#include "guts.h"

#define NSTEPS 512
#define SCALESTEP 1.011

extern GC fall_gc, erase_gc;

XPoint fullArea[] = {
	0, TOPY,
	MAXX, TOPY,
	MAXX, MAXY,
	0, MAXY
};

XPoint bigCircle[] = {
	600, 0,
	408, 306,
	0, 450,
	-408, 306,
	-600, 0,
	-408, -306,
	0, -450,
	408, -306
};

#define circleSize (sizeof bigCircle / sizeof(XPoint))

XPoint drawCircle[circleSize];

typedef struct {
	XPoint points[18];
	int npoints;
} Letter;

Letter letter[] = {
	{{
		{268, 168},
		{340, 168},
		{340, 192},
		{316, 192},
		{316, 288},
		{292, 288},
		{292, 192},
		{268, 192},
	}, 8},
	{{
		{364, 168},
		{388, 168},
		{388, 216},
		{412, 216},
		{412, 168},
		{436, 168},
		{436, 288},
		{412, 288},
		{412, 240},
		{388, 240},
		{388, 288},
		{364, 288},
	}, 12},
	{{
		{460, 168},
		{532, 168},
		{532, 192},
		{484, 192},
		{484, 216},
		{508, 216},
		{508, 240},
		{484, 240},
		{484, 264},
		{532, 264},
		{532, 288},
		{460, 288},
	}, 12},
	{{
		{268, 312},
		{340, 312},
		{340, 336},
		{292, 336},
		{292, 360},
		{316, 360},
		{316, 384},
		{292, 384},
		{292, 408},
		{340, 408},
		{340, 432},
		{268, 432},
	}, 12},
	{{
		{364, 312},
		{388, 312},
		{412, 372},
		{412, 312},
		{436, 312},
		{436, 432},
		{412, 432},
		{388, 372},
		{388, 432},
		{364, 432},
	}, 10},
	{{
		{460, 312},
		{496, 312},
		{503, 313},
		{511, 317},
		{517, 323},
		{523, 332},
		{527, 342},
		{530, 353},
		{532, 366},
		{532, 378},
		{530, 391},
		{527, 402},
		{523, 412},
		{517, 421},
		{511, 427},
		{503, 431},
		{496, 432},
		{460, 432}
	}, 18}
};

#define nLetters (sizeof letter / sizeof(Letter))

XPoint insideD[] = {
	{484, 336},
	{496, 336},
	{500, 338},
	{504, 344},
	{506, 354},
	{508, 366},
	{508, 378},
	{506, 390},
	{504, 400},
	{500, 406},
	{496, 408},
	{484, 408}
};

extern int CheckingSleep(long);

the_end()
{
	Region to_clip, lr, nr;
	int i, j;
	double scale;
	XEvent ev;
	char key;

	XFillRectangle(display, win, erase_gc, 0, TOPY, MAXX, BOTTOMY - TOPY + 1);
	to_clip = XPolygonRegion(fullArea, 4, EvenOddRule);
	for (i = 0; i < nLetters; i++) {
		lr = XPolygonRegion(letter[i].points, letter[i].npoints, EvenOddRule);
		nr = XCreateRegion();
		XXorRegion(to_clip, lr, nr);
		XDestroyRegion(lr);
		XDestroyRegion(to_clip);
		to_clip = nr;
	}
	lr = XPolygonRegion(insideD, sizeof insideD / sizeof(XPoint), EvenOddRule);
	nr = XCreateRegion();
	XUnionRegion(to_clip, lr, nr);
	XDestroyRegion(lr);
	XDestroyRegion(to_clip);
	to_clip = nr;

	XSetRegion(display, fall_gc, to_clip);
	XSetForeground(display, fall_gc, colors[RED]);

	scale = 1.0;
	for (i = 0; i < NSTEPS; i++)
		scale /= SCALESTEP;

	for (i = 0; i < NSTEPS; i++) {
		for (j = 0; j < circleSize; j++) {
			drawCircle[j].x = bigCircle[j].x * scale + (MAXX / 2);
			drawCircle[j].y = bigCircle[j].y * scale + ((MAXY + TOPY) / 2);
		}
		scale *= SCALESTEP;
		XFillPolygon(display, win, fall_gc, drawCircle, circleSize,
			Convex, CoordModeOrigin);
		XFlush(display);
	}
	XSetClipMask(display, fall_gc, None);
	XDestroyRegion(to_clip);
	XSync(display, True);
	sleep(1);
}
