/*****
 ** ** Module Header ******************************************************* **
 ** 									     **
 **   Modules Revision 3.0						     **
 **   Providing a flexible user environment				     **
 ** 									     **
 **   File:		ModuleCmd_List.c				     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Authors:	John Furlani, John.Furlani"@Eng.Sun.COM			     **
 **		Jens Hamisch, Jens.Hamisch"@Strawberry.COM		     **
 ** 									     **
 **   Description:	Lists the currently loaded modulefiles.		     **
 ** 									     **
 **   Exports:		ModuleCmd_List					     **
 ** 									     **
 **   Notes:								     **
 ** 									     **
 ** ************************************************************************ **
 ****/

/** ** Copyright *********************************************************** **/
/** 									     **/
/** Copyright 1991-1994 by John L. Furlani.  All rights reserved.	     **/
/**									     **/
/** Redistribution and use in source and binary forms are permitted	     **/
/** provided that this entire copyright notice is duplicated in all such     **/
/** copies, and that any documentation, announcements, and other	     **/
/** materials related to such distribution and use acknowledge that the	     **/
/** software was originally developed by John Furlani. No charge, other than **/
/** an "at-cost" distribution fee, may be charged for copies, derivations,   **/
/** or distributions of this material without the express written 	     **/
/** consent of the copyright holder.  The name of the author may not	     **/
/** be used to endorse or promote products derived from this material 	     **/
/** without specific prior written permission.				     **/
/**									     **/
/** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED   **/
/** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF     **/
/** MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE. IN NO EVENT SHALL**/
/** THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,	     **/
/** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES.		     **/
/** 									     **/
/** ************************************************************************ **/

static char Id[] = "@(#)$Id: ModuleCmd_List.c,v 1.7 2000/04/07 16:20:23 rk Exp $";
static void *UseId[] = { &UseId, Id };

/** ************************************************************************ **/
/** 				      HEADERS				     **/
/** ************************************************************************ **/

#include "modules_def.h"

/** ************************************************************************ **/
/** 				  LOCAL DATATYPES			     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				     CONSTANTS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/**				      MACROS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				    LOCAL DATA				     **/
/** ************************************************************************ **/

#if WITH_DEBUGGING_MODULECMD
static	char	module_name[] = "ModuleCmd_List.c";	/** File name of this module **/
static	char	_proc_ModuleCmd_List[] = "ModuleCmd_List";
#endif

/** ************************************************************************ **/
/**				    PROTOTYPES				     **/
/** ************************************************************************ **/

/** not applicable **/


/*++++
 ** ** Function-Header ***************************************************** **
 ** 									     **
 **   Function:		ModuleCmd_List					     **
 ** 									     **
 **   Description:	Execution of the module-command 'list'		     **
 **			Lists all modules stored in the environment variable **
 **			'LOADEDMODULES'					     **
 ** 									     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Parameters:	Tcl_Interp	*interp		Attached Tcl Interp. **
 **			int		 argc		Number of args	     **
 **			char 		*argv[]		Argument list	     **
 ** 									     **
 **   Result:		int	TCL_ERROR	Failure			     **
 **				TCL_OK		Successfull operation	     **
 ** 									     **
 **   Attached Globals:							     **
 ** 									     **
 ** ************************************************************************ **
 ++++*/

int	ModuleCmd_List(	Tcl_Interp	*interp,
			int		 argc,
                   	char		*argv[])
{
    /**
     **  Get the list of loaded modules at first
     **/

    char	*loaded, *lmfiles;
    int		 i, count;
    char	*list[ MOD_BUFSIZE];
    char	*files[ MOD_BUFSIZE];
    char	*tmplist[ MOD_BUFSIZE], *s;
    int	  	 len;

#if WITH_DEBUGGING_MODULECMD
    ErrorLogger( NO_ERR_START, LOC, _proc_ModuleCmd_List, NULL);
#endif

    lmfiles = getLMFILES( interp);
    loaded = getenv( "LOADEDMODULES");
    
    if( !loaded || !*loaded) {
	if( sw_format & (SW_TERSE | SW_LONG | SW_HUMAN) )
	    fprintf(stderr, "No Modulefiles Currently Loaded.\n");
    } else {

	/**
	 **  Now tokenize it, form a list and print it out.
	 **/

	if( sw_format & SW_LONG ) {
	    fprintf( stderr, long_header);
	}
	if( sw_format & (SW_TERSE | SW_LONG | SW_HUMAN) )
	    fprintf( stderr, "Currently Loaded Modulefiles:\n");

	/**
	 **  LOADEDMODULES and _LMFILES_ should provide a list of loaded
	 **  modules and assigned files in the SAME ORDER
	 **/

	count = 1;
        for( list[ 0] = strtok( loaded, ":");
	     list[ count] = strtok( NULL, ":");
	     count++ );

	count = 1;
        for( files[ 0] = strtok( lmfiles, ":");
	     files[ count] = strtok( NULL, ":");
	     count++ );

	/**
	 **  We have to build a single list of files for each loaded entry
	 **  in order to be able to figure out the length of the directory
	 **  part
	 **/

	for( i=0; i<count; i++) {

	    len = strlen( files[i]) - strlen( list[i]);
	    tmplist[i] = files[i];

	    /**
	     **  We have to source all relevant .modulerc and .version files
	     **  on the path
	     **/

	    s = files[i] + len;
	    while( s) {
		if( s = strchr( s, '/'))
		    *s = '\0';

		SourceRC( interp, files[i], modulerc_file);
		SourceVers( interp, files[i], list[i]);

		if( s)
		    *s++ = '/';
	    }

	    /** 
	     **  Print this guy
	     **/
	}
	print_aligned_files( interp, NULL, NULL, tmplist, count, 1);
    }

    /**
     **  Return on success
     **/

#if WITH_DEBUGGING_MODULECMD
    ErrorLogger( NO_ERR_END, LOC, _proc_ModuleCmd_List, NULL);
#endif

    return( TCL_OK);

} /** End of 'ModuleCmd_List' **/
