/*****
 ** ** Module Header ******************************************************* **
 ** 									     **
 **   Modules Revision 3.0						     **
 **   Providing a flexible user environment				     **
 ** 									     **
 **   File:		ModuleCmd_Purge.c				     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Authors:	John Furlani, John.Furlani"@Eng.Sun.COM			     **
 **		Jens Hamisch, Jens.Hamisch"@Strawberry.COM		     **
 ** 									     **
 **   Description:	Removes all loaded modulefiles from the environment. **
 ** 									     **
 **   Exports:		ModuleCmd_Purge					     **
 ** 									     **
 **   Notes:								     **
 ** 									     **
 ** ************************************************************************ **
 ****/

/** ** Copyright *********************************************************** **/
/** 									     **/
/** Copyright 1991-1994 by John L. Furlani.  All rights reserved.	     **/
/**									     **/
/** Redistribution and use in source and binary forms are permitted	     **/
/** provided that this entire copyright notice is duplicated in all such     **/
/** copies, and that any documentation, announcements, and other	     **/
/** materials related to such distribution and use acknowledge that the	     **/
/** software was originally developed by John Furlani. No charge, other than **/
/** an "at-cost" distribution fee, may be charged for copies, derivations,   **/
/** or distributions of this material without the express written 	     **/
/** consent of the copyright holder.  The name of the author may not	     **/
/** be used to endorse or promote products derived from this material 	     **/
/** without specific prior written permission.				     **/
/**									     **/
/** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED   **/
/** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF     **/
/** MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE. IN NO EVENT SHALL**/
/** THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,	     **/
/** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES.		     **/
/** 									     **/
/** ************************************************************************ **/

static char Id[] = "@(#)$Id: ModuleCmd_Purge.c,v 1.4 2000/04/07 16:20:23 rk Exp $";
static void *UseId[] = { &UseId, Id };

/** ************************************************************************ **/
/** 				      HEADERS				     **/
/** ************************************************************************ **/

#include "modules_def.h"

/** ************************************************************************ **/
/** 				  LOCAL DATATYPES			     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				     CONSTANTS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/**				      MACROS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				    LOCAL DATA				     **/
/** ************************************************************************ **/

static	char	module_name[] = "ModuleCmd_Purge.c";	/** File name of this module **/

/** ************************************************************************ **/
/**				    PROTOTYPES				     **/
/** ************************************************************************ **/

/** not applicable **/


/*++++
 ** ** Function-Header ***************************************************** **
 ** 									     **
 **   Function:		ModuleCmd_Purge					     **
 ** 									     **
 **   Description:	Execution of the module-command 'purge'		     **
 ** 									     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Parameters:	Tcl_Interp	*interp		Attached Tcl Interp. **
 **			int		 argc		Number of arguments  **
 **			char 		*argv[]		Argument list	     **
 ** 									     **
 **   Result:		int	TCL_ERROR	Failure			     **
 **				TCL_OK		Successfull operation	     **
 ** 									     **
 **   Attached Globals:							     **
 ** 									     **
 ** ************************************************************************ **
 ++++*/

int	ModuleCmd_Purge(	Tcl_Interp	*interp,
                		int		 argc,
                		char		*argv[])
{
    char	*lmodules = NULL,
		*cur_module = NULL,
		*loaded_modules,
		*unload_argv[ MOD_BUFSIZE];
    int		 unload_argc = 0,
    		 status;

#if WITH_DEBUGGING_MODULECMD
    fprintf( stderr, "ModuleCmd_Purge(%d):DEBUG: Starting\n", __LINE__);
#endif

    /**
     **  Get the list of currently loaded modules from the environment variable
     **  LOADEDMODULES
     **/

    if( NULL == (loaded_modules = Tcl_GetVar2( interp, "env", "LOADEDMODULES",
	TCL_GLOBAL_ONLY))) {
	if( OK != ErrorLogger( ERR_MODULE_PATH, LOC, NULL))
	    return( TCL_ERROR);		/** -------- EXIT (FAILURE) --------> **/
	else
	    return( TCL_OK);		/** ---- EXIT (Nothing to list) ----> **/
    }

    if( NULL == (lmodules = strdup( loaded_modules))) 
	if( OK != ErrorLogger( ERR_ALLOC, LOC, NULL))
	    return( TCL_ERROR);		/** -------- EXIT (FAILURE) --------> **/

    /**
     **  Build a NULL terminated list of loaded modules
     **/

    for( cur_module = strtok( lmodules, ":");
         cur_module && unload_argc < MOD_BUFSIZE-1;
         cur_module = strtok( NULL, ":"))
        unload_argv[ unload_argc++] = cur_module;
    
    unload_argv[ unload_argc] = NULL;
    
    /**
     **  Unload 'em all
     **  We always say the load succeeded.  ModuleCmd_Load will
     **  output any necessary error messages.
     **/

    ModuleCmd_Load( interp, 0, unload_argc, unload_argv);
    status = TCL_OK;

    /**
     **  Free, what has been allocated and pass the load's result to the caller
     **/

    free( lmodules);

#if WITH_DEBUGGING_MODULECMD
    fprintf( stderr, "ModuleCmd_Purge(%d):DEBUG: End\n", __LINE__);
#endif

    return( status);

} /** End of 'ModuleCmd_Purge' **/
