/*****
 ** ** Module Header ******************************************************* **
 ** 									     **
 **   Modules Revision 3.0						     **
 **   Providing a flexible user environment				     **
 ** 									     **
 **   File:		cmdAlias.c					     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Authors:	John Furlani, John.Furlani"@Eng.Sun.COM			     **
 **		Jens Hamisch, Jens.Hamisch"@Strawberry.COM		     **
 ** 									     **
 **   Description:	The Tcl set-alias command			     **
 ** 									     **
 **   Exports:		cmdSetAlias					     **
 ** 									     **
 **   Notes:								     **
 ** 									     **
 ** ************************************************************************ **
 ****/

/** ** Copyright *********************************************************** **/
/** 									     **/
/** Copyright 1991-1994 by John L. Furlani.  All rights reserved.	     **/
/**									     **/
/** Redistribution and use in source and binary forms are permitted	     **/
/** provided that this entire copyright notice is duplicated in all such     **/
/** copies, and that any documentation, announcements, and other	     **/
/** materials related to such distribution and use acknowledge that the	     **/
/** software was originally developed by John Furlani. No charge, other than **/
/** an "at-cost" distribution fee, may be charged for copies, derivations,   **/
/** or distributions of this material without the express written 	     **/
/** consent of the copyright holder.  The name of the author may not	     **/
/** be used to endorse or promote products derived from this material 	     **/
/** without specific prior written permission.				     **/
/**									     **/
/** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED   **/
/** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF     **/
/** MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE. IN NO EVENT SHALL**/
/** THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,	     **/
/** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES.		     **/
/** 									     **/
/** ************************************************************************ **/

static char Id[] = "@(#)$Id: cmdAlias.c,v 1.5 2000/04/07 16:20:23 rk Exp $";
static void *UseId[] = { &UseId, Id };

/** ************************************************************************ **/
/** 				      HEADERS				     **/
/** ************************************************************************ **/

#include "modules_def.h"

/** ************************************************************************ **/
/** 				  LOCAL DATATYPES			     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				     CONSTANTS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/**				      MACROS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				    LOCAL DATA				     **/
/** ************************************************************************ **/

static	char	module_name[] = "cmdAlias.c";	/** File name of this module **/
#if WITH_DEBUGGING_CALLBACK
static	char	_proc_cmdSetAlias[] = "cmdSetAlias";
#endif

/** ************************************************************************ **/
/**				    PROTOTYPES				     **/
/** ************************************************************************ **/

/** not applicable **/


/*++++
 ** ** Function-Header ***************************************************** **
 ** 									     **
 **   Function:		cmdSetAlias					     **
 ** 									     **
 **   Description:	Callback function for (re)setting aliases	     **
 ** 									     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Parameters:	ClientData	 client_data			     **
 **			Tcl_Interp	*interp		According Tcl interp.**
 **			int		 argc		Number of arguments  **
 **			char		*argv[]		Argument array	     **
 ** 									     **
 **   Result:		int	TCL_OK		Successfull completion	     **
 **				TCL_ERROR	Any error		     **
 ** 									     **
 **   Attached Globals:	flags		These are set up accordingly before  **
 **					this function is called in order to  **
 **					control everything		     **
 ** 									     **
 ** ************************************************************************ **
 ++++*/

int cmdSetAlias( ClientData	 client_data,
	  	 Tcl_Interp	*interp,
	  	 int 		 argc,
	  	 char		*argv[])
{

#if WITH_DEBUGGING_CALLBACK
    ErrorLogger( NO_ERR_START, LOC, _proc_cmdSetAlias, NULL);
#endif

    /**
     **  Whatis mode?
     **/

    if( flags & (M_WHATIS | M_HELP)) 
        return( TCL_OK);		/** ------- EXIT PROCEDURE -------> **/
	
    /**
     **  Parameter check. Valid commands are:
     **
     **     unset-alias <alias>
     **     set-alias <alias> <value>
     **/

    if( (!strncmp( argv[0], "un", 2) && (argc != 2)) ||
        (!strncmp( argv[0], "set", 3) && (argc != 3))) {
	if( OK != ErrorLogger( ERR_USAGE, LOC, argv[0], "variable", NULL))
	    return( TCL_ERROR);		/** -------- EXIT (FAILURE) -------> **/
    }

    /**
     **  Display only mode?
     **/

    if( flags & M_DISPLAY) {
	fprintf( stderr, "%s\t ", argv[ 0]);
	while( --argc)
	    fprintf( stderr, "%s ", *++argv);
	fprintf( stderr, "\n");
        return( TCL_OK);		/** ------- EXIT PROCEDURE -------> **/
    }

    /**
     **  Switch command
     **/

    if( flags & M_SWSTATE1) {
        set_marked_entry( markAliasHashTable, argv[1], M_SWSTATE1);
        return( TCL_OK);		/** ------- EXIT PROCEDURE -------> **/
    } else if( flags & M_SWSTATE2) {
        set_marked_entry( markAliasHashTable, argv[1], M_SWSTATE2);
    } else if( flags & M_SWSTATE3) {
        int marked_val;
        if( marked_val = chk_marked_entry( markAliasHashTable, argv[1])) {
            if( marked_val == M_SWSTATE1)
                store_hash_value( aliasUnsetHashTable, argv[1], argv[2]);
            else
		return( TCL_OK);	/** ------- EXIT PROCEDURE -------> **/
      }
    } else if( flags & M_REMOVE) {
        store_hash_value( aliasUnsetHashTable, argv[1], argv[2]);
    }

    /**
     **  Finally remove or set the alias
     **/

    if( *argv[0] == 'u' || (flags & M_REMOVE))
        store_hash_value( aliasUnsetHashTable, argv[1], argv[2]);
    else
        store_hash_value( aliasSetHashTable, argv[1], argv[2]);
  
#if WITH_DEBUGGING_CALLBACK
    ErrorLogger( NO_ERR_END, LOC, _proc_cmdSetAlias, NULL);
#endif

    return( TCL_OK);

} /** End of 'cmdSetAlias' **/
