/*****
 ** ** Module Header ******************************************************* **
 ** 									     **
 **   Modules Revision 3.0						     **
 **   Providing a flexible user environment				     **
 ** 									     **
 **   File:		cmdUlvl.c					     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Authors:	Jens Hamisch, Jens.Hamisch"@Strawberry.COM		     **
 ** 									     **
 **   Description:	The Tcl module-user routine which changes the cur-   **
 **			rent user level					     **
 ** 									     **
 **   Exports:		cmdModuleUser					     **
 ** 									     **
 **   Notes:								     **
 ** 									     **
 ** ************************************************************************ **
 ****/

/** ** Copyright *********************************************************** **/
/** 									     **/
/** Copyright 1991-1994 by John L. Furlani.  All rights reserved.	     **/
/**									     **/
/** Redistribution and use in source and binary forms are permitted	     **/
/** provided that this entire copyright notice is duplicated in all such     **/
/** copies, and that any documentation, announcements, and other	     **/
/** materials related to such distribution and use acknowledge that the	     **/
/** software was originally developed by John Furlani. No charge, other than **/
/** an "at-cost" distribution fee, may be charged for copies, derivations,   **/
/** or distributions of this material without the express written 	     **/
/** consent of the copyright holder.  The name of the author may not	     **/
/** be used to endorse or promote products derived from this material 	     **/
/** without specific prior written permission.				     **/
/**									     **/
/** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED   **/
/** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF     **/
/** MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE. IN NO EVENT SHALL**/
/** THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,	     **/
/** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES.		     **/
/** 									     **/
/** ************************************************************************ **/

static char Id[] = "@(#)$Id: cmdUlvl.c,v 1.4 2000/04/07 16:20:23 rk Exp $";
static void *UseId[] = { &UseId, Id };

/** ************************************************************************ **/
/** 				      HEADERS				     **/
/** ************************************************************************ **/

#include "modules_def.h"

/** ************************************************************************ **/
/** 				  LOCAL DATATYPES			     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				     CONSTANTS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/**				      MACROS				     **/
/** ************************************************************************ **/

/** not applicable **/

/** ************************************************************************ **/
/** 				    LOCAL DATA				     **/
/** ************************************************************************ **/

static	char	module_name[] = "cmdUlvl.c";	/** File name of this module **/
#if WITH_DEBUGGING_CALLBACK
static	char	_proc_cmdModuleUser[] = "cmdModuleUser";
#endif
#if WITH_DEBUGGING_CALLBACK_1
static	char	_proc_cmdModuleUser_sub[] = "cmdModuleUser_sub";
#endif

/**
 **  names for the user level
 **/

static	char	_str_ul_novice[] = "novice";
static	char	_str_ul_advanced[] = "advanced";
static	char	_str_ul_expert[] = "expert";

/** ************************************************************************ **/
/**				    PROTOTYPES				     **/
/** ************************************************************************ **/

/** not applicable **/


/*++++
 ** ** Function-Header ***************************************************** **
 ** 									     **
 **   Function:		cmdModuleUser					     **
 ** 									     **
 **   Description:	Callback function for 'info'			     **
 ** 									     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Parameters:	ClientData	 client_data			     **
 **			Tcl_Interp	*interp		According Tcl interp.**
 **			int		 argc		Number of arguments  **
 **			char		*argv[]		Argument array	     **
 ** 									     **
 **   Result:		int	TCL_OK		Successfull completion	     **
 **				TCL_ERROR	Any error		     **
 ** 									     **
 **   Attached Globals:	flags		These are set up accordingly before  **
 **					this function is called in order to  **
 **					control everything		     **
 ** 									     **
 ** ************************************************************************ **
 ++++*/

int	cmdModuleUser(	ClientData	 client_data,
	      		Tcl_Interp	*interp,
	      		int		 argc,
	      		char		*argv[])
{

#if WITH_DEBUGGING_CALLBACK
    ErrorLogger( NO_ERR_START, LOC, _proc_cmdModuleUser, NULL);
#endif

    /**
     **  Whatis mode?
     **/

    if( flags & (M_WHATIS | M_HELP))
        return( TCL_OK);		/** ------- EXIT PROCEDURE -------> **/
	
    /**
     **  Parameter check
     **/

    if( argc < 2) {
	if( OK != ErrorLogger( ERR_USAGE, LOC, argv[0], "level ", NULL))
	    return( TCL_ERROR);		/** -------- EXIT (FAILURE) -------> **/
    }
  
    /**
     **  Display mode?
     **/

    if( flags & M_DISPLAY) {
	fprintf( stderr, "%s\t ", argv[ 0]);
	while( --argc)
	    fprintf( stderr, "%s ", *++argv);
	fprintf( stderr, "\n");
        return( TCL_OK);		/** ------- EXIT PROCEDURE -------> **/
    }
	
    /**
     **  Change the user level
     **/

    return( cmdModuleUser_sub( argv[ 1]));

} /** End of 'cmdModuleUser' **/
    

/*++++
 ** ** Function-Header ***************************************************** **
 ** 									     **
 **   Function:		cmdModuleUser_sub				     **
 ** 									     **
 **   Description:	Check the user level passed as argument and set up   **
 **			the global user level flag			     **
 ** 									     **
 **   First Edition:	91/10/23					     **
 ** 									     **
 **   Parameters:	char	*user_level	User level string to be chk. **
 ** 									     **
 **   Result:		int	TCL_OK		Successfull completion	     **
 **				TCL_ERROR	Any error		     **
 ** 									     **
 **   Attached Globals:	sw_userlvl	Contains the binary coded userlevel  **
 ** 									     **
 ** ************************************************************************ **
 ++++*/

int	cmdModuleUser_sub(	char	*user_level)
{
    char *s;
    int len_arg;

#if WITH_DEBUGGING_CALLBACK_1
    ErrorLogger( NO_ERR_START, LOC, _proc_cmdModuleUser_sub, NULL);
#endif

    len_arg = strlen( user_level);
    s = user_level;
    while( s && *s)
	*s++ = tolower( *s);

    if( !strncmp( user_level, _str_ul_novice, len_arg)) {
	sw_userlvl = UL_NOVICE;
    } else if( !strncmp( user_level, _str_ul_advanced, len_arg)) {
	sw_userlvl = UL_ADVANCED;
    } else if( !strncmp( user_level, _str_ul_expert, len_arg)) {
	sw_userlvl = UL_EXPERT;
    } else {
	if( OK != ErrorLogger( ERR_USERLVL, LOC, user_level, NULL))
	    return( TCL_ERROR);			/** ---- EXIT (FAILURE) ---> **/
    }

    /**
     **  Success
     **/

#if WITH_DEBUGGING_CALLBACK_1
    ErrorLogger( NO_ERR_END, LOC, _proc_cmdModuleUser_sub, NULL);
#endif

    return( TCL_OK);

} /** End of 'cmdModuleUser_sub' **/
