/***************************************************************************
                                 choice.h
                             -------------------
    begin                : Sat Apr 13 2002
    copyright            : (C) 2002 by Catalin Avram
    email                : catalin_avram@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 float **needmatrix(int r, int c);

 void Choice()
 {
  char choice;
  matrix m;
  menu Menu;

   choice = Menu.Main();

   switch(choice)
   {

    /*************   Generate Random Matrix ***********************/
    case '1':   //generate random matrix
    {

      int r, c, max = 0;
      float **theMatrix;
      cout << "\nEnter row size: ";
      cin >> r;
      cout << "\nEnter column size: ";
      cin >> c;
      cout << "\nEnter maximum value: ";
      cin >> max;

      cout << "\nGenerating matrix...";
      theMatrix = m.random(r, c, max);
      cout << "...done" << endl;

      cout << "\nYour matrix is: " << endl;
      m.output_matrix(theMatrix, r, c);   //output the random matrix

      cout << endl;

      char ch = Menu.Result(); //go to the result menu

      switch(ch)
      {
        case '1':  //save result to ram
        {
         cout << "This function is not supported yet..." << endl;
         delete[] theMatrix;
         Choice();
         break;
        }

        case '2': //return to main menu without saving
        {
         delete[] theMatrix;
         Choice();
         break;
        }
      }
      break;

    }

    /******************************************************************/

    /***************    Calculate Determinant *************************/

    case '2':   //calculate determinant
    {
      char ch = Menu.Pre_mat();

      switch(ch)
      {
        case '1':
        {
          //recall matrix
          //calculate determinant
          //output determinant

          cout << "This function is not supported yet...";
          Choice();
          break;
        }

        case '2':   //input matrix
        {
          float **matrix;
          float d = 0;
          int size= 0;

          cout << "\nEnter size of matrix: ";
          cin >> size;

          matrix = m.input_matrix(size, size);

          d = m.det(matrix, size);            //caluclate determinant

          cout << "\nThe determinant is: " << d << endl;  //output determinant

          char ch = Menu.Result();

          switch(ch)
          {
            case '1':
            {
              //save result to ram
              cout << "Function not supported yet..." << endl;
              break;
            }

            case '2':   //return to the main menu
            {
              delete[] matrix;
              Choice();
              break;
            }
          }
          break;
        }

        case '3':   //random matrix
        {

          float **matrix;
          float d = 0;
          int size, max = 0;

          cout << "\nEnter the size of the matrix: ";
          cin >> size;
          cout << "Enter the maximum value allowed: ";
          cin >>max;

          matrix = m.random(size, size, max); //generating random matrix

          cout << "The generated matrix is: " << endl;

          m.output_matrix(matrix, size, size);

          d = m.det(matrix, size); //calculating the determinant

          cout << "The determinant is: " << d << endl;

          char ch = Menu.Result();

          switch(ch)
          {
            case '1':
            {
              cout << "This function is not supported yet..." << endl;
              Choice();
              break;
            }

            case '2':  //return to the main menu
            {
              Choice();
              break;
            }
          }
          break;
        }

        case '4': //main menu
        {
          Choice();
          break;
        }
      }
      break;
    }


    /****************************************************************/


    /****************     Multiply two matrices *********************/
    case '3':
    {
      //multiply 2 matrices
      float **left_matrix;
      float **right_matrix;
      float **result_matrix;

      int r, c = 0; //for the left matrix
      int t, s = 0; //for the right matrix


      cout << "\nFor the LEFT matrix: " << endl;
      cout << "\nEnter the row size: ";
      cin >> r;
      cout << "Enter the column size: ";
      cin >> c;
      left_matrix = needmatrix(r, c);
      cout << "\nYour LEFT matrix is: " << endl;
      m.output_matrix(left_matrix, r, c);

      cout << "\nFor the RIGHT matrix: " << endl;
      cout << "\nEnter the row size: ";
      cin >> t;
      cout << "Enter the column size: ";
      cin >> s;
      right_matrix = needmatrix(t, s);
      cout << "\nYour RIGHT matrix is: " << endl;
      m.output_matrix(right_matrix, t, s);

      result_matrix = m.multiplied(left_matrix, r, c, right_matrix, t, s);

      cout << "\nYour result matrix is: " << endl;
      m.output_matrix(result_matrix, r, s);

      cout << "\nFor the resulting matrix, do you want to: " << endl;
      char ch = Menu.Result();

      switch(ch)
      {
        case '1':  //save result to ram
        {
          cout << "This function is not supported yet..." << endl;
          Choice();
          break;
        }

        case '2':  //return to main menu && clear memory
        {
          delete[] result_matrix;
          delete[] left_matrix;
          delete[] right_matrix;
          Choice();
          break;
        }
      }

      break;
     }

    /****************************************************************/



    /***************  Add/Substract 2 matrices  *********************/
    case '4':  //add/substract 2 matrices
    {
      float **left_matrix;
      float **right_matrix;
      float **result_matrix;

      int r, c = 0;
      char temp;

      cout << "\nEnter the size of the rows: ";
      cin >> r;
      cout << "Enter the size of the colums: ";
      cin >> c;

      left_matrix = needmatrix(r, c);
      cout << "\nYour LEFT matrix is: " << endl;
      m.output_matrix(left_matrix, r, c);


      right_matrix = needmatrix(r, c);
      cout << "\nYour RIGHT matrix is: " << endl;
      m.output_matrix(right_matrix, r, c);

      temp = Menu.add_sub();


      switch(temp)
      {
        case '1':
        {
          result_matrix = m.add_sub(left_matrix, right_matrix, r, c, 0); // 0 to add
          break;                                                         // 1 to substract
        }
        case '2':
        {
          result_matrix = m.add_sub(left_matrix, right_matrix, r, c, 1); // 0 to add
          break;                                                         // 1 to substract
        }
        case '3':
        {
          delete[] left_matrix;
          delete[] right_matrix;
          Choice();
          break;
        }
      }

        cout << "\nYour result matrix is: " << endl;
        m.output_matrix(result_matrix, r, c);

        cout << "\nFor the resulting matrix, do you want to: " << endl;

        char ch = Menu.Result();

        switch(ch)
        {
          case '1':
          {
            cout << "Function not supported yet...";
            Choice();
            break;
          }
          case '2':
          {
            delete[] left_matrix;
            delete[] right_matrix;
            delete[] result_matrix;
            Choice();
            break;
          }
        }

      break;
    }
    /****************************************************************/

    /***************  Input Matrix    *******************************/
    case '5':   //input matrix
    {
      int r, c;
      float **matrix;

      cout << "\nEnter the row size: ";
      cin >> r;

      cout << "Enter the column size: ";
      cin >> c;

      matrix = m.input_matrix(r, c);

      cout << "\nYour inputed matrix is: " << endl;
      m.output_matrix(matrix, r, c);

      char ch = Menu.Result();

      switch(ch)
      {
        case '1':
        {
          cout << "This function is not supported yet..." << endl;
          delete[] matrix;
          Choice();
          break;
        }
        case '2':
        {
          delete[] matrix;
          Choice();
          break;
        }
      }

      break;
    }

    /********************************************************************/


    /******************   Inverse of a matrix ***************************/
    case '6':  //inverse of a matrix
    {
      int size = 0;
      float **matrix;
      float **inv;

      cout << "\nEnter the size of the matrix: ";
      cin >> size;

      matrix = needmatrix(size, size);
      inv = m.inverse(matrix, size);

      cout << "\nThe initial matrix is: " << endl;
      m.output_matrix(matrix, size, size);

      cout << "\nThe inverse of the matrix is: " << endl;
      m.output_matrix(inv, size, size);

      char ch = Menu.Result();

      switch(ch)
      {
        case '1':
        {
          cout << "\nThis function is not supported yet..." << endl;
          delete[] matrix;
          delete[] inv;
          Choice();
          break;
        }

        case '2':
        {
          delete[] matrix;
          delete[] inv;
          Choice();
          break;
        }
      }

      break;
    }
    /*******************************************************************/



    /****************   Adjoint of a matrix ****************************/
    case '7':  //adjoint of a matrix
    {
      int size = 0;
      float **matrix;
      float **adj;

      cout << "\nEnter the size of the matrix: ";
      cin >> size;

      matrix = needmatrix(size, size);

      cout << "\nThe initial matrix is: " << endl;
      m.output_matrix(matrix, size, size);

      adj = m.adjoint(matrix, size);

      cout << "\nThe adjoint matrix is: " << endl;
      m.output_matrix(adj, size, size);

      char ch = Menu.Result();

      switch(ch)
      {
        case '1': //save to ram
        {
          cout << "This function is not supported yet...";
          delete[] matrix;
          delete[] adj;
          Choice();
          break;
        }

        case '2': //main menu
        {
          delete[] matrix;
          delete[] adj;
          Choice();
          break;
        }
      }
      break;
    }
    /********************************************************************/


    /*************  Transpose of a matrix   *****************************/
    case '8':  //transpose of a matrix
    {
      float **matrix;
      float **transposed;
      int r, c = 0;

      cout << "\nEnter the row size: ";
      cin >> r;

      cout << "Enter the colum size: ";
      cin >> c;

      matrix = needmatrix(r, c);

      transposed = m.transposed(matrix, r, c);

      cout << "\nYour original matrix is: " << endl;
      m.output_matrix(matrix, r, c);

      cout << "\nYour transposed matrix is: " << endl;
      m.output_matrix(transposed, r, c);

      char ch = Menu.Result();

      switch (ch)
      {
        case '1':  //save to ram
        {
          cout << "This function is not supported yet..." << endl;

          delete[] matrix;
          delete[] transposed;
          Choice();
          break;
        }

        case '2':    //main menu
        {
          delete[] matrix;
          delete[] transposed;
          Choice();
          break;
        }
      }


      break;
    }

    /*****************************************************************************/

    case '9':   //exit
    {
      cout << "2002 (c) to Catalin Avram.  Please report any bugs to catalin_avram@hotmail.com Thanx!" << endl;
      break;
    }
   }

 }
/***********************************************************************************/
 float **needmatrix(int r, int c)
 {
  matrix m;
  menu Menu;
  char ch = Menu.Pre_mat();
  int max = 0;
  float **matrix;

      switch(ch)
      {
        case '1': //recall matrix;
        {
          cout << "This function is not supported yet...generating random matrix instead" << endl;

          matrix = m.random(3, 3, 20);

          return(matrix);

          break;
        }

        case '2': //input matrix
        {


          matrix = m.input_matrix(r, c);

          return(matrix);

          break;
        }

        case '3':  //random matrix
        {

          cout << "Enter maximum value: ";
          cin >> max;

          matrix = m.random(r, c, max);
          return(matrix);

        }

        case '4':  //return to main menu
        {
          Choice();
          return NULL;
          break;
        }

    }
    return NULL;
 }
