/*
 *  extract_mpeg2.c
 *
 *  Copyright (C) Aaron Holtzman <aholtzma@ess.engr.uvic.ca> - Nov 1999
 *
 *  Extracts an MPEG-2 video stream from an MPEG-2 system stream
 *  and writes it to stdout
 *
 *  Ideas and bitstream syntax info borrowed from code written 
 *  by Nathan Laredo <laredo@gnu.org>
 *
 *  This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *	
 *  mpeg2dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  mpeg2dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/mman.h>

#define BUFSIZE 512 /* needs to be as big as biggest header */

static int input_file;
static unsigned char buf[BUFSIZE];
static unsigned char *cur_pos;
static unsigned char *end_pos;

void file_init(char file_name[])
{
	if(file_name[0] == '-' && file_name[1] == '\0')
	{
	   input_file = STDIN_FILENO;
	}
	else if ((input_file = open(file_name, O_RDONLY)) < 0)
	{
		fprintf(stderr,"File not found\n");
		exit(1);
	}
	cur_pos = buf;
	end_pos = buf;
}

unsigned char sector[2048];

int parse_sector(void)
{
	int bytes_read;
	int header_length;

  bytes_read = read(input_file, sector, 2048); 

	if(bytes_read != 2048)
		return 0;

	if (sector[0x00] || sector[0x01] || sector[0x0e] || sector[0x0f])
		return 1;
	if (sector[0x02] != 0x01 || sector[0x10] != 0x01)
		return 1;
	if (sector[0x11] >= 0xbc) 
	{
		//video elementary stream
		if ((sector[0x11] & 0xf0) == 0xe0) 
		{
			header_length = sector[14 + 8] + 6 + 3;
			fwrite(&sector[14 + header_length],1,2048 - 14 - header_length,stdout);
		}
	}
	return 1;
}

int main(int argc, char *argv[])
{
	if (argc < 2) {
		fprintf(stderr, "usage: %s mpeg_stream\n", argv[0]);
		exit(1);
	}

	file_init(argv[1]);

	while(parse_sector());

	if(input_file != STDIN_FILENO) close(input_file);
	return 0;
}		

