/*************************************************************************

This software module was originally developed by 

	Ming-Chieh Lee (mingcl@microsoft.com), Microsoft Corporation
	Wei-ge Chen (wchen@microsoft.com), Microsoft Corporation
	Bruce Lin (blin@microsoft.com), Microsoft Corporation
	Chuang Gu (chuanggu@microsoft.com), Microsoft Corporation
	(date: March, 1996)

and edited by
	Yoshihiro Kikuchi (TOSHIBA CORPORATION)
	Takeshi Nagai (TOSHIBA CORPORATION)
	Toshiaki Watanabe (TOSHIBA CORPORATION)
	Noboru Yamaguchi (TOSHIBA CORPORATION)

in the course of development of the MPEG-4 Video (ISO/IEC 14496-2). 
This software module is an implementation of a part of one or more MPEG-4 Video tools 
as specified by the MPEG-4 Video. 
ISO/IEC gives users of the MPEG-4 Video free license to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the MPEG-4 Video. 
Those intending to use this software module in hardware or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, 
the subsequent editors and their companies, 
and ISO/IEC have no liability for use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Video conforming products. 
Microsoft retains full right to use the code for his/her own purpose, 
assign or donate the code to a third party and to inhibit third parties from using the code for non <MPEG standard> conforming products. 
This copyright notice must be included in all copies or derivative works. 

Copyright (c) 1996, 1997.

Revision History:

*************************************************************************/


#ifndef __GLOBAL_HPP_
#define __GLOBAL_HPP_



// global tables for overlap motion comp.
// central block

#ifdef __GLOBAL_VAR_

UInt gWghtC[8][8] = {
	{4,5,5,5,5,5,5,4},
	{5,5,5,5,5,5,5,5},
	{5,5,6,6,6,6,5,5},
	{5,5,6,6,6,6,5,5},
	{5,5,6,6,6,6,5,5},
	{5,5,6,6,6,6,5,5},
	{5,5,5,5,5,5,5,5},
	{4,5,5,5,5,5,5,4},
};
// top block
UInt gWghtT[8][8] = {
	{2,2,2,2,2,2,2,2},
	{1,1,2,2,2,2,1,1},
	{1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1},
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
};
// bottom block
UInt gWghtB[8][8] = {
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0},
	{1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1},
	{1,1,2,2,2,2,1,1},
	{2,2,2,2,2,2,2,2},
};
// right block
UInt gWghtR[8][8] = {
	{0,0,0,0,1,1,1,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,2,2},
	{0,0,0,0,1,1,1,2},
};
// left block
UInt gWghtL[8][8] = {
	{2,1,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,2,1,1,0,0,0,0},
	{2,1,1,1,0,0,0,0},
};

// rounding table for Chrominace mv; see VM1.1/Table ?
Int grgiMvRound16 [16] = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
};
Int grgiMvRound12 [12] = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2,
};
Int grgiMvRound8 [8] = {
	0, 0, 1, 1, 1, 1, 1, 2,
};
Int grgiMvRound4 [4] ={
	0, 1, 1, 1,
};


//index of candidate blocks for diffrential mv coding
BlockNum gIndexOfCandBlk[5][3] = {
					{Y_BLOCK2, Y_BLOCK3, Y_BLOCK3}, 	
					{Y_BLOCK2, Y_BLOCK3, Y_BLOCK3}, 
					{Y_BLOCK1, Y_BLOCK4, Y_BLOCK3},
					{Y_BLOCK4, Y_BLOCK1, Y_BLOCK2},
					{Y_BLOCK3, Y_BLOCK1, Y_BLOCK2}};

//MPEG quantizer matrix
Int rgiDefaultIntraQMatrix [BLOCK_SQUARE_SIZE] = {
	8,	17,	18,	19,	21,	23,	25,	27,
	17,	18,	19,	21,	23,	25,	27,	28,
	20,	21,	22,	23,	24,	26,	28,	30,
	21,	22,	23,	24,	26,	28,	30,	32,
	22,	23,	24,	26,	28,	30,	32,	35,
	23,	24,	26,	28,	30,	32,	35,	38,
	25,	26,	28,	30,	32,	35,	38,	41,
	27,	28,	30,	32,	35,	38,	41,	45
};

Int rgiDefaultInterQMatrix [BLOCK_SQUARE_SIZE] = {
	16,	17,	18, 19, 20,	21,	22,	23,
	17,	18,	19,	20,	21,	22,	23,	24,
	18,	19,	20,	21,	22,	23,	24,	25,
	19,	20,	21,	22,	23,	24,	26,	27,
	20,	21,	22,	23,	25,	26,	27,	28,
	21,	22,	23,	24,	26,	27,	28,	30,
	22,	23,	24,	26,	27,	28,	30,	31,
	23,	24,	25,	27,	28,	30,	31,	33
};
/*
Int rgiDefaultIntraQMatrix [BLOCK_SQUARE_SIZE] = {
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16
};

Int rgiDefaultInterQMatrix [BLOCK_SQUARE_SIZE] = {
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16,
	16,	16,	16,	16,	16,	16,	16, 16
};
*/
Int grgiStandardZigzag [BLOCK_SQUARE_SIZE] = {
	0, 1, 8, 16, 9, 2, 3, 10, 
	17, 24, 32, 25, 18, 11, 4, 5, 
	12, 19, 26, 33, 40, 48, 41, 34, 
	27, 20, 13, 6, 7, 14, 21, 28, 
	35, 42, 49, 56, 57, 50, 43, 36, 
	29, 22, 15, 23, 30, 37, 44, 51, 
	58, 59, 52, 45, 38, 31, 39, 46, 
	53, 60, 61, 54, 47, 55, 62, 63
};

Int grgiHorizontalZigzag [BLOCK_SQUARE_SIZE] = {
	0, 1, 2, 3, 8, 9, 16, 17, 
	10, 11, 4, 5, 6, 7, 15, 14, 
	13, 12, 19, 18, 24, 25, 32, 33, 
	26, 27, 20, 21, 22, 23, 28, 29, 
	30, 31, 34, 35, 40, 41, 48, 49, 
	42, 43, 36, 37, 38, 39, 44, 45, 
	46, 47, 50, 51, 56, 57, 58, 59, 
	52, 53, 54, 55, 60, 61, 62, 63
};

Int grgiVerticalZigzag [BLOCK_SQUARE_SIZE] = {
	0, 8, 16, 24, 1, 9, 2, 10, 
	17, 25, 32, 40, 48, 56, 57, 49, 
	41, 33, 26, 18, 3, 11, 4, 12, 
	19, 27, 34, 42, 50, 58, 35, 43, 
	51, 59, 20, 28, 5, 13, 6, 14, 
	21, 29, 36, 44, 52, 60, 37, 45, 
	53, 61, 22, 30, 7, 15, 23, 31, 
	38, 46, 54, 62, 39, 47, 55, 63
};

UInt grgIfNotLastNumOfLevelAtRun [27] = {
	12, 6, 4, 3, 3, 3, 3, 2, 2, 2, 2, 
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1
};

UInt grgIfLastNumOfLevelAtRun [41] = {
	 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1
};

UInt grgiIntraYAVCLHashingTable [102] = {
1, 3, 6, 9, 10, 13, 14, 17, 18, 21,
22, 23, 2, 34, 11, 19, 24, 25, 33, 12,
20, 26, 4, 15, 39, 5, 130, 27, 65, 68,
41, 7, 100, 195, 8, 131, 97, 258, 129,
163, 35, 42, 66, 225, 36, 98, 16, 37,
38, 67, 99, 162, 194, 226, 40, 290, 69,
227, 1025, 353, 1030, 1057, 1031, 1089, 161, 
1026, 1185, 193, 1121, 1153, 1313, 257, 289,
321, 1027, 1217, 1249, 1281, 385, 1028, 1058,
1345, 1377, 1409, 1441, 1473, 417, 1029, 1059,
1090, 1122, 1154, 1505, 1537, 449, 1032, 1186,
1218, 1569, 1601, 1633, 1665};

/* NBIT: change to a bigger number
Int grgiDCSwitchingThreshold [8] = {32, 13, 15, 17, 19, 21, 23, 0};
*/
Int grgiDCSwitchingThreshold [8] = {512, 13, 15, 17, 19, 21, 23, 0};

Int g_rgiLMAXintra [128] ={27, 10, 5, 4, 3, 3, 3, 3, 2, 2, 1, 1, 1, 1, 1, 0, 
						    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							8,  3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
							1,  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

Int g_rgiRMAXintra [64]  = {0, 15,10, 8, 4, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 
						    1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
						    0, 21, 7, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
						    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

Int g_rgiLMAXinter [128] = {12, 6, 4, 3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 1, 
							 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
							 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
							 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
							 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
							 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

Int g_rgiRMAXinter [64]  = {0, 27, 11, 7, 3, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0,
							0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
						    0, 41,  2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,};

U16 gCAEintraProb [1024] = {
65267,16468,65003,17912,64573,8556,64252,5653,
40174,3932,29789,277,45152,1140,32768,2043,
4499,80,6554,1144,21065,465,32768,799,
5482,183,7282,264,5336,99,6554,563,
54784,30201,58254,9879,54613,3069,32768,58495,
32768,32768,32768,2849,58982,54613,32768,12892,
31006,1332,49152,3287,60075,350,32768,712,
39322,760,32768,354,52659,432,61854,150,
64999,28362,65323,42521,63572,32768,63677,18319,
4910,32768,64238,434,53248,32768,61865,13590,
16384,32768,13107,333,32768,32768,32768,32768,
32768,32768,1074,780,25058,5461,6697,233,
62949,30247,63702,24638,59578,32768,32768,42257,
32768,32768,49152,546,62557,32768,54613,19258,
62405,32569,64600,865,60495,10923,32768,898,
34193,24576,64111,341,47492,5231,55474,591,
65114,60075,64080,5334,65448,61882,64543,13209,
54906,16384,35289,4933,48645,9614,55351,7318,
49807,54613,32768,32768,50972,32768,32768,32768,
15159,1928,2048,171,3093,8,6096,74,
32768,60855,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,55454,32768,57672,
32768,16384,32768,21845,32768,32768,32768,32768,
32768,32768,32768,5041,28440,91,32768,45,
65124,10923,64874,5041,65429,57344,63435,48060,
61440,32768,63488,24887,59688,3277,63918,14021,
32768,32768,32768,32768,32768,32768,32768,32768,
690,32768,32768,1456,32768,32768,8192,728,
32768,32768,58982,17944,65237,54613,32768,2242,
32768,32768,32768,42130,49152,57344,58254,16740,
32768,10923,54613,182,32768,32768,32768,7282,
49152,32768,32768,5041,63295,1394,55188,77,
63672,6554,54613,49152,64558,32768,32768,5461,
64142,32768,32768,32768,62415,32768,32768,16384,
1481,438,19661,840,33654,3121,64425,6554,
4178,2048,32768,2260,5226,1680,32768,565,
60075,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
16384,261,32768,412,16384,636,32768,4369,
23406,4328,32768,524,15604,560,32768,676,
49152,32768,49152,32768,32768,32768,64572,32768,
32768,32768,54613,32768,32768,32768,32768,32768,
4681,32768,5617,851,32768,32768,59578,32768,
32768,32768,3121,3121,49152,32768,6554,10923,
32768,32768,54613,14043,32768,32768,32768,3449,
32768,32768,32768,32768,32768,32768,32768,32768,
57344,32768,57344,3449,32768,32768,32768,3855,
58982,10923,32768,239,62259,32768,49152,85,
58778,23831,62888,20922,64311,8192,60075,575,
59714,32768,57344,40960,62107,4096,61943,3921,
39862,15338,32768,1524,45123,5958,32768,58982,
6669,930,1170,1043,7385,44,8813,5011,
59578,29789,54613,32768,32768,32768,32768,32768,
32768,32768,32768,32768,58254,56174,32768,32768,
64080,25891,49152,22528,32768,2731,32768,10923,
10923,3283,32768,1748,17827,77,32768,108,
62805,32768,62013,42612,32768,32768,61681,16384,
58982,60075,62313,58982,65279,58982,62694,62174,
32768,32768,10923,950,32768,32768,32768,32768,
5958,32768,38551,1092,11012,39322,13705,2072,
54613,32768,32768,11398,32768,32768,32768,145,
32768,32768,32768,29789,60855,32768,61681,54792,
32768,32768,32768,17348,32768,32768,32768,8192,
57344,16384,32768,3582,52581,580,24030,303,
62673,37266,65374,6197,62017,32768,49152,299,
54613,32768,32768,32768,35234,119,32768,3855,
31949,32768,32768,49152,16384,32768,32768,32768,
24576,32768,49152,32768,17476,32768,32768,57445,
51200,50864,54613,27949,60075,20480,32768,57344,
32768,32768,32768,32768,32768,45875,32768,32768,
11498,3244,24576,482,16384,1150,32768,16384,
7992,215,32768,1150,23593,927,32768,993,
65353,32768,65465,46741,41870,32768,64596,59578,
62087,32768,12619,23406,11833,32768,47720,17476,
32768,32768,2621,6554,32768,32768,32768,32768,
32768,32768,5041,32768,16384,32768,4096,2731,
63212,43526,65442,47124,65410,35747,60304,55858,
60855,58982,60075,19859,35747,63015,64470,25432,
58689,1118,64717,1339,24576,32768,32768,1257,
53297,1928,32768,33,52067,3511,62861,453,
64613,32768,32768,32768,64558,32768,32768,2731,
49152,32768,32768,32768,61534,32768,32768,35747,
32768,32768,32768,32768,13107,32768,32768,32768,
32768,32768,32768,32768,20480,32768,32768,32768,
32768,32768,32768,54613,40960,5041,32768,32768,
32768,32768,32768,3277,64263,57592,32768,3121,
32768,32768,32768,32768,32768,10923,32768,32768,
32768,8192,32768,32768,5461,6899,32768,1725,
63351,3855,63608,29127,62415,7282,64626,60855,
32768,32768,60075,5958,44961,32768,61866,53718,
32768,32768,32768,32768,32768,32768,6554,32768,
32768,32768,32768,32768,2521,978,32768,1489,
58254,32768,58982,61745,21845,32768,54613,58655,
60075,32768,49152,16274,50412,64344,61643,43987,
32768,32768,32768,1638,32768,32768,32768,24966,
54613,32768,32768,2427,46951,32768,17970,654,
65385,27307,60075,26472,64479,32768,32768,4681,
61895,32768,32768,16384,58254,32768,32768,6554,
37630,3277,54613,6554,4965,5958,4681,32768,
42765,16384,32768,21845,22827,16384,32768,6554,
65297,64769,60855,12743,63195,16384,32768,37942,
32768,32768,32768,32768,60075,32768,62087,54613,
41764,2161,21845,1836,17284,5424,10923,1680,
11019,555,32768,431,39819,907,32768,171,
65480,32768,64435,33803,2595,32768,57041,32768,
61167,32768,32768,32768,32768,32768,32768,1796,
60855,32768,17246,978,32768,32768,8192,32768,
32768,32768,14043,2849,32768,2979,6554,6554,
65507,62415,65384,61891,65273,58982,65461,55097,
32768,32768,32768,55606,32768,2979,3745,16913,
61885,13827,60893,12196,60855,53248,51493,11243,
56656,783,55563,143,63432,7106,52429,445,
65485,1031,65020,1380,65180,57344,65162,36536,
61154,6554,26569,2341,63593,3449,65102,533,
47827,2913,57344,3449,35688,1337,32768,22938,
25012,910,7944,1008,29319,607,64466,4202,
64549,57301,49152,20025,63351,61167,32768,45542,
58982,14564,32768,9362,61895,44840,32768,26385,
59664,17135,60855,13291,40050,12252,32768,7816,
25798,1850,60495,2662,18707,122,52538,231,
65332,32768,65210,21693,65113,6554,65141,39667,
62259,32768,22258,1337,63636,32768,64255,52429,
60362,32768,6780,819,16384,32768,16384,4681,
49152,32768,8985,2521,24410,683,21535,16585,
65416,46091,65292,58328,64626,32768,65016,39897,
62687,47332,62805,28948,64284,53620,52870,49567,
65032,31174,63022,28312,64299,46811,48009,31453,
61207,7077,50299,1514,60047,2634,46488,235
};

U16 gCAEinterProb [512] = {
65532,62970,65148,54613,62470,8192,62577,8937,
65480,64335,65195,53248,65322,62518,62891,38312,
65075,53405,63980,58982,32768,32768,54613,32768,
65238,60009,60075,32768,59294,19661,61203,13107,
63000,9830,62566,58982,11565,32768,25215,3277,
53620,50972,63109,43691,54613,32768,39671,17129,
59788,6068,43336,27913,6554,32768,12178,1771,
56174,49152,60075,43691,58254,16384,49152,9930,
23130,7282,40960,32768,10923,32768,32768,32768,
27307,32768,32768,32768,32768,32768,32768,32768,
36285,12511,10923,32768,45875,16384,32768,32768,
16384,23831,4369,32768,8192,10923,32768,32768,
10175,2979,18978,10923,54613,32768,6242,6554,
1820,10923,32768,32768,32768,32768,32768,5461,
28459,593,11886,2030,3121,4681,1292,112,
42130,23831,49152,29127,32768,6554,5461,2048,
65331,64600,63811,63314,42130,19661,49152,32768,
65417,64609,62415,64617,64276,44256,61068,36713,
64887,57525,53620,61375,32768,8192,57344,6554,
63608,49809,49152,62623,32768,15851,58982,34162,
55454,51739,64406,64047,32768,32768,7282,32768,
49152,58756,62805,64990,32768,14895,16384,19418,
57929,24966,58689,31832,32768,16384,10923,6554,
54613,42882,57344,64238,58982,10082,20165,20339,
62687,15061,32768,10923,32768,10923,32768,16384,
59578,34427,32768,16384,32768,7825,32768,7282,
58052,23400,32768,5041,32768,2849,32768,32768,
47663,15073,57344,4096,32768,1176,32768,1320,
24858,410,24576,923,32768,16384,16384,5461,
16384,1365,32768,5461,32768,5699,8192,13107,
46884,2361,23559,424,19661,712,655,182,
58637,2094,49152,9362,8192,85,32768,1228,
65486,49152,65186,49152,61320,32768,57088,25206,
65352,63047,62623,49152,64641,62165,58986,18304,
64171,16384,60855,54613,42130,32768,61335,32768,
58254,58982,49152,32768,60985,35289,64520,31554,
51067,32768,64074,32768,40330,32768,34526,4096,
60855,32768,63109,58254,57672,16384,31009,2567,
23406,32768,44620,10923,32768,32768,32099,10923,
49152,49152,54613,60075,63422,54613,46388,39719,
58982,32768,54613,32768,14247,32768,22938,5041,
32768,49152,32768,32768,25321,6144,29127,10999,
41263,32768,46811,32768,267,4096,426,16384,
32768,19275,49152,32768,1008,1437,5767,11275,
5595,5461,37493,6554,4681,32768,6147,1560,
38229,10923,32768,40960,35747,2521,5999,312,
17052,2521,18808,3641,213,2427,574,32,
51493,42130,42130,53053,11155,312,2069,106,
64406,45197,58982,32768,32768,16384,40960,36864,
65336,64244,60075,61681,65269,50748,60340,20515,
58982,23406,57344,32768,6554,16384,19661,61564,
60855,47480,32768,54613,46811,21701,54909,37826,
32768,58982,60855,60855,32768,32768,39322,49152,
57344,45875,60855,55706,32768,24576,62313,25038,
54613,8192,49152,10923,32768,32768,32768,32768,
32768,19661,16384,51493,32768,14043,40050,44651,
59578,5174,32768,6554,32768,5461,23593,5461,
63608,51825,32768,23831,58887,24032,57170,3298,
39322,12971,16384,49152,1872,618,13107,2114,
58982,25705,32768,60075,28913,949,18312,1815,
48188,114,51493,1542,5461,3855,11360,1163,
58982,7215,54613,21487,49152,4590,48430,1421,
28944,1319,6868,324,1456,232,820,7,
61681,1864,60855,9922,4369,315,6589,14
};

U8 grgchFirstShpCd [243] = {
	0, 3, 2, 3, 2, 0, 2, 3, 0, 0, 3, 2, 0, 2, 3, 0, 2, 3, 
	0, 3, 2, 0, 2, 3, 2, 3, 0, 3, 2, 0, 0, 2, 3, 0, 2, 3, 
	3, 2, 0, 0, 2, 3, 2, 0, 3, 3, 2, 0, 0, 2, 3, 0, 2, 3, 
	2, 3, 0, 0, 2, 3, 3, 2, 0, 2, 3, 0, 0, 2, 3, 3, 2, 0, 
	2, 3, 0, 3, 2, 0, 3, 2, 0, 0, 2, 3, 0, 2, 3, 0, 2, 3, 
	0, 2, 3, 0, 2, 3, 0, 2, 3, 0, 2, 3, 0, 2, 3, 3, 2, 0, 
	0, 2, 3, 3, 2, 0, 3, 2, 0, 0, 2, 3, 3, 0, 2, 3, 2, 0, 
	0, 2, 3, 3, 0, 2, 3, 2, 0, 0, 2, 3, 3, 2, 0, 2, 3, 0, 
	0, 2, 3, 3, 2, 0, 2, 3, 0, 0, 3, 2, 3, 0, 2, 2, 3, 0, 
	0, 3, 2, 2, 3, 0, 2, 3, 0, 0, 2, 3, 0, 2, 3, 0, 2, 3, 
	0, 2, 3, 0, 2, 3, 2, 3, 0, 0, 2, 3, 3, 2, 0, 3, 2, 0, 
	2, 3, 0, 3, 0, 2, 3, 0, 2, 2, 3, 0, 3, 0, 2, 3, 2, 0, 
	0, 3, 2, 3, 2, 0, 2, 3, 0, 2, 3, 0, 3, 0, 2, 3, 2, 0, 
	0, 3, 2, 3, 0, 2, 3, 2, 0 
};

// 10/11/97 Threshold for shape upsampling filter : added by dscho@dspsun.sait.samsung.co.kr
U8 grgchInterpolationFilterTh [256] = {
       3, 6, 6, 7,  4, 7, 7, 8,  6, 7, 5, 8,  7, 8, 8, 9,
       6, 5, 5, 8,  5, 6, 8, 9,  7, 6, 8, 9,  8, 7, 9,10,
       6, 7, 7, 8,  7, 8, 8, 9,  7,10, 8, 9,  8, 9, 9,10,
       7, 8, 6, 9,  6, 9, 9,10,  8, 9, 9,10, 11,10,10,11,
       6, 9, 5, 8,  5, 6, 8, 9,  7,10,10, 9,  8, 7, 9,10,
       7, 6, 8, 9,  8, 7, 7,10,  8, 9, 9,10,  9, 8,10, 9,
       7, 8, 8, 9,  6, 9, 9,10,  8, 9, 9,10,  9,10,10, 9,
       8, 9,11,10,  7,10,10,11,  9,12,10,11, 10,11,11,12,
       6, 7, 5, 8,  5, 6, 8, 9,  5, 6, 6, 9,  8, 9, 9,10,
       5, 8, 8, 9,  6, 7, 9,10,  6, 7, 9,10,  9,10,10,11,
       7, 8, 6, 9,  8, 9, 9,10,  8, 7, 9,10,  9,10,10,11,
       8, 9, 7,10,  9,10, 8,11,  9,10,10,11, 10,11, 9,12,
       7, 8, 6, 9,  8, 9, 9,10, 10, 9, 7,10,  9,10,10,11,
       8, 7, 7,10,  7, 8, 8, 9,  9,10,10,11, 10,11,11,12,
       8, 9, 9,10,  9,10,10, 9,  9,10,10,11, 10,11,11,12,
       9,10,10,11, 10,11,11,12, 10,11,11,12, 11,12,12,13
};
//	Added for error resilient mode by Toshiba(1997-11-14)
Int	g_iMaxHeading;
Int	g_iMaxMiddle;
Int 	g_iMaxTrailing;
// End Toshiba(1997-11-14)

//	Added for error resilience mode By Toshiba(1998-1-16:DP+RVLC)
UInt grgiInterRVLCYAVCLHashingTable [169] = {
   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,
  11,  12,  13,  14,  15,  16,  17,  18,  19,  33,
  34,  35,  36,  37,  38,  39,  40,  41,  42,  65,
  66,  67,  68,  69,  70,  71,  97,  98,  99, 100,
 101, 102, 103, 129, 130, 131, 132, 133, 161, 162,
 163, 164, 193, 194, 195, 196, 225, 226, 227, 228,
 257, 258, 259, 289, 290, 291, 321, 322, 353, 354,
 385, 386, 417, 418, 449, 450, 481, 482, 513, 514,
 545, 546, 577, 609, 641, 673, 705, 737, 769, 801,
 833, 865, 897, 929, 961, 993,1025,1057,1089,1121,
1153,1185,1217,2049,2050,2051,2052,2053,2081,2082,
2083,2084,2085,2113,2114,2115,2145,2146,2177,2178,
2209,2210,2241,2242,2273,2274,2305,2306,2337,2338,
2369,2370,2401,2402,2433,2434,2465,2466,2497,2529,
2561,2593,2625,2657,2689,2721,2753,2785,2817,2849,
2881,2913,2945,2977,3009,3041,3073,3105,3137,3169,
3201,3233,3265,3297,3329,3361,3393,3425,3457
};

UInt grgiIntraRVLCYAVCLHashingTable [169] = {
   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,
  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
  21,  22,  23,  24,  25,  26,  27,  33,  34,  35,
  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,
  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  97,  98,  99, 100, 101, 102, 103, 104, 105,
 129, 130, 131, 132, 133, 134, 161, 162, 163, 164,
 165, 166, 193, 194, 195, 196, 197, 225, 226, 227,
 228, 229, 257, 258, 259, 260, 289, 290, 291, 292,
 321, 322, 353, 354, 385, 386, 417, 449, 481, 513,
 545, 577, 609,2049,2050,2051,2052,2053,2081,2082,
2083,2084,2085,2113,2114,2115,2145,2146,2177,2178,
2209,2210,2241,2242,2273,2274,2305,2306,2337,2338,
2369,2370,2401,2402,2433,2434,2465,2466,2497,2529,
2561,2593,2625,2657,2689,2721,2753,2785,2817,2849,
2881,2913,2945,2977,3009,3041,3073,3105,3137,3169,
3201,3233,3265,3297,3329,3361,3393,3425,3457
};

UInt grgIfNotLastNumOfLevelAtRunInterRVLC [39] = {
	19, 10, 7, 7, 5, 4, 4, 4, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

UInt grgIfLastNumOfLevelAtRunInterRVLC [45] = {
	5, 5, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

UInt grgIfNotLastNumOfLevelAtRunIntraRVLC [20] = {
	27, 13, 11, 9, 6, 6, 5, 5, 4, 4, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1
};

UInt grgIfLastNumOfLevelAtRunIntraRVLC [45] = {
	5, 5, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};
//	End Toshiba(1998-1-16:DP+RVLC)

#else
extern UInt gWghtC[8][8];
extern UInt gWghtT[8][8];
extern UInt gWghtB[8][8];
extern UInt gWghtR[8][8];
extern UInt gWghtL[8][8];
extern Int grgiMvRound16 [16];
extern Int grgiMvRound12 [12];
extern Int grgiMvRound8 [8];
extern Int grgiMvRound4 [4];
extern BlockNum gIndexOfCandBlk[5][3];
extern Int rgiDefaultIntraQMatrix [BLOCK_SQUARE_SIZE];
extern Int rgiDefaultInterQMatrix [BLOCK_SQUARE_SIZE]; 
extern Int grgiStandardZigzag [BLOCK_SQUARE_SIZE];
extern Int grgiHorizontalZigzag [BLOCK_SQUARE_SIZE];
extern Int grgiVerticalZigzag [BLOCK_SQUARE_SIZE];
extern UInt grgIfNotLastNumOfLevelAtRun [27];
extern UInt grgIfLastNumOfLevelAtRun [41];
extern UInt grgiIntraYAVCLHashingTable [102];
extern Int grgiDCSwitchingThreshold [8];
extern Int g_rgiLMAXintra [128]; 
extern Int g_rgiRMAXintra [32];
extern Int g_rgiLMAXinter [128];
extern Int g_rgiRMAXinter [32];
extern U16 gCAEintraProb [1024];
extern U16 gCAEinterProb [512];
extern U8 grgchFirstShpCd [243];
extern U8 grgchInterpolationFilterTh [256];
//	Added for error resilient mode by Toshiba(1997-11-14)
extern Int	g_iMaxHeading;
extern Int	g_iMaxMiddle;
extern Int 	g_iMaxTrailing;
// End Toshiba(1997-11-14)
//	Added for error resilience mode By Toshiba(1998-1-16:DP+RVLC)
extern UInt grgiIntraRVLCYAVCLHashingTable [169];
extern UInt grgiInterRVLCYAVCLHashingTable [169];
extern UInt grgIfNotLastNumOfLevelAtRunInterRVLC [39];
extern UInt grgIfLastNumOfLevelAtRunInterRVLC [45];
extern UInt grgIfNotLastNumOfLevelAtRunIntraRVLC [20];
extern UInt grgIfLastNumOfLevelAtRunIntraRVLC [45];
//	End Toshiba(1998-1-16:DP+RVLC)
#endif

#ifdef __GLOBAL_VAR_
#undef __GLOBAL_VAR_
#endif

#endif
