/*************************************************************************

This software module was originally developed by 

	Ming-Chieh Lee (mingcl@microsoft.com), Microsoft Corporation
	Wei-ge Chen (wchen@microsoft.com), Microsoft Corporation
	Bruce Lin (blin@microsoft.com), Microsoft Corporation
	Chuang Gu (chuanggu@microsoft.com), Microsoft Corporation
	Simon Winder (swinder@microsoft.com), Microsoft Corporation
	(date: March, 1996)

in the course of development of the MPEG-4 Video (ISO/IEC 14496-2). 
This software module is an implementation of a part of one or more MPEG-4 Video tools 
as specified by the MPEG-4 Video. 
ISO/IEC gives users of the MPEG-4 Video free license to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the MPEG-4 Video. 
Those intending to use this software module in hardware or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, 
the subsequent editors and their companies, 
and ISO/IEC have no liability for use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Video conforming products. 
Microsoft retains full right to use the code for his/her own purpose, 
assign or donate the code to a third party and to inhibit third parties from using the code for non <MPEG standard> conforming products. 
This copyright notice must be included in all copies or derivative works. 

Copyright (c) 1996, 1997.

Module Name:

	vlc.hpp

Abstract:

	Vlc codes for entropy encoder/decoder

Revision History:

*************************************************************************/


static VlcTable g_rgVlcDCT[] = {
{0,"10"}, {1,"1111"}, {2,"010101"}, {3,"0010111"}, {4,"00011111"},
{5,"000100101"}, {6,"000100100"}, {7,"0000100001"}, {8,"0000100000"},
{9,"00000000111"}, {10,"00000000110"}, {11,"00000100000"}, {12,"110"},
{13,"010100"}, {14,"00011110"}, {15,"0000001111"}, {16,"00000100001"},
{17,"000001010000"}, {18,"1110"}, {19,"00011101"}, {20,"0000001110"},
{21,"000001010001"}, {22,"01101"}, {23,"000100011"},
{24,"0000001101"}, {25,"01100"}, {26,"000100010"},
{27,"000001010010"}, {28,"01011"}, {29,"0000001100"},
{30,"000001010011"}, {31,"010011"}, {32,"0000001011"},
{33,"000001010100"}, {34,"010010"}, {35,"0000001010"}, {36,"010001"},
{37,"0000001001"}, {38,"010000"}, {39,"0000001000"}, {40,"0010110"},
{41,"000001010101"}, {42,"0010101"}, {43,"0010100"}, {44,"00011100"},
{45,"00011011"}, {46,"000100001"}, {47,"000100000"}, {48,"000011111"},
{49,"000011110"}, {50,"000011101"}, {51,"000011100"},
{52,"000011011"}, {53,"000011010"}, {54,"00000100010"},
{55,"00000100011"}, {56,"000001010110"}, {57,"000001010111"},
{58,"0111"}, {59,"000011001"}, {60,"00000000101"}, {61,"001111"},
{62,"00000000100"}, {63,"001110"}, {64,"001101"}, {65,"001100"},
{66,"0010011"}, {67,"0010010"}, {68,"0010001"}, {69,"0010000"},
{70,"00011010"}, {71,"00011001"}, {72,"00011000"}, {73,"00010111"},
{74,"00010110"}, {75,"00010101"}, {76,"00010100"}, {77,"00010011"},
{78,"000011000"}, {79,"000010111"}, {80,"000010110"},
{81,"000010101"}, {82,"000010100"}, {83,"000010011"},
{84,"000010010"}, {85,"000010001"}, {86,"0000000111"},
{87,"0000000110"}, {88,"0000000101"}, {89,"0000000100"},
{90,"00000100100"}, {91,"00000100101"}, {92,"00000100110"},
{93,"00000100111"}, {94,"000001011000"}, {95,"000001011001"},
{96,"000001011010"}, {97,"000001011011"}, {98,"000001011100"},
{99,"000001011101"}, {100,"000001011110"}, {101,"000001011111"},
{102,"0000011"},
{103,NULL}
};

static VlcTable g_rgVlcDCTIntra[] = {
{0,"10"}, {1,"1111"}, {2,"010101"}, {3,"0010111"}, {4,"00011111"},
{5,"000100101"}, {6,"000100100"}, {7,"0000100001"}, {8,"0000100000"},
{9,"00000000111"}, {10,"00000000110"}, {11,"00000100000"}, {12,"110"},
{13,"010100"}, {14,"00011110"}, {15,"0000001111"}, {16,"00000100001"},
{17,"000001010000"}, {18,"1110"}, {19,"00011101"}, {20,"0000001110"},
{21,"000001010001"}, {22,"01101"}, {23,"000100011"},
{24,"0000001101"}, {25,"01100"}, {26,"000100010"},
{27,"000001010010"}, {28,"01011"}, {29,"0000001100"},
{30,"000001010011"}, {31,"010011"}, {32,"0000001011"},
{33,"000001010100"}, {34,"010010"}, {35,"0000001010"}, {36,"010001"},
{37,"0000001001"}, {38,"010000"}, {39,"0000001000"}, {40,"0010110"},
{41,"000001010101"}, {42,"0010101"}, {43,"0010100"}, {44,"00011100"},
{45,"00011011"}, {46,"000100001"}, {47,"000100000"}, {48,"000011111"},
{49,"000011110"}, {50,"000011101"}, {51,"000011100"},
{52,"000011011"}, {53,"000011010"}, {54,"00000100010"},
{55,"00000100011"}, {56,"000001010110"}, {57,"000001010111"},
{58,"0111"}, {59,"000011001"}, {60,"00000000101"}, {61,"001111"},
{62,"00000000100"}, {63,"001110"}, {64,"001101"}, {65,"001100"},
{66,"0010011"}, {67,"0010010"}, {68,"0010001"}, {69,"0010000"},
{70,"00011010"}, {71,"00011001"}, {72,"00011000"}, {73,"00010111"},
{74,"00010110"}, {75,"00010101"}, {76,"00010100"}, {77,"00010011"},
{78,"000011000"}, {79,"000010111"}, {80,"000010110"},
{81,"000010101"}, {82,"000010100"}, {83,"000010011"},
{84,"000010010"}, {85,"000010001"}, {86,"0000000111"},
{87,"0000000110"}, {88,"0000000101"}, {89,"0000000100"},
{90,"00000100100"}, {91,"00000100101"}, {92,"00000100110"},
{93,"00000100111"}, {94,"000001011000"}, {95,"000001011001"},
{96,"000001011010"}, {97,"000001011011"}, {98,"000001011100"},
{99,"000001011101"}, {100,"000001011110"}, {101,"000001011111"},
{102,"0000011"},
{103,NULL}
};

static VlcTable g_rgVlcDCTRVLC[] = {
{0,"110"}, {1,"0001"}, {2,"00100"}, {3,"0011100"}, {4,"00111100"},
{5,"00111101"}, {6,"001111100"}, {7,"0011111100"}, {8,"0011111101"},
{9,"00111111100"}, {10,"00111111101"}, {11,"001111111100"},
{12,"0011111111100"}, {13,"0011111111101"}, {14,"0101111111100"},
{15,"0101111111101"}, {16,"00111111111100"}, {17,"00111111111101"},
{18,"001111111111100"}, {19,"111"}, {20,"001100"}, {21,"01011100"},
{22,"001111101"}, {23,"0101111100"}, {24,"01011111100"},
{25,"001111111101"}, {26,"0110111111100"}, {27,"01011111111100"},
{28,"01011111111101"}, {29,"1010"}, {30,"0011101"}, {31,"010111100"},
{32,"01011111101"}, {33,"010111111100"}, {34,"01101111111100"},
{35,"01101111111101"}, {36,"00101"}, {37,"01011101"},
{38,"0101111101"}, {39,"010111111101"}, {40,"0110111111101"},
{41,"01110111111100"}, {42,"001111111111101"}, {43,"01000"},
{44,"01101100"}, {45,"01101111100"}, {46,"0111011111100"},
{47,"010111111111100"}, {48,"01001"}, {49,"010111101"},
{50,"01101111101"}, {51,"0111011111101"}, {52,"001101"},
{53,"0110111100"}, {54,"011011111100"}, {55,"01110111111101"},
{56,"010100"}, {57,"0110111101"}, {58,"011011111101"},
{59,"010111111111101"}, {60,"010101"}, {61,"0111011100"},
{62,"0111101111100"}, {63,"0101100"}, {64,"0111011101"},
{65,"01111011111100"}, {66,"0101101"}, {67,"01110111100"},
{68,"0110100"}, {69,"011101111100"}, {70,"01101101"},
{71,"0111101111101"}, {72,"01110100"}, {73,"01111011111101"},
{74,"01110101"}, {75,"01111101111100"}, {76,"011011100"},
{77,"01111101111101"}, {78,"011011101"}, {79,"01111110111100"},
{80,"011101100"}, {81,"011011111111100"}, {82,"0111101100"},
{83,"0111101101"}, {84,"0111110100"}, {85,"01110111101"},
{86,"01111011100"}, {87,"01111011101"}, {88,"01111101100"},
{89,"01111101101"}, {90,"01111110100"}, {91,"011101111101"},
{92,"011110111100"}, {93,"011110111101"}, {94,"0111110111100"},
{95,"0111110111101"}, {96,"0111111011100"}, {97,"0111111011101"},
{98,"01111110111101"}, {99,"01111111011100"}, {100,"01111111011101"},
{101,"011011111111101"}, {102,"011101111111100"}, {103,"1011"},
{104,"01111000"}, {105,"01111110101"}, {106,"0111111101100"},
{107,"01111111101100"}, {108,"10010"}, {109,"011101101"},
{110,"011111011100"}, {111,"01111111101101"}, {112,"011101111111101"},
{113,"10011"}, {114,"01111111000"}, {115,"011110111111100"},
{116,"011000"}, {117,"011111011101"}, {118,"011001"},
{119,"011111101100"}, {120,"100010"}, {121,"0111111101101"},
{122,"100011"}, {123,"0111111110100"}, {124,"0110101"},
{125,"0111111110101"}, {126,"0111000"}, {127,"0111111111000"},
{128,"0111001"}, {129,"0111111111001"}, {130,"1000010"},
{131,"01111111110100"}, {132,"1000011"}, {133,"01111111110101"},
{134,"01111001"}, {135,"01111111111000"}, {136,"10000010"},
{137,"011110111111101"}, {138,"10000011"}, {139,"011110100"},
{140,"011110101"}, {141,"011111000"}, {142,"011111001"},
{143,"100000010"}, {144,"100000011"}, {145,"0111110101"},
{146,"0111111000"}, {147,"0111111001"}, {148,"1000000010"},
{149,"1000000011"}, {150,"01111111001"}, {151,"10000000010"},
{152,"10000000011"}, {153,"011111101101"}, {154,"011111110100"},
{155,"011111110101"}, {156,"011111111000"}, {157,"011111111001"},
{158,"100000000010"}, {159,"100000000011"}, {160,"1000000000010"},
{161,"1000000000011"}, {162,"01111111111001"}, {163,"10000000000010"},
{164,"10000000000011"}, {165,"011111011111100"},
{166,"011111011111101"}, {167,"011111101111100"},
{168,"011111101111101"}, {169,"0000"},
{170,NULL}
};

static VlcTable g_rgVlcDCTIntraRVLC[] = {

{0,"110"}, {1,"111"}, {2,"1010"}, {3,"01001"}, {4,"010100"},
{5,"010101"}, {6,"0110100"}, {7,"01110100"}, {8,"01110101"},
{9,"011011101"}, {10,"011101100"}, {11,"0111101100"},
{12,"0111101101"}, {13,"0111110100"}, {14,"01111101100"},
{15,"01111101101"}, {16,"01111110100"}, {17,"011101111101"},
{18,"011110111100"}, {19,"0111110111101"}, {20,"0111111011100"},
{21,"011110111101"}, {22,"0111111011101"}, {23,"01111110111101"},
{24,"01111111011100"}, {25,"01111111011101"}, {26,"001111111111100"},
{27,"0001"}, {28,"01000"}, {29,"0101101"}, {30,"01101100"},
{31,"01101101"}, {32,"011011100"}, {33,"0111011101"},
{34,"01111011100"}, {35,"01111011101"}, {36,"011101111100"},
{37,"0111110111100"}, {38,"01111101111101"}, {39,"01111110111100"},
{40,"00100"}, {41,"0101100"}, {42,"010111100"}, {43,"0111011100"},
{44,"01110111100"}, {45,"01110111101"}, {46,"0111011111101"},
{47,"0111101111100"}, {48,"0111101111101"}, {49,"01111011111101"},
{50,"01111101111100"}, {51,"00101"}, {52,"01011100"},
{53,"010111101"}, {54,"01101111101"}, {55,"011011111100"},
{56,"0111011111100"}, {57,"01110111111101"}, {58,"01111011111100"},
{59,"001111111111101"}, {60,"001100"}, {61,"01011101"},
{62,"0110111101"}, {63,"001111111101"}, {64,"011011111101"},
{65,"01101111111101"}, {66,"001101"}, {67,"001111101"},
{68,"01011111100"}, {69,"010111111100"}, {70,"01101111111100"},
{71,"01110111111100"}, {72,"0011100"}, {73,"0101111100"},
{74,"01011111101"}, {75,"010111111101"}, {76,"010111111111100"},
{77,"0011101"}, {78,"0101111101"}, {79,"01101111100"},
{80,"0110111111101"}, {81,"010111111111101"}, {82,"00111100"},
{83,"0110111100"}, {84,"0101111111101"}, {85,"01011111111101"},
{86,"00111101"}, {87,"00111111101"}, {88,"0110111111100"},
{89,"011011111111100"}, {90,"001111100"}, {91,"001111111100"},
{92,"0011111100"}, {93,"0101111111100"}, {94,"0011111101"},
{95,"011011111111101"}, {96,"00111111100"}, {97,"0011111111100"},
{98,"0011111111101"}, {99,"00111111111100"}, {100,"00111111111101"},
{101,"01011111111100"}, {102,"011101111111100"}, {103,"1011"},
{104,"01111000"}, {105,"01111110101"}, {106,"0111111101100"},
{107,"01111111101100"}, {108,"10010"}, {109,"011101101"},
{110,"011111011100"}, {111,"01111111101101"}, {112,"011101111111101"},
{113,"10011"}, {114,"01111111000"}, {115,"011110111111100"},
{116,"011000"}, {117,"011111011101"}, {118,"011001"},
{119,"011111101100"}, {120,"100010"}, {121,"0111111101101"},
{122,"100011"}, {123,"0111111110100"}, {124,"0110101"},
{125,"0111111110101"}, {126,"0111000"}, {127,"0111111111000"},
{128,"0111001"}, {129,"0111111111001"}, {130,"1000010"},
{131,"01111111110100"}, {132,"1000011"}, {133,"01111111110101"},
{134,"01111001"}, {135,"01111111111000"}, {136,"10000010"},
{137,"011110111111101"}, {138,"10000011"}, {139,"011110100"},
{140,"011110101"}, {141,"011111000"}, {142,"011111001"},
{143,"100000010"}, {144,"100000011"}, {145,"0111110101"},
{146,"0111111000"}, {147,"0111111001"}, {148,"1000000010"},
{149,"1000000011"}, {150,"01111111001"}, {151,"10000000010"},
{152,"10000000011"}, {153,"011111101101"}, {154,"011111110100"},
{155,"011111110101"}, {156,"011111111000"}, {157,"011111111001"},
{158,"100000000010"}, {159,"100000000011"}, {160,"1000000000010"},
{161,"1000000000011"}, {162,"01111111111001"}, {163,"10000000000010"},
{164,"10000000000011"}, {165,"011111011111100"},
{166,"011111011111101"}, {167,"011111101111100"},
{168,"011111101111101"}, {169,"0000"},
{170,NULL}
};

static VlcTable g_rgVlcMV[] = {
{0,"0000000000101"}, {1,"0000000000111"}, {2,"000000000101"},
{3,"000000000111"}, {4,"000000001001"}, {5,"000000001011"},
{6,"000000001101"}, {7,"000000001111"}, {8,"00000001001"},
{9,"00000001011"}, {10,"00000001101"}, {11,"00000001111"},
{12,"00000010001"}, {13,"00000010011"}, {14,"00000010101"},
{15,"00000010111"}, {16,"00000011001"}, {17,"00000011011"},
{18,"00000011101"}, {19,"00000011111"}, {20,"00000100001"},
{21,"00000100011"}, {22,"0000010011"}, {23,"0000010101"},
{24,"0000010111"}, {25,"00000111"}, {26,"00001001"}, {27,"00001011"},
{28,"0000111"}, {29,"00011"}, {30,"0011"}, {31,"011"}, {32,"1"},
{33,"010"}, {34,"0010"}, {35,"00010"}, {36,"0000110"},
{37,"00001010"}, {38,"00001000"}, {39,"00000110"}, {40,"0000010110"},
{41,"0000010100"}, {42,"0000010010"}, {43,"00000100010"},
{44,"00000100000"}, {45,"00000011110"}, {46,"00000011100"},
{47,"00000011010"}, {48,"00000011000"}, {49,"00000010110"},
{50,"00000010100"}, {51,"00000010010"}, {52,"00000010000"},
{53,"00000001110"}, {54,"00000001100"}, {55,"00000001010"},
{56,"00000001000"}, {57,"000000001110"}, {58,"000000001100"},
{59,"000000001010"}, {60,"000000001000"}, {61,"000000000110"},
{62,"000000000100"}, {63,"0000000000110"}, {64,"0000000000100"},
{65,NULL}
};

static VlcTable g_rgVlcMCBPCintra[] = {
{0,"1"}, {1,"001"}, {2,"010"}, {3,"011"}, {4,"0001"}, {5,"000001"},
{6,"000010"}, {7,"000011"}, {8,"000000001"},
{9,NULL}
};

static VlcTable g_rgVlcMCBPCinter[] = {
{0,"1"}, {1,"0011"}, {2,"0010"}, {3,"000101"}, {4,"011"},
{5,"0000111"}, {6,"0000110"}, {7,"000000101"}, {8,"010"},
{9,"0000101"}, {10,"0000100"}, {11,"00000101"}, {12,"00011"},
{13,"00000100"}, {14,"00000011"}, {15,"0000011"}, {16,"000100"},
{17,"000000100"}, {18,"000000011"}, {19,"000000010"},
{20,"000000001"},
{21,NULL}
};

static VlcTable g_rgVlcCBPY[] = {
{0,"0011"}, {1,"00101"}, {2,"00100"}, {3,"1001"}, {4,"00011"},
{5,"0111"}, {6,"000010"}, {7,"1011"}, {8,"00010"}, {9,"000011"},
{10,"0101"}, {11,"1010"}, {12,"0100"}, {13,"1000"}, {14,"0110"},
{15,"11"}, {16,"000000"}, {17,"000001"}, 
{18,NULL}
};

static VlcTable g_rgVlcCBPY1[] = {
{0,"01"}, {1,"1"},
{2,NULL}
};

static VlcTable g_rgVlcCBPY2[] = {
{0,"0001"}, {1,"001"}, {2,"01"}, {3,"1"},
{4,NULL}
};

static VlcTable g_rgVlcCBPY3[] = {
{0,"011"}, {1,"000001"},
{2,"00001"}, {3,"010"}, {4,"00010"}, {5,"00011"}, {6,"001"}, {7,"1"},
{8,NULL}
};

static VlcTable g_rgVlcIntraDCy[] = {
{0,"011"}, {1,"11"}, {2,"10"},
{3,"010"}, {4,"001"}, {5,"0001"}, {6,"00001"}, {7,"000001"},
{8,"0000001"}, {9,"00000001"}, {10,"000000001"}, {11,"0000000001"},
{12,"00000000001"},
{13,NULL}
};

static VlcTable g_rgVlcIntraDCc[] = {
{0,"11"}, {1,"10"}, {2,"01"}, {3,"001"}, {4,"0001"}, {5,"00001"},
{6,"000001"}, {7,"0000001"}, {8,"00000001"}, {9,"000000001"},
{10,"0000000001"}, {11,"00000000001"}, {12,"000000000001"},
{13,NULL}
};

static VlcTable g_rgVlcMbTypeBVOP[] = {
{0,"1"}, {1,"01"}, {2,"001"}, {3,"0001"},
{4,NULL}
};

static VlcTable g_rgVlcWrpPnt[] = {
{0,"00"}, {1,"010"}, {2,"011"}, {3,"100"}, {4,"101"}, {5,"110"},
{6,"1110"}, {7,"11110"}, {8,"111110"}, {9,"1111110"}, {10,"11111110"},
{11,"111111110"}, {12,"1111111110"}, {13,"11111111110"},
{14,"111111111110"},
{15,NULL}
};

static VlcTable g_rgVlcShapeMode0[] = {
{0,"1"}, {1,"000001"}, {2,"01"}, {3,"0000001"}, {4,"00001"},
{5,"0001"}, {6,"001"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode1[] = {
{0,"000001"}, {1,"001"}, {2,"01"}, {3,"0000001"}, {4,"00001"},
{5,"1"}, {6,"0001"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode2[] = {
{0,"0001"}, {1,"00001"}, {2,"1"}, {3,"000001"}, {4,"010"}, {5,"011"},
{6,"001"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode3[] = {
{0,"00001"}, {1,"000001"}, {2,"001"}, {3,"11"}, {4,"10"}, {5,"01"},
{6,"0001"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode4[] = {
{0,"00001"}, {1,"000001"}, {2,"01"}, {3,"10"}, {4,"11"}, {5,"001"},
{6,"0001"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode5[] = {
{0,"00001"}, {1,"000001"}, {2,"0001"}, {3,"0010"}, {4,"0011"},
{5,"1"}, {6,"01"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMode6[] = {
{0,"00001"}, {1,"000001"}, {2,"001"}, {3,"0000001"}, {4,"0001"},
{5,"01"}, {6,"1"},
{7,NULL}
};

static VlcTable g_rgVlcShapeMV1[] = {
{0,"0"}, {1,"10"}, {2,"110"}, {3,"1110"}, {4,"11110"}, {5,"111110"},
{6,"1111110"}, {7,"11111110"}, {8,"111111110"}, {9,"1111111110"},
{10,"11111111110"}, {11,"111111111110"}, {12,"1111111111110"},
{13,"11111111111110"}, {14,"111111111111110"},
{15,"1111111111111110"}, {16,"11111111111111110"},
{17,NULL}
};

static VlcTable g_rgVlcShapeMV2[] = {
{0,"0"}, {1,"10"}, {2,"110"}, {3,"1110"}, {4,"11110"}, {5,"111110"},
{6,"1111110"}, {7,"11111110"}, {8,"111111110"}, {9,"1111111110"},
{10,"11111111110"}, {11,"111111111110"}, {12,"1111111111110"},
{13,"11111111111110"}, {14,"111111111111110"},
{15,"1111111111111110"},
{16,NULL}
};
