/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS in the course of 
development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

#include "all.h"

Huffman book1[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                   0 */  1,     0,  0,  0,  0,  0 },
	{ /*   1:              1 0000 */  5,    16,  1,  0,  0,  0 },
	{ /*   2:              1 0001 */  5,    17, -1,  0,  0,  0 },
	{ /*   3:              1 0010 */  5,    18,  0,  0,  0, -1 },
	{ /*   4:              1 0011 */  5,    19,  0,  1,  0,  0 },
	{ /*   5:              1 0100 */  5,    20,  0,  0,  0,  1 },
	{ /*   6:              1 0101 */  5,    21,  0,  0, -1,  0 },
	{ /*   7:              1 0110 */  5,    22,  0,  0,  1,  0 },
	{ /*   8:              1 0111 */  5,    23,  0, -1,  0,  0 },
	{ /*   9:            110 0000 */  7,    96,  1, -1,  0,  0 },
	{ /*  10:            110 0001 */  7,    97, -1,  1,  0,  0 },
	{ /*  11:            110 0010 */  7,    98,  0,  0, -1,  1 },
	{ /*  12:            110 0011 */  7,    99,  0,  1, -1,  0 },
	{ /*  13:            110 0100 */  7,   100,  0, -1,  1,  0 },
	{ /*  14:            110 0101 */  7,   101,  0,  0,  1, -1 },
	{ /*  15:            110 0110 */  7,   102,  1,  1,  0,  0 },
	{ /*  16:            110 0111 */  7,   103,  0,  0, -1, -1 },
	{ /*  17:            110 1000 */  7,   104, -1, -1,  0,  0 },
	{ /*  18:            110 1001 */  7,   105,  0, -1, -1,  0 },
	{ /*  19:            110 1010 */  7,   106,  1,  0, -1,  0 },
	{ /*  20:            110 1011 */  7,   107,  0,  1,  0, -1 },
	{ /*  21:            110 1100 */  7,   108, -1,  0,  1,  0 },
	{ /*  22:            110 1101 */  7,   109,  0,  0,  1,  1 },
	{ /*  23:            110 1110 */  7,   110,  1,  0,  1,  0 },
	{ /*  24:            110 1111 */  7,   111,  0, -1,  0,  1 },
	{ /*  25:            111 0000 */  7,   112,  0,  1,  1,  0 },
	{ /*  26:            111 0001 */  7,   113,  0,  1,  0,  1 },
	{ /*  27:            111 0010 */  7,   114, -1,  0, -1,  0 },
	{ /*  28:            111 0011 */  7,   115,  1,  0,  0,  1 },
	{ /*  29:            111 0100 */  7,   116, -1,  0,  0, -1 },
	{ /*  30:            111 0101 */  7,   117,  1,  0,  0, -1 },
	{ /*  31:            111 0110 */  7,   118, -1,  0,  0,  1 },
	{ /*  32:            111 0111 */  7,   119,  0, -1,  0, -1 },
	{ /*  33:         1 1110 0000 */  9,   480,  1,  1, -1,  0 },
	{ /*  34:         1 1110 0001 */  9,   481, -1,  1, -1,  0 },
	{ /*  35:         1 1110 0010 */  9,   482,  1, -1,  1,  0 },
	{ /*  36:         1 1110 0011 */  9,   483,  0,  1,  1, -1 },
	{ /*  37:         1 1110 0100 */  9,   484,  0,  1, -1,  1 },
	{ /*  38:         1 1110 0101 */  9,   485,  0, -1,  1,  1 },
	{ /*  39:         1 1110 0110 */  9,   486,  0, -1,  1, -1 },
	{ /*  40:         1 1110 0111 */  9,   487,  1, -1, -1,  0 },
	{ /*  41:         1 1110 1000 */  9,   488,  1,  0, -1,  1 },
	{ /*  42:         1 1110 1001 */  9,   489,  0,  1, -1, -1 },
	{ /*  43:         1 1110 1010 */  9,   490, -1,  1,  1,  0 },
	{ /*  44:         1 1110 1011 */  9,   491, -1,  0,  1, -1 },
	{ /*  45:         1 1110 1100 */  9,   492, -1, -1,  1,  0 },
	{ /*  46:         1 1110 1101 */  9,   493,  0, -1, -1,  1 },
	{ /*  47:         1 1110 1110 */  9,   494,  1, -1,  0,  1 },
	{ /*  48:         1 1110 1111 */  9,   495,  1, -1,  0, -1 },
	{ /*  49:         1 1111 0000 */  9,   496, -1,  1,  0, -1 },
	{ /*  50:         1 1111 0001 */  9,   497, -1, -1, -1,  0 },
	{ /*  51:         1 1111 0010 */  9,   498,  0, -1, -1, -1 },
	{ /*  52:         1 1111 0011 */  9,   499,  0,  1,  1,  1 },
	{ /*  53:         1 1111 0100 */  9,   500,  1,  0,  1, -1 },
	{ /*  54:         1 1111 0101 */  9,   501,  1,  1,  0,  1 },
	{ /*  55:         1 1111 0110 */  9,   502, -1,  1,  0,  1 },
	{ /*  56:         1 1111 0111 */  9,   503,  1,  1,  1,  0 },
	{ /*  57:        11 1111 0000 */ 10,  1008, -1, -1,  0,  1 },
	{ /*  58:        11 1111 0001 */ 10,  1009, -1,  0, -1, -1 },
	{ /*  59:        11 1111 0010 */ 10,  1010,  1,  1,  0, -1 },
	{ /*  60:        11 1111 0011 */ 10,  1011,  1,  0, -1, -1 },
	{ /*  61:        11 1111 0100 */ 10,  1012, -1,  0, -1,  1 },
	{ /*  62:        11 1111 0101 */ 10,  1013, -1, -1,  0, -1 },
	{ /*  63:        11 1111 0110 */ 10,  1014, -1,  0,  1,  1 },
	{ /*  64:        11 1111 0111 */ 10,  1015,  1,  0,  1,  1 },
	{ /*  65:       111 1111 0000 */ 11,  2032,  1, -1,  1, -1 },
	{ /*  66:       111 1111 0001 */ 11,  2033, -1,  1, -1,  1 },
	{ /*  67:       111 1111 0010 */ 11,  2034, -1,  1,  1, -1 },
	{ /*  68:       111 1111 0011 */ 11,  2035,  1, -1, -1,  1 },
	{ /*  69:       111 1111 0100 */ 11,  2036,  1,  1,  1,  1 },
	{ /*  70:       111 1111 0101 */ 11,  2037, -1, -1,  1,  1 },
	{ /*  71:       111 1111 0110 */ 11,  2038,  1,  1, -1, -1 },
	{ /*  72:       111 1111 0111 */ 11,  2039, -1, -1,  1, -1 },
	{ /*  73:       111 1111 1000 */ 11,  2040, -1, -1, -1, -1 },
	{ /*  74:       111 1111 1001 */ 11,  2041,  1,  1, -1,  1 },
	{ /*  75:       111 1111 1010 */ 11,  2042,  1, -1,  1,  1 },
	{ /*  76:       111 1111 1011 */ 11,  2043, -1,  1,  1,  1 },
	{ /*  77:       111 1111 1100 */ 11,  2044, -1,  1, -1, -1 },
	{ /*  78:       111 1111 1101 */ 11,  2045, -1, -1, -1,  1 },
	{ /*  79:       111 1111 1110 */ 11,  2046,  1, -1, -1, -1 },
	{ /*  80:       111 1111 1111 */ 11,  2047,  1,  1,  1, -1 }
};

Huffman book2[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                 000 */  3,     0,  0,  0,  0,  0 },
	{ /*   1:                0010 */  4,     2,  1,  0,  0,  0 },
	{ /*   2:              0 0110 */  5,     6, -1,  0,  0,  0 },
	{ /*   3:              0 0111 */  5,     7,  0,  0,  0,  1 },
	{ /*   4:              0 1000 */  5,     8,  0,  0, -1,  0 },
	{ /*   5:              0 1001 */  5,     9,  0,  0,  0, -1 },
	{ /*   6:              0 1010 */  5,    10,  0, -1,  0,  0 },
	{ /*   7:              0 1011 */  5,    11,  0,  0,  1,  0 },
	{ /*   8:              0 1100 */  5,    12,  0,  1,  0,  0 },
	{ /*   9:             01 1010 */  6,    26,  0, -1,  1,  0 },
	{ /*  10:             01 1011 */  6,    27, -1,  1,  0,  0 },
	{ /*  11:             01 1100 */  6,    28,  0,  1, -1,  0 },
	{ /*  12:             01 1101 */  6,    29,  0,  0,  1, -1 },
	{ /*  13:             01 1110 */  6,    30,  0,  1,  0, -1 },
	{ /*  14:             01 1111 */  6,    31,  0,  0, -1,  1 },
	{ /*  15:             10 0000 */  6,    32, -1,  0,  0, -1 },
	{ /*  16:             10 0001 */  6,    33,  1, -1,  0,  0 },
	{ /*  17:             10 0010 */  6,    34,  1,  0, -1,  0 },
	{ /*  18:             10 0011 */  6,    35, -1, -1,  0,  0 },
	{ /*  19:             10 0100 */  6,    36,  0,  0, -1, -1 },
	{ /*  20:             10 0101 */  6,    37,  1,  0,  1,  0 },
	{ /*  21:             10 0110 */  6,    38,  1,  0,  0,  1 },
	{ /*  22:             10 0111 */  6,    39,  0, -1,  0,  1 },
	{ /*  23:             10 1000 */  6,    40, -1,  0,  1,  0 },
	{ /*  24:             10 1001 */  6,    41,  0,  1,  0,  1 },
	{ /*  25:             10 1010 */  6,    42,  0, -1, -1,  0 },
	{ /*  26:             10 1011 */  6,    43, -1,  0,  0,  1 },
	{ /*  27:             10 1100 */  6,    44,  0, -1,  0, -1 },
	{ /*  28:             10 1101 */  6,    45, -1,  0, -1,  0 },
	{ /*  29:             10 1110 */  6,    46,  1,  1,  0,  0 },
	{ /*  30:             10 1111 */  6,    47,  0,  1,  1,  0 },
	{ /*  31:             11 0000 */  6,    48,  0,  0,  1,  1 },
	{ /*  32:             11 0001 */  6,    49,  1,  0,  0, -1 },
	{ /*  33:            110 0100 */  7,   100,  0,  1, -1,  1 },
	{ /*  34:            110 0101 */  7,   101,  1,  0, -1,  1 },
	{ /*  35:            110 0110 */  7,   102, -1,  1, -1,  0 },
	{ /*  36:            110 0111 */  7,   103,  0, -1,  1, -1 },
	{ /*  37:            110 1000 */  7,   104,  1, -1,  1,  0 },
	{ /*  38:            110 1001 */  7,   105,  1,  1,  0, -1 },
	{ /*  39:            110 1010 */  7,   106,  1,  0,  1,  1 },
	{ /*  40:            110 1011 */  7,   107, -1,  1,  1,  0 },
	{ /*  41:            110 1100 */  7,   108,  0, -1, -1,  1 },
	{ /*  42:            110 1101 */  7,   109,  1,  1,  1,  0 },
	{ /*  43:            110 1110 */  7,   110, -1,  0,  1, -1 },
	{ /*  44:            110 1111 */  7,   111, -1, -1, -1,  0 },
	{ /*  45:            111 0000 */  7,   112, -1,  0, -1,  1 },
	{ /*  46:            111 0001 */  7,   113,  1, -1, -1,  0 },
	{ /*  47:            111 0010 */  7,   114,  1,  1, -1,  0 },
	{ /*  48:           1110 0110 */  8,   230,  1, -1,  0,  1 },
	{ /*  49:           1110 0111 */  8,   231, -1,  1,  0, -1 },
	{ /*  50:           1110 1000 */  8,   232, -1, -1,  1,  0 },
	{ /*  51:           1110 1001 */  8,   233, -1,  0,  1,  1 },
	{ /*  52:           1110 1010 */  8,   234, -1, -1,  0,  1 },
	{ /*  53:           1110 1011 */  8,   235, -1, -1,  0, -1 },
	{ /*  54:           1110 1100 */  8,   236,  0, -1, -1, -1 },
	{ /*  55:           1110 1101 */  8,   237,  1,  0,  1, -1 },
	{ /*  56:           1110 1110 */  8,   238,  1,  0, -1, -1 },
	{ /*  57:           1110 1111 */  8,   239,  0,  1, -1, -1 },
	{ /*  58:           1111 0000 */  8,   240,  0,  1,  1,  1 },
	{ /*  59:           1111 0001 */  8,   241, -1,  1,  0,  1 },
	{ /*  60:           1111 0010 */  8,   242, -1,  0, -1, -1 },
	{ /*  61:           1111 0011 */  8,   243,  0,  1,  1, -1 },
	{ /*  62:           1111 0100 */  8,   244,  1, -1,  0, -1 },
	{ /*  63:           1111 0101 */  8,   245,  0, -1,  1,  1 },
	{ /*  64:           1111 0110 */  8,   246,  1,  1,  0,  1 },
	{ /*  65:           1111 0111 */  8,   247,  1, -1,  1, -1 },
	{ /*  66:           1111 1000 */  8,   248, -1,  1, -1,  1 },
	{ /*  67:         1 1111 0010 */  9,   498,  1, -1, -1,  1 },
	{ /*  68:         1 1111 0011 */  9,   499, -1, -1, -1, -1 },
	{ /*  69:         1 1111 0100 */  9,   500, -1,  1,  1, -1 },
	{ /*  70:         1 1111 0101 */  9,   501, -1,  1,  1,  1 },
	{ /*  71:         1 1111 0110 */  9,   502,  1,  1,  1,  1 },
	{ /*  72:         1 1111 0111 */  9,   503, -1, -1,  1, -1 },
	{ /*  73:         1 1111 1000 */  9,   504,  1, -1,  1,  1 },
	{ /*  74:         1 1111 1001 */  9,   505, -1,  1, -1, -1 },
	{ /*  75:         1 1111 1010 */  9,   506, -1, -1,  1,  1 },
	{ /*  76:         1 1111 1011 */  9,   507,  1,  1, -1, -1 },
	{ /*  77:         1 1111 1100 */  9,   508,  1, -1, -1, -1 },
	{ /*  78:         1 1111 1101 */  9,   509, -1, -1, -1,  1 },
	{ /*  79:         1 1111 1110 */  9,   510,  1,  1, -1,  1 },
	{ /*  80:         1 1111 1111 */  9,   511,  1,  1,  1, -1 }
};

Huffman book3[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                   0 */  1,     0,  0,  0,  0,  0 },
	{ /*   1:                1000 */  4,     8,  1,  0,  0,  0 },
	{ /*   2:                1001 */  4,     9,  0,  0,  0,  1 },
	{ /*   3:                1010 */  4,    10,  0,  1,  0,  0 },
	{ /*   4:                1011 */  4,    11,  0,  0,  1,  0 },
	{ /*   5:              1 1000 */  5,    24,  1,  1,  0,  0 },
	{ /*   6:              1 1001 */  5,    25,  0,  0,  1,  1 },
	{ /*   7:             11 0100 */  6,    52,  0,  1,  1,  0 },
	{ /*   8:             11 0101 */  6,    53,  0,  1,  0,  1 },
	{ /*   9:             11 0110 */  6,    54,  1,  0,  1,  0 },
	{ /*  10:             11 0111 */  6,    55,  0,  1,  1,  1 },
	{ /*  11:             11 1000 */  6,    56,  1,  0,  0,  1 },
	{ /*  12:             11 1001 */  6,    57,  1,  1,  1,  0 },
	{ /*  13:            111 0100 */  7,   116,  1,  1,  1,  1 },
	{ /*  14:            111 0101 */  7,   117,  1,  0,  1,  1 },
	{ /*  15:            111 0110 */  7,   118,  1,  1,  0,  1 },
	{ /*  16:           1110 1110 */  8,   238,  2,  0,  0,  0 },
	{ /*  17:           1110 1111 */  8,   239,  0,  0,  0,  2 },
	{ /*  18:           1111 0000 */  8,   240,  0,  0,  1,  2 },
	{ /*  19:           1111 0001 */  8,   241,  2,  1,  0,  0 },
	{ /*  20:           1111 0010 */  8,   242,  1,  2,  1,  0 },
	{ /*  21:         1 1110 0110 */  9,   486,  0,  0,  2,  1 },
	{ /*  22:         1 1110 0111 */  9,   487,  0,  1,  2,  1 },
	{ /*  23:         1 1110 1000 */  9,   488,  1,  2,  0,  0 },
	{ /*  24:         1 1110 1001 */  9,   489,  0,  1,  1,  2 },
	{ /*  25:         1 1110 1010 */  9,   490,  2,  1,  1,  0 },
	{ /*  26:         1 1110 1011 */  9,   491,  0,  0,  2,  0 },
	{ /*  27:         1 1110 1100 */  9,   492,  0,  2,  1,  0 },
	{ /*  28:         1 1110 1101 */  9,   493,  0,  1,  2,  0 },
	{ /*  29:         1 1110 1110 */  9,   494,  0,  2,  0,  0 },
	{ /*  30:         1 1110 1111 */  9,   495,  0,  1,  0,  2 },
	{ /*  31:         1 1111 0000 */  9,   496,  2,  0,  1,  0 },
	{ /*  32:         1 1111 0001 */  9,   497,  1,  2,  1,  1 },
	{ /*  33:         1 1111 0010 */  9,   498,  0,  2,  1,  1 },
	{ /*  34:         1 1111 0011 */  9,   499,  1,  1,  2,  0 },
	{ /*  35:         1 1111 0100 */  9,   500,  1,  1,  2,  1 },
	{ /*  36:        11 1110 1010 */ 10,  1002,  1,  2,  0,  1 },
	{ /*  37:        11 1110 1011 */ 10,  1003,  1,  0,  2,  0 },
	{ /*  38:        11 1110 1100 */ 10,  1004,  1,  0,  2,  1 },
	{ /*  39:        11 1110 1101 */ 10,  1005,  0,  2,  0,  1 },
	{ /*  40:        11 1110 1110 */ 10,  1006,  2,  1,  1,  1 },
	{ /*  41:        11 1110 1111 */ 10,  1007,  1,  1,  1,  2 },
	{ /*  42:        11 1111 0000 */ 10,  1008,  2,  1,  0,  1 },
	{ /*  43:        11 1111 0001 */ 10,  1009,  1,  0,  1,  2 },
	{ /*  44:        11 1111 0010 */ 10,  1010,  0,  0,  2,  2 },
	{ /*  45:        11 1111 0011 */ 10,  1011,  0,  1,  2,  2 },
	{ /*  46:        11 1111 0100 */ 10,  1012,  2,  2,  1,  0 },
	{ /*  47:        11 1111 0101 */ 10,  1013,  1,  2,  2,  0 },
	{ /*  48:        11 1111 0110 */ 10,  1014,  1,  0,  0,  2 },
	{ /*  49:        11 1111 0111 */ 10,  1015,  2,  0,  0,  1 },
	{ /*  50:        11 1111 1000 */ 10,  1016,  0,  2,  2,  1 },
	{ /*  51:       111 1111 0010 */ 11,  2034,  2,  2,  0,  0 },
	{ /*  52:       111 1111 0011 */ 11,  2035,  1,  2,  2,  1 },
	{ /*  53:       111 1111 0100 */ 11,  2036,  1,  1,  0,  2 },
	{ /*  54:       111 1111 0101 */ 11,  2037,  2,  0,  1,  1 },
	{ /*  55:       111 1111 0110 */ 11,  2038,  1,  1,  2,  2 },
	{ /*  56:       111 1111 0111 */ 11,  2039,  2,  2,  1,  1 },
	{ /*  57:       111 1111 1000 */ 11,  2040,  0,  2,  2,  0 },
	{ /*  58:       111 1111 1001 */ 11,  2041,  0,  2,  1,  2 },
	{ /*  59:      1111 1111 0100 */ 12,  4084,  1,  0,  2,  2 },
	{ /*  60:      1111 1111 0101 */ 12,  4085,  2,  2,  0,  1 },
	{ /*  61:      1111 1111 0110 */ 12,  4086,  2,  1,  2,  0 },
	{ /*  62:      1111 1111 0111 */ 12,  4087,  2,  2,  2,  0 },
	{ /*  63:      1111 1111 1000 */ 12,  4088,  0,  2,  2,  2 },
	{ /*  64:      1111 1111 1001 */ 12,  4089,  2,  2,  2,  1 },
	{ /*  65:      1111 1111 1010 */ 12,  4090,  2,  1,  2,  1 },
	{ /*  66:      1111 1111 1011 */ 12,  4091,  1,  2,  1,  2 },
	{ /*  67:      1111 1111 1100 */ 12,  4092,  1,  2,  2,  2 },
	{ /*  68:    1 1111 1111 1010 */ 13,  8186,  0,  2,  0,  2 },
	{ /*  69:    1 1111 1111 1011 */ 13,  8187,  2,  0,  2,  0 },
	{ /*  70:    1 1111 1111 1100 */ 13,  8188,  1,  2,  0,  2 },
	{ /*  71:   11 1111 1111 1010 */ 14, 16378,  2,  0,  2,  1 },
	{ /*  72:   11 1111 1111 1011 */ 14, 16379,  2,  1,  1,  2 },
	{ /*  73:   11 1111 1111 1100 */ 14, 16380,  2,  1,  0,  2 },
	{ /*  74:  111 1111 1111 1010 */ 15, 32762,  2,  2,  2,  2 },
	{ /*  75:  111 1111 1111 1011 */ 15, 32763,  2,  2,  1,  2 },
	{ /*  76:  111 1111 1111 1100 */ 15, 32764,  2,  1,  2,  2 },
	{ /*  77:  111 1111 1111 1101 */ 15, 32765,  2,  0,  1,  2 },
	{ /*  78:  111 1111 1111 1110 */ 15, 32766,  2,  0,  0,  2 },
	{ /*  79: 1111 1111 1111 1110 */ 16, 65534,  2,  2,  0,  2 },
	{ /*  80: 1111 1111 1111 1111 */ 16, 65535,  2,  0,  2,  2 }
};

Huffman book4[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                0000 */  4,     0,  1,  1,  1,  1 },
	{ /*   1:                0001 */  4,     1,  0,  1,  1,  1 },
	{ /*   2:                0010 */  4,     2,  1,  1,  0,  1 },
	{ /*   3:                0011 */  4,     3,  1,  1,  1,  0 },
	{ /*   4:                0100 */  4,     4,  1,  0,  1,  1 },
	{ /*   5:                0101 */  4,     5,  1,  0,  0,  0 },
	{ /*   6:                0110 */  4,     6,  1,  1,  0,  0 },
	{ /*   7:                0111 */  4,     7,  0,  0,  0,  0 },
	{ /*   8:                1000 */  4,     8,  0,  0,  1,  1 },
	{ /*   9:                1001 */  4,     9,  1,  0,  1,  0 },
	{ /*  10:              1 0100 */  5,    20,  1,  0,  0,  1 },
	{ /*  11:              1 0101 */  5,    21,  0,  1,  1,  0 },
	{ /*  12:              1 0110 */  5,    22,  0,  0,  0,  1 },
	{ /*  13:              1 0111 */  5,    23,  0,  1,  0,  1 },
	{ /*  14:              1 1000 */  5,    24,  0,  0,  1,  0 },
	{ /*  15:              1 1001 */  5,    25,  0,  1,  0,  0 },
	{ /*  16:            110 1000 */  7,   104,  2,  1,  1,  1 },
	{ /*  17:            110 1001 */  7,   105,  1,  1,  2,  1 },
	{ /*  18:            110 1010 */  7,   106,  1,  2,  1,  1 },
	{ /*  19:            110 1011 */  7,   107,  1,  1,  1,  2 },
	{ /*  20:            110 1100 */  7,   108,  2,  1,  1,  0 },
	{ /*  21:            110 1101 */  7,   109,  2,  1,  0,  1 },
	{ /*  22:            110 1110 */  7,   110,  1,  2,  1,  0 },
	{ /*  23:            110 1111 */  7,   111,  2,  0,  1,  1 },
	{ /*  24:            111 0000 */  7,   112,  0,  1,  2,  1 },
	{ /*  25:           1110 0010 */  8,   226,  0,  1,  1,  2 },
	{ /*  26:           1110 0011 */  8,   227,  1,  1,  2,  0 },
	{ /*  27:           1110 0100 */  8,   228,  0,  2,  1,  1 },
	{ /*  28:           1110 0101 */  8,   229,  1,  0,  1,  2 },
	{ /*  29:           1110 0110 */  8,   230,  1,  2,  0,  1 },
	{ /*  30:           1110 0111 */  8,   231,  1,  1,  0,  2 },
	{ /*  31:           1110 1000 */  8,   232,  1,  0,  2,  1 },
	{ /*  32:           1110 1001 */  8,   233,  2,  1,  0,  0 },
	{ /*  33:           1110 1010 */  8,   234,  2,  0,  1,  0 },
	{ /*  34:           1110 1011 */  8,   235,  1,  2,  0,  0 },
	{ /*  35:           1110 1100 */  8,   236,  2,  0,  0,  1 },
	{ /*  36:           1110 1101 */  8,   237,  0,  1,  0,  2 },
	{ /*  37:           1110 1110 */  8,   238,  0,  2,  1,  0 },
	{ /*  38:           1110 1111 */  8,   239,  0,  0,  1,  2 },
	{ /*  39:           1111 0000 */  8,   240,  0,  1,  2,  0 },
	{ /*  40:           1111 0001 */  8,   241,  0,  2,  0,  1 },
	{ /*  41:           1111 0010 */  8,   242,  1,  0,  0,  2 },
	{ /*  42:           1111 0011 */  8,   243,  0,  0,  2,  1 },
	{ /*  43:           1111 0100 */  8,   244,  1,  0,  2,  0 },
	{ /*  44:           1111 0101 */  8,   245,  2,  0,  0,  0 },
	{ /*  45:           1111 0110 */  8,   246,  0,  0,  0,  2 },
	{ /*  46:         1 1110 1110 */  9,   494,  0,  2,  0,  0 },
	{ /*  47:         1 1110 1111 */  9,   495,  0,  0,  2,  0 },
	{ /*  48:         1 1111 0000 */  9,   496,  1,  2,  2,  1 },
	{ /*  49:         1 1111 0001 */  9,   497,  2,  2,  1,  1 },
	{ /*  50:         1 1111 0010 */  9,   498,  2,  1,  2,  1 },
	{ /*  51:         1 1111 0011 */  9,   499,  1,  1,  2,  2 },
	{ /*  52:         1 1111 0100 */  9,   500,  1,  2,  1,  2 },
	{ /*  53:         1 1111 0101 */  9,   501,  2,  1,  1,  2 },
	{ /*  54:        11 1110 1100 */ 10,  1004,  1,  2,  2,  0 },
	{ /*  55:        11 1110 1101 */ 10,  1005,  2,  2,  1,  0 },
	{ /*  56:        11 1110 1110 */ 10,  1006,  2,  1,  2,  0 },
	{ /*  57:        11 1110 1111 */ 10,  1007,  0,  2,  2,  1 },
	{ /*  58:        11 1111 0000 */ 10,  1008,  0,  1,  2,  2 },
	{ /*  59:        11 1111 0001 */ 10,  1009,  2,  2,  0,  1 },
	{ /*  60:        11 1111 0010 */ 10,  1010,  0,  2,  1,  2 },
	{ /*  61:        11 1111 0011 */ 10,  1011,  2,  0,  2,  1 },
	{ /*  62:        11 1111 0100 */ 10,  1012,  1,  0,  2,  2 },
	{ /*  63:        11 1111 0101 */ 10,  1013,  2,  2,  2,  1 },
	{ /*  64:        11 1111 0110 */ 10,  1014,  1,  2,  0,  2 },
	{ /*  65:        11 1111 0111 */ 10,  1015,  2,  0,  1,  2 },
	{ /*  66:        11 1111 1000 */ 10,  1016,  2,  1,  0,  2 },
	{ /*  67:        11 1111 1001 */ 10,  1017,  1,  2,  2,  2 },
	{ /*  68:       111 1111 0100 */ 11,  2036,  2,  1,  2,  2 },
	{ /*  69:       111 1111 0101 */ 11,  2037,  2,  2,  1,  2 },
	{ /*  70:       111 1111 0110 */ 11,  2038,  0,  2,  2,  0 },
	{ /*  71:       111 1111 0111 */ 11,  2039,  2,  2,  0,  0 },
	{ /*  72:       111 1111 1000 */ 11,  2040,  0,  0,  2,  2 },
	{ /*  73:       111 1111 1001 */ 11,  2041,  2,  0,  2,  0 },
	{ /*  74:       111 1111 1010 */ 11,  2042,  0,  2,  0,  2 },
	{ /*  75:       111 1111 1011 */ 11,  2043,  2,  0,  0,  2 },
	{ /*  76:       111 1111 1100 */ 11,  2044,  2,  2,  2,  2 },
	{ /*  77:       111 1111 1101 */ 11,  2045,  0,  2,  2,  2 },
	{ /*  78:       111 1111 1110 */ 11,  2046,  2,  2,  2,  0 },
	{ /*  79:      1111 1111 1110 */ 12,  4094,  2,  2,  0,  2 },
	{ /*  80:      1111 1111 1111 */ 12,  4095,  2,  0,  2,  2 }
};

Huffman book5[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                   0 */  1,     0,  0,  0,  0,  0 },
	{ /*   1:                1000 */  4,     8, -1,  0,  0,  0 },
	{ /*   2:                1001 */  4,     9,  1,  0,  0,  0 },
	{ /*   3:                1010 */  4,    10,  0,  1,  0,  0 },
	{ /*   4:                1011 */  4,    11,  0, -1,  0,  0 },
	{ /*   5:              1 1000 */  5,    24,  1, -1,  0,  0 },
	{ /*   6:              1 1001 */  5,    25, -1,  1,  0,  0 },
	{ /*   7:              1 1010 */  5,    26, -1, -1,  0,  0 },
	{ /*   8:              1 1011 */  5,    27,  1,  1,  0,  0 },
	{ /*   9:            111 0000 */  7,   112, -2,  0,  0,  0 },
	{ /*  10:            111 0001 */  7,   113,  0,  2,  0,  0 },
	{ /*  11:            111 0010 */  7,   114,  2,  0,  0,  0 },
	{ /*  12:            111 0011 */  7,   115,  0, -2,  0,  0 },
	{ /*  13:           1110 1000 */  8,   232, -2, -1,  0,  0 },
	{ /*  14:           1110 1001 */  8,   233,  2,  1,  0,  0 },
	{ /*  15:           1110 1010 */  8,   234, -1, -2,  0,  0 },
	{ /*  16:           1110 1011 */  8,   235,  1,  2,  0,  0 },
	{ /*  17:           1110 1100 */  8,   236, -2,  1,  0,  0 },
	{ /*  18:           1110 1101 */  8,   237,  2, -1,  0,  0 },
	{ /*  19:           1110 1110 */  8,   238, -1,  2,  0,  0 },
	{ /*  20:           1110 1111 */  8,   239,  1, -2,  0,  0 },
	{ /*  21:           1111 0000 */  8,   240, -3,  0,  0,  0 },
	{ /*  22:           1111 0001 */  8,   241,  3,  0,  0,  0 },
	{ /*  23:           1111 0010 */  8,   242,  0, -3,  0,  0 },
	{ /*  24:           1111 0011 */  8,   243,  0,  3,  0,  0 },
	{ /*  25:         1 1110 1000 */  9,   488, -3, -1,  0,  0 },
	{ /*  26:         1 1110 1001 */  9,   489,  1,  3,  0,  0 },
	{ /*  27:         1 1110 1010 */  9,   490,  3,  1,  0,  0 },
	{ /*  28:         1 1110 1011 */  9,   491, -1, -3,  0,  0 },
	{ /*  29:         1 1110 1100 */  9,   492, -3,  1,  0,  0 },
	{ /*  30:         1 1110 1101 */  9,   493,  3, -1,  0,  0 },
	{ /*  31:         1 1110 1110 */  9,   494,  1, -3,  0,  0 },
	{ /*  32:         1 1110 1111 */  9,   495, -1,  3,  0,  0 },
	{ /*  33:         1 1111 0000 */  9,   496, -2,  2,  0,  0 },
	{ /*  34:         1 1111 0001 */  9,   497,  2,  2,  0,  0 },
	{ /*  35:         1 1111 0010 */  9,   498, -2, -2,  0,  0 },
	{ /*  36:         1 1111 0011 */  9,   499,  2, -2,  0,  0 },
	{ /*  37:        11 1110 1000 */ 10,  1000, -3, -2,  0,  0 },
	{ /*  38:        11 1110 1001 */ 10,  1001,  3, -2,  0,  0 },
	{ /*  39:        11 1110 1010 */ 10,  1002, -2,  3,  0,  0 },
	{ /*  40:        11 1110 1011 */ 10,  1003,  2, -3,  0,  0 },
	{ /*  41:        11 1110 1100 */ 10,  1004,  3,  2,  0,  0 },
	{ /*  42:        11 1110 1101 */ 10,  1005,  2,  3,  0,  0 },
	{ /*  43:        11 1110 1110 */ 10,  1006, -3,  2,  0,  0 },
	{ /*  44:        11 1110 1111 */ 10,  1007, -2, -3,  0,  0 },
	{ /*  45:        11 1111 0000 */ 10,  1008,  0, -4,  0,  0 },
	{ /*  46:        11 1111 0001 */ 10,  1009, -4,  0,  0,  0 },
	{ /*  47:        11 1111 0010 */ 10,  1010,  4,  1,  0,  0 },
	{ /*  48:        11 1111 0011 */ 10,  1011,  4,  0,  0,  0 },
	{ /*  49:       111 1110 1000 */ 11,  2024, -4, -1,  0,  0 },
	{ /*  50:       111 1110 1001 */ 11,  2025,  0,  4,  0,  0 },
	{ /*  51:       111 1110 1010 */ 11,  2026,  4, -1,  0,  0 },
	{ /*  52:       111 1110 1011 */ 11,  2027, -1, -4,  0,  0 },
	{ /*  53:       111 1110 1100 */ 11,  2028,  1,  4,  0,  0 },
	{ /*  54:       111 1110 1101 */ 11,  2029, -1,  4,  0,  0 },
	{ /*  55:       111 1110 1110 */ 11,  2030, -4,  1,  0,  0 },
	{ /*  56:       111 1110 1111 */ 11,  2031,  1, -4,  0,  0 },
	{ /*  57:       111 1111 0000 */ 11,  2032,  3, -3,  0,  0 },
	{ /*  58:       111 1111 0001 */ 11,  2033, -3, -3,  0,  0 },
	{ /*  59:       111 1111 0010 */ 11,  2034, -3,  3,  0,  0 },
	{ /*  60:       111 1111 0011 */ 11,  2035, -2,  4,  0,  0 },
	{ /*  61:       111 1111 0100 */ 11,  2036, -4, -2,  0,  0 },
	{ /*  62:       111 1111 0101 */ 11,  2037,  4,  2,  0,  0 },
	{ /*  63:       111 1111 0110 */ 11,  2038,  2, -4,  0,  0 },
	{ /*  64:       111 1111 0111 */ 11,  2039,  2,  4,  0,  0 },
	{ /*  65:       111 1111 1000 */ 11,  2040,  3,  3,  0,  0 },
	{ /*  66:       111 1111 1001 */ 11,  2041, -4,  2,  0,  0 },
	{ /*  67:      1111 1111 0100 */ 12,  4084, -2, -4,  0,  0 },
	{ /*  68:      1111 1111 0101 */ 12,  4085,  4, -2,  0,  0 },
	{ /*  69:      1111 1111 0110 */ 12,  4086,  3, -4,  0,  0 },
	{ /*  70:      1111 1111 0111 */ 12,  4087, -4, -3,  0,  0 },
	{ /*  71:      1111 1111 1000 */ 12,  4088, -4,  3,  0,  0 },
	{ /*  72:      1111 1111 1001 */ 12,  4089,  3,  4,  0,  0 },
	{ /*  73:      1111 1111 1010 */ 12,  4090, -3,  4,  0,  0 },
	{ /*  74:      1111 1111 1011 */ 12,  4091,  4,  3,  0,  0 },
	{ /*  75:      1111 1111 1100 */ 12,  4092,  4, -3,  0,  0 },
	{ /*  76:      1111 1111 1101 */ 12,  4093, -3, -4,  0,  0 },
	{ /*  77:    1 1111 1111 1100 */ 13,  8188,  4, -4,  0,  0 },
	{ /*  78:    1 1111 1111 1101 */ 13,  8189, -4,  4,  0,  0 },
	{ /*  79:    1 1111 1111 1110 */ 13,  8190,  4,  4,  0,  0 },
	{ /*  80:    1 1111 1111 1111 */ 13,  8191, -4, -4,  0,  0 }
};

Huffman book6[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                0000 */  4,     0,  0,  0,  0,  0 },
	{ /*   1:                0001 */  4,     1,  1,  0,  0,  0 },
	{ /*   2:                0010 */  4,     2,  0, -1,  0,  0 },
	{ /*   3:                0011 */  4,     3,  0,  1,  0,  0 },
	{ /*   4:                0100 */  4,     4, -1,  0,  0,  0 },
	{ /*   5:                0101 */  4,     5,  1,  1,  0,  0 },
	{ /*   6:                0110 */  4,     6, -1,  1,  0,  0 },
	{ /*   7:                0111 */  4,     7,  1, -1,  0,  0 },
	{ /*   8:                1000 */  4,     8, -1, -1,  0,  0 },
	{ /*   9:             10 0100 */  6,    36,  2, -1,  0,  0 },
	{ /*  10:             10 0101 */  6,    37,  2,  1,  0,  0 },
	{ /*  11:             10 0110 */  6,    38, -2,  1,  0,  0 },
	{ /*  12:             10 0111 */  6,    39, -2, -1,  0,  0 },
	{ /*  13:             10 1000 */  6,    40, -2,  0,  0,  0 },
	{ /*  14:             10 1001 */  6,    41, -1,  2,  0,  0 },
	{ /*  15:             10 1010 */  6,    42,  2,  0,  0,  0 },
	{ /*  16:             10 1011 */  6,    43,  1, -2,  0,  0 },
	{ /*  17:             10 1100 */  6,    44,  1,  2,  0,  0 },
	{ /*  18:             10 1101 */  6,    45,  0, -2,  0,  0 },
	{ /*  19:             10 1110 */  6,    46, -1, -2,  0,  0 },
	{ /*  20:             10 1111 */  6,    47,  0,  2,  0,  0 },
	{ /*  21:             11 0000 */  6,    48,  2, -2,  0,  0 },
	{ /*  22:             11 0001 */  6,    49, -2,  2,  0,  0 },
	{ /*  23:             11 0010 */  6,    50, -2, -2,  0,  0 },
	{ /*  24:             11 0011 */  6,    51,  2,  2,  0,  0 },
	{ /*  25:            110 1000 */  7,   104, -3,  1,  0,  0 },
	{ /*  26:            110 1001 */  7,   105,  3,  1,  0,  0 },
	{ /*  27:            110 1010 */  7,   106,  3, -1,  0,  0 },
	{ /*  28:            110 1011 */  7,   107, -1,  3,  0,  0 },
	{ /*  29:            110 1100 */  7,   108, -3, -1,  0,  0 },
	{ /*  30:            110 1101 */  7,   109,  1,  3,  0,  0 },
	{ /*  31:            110 1110 */  7,   110,  1, -3,  0,  0 },
	{ /*  32:            110 1111 */  7,   111, -1, -3,  0,  0 },
	{ /*  33:            111 0000 */  7,   112,  3,  0,  0,  0 },
	{ /*  34:            111 0001 */  7,   113, -3,  0,  0,  0 },
	{ /*  35:            111 0010 */  7,   114,  0, -3,  0,  0 },
	{ /*  36:            111 0011 */  7,   115,  0,  3,  0,  0 },
	{ /*  37:            111 0100 */  7,   116,  3,  2,  0,  0 },
	{ /*  38:           1110 1010 */  8,   234, -3, -2,  0,  0 },
	{ /*  39:           1110 1011 */  8,   235, -2,  3,  0,  0 },
	{ /*  40:           1110 1100 */  8,   236,  2,  3,  0,  0 },
	{ /*  41:           1110 1101 */  8,   237,  3, -2,  0,  0 },
	{ /*  42:           1110 1110 */  8,   238,  2, -3,  0,  0 },
	{ /*  43:           1110 1111 */  8,   239, -2, -3,  0,  0 },
	{ /*  44:           1111 0000 */  8,   240, -3,  2,  0,  0 },
	{ /*  45:           1111 0001 */  8,   241,  3,  3,  0,  0 },
	{ /*  46:         1 1110 0100 */  9,   484,  3, -3,  0,  0 },
	{ /*  47:         1 1110 0101 */  9,   485, -3, -3,  0,  0 },
	{ /*  48:         1 1110 0110 */  9,   486, -3,  3,  0,  0 },
	{ /*  49:         1 1110 0111 */  9,   487,  1, -4,  0,  0 },
	{ /*  50:         1 1110 1000 */  9,   488, -1, -4,  0,  0 },
	{ /*  51:         1 1110 1001 */  9,   489,  4,  1,  0,  0 },
	{ /*  52:         1 1110 1010 */  9,   490, -4,  1,  0,  0 },
	{ /*  53:         1 1110 1011 */  9,   491, -4, -1,  0,  0 },
	{ /*  54:         1 1110 1100 */  9,   492,  1,  4,  0,  0 },
	{ /*  55:         1 1110 1101 */  9,   493,  4, -1,  0,  0 },
	{ /*  56:         1 1110 1110 */  9,   494, -1,  4,  0,  0 },
	{ /*  57:         1 1110 1111 */  9,   495,  0, -4,  0,  0 },
	{ /*  58:         1 1111 0000 */  9,   496, -4,  2,  0,  0 },
	{ /*  59:         1 1111 0001 */  9,   497, -4, -2,  0,  0 },
	{ /*  60:         1 1111 0010 */  9,   498,  2,  4,  0,  0 },
	{ /*  61:         1 1111 0011 */  9,   499, -2, -4,  0,  0 },
	{ /*  62:         1 1111 0100 */  9,   500, -4,  0,  0,  0 },
	{ /*  63:         1 1111 0101 */  9,   501,  4,  2,  0,  0 },
	{ /*  64:         1 1111 0110 */  9,   502,  4, -2,  0,  0 },
	{ /*  65:         1 1111 0111 */  9,   503, -2,  4,  0,  0 },
	{ /*  66:         1 1111 1000 */  9,   504,  4,  0,  0,  0 },
	{ /*  67:         1 1111 1001 */  9,   505,  2, -4,  0,  0 },
	{ /*  68:         1 1111 1010 */  9,   506,  0,  4,  0,  0 },
	{ /*  69:        11 1111 0110 */ 10,  1014, -3, -4,  0,  0 },
	{ /*  70:        11 1111 0111 */ 10,  1015, -3,  4,  0,  0 },
	{ /*  71:        11 1111 1000 */ 10,  1016,  3, -4,  0,  0 },
	{ /*  72:        11 1111 1001 */ 10,  1017,  4, -3,  0,  0 },
	{ /*  73:        11 1111 1010 */ 10,  1018,  3,  4,  0,  0 },
	{ /*  74:        11 1111 1011 */ 10,  1019,  4,  3,  0,  0 },
	{ /*  75:        11 1111 1100 */ 10,  1020, -4,  3,  0,  0 },
	{ /*  76:        11 1111 1101 */ 10,  1021, -4, -3,  0,  0 },
	{ /*  77:       111 1111 1100 */ 11,  2044,  4,  4,  0,  0 },
	{ /*  78:       111 1111 1101 */ 11,  2045, -4,  4,  0,  0 },
	{ /*  79:       111 1111 1110 */ 11,  2046, -4, -4,  0,  0 },
	{ /*  80:       111 1111 1111 */ 11,  2047,  4, -4,  0,  0 }
};

Huffman book7[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                   0 */  1,     0,  0,  0,  0,  0 },
	{ /*   1:                 100 */  3,     4,  1,  0,  0,  0 },
	{ /*   2:                 101 */  3,     5,  0,  1,  0,  0 },
	{ /*   3:                1100 */  4,    12,  1,  1,  0,  0 },
	{ /*   4:             11 0100 */  6,    52,  2,  1,  0,  0 },
	{ /*   5:             11 0101 */  6,    53,  1,  2,  0,  0 },
	{ /*   6:             11 0110 */  6,    54,  2,  0,  0,  0 },
	{ /*   7:             11 0111 */  6,    55,  0,  2,  0,  0 },
	{ /*   8:            111 0000 */  7,   112,  3,  1,  0,  0 },
	{ /*   9:            111 0001 */  7,   113,  1,  3,  0,  0 },
	{ /*  10:            111 0010 */  7,   114,  2,  2,  0,  0 },
	{ /*  11:            111 0011 */  7,   115,  3,  0,  0,  0 },
	{ /*  12:            111 0100 */  7,   116,  0,  3,  0,  0 },
	{ /*  13:           1110 1010 */  8,   234,  2,  3,  0,  0 },
	{ /*  14:           1110 1011 */  8,   235,  3,  2,  0,  0 },
	{ /*  15:           1110 1100 */  8,   236,  1,  4,  0,  0 },
	{ /*  16:           1110 1101 */  8,   237,  4,  1,  0,  0 },
	{ /*  17:           1110 1110 */  8,   238,  1,  5,  0,  0 },
	{ /*  18:           1110 1111 */  8,   239,  5,  1,  0,  0 },
	{ /*  19:           1111 0000 */  8,   240,  3,  3,  0,  0 },
	{ /*  20:           1111 0001 */  8,   241,  2,  4,  0,  0 },
	{ /*  21:           1111 0010 */  8,   242,  0,  4,  0,  0 },
	{ /*  22:           1111 0011 */  8,   243,  4,  0,  0,  0 },
	{ /*  23:         1 1110 1000 */  9,   488,  4,  2,  0,  0 },
	{ /*  24:         1 1110 1001 */  9,   489,  2,  5,  0,  0 },
	{ /*  25:         1 1110 1010 */  9,   490,  5,  2,  0,  0 },
	{ /*  26:         1 1110 1011 */  9,   491,  0,  5,  0,  0 },
	{ /*  27:         1 1110 1100 */  9,   492,  6,  1,  0,  0 },
	{ /*  28:         1 1110 1101 */  9,   493,  5,  0,  0,  0 },
	{ /*  29:         1 1110 1110 */  9,   494,  1,  6,  0,  0 },
	{ /*  30:         1 1110 1111 */  9,   495,  4,  3,  0,  0 },
	{ /*  31:         1 1111 0000 */  9,   496,  3,  5,  0,  0 },
	{ /*  32:         1 1111 0001 */  9,   497,  3,  4,  0,  0 },
	{ /*  33:         1 1111 0010 */  9,   498,  5,  3,  0,  0 },
	{ /*  34:         1 1111 0011 */  9,   499,  2,  6,  0,  0 },
	{ /*  35:         1 1111 0100 */  9,   500,  6,  2,  0,  0 },
	{ /*  36:         1 1111 0101 */  9,   501,  1,  7,  0,  0 },
	{ /*  37:        11 1110 1100 */ 10,  1004,  3,  6,  0,  0 },
	{ /*  38:        11 1110 1101 */ 10,  1005,  0,  6,  0,  0 },
	{ /*  39:        11 1110 1110 */ 10,  1006,  6,  0,  0,  0 },
	{ /*  40:        11 1110 1111 */ 10,  1007,  4,  4,  0,  0 },
	{ /*  41:        11 1111 0000 */ 10,  1008,  7,  1,  0,  0 },
	{ /*  42:        11 1111 0001 */ 10,  1009,  4,  5,  0,  0 },
	{ /*  43:        11 1111 0010 */ 10,  1010,  7,  2,  0,  0 },
	{ /*  44:        11 1111 0011 */ 10,  1011,  5,  4,  0,  0 },
	{ /*  45:        11 1111 0100 */ 10,  1012,  6,  3,  0,  0 },
	{ /*  46:        11 1111 0101 */ 10,  1013,  2,  7,  0,  0 },
	{ /*  47:        11 1111 0110 */ 10,  1014,  7,  3,  0,  0 },
	{ /*  48:        11 1111 0111 */ 10,  1015,  6,  4,  0,  0 },
	{ /*  49:        11 1111 1000 */ 10,  1016,  5,  5,  0,  0 },
	{ /*  50:        11 1111 1001 */ 10,  1017,  4,  6,  0,  0 },
	{ /*  51:        11 1111 1010 */ 10,  1018,  3,  7,  0,  0 },
	{ /*  52:       111 1111 0110 */ 11,  2038,  7,  0,  0,  0 },
	{ /*  53:       111 1111 0111 */ 11,  2039,  0,  7,  0,  0 },
	{ /*  54:       111 1111 1000 */ 11,  2040,  6,  5,  0,  0 },
	{ /*  55:       111 1111 1001 */ 11,  2041,  5,  6,  0,  0 },
	{ /*  56:       111 1111 1010 */ 11,  2042,  7,  4,  0,  0 },
	{ /*  57:       111 1111 1011 */ 11,  2043,  4,  7,  0,  0 },
	{ /*  58:       111 1111 1100 */ 11,  2044,  5,  7,  0,  0 },
	{ /*  59:       111 1111 1101 */ 11,  2045,  7,  5,  0,  0 },
	{ /*  60:      1111 1111 1100 */ 12,  4092,  7,  6,  0,  0 },
	{ /*  61:      1111 1111 1101 */ 12,  4093,  6,  6,  0,  0 },
	{ /*  62:      1111 1111 1110 */ 12,  4094,  6,  7,  0,  0 },
	{ /*  63:      1111 1111 1111 */ 12,  4095,  7,  7,  0,  0 }
};

Huffman book8[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                 000 */  3,     0,  1,  1,  0,  0 },
	{ /*   1:                0010 */  4,     2,  2,  1,  0,  0 },
	{ /*   2:                0011 */  4,     3,  1,  0,  0,  0 },
	{ /*   3:                0100 */  4,     4,  1,  2,  0,  0 },
	{ /*   4:                0101 */  4,     5,  0,  1,  0,  0 },
	{ /*   5:                0110 */  4,     6,  2,  2,  0,  0 },
	{ /*   6:              0 1110 */  5,    14,  0,  0,  0,  0 },
	{ /*   7:              0 1111 */  5,    15,  2,  0,  0,  0 },
	{ /*   8:              1 0000 */  5,    16,  0,  2,  0,  0 },
	{ /*   9:              1 0001 */  5,    17,  3,  1,  0,  0 },
	{ /*  10:              1 0010 */  5,    18,  1,  3,  0,  0 },
	{ /*  11:              1 0011 */  5,    19,  3,  2,  0,  0 },
	{ /*  12:              1 0100 */  5,    20,  2,  3,  0,  0 },
	{ /*  13:             10 1010 */  6,    42,  3,  3,  0,  0 },
	{ /*  14:             10 1011 */  6,    43,  4,  1,  0,  0 },
	{ /*  15:             10 1100 */  6,    44,  1,  4,  0,  0 },
	{ /*  16:             10 1101 */  6,    45,  4,  2,  0,  0 },
	{ /*  17:             10 1110 */  6,    46,  2,  4,  0,  0 },
	{ /*  18:             10 1111 */  6,    47,  3,  0,  0,  0 },
	{ /*  19:             11 0000 */  6,    48,  0,  3,  0,  0 },
	{ /*  20:             11 0001 */  6,    49,  4,  3,  0,  0 },
	{ /*  21:             11 0010 */  6,    50,  3,  4,  0,  0 },
	{ /*  22:             11 0011 */  6,    51,  5,  2,  0,  0 },
	{ /*  23:            110 1000 */  7,   104,  5,  1,  0,  0 },
	{ /*  24:            110 1001 */  7,   105,  2,  5,  0,  0 },
	{ /*  25:            110 1010 */  7,   106,  1,  5,  0,  0 },
	{ /*  26:            110 1011 */  7,   107,  5,  3,  0,  0 },
	{ /*  27:            110 1100 */  7,   108,  3,  5,  0,  0 },
	{ /*  28:            110 1101 */  7,   109,  4,  4,  0,  0 },
	{ /*  29:            110 1110 */  7,   110,  5,  4,  0,  0 },
	{ /*  30:            110 1111 */  7,   111,  0,  4,  0,  0 },
	{ /*  31:            111 0000 */  7,   112,  4,  5,  0,  0 },
	{ /*  32:            111 0001 */  7,   113,  4,  0,  0,  0 },
	{ /*  33:            111 0010 */  7,   114,  2,  6,  0,  0 },
	{ /*  34:            111 0011 */  7,   115,  6,  2,  0,  0 },
	{ /*  35:            111 0100 */  7,   116,  6,  1,  0,  0 },
	{ /*  36:            111 0101 */  7,   117,  1,  6,  0,  0 },
	{ /*  37:           1110 1100 */  8,   236,  3,  6,  0,  0 },
	{ /*  38:           1110 1101 */  8,   237,  6,  3,  0,  0 },
	{ /*  39:           1110 1110 */  8,   238,  5,  5,  0,  0 },
	{ /*  40:           1110 1111 */  8,   239,  5,  0,  0,  0 },
	{ /*  41:           1111 0000 */  8,   240,  6,  4,  0,  0 },
	{ /*  42:           1111 0001 */  8,   241,  0,  5,  0,  0 },
	{ /*  43:           1111 0010 */  8,   242,  4,  6,  0,  0 },
	{ /*  44:           1111 0011 */  8,   243,  7,  1,  0,  0 },
	{ /*  45:           1111 0100 */  8,   244,  7,  2,  0,  0 },
	{ /*  46:           1111 0101 */  8,   245,  2,  7,  0,  0 },
	{ /*  47:           1111 0110 */  8,   246,  6,  5,  0,  0 },
	{ /*  48:           1111 0111 */  8,   247,  7,  3,  0,  0 },
	{ /*  49:           1111 1000 */  8,   248,  1,  7,  0,  0 },
	{ /*  50:           1111 1001 */  8,   249,  5,  6,  0,  0 },
	{ /*  51:           1111 1010 */  8,   250,  3,  7,  0,  0 },
	{ /*  52:         1 1111 0110 */  9,   502,  6,  6,  0,  0 },
	{ /*  53:         1 1111 0111 */  9,   503,  7,  4,  0,  0 },
	{ /*  54:         1 1111 1000 */  9,   504,  6,  0,  0,  0 },
	{ /*  55:         1 1111 1001 */  9,   505,  4,  7,  0,  0 },
	{ /*  56:         1 1111 1010 */  9,   506,  0,  6,  0,  0 },
	{ /*  57:         1 1111 1011 */  9,   507,  7,  5,  0,  0 },
	{ /*  58:         1 1111 1100 */  9,   508,  7,  6,  0,  0 },
	{ /*  59:         1 1111 1101 */  9,   509,  6,  7,  0,  0 },
	{ /*  60:        11 1111 1100 */ 10,  1020,  5,  7,  0,  0 },
	{ /*  61:        11 1111 1101 */ 10,  1021,  7,  0,  0,  0 },
	{ /*  62:        11 1111 1110 */ 10,  1022,  0,  7,  0,  0 },
	{ /*  63:        11 1111 1111 */ 10,  1023,  7,  7,  0,  0 }
};

Huffman book9[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                   0 */  1,     0,  0,  0,  0,  0 },
	{ /*   1:                 100 */  3,     4,  1,  0,  0,  0 },
	{ /*   2:                 101 */  3,     5,  0,  1,  0,  0 },
	{ /*   3:                1100 */  4,    12,  1,  1,  0,  0 },
	{ /*   4:             11 0100 */  6,    52,  2,  1,  0,  0 },
	{ /*   5:             11 0101 */  6,    53,  1,  2,  0,  0 },
	{ /*   6:             11 0110 */  6,    54,  2,  0,  0,  0 },
	{ /*   7:             11 0111 */  6,    55,  0,  2,  0,  0 },
	{ /*   8:            111 0000 */  7,   112,  3,  1,  0,  0 },
	{ /*   9:            111 0001 */  7,   113,  2,  2,  0,  0 },
	{ /*  10:            111 0010 */  7,   114,  1,  3,  0,  0 },
	{ /*  11:           1110 0110 */  8,   230,  3,  0,  0,  0 },
	{ /*  12:           1110 0111 */  8,   231,  0,  3,  0,  0 },
	{ /*  13:           1110 1000 */  8,   232,  2,  3,  0,  0 },
	{ /*  14:           1110 1001 */  8,   233,  3,  2,  0,  0 },
	{ /*  15:           1110 1010 */  8,   234,  1,  4,  0,  0 },
	{ /*  16:           1110 1011 */  8,   235,  4,  1,  0,  0 },
	{ /*  17:           1110 1100 */  8,   236,  2,  4,  0,  0 },
	{ /*  18:           1110 1101 */  8,   237,  1,  5,  0,  0 },
	{ /*  19:         1 1101 1100 */  9,   476,  4,  2,  0,  0 },
	{ /*  20:         1 1101 1101 */  9,   477,  3,  3,  0,  0 },
	{ /*  21:         1 1101 1110 */  9,   478,  0,  4,  0,  0 },
	{ /*  22:         1 1101 1111 */  9,   479,  4,  0,  0,  0 },
	{ /*  23:         1 1110 0000 */  9,   480,  5,  1,  0,  0 },
	{ /*  24:         1 1110 0001 */  9,   481,  2,  5,  0,  0 },
	{ /*  25:         1 1110 0010 */  9,   482,  1,  6,  0,  0 },
	{ /*  26:         1 1110 0011 */  9,   483,  3,  4,  0,  0 },
	{ /*  27:         1 1110 0100 */  9,   484,  5,  2,  0,  0 },
	{ /*  28:         1 1110 0101 */  9,   485,  6,  1,  0,  0 },
	{ /*  29:         1 1110 0110 */  9,   486,  4,  3,  0,  0 },
	{ /*  30:        11 1100 1110 */ 10,   974,  0,  5,  0,  0 },
	{ /*  31:        11 1100 1111 */ 10,   975,  2,  6,  0,  0 },
	{ /*  32:        11 1101 0000 */ 10,   976,  5,  0,  0,  0 },
	{ /*  33:        11 1101 0001 */ 10,   977,  1,  7,  0,  0 },
	{ /*  34:        11 1101 0010 */ 10,   978,  3,  5,  0,  0 },
	{ /*  35:        11 1101 0011 */ 10,   979,  1,  8,  0,  0 },
	{ /*  36:        11 1101 0100 */ 10,   980,  8,  1,  0,  0 },
	{ /*  37:        11 1101 0101 */ 10,   981,  4,  4,  0,  0 },
	{ /*  38:        11 1101 0110 */ 10,   982,  5,  3,  0,  0 },
	{ /*  39:        11 1101 0111 */ 10,   983,  6,  2,  0,  0 },
	{ /*  40:        11 1101 1000 */ 10,   984,  7,  1,  0,  0 },
	{ /*  41:        11 1101 1001 */ 10,   985,  0,  6,  0,  0 },
	{ /*  42:        11 1101 1010 */ 10,   986,  8,  2,  0,  0 },
	{ /*  43:        11 1101 1011 */ 10,   987,  2,  8,  0,  0 },
	{ /*  44:        11 1101 1100 */ 10,   988,  3,  6,  0,  0 },
	{ /*  45:        11 1101 1101 */ 10,   989,  2,  7,  0,  0 },
	{ /*  46:        11 1101 1110 */ 10,   990,  4,  5,  0,  0 },
	{ /*  47:        11 1101 1111 */ 10,   991,  9,  1,  0,  0 },
	{ /*  48:        11 1110 0000 */ 10,   992,  1,  9,  0,  0 },
	{ /*  49:        11 1110 0001 */ 10,   993,  7,  2,  0,  0 },
	{ /*  50:       111 1100 0100 */ 11,  1988,  6,  0,  0,  0 },
	{ /*  51:       111 1100 0101 */ 11,  1989,  5,  4,  0,  0 },
	{ /*  52:       111 1100 0110 */ 11,  1990,  6,  3,  0,  0 },
	{ /*  53:       111 1100 0111 */ 11,  1991,  8,  3,  0,  0 },
	{ /*  54:       111 1100 1000 */ 11,  1992,  0,  7,  0,  0 },
	{ /*  55:       111 1100 1001 */ 11,  1993,  9,  2,  0,  0 },
	{ /*  56:       111 1100 1010 */ 11,  1994,  3,  8,  0,  0 },
	{ /*  57:       111 1100 1011 */ 11,  1995,  4,  6,  0,  0 },
	{ /*  58:       111 1100 1100 */ 11,  1996,  3,  7,  0,  0 },
	{ /*  59:       111 1100 1101 */ 11,  1997,  0,  8,  0,  0 },
	{ /*  60:       111 1100 1110 */ 11,  1998, 10,  1,  0,  0 },
	{ /*  61:       111 1100 1111 */ 11,  1999,  6,  4,  0,  0 },
	{ /*  62:       111 1101 0000 */ 11,  2000,  2,  9,  0,  0 },
	{ /*  63:       111 1101 0001 */ 11,  2001,  5,  5,  0,  0 },
	{ /*  64:       111 1101 0010 */ 11,  2002,  8,  0,  0,  0 },
	{ /*  65:       111 1101 0011 */ 11,  2003,  7,  0,  0,  0 },
	{ /*  66:       111 1101 0100 */ 11,  2004,  7,  3,  0,  0 },
	{ /*  67:       111 1101 0101 */ 11,  2005, 10,  2,  0,  0 },
	{ /*  68:       111 1101 0110 */ 11,  2006,  9,  3,  0,  0 },
	{ /*  69:       111 1101 0111 */ 11,  2007,  8,  4,  0,  0 },
	{ /*  70:       111 1101 1000 */ 11,  2008,  1, 10,  0,  0 },
	{ /*  71:       111 1101 1001 */ 11,  2009,  7,  4,  0,  0 },
	{ /*  72:       111 1101 1010 */ 11,  2010,  6,  5,  0,  0 },
	{ /*  73:       111 1101 1011 */ 11,  2011,  5,  6,  0,  0 },
	{ /*  74:       111 1101 1100 */ 11,  2012,  4,  8,  0,  0 },
	{ /*  75:       111 1101 1101 */ 11,  2013,  4,  7,  0,  0 },
	{ /*  76:       111 1101 1110 */ 11,  2014,  3,  9,  0,  0 },
	{ /*  77:       111 1101 1111 */ 11,  2015, 11,  1,  0,  0 },
	{ /*  78:       111 1110 0000 */ 11,  2016,  5,  8,  0,  0 },
	{ /*  79:       111 1110 0001 */ 11,  2017,  9,  0,  0,  0 },
	{ /*  80:       111 1110 0010 */ 11,  2018,  8,  5,  0,  0 },
	{ /*  81:      1111 1100 0110 */ 12,  4038, 10,  3,  0,  0 },
	{ /*  82:      1111 1100 0111 */ 12,  4039,  2, 10,  0,  0 },
	{ /*  83:      1111 1100 1000 */ 12,  4040,  0,  9,  0,  0 },
	{ /*  84:      1111 1100 1001 */ 12,  4041, 11,  2,  0,  0 },
	{ /*  85:      1111 1100 1010 */ 12,  4042,  9,  4,  0,  0 },
	{ /*  86:      1111 1100 1011 */ 12,  4043,  6,  6,  0,  0 },
	{ /*  87:      1111 1100 1100 */ 12,  4044, 12,  1,  0,  0 },
	{ /*  88:      1111 1100 1101 */ 12,  4045,  4,  9,  0,  0 },
	{ /*  89:      1111 1100 1110 */ 12,  4046,  8,  6,  0,  0 },
	{ /*  90:      1111 1100 1111 */ 12,  4047,  1, 11,  0,  0 },
	{ /*  91:      1111 1101 0000 */ 12,  4048,  9,  5,  0,  0 },
	{ /*  92:      1111 1101 0001 */ 12,  4049, 10,  4,  0,  0 },
	{ /*  93:      1111 1101 0010 */ 12,  4050,  5,  7,  0,  0 },
	{ /*  94:      1111 1101 0011 */ 12,  4051,  7,  5,  0,  0 },
	{ /*  95:      1111 1101 0100 */ 12,  4052,  2, 11,  0,  0 },
	{ /*  96:      1111 1101 0101 */ 12,  4053,  1, 12,  0,  0 },
	{ /*  97:      1111 1101 0110 */ 12,  4054, 12,  2,  0,  0 },
	{ /*  98:      1111 1101 0111 */ 12,  4055, 11,  3,  0,  0 },
	{ /*  99:      1111 1101 1000 */ 12,  4056,  3, 10,  0,  0 },
	{ /* 100:      1111 1101 1001 */ 12,  4057,  5,  9,  0,  0 },
	{ /* 101:      1111 1101 1010 */ 12,  4058,  6,  7,  0,  0 },
	{ /* 102:      1111 1101 1011 */ 12,  4059,  8,  7,  0,  0 },
	{ /* 103:      1111 1101 1100 */ 12,  4060, 11,  4,  0,  0 },
	{ /* 104:      1111 1101 1101 */ 12,  4061,  0, 10,  0,  0 },
	{ /* 105:      1111 1101 1110 */ 12,  4062,  7,  6,  0,  0 },
	{ /* 106:      1111 1101 1111 */ 12,  4063, 12,  3,  0,  0 },
	{ /* 107:      1111 1110 0000 */ 12,  4064, 10,  0,  0,  0 },
	{ /* 108:      1111 1110 0001 */ 12,  4065, 10,  5,  0,  0 },
	{ /* 109:      1111 1110 0010 */ 12,  4066,  4, 10,  0,  0 },
	{ /* 110:      1111 1110 0011 */ 12,  4067,  6,  8,  0,  0 },
	{ /* 111:      1111 1110 0100 */ 12,  4068,  2, 12,  0,  0 },
	{ /* 112:      1111 1110 0101 */ 12,  4069,  9,  6,  0,  0 },
	{ /* 113:      1111 1110 0110 */ 12,  4070,  9,  7,  0,  0 },
	{ /* 114:      1111 1110 0111 */ 12,  4071,  4, 11,  0,  0 },
	{ /* 115:      1111 1110 1000 */ 12,  4072, 11,  0,  0,  0 },
	{ /* 116:      1111 1110 1001 */ 12,  4073,  6,  9,  0,  0 },
	{ /* 117:      1111 1110 1010 */ 12,  4074,  3, 11,  0,  0 },
	{ /* 118:      1111 1110 1011 */ 12,  4075,  5, 10,  0,  0 },
	{ /* 119:    1 1111 1101 1000 */ 13,  8152,  8,  8,  0,  0 },
	{ /* 120:    1 1111 1101 1001 */ 13,  8153,  7,  8,  0,  0 },
	{ /* 121:    1 1111 1101 1010 */ 13,  8154, 12,  5,  0,  0 },
	{ /* 122:    1 1111 1101 1011 */ 13,  8155,  3, 12,  0,  0 },
	{ /* 123:    1 1111 1101 1100 */ 13,  8156, 11,  5,  0,  0 },
	{ /* 124:    1 1111 1101 1101 */ 13,  8157,  7,  7,  0,  0 },
	{ /* 125:    1 1111 1101 1110 */ 13,  8158, 12,  4,  0,  0 },
	{ /* 126:    1 1111 1101 1111 */ 13,  8159, 11,  6,  0,  0 },
	{ /* 127:    1 1111 1110 0000 */ 13,  8160, 10,  6,  0,  0 },
	{ /* 128:    1 1111 1110 0001 */ 13,  8161,  4, 12,  0,  0 },
	{ /* 129:    1 1111 1110 0010 */ 13,  8162,  7,  9,  0,  0 },
	{ /* 130:    1 1111 1110 0011 */ 13,  8163,  5, 11,  0,  0 },
	{ /* 131:    1 1111 1110 0100 */ 13,  8164,  0, 11,  0,  0 },
	{ /* 132:    1 1111 1110 0101 */ 13,  8165, 12,  6,  0,  0 },
	{ /* 133:    1 1111 1110 0110 */ 13,  8166,  6, 10,  0,  0 },
	{ /* 134:    1 1111 1110 0111 */ 13,  8167, 12,  0,  0,  0 },
	{ /* 135:    1 1111 1110 1000 */ 13,  8168, 10,  7,  0,  0 },
	{ /* 136:    1 1111 1110 1001 */ 13,  8169,  5, 12,  0,  0 },
	{ /* 137:    1 1111 1110 1010 */ 13,  8170,  7, 10,  0,  0 },
	{ /* 138:    1 1111 1110 1011 */ 13,  8171,  9,  8,  0,  0 },
	{ /* 139:    1 1111 1110 1100 */ 13,  8172,  0, 12,  0,  0 },
	{ /* 140:    1 1111 1110 1101 */ 13,  8173, 11,  7,  0,  0 },
	{ /* 141:    1 1111 1110 1110 */ 13,  8174,  8,  9,  0,  0 },
	{ /* 142:    1 1111 1110 1111 */ 13,  8175,  9,  9,  0,  0 },
	{ /* 143:    1 1111 1111 0000 */ 13,  8176, 10,  8,  0,  0 },
	{ /* 144:    1 1111 1111 0001 */ 13,  8177,  7, 11,  0,  0 },
	{ /* 145:    1 1111 1111 0010 */ 13,  8178, 12,  7,  0,  0 },
	{ /* 146:    1 1111 1111 0011 */ 13,  8179,  6, 11,  0,  0 },
	{ /* 147:    1 1111 1111 0100 */ 13,  8180,  8, 11,  0,  0 },
	{ /* 148:    1 1111 1111 0101 */ 13,  8181, 11,  8,  0,  0 },
	{ /* 149:    1 1111 1111 0110 */ 13,  8182,  7, 12,  0,  0 },
	{ /* 150:    1 1111 1111 0111 */ 13,  8183,  6, 12,  0,  0 },
	{ /* 151:   11 1111 1111 0000 */ 14, 16368,  8, 10,  0,  0 },
	{ /* 152:   11 1111 1111 0001 */ 14, 16369, 10,  9,  0,  0 },
	{ /* 153:   11 1111 1111 0010 */ 14, 16370,  8, 12,  0,  0 },
	{ /* 154:   11 1111 1111 0011 */ 14, 16371,  9, 10,  0,  0 },
	{ /* 155:   11 1111 1111 0100 */ 14, 16372,  9, 11,  0,  0 },
	{ /* 156:   11 1111 1111 0101 */ 14, 16373,  9, 12,  0,  0 },
	{ /* 157:   11 1111 1111 0110 */ 14, 16374, 10, 11,  0,  0 },
	{ /* 158:   11 1111 1111 0111 */ 14, 16375, 12,  9,  0,  0 },
	{ /* 159:   11 1111 1111 1000 */ 14, 16376, 10, 10,  0,  0 },
	{ /* 160:   11 1111 1111 1001 */ 14, 16377, 11,  9,  0,  0 },
	{ /* 161:   11 1111 1111 1010 */ 14, 16378, 12,  8,  0,  0 },
	{ /* 162:   11 1111 1111 1011 */ 14, 16379, 11, 10,  0,  0 },
	{ /* 163:   11 1111 1111 1100 */ 14, 16380, 12, 10,  0,  0 },
	{ /* 164:   11 1111 1111 1101 */ 14, 16381, 12, 11,  0,  0 },
	{ /* 165:  111 1111 1111 1100 */ 15, 32764, 10, 12,  0,  0 },
	{ /* 166:  111 1111 1111 1101 */ 15, 32765, 11, 11,  0,  0 },
	{ /* 167:  111 1111 1111 1110 */ 15, 32766, 11, 12,  0,  0 },
	{ /* 168:  111 1111 1111 1111 */ 15, 32767, 12, 12,  0,  0 }
};

Huffman book10[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                0000 */  4,     0,  1,  1,  0,  0 },
	{ /*   1:                0001 */  4,     1,  1,  2,  0,  0 },
	{ /*   2:                0010 */  4,     2,  2,  1,  0,  0 },
	{ /*   3:              0 0110 */  5,     6,  2,  2,  0,  0 },
	{ /*   4:              0 0111 */  5,     7,  1,  0,  0,  0 },
	{ /*   5:              0 1000 */  5,     8,  0,  1,  0,  0 },
	{ /*   6:              0 1001 */  5,     9,  1,  3,  0,  0 },
	{ /*   7:              0 1010 */  5,    10,  3,  2,  0,  0 },
	{ /*   8:              0 1011 */  5,    11,  3,  1,  0,  0 },
	{ /*   9:              0 1100 */  5,    12,  2,  3,  0,  0 },
	{ /*  10:              0 1101 */  5,    13,  3,  3,  0,  0 },
	{ /*  11:             01 1100 */  6,    28,  2,  0,  0,  0 },
	{ /*  12:             01 1101 */  6,    29,  0,  2,  0,  0 },
	{ /*  13:             01 1110 */  6,    30,  2,  4,  0,  0 },
	{ /*  14:             01 1111 */  6,    31,  4,  2,  0,  0 },
	{ /*  15:             10 0000 */  6,    32,  1,  4,  0,  0 },
	{ /*  16:             10 0001 */  6,    33,  4,  1,  0,  0 },
	{ /*  17:             10 0010 */  6,    34,  0,  0,  0,  0 },
	{ /*  18:             10 0011 */  6,    35,  4,  3,  0,  0 },
	{ /*  19:             10 0100 */  6,    36,  3,  4,  0,  0 },
	{ /*  20:             10 0101 */  6,    37,  3,  0,  0,  0 },
	{ /*  21:             10 0110 */  6,    38,  0,  3,  0,  0 },
	{ /*  22:             10 0111 */  6,    39,  4,  4,  0,  0 },
	{ /*  23:             10 1000 */  6,    40,  2,  5,  0,  0 },
	{ /*  24:             10 1001 */  6,    41,  5,  2,  0,  0 },
	{ /*  25:            101 0100 */  7,    84,  1,  5,  0,  0 },
	{ /*  26:            101 0101 */  7,    85,  5,  1,  0,  0 },
	{ /*  27:            101 0110 */  7,    86,  5,  3,  0,  0 },
	{ /*  28:            101 0111 */  7,    87,  3,  5,  0,  0 },
	{ /*  29:            101 1000 */  7,    88,  5,  4,  0,  0 },
	{ /*  30:            101 1001 */  7,    89,  4,  5,  0,  0 },
	{ /*  31:            101 1010 */  7,    90,  6,  2,  0,  0 },
	{ /*  32:            101 1011 */  7,    91,  2,  6,  0,  0 },
	{ /*  33:            101 1100 */  7,    92,  6,  3,  0,  0 },
	{ /*  34:            101 1101 */  7,    93,  4,  0,  0,  0 },
	{ /*  35:            101 1110 */  7,    94,  6,  1,  0,  0 },
	{ /*  36:            101 1111 */  7,    95,  0,  4,  0,  0 },
	{ /*  37:            110 0000 */  7,    96,  1,  6,  0,  0 },
	{ /*  38:            110 0001 */  7,    97,  3,  6,  0,  0 },
	{ /*  39:            110 0010 */  7,    98,  5,  5,  0,  0 },
	{ /*  40:            110 0011 */  7,    99,  6,  4,  0,  0 },
	{ /*  41:            110 0100 */  7,   100,  4,  6,  0,  0 },
	{ /*  42:           1100 1010 */  8,   202,  6,  5,  0,  0 },
	{ /*  43:           1100 1011 */  8,   203,  7,  2,  0,  0 },
	{ /*  44:           1100 1100 */  8,   204,  3,  7,  0,  0 },
	{ /*  45:           1100 1101 */  8,   205,  2,  7,  0,  0 },
	{ /*  46:           1100 1110 */  8,   206,  5,  6,  0,  0 },
	{ /*  47:           1100 1111 */  8,   207,  8,  2,  0,  0 },
	{ /*  48:           1101 0000 */  8,   208,  7,  3,  0,  0 },
	{ /*  49:           1101 0001 */  8,   209,  5,  0,  0,  0 },
	{ /*  50:           1101 0010 */  8,   210,  7,  1,  0,  0 },
	{ /*  51:           1101 0011 */  8,   211,  0,  5,  0,  0 },
	{ /*  52:           1101 0100 */  8,   212,  8,  1,  0,  0 },
	{ /*  53:           1101 0101 */  8,   213,  1,  7,  0,  0 },
	{ /*  54:           1101 0110 */  8,   214,  8,  3,  0,  0 },
	{ /*  55:           1101 0111 */  8,   215,  7,  4,  0,  0 },
	{ /*  56:           1101 1000 */  8,   216,  4,  7,  0,  0 },
	{ /*  57:           1101 1001 */  8,   217,  2,  8,  0,  0 },
	{ /*  58:           1101 1010 */  8,   218,  6,  6,  0,  0 },
	{ /*  59:           1101 1011 */  8,   219,  7,  5,  0,  0 },
	{ /*  60:           1101 1100 */  8,   220,  1,  8,  0,  0 },
	{ /*  61:           1101 1101 */  8,   221,  3,  8,  0,  0 },
	{ /*  62:           1101 1110 */  8,   222,  8,  4,  0,  0 },
	{ /*  63:           1101 1111 */  8,   223,  4,  8,  0,  0 },
	{ /*  64:           1110 0000 */  8,   224,  5,  7,  0,  0 },
	{ /*  65:           1110 0001 */  8,   225,  8,  5,  0,  0 },
	{ /*  66:           1110 0010 */  8,   226,  5,  8,  0,  0 },
	{ /*  67:         1 1100 0110 */  9,   454,  7,  6,  0,  0 },
	{ /*  68:         1 1100 0111 */  9,   455,  6,  7,  0,  0 },
	{ /*  69:         1 1100 1000 */  9,   456,  9,  2,  0,  0 },
	{ /*  70:         1 1100 1001 */  9,   457,  6,  0,  0,  0 },
	{ /*  71:         1 1100 1010 */  9,   458,  6,  8,  0,  0 },
	{ /*  72:         1 1100 1011 */  9,   459,  9,  3,  0,  0 },
	{ /*  73:         1 1100 1100 */  9,   460,  3,  9,  0,  0 },
	{ /*  74:         1 1100 1101 */  9,   461,  9,  1,  0,  0 },
	{ /*  75:         1 1100 1110 */  9,   462,  2,  9,  0,  0 },
	{ /*  76:         1 1100 1111 */  9,   463,  0,  6,  0,  0 },
	{ /*  77:         1 1101 0000 */  9,   464,  8,  6,  0,  0 },
	{ /*  78:         1 1101 0001 */  9,   465,  9,  4,  0,  0 },
	{ /*  79:         1 1101 0010 */  9,   466,  4,  9,  0,  0 },
	{ /*  80:         1 1101 0011 */  9,   467, 10,  2,  0,  0 },
	{ /*  81:         1 1101 0100 */  9,   468,  1,  9,  0,  0 },
	{ /*  82:         1 1101 0101 */  9,   469,  7,  7,  0,  0 },
	{ /*  83:         1 1101 0110 */  9,   470,  8,  7,  0,  0 },
	{ /*  84:         1 1101 0111 */  9,   471,  9,  5,  0,  0 },
	{ /*  85:         1 1101 1000 */  9,   472,  7,  8,  0,  0 },
	{ /*  86:         1 1101 1001 */  9,   473, 10,  3,  0,  0 },
	{ /*  87:         1 1101 1010 */  9,   474,  5,  9,  0,  0 },
	{ /*  88:         1 1101 1011 */  9,   475, 10,  4,  0,  0 },
	{ /*  89:         1 1101 1100 */  9,   476,  2, 10,  0,  0 },
	{ /*  90:         1 1101 1101 */  9,   477, 10,  1,  0,  0 },
	{ /*  91:         1 1101 1110 */  9,   478,  3, 10,  0,  0 },
	{ /*  92:         1 1101 1111 */  9,   479,  9,  6,  0,  0 },
	{ /*  93:         1 1110 0000 */  9,   480,  6,  9,  0,  0 },
	{ /*  94:         1 1110 0001 */  9,   481,  8,  0,  0,  0 },
	{ /*  95:         1 1110 0010 */  9,   482,  4, 10,  0,  0 },
	{ /*  96:         1 1110 0011 */  9,   483,  7,  0,  0,  0 },
	{ /*  97:         1 1110 0100 */  9,   484, 11,  2,  0,  0 },
	{ /*  98:        11 1100 1010 */ 10,   970,  7,  9,  0,  0 },
	{ /*  99:        11 1100 1011 */ 10,   971, 11,  3,  0,  0 },
	{ /* 100:        11 1100 1100 */ 10,   972, 10,  6,  0,  0 },
	{ /* 101:        11 1100 1101 */ 10,   973,  1, 10,  0,  0 },
	{ /* 102:        11 1100 1110 */ 10,   974, 11,  1,  0,  0 },
	{ /* 103:        11 1100 1111 */ 10,   975,  9,  7,  0,  0 },
	{ /* 104:        11 1101 0000 */ 10,   976,  0,  7,  0,  0 },
	{ /* 105:        11 1101 0001 */ 10,   977,  8,  8,  0,  0 },
	{ /* 106:        11 1101 0010 */ 10,   978, 10,  5,  0,  0 },
	{ /* 107:        11 1101 0011 */ 10,   979,  3, 11,  0,  0 },
	{ /* 108:        11 1101 0100 */ 10,   980,  5, 10,  0,  0 },
	{ /* 109:        11 1101 0101 */ 10,   981,  8,  9,  0,  0 },
	{ /* 110:        11 1101 0110 */ 10,   982, 11,  5,  0,  0 },
	{ /* 111:        11 1101 0111 */ 10,   983,  0,  8,  0,  0 },
	{ /* 112:        11 1101 1000 */ 10,   984, 11,  4,  0,  0 },
	{ /* 113:        11 1101 1001 */ 10,   985,  2, 11,  0,  0 },
	{ /* 114:        11 1101 1010 */ 10,   986,  7, 10,  0,  0 },
	{ /* 115:        11 1101 1011 */ 10,   987,  6, 10,  0,  0 },
	{ /* 116:        11 1101 1100 */ 10,   988, 10,  7,  0,  0 },
	{ /* 117:        11 1101 1101 */ 10,   989,  4, 11,  0,  0 },
	{ /* 118:        11 1101 1110 */ 10,   990,  1, 11,  0,  0 },
	{ /* 119:        11 1101 1111 */ 10,   991, 12,  2,  0,  0 },
	{ /* 120:        11 1110 0000 */ 10,   992,  9,  8,  0,  0 },
	{ /* 121:        11 1110 0001 */ 10,   993, 12,  3,  0,  0 },
	{ /* 122:        11 1110 0010 */ 10,   994, 11,  6,  0,  0 },
	{ /* 123:        11 1110 0011 */ 10,   995,  5, 11,  0,  0 },
	{ /* 124:        11 1110 0100 */ 10,   996, 12,  4,  0,  0 },
	{ /* 125:        11 1110 0101 */ 10,   997, 11,  7,  0,  0 },
	{ /* 126:        11 1110 0110 */ 10,   998, 12,  5,  0,  0 },
	{ /* 127:        11 1110 0111 */ 10,   999,  3, 12,  0,  0 },
	{ /* 128:        11 1110 1000 */ 10,  1000,  6, 11,  0,  0 },
	{ /* 129:        11 1110 1001 */ 10,  1001,  9,  0,  0,  0 },
	{ /* 130:        11 1110 1010 */ 10,  1002, 10,  8,  0,  0 },
	{ /* 131:        11 1110 1011 */ 10,  1003, 10,  0,  0,  0 },
	{ /* 132:        11 1110 1100 */ 10,  1004, 12,  1,  0,  0 },
	{ /* 133:        11 1110 1101 */ 10,  1005,  0,  9,  0,  0 },
	{ /* 134:        11 1110 1110 */ 10,  1006,  4, 12,  0,  0 },
	{ /* 135:        11 1110 1111 */ 10,  1007,  9,  9,  0,  0 },
	{ /* 136:        11 1111 0000 */ 10,  1008, 12,  6,  0,  0 },
	{ /* 137:        11 1111 0001 */ 10,  1009,  2, 12,  0,  0 },
	{ /* 138:        11 1111 0010 */ 10,  1010,  8, 10,  0,  0 },
	{ /* 139:       111 1110 0110 */ 11,  2022,  9, 10,  0,  0 },
	{ /* 140:       111 1110 0111 */ 11,  2023,  1, 12,  0,  0 },
	{ /* 141:       111 1110 1000 */ 11,  2024, 11,  8,  0,  0 },
	{ /* 142:       111 1110 1001 */ 11,  2025, 12,  7,  0,  0 },
	{ /* 143:       111 1110 1010 */ 11,  2026,  7, 11,  0,  0 },
	{ /* 144:       111 1110 1011 */ 11,  2027,  5, 12,  0,  0 },
	{ /* 145:       111 1110 1100 */ 11,  2028,  6, 12,  0,  0 },
	{ /* 146:       111 1110 1101 */ 11,  2029, 10,  9,  0,  0 },
	{ /* 147:       111 1110 1110 */ 11,  2030,  8, 11,  0,  0 },
	{ /* 148:       111 1110 1111 */ 11,  2031, 12,  8,  0,  0 },
	{ /* 149:       111 1111 0000 */ 11,  2032,  0, 10,  0,  0 },
	{ /* 150:       111 1111 0001 */ 11,  2033,  7, 12,  0,  0 },
	{ /* 151:       111 1111 0010 */ 11,  2034, 11,  0,  0,  0 },
	{ /* 152:       111 1111 0011 */ 11,  2035, 10, 10,  0,  0 },
	{ /* 153:       111 1111 0100 */ 11,  2036, 11,  9,  0,  0 },
	{ /* 154:       111 1111 0101 */ 11,  2037, 11, 10,  0,  0 },
	{ /* 155:       111 1111 0110 */ 11,  2038,  0, 11,  0,  0 },
	{ /* 156:       111 1111 0111 */ 11,  2039, 11, 11,  0,  0 },
	{ /* 157:       111 1111 1000 */ 11,  2040,  9, 11,  0,  0 },
	{ /* 158:       111 1111 1001 */ 11,  2041, 10, 11,  0,  0 },
	{ /* 159:       111 1111 1010 */ 11,  2042, 12,  0,  0,  0 },
	{ /* 160:       111 1111 1011 */ 11,  2043,  8, 12,  0,  0 },
	{ /* 161:      1111 1111 1000 */ 12,  4088, 12,  9,  0,  0 },
	{ /* 162:      1111 1111 1001 */ 12,  4089, 10, 12,  0,  0 },
	{ /* 163:      1111 1111 1010 */ 12,  4090,  9, 12,  0,  0 },
	{ /* 164:      1111 1111 1011 */ 12,  4091, 11, 12,  0,  0 },
	{ /* 165:      1111 1111 1100 */ 12,  4092, 12, 11,  0,  0 },
	{ /* 166:      1111 1111 1101 */ 12,  4093,  0, 12,  0,  0 },
	{ /* 167:      1111 1111 1110 */ 12,  4094, 12, 10,  0,  0 },
	{ /* 168:      1111 1111 1111 */ 12,  4095, 12, 12,  0,  0 }
};

Huffman book11[] = {
	  /* idx             codeword   len  codew   x   y   v   w */
	{ /*   0:                0000 */  4,     0,  0,  0,  0,  0 },
	{ /*   1:                0001 */  4,     1,  1,  1,  0,  0 },
	{ /*   2:              0 0100 */  5,     4, 16, 16,  0,  0 },
	{ /*   3:              0 0101 */  5,     5,  1,  0,  0,  0 },
	{ /*   4:              0 0110 */  5,     6,  0,  1,  0,  0 },
	{ /*   5:              0 0111 */  5,     7,  2,  1,  0,  0 },
	{ /*   6:              0 1000 */  5,     8,  1,  2,  0,  0 },
	{ /*   7:              0 1001 */  5,     9,  2,  2,  0,  0 },
	{ /*   8:             01 0100 */  6,    20,  1,  3,  0,  0 },
	{ /*   9:             01 0101 */  6,    21,  3,  1,  0,  0 },
	{ /*  10:             01 0110 */  6,    22,  3,  2,  0,  0 },
	{ /*  11:             01 0111 */  6,    23,  2,  0,  0,  0 },
	{ /*  12:             01 1000 */  6,    24,  2,  3,  0,  0 },
	{ /*  13:             01 1001 */  6,    25,  0,  2,  0,  0 },
	{ /*  14:             01 1010 */  6,    26,  3,  3,  0,  0 },
	{ /*  15:            011 0110 */  7,    54,  4,  1,  0,  0 },
	{ /*  16:            011 0111 */  7,    55,  1,  4,  0,  0 },
	{ /*  17:            011 1000 */  7,    56,  4,  2,  0,  0 },
	{ /*  18:            011 1001 */  7,    57,  2,  4,  0,  0 },
	{ /*  19:            011 1010 */  7,    58,  4,  3,  0,  0 },
	{ /*  20:            011 1011 */  7,    59,  3,  4,  0,  0 },
	{ /*  21:            011 1100 */  7,    60,  3,  0,  0,  0 },
	{ /*  22:            011 1101 */  7,    61,  0,  3,  0,  0 },
	{ /*  23:            011 1110 */  7,    62,  5,  1,  0,  0 },
	{ /*  24:            011 1111 */  7,    63,  5,  2,  0,  0 },
	{ /*  25:            100 0000 */  7,    64,  2,  5,  0,  0 },
	{ /*  26:            100 0001 */  7,    65,  4,  4,  0,  0 },
	{ /*  27:            100 0010 */  7,    66,  1,  5,  0,  0 },
	{ /*  28:            100 0011 */  7,    67,  5,  3,  0,  0 },
	{ /*  29:            100 0100 */  7,    68,  3,  5,  0,  0 },
	{ /*  30:            100 0101 */  7,    69,  5,  4,  0,  0 },
	{ /*  31:           1000 1100 */  8,   140,  4,  5,  0,  0 },
	{ /*  32:           1000 1101 */  8,   141,  6,  2,  0,  0 },
	{ /*  33:           1000 1110 */  8,   142,  2,  6,  0,  0 },
	{ /*  34:           1000 1111 */  8,   143,  6,  1,  0,  0 },
	{ /*  35:           1001 0000 */  8,   144,  6,  3,  0,  0 },
	{ /*  36:           1001 0001 */  8,   145,  3,  6,  0,  0 },
	{ /*  37:           1001 0010 */  8,   146,  1,  6,  0,  0 },
	{ /*  38:           1001 0011 */  8,   147,  4, 16,  0,  0 },
	{ /*  39:           1001 0100 */  8,   148,  3, 16,  0,  0 },
	{ /*  40:           1001 0101 */  8,   149, 16,  5,  0,  0 },
	{ /*  41:           1001 0110 */  8,   150, 16,  3,  0,  0 },
	{ /*  42:           1001 0111 */  8,   151, 16,  4,  0,  0 },
	{ /*  43:           1001 1000 */  8,   152,  6,  4,  0,  0 },
	{ /*  44:           1001 1001 */  8,   153, 16,  6,  0,  0 },
	{ /*  45:           1001 1010 */  8,   154,  4,  0,  0,  0 },
	{ /*  46:           1001 1011 */  8,   155,  4,  6,  0,  0 },
	{ /*  47:           1001 1100 */  8,   156,  0,  4,  0,  0 },
	{ /*  48:           1001 1101 */  8,   157,  2, 16,  0,  0 },
	{ /*  49:           1001 1110 */  8,   158,  5,  5,  0,  0 },
	{ /*  50:           1001 1111 */  8,   159,  5, 16,  0,  0 },
	{ /*  51:           1010 0000 */  8,   160, 16,  7,  0,  0 },
	{ /*  52:           1010 0001 */  8,   161, 16,  2,  0,  0 },
	{ /*  53:           1010 0010 */  8,   162, 16,  8,  0,  0 },
	{ /*  54:           1010 0011 */  8,   163,  2,  7,  0,  0 },
	{ /*  55:           1010 0100 */  8,   164,  7,  2,  0,  0 },
	{ /*  56:           1010 0101 */  8,   165,  3,  7,  0,  0 },
	{ /*  57:           1010 0110 */  8,   166,  6,  5,  0,  0 },
	{ /*  58:           1010 0111 */  8,   167,  5,  6,  0,  0 },
	{ /*  59:           1010 1000 */  8,   168,  6, 16,  0,  0 },
	{ /*  60:           1010 1001 */  8,   169, 16, 10,  0,  0 },
	{ /*  61:           1010 1010 */  8,   170,  7,  3,  0,  0 },
	{ /*  62:           1010 1011 */  8,   171,  7,  1,  0,  0 },
	{ /*  63:           1010 1100 */  8,   172, 16,  9,  0,  0 },
	{ /*  64:           1010 1101 */  8,   173,  7, 16,  0,  0 },
	{ /*  65:           1010 1110 */  8,   174,  1, 16,  0,  0 },
	{ /*  66:           1010 1111 */  8,   175,  1,  7,  0,  0 },
	{ /*  67:           1011 0000 */  8,   176,  4,  7,  0,  0 },
	{ /*  68:           1011 0001 */  8,   177, 16, 11,  0,  0 },
	{ /*  69:           1011 0010 */  8,   178,  7,  4,  0,  0 },
	{ /*  70:           1011 0011 */  8,   179, 16, 12,  0,  0 },
	{ /*  71:           1011 0100 */  8,   180,  8, 16,  0,  0 },
	{ /*  72:           1011 0101 */  8,   181, 16,  1,  0,  0 },
	{ /*  73:           1011 0110 */  8,   182,  6,  6,  0,  0 },
	{ /*  74:           1011 0111 */  8,   183,  9, 16,  0,  0 },
	{ /*  75:           1011 1000 */  8,   184,  2,  8,  0,  0 },
	{ /*  76:           1011 1001 */  8,   185,  5,  7,  0,  0 },
	{ /*  77:           1011 1010 */  8,   186, 10, 16,  0,  0 },
	{ /*  78:           1011 1011 */  8,   187, 16, 13,  0,  0 },
	{ /*  79:           1011 1100 */  8,   188,  8,  3,  0,  0 },
	{ /*  80:           1011 1101 */  8,   189,  8,  2,  0,  0 },
	{ /*  81:           1011 1110 */  8,   190,  3,  8,  0,  0 },
	{ /*  82:           1011 1111 */  8,   191,  5,  0,  0,  0 },
	{ /*  83:           1100 0000 */  8,   192, 16, 14,  0,  0 },
	{ /*  84:           1100 0001 */  8,   193, 11, 16,  0,  0 },
	{ /*  85:           1100 0010 */  8,   194,  7,  5,  0,  0 },
	{ /*  86:           1100 0011 */  8,   195,  4,  8,  0,  0 },
	{ /*  87:           1100 0100 */  8,   196,  6,  7,  0,  0 },
	{ /*  88:           1100 0101 */  8,   197,  7,  6,  0,  0 },
	{ /*  89:           1100 0110 */  8,   198,  0,  5,  0,  0 },
	{ /*  90:         1 1000 1110 */  9,   398,  8,  4,  0,  0 },
	{ /*  91:         1 1000 1111 */  9,   399, 16, 15,  0,  0 },
	{ /*  92:         1 1001 0000 */  9,   400, 12, 16,  0,  0 },
	{ /*  93:         1 1001 0001 */  9,   401,  1,  8,  0,  0 },
	{ /*  94:         1 1001 0010 */  9,   402,  8,  1,  0,  0 },
	{ /*  95:         1 1001 0011 */  9,   403, 14, 16,  0,  0 },
	{ /*  96:         1 1001 0100 */  9,   404,  5,  8,  0,  0 },
	{ /*  97:         1 1001 0101 */  9,   405, 13, 16,  0,  0 },
	{ /*  98:         1 1001 0110 */  9,   406,  3,  9,  0,  0 },
	{ /*  99:         1 1001 0111 */  9,   407,  8,  5,  0,  0 },
	{ /* 100:         1 1001 1000 */  9,   408,  7,  7,  0,  0 },
	{ /* 101:         1 1001 1001 */  9,   409,  2,  9,  0,  0 },
	{ /* 102:         1 1001 1010 */  9,   410,  8,  6,  0,  0 },
	{ /* 103:         1 1001 1011 */  9,   411,  9,  2,  0,  0 },
	{ /* 104:         1 1001 1100 */  9,   412,  9,  3,  0,  0 },
	{ /* 105:         1 1001 1101 */  9,   413, 15, 16,  0,  0 },
	{ /* 106:         1 1001 1110 */  9,   414,  4,  9,  0,  0 },
	{ /* 107:         1 1001 1111 */  9,   415,  6,  8,  0,  0 },
	{ /* 108:         1 1010 0000 */  9,   416,  6,  0,  0,  0 },
	{ /* 109:         1 1010 0001 */  9,   417,  9,  4,  0,  0 },
	{ /* 110:         1 1010 0010 */  9,   418,  5,  9,  0,  0 },
	{ /* 111:         1 1010 0011 */  9,   419,  8,  7,  0,  0 },
	{ /* 112:         1 1010 0100 */  9,   420,  7,  8,  0,  0 },
	{ /* 113:         1 1010 0101 */  9,   421,  1,  9,  0,  0 },
	{ /* 114:         1 1010 0110 */  9,   422, 10,  3,  0,  0 },
	{ /* 115:         1 1010 0111 */  9,   423,  0,  6,  0,  0 },
	{ /* 116:         1 1010 1000 */  9,   424, 10,  2,  0,  0 },
	{ /* 117:         1 1010 1001 */  9,   425,  9,  1,  0,  0 },
	{ /* 118:         1 1010 1010 */  9,   426,  9,  5,  0,  0 },
	{ /* 119:         1 1010 1011 */  9,   427,  4, 10,  0,  0 },
	{ /* 120:         1 1010 1100 */  9,   428,  2, 10,  0,  0 },
	{ /* 121:         1 1010 1101 */  9,   429,  9,  6,  0,  0 },
	{ /* 122:         1 1010 1110 */  9,   430,  3, 10,  0,  0 },
	{ /* 123:         1 1010 1111 */  9,   431,  6,  9,  0,  0 },
	{ /* 124:         1 1011 0000 */  9,   432, 10,  4,  0,  0 },
	{ /* 125:         1 1011 0001 */  9,   433,  8,  8,  0,  0 },
	{ /* 126:         1 1011 0010 */  9,   434, 10,  5,  0,  0 },
	{ /* 127:         1 1011 0011 */  9,   435,  9,  7,  0,  0 },
	{ /* 128:         1 1011 0100 */  9,   436, 11,  3,  0,  0 },
	{ /* 129:         1 1011 0101 */  9,   437,  1, 10,  0,  0 },
	{ /* 130:         1 1011 0110 */  9,   438,  7,  0,  0,  0 },
	{ /* 131:         1 1011 0111 */  9,   439, 10,  6,  0,  0 },
	{ /* 132:         1 1011 1000 */  9,   440,  7,  9,  0,  0 },
	{ /* 133:         1 1011 1001 */  9,   441,  3, 11,  0,  0 },
	{ /* 134:         1 1011 1010 */  9,   442,  5, 10,  0,  0 },
	{ /* 135:         1 1011 1011 */  9,   443, 10,  1,  0,  0 },
	{ /* 136:         1 1011 1100 */  9,   444,  4, 11,  0,  0 },
	{ /* 137:         1 1011 1101 */  9,   445, 11,  2,  0,  0 },
	{ /* 138:         1 1011 1110 */  9,   446, 13,  2,  0,  0 },
	{ /* 139:         1 1011 1111 */  9,   447,  6, 10,  0,  0 },
	{ /* 140:         1 1100 0000 */  9,   448, 13,  3,  0,  0 },
	{ /* 141:         1 1100 0001 */  9,   449,  2, 11,  0,  0 },
	{ /* 142:         1 1100 0010 */  9,   450, 16,  0,  0,  0 },
	{ /* 143:         1 1100 0011 */  9,   451,  5, 11,  0,  0 },
	{ /* 144:         1 1100 0100 */  9,   452, 11,  5,  0,  0 },
	{ /* 145:        11 1000 1010 */ 10,   906, 11,  4,  0,  0 },
	{ /* 146:        11 1000 1011 */ 10,   907,  9,  8,  0,  0 },
	{ /* 147:        11 1000 1100 */ 10,   908,  7, 10,  0,  0 },
	{ /* 148:        11 1000 1101 */ 10,   909,  8,  9,  0,  0 },
	{ /* 149:        11 1000 1110 */ 10,   910,  0, 16,  0,  0 },
	{ /* 150:        11 1000 1111 */ 10,   911,  4, 13,  0,  0 },
	{ /* 151:        11 1001 0000 */ 10,   912,  0,  7,  0,  0 },
	{ /* 152:        11 1001 0001 */ 10,   913,  3, 13,  0,  0 },
	{ /* 153:        11 1001 0010 */ 10,   914, 11,  6,  0,  0 },
	{ /* 154:        11 1001 0011 */ 10,   915, 13,  1,  0,  0 },
	{ /* 155:        11 1001 0100 */ 10,   916, 13,  4,  0,  0 },
	{ /* 156:        11 1001 0101 */ 10,   917, 12,  3,  0,  0 },
	{ /* 157:        11 1001 0110 */ 10,   918,  2, 13,  0,  0 },
	{ /* 158:        11 1001 0111 */ 10,   919, 13,  5,  0,  0 },
	{ /* 159:        11 1001 1000 */ 10,   920,  8, 10,  0,  0 },
	{ /* 160:        11 1001 1001 */ 10,   921,  6, 11,  0,  0 },
	{ /* 161:        11 1001 1010 */ 10,   922, 10,  8,  0,  0 },
	{ /* 162:        11 1001 1011 */ 10,   923, 10,  7,  0,  0 },
	{ /* 163:        11 1001 1100 */ 10,   924, 14,  2,  0,  0 },
	{ /* 164:        11 1001 1101 */ 10,   925, 12,  4,  0,  0 },
	{ /* 165:        11 1001 1110 */ 10,   926,  1, 11,  0,  0 },
	{ /* 166:        11 1001 1111 */ 10,   927,  4, 12,  0,  0 },
	{ /* 167:        11 1010 0000 */ 10,   928, 11,  1,  0,  0 },
	{ /* 168:        11 1010 0001 */ 10,   929,  3, 12,  0,  0 },
	{ /* 169:        11 1010 0010 */ 10,   930,  1, 13,  0,  0 },
	{ /* 170:        11 1010 0011 */ 10,   931, 12,  2,  0,  0 },
	{ /* 171:        11 1010 0100 */ 10,   932,  7, 11,  0,  0 },
	{ /* 172:        11 1010 0101 */ 10,   933,  3, 14,  0,  0 },
	{ /* 173:        11 1010 0110 */ 10,   934,  5, 12,  0,  0 },
	{ /* 174:        11 1010 0111 */ 10,   935,  5, 13,  0,  0 },
	{ /* 175:        11 1010 1000 */ 10,   936, 14,  4,  0,  0 },
	{ /* 176:        11 1010 1001 */ 10,   937,  4, 14,  0,  0 },
	{ /* 177:        11 1010 1010 */ 10,   938, 11,  7,  0,  0 },
	{ /* 178:        11 1010 1011 */ 10,   939, 14,  3,  0,  0 },
	{ /* 179:        11 1010 1100 */ 10,   940, 12,  5,  0,  0 },
	{ /* 180:        11 1010 1101 */ 10,   941, 13,  6,  0,  0 },
	{ /* 181:        11 1010 1110 */ 10,   942, 12,  6,  0,  0 },
	{ /* 182:        11 1010 1111 */ 10,   943,  8,  0,  0,  0 },
	{ /* 183:        11 1011 0000 */ 10,   944, 11,  8,  0,  0 },
	{ /* 184:        11 1011 0001 */ 10,   945,  2, 12,  0,  0 },
	{ /* 185:        11 1011 0010 */ 10,   946,  9,  9,  0,  0 },
	{ /* 186:        11 1011 0011 */ 10,   947, 14,  5,  0,  0 },
	{ /* 187:        11 1011 0100 */ 10,   948,  6, 13,  0,  0 },
	{ /* 188:        11 1011 0101 */ 10,   949, 10, 10,  0,  0 },
	{ /* 189:        11 1011 0110 */ 10,   950, 15,  2,  0,  0 },
	{ /* 190:        11 1011 0111 */ 10,   951,  8, 11,  0,  0 },
	{ /* 191:        11 1011 1000 */ 10,   952,  9, 10,  0,  0 },
	{ /* 192:        11 1011 1001 */ 10,   953, 14,  6,  0,  0 },
	{ /* 193:        11 1011 1010 */ 10,   954, 10,  9,  0,  0 },
	{ /* 194:        11 1011 1011 */ 10,   955,  5, 14,  0,  0 },
	{ /* 195:        11 1011 1100 */ 10,   956, 11,  9,  0,  0 },
	{ /* 196:        11 1011 1101 */ 10,   957, 14,  1,  0,  0 },
	{ /* 197:        11 1011 1110 */ 10,   958,  2, 14,  0,  0 },
	{ /* 198:        11 1011 1111 */ 10,   959,  6, 12,  0,  0 },
	{ /* 199:        11 1100 0000 */ 10,   960,  1, 12,  0,  0 },
	{ /* 200:        11 1100 0001 */ 10,   961, 13,  8,  0,  0 },
	{ /* 201:        11 1100 0010 */ 10,   962,  0,  8,  0,  0 },
	{ /* 202:        11 1100 0011 */ 10,   963, 13,  7,  0,  0 },
	{ /* 203:        11 1100 0100 */ 10,   964,  7, 12,  0,  0 },
	{ /* 204:        11 1100 0101 */ 10,   965, 12,  7,  0,  0 },
	{ /* 205:        11 1100 0110 */ 10,   966,  7, 13,  0,  0 },
	{ /* 206:        11 1100 0111 */ 10,   967, 15,  3,  0,  0 },
	{ /* 207:        11 1100 1000 */ 10,   968, 12,  1,  0,  0 },
	{ /* 208:        11 1100 1001 */ 10,   969,  6, 14,  0,  0 },
	{ /* 209:        11 1100 1010 */ 10,   970,  2, 15,  0,  0 },
	{ /* 210:        11 1100 1011 */ 10,   971, 15,  5,  0,  0 },
	{ /* 211:        11 1100 1100 */ 10,   972, 15,  4,  0,  0 },
	{ /* 212:        11 1100 1101 */ 10,   973,  1, 14,  0,  0 },
	{ /* 213:        11 1100 1110 */ 10,   974,  9, 11,  0,  0 },
	{ /* 214:        11 1100 1111 */ 10,   975,  4, 15,  0,  0 },
	{ /* 215:        11 1101 0000 */ 10,   976, 14,  7,  0,  0 },
	{ /* 216:        11 1101 0001 */ 10,   977,  8, 13,  0,  0 },
	{ /* 217:        11 1101 0010 */ 10,   978, 13,  9,  0,  0 },
	{ /* 218:        11 1101 0011 */ 10,   979,  8, 12,  0,  0 },
	{ /* 219:        11 1101 0100 */ 10,   980,  5, 15,  0,  0 },
	{ /* 220:        11 1101 0101 */ 10,   981,  3, 15,  0,  0 },
	{ /* 221:        11 1101 0110 */ 10,   982, 10, 11,  0,  0 },
	{ /* 222:        11 1101 0111 */ 10,   983, 11, 10,  0,  0 },
	{ /* 223:        11 1101 1000 */ 10,   984, 12,  8,  0,  0 },
	{ /* 224:        11 1101 1001 */ 10,   985, 15,  6,  0,  0 },
	{ /* 225:        11 1101 1010 */ 10,   986, 15,  7,  0,  0 },
	{ /* 226:        11 1101 1011 */ 10,   987,  8, 14,  0,  0 },
	{ /* 227:        11 1101 1100 */ 10,   988, 15,  1,  0,  0 },
	{ /* 228:        11 1101 1101 */ 10,   989,  7, 14,  0,  0 },
	{ /* 229:        11 1101 1110 */ 10,   990,  9,  0,  0,  0 },
	{ /* 230:        11 1101 1111 */ 10,   991,  0,  9,  0,  0 },
	{ /* 231:        11 1110 0000 */ 10,   992,  9, 13,  0,  0 },
	{ /* 232:        11 1110 0001 */ 10,   993,  9, 12,  0,  0 },
	{ /* 233:        11 1110 0010 */ 10,   994, 12,  9,  0,  0 },
	{ /* 234:        11 1110 0011 */ 10,   995, 14,  8,  0,  0 },
	{ /* 235:        11 1110 0100 */ 10,   996, 10, 13,  0,  0 },
	{ /* 236:        11 1110 0101 */ 10,   997, 14,  9,  0,  0 },
	{ /* 237:        11 1110 0110 */ 10,   998, 12, 10,  0,  0 },
	{ /* 238:        11 1110 0111 */ 10,   999,  6, 15,  0,  0 },
	{ /* 239:        11 1110 1000 */ 10,  1000,  7, 15,  0,  0 },
	{ /* 240:       111 1101 0010 */ 11,  2002,  9, 14,  0,  0 },
	{ /* 241:       111 1101 0011 */ 11,  2003, 15,  8,  0,  0 },
	{ /* 242:       111 1101 0100 */ 11,  2004, 11, 11,  0,  0 },
	{ /* 243:       111 1101 0101 */ 11,  2005, 11, 14,  0,  0 },
	{ /* 244:       111 1101 0110 */ 11,  2006,  1, 15,  0,  0 },
	{ /* 245:       111 1101 0111 */ 11,  2007, 10, 12,  0,  0 },
	{ /* 246:       111 1101 1000 */ 11,  2008, 10, 14,  0,  0 },
	{ /* 247:       111 1101 1001 */ 11,  2009, 13, 11,  0,  0 },
	{ /* 248:       111 1101 1010 */ 11,  2010, 13, 10,  0,  0 },
	{ /* 249:       111 1101 1011 */ 11,  2011, 11, 13,  0,  0 },
	{ /* 250:       111 1101 1100 */ 11,  2012, 11, 12,  0,  0 },
	{ /* 251:       111 1101 1101 */ 11,  2013,  8, 15,  0,  0 },
	{ /* 252:       111 1101 1110 */ 11,  2014, 14, 11,  0,  0 },
	{ /* 253:       111 1101 1111 */ 11,  2015, 13, 12,  0,  0 },
	{ /* 254:       111 1110 0000 */ 11,  2016, 12, 13,  0,  0 },
	{ /* 255:       111 1110 0001 */ 11,  2017, 15,  9,  0,  0 },
	{ /* 256:       111 1110 0010 */ 11,  2018, 14, 10,  0,  0 },
	{ /* 257:       111 1110 0011 */ 11,  2019, 10,  0,  0,  0 },
	{ /* 258:       111 1110 0100 */ 11,  2020, 12, 11,  0,  0 },
	{ /* 259:       111 1110 0101 */ 11,  2021,  9, 15,  0,  0 },
	{ /* 260:       111 1110 0110 */ 11,  2022,  0, 10,  0,  0 },
	{ /* 261:       111 1110 0111 */ 11,  2023, 12, 12,  0,  0 },
	{ /* 262:       111 1110 1000 */ 11,  2024, 11,  0,  0,  0 },
	{ /* 263:       111 1110 1001 */ 11,  2025, 12, 14,  0,  0 },
	{ /* 264:       111 1110 1010 */ 11,  2026, 10, 15,  0,  0 },
	{ /* 265:       111 1110 1011 */ 11,  2027, 13, 13,  0,  0 },
	{ /* 266:       111 1110 1100 */ 11,  2028,  0, 13,  0,  0 },
	{ /* 267:       111 1110 1101 */ 11,  2029, 14, 12,  0,  0 },
	{ /* 268:       111 1110 1110 */ 11,  2030, 15, 10,  0,  0 },
	{ /* 269:       111 1110 1111 */ 11,  2031, 15, 11,  0,  0 },
	{ /* 270:       111 1111 0000 */ 11,  2032, 11, 15,  0,  0 },
	{ /* 271:       111 1111 0001 */ 11,  2033, 14, 13,  0,  0 },
	{ /* 272:       111 1111 0010 */ 11,  2034, 13,  0,  0,  0 },
	{ /* 273:       111 1111 0011 */ 11,  2035,  0, 11,  0,  0 },
	{ /* 274:       111 1111 0100 */ 11,  2036, 13, 14,  0,  0 },
	{ /* 275:       111 1111 0101 */ 11,  2037, 15, 12,  0,  0 },
	{ /* 276:       111 1111 0110 */ 11,  2038, 15, 13,  0,  0 },
	{ /* 277:       111 1111 0111 */ 11,  2039, 12, 15,  0,  0 },
	{ /* 278:       111 1111 1000 */ 11,  2040, 14,  0,  0,  0 },
	{ /* 279:       111 1111 1001 */ 11,  2041, 14, 14,  0,  0 },
	{ /* 280:       111 1111 1010 */ 11,  2042, 13, 15,  0,  0 },
	{ /* 281:       111 1111 1011 */ 11,  2043, 12,  0,  0,  0 },
	{ /* 282:       111 1111 1100 */ 11,  2044, 14, 15,  0,  0 },
	{ /* 283:      1111 1111 1010 */ 12,  4090,  0, 14,  0,  0 },
	{ /* 284:      1111 1111 1011 */ 12,  4091,  0, 12,  0,  0 },
	{ /* 285:      1111 1111 1100 */ 12,  4092, 15, 14,  0,  0 },
	{ /* 286:      1111 1111 1101 */ 12,  4093, 15,  0,  0,  0 },
	{ /* 287:      1111 1111 1110 */ 12,  4094,  0, 15,  0,  0 },
	{ /* 288:      1111 1111 1111 */ 12,  4095, 15, 15,  0,  0 }
};

Huffscl bookscl[] = {
	  /* idx                 codeword   len   codew  idx */
	{ /*   0:                       0 */  1,      0,  60 },
	{ /*   1:                     100 */  3,      4,  59 },
	{ /*   2:                    1010 */  4,     10,  61 },
	{ /*   3:                    1011 */  4,     11,  58 },
	{ /*   4:                    1100 */  4,     12,  62 },
	{ /*   5:                  1 1010 */  5,     26,  57 },
	{ /*   6:                  1 1011 */  5,     27,  63 },
	{ /*   7:                 11 1000 */  6,     56,  56 },
	{ /*   8:                 11 1001 */  6,     57,  64 },
	{ /*   9:                 11 1010 */  6,     58,  55 },
	{ /*  10:                 11 1011 */  6,     59,  65 },
	{ /*  11:                111 1000 */  7,    120,  66 },
	{ /*  12:                111 1001 */  7,    121,  54 },
	{ /*  13:                111 1010 */  7,    122,  67 },
	{ /*  14:               1111 0110 */  8,    246,  53 },
	{ /*  15:               1111 0111 */  8,    247,  68 },
	{ /*  16:               1111 1000 */  8,    248,  52 },
	{ /*  17:               1111 1001 */  8,    249,  69 },
	{ /*  18:               1111 1010 */  8,    250,  51 },
	{ /*  19:             1 1111 0110 */  9,    502,  70 },
	{ /*  20:             1 1111 0111 */  9,    503,  50 },
	{ /*  21:             1 1111 1000 */  9,    504,  49 },
	{ /*  22:             1 1111 1001 */  9,    505,  71 },
	{ /*  23:            11 1111 0100 */ 10,   1012,  72 },
	{ /*  24:            11 1111 0101 */ 10,   1013,  48 },
	{ /*  25:            11 1111 0110 */ 10,   1014,  73 },
	{ /*  26:            11 1111 0111 */ 10,   1015,  47 },
	{ /*  27:            11 1111 1000 */ 10,   1016,  74 },
	{ /*  28:            11 1111 1001 */ 10,   1017,  46 },
	{ /*  29:           111 1111 0100 */ 11,   2036,  76 },
	{ /*  30:           111 1111 0101 */ 11,   2037,  75 },
	{ /*  31:           111 1111 0110 */ 11,   2038,  77 },
	{ /*  32:           111 1111 0111 */ 11,   2039,  78 },
	{ /*  33:           111 1111 1000 */ 11,   2040,  45 },
	{ /*  34:           111 1111 1001 */ 11,   2041,  43 },
	{ /*  35:          1111 1111 0100 */ 12,   4084,  44 },
	{ /*  36:          1111 1111 0101 */ 12,   4085,  79 },
	{ /*  37:          1111 1111 0110 */ 12,   4086,  42 },
	{ /*  38:          1111 1111 0111 */ 12,   4087,  41 },
	{ /*  39:          1111 1111 1000 */ 12,   4088,  80 },
	{ /*  40:          1111 1111 1001 */ 12,   4089,  40 },
	{ /*  41:        1 1111 1111 0100 */ 13,   8180,  81 },
	{ /*  42:        1 1111 1111 0101 */ 13,   8181,  39 },
	{ /*  43:        1 1111 1111 0110 */ 13,   8182,  82 },
	{ /*  44:        1 1111 1111 0111 */ 13,   8183,  38 },
	{ /*  45:        1 1111 1111 1000 */ 13,   8184,  83 },
	{ /*  46:       11 1111 1111 0010 */ 14,  16370,  37 },
	{ /*  47:       11 1111 1111 0011 */ 14,  16371,  35 },
	{ /*  48:       11 1111 1111 0100 */ 14,  16372,  85 },
	{ /*  49:       11 1111 1111 0101 */ 14,  16373,  33 },
	{ /*  50:       11 1111 1111 0110 */ 14,  16374,  36 },
	{ /*  51:       11 1111 1111 0111 */ 14,  16375,  34 },
	{ /*  52:       11 1111 1111 1000 */ 14,  16376,  84 },
	{ /*  53:       11 1111 1111 1001 */ 14,  16377,  32 },
	{ /*  54:      111 1111 1111 0100 */ 15,  32756,  87 },
	{ /*  55:      111 1111 1111 0101 */ 15,  32757,  89 },
	{ /*  56:      111 1111 1111 0110 */ 15,  32758,  30 },
	{ /*  57:      111 1111 1111 0111 */ 15,  32759,  31 },
	{ /*  58:     1111 1111 1111 0000 */ 16,  65520,  86 },
	{ /*  59:     1111 1111 1111 0001 */ 16,  65521,  29 },
	{ /*  60:     1111 1111 1111 0010 */ 16,  65522,  26 },
	{ /*  61:     1111 1111 1111 0011 */ 16,  65523,  27 },
	{ /*  62:     1111 1111 1111 0100 */ 16,  65524,  28 },
	{ /*  63:     1111 1111 1111 0101 */ 16,  65525,  24 },
	{ /*  64:     1111 1111 1111 0110 */ 16,  65526,  88 },
	{ /*  65:   1 1111 1111 1110 1110 */ 17, 131054,  25 },
	{ /*  66:   1 1111 1111 1110 1111 */ 17, 131055,  22 },
	{ /*  67:   1 1111 1111 1111 0000 */ 17, 131056,  23 },
	{ /*  68:  11 1111 1111 1110 0010 */ 18, 262114,  90 },
	{ /*  69:  11 1111 1111 1110 0011 */ 18, 262115,  21 },
	{ /*  70:  11 1111 1111 1110 0100 */ 18, 262116,  19 },
	{ /*  71:  11 1111 1111 1110 0101 */ 18, 262117,   3 },
	{ /*  72:  11 1111 1111 1110 0110 */ 18, 262118,   1 },
	{ /*  73:  11 1111 1111 1110 0111 */ 18, 262119,   2 },
	{ /*  74:  11 1111 1111 1110 1000 */ 18, 262120,   0 },
	{ /*  75: 111 1111 1111 1101 0010 */ 19, 524242,  98 },
	{ /*  76: 111 1111 1111 1101 0011 */ 19, 524243,  99 },
	{ /*  77: 111 1111 1111 1101 0100 */ 19, 524244, 100 },
	{ /*  78: 111 1111 1111 1101 0101 */ 19, 524245, 101 },
	{ /*  79: 111 1111 1111 1101 0110 */ 19, 524246, 102 },
	{ /*  80: 111 1111 1111 1101 0111 */ 19, 524247, 117 },
	{ /*  81: 111 1111 1111 1101 1000 */ 19, 524248,  97 },
	{ /*  82: 111 1111 1111 1101 1001 */ 19, 524249,  91 },
	{ /*  83: 111 1111 1111 1101 1010 */ 19, 524250,  92 },
	{ /*  84: 111 1111 1111 1101 1011 */ 19, 524251,  93 },
	{ /*  85: 111 1111 1111 1101 1100 */ 19, 524252,  94 },
	{ /*  86: 111 1111 1111 1101 1101 */ 19, 524253,  95 },
	{ /*  87: 111 1111 1111 1101 1110 */ 19, 524254,  96 },
	{ /*  88: 111 1111 1111 1101 1111 */ 19, 524255, 104 },
	{ /*  89: 111 1111 1111 1110 0000 */ 19, 524256, 111 },
	{ /*  90: 111 1111 1111 1110 0001 */ 19, 524257, 112 },
	{ /*  91: 111 1111 1111 1110 0010 */ 19, 524258, 113 },
	{ /*  92: 111 1111 1111 1110 0011 */ 19, 524259, 114 },
	{ /*  93: 111 1111 1111 1110 0100 */ 19, 524260, 115 },
	{ /*  94: 111 1111 1111 1110 0101 */ 19, 524261, 116 },
	{ /*  95: 111 1111 1111 1110 0110 */ 19, 524262, 110 },
	{ /*  96: 111 1111 1111 1110 0111 */ 19, 524263, 105 },
	{ /*  97: 111 1111 1111 1110 1000 */ 19, 524264, 106 },
	{ /*  98: 111 1111 1111 1110 1001 */ 19, 524265, 107 },
	{ /*  99: 111 1111 1111 1110 1010 */ 19, 524266, 108 },
	{ /* 100: 111 1111 1111 1110 1011 */ 19, 524267, 109 },
	{ /* 101: 111 1111 1111 1110 1100 */ 19, 524268, 118 },
	{ /* 102: 111 1111 1111 1110 1101 */ 19, 524269,   6 },
	{ /* 103: 111 1111 1111 1110 1110 */ 19, 524270,   8 },
	{ /* 104: 111 1111 1111 1110 1111 */ 19, 524271,   9 },
	{ /* 105: 111 1111 1111 1111 0000 */ 19, 524272,  10 },
	{ /* 106: 111 1111 1111 1111 0001 */ 19, 524273,   5 },
	{ /* 107: 111 1111 1111 1111 0010 */ 19, 524274, 103 },
	{ /* 108: 111 1111 1111 1111 0011 */ 19, 524275, 120 },
	{ /* 109: 111 1111 1111 1111 0100 */ 19, 524276, 119 },
	{ /* 110: 111 1111 1111 1111 0101 */ 19, 524277,   4 },
	{ /* 111: 111 1111 1111 1111 0110 */ 19, 524278,   7 },
	{ /* 112: 111 1111 1111 1111 0111 */ 19, 524279,  15 },
	{ /* 113: 111 1111 1111 1111 1000 */ 19, 524280,  16 },
	{ /* 114: 111 1111 1111 1111 1001 */ 19, 524281,  18 },
	{ /* 115: 111 1111 1111 1111 1010 */ 19, 524282,  20 },
	{ /* 116: 111 1111 1111 1111 1011 */ 19, 524283,  17 },
	{ /* 117: 111 1111 1111 1111 1100 */ 19, 524284,  11 },
	{ /* 118: 111 1111 1111 1111 1101 */ 19, 524285,  12 },
	{ /* 119: 111 1111 1111 1111 1110 */ 19, 524286,  14 },
	{ /* 120: 111 1111 1111 1111 1111 */ 19, 524287,  13 }
};
