/*
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * Copyright (c) 1999-2001 Apple Computer, Inc.  All Rights Reserved. The
 * contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License.  Please
 * obtain a copy of the License at http://www.apple.com/publicsource and
 * read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.  Please
 * see the License for the specific language governing rights and
 * limitations under the License.
 *
 *
 * @APPLE_LICENSE_HEADER_END@
 *
 */
// $Id: QTAtom_stco.cpp,v 1.2 2001/10/01 22:08:39 dmackie Exp $
//
// QTAtom_stco:
//   The 'stco' QTAtom class.


// -------------------------------------
// Includes
//
#include <stdio.h>
#include <stdlib.h>

#include "QTFile.h"

#include "QTAtom.h"
#include "QTAtom_stco.h"
#include "OSMemory.h"


// -------------------------------------
// Constants
//
const int		stcoPos_VersionFlags		=  0;
const int		stcoPos_NumEntries			=  4;
const int		stcoPos_SampleTable			=  8;



// -------------------------------------
// Macros
//
#define DEBUG_PRINT(s) if(fDebug) printf s
#define DEEP_DEBUG_PRINT(s) if(fDeepDebug) printf s



// -------------------------------------
// Constructors and destructors
//
QTAtom_stco::QTAtom_stco(QTFile * File, QTFile::AtomTOCEntry * TOCEntry, Bool16 Debug, Bool16 DeepDebug)
	: QTAtom(File, TOCEntry, Debug, DeepDebug),
	  fNumEntries(0), fChunkOffsetTable(NULL), fTable(NULL)
{
}

QTAtom_stco::~QTAtom_stco(void)
{
	//
	// Free our variables.
	if( fChunkOffsetTable != NULL )
		delete[] fChunkOffsetTable;
}



// -------------------------------------
// Initialization functions
//
Bool16 QTAtom_stco::Initialize(void)
{
	// Temporary vars
	UInt32		tempInt32;


	//
	// Parse this atom's fields.
	ReadInt32(stcoPos_VersionFlags, &tempInt32);
	fVersion = (UInt8)((tempInt32 >> 24) & 0x000000ff);
	fFlags = tempInt32 & 0x00ffffff;

	ReadInt32(stcoPos_NumEntries, &fNumEntries);

	//
	// Validate the size of the sample table.
	if( (unsigned long)(fNumEntries * 4) != (fTOCEntry.AtomDataLength - 8) )
		return false;

	//
	// Read in the chunk offset table.
	fChunkOffsetTable = NEW char[(fNumEntries * 4) + 1];
	if( fChunkOffsetTable == NULL )
		return false;
	
	if( ((PointerSizedInt)fChunkOffsetTable & (PointerSizedInt)0x3) == 0)
		fTable = (UInt32 *)fChunkOffsetTable;
	else
		fTable = (UInt32 *)(((PointerSizedInt)fChunkOffsetTable + 4) & ~((PointerSizedInt)0x3));
	
	ReadBytes(stcoPos_SampleTable, (char *)fTable, fNumEntries * 4);

	//
	// This atom has been successfully read in.
	return true;
}



// -------------------------------------
// Debugging functions
//
void QTAtom_stco::DumpAtom(void)
{
	DEBUG_PRINT(("QTAtom_stco::DumpAtom - Dumping atom.\n"));
	DEBUG_PRINT(("QTAtom_stco::DumpAtom - ..Number of chunk offset entries: %ld\n", fNumEntries));
}

void QTAtom_stco::DumpTable(void)
{
	//
	// Print out a header.
	printf("-- Chunk Offset table ----------------------------------------------------------\n");
	printf("\n");
	printf("  Chunk Num.     Offset\n");
	printf("  ----------   ----------\n");
	
	//
	// Print the table.
	for( UInt32 CurEntry = 1; CurEntry <= fNumEntries; CurEntry++ ) {
		//
		// Print out a listing.
		printf("  %10lu : %10lu\n", CurEntry, fTable[CurEntry-1]);
	}
}
