/* Coeffs for last = 0, run = 0. Indexed by [level-1] */

static const UINT8 coeff_tab4[27][2] =
{
    /* run = 0 */
    {0x02, 2}, {0x06, 3}, {0x0f, 4}, {0x0d, 5},
    {0x0c, 5}, {0x15, 6}, {0x13, 6}, {0x12, 6}, 
    {0x17, 7}, {0x1f, 8}, {0x1e, 8}, {0x1d, 8},
    {0x25, 9}, {0x24, 9}, {0x23, 9}, {0x21, 9},
    {0x21,10}, {0x20,10}, {0x0f,10}, {0x0e,10},
    {0x07,11}, {0x06,11}, {0x20,11}, {0x21,11},
    {0x50,12}, {0x51,12}, {0x52,12}
};

/* Coeffs for last = 0, run = 1. Indexed by [level-1] */

static const UINT8 coeff_tab5[10][2] =
{
    {0x0e, 4}, {0x14, 6}, {0x16, 7}, {0x1c, 8},
    {0x20, 9}, {0x1f, 9}, {0x0d,10}, {0x22,11},
    {0x53,12}, {0x55,12}
};

/* Coeffs for last = 0, run = 2 -> 9. Indexed by [run-2][level-1] */

static const UINT8 coeff_tab6[8][5][2] =
{
    /* run = 2 */
    {
	{0x0b, 5}, {0x15, 7}, {0x1e, 9}, {0x0c,10},
	{0x56,12}
    },
    /* run = 3 */
    {
	{0x11, 6}, {0x1b, 8}, {0x1d, 9}, {0x0b,10},
	{0x00, 0}
    },
    /* run = 4 */
    {
	{0x10, 6}, {0x22, 9}, {0x0a,10}, {0x00, 0},
	{0x00, 0}
    },
    /* run = 5 */
    {
	{0x0d, 6}, {0x1c, 9}, {0x08,10}, {0x00, 0},
	{0x00, 0}
    },
    /* run = 6 */
    {
	{0x12, 7}, {0x1b, 9}, {0x54,12}, {0x00, 0},
	{0x00, 0}
    },
    /* run = 7 */
    {
	{0x14, 7}, {0x1a, 9}, {0x57,12}, {0x00, 0},
	{0x00, 0}
    },
    /* run = 8 */
    {
	{0x19, 8}, {0x09,10}, {0x00, 0}, {0x00, 0},
	{0x00, 0}
    },
    /* run = 9 */
    {
	{0x18, 8}, {0x23,11}, {0x00, 0}, {0x00, 0},
	{0x00, 0}
    }
};

/* Coeffs for last = 0, run = 10 -> 14. Indexed by [run-10] */

static const UINT8 coeff_tab7[5][2] =
{
    {0x17, 8}, {0x19, 9}, {0x18, 9}, {0x07,10},
    {0x58,12}
};

/* Coeffs for last = 1, run = 0. Indexed by [level-1] */

static const UINT8 coeff_tab8[8][2] =
{
    {0x07, 4}, {0x0c, 6}, {0x16, 8}, {0x17, 9},
    {0x06,10}, {0x05,11}, {0x04,11}, {0x59,12}
};

/* Coeffs for last = 1, run = 1 -> 6. Indexed by [run-1][level-1] */

static const UINT8 coeff_tab9[6][3][2] =
{
    /* run = 1 */
    {
	{0x0f, 6}, {0x16, 9}, {0x05,10}
    },
    /* run = 2 */
    {
	{0x0e, 6}, {0x04,10}, {0x00, 0}
    },
    /* run = 3 */
    {
	{0x11, 7}, {0x24,11}, {0x00, 0}
    },
    /* run = 4 */
    {
	{0x10, 7}, {0x25,11}, {0x00, 0}
    },
    /* run = 5 */
    {
	{0x13, 7}, {0x5a,12}, {0x00, 0}
    },
    /* run = 6 */
    {
	{0x15, 8}, {0x5b,12}, {0x00, 0}
    }
};

/* Coeffs for last = 1, run = 7 -> 20. Indexed by [run-7] */

static const UINT8 coeff_tab10[14][2] =
{
    {0x14, 8}, {0x13, 8}, {0x1a, 8}, {0x15, 9},
    {0x14, 9}, {0x13, 9}, {0x12, 9}, {0x11, 9},
    {0x26,11}, {0x27,11}, {0x5c,12}, {0x5d,12},
    {0x5e,12}, {0x5f,12}
};


/* dc encoding for mpeg4 */
static const UINT8 DCtab_lum[13][2] =
{
    {3,3}, {3,2}, {2,2}, {2,3}, {1,3}, {1,4}, {1,5}, {1,6}, {1,7},
    {1,8}, {1,9}, {1,10}, {1,11},
}; 

static const UINT8 DCtab_chrom[13][2] =
{
    {3,2}, {2,2}, {1,2}, {1,3}, {1,4}, {1,5}, {1,6}, {1,7}, {1,8},
    {1,9}, {1,10}, {1,11}, {1,12},
}; 

static const UINT8 intra_max_level[2][64] = 
{
	{
		27, 10,  5,  4,  3,  3,  3,  3, 
		2,  2,  1,  1,  1,  1,  1,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
	},

	{
		8,  3,  2,  2,  2,  2,  2,  1, 
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  1,  1,  1,  1,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0
	}
};


static const UINT8 inter_max_level[2][64] = 
{
	{
		12,  6,  4,  3,  3,  3,  3,  2, 
		2,  2,  2,  1,  1,  1,  1,  1,
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  1,  1,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0
	},

	{
		3,  2,  1,  1,  1,  1,  1,  1, 
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  1,  1,  1,  1,  1,  1,  1,
		1,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0
	}
};


static const UINT16 intra_max_run[2][28] = 
{ 
    {
	999, 14,  9,  7,  3,  2,  1,   
	1,  1,  1,  1,  0,  0,  0, 
	0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0
    },
    {
	999, 20,  6,  
	1,  0,  0,  
	0,  0,  0
    },
};


static const UINT16 inter_max_run[2][13] = 
{
    { 
        999, 
	26, 10,  6,  2,  1,  1,   
        0,  0,  0,  0,  0,  0
    },
    {
	999, 40,  1,  0
    },
};

