/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.SplitPaneUI;
import com.sun.java.swing.plaf.basic.BasicSplitPaneDivider;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicSplitPaneUI
extends SplitPaneUI
implements PropertyChangeListener,
Serializable {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected JSplitPane splitPane;
    private int orientation;
    protected BasicHorizontalLayoutManager layoutManager;
    private boolean continuousLayout;
    protected BasicSplitPaneDivider divider;
    private int lastDragLocation;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int n) {
        this.lastDragLocation = n;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSplitPaneUI();
    }

    public BasicSplitPaneUI() {
        this.setLastDragLocation(-1);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.splitPane.layout();
    }

    protected void installDefaults(JComponent jComponent) {
        this.splitPane = (JSplitPane)jComponent;
        LookAndFeel.installBorder(jComponent, "SplitPane.border");
        if (this.divider == null) {
            this.divider = this.createDefaultDivider();
        }
        this.divider.setBasicSplitPaneUI(this);
        this.splitPane.setDividerSize((Integer)UIManager.get("SplitPane.dividerSize"));
        this.divider.setDividerSize(this.splitPane.getDividerSize());
        this.splitPane.add((Component)this.divider, "divider");
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
            return;
        }
        this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
    }

    protected void installListeners(JComponent jComponent) {
        this.splitPane.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(jComponent);
        this.uninstallDefaults(jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        this.splitPane.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        if (this.splitPane.getLayout() == this.layoutManager) {
            this.splitPane.setLayout(null);
        }
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.splitPane.remove(this.divider);
        this.divider.setBasicSplitPaneUI(null);
        this.splitPane = null;
        this.layoutManager = null;
        this.setNonContinuousLayoutDivider(null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation")) {
                this.orientation = this.splitPane.getOrientation();
                this.resetLayoutManager();
                return;
            }
            if (string.equals("continuousLayout")) {
                this.setContinuousLayout(this.splitPane.isContinuousLayout());
                if (!this.isContinuousLayout()) {
                    if (this.nonContinuousLayoutDivider == null) {
                        this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
                        return;
                    }
                    if (this.nonContinuousLayoutDivider.getParent() == null) {
                        this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
                        return;
                    }
                }
            } else if (string.equals("dividerSize")) {
                this.divider.setDividerSize(this.splitPane.getDividerSize());
                this.layoutManager.resetSizeAt(2);
                this.splitPane.invalidate();
                this.splitPane.validate();
            }
        }
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new 1();
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = component;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.nonContinuousLayoutDivider.setLocation(-1000, -1000);
            Component component2 = this.splitPane.getLeftComponent();
            Component component3 = this.splitPane.getRightComponent();
            int[] nArray = this.layoutManager.getSizes();
            if (component2 != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (component3 != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(component2);
            this.splitPane.setRightComponent(component3);
            this.splitPane.add((Component)this.divider, "divider");
            if (bl) {
                this.layoutManager.setSizes(nArray);
            }
            this.splitPane.validate();
            this.splitPane.paintImmediately(this.splitPane.getX(), this.splitPane.getY(), this.splitPane.getWidth(), this.splitPane.getHeight());
        }
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this);
    }

    public void resetToPreferredSizes() {
        if (this.splitPane != null) {
            this.layoutManager.resetToPreferredSizes();
            this.splitPane.validate();
            this.layoutManager.layoutContainer(this.splitPane);
        }
    }

    public void setDividerLocation(int n) {
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        if (component != null && component2 != null) {
            Insets insets = this.splitPane.getInsets();
            if (insets != null) {
                if (this.orientation == 1) {
                    component.setSize(Math.max(0, n - insets.left), 10);
                } else {
                    component.setSize(10, Math.max(0, n - insets.top));
                }
            } else if (this.orientation == 1) {
                component.setSize(Math.max(0, n), 10);
            } else {
                component.setSize(10, Math.max(0, n));
            }
            this.splitPane.validate();
            this.splitPane.repaint();
        }
    }

    public int getDividerLocation() {
        if (this.orientation == 1) {
            return this.divider.getLocation().x;
        }
        return this.divider.getLocation().y;
    }

    public int getMinimumDividerLocation() {
        int n = 0;
        Component component = this.splitPane.getLeftComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width : dimension.height;
            n += this.getDividerBorderSize();
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return n;
    }

    public int getMaximumDividerLocation() {
        Dimension dimension = this.splitPane.getSize();
        int n = 0;
        Component component = this.splitPane.getRightComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension2 = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width - dimension2.width : dimension.height - dimension2.height;
            n -= this.dividerSize + this.getDividerBorderSize();
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(), n);
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension dimension = this.splitPane.getSize();
            graphics.setColor(Color.darkGray);
            if (this.orientation == 1) {
                graphics.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, dimension.height - 1);
                return;
            }
            graphics.fillRect(0, this.lastDragLocation, dimension.width - 1, this.dividerSize - 1);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.preferredLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.minimumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.maximumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Insets getInsets(JComponent jComponent) {
        return null;
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.orientation == 1 ? new BasicHorizontalLayoutManager() : new BasicVerticalLayoutManager();
        this.splitPane.setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.splitPane.validate();
        this.splitPane.repaint();
    }

    protected void startDragging() {
        ComponentPeer componentPeer;
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation();
        this.draggingHW = false;
        if (component != null && (componentPeer = component.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (component2 != null && (componentPeer = component2.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width + 2 * this.getDividerBorderSize();
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
                return;
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height + 2 * this.getDividerBorderSize();
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
            }
        }
    }

    protected void dragDividerTo(int n) {
        if (this.getLastDragLocation() != n) {
            if (this.isContinuousLayout()) {
                Component component = this.splitPane.getLeftComponent();
                Rectangle rectangle = component.getBounds();
                if (this.orientation == 1) {
                    component.setSize(n - rectangle.x, rectangle.height);
                } else {
                    component.setSize(rectangle.width, n - rectangle.y);
                }
                this.splitPane.validate();
                this.splitPane.repaint();
                this.setLastDragLocation(n);
                return;
            }
            int n2 = this.getLastDragLocation();
            this.setLastDragLocation(n);
            if (this.orientation == 1) {
                int n3 = this.splitPane.getSize().height;
                if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    return;
                }
                this.splitPane.repaint(n2, 0, this.dividerSize, n3);
                this.splitPane.repaint(n, 0, this.dividerSize, n3);
                return;
            }
            int n4 = this.splitPane.getSize().width;
            if (this.draggingHW) {
                this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                return;
            }
            this.splitPane.repaint(0, n2, n4, this.dividerSize);
            this.splitPane.repaint(0, n, n4, this.dividerSize);
        }
    }

    protected void finishDraggingTo(int n) {
        this.dragDividerTo(n);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component component = this.splitPane.getLeftComponent();
            Rectangle rectangle = component.getBounds();
            if (this.orientation == 1) {
                int n2 = this.splitPane.getSize().height;
                component.setSize(n - rectangle.x, rectangle.height);
                if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                }
                this.splitPane.paintImmediately(n, 0, this.dividerSize, n2);
            } else {
                int n3 = this.splitPane.getSize().width;
                component.setSize(rectangle.width, n - rectangle.y);
                if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.paintImmediately(0, n, n3, this.dividerSize);
            }
            this.splitPane.validate();
            this.splitPane.repaint();
        }
        this.splitPane.setLastDividerLocation(this.beginDragDividerLocation);
    }

    protected int getDividerBorderSize() {
        return 1;
    }

    private final class 1
    extends Canvas {
        public void paint(Graphics graphics) {
            if (!BasicSplitPaneUI.this.isContinuousLayout() && BasicSplitPaneUI.this.getLastDragLocation() != -1) {
                Dimension dimension = BasicSplitPaneUI.this.splitPane.getSize();
                graphics.setColor(Color.darkGray);
                if (BasicSplitPaneUI.this.orientation == 1) {
                    graphics.fillRect(0, 0, BasicSplitPaneUI.this.dividerSize - 1, dimension.height - 1);
                    return;
                }
                graphics.fillRect(0, 0, dimension.width - 1, BasicSplitPaneUI.this.dividerSize - 1);
            }
        }

        /* synthetic */ 1() {
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2,
    Serializable {
        protected int[] sizes;
        protected Component[] components = new Component[3];
        protected int dividerLocation;

        BasicHorizontalLayoutManager() {
            BasicSplitPaneUI.this = BasicSplitPaneUI.this;
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
            this.dividerLocation = -1;
        }

        protected void resetSizeAt(int n) {
            this.sizes[n] = -1;
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizes, 0, 3);
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizes, 0, nArray, 0, 3);
            return nArray;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return component.getPreferredSize().width;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getSize().width;
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return dimension.width;
            }
            return dimension.width - (insets.left + insets.right + 2 * BasicSplitPaneUI.this.getDividerBorderSize());
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.left;
            }
            return 0;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                component.setBounds(n2, insets.top, n, dimension.height - (insets.top + insets.bottom));
                return;
            }
            component.setBounds(n2, 0, n, dimension.height);
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            Dimension dimension = container.getSize();
            if (dimension.height == 0 || dimension.width == 0) {
                return;
            }
            int n3 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n4 = this.getAvailableSize(dimension, insets);
            int n5 = BasicSplitPaneUI.this.splitPane.getDividerLocation();
            int n6 = 0;
            while (n6 < 3) {
                if (this.components[n6] != null) {
                    if (this.sizes[n6] == -1) {
                        this.sizes[n6] = Math.min(n4, this.getPreferredSizeOfComponent(this.components[n6]));
                    } else {
                        n2 = this.getSizeOfComponent(this.components[n6]);
                        if (this.sizes[n6] != n2) {
                            if (n6 == 0) {
                                if (this.components[1] != null) {
                                    this.sizes[1] = Math.max(0, this.sizes[1] + (this.sizes[n6] - n2));
                                }
                            } else if (n6 == 1 && this.components[0] != null) {
                                this.sizes[0] = Math.max(0, this.sizes[0] + (this.sizes[n6] - n2));
                            }
                            this.sizes[n6] = n2;
                            if (n6 == 0) {
                                n6 = 1;
                            }
                        }
                    }
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < 3) {
                n3 += this.sizes[n6];
                ++n6;
            }
            if (n3 != n4) {
                n = n4 - n3;
                if (this.components[1] != null) {
                    n2 = Math.max(0, this.sizes[1] + n);
                    if (n2 == 0) {
                        n += this.sizes[1];
                        this.sizes[1] = 0;
                        if (this.components[0] != null) {
                            this.sizes[0] = Math.max(0, this.sizes[0] + n);
                        }
                    } else {
                        this.sizes[1] = n2;
                    }
                } else if (this.components[0] != null) {
                    this.sizes[0] = Math.max(0, this.sizes[0] + n);
                }
            }
            n = this.getInitialLocation(insets);
            int n7 = BasicSplitPaneUI.this.getDividerBorderSize();
            n6 = 0;
            while (n6 < 3) {
                if (this.components[n6] != null) {
                    this.setComponentToSize(this.components[n6], this.sizes[n6], n, insets, dimension);
                    n += this.sizes[n6];
                }
                switch (n6) {
                    case 0: {
                        n6 = 2;
                        n += n7;
                        break;
                    }
                    case 2: {
                        n6 = 1;
                        n += n7;
                        break;
                    }
                    case 1: {
                        n6 = 3;
                        break;
                    }
                }
            }
            if (n5 != BasicSplitPaneUI.this.splitPane.getDividerLocation()) {
                BasicSplitPaneUI.this.splitPane.setLastDividerLocation(n5);
            }
        }

        public void addLayoutComponent(String string, Component component) {
            boolean bl = true;
            if (string != null) {
                if (string.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = -1;
                } else if (string.equals("left") || string.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = -1;
                } else if (string.equals("right") || string.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = -1;
                } else if (!string.equals(BasicSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getMinimumSize();
                    n2 += dimension.width;
                    if (dimension.height > n) {
                        n = dimension.height;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n2 += insets.left + insets.right;
                n += insets.bottom + insets.top;
            }
            return new Dimension(n2, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getPreferredSize();
                    n2 += dimension.width;
                    if (dimension.height > n) {
                        n = dimension.height;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n2 += insets.left + insets.right;
                n += insets.bottom + insets.top;
            }
            return new Dimension(n2, n);
        }

        public void removeLayoutComponent(Component component) {
            int n = 0;
            while (n < 3) {
                if (this.components[n] == component) {
                    this.components[n] = null;
                    this.sizes[n] = 0;
                }
                ++n;
            }
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object == null || object instanceof String) {
                this.addLayoutComponent((String)object, component);
                return;
            }
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void resetToPreferredSizes() {
            int n = 0;
            while (n < 3) {
                this.sizes[n] = -1;
                ++n;
            }
        }

        protected void updateComponents() {
            Component component = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.components[0] != component) {
                this.components[0] = component;
                this.sizes[0] = component == null ? 0 : -1;
            }
            if (this.components[1] != (component = BasicSplitPaneUI.this.splitPane.getRightComponent())) {
                this.components[1] = component;
                this.sizes[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = BasicSplitPaneUI.this.splitPane.getComponents();
            Component component2 = this.components[2];
            this.components[2] = null;
            int n = componentArray.length - 1;
            while (n >= 0) {
                if (componentArray[n] != this.components[0] && componentArray[n] != this.components[1] && componentArray[n] != BasicSplitPaneUI.this.nonContinuousLayoutDivider) {
                    if (component2 != componentArray[n]) {
                        this.components[2] = componentArray[n];
                        if (componentArray[n] == null) {
                            this.sizes[2] = 0;
                            break;
                        }
                        this.sizes[2] = -1;
                        break;
                    }
                    this.components[2] = component2;
                    break;
                }
                --n;
            }
            if (this.components[2] == null) {
                this.sizes[2] = 0;
            }
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager
    implements Serializable {
        protected int getPreferredSizeOfComponent(Component component) {
            return component.getPreferredSize().height;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getSize().height;
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return dimension.height;
            }
            return dimension.height - (insets.bottom + insets.top + 2 * BasicSplitPaneUI.this.getDividerBorderSize());
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.top;
            }
            return 0;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                component.setBounds(insets.left, n2, dimension.width - (insets.left + insets.right), n);
                return;
            }
            component.setBounds(0, n2, dimension.width, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getMinimumSize();
                    n += dimension.height;
                    if (dimension.width > n2) {
                        n2 = dimension.width;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n2 += insets.left + insets.right;
                n += insets.bottom + insets.top;
            }
            return new Dimension(n2, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getPreferredSize();
                    n += dimension.height;
                    if (dimension.width > n2) {
                        n2 = dimension.width;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n2 += insets.left + insets.right;
                n += insets.bottom + insets.top;
            }
            return new Dimension(n2, n);
        }

        public BasicVerticalLayoutManager() {
            BasicSplitPaneUI.this = BasicSplitPaneUI.this;
        }
    }

    public static class SplitBorder
    implements Border,
    Serializable {
        private Color highlightColor;
        private Color shadowColor;

        public SplitBorder(Color color, Color color2) {
            this.highlightColor = color;
            this.shadowColor = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JSplitPane jSplitPane = (JSplitPane)component;
            Component component2 = jSplitPane.getLeftComponent();
            if (jSplitPane.getOrientation() == 1) {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height + 2);
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(1, rectangle.height + 1, rectangle.width + 2, rectangle.height + 1);
                    graphics.drawLine(rectangle.width + 1, 1, rectangle.width + 1, rectangle.height + 2);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n5 = rectangle.x + rectangle.width;
                    int n6 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(rectangle.x - 1, 0, n5, 0);
                    graphics.drawLine(rectangle.x - 1, n6, rectangle.x, n6);
                    graphics.drawLine(rectangle.x - 1, 0, rectangle.x - 1, n6);
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(rectangle.x, n6, n5, n6);
                    graphics.drawLine(n5, 0, n5, n6 + 1);
                    return;
                }
            } else {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height + 1);
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(1 + rectangle.width, 0, 1 + rectangle.width, rectangle.height + 1);
                    graphics.drawLine(0, rectangle.height + 1, rectangle.width, rectangle.height + 1);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n7 = rectangle.x + rectangle.width;
                    int n8 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadowColor);
                    graphics.drawLine(0, rectangle.y - 1, 0, n8);
                    graphics.drawLine(n7, rectangle.y - 1, n7, rectangle.y);
                    graphics.drawLine(0, rectangle.y - 1, rectangle.width, rectangle.y - 1);
                    graphics.setColor(this.highlightColor);
                    graphics.drawLine(0, n8, rectangle.width + 1, n8);
                    graphics.drawLine(n7, rectangle.y, n7, n8);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

