/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class NumericDocument
extends PlainDocument {
    int min;
    int max;
    int currentVal = 0;
    boolean checkingEnabled = true;

    public NumericDocument(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    public int getIntegerValue() {
        return this.currentVal;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (!this.checkingEnabled) {
            super.insertString(n, string, attributeSet);
            return;
        }
        String string2 = null;
        if (this.getLength() == 0) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.getText(0, this.getLength()));
            stringBuffer.insert(n, string);
            string2 = stringBuffer.toString();
        }
        try {
            this.currentVal = this.parse(string2);
            super.insertString(n, string, attributeSet);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int parse(String string) throws NumberFormatException {
        int n = 0;
        if (string.length() != 0) {
            n = Integer.parseInt(string);
        }
        if (n >= this.min && n <= this.max) {
            return n;
        }
        throw new NumberFormatException();
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (!this.checkingEnabled) {
            super.remove(n, n2);
            return;
        }
        String string = this.getText(0, this.getLength());
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + n, string.length());
        String string4 = String.valueOf(string2) + string3;
        try {
            this.currentVal = this.parse(string4);
            super.remove(n, n2);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

