/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ListUI;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicListUI
extends ListUI
implements Serializable {
    protected transient boolean hasFocus = false;
    protected ListSelectionListener selectionL;
    protected ListDataListener dataL;
    protected PropertyChangeListener propertyL;
    protected InputListener inputL;
    protected JList list;
    protected CellRendererPane rendererPane;
    protected int[] cellHeights;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.hasFocus && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || listModel.getSize() == 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = this.convertYToRow(rectangle2.y);
        int n2 = this.convertYToRow(rectangle2.y + rectangle2.height - 1);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = listModel.getSize() - 1;
        }
        if ((rectangle = this.getCellBounds(this.list, n, n)) == null) {
            return;
        }
        int n3 = this.list.getLeadSelectionIndex();
        int n4 = n;
        while (n4 <= n2) {
            rectangle.height = this.getRowHeight(n4);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.paintCell(graphics, n4, rectangle, listCellRenderer, listModel, listSelectionModel, n3);
            rectangle.y += rectangle.height;
            ++n4;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth + insets.left + insets.right;
        int n3 = this.convertRowToY(n) + this.getRowHeight(n) + insets.bottom;
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void registerKeyboardActions() {
        1 var1_1 = new 1("SelectPreviousRow");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.list.registerKeyboardAction(var1_1, keyStroke, 0);
        2 var3_3 = new 2("SelectNextRow");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
        this.list.registerKeyboardAction(var3_3, keyStroke2, 0);
    }

    protected void unregisterKeyboardActions() {
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
    }

    protected void addListListeners() {
        this.inputL = this.createInputListener();
        this.list.addMouseListener(this.inputL);
        this.list.addMouseMotionListener(this.inputL);
        this.propertyL = this.createPropertyListener();
        this.list.addPropertyChangeListener(this.propertyL);
        this.list.addFocusListener(this.inputL);
        this.dataL = this.createDataListener();
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.dataL);
        }
        this.selectionL = this.createSelectionListener();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this.selectionL);
        }
    }

    protected void removeListListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeMouseListener(this.inputL);
        this.list.removeMouseMotionListener(this.inputL);
        this.list.removePropertyChangeListener(this.propertyL);
        this.list.removeFocusListener(this.inputL);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.dataL);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.selectionL);
        }
    }

    protected void configureList() {
        Color color;
        Color color2;
        this.list.setLayout(null);
        LookAndFeel.installBorder(this.list, "List.border");
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        if (this.list.getCellRenderer() == null) {
            this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
        if ((color2 = this.list.getSelectionBackground()) == null || color2 instanceof UIResource) {
            this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        }
        if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
            this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
    }

    protected void unconfigureList() {
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.configureList();
        this.addListListeners();
        this.registerKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.removeListListeners();
        this.unregisterKeyboardActions();
        this.unconfigureList();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.list = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertYToRow(point.y);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        return new Point(0, this.convertRowToY(n));
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.convertRowToY(n3);
        int n6 = this.convertRowToY(n4);
        if (n5 == -1 || n6 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n7 = insets.left;
        int n8 = n5;
        int n9 = jList.getWidth() - (insets.left + insets.right);
        int n10 = n6 + this.getRowHeight(n4) - n5;
        return new Rectangle(n7, n8, n9, n10);
    }

    protected int getRowHeight(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        if (this.cellHeights == null) {
            return this.cellHeight;
        }
        if (n < this.cellHeights.length) {
            return this.cellHeights[n];
        }
        return -1;
    }

    protected int convertYToRow(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int n3;
            int n4 = n3 = this.cellHeight == 0 ? 0 : (n - insets.top) / this.cellHeight;
            if (n3 < 0 || n3 >= n2) {
                return -1;
            }
            return n3;
        }
        int n5 = insets.top;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            if (n >= n5 && n < n5 + this.cellHeights[n7]) {
                return n6;
            }
            n5 += this.cellHeights[n7];
            ++n6;
            ++n7;
        }
        return -1;
    }

    protected int convertRowToY(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (n < 0 || n > n2) {
            return -1;
        }
        if (this.cellHeights == null) {
            return insets.top + this.cellHeight * n;
        }
        int n3 = insets.top;
        int n4 = 0;
        while (n4 < n) {
            n3 += this.cellHeights[n4];
            ++n4;
        }
        return n3;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                int n5 = 0;
                while (n5 < n4) {
                    Object object = listModel.getElementAt(n5);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1) {
                        this.cellHeights[n5] = dimension.height;
                    }
                    ++n5;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                int n6 = 0;
                while (n6 < n4) {
                    this.cellHeights[n6] = 0;
                    ++n6;
                }
            }
        }
        this.list.invalidate();
    }

    protected InputListener createInputListener() {
        return new InputListener();
    }

    protected ListSelectionListener createSelectionListener() {
        return new SelectionListener();
    }

    protected ListDataListener createDataListener() {
        return new DataListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    private final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicListUI.this.selectPreviousIndex();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 1(String string) {
            super(string);
        }
    }

    private final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicListUI.this.selectNextIndex();
        }

        public boolean isEnabled() {
            return true;
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    protected class InputListener
    extends MouseAdapter
    implements MouseMotionListener,
    FocusListener,
    Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = BasicListUI.this.convertYToRow(mouseEvent.getY());
            if (n != -1) {
                BasicListUI.this.list.setValueIsAdjusting(true);
                int n2 = BasicListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
            if (!BasicListUI.this.hasFocus) {
                BasicListUI.this.list.requestFocus();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = BasicListUI.this.convertYToRow(mouseEvent.getY());
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.scrollRectToVisible(rectangle);
                BasicListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = BasicListUI.this.convertYToRow(mouseEvent.getY());
            if (n != -1) {
                BasicListUI.this.list.setSelectionInterval(n, n);
            }
            BasicListUI.this.list.setValueIsAdjusting(false);
        }

        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicListUI.this.list.getLeadSelectionIndex();
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            BasicListUI.this.hasFocus = true;
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicListUI.this.hasFocus = false;
            this.repaintCellFocus();
        }

        InputListener() {
            BasicListUI.this = BasicListUI.this;
        }
    }

    public class SelectionListener
    implements ListSelectionListener,
    Serializable {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.maybeUpdateLayoutState();
            int n = BasicListUI.this.convertRowToY(listSelectionEvent.getFirstIndex());
            int n2 = BasicListUI.this.convertRowToY(listSelectionEvent.getLastIndex());
            if (n == -1 || n2 == -1) {
                BasicListUI.this.list.repaint(0, 0, BasicListUI.this.list.getWidth(), BasicListUI.this.list.getHeight());
                return;
            }
            BasicListUI.this.list.repaint(0, n, BasicListUI.this.list.getWidth(), (n2 += BasicListUI.this.getRowHeight(listSelectionEvent.getLastIndex())) - n);
        }

        public SelectionListener() {
            BasicListUI.this = BasicListUI.this;
        }
    }

    public class DataListener
    implements ListDataListener,
    Serializable {
        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
            int n3 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n4 = BasicListUI.this.list.getHeight() - n3;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n3, BasicListUI.this.list.getWidth(), n4);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n3 = BasicListUI.this.list.getHeight() - n2;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n2, BasicListUI.this.list.getWidth(), n3);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint();
        }

        public DataListener() {
            BasicListUI.this = BasicListUI.this;
        }
    }

    public class PropertyListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(BasicListUI.this.dataL);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(BasicListUI.this.dataL);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                return;
            }
            if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(BasicListUI.this.selectionL);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(BasicListUI.this.selectionL);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                return;
            }
            if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                return;
            }
            if (string.equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                return;
            }
            if (string.equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                return;
            }
            if (string.equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                return;
            }
            if (string.equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                return;
            }
            if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
            }
        }

        public PropertyListener() {
            BasicListUI.this = BasicListUI.this;
        }
    }
}

