/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.TimerQueue;
import com.sun.java.swing.event.EventListenerList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class Timer
implements Serializable {
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    protected EventListenerList listenerList = new EventListenerList();
    boolean eventQueued = false;
    private static boolean logTimers;
    Runnable doPostEvent;
    long expirationTime;
    Timer nextTimer;
    boolean running;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public Timer(int n, ActionListener actionListener) {
        this.delay = n;
        this.initialDelay = n;
        this.doPostEvent = new DoPostEvent();
        this.addActionListener(actionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : Timer.class$("java.awt.event.ActionListener"))) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    public static void setLogTimers(boolean bl) {
        logTimers = bl;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new RuntimeException("Invalid initial delay: " + n);
        }
        this.delay = n;
        if (this.isRunning()) {
            TimerQueue timerQueue = this.timerQueue();
            timerQueue.removeTimer(this);
            this.cancelEvent();
            timerQueue.addTimer(this, System.currentTimeMillis() + (long)n);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int n) {
        if (n < 0) {
            throw new RuntimeException("Invalid initial delay: " + n);
        }
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    synchronized void cancelEvent() {
        this.eventQueued = false;
    }

    synchronized void post() {
        if (!this.eventQueued) {
            this.eventQueued = true;
            SwingUtilities.invokeLater(this.doPostEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        public void run() {
            if (logTimers) {
                System.out.println("Timer ringing: " + Timer.this);
            }
            if (Timer.this.eventQueued) {
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this, 0, null));
                Timer.this.cancelEvent();
            }
        }

        Timer getTimer() {
            return Timer.this;
        }

        DoPostEvent() {
            Timer.this = Timer.this;
        }
    }
}

