/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.DefaultHighlighter;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Highlighter;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.StateInvariantError;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class DefaultCaret
implements Caret,
Serializable,
FocusListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent;
    JTextComponent component;
    boolean visible;
    int dot;
    int mark;
    Object selectionTag;
    Timer flasher;
    Point magicCaretPosition;
    transient UpdateHandler updateHandler = new UpdateHandler();
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    protected final JTextComponent getComponent() {
        return this.component;
    }

    protected void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.component.repaint(rectangle.x - 1, rectangle.y, 3, rectangle.height);
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        SwingUtilities.invokeLater(new SafeScroller(rectangle));
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this.component.getSelectionColor());
        return defaultHighlightPainter;
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.component.viewToModel(point);
        if (n >= 0) {
            this.setDot(n);
            this.setMagicCaretPosition(null);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.component.viewToModel(point);
        if (n >= 0) {
            this.moveDot(n);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEditable()) {
            this.setVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            DefaultEditorKit.SelectWordAction selectWordAction = new DefaultEditorKit.SelectWordAction();
            selectWordAction.actionPerformed(null);
            return;
        }
        if (mouseEvent.getClickCount() == 3) {
            DefaultEditorKit.SelectLineAction selectLineAction = new DefaultEditorKit.SelectLineAction();
            selectLineAction.actionPerformed(null);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.positionCaret(mouseEvent);
        if (this.component.isEnabled()) {
            this.component.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveCaret(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.dot);
                graphics.setColor(this.component.getCaretColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        if (document != null) {
            document.addDocumentListener(this.updateHandler);
        }
        jTextComponent.addPropertyChangeListener(this.updateHandler);
        jTextComponent.addFocusListener(this);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
    }

    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeFocusListener(this);
        jTextComponent.removePropertyChangeListener(this.updateHandler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.updateHandler);
        }
        this.component = null;
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = DefaultCaret.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = DefaultCaret.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : DefaultCaret.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void setSelectionVisible(boolean bl) {
        if (bl) {
            if (this.selectionTag == null && this.dot != this.mark) {
                Highlighter highlighter = this.component.getHighlighter();
                int n = Math.min(this.dot, this.mark);
                int n2 = Math.max(this.dot, this.mark);
                Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                try {
                    this.selectionTag = highlighter.addHighlight(n, n2, highlightPainter);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    this.selectionTag = null;
                    return;
                }
            }
        } else if (this.selectionTag != null) {
            Highlighter highlighter = this.component.getHighlighter();
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public boolean isSelectionVisible() {
        return this.selectionTag != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        TextUI textUI = this.component.getUI();
        Document document = this.component.getDocument();
        if (this.visible != bl && document != null && textUI != null) {
            try {
                Rectangle rectangle = textUI.modelToView(this.dot);
                this.damage(rectangle);
            }
            catch (BadLocationException badLocationException) {}
        }
        this.visible = bl;
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
                return;
            }
            this.flasher.stop();
        }
    }

    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.updateHandler);
            }
            this.flasher.setDelay(n);
            return;
        }
        if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.updateHandler);
            this.flasher = null;
        }
    }

    public int getBlinkRate() {
        if (this.flasher == null) {
            return 0;
        }
        return this.flasher.getDelay();
    }

    public int getDot() {
        return this.dot;
    }

    public int getMark() {
        return this.mark;
    }

    public void setDot(int n) {
        Document document = this.component.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
        }
        this.mark = n = Math.max(n, 0);
        if (this.dot != n || this.selectionTag != null) {
            this.changeCaretPosition(n);
        }
        if (this.selectionTag != null) {
            Highlighter highlighter = this.component.getHighlighter();
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public void moveDot(int n) {
        if (n != this.dot) {
            this.changeCaretPosition(n);
            Highlighter highlighter = this.component.getHighlighter();
            int n2 = Math.min(n, this.mark);
            int n3 = Math.max(n, this.mark);
            try {
                if (this.selectionTag != null) {
                    highlighter.changeHighlight(this.selectionTag, n2, n3);
                    return;
                }
                Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                this.selectionTag = highlighter.addHighlight(n2, n3, highlightPainter);
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new StateInvariantError("Bad caret position");
            }
        }
    }

    void changeCaretPosition(int n) {
        TextUI textUI = this.component.getUI();
        Document document = this.component.getDocument();
        if (textUI != null && document != null) {
            Rectangle rectangle;
            try {
                Rectangle rectangle2 = textUI.modelToView(this.dot);
                this.damage(rectangle2);
            }
            catch (BadLocationException badLocationException) {
                Object var4_5 = null;
            }
            this.dot = n;
            try {
                rectangle = textUI.modelToView(this.dot);
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle != null) {
                this.adjustVisibility(rectangle);
            }
            this.damage(rectangle);
            this.fireStateChanged();
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateHandler = new UpdateHandler();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle rectangle) {
            DefaultCaret.this = DefaultCaret.this;
            this.r = rectangle;
        }

        public void run() {
            DefaultCaret.this.component.scrollRectToVisible(this.r);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultCaret.this.visible = !DefaultCaret.this.visible;
            try {
                TextUI textUI = DefaultCaret.this.component.getUI();
                Rectangle rectangle = textUI.modelToView(DefaultCaret.this.dot);
                DefaultCaret.this.damage(rectangle);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n = 0;
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            if (DefaultCaret.this.dot >= n2) {
                n = n3;
            }
            if (DefaultCaret.this.mark >= n2) {
                DefaultCaret.this.mark += n3;
            }
            if (n != 0) {
                DefaultCaret.this.changeCaretPosition(DefaultCaret.this.dot + n);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int n = 0;
            int n2 = documentEvent.getOffset();
            int n3 = n2 + documentEvent.getLength();
            if (DefaultCaret.this.dot >= n3) {
                n = n3 - n2;
            } else if (DefaultCaret.this.dot >= n2) {
                n = DefaultCaret.this.dot - n2;
            }
            if (DefaultCaret.this.mark >= n3) {
                DefaultCaret.this.mark -= n3 - n2;
            } else if (DefaultCaret.this.mark >= n2) {
                DefaultCaret.this.mark = n2;
            }
            if (DefaultCaret.this.mark == DefaultCaret.this.dot - n) {
                DefaultCaret.this.setDot(DefaultCaret.this.dot - n);
                return;
            }
            DefaultCaret.this.changeCaretPosition(DefaultCaret.this.dot - n);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                DefaultCaret.this.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            }
        }

        UpdateHandler() {
            DefaultCaret.this = DefaultCaret.this;
        }
    }
}

