import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.swing.*;

class ApltFileDlg extends JDialog 
                  implements ActionListener
{
  private List    urlList;
  private MainApplet top_applet;
  private boolean selected;
  
  public ApltFileDlg( MainApplet in_applet, String txt )
  {
    super();
    setTitle( txt );
    setModal( true );
    top_applet = in_applet;
    setup();
  }
  
  public boolean getSelected()
  {
      return selected;
  }

  //setup methods--------------------------------------------------------
  private void setup ()
  {
    setupPanel();
      
    pack();
    setResizable( true );
    //    setSize (getMinimumSize ()); 
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener( new WindowAdapter () {
      public void windowClosing( WindowEvent e ) {
        selected = false;
        setVisible( false );
      }
    });
  }
  
  private void setupPanel()
  {
    MyJPanel p = new MyJPanel( new BorderLayout(), "Files" );
    
    p.add( urlList = new List(4, false), BorderLayout.CENTER );
    urlList.setBackground( Color.white );
    urlList.setForeground( Color.black );
    getURLs();
    urlList.select(0);
    
    JPanel pj = new JPanel( new GridLayout(1, 2) );
    pj.add( new MyButton("OK", "Open selected logfile", this) );
    pj.add( new MyButton("Cancel", "Cancel logfile open", this) );
    
    p.add( pj, BorderLayout.SOUTH );
    
    getContentPane().add( "Center", p );
  }
  //end of setup methods------------------------------------------------------
  
  //event handler methods-----------------------------------------------------
  //event handler method for ActionEvents generated by buttons
  public void actionPerformed( ActionEvent evt )
  {
      String command = evt.getActionCommand();
      if ( command.equals("Cancel") ) {
          selected = false;
          setVisible (false);
      }
      if ( command.equals("OK") ) {
          selected = true;
          setVisible (false);
      }
  }
  //end of event handler methods----------------------------------------------
  
  //Utility methods-----------------------------------------------------------
  public String getFile()
  {
      return urlList.getSelectedItem();
  }
  
  private void getURLs()
  {
      String line, s;
      BufferedReader in = null;
      int x, y;

      URL url = top_applet.GetLogFileListingURL();
      if ( url == null )
          return;
    
      try {
          in = new BufferedReader( new InputStreamReader( url.openStream() ) );
          while ( ( line = in.readLine() ) != null ) {
              x = line.indexOf( "slog" );
              for(  y = x - 1;
                    y > -1 && line.charAt(y) != '<'
                 && line.charAt(y) != ' ' && line.charAt(y) != '"' ;
                    y--);
              if ( x != -1 ) {
                  String name = line.substring(y+1, x) + "slog";
                  urlList.add( name ); 
              }
          }
          in.close();
      }
      catch (IOException e) {
          new ErrorDialog( top_applet, "IO Error:" + e.getMessage() );
      }
  }
}
