/* 
 *  bitstream.c
 *
 *	Copyright (C) Aaron Holtzman - Dec 1999
 *
 *  This file is part of ac3dec, a free AC-3 audio decoder
 *	
 *  ac3dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  ac3dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <inttypes.h>

#include "bswap.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ac3.h"
#include "ac3_internal.h"
#include "bitstream.h"


uint32_t bits_left = 0;
uint8_t *buffer_start = 0;
#if ARCH_X86
uint64_t current_word;
#else
uint32_t current_word;
#endif

/**
 *
 **/

static inline void bitstream_fill_current()
{
#if ARCH_X86
	current_word = bswap_64 (*(uint64_t*)buffer_start);
#else
	current_word =
	    buffer_start[0] << 24 |
	    buffer_start[1] << 16 |
	    buffer_start[2] <<  8 |
	    buffer_start[3];
#endif
	buffer_start += CURRENT_WORD_BITS/8;
}

/**
 * The fast paths for _get is in the
 * bitstream.h header file so it can be inlined.
 *
 * The "bottom half" of this routine is suffixed _bh
 *
 * -ah
 **/

uint32_t bitstream_get_bh (uint32_t num_bits)
{
	uint32_t result;

	num_bits -= bits_left;
	result = (current_word << (CURRENT_WORD_BITS - bits_left)) >> (CURRENT_WORD_BITS - bits_left);

	bitstream_fill_current();

	if(num_bits != 0)
		result = (result << num_bits) | (current_word >> (CURRENT_WORD_BITS - num_bits));
	
	bits_left = CURRENT_WORD_BITS - num_bits;

	return result;
}


/**
 *
 **/

void bitstream_init (uint8_t *start)
{
	//initialize the start of the buffer
	buffer_start = start;
	bits_left = 0;
}
