// gcc test2.c -I.. -L. -lac3 -o ac3test
//#define DUMP_PCM

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/soundcard.h>

#include "ac3.h"
#include "config.h"

static FILE* ac3file=NULL;

#define IN_BUF_SIZE (2048*32)

static unsigned char in_buf[IN_BUF_SIZE];

// AC3 decoder buffer callback:
static void ac3_fill_buffer(uint8_t **start,uint8_t **end){
    int len=fread(in_buf,1,IN_BUF_SIZE,ac3file);
    if(len<=0){
          *start = *end = NULL;        // EOF
          return;
    }
    *start=in_buf;
    *end=&in_buf[len];
//    printf("!!!\n");
}

int main(int argc,char* argv[]){
  int len;
  int total=0;
  float length;
  int r;
#ifdef DUMP_PCM
  FILE *fd_audio;
#else
  int audio_fd;
#endif
  ac3_frame_t* ac3_frame=NULL;
  
  ac3file=fopen((argc>1)?argv[1]:"test2.ac3","rb");
  if(!ac3file){  printf("input ac3 stream not found\n");  exit(1); }

  // Dolby AC3 audio:
  ac3_config.fill_buffer_callback = ac3_fill_buffer;
  ac3_config.num_output_ch = 2;
  ac3_config.flags = 0;
#ifdef HAVE_MMX
  ac3_config.flags |= AC3_MMX_ENABLE;
#endif
#ifdef HAVE_3DNOW
  ac3_config.flags |= AC3_3DNOW_ENABLE;
#endif
  ac3_init();
  ac3_frame = ac3_decode_frame();
  if(!ac3_frame){  printf("Can't decode this file...\n");exit(1); }

#ifdef DUMP_PCM
  fd_audio=fopen("test.pcm", "wb");
  if(!fd_audio){  printf("file creation error\n");  exit(1); }
#else
  audio_fd=open("/dev/dsp", O_WRONLY);
  if(audio_fd<0){  printf("Can't open audio device\n");exit(1); }
  r=AFMT_S16_LE;ioctl (audio_fd, SNDCTL_DSP_SETFMT, &r);
  r=1;ioctl (audio_fd, SNDCTL_DSP_STEREO, &r);
  r=ac3_frame->sampling_rate;ioctl (audio_fd, SNDCTL_DSP_SPEED, &r);
  printf("audio_setup: using %d Hz samplerate (requested: %d)\n",r,ac3_frame->sampling_rate);
#endif
  
  while(1){
      int len2;
      if(!ac3_frame) ac3_frame = ac3_decode_frame();
      if(!ac3_frame) break; // EOF
      len=256*6*4;  // 2048*3
            
      // play it
#ifdef DUMP_PCM
      fwrite(ac3_frame->audio_data,len,1,fd_audio);
#else
      len2=write(audio_fd,ac3_frame->audio_data,len);
#endif
      if(len2<0) break; // ERROR?
      if(len2<len) printf("???\n"); // shouldn't happen
      ac3_frame=NULL;
  }
  
  fclose(ac3file);
#ifdef DUMP_PCM
  fclose(fd_audio);
#endif
}
