
// draw_slice / draw_frame implementation

#include "libvo2.h"

// type:
//    1 = single, temporary buffer  (yuv->rgb, or indirect render)
//    2 = single, static buffer (direct rendering for buggy vfw codecs)
//    3 = P+P+B buffering (for mpeg 1/2/4)
// doublebuf:
//    0 = auto (not specified by the user)
//    1 = no doublebuffering
//    2 = double buffering
//    3 = triple buffering
void vo2_choose_buffering(vo2_handle_t *vo,int type,int doublebuf){
    int speed=vo->functions->control(vo,VO2CTRL_QUERY_SURFACE_FAST,0);
    int direct=vo->functions->control(vo,VO2CTRL_QUERY_SURFACE_DIRECT,0);
    int max=vo->functions->control(vo,VO2CTRL_GET_MAX_SURFACES,0);
    int bufs=0; // buffers in driver
    int vo2_bufs=0; // buffers in vo2

    switch(type){
    case 1:
	// full update of buffer for each frames
	// USED BY: divx4linux, and codecs with YV12->RGB conversion
	if(doublebuf==1 || direct==0){
	    // user disabled double buffering or driver does memcpy:
	    bufs=1;
	    break;
	}
	if(doublebuf>1 && max==1) {
	    // user wants doublebuf, but driver has only 1 direct surface:
	    vo2_bufs=1; // vo2 does double buffering (allocates surface)
	    bufs=1;
	    break;
	}
	    // try double buffering...
	    bufs=(doublebuf>1) ? doublebuf : 3;
	    if(max>0 && bufs>max) bufs=max;
	break;
    case 2:
	// partial update of buffer. buffer address shouldn't change.
	// used by VfW divx codecs.
	if(doublebuf>1 && direct!=0){
	    // user wants double buffering & not indirect -> use internal buffer
	    bufs=1;
	    vo2_bufs=1; // vo2 does double buffering (allocates surface)
	    break;
	}
	// direct rendering!
	bufs=1;
	break;
    case 3:
	// mixed mode: 2 static and 1 temporary frames (for MPEG codecs)
	if(speed==1 && max>=3){
	    // buffers are in fast memory. keep P frames in driver.
	    if(direct==0){
		// we have enough indirect buffers
		bufs=3;
		break;
	    }
	    // I think we never reach this point:
	    //  fast & direct at the same time... but who knows :)
	    //  (maybe some overlay driver with shared/AGP memory?)
	    if(max>4){
		// direct, triple buffering is possible
		if(doublebuf==0 || doublebuf>=3){
		    bufs=5;
		    break;
		}
	    }
	    if(max>3){
		// direct, double buffering is possible
		if(doublebuf==0 || doublebuf>=2){
		    bufs=4;
		    break;
		}
	    }
	    bufs=3;	// no doublebuffering :(
	    break;
	}
	// ok. no enough fast buffers.
	// try mixed mode: P in system, B in video ram ?
	vo2_bufs=2; // two P buffers
	if(doublebuf==1 || direct==0){
	    // user doesn't want double buffering or indirect 
	    bufs=1; break;
	}
	// double buffering (if possible)
	if(max==0){
	    // user forces double buffering, but we don't know how many
	    // buffers we have (hope user knows)
	    bufs=(doublebuf>1) ? doublebuf : 1;
	    break;
	}
	bufs=(max>3)?3:max;
	break;
    }
    
    printf("choose_buffering: system: %d  video: %d\n",vo2_bufs,bufs);

}

// field:  0=frame  1=top_field  2=bottom_field
void vo2_draw_slice_start(vo2_handle_t *vo,int field){
    // setup surface
    vo->surface=vo->functions->get_surface(vo->priv,0);
}

void vo2_draw_slice(vo2_handle_t *vo,unsigned char* img[3],int stride[3],int w,int h,int x,int y){
    


}

void vo2_draw_frame(vo2_handle_t *vo,unsigned char* img,int stride,int w,int h){
// do it:
    int i,bpp;
    vo->surface=vo->functions->get_surface(vo->priv,0);
    bpp=(vo->surface->bpp+7)/8;
    
    printf("w=%d  h=%d  bpp=%d  s_stride=%d  d_stride=%d\n",w,h,bpp,stride,
	vo->surface->stride[0]);

//    memset(vo->surface->img[0],0x20,w*h); return;
    
    if(stride==w && w*bpp==vo->surface->stride[0]){
	memcpy(vo->surface->img[0],img,w*h*bpp);
	return;
    }
    
    for(i=0;i<h;i++){
	memcpy(vo->surface->img[0]+vo->surface->stride[0]*i,img+stride*bpp*i,bpp*w);
    }
    return;
    
// fallback:
//    vo2_draw_slice(vo,&img,&stride,w,h,0,0);
}

void vo2_flip(vo2_handle_t *vo,int num){

    vo->functions->flip_image(vo->priv,num);

}

