
#include <stdio.h>
#include <stdlib.h>

#include "libvo2.h"

// libvo2 core interface

vo2_handle_t* vo2_init_sample();

vo2_handle_t* vo2_new(char *drvname){

    // do it better... (later: plugin loader stuff)
    if(!strcmp(drvname,"sample")) return vo2_init_sample();
    if(!strcmp(drvname,"mga")) return vo2_init_mga();
//    if(!strcmp(drvname,"x11")) return vo2_new_mga();
// ...

    fprintf(stderr,"No such driver: %s\n",drvname);
    return NULL;

}

int vo2_start(vo2_handle_t* vo, int w,int h,int format,int buffering,int flags){
    return vo->functions->start(vo->priv,w,h,format,buffering,flags);
}

int vo2_query_format(vo2_handle_t* vo){
    return 1;
}

int vo2_close(vo2_handle_t* vo){
    return vo->functions->stop(vo->priv);
}
