
#define VO2_FALSE 0
#define VO2_TRUE 1
#define VO2_NA -1
#define VO2_UNKNOWN -2

// return true if surface is in fast system ram, false if slow (video?) memory
// USED for storing mpeg2 I/P frames only if it's fast enough
#define VO2CTRL_QUERY_SURFACE_FAST 0x101

// return true if surface is direct rendered, false if indirect (copied first)
// Note: it's usually same as VO2CTRL_GET_SURFACE_SPEED, except for some
// special cases, when video card does the copy from video ram (opengl...)
// USED for deciding external double buffering mode (using 2 surfaces)
#define VO2CTRL_QUERY_SURFACE_DIRECT 0x102

// Get the upper hardware/Driver limitation (used for double buffering)
#define VO2CTRL_GET_MAX_SURFACES 0x103

// Query support of a given video pixel format (use IMGFMT_ constants)
#define VO2CTRL_QUERY_FORMAT 0x111

// Query that software and/or hardware scaling is supported by driver
#define VO2CTRL_QUERY_SWSCALE 0x121
#define VO2CTRL_QUERY_HWSCALE 0x122


typedef struct vo2_info_s
{
        /* driver name ("Matrox Millennium G200/G400" */
        const char *name;
        /* short name (for config strings) ("mga") */
        const char *short_name;
        /* author ("Aaron Holtzman <aholtzma@ess.engr.uvic.ca>") */
        const char *author;
        /* any additional comments */
        const char *comment;
} vo2_info_t;

typedef struct {
    int w,h;  // dimension of the surface
    int x,y;  // position of the image (for draw_frame/draw_slice)
    unsigned char* img[3];  // pointer to frame/planes
    int stride[3]; // strides (bytes per line) for frame/planes
    int format; // RGB / BGR / YUV_PACKED / YUV_PLANAR
    int bpp;  // bits per pixel (15/16/24/32) or YUV fourcc
} vo2_surface_t;

typedef struct vo2_functions_s {

// control (get/set/query) device parameters
//  for example: query supported pixel formats, en/disable double buffering,
//  query hw/sw scaling capabilities, switch window/fullscreen,
//  get best matching resolution for a given image size etc...
    int (*control)(void *p, int cmd, void* param);

// start drawing (set video mode, allocate image buffers etc.)
// w,h: requested surface size (actual size may be larger!!!)
// format: IMGFMT_* requested surface pixel format
// buffers: requested number of surfaces  (0=auto)
// flags: various things, like fullscreen, sw/hw zoom and vidmode change
// return: 0=fail (fail if pixel format or buffering not supported)
//         n=number of surfaces allocated
    int (*start)(void *p, int w,int h,int format,int surfaces,int flags);
    
// stop rendering, close device
    int (*stop)(void *p);

// get destination surface (for direct rendering or generic draw_ functions)
// num: number of frame. 0 = temporary frame - can be dropped/modified
//                       1-2 = static frames - should not be modified
// Note:  mpeg will use 0,1,2 frames for B,Pf,Pb  (or fallback to 0-only)
//        win32 will use only 0
    vo2_surface_t* (*get_surface)(void *p, int num);

// let's show surface[num]
// we can assume that num is valid (get_surface(num) will return non-NULL)
    void (*flip_image)(void *p, int num);

} vo2_functions_t;

typedef struct vo2_handle_s {
    vo2_info_t* info;
    vo2_functions_t* functions;
    vo2_surface_t* surface;
    void* priv;
} vo2_handle_t;

// Opens a new driver by name, returns the handle (vo2_handle_t)
// returns NULL if failed (no such driver/device, etc)
vo2_handle_t* vo2_new(char *drvname);
int vo2_start(vo2_handle_t* vo, int w,int h,int format,int buffering,int flags);
int vo2_query_format(vo2_handle_t* vo);
int vo2_close(vo2_handle_t* vo);
void vo2_draw_slice_start(vo2_handle_t *vo,int field);
void vo2_draw_slice(vo2_handle_t *vo,unsigned char* img[3],int stride[3],int w,int h,int x,int y);
void vo2_draw_frame(vo2_handle_t *vo,unsigned char* img,int stride,int w,int h);
void vo2_flip(vo2_handle_t *vo,int num);

// HACK
typedef struct {
    int dummy;
} vo_functions_t;

#include <inttypes.h>

#include "../libvo/font_load.h"
#include "../libvo/img_format.h"

// currect resolution/bpp on screen:  (should be autodetected by vo_init())
extern int vo_depthonscreen;
extern int vo_screenwidth;
extern int vo_screenheight;

// requested resolution/bpp:  (-x -y -bpp options)
extern int vo_dwidth;
extern int vo_dheight;
extern int vo_dbpp;

extern int vo_doublebuffering;
extern int vo_fsmode;

extern char *vo_subdevice;

