
#include <stdio.h>
#include <stdlib.h>

#include "libvo2.h"
#include "img_format.h"

// Driver info:
static vo2_info_t info = {
        "dummy sample vo2 driver",
        "dummy",
        "Arpad Gereoffy <arpi@thot.banki.hu>",
        "does nothing"
};

// Local, driver-dependent data:  (do not use globals! -> reentrancy)
typedef struct {
    int double_buffering;
    int current_surface;
    vo2_surface_t surfaces[3];
} priv_t;

#include "vo2_def.h"

// open hardware/lib, get capabilities
// this function will be called first, before any other control() or start() calls
// return:  1=success  0=failed
vo2_handle_t* vo2_init_sample(){
    printf("vo2_sample: init()\n");

    return new_handle();
}

// control (get/set/query) device parameters
//  for example: query supported pixel formats, en/disable double buffering,
//  query hw/sw scaling capabilities, switch window/fullscreen,
//  get best matching resolution for a given image size etc...
static int control(void *p, int cmd, void* param){

    printf("vo2_sample: control(0x%X)\n",cmd);
    
    return -1;
}

// start drawing (set video mode, allocate image buffers etc.)
// w,h: requested surface size (actual size may be larger!!!)
// format: IMGFMT_* requested surface pixel format
// buffering: 0 - single temporary frame buffer (for draw_* stuff)
//            1 - single static buffer  (for win32 direct rendering)
//            2 - 2 static + 1 temp buffer (for mpeg direct rendering)
// flags: various things, like fullscreen, sw/hw zoom and vidmode change
// return: 1=success 0=fail (fail if pixel format or buffering not supported)
static int start(void *p, int w,int h,int format,int buffering,int flags){

    // open window / switch vidmode, set up surfaces etc...
    printf("vo2_sample: start() %dx%d  %s  %d  0x%X\n",w,h,vo_format_name(format),buffering,flags);


    return 1;
}

static int stop(void *p){
    // stop rendering, close device
    printf("vo2_sample: stop()\n");
    return 1;
}

// get destination surface (for direct rendering or generic draw_ functions)
// num: number of frame. 0 = temporary frame - can be dropped/modified
//                       1-2 = static frames - should not be modified
// Note:  mpeg will use 0,1,2 frames for B,Pf,Pb  (or fallback to 0-only)
//        win32 will use only 0
static vo2_surface_t* get_surface(void *p, int num){
    printf("vo2_sample: get_surface(%d)\n",num);
    return &((priv_t*)p)->surfaces[((priv_t*)p)->current_surface];
}

static void flip_image(void *p, int num){
    // we can assume that num is valid (get_surface(num) will return non-NULL)

    printf("vo2_sample: flip_image(%d)\n",num);
  
    // let's show surface[num]

//    if(double_buffering) current_surface=current_surface^1; // swap buffers
}



