// MS-RLE8 decoder, based on code from XAnim

#include <stdio.h>

typedef char xaBYTE;
typedef short xaSHORT;
typedef int xaLONG;

typedef unsigned char xaUBYTE;
typedef unsigned short xaUSHORT;
typedef unsigned int xaULONG;

#define xaFALSE 0
#define xaTRUE 1

#define DEBUG_LEVEL2 if(0)

// image -> buffer
// delta -> compressed frame
// tdsize = size of compressed frame

void AVI_Decode_RLE8(xaUBYTE *image,xaUBYTE *delta,xaULONG tdsize,
    xaULONG *map,xaULONG imagex,xaULONG imagey,xaUBYTE x11_bytes_pixel)
{ xaULONG map_flag = map ? xaTRUE:xaFALSE;
  xaULONG opcode,mod;
  xaLONG x,y,min_x,max_x,min_y,max_y;
  xaUBYTE *dptr;
  xaLONG dsize = tdsize;

  max_x = max_y = 0; min_x = imagex; min_y = imagey;
  x = 0;  y = imagey - 1;
  dptr = delta;

  while( (y >= 0) && (dsize > 0) )
  {
    mod = *dptr++;
    opcode = *dptr++;  dsize-=2;

DEBUG_LEVEL2 fprintf(stdout,"MOD %x OPCODE %x <%d,%d>\n",mod,opcode,x,y);
    if (mod == 0x00)				/* END-OF-LINE */
    {
      if (opcode==0x00)
      {
        while(x > imagex) { x -=imagex; y--; }
        x = 0; y--;
DEBUG_LEVEL2 fprintf(stdout,"EOL <%d,%d>\n",x,y);
      }
      else if (opcode==0x01)			/* END Of Image */
      {
        y = -1;
DEBUG_LEVEL2 fprintf(stdout,"EOI <%d,%d>\n",x,y);
      }
      else if (opcode==0x02)			/* SKIP */
      {
        xaULONG yskip,xskip;
        xskip = *dptr++; 
        yskip = *dptr++;  dsize-=2;
        x += xskip;
        y -= yskip;
DEBUG_LEVEL2 fprintf(stdout,"SKIP <%d,%d>\n",x,y);
      }
      else					/* ABSOLUTE MODE */
      {
        int cnt = opcode;
        
	dsize-=cnt;
        while(x >= imagex) { x -= imagex; y--; }
	if (y > max_y) max_y = y; if (x < min_x) min_x = x;
        if (map_flag==xaTRUE){
	  if (x11_bytes_pixel==1)
          { xaUBYTE *iptr = (xaUBYTE *)(image + (y * imagex + x) );
            while(cnt--) 
	    { if (x >= imagex) { max_x = imagex; min_x = 0;
		 x -= imagex; y--; iptr = (xaUBYTE *)(image+y*imagex+x); }
              *iptr++ = (xaUBYTE)map[*dptr++];  x++;
	    }
	  }
	  else if (x11_bytes_pixel==2)
          { xaUSHORT *iptr = (xaUSHORT *)(image + ((y * imagex + x)<<1) );
            while(cnt--) 
	    { if (x >= imagex)  { max_x = imagex; min_x = 0;
		x -= imagex; y--; iptr = (xaUSHORT *)(image+y*imagex+x); }
              *iptr++ = (xaUSHORT)map[*dptr++];  x++;
	    }
	  }
	  else if (x11_bytes_pixel==3)
          { xaUBYTE *iptr = (xaUBYTE *)(image + ((y * imagex + x)*3) );
            while(cnt--)
	    { if (x >= imagex) { max_x = imagex; min_x = 0;
		 x -= imagex; y--; iptr = (xaUBYTE *)(image+y*imagex+x); }
	      { xaUBYTE* m=((xaUBYTE*)&map[*dptr]);
                *iptr++ = m[0];
                *iptr++ = m[1];
                *iptr++ = m[2];
	      }
	      dptr++; x++;
	    }
	  }
	  else /* if (x11_bytes_pixel==4) */
          { xaULONG *iptr = (xaULONG *)(image + ((y * imagex + x)<<2) );
            while(cnt--) 
	    { if (x >= imagex)  { max_x = imagex; min_x = 0;
		x -= imagex; y--; iptr = (xaULONG *)(image+y*imagex+x); }
              *iptr++ = (xaULONG)map[*dptr++];  x++;
	    }
	  }
        }
        else
        { xaUBYTE *iptr = (xaUBYTE *)(image + (y * imagex + x) );
          while(cnt--) 
	  { if (x >= imagex)  { max_x = imagex; min_x = 0;
		x -=imagex; y--; iptr = (xaUBYTE *)(image+y*imagex+x); }
	    *iptr++ = (xaUBYTE)(*dptr++); x++;
	  }
        }
DEBUG_LEVEL2 fprintf(stdout,"ABSOLUTE <%d,%d>\n",x,y);
		/* PAD to Short */
        if (opcode & 0x01) { dptr++; dsize--; }
        if (y < min_y) min_y = y; if (x > max_x) max_x = x;
      }
    }
    else					/* ENCODED MODE */
    {
      int color,cnt;
      while(x >= imagex) { x -=imagex; y--; }
      if (y > max_y) max_y = y; if (x < min_x) min_x = x;  /* OPT */
      cnt = mod;
      color = (map_flag==xaTRUE)?(map[opcode]):(opcode);
      if ( (map_flag==xaFALSE) || (x11_bytes_pixel==1) )
      { xaUBYTE *iptr = (xaUBYTE *)(image + (y * imagex + x) );
	xaUBYTE clr = (xaUBYTE)color;
	while(cnt--) 
	{ if (x >= imagex) { max_x = imagex; min_x = 0;
		x -=imagex; y--; iptr = (xaUBYTE *)(image+y*imagex+x); }
	  *iptr++ = clr; x++;
	}
      }
      else if (x11_bytes_pixel==2)
      { xaUSHORT *iptr = (xaUSHORT *)(image + ((y * imagex + x)<<1) );
	xaUSHORT clr = (xaUSHORT)color;
	while(cnt--) 
	{ if (x >= imagex)  { max_x = imagex; min_x = 0;
		x -=imagex; y--; iptr = (xaUSHORT *)(image+y*imagex+x); }
	  *iptr++ = clr; x++;
	}
      }
      else if (x11_bytes_pixel==3)
      { xaUBYTE *iptr = (xaUBYTE *)(image + ((y * imagex + x)*3) );
	xaUBYTE clr0 = color&255;
	xaUBYTE clr1 = (color>>8)&255;
	xaUBYTE clr2 = (color>>16)&255;
	while(cnt--) 
	{ if (x >= imagex) { max_x = imagex; min_x = 0;
		x -=imagex; y--; iptr = (xaUBYTE *)(image+y*imagex+x); }
	  *iptr++ = clr0;
	  *iptr++ = clr1;
	  *iptr++ = clr2;
	  x++;
	}
      }
      else /* if (x11_bytes_pixel==4) */
      { xaULONG *iptr = (xaULONG *)(image + ((y * imagex + x)<<2) );
	xaULONG clr = (xaULONG)color;
	while(cnt--) 
	{ if (x >= imagex)  { max_x = imagex; min_x = 0;
		x -=imagex; y--; iptr = (xaULONG *)(image+y*imagex+x); }
	  *iptr++ = clr; x++;
	}
      }
      if (y < min_y) min_y = y; if (x > max_x) max_x = x;
DEBUG_LEVEL2 fprintf(stdout,"ENCODED <%d,%d>\n",x,y);
    }
  } /* end of while */

DEBUG_LEVEL2 
{
  fprintf(stdout,"dsize %d\n  ",dsize);
  while(dsize)  { int d = *dptr++;  fprintf(stdout,"<%02x> ",d); dsize--; }
  fprintf(stdout,"\n");
}

#if 0
  if (xa_optimize_flag == xaTRUE)
  {
    max_x++; if (max_x>imagex) max_x=imagex;
    max_y++; if (max_y>imagey) max_y=imagey;
    if ((min_x >= max_x) || (min_y >= max_y)) /* no change */
	{ dec_info->xs = dec_info->ys = dec_info->xe = dec_info->ye = 0; 
			return(ACT_DLTA_NOP); }
    else { dec_info->xs=min_x; dec_info->ys=min_y; 
			dec_info->xe=max_x; dec_info->ye=max_y; }
  }
  else { dec_info->xs = dec_info->ys = 0;
	 dec_info->xe = imagex; dec_info->ye = imagey; }
#endif

//  if (map_flag) return(ACT_DLTA_MAPD);
//  else return(ACT_DLTA_NORM);
}

