/*
 * URL Helper
 * by Bertrand Baudet <bertrand_baudet@yahoo.com>
 * (C) 2001, MPlayer team.
 *
 * TODO: 
 * 	Extract the username/password if present
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "url.h"

URL_t*
url_new(char* url) {
	int pos1, pos2;
	URL_t* Curl;
	char *ptr1, *ptr2, *ptr3;

	// Create the URL container
	Curl = (URL_t*)malloc(sizeof(URL_t));
	if( Curl==NULL ) {
		printf("Memory allocation failed!\n");
		return NULL;
	}
	// Initialisation of the URL container members
	memset( Curl, 0, sizeof(URL_t) );

	// Copy the url in the URL container
	Curl->url = strdup(url);
	if( Curl->url==NULL ) {
		printf("Memory allocation failed!\n");
		return NULL;
	}

	// extract the protocol
	ptr1 = strstr(url, "://");
	if( ptr1==NULL ) {
		printf("Not an URL!\n");
		return NULL;
	}
	pos1 = ptr1-url;
	Curl->protocol = (char*)malloc(pos1+1);
	strncpy(Curl->protocol, url, pos1);
	Curl->protocol[pos1] = '\0';

	// look if the port is given
	ptr2 = strstr(ptr1+3, ":");
	// If the : is after the first / it isn't the port
	ptr3 = strstr(ptr1+3, "/");
	if(ptr3 && ptr3 - ptr2 < 0) ptr2 = NULL;
	if( ptr2==NULL ) {
		// No port is given
		// Look if a path is given
		ptr2 = strstr(ptr1+3, "/");
		if( ptr2==NULL ) {
			// No path/filename
			// So we have an URL like http://www.hostname.com
			pos2 = strlen(url);
		} else {
			// We have an URL like http://www.hostname.com/file.txt
			pos2 = ptr2-url;
		}
	} else {
		// We have an URL beginning like http://www.hostname.com:1212
		// Get the port number
		Curl->port = atoi(ptr2+1);
		pos2 = ptr2-url;
	}
	// copy the hostname in the URL container
	Curl->hostname = (char*)malloc(pos2-pos1-3+1);
	if( Curl->hostname==NULL ) {
		printf("Memory allocation failed!\n");
		return NULL;
	}
	strncpy(Curl->hostname, ptr1+3, pos2-pos1-3);
	Curl->hostname[pos2-pos1-3] = '\0';

	// Look if a path is given
	ptr2 = strstr(ptr1+3, "/");
	if( ptr2!=NULL ) {
		// A path/filename is given
		// check if it's not a trailing '/'
		if( strlen(ptr2)>1 ) {
			// copy the path/filename in the URL container
			Curl->file = strdup(ptr2);
			if( Curl->file==NULL ) {
				printf("Memory allocation failed!\n");
				return NULL;
			}
		}
	} 
	// Check if a filenme was given or set, else set it with '/'
	if( Curl->file==NULL ) {
		Curl->file = (char*)malloc(2);
		if( Curl->file==NULL ) {
			printf("Memory allocation failed!\n");
			return NULL;
		}
		strcpy(Curl->file, "/");
	}
	
	return Curl;
}

URL_t *
url_copy(URL_t* url) {
	URL_t *dup_url;

	if( url==NULL ) return NULL;
	dup_url = (URL_t*)malloc(sizeof(URL_t));
	if( dup_url==NULL ) {
		printf("Memory allocation failed!\n");
		return NULL;
	}
	memcpy( dup_url, url, sizeof(URL_t) );
	
	return dup_url;
}


void
url_free(URL_t* url) {
	if(!url) return;
	if(url->url) free(url->url);
	if(url->protocol) free(url->protocol);
	if(url->hostname) free(url->hostname);
	if(url->file) free(url->file);
	if(url->username) free(url->username);
	if(url->password) free(url->password);
	free(url);
}


/* Replace escape sequences in an URL (or a part of an URL) */
/* works like strcpy(), but without return argument */
/* unescape_url_string comes from ASFRecorder */
void
url_unescape_string(char *outbuf, char *inbuf)
{
	unsigned char c;
	do {
		c = *inbuf++;
		if (c == '%') {
			unsigned char c1 = *inbuf++;
			unsigned char c2 = *inbuf++;
			if (	((c1>='0' && c1<='9') || (c1>='A' && c1<='F')) &&
				((c2>='0' && c2<='9') || (c2>='A' && c2<='F')) ) {
				if (c1>='0' && c1<='9') c1-='0';
				else c1-='A';
				if (c2>='0' && c2<='9') c2-='0';
				else c2-='A';
				c = (c1<<4) + c2;
			}
		}
		*outbuf++ = c;
	} while (c != '\0');
}

/* Replace specific characters in the URL string by an escape sequence */
/* works like strcpy(), but without return argument */
/* escape_url_string comes from ASFRecorder */
void
url_escape_string(char *outbuf, char *inbuf) {
	unsigned char c;
	do {
		c = *inbuf++;
		if(	(c >= 'A' && c <= 'Z') ||
			(c >= 'a' && c <= 'z') ||
			(c >= '0' && c <= '9') ||
			(c >= 0x7f) ||						/* fareast languages(Chinese, Korean, Japanese) */
			c=='-' || c=='_' || c=='.' || c=='!' || c=='~' ||	/* mark characters */
			c=='*' || c=='\'' || c=='(' || c==')' || c=='%' || 	/* do not touch escape character */
			c==';' || c=='/' || c=='?' || c==':' || c=='@' || 	/* reserved characters */
			c=='&' || c=='=' || c=='+' || c=='$' || c==',' || 	/* see RFC 2396 */
			c=='\0' ) {
			*outbuf++ = c;
		} else {
			/* all others will be escaped */
			unsigned char c1 = ((c & 0xf0) >> 4);
			unsigned char c2 = (c & 0x0f);
			if (c1 < 10) c1+='0';
			else c1+='A';
			if (c2 < 10) c2+='0';
			else c2+='A';
			*outbuf++ = '%';
			*outbuf++ = c1;
			*outbuf++ = c2;
		}
	} while (c != '\0');
}

