/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*****************************************************************************/
/* intra VLC table when not last coefficient                                 */
/*****************************************************************************/

static fame_vlc_t rlehuff_intra_notlast_run_0[2*27+1] = 
{
  { 0xa5, 13}, /* -27 */
  { 0xa3, 13}, /* -26 */
  { 0xa1, 13}, /* -25 */
  { 0x43, 12}, /* -24 */
  { 0x41, 12}, /* -23 */
  { 0x0d, 12}, /* -22 */
  { 0x0f, 12}, /* -21 */
  { 0x1d, 11}, /* -20 */
  { 0x1f, 11}, /* -19 */
  { 0x41, 11}, /* -18 */
  { 0x43, 11}, /* -17 */
  { 0x43, 10}, /* -16 */
  { 0x47, 10}, /* -15 */
  { 0x49, 10}, /* -14 */
  { 0x4b, 10}, /* -13 */
  { 0x3b,  9}, /* -12 */
  { 0x3d,  9}, /* -11 */
  { 0x3f,  9}, /* -10 */
  { 0x2f,  8}, /*  -9 */
  { 0x25,  7}, /*  -8 */
  { 0x27,  7}, /*  -7 */
  { 0x2b,  7}, /*  -6 */
  { 0x19,  6}, /*  -5 */
  { 0x1b,  6}, /*  -4 */
  { 0x1f,  5}, /*  -3 */
  { 0x0d,  4}, /*  -2 */
  { 0x05,  3}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x04,  3}, /*   1 */
  { 0x0c,  4}, /*   2 */
  { 0x1e,  5}, /*   3 */
  { 0x1a,  6}, /*   4 */
  { 0x18,  6}, /*   5 */
  { 0x2a,  7}, /*   6 */
  { 0x26,  7}, /*   7 */
  { 0x24,  7}, /*   8 */
  { 0x2e,  8}, /*   9 */
  { 0x3e,  9}, /*  10 */
  { 0x3c,  9}, /*  11 */
  { 0x3a,  9}, /*  12 */
  { 0x4a, 10}, /*  13 */
  { 0x48, 10}, /*  14 */
  { 0x46, 10}, /*  15 */
  { 0x42, 10}, /*  16 */
  { 0x42, 11}, /*  17 */
  { 0x40, 11}, /*  18 */
  { 0x1e, 11}, /*  19 */
  { 0x1c, 11}, /*  20 */
  { 0x0e, 12}, /*  21 */
  { 0x0c, 12}, /*  22 */
  { 0x40, 12}, /*  23 */
  { 0x42, 12}, /*  24 */
  { 0xa0, 13}, /*  25 */
  { 0xa2, 13}, /*  26 */
  { 0xa4, 13}, /*  27 */
};

static fame_vlc_t rlehuff_intra_notlast_run_1[2*10+1] = 
{
  { 0xab, 13}, /* -10 */
  { 0xa7, 13}, /*  -9 */
  { 0x45, 12}, /*  -8 */
  { 0x1b, 11}, /*  -7 */
  { 0x3f, 10}, /*  -6 */
  { 0x41, 10}, /*  -5 */
  { 0x39,  9}, /*  -4 */
  { 0x2d,  8}, /*  -3 */
  { 0x29,  7}, /*  -2 */
  { 0x1d,  5}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1c,  5}, /*   1 */
  { 0x28,  7}, /*   2 */
  { 0x2c,  8}, /*   3 */
  { 0x38,  9}, /*   4 */
  { 0x40, 10}, /*   5 */
  { 0x3e, 10}, /*   6 */
  { 0x1a, 11}, /*   7 */
  { 0x44, 12}, /*   8 */
  { 0xa6, 13}, /*   9 */
  { 0xaa, 13}, /*  10 */
};

static fame_vlc_t rlehuff_intra_notlast_run_2[2*5+1] = 
{
  { 0xad, 13}, /*  -5 */
  { 0x19, 11}, /*  -4 */
  { 0x3d, 10}, /*  -3 */
  { 0x2b,  8}, /*  -2 */
  { 0x17,  6}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x16,  6}, /*   1 */
  { 0x2a,  8}, /*   2 */
  { 0x3c, 10}, /*   3 */
  { 0x18, 11}, /*   4 */
  { 0xac, 13}, /*   5 */
};

static fame_vlc_t rlehuff_intra_notlast_run_3[2*4+1] = 
{
  { 0x17, 11}, /*  -4 */
  { 0x3b, 10}, /*  -3 */
  { 0x37,  9}, /*  -2 */
  { 0x23,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22,  7}, /*   1 */
  { 0x36,  9}, /*   2 */
  { 0x3a, 10}, /*   3 */
  { 0x16, 11}, /*   4 */
};

static fame_vlc_t rlehuff_intra_notlast_run_4[2*3+1] = 
{
  { 0x15, 11}, /*  -3 */
  { 0x45, 10}, /*  -2 */
  { 0x21,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x20,  7}, /*   1 */
  { 0x44, 10}, /*   2 */
  { 0x14, 11}, /*   3 */
};

static fame_vlc_t rlehuff_intra_notlast_run_5[2*3+1] = 
{
  { 0x11, 11}, /*  -3 */
  { 0x39, 10}, /*  -2 */
  { 0x1b,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1a,  7}, /*   1 */
  { 0x38, 10}, /*   2 */
  { 0x10, 11}, /*   3 */
};

static fame_vlc_t rlehuff_intra_notlast_run_6[2*3+1] = 
{
  { 0xa9, 13}, /*  -3 */
  { 0x37, 10}, /*  -2 */
  { 0x25,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x24,  8}, /*   1 */
  { 0x36, 10}, /*   2 */
  { 0xa8, 13}, /*   3 */
};

static fame_vlc_t rlehuff_intra_notlast_run_7[2*3+1] = 
{
  { 0xaf, 13}, /*  -3 */
  { 0x35, 10}, /*  -2 */
  { 0x29,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28,  8}, /*   1 */
  { 0x34, 10}, /*   2 */
  { 0xae, 13}, /*   3 */
};

static fame_vlc_t rlehuff_intra_notlast_run_8[2*2+1] = 
{
  { 0x13, 11}, /*  -2 */
  { 0x33,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x32,  9}, /*   1 */
  { 0x12, 11}, /*   2 */
};

static fame_vlc_t rlehuff_intra_notlast_run_9[2*2+1] = 
{
  { 0x47, 12}, /*  -2 */
  { 0x31,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x30,  9}, /*   1 */
  { 0x46, 12}, /*   2 */
};

static fame_vlc_t rlehuff_intra_notlast_run_10[1*2+1] = 
{
  { 0x2f,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2e,  9}, /*   1 */
};

static fame_vlc_t rlehuff_intra_notlast_run_11[1*2+1] = 
{
  { 0x33, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x32, 10}, /*   1 */
};

static fame_vlc_t rlehuff_intra_notlast_run_12[1*2+1] = 
{
  { 0x31, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x30, 10}, /*   1 */
};

static fame_vlc_t rlehuff_intra_notlast_run_13[1*2+1] = 
{
  { 0x0f, 11}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0e, 11}, /*   1 */
};

static fame_vlc_t rlehuff_intra_notlast_run_14[1*2+1] = 
{
  { 0xb1, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb0, 13}, /*   1 */
};

static fame_vlc_t *rlehuff_intra_notlast_vlc[15] = {
  rlehuff_intra_notlast_run_0 + 27,
  rlehuff_intra_notlast_run_1 + 10,
  rlehuff_intra_notlast_run_2 + 5,
  rlehuff_intra_notlast_run_3 + 4,
  rlehuff_intra_notlast_run_4 + 3,
  rlehuff_intra_notlast_run_5 + 3,
  rlehuff_intra_notlast_run_6 + 3,
  rlehuff_intra_notlast_run_7 + 3,
  rlehuff_intra_notlast_run_8 + 2,
  rlehuff_intra_notlast_run_9 + 2,
  rlehuff_intra_notlast_run_10 + 1,
  rlehuff_intra_notlast_run_11 + 1,
  rlehuff_intra_notlast_run_12 + 1,
  rlehuff_intra_notlast_run_13 + 1,
  rlehuff_intra_notlast_run_14 + 1
};

/*****************************************************************************/
/* inter VLC table when not last coefficient                                 */
/*****************************************************************************/

static fame_vlc_t rlehuff_inter_notlast_run_0[2*12+1] = 
{
  { 0x41, 12}, /* -12 */ 
  { 0x0d, 12}, /* -11 */ 
  { 0x0f, 12}, /* -10 */ 
  { 0x41, 11}, /*  -9 */ 
  { 0x43, 11}, /*  -8 */ 
  { 0x49, 10}, /*  -7 */ 
  { 0x4b, 10}, /*  -6 */ 
  { 0x3f,  9}, /*  -5 */ 
  { 0x2f,  8}, /*  -4 */ 
  { 0x2b,  7}, /*  -3 */ 
  { 0x1f,  5}, /*  -2 */ 
  { 0x05,  3}, /*  -1 */ 
  { 0x00,  0}, /*   0 */
  { 0x04,  3}, /*   1 */ 
  { 0x1e,  5}, /*   2 */ 
  { 0x2a,  7}, /*   3 */ 
  { 0x2e,  8}, /*   4 */ 
  { 0x3e,  9}, /*   5 */ 
  { 0x4a, 10}, /*   6 */ 
  { 0x48, 10}, /*   7 */ 
  { 0x42, 11}, /*   8 */ 
  { 0x40, 11}, /*   9 */ 
  { 0x0e, 12}, /*  10 */ 
  { 0x0c, 12}, /*  11 */ 
  { 0x40, 12}  /*  12 */ 
};

static fame_vlc_t rlehuff_inter_notlast_run_1[2*6+1] = 
{
  { 0xa1, 13}, /*  -6 */
  { 0x43, 12}, /*  -5 */
  { 0x1f, 11}, /*  -4 */
  { 0x3d,  9}, /*  -3 */
  { 0x29,  7}, /*  -2 */
  { 0x0d,  4}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0c,  4}, /*   1 */
  { 0x28,  7}, /*   2 */
  { 0x3c,  9}, /*   3 */
  { 0x1e, 11}, /*   4 */
  { 0x42, 12}, /*   5 */
  { 0xa0, 13}  /*   6 */
};

static fame_vlc_t rlehuff_inter_notlast_run_2[2*4+1] = {
  { 0xa3, 13}, /*  -4 */
  { 0x1d, 11}, /*  -3 */
  { 0x3b,  9}, /*  -2 */
  { 0x1d,  5}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1c,  5}, /*   1 */
  { 0x3a,  9}, /*   2 */
  { 0x1c, 11}, /*   3 */
  { 0xa2, 13}  /*   4 */
};

static fame_vlc_t rlehuff_inter_notlast_run_3[2*3+1] = {
  { 0x1b, 11}, /*  -3 */
  { 0x47, 10}, /*  -2 */
  { 0x1b,  6}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1a,  6}, /*   1 */
  { 0x46, 10}, /*   2 */
  { 0x1a, 11}  /*   3 */
};

static fame_vlc_t rlehuff_inter_notlast_run_4[2*3+1] = {
  { 0xa5, 13}, /*  -3 */
  { 0x45, 10}, /*  -2 */
  { 0x19,  6}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x18,  6}, /*   1 */
  { 0x44, 10}, /*   2 */
  { 0xa4, 13}  /*   3 */
};

static fame_vlc_t rlehuff_inter_notlast_run_5[2*3+1] = {
  { 0xa7, 13}, /*  -3 */
  { 0x19, 11}, /*  -2 */
  { 0x17,  6}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x16,  6}, /*   1 */
  { 0x18, 11}, /*   2 */
  { 0xa6, 13}  /*   3 */
};

static fame_vlc_t rlehuff_inter_notlast_run_6[2*3+1] = {
  { 0xa9, 13}, /*  -3 */
  { 0x17, 11}, /*  -2 */
  { 0x27,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26,  7}, /*   1 */
  { 0x16, 11}, /*   2 */
  { 0xa8, 13}  /*   3 */
};

static fame_vlc_t rlehuff_inter_notlast_run_7[2*2+1] = {
  { 0x15, 11}, /*  -2 */
  { 0x25,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x24,  7}, /*   1 */
  { 0x14, 11}  /*   2 */
};

static fame_vlc_t rlehuff_inter_notlast_run_8[2*2+1] = {
  { 0x13, 11}, /*  -2 */
  { 0x23,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22,  7}, /*   1 */
  { 0x12, 11}  /*   2 */
};

static fame_vlc_t rlehuff_inter_notlast_run_9[2*2+1] = {
  { 0x11, 11}, /*  -2 */
  { 0x21,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x20,  7}, /*   1 */
  { 0x10, 11}  /*   2 */
};

static fame_vlc_t rlehuff_inter_notlast_run_10[2*2+1] = {
  { 0xab, 13}, /*  -2 */
  { 0x2d,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2c,  8}, /*   1 */
  { 0xaa, 13}  /*   2 */
};

static fame_vlc_t rlehuff_inter_notlast_run_11[2*1+1] = {
  { 0x2b,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2a,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_12[2*1+1] = {
  { 0x29,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_13[2*1+1] = {
  { 0x39,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x38,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_14[2*1+1] = {
  { 0x37,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x36,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_15[2*1+1] = {
  { 0x43, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x42, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_16[2*1+1] = {
  { 0x41, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x40, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_17[2*1+1] = {
  { 0x3f, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x3e, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_18[2*1+1] = {
  { 0x3d, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x3c, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_19[2*1+1] = {
  { 0x3b, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x3a, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_20[2*1+1] = {
  { 0x39, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x38, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_21[2*1+1] = {
  { 0x37, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x36, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_22[2*1+1] = {
  { 0x35, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x34, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_23[2*1+1] = {
  { 0x45, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x44, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_24[2*1+1] = {
  { 0x47, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x46, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_25[2*1+1] = {
  { 0xad, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xac, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_notlast_run_26[2*1+1] = {
  { 0xaf, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xae, 13}  /*   1 */
};

static fame_vlc_t *rlehuff_inter_notlast_vlc[27] = {
  rlehuff_inter_notlast_run_0 + 12,
  rlehuff_inter_notlast_run_1 + 6,
  rlehuff_inter_notlast_run_2 + 4,
  rlehuff_inter_notlast_run_3 + 3,
  rlehuff_inter_notlast_run_4 + 3,
  rlehuff_inter_notlast_run_5 + 3,
  rlehuff_inter_notlast_run_6 + 3,
  rlehuff_inter_notlast_run_7 + 2,
  rlehuff_inter_notlast_run_8 + 2,
  rlehuff_inter_notlast_run_9 + 2,
  rlehuff_inter_notlast_run_10 + 2,
  rlehuff_inter_notlast_run_11 + 1,
  rlehuff_inter_notlast_run_12 + 1,
  rlehuff_inter_notlast_run_13 + 1,
  rlehuff_inter_notlast_run_14 + 1,
  rlehuff_inter_notlast_run_15 + 1,
  rlehuff_inter_notlast_run_16 + 1,
  rlehuff_inter_notlast_run_17 + 1,
  rlehuff_inter_notlast_run_18 + 1,
  rlehuff_inter_notlast_run_19 + 1,
  rlehuff_inter_notlast_run_20 + 1,
  rlehuff_inter_notlast_run_21 + 1,
  rlehuff_inter_notlast_run_22 + 1,
  rlehuff_inter_notlast_run_23 + 1,
  rlehuff_inter_notlast_run_24 + 1,
  rlehuff_inter_notlast_run_25 + 1,
  rlehuff_inter_notlast_run_26 + 1
};

/*****************************************************************************/
/* intra VLC table when last coefficient                                     */
/*****************************************************************************/

static fame_vlc_t rlehuff_intra_last_run_0[2*8+1] = {
  { 0xb3, 13}, /*  -8 */
  { 0x09, 12}, /*  -7 */
  { 0x0b, 12}, /*  -6 */
  { 0x0d, 11}, /*  -5 */
  { 0x2f, 10}, /*  -4 */
  { 0x2d,  9}, /*  -3 */
  { 0x19,  7}, /*  -2 */
  { 0x0f,  5}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0e,  5}, /*   1 */
  { 0x18,  7}, /*   2 */
  { 0x2c,  9}, /*   3 */
  { 0x2e, 10}, /*   4 */
  { 0x0c, 11}, /*   5 */
  { 0x0a, 12}, /*   6 */
  { 0x08, 12}, /*   7 */
  { 0xb2, 13}  /*   8 */
};

static fame_vlc_t rlehuff_intra_last_run_1[2*3+1] = {
  { 0x0b, 11}, /*  -3 */
  { 0x2d, 10}, /*  -2 */
  { 0x1f,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1e,  7}, /*   1 */
  { 0x2c, 10}, /*   2 */
  { 0x0a, 11}  /*   3 */
};

static fame_vlc_t rlehuff_intra_last_run_2[2*2+1] = {
  { 0x09, 11}, /*  -2 */
  { 0x1d,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1c,  7}, /*   1 */
  { 0x08, 11}  /*   2 */
};

static fame_vlc_t rlehuff_intra_last_run_3[2*2+1] = {
  { 0x49, 12}, /*  -2 */
  { 0x23,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22,  8}, /*   1 */
  { 0x48, 12}  /*   2 */
};

static fame_vlc_t rlehuff_intra_last_run_4[2*2+1] = {
  { 0x4b, 12}, /*  -2 */
  { 0x21,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x20,  8}, /*   1 */
  { 0x4a, 12}  /*   2 */
};

static fame_vlc_t rlehuff_intra_last_run_5[2*2+1] = {
  { 0xb5, 13}, /*  -2 */
  { 0x27,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26,  8}, /*   1 */
  { 0xb4, 13}  /*   2 */
};

static fame_vlc_t rlehuff_intra_last_run_6[2*2+1] = {
  { 0xb7, 13}, /*  -2 */
  { 0x2b,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2a,  9}, /*   1 */
  { 0xb6, 13}  /*   2 */
};

static fame_vlc_t rlehuff_intra_last_run_7[2*1+1] = {
  { 0x29,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28,  9}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_8[2*1+1] = {
  { 0x27,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26,  9}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_9[2*1+1] = {
  { 0x35,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x34,  9}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_10[2*1+1] = {
  { 0x2b, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2a, 10}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_11[2*1+1] = {
  { 0x29, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28, 10}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_12[2*1+1] = {
  { 0x27, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26, 10}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_13[2*1+1] = {
  { 0x25, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x24, 10}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_14[2*1+1] = {
  { 0x23, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22, 10}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_15[2*1+1] = {
  { 0x4d, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x4c, 12}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_16[2*1+1] = {
  { 0x4f, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x4e, 12}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_17[2*1+1] = {
  { 0xb9, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb8, 13}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_18[2*1+1] = {
  { 0xbb, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xba, 13}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_19[2*1+1] = {
  { 0xbd, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xbc, 13}  /*   1 */
};

static fame_vlc_t rlehuff_intra_last_run_20[2*1+1] = {
  { 0xbf, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xbe, 13}  /*   1 */
};

static fame_vlc_t *rlehuff_intra_last_vlc[21] = {
  rlehuff_intra_last_run_0 + 8,
  rlehuff_intra_last_run_1 + 3,
  rlehuff_intra_last_run_2 + 2,
  rlehuff_intra_last_run_3 + 2,
  rlehuff_intra_last_run_4 + 2,
  rlehuff_intra_last_run_5 + 2,
  rlehuff_intra_last_run_6 + 2,
  rlehuff_intra_last_run_7 + 1,
  rlehuff_intra_last_run_8 + 1,
  rlehuff_intra_last_run_9 + 1,
  rlehuff_intra_last_run_10 + 1,
  rlehuff_intra_last_run_11 + 1,
  rlehuff_intra_last_run_12 + 1,
  rlehuff_intra_last_run_13 + 1,
  rlehuff_intra_last_run_14 + 1,
  rlehuff_intra_last_run_15 + 1,
  rlehuff_intra_last_run_16 + 1,
  rlehuff_intra_last_run_17 + 1,
  rlehuff_intra_last_run_18 + 1,
  rlehuff_intra_last_run_19 + 1,
  rlehuff_intra_last_run_20 + 1
};


/*****************************************************************************/
/* inter VLC table when last coefficient                                     */
/*****************************************************************************/

static fame_vlc_t rlehuff_inter_last_run_0[2*3+1] = {
  { 0x0b, 12}, /*  -3 */
  { 0x33, 10}, /*  -2 */
  { 0x0f,  5}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0e,  5}, /*   1 */
  { 0x32, 10}, /*   2 */
  { 0x0a, 12}  /*   3 */
};

static fame_vlc_t rlehuff_inter_last_run_1[2*2+1] = {
  { 0x09, 12}, /*  -2 */
  { 0x1f,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1e,  7}, /*   1 */
  { 0x08, 12}  /*   2 */
};

static fame_vlc_t rlehuff_inter_last_run_2[2*1+1] = {
  { 0x1d,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1c,  7}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_3[2*1+1] = {
  { 0x1b,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x1a,  7}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_4[2*1+1] = {
  { 0x19,  7}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x18,  7}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_5[2*1+1] = {
  { 0x27,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_6[2*1+1] = {
  { 0x25,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x24,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_7[2*1+1] = {
  { 0x23,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_8[2*1+1] = {
  { 0x21,  8}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x20,  8}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_9[2*1+1] = {
  { 0x35,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x34,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_10[2*1+1] = {
  { 0x33,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x32,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_11[2*1+1] = {
  { 0x31,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x30,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_12[2*1+1] = {
  { 0x2f,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2e,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_13[2*1+1] = {
  { 0x2d,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2c,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_14[2*1+1] = {
  { 0x2b,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2a,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_15[2*1+1] = {
  { 0x29,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_16[2*1+1] = {
  { 0x27,  9}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26,  9}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_17[2*1+1] = {
  { 0x31, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x30, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_18[2*1+1] = {
  { 0x2f, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2e, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_19[2*1+1] = {
  { 0x2d, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2c, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_20[2*1+1] = {
  { 0x2b, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x2a, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_21[2*1+1] = {
  { 0x29, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x28, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_22[2*1+1] = {
  { 0x27, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x26, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_23[2*1+1] = {
  { 0x25, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x24, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_24[2*1+1] = {
  { 0x23, 10}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x22, 10}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_25[2*1+1] = {
  { 0x0f, 11}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0e, 11}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_26[2*1+1] = {
  { 0x0d, 11}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0c, 11}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_27[2*1+1] = {
  { 0x0b, 11}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x0a, 11}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_28[2*1+1] = {
  { 0x09, 11}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x08, 11}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_29[2*1+1] = {
  { 0x49, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x48, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_30[2*1+1] = {
  { 0x4b, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x4a, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_31[2*1+1] = {
  { 0x4d, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x4c, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_32[2*1+1] = {
  { 0x4f, 12}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0x4e, 12}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_33[2*1+1] = {
  { 0xb1, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb0, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_34[2*1+1] = {
  { 0xb3, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb2, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_35[2*1+1] = {
  { 0xb5, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb4, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_36[2*1+1] = {
  { 0xb7, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb6, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_37[2*1+1] = {
  { 0xb9, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xb8, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_38[2*1+1] = {
  { 0xbb, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xba, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_39[2*1+1] = {
  { 0xbd, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xbc, 13}  /*   1 */
};

static fame_vlc_t rlehuff_inter_last_run_40[2*1+1] = {
  { 0xbf, 13}, /*  -1 */
  { 0x00,  0}, /*   0 */
  { 0xbe, 13}  /*   1 */
};

static fame_vlc_t *rlehuff_inter_last_vlc[41] = {
  rlehuff_inter_last_run_0 + 3,
  rlehuff_inter_last_run_1 + 2,
  rlehuff_inter_last_run_2 + 1,
  rlehuff_inter_last_run_3 + 1,
  rlehuff_inter_last_run_4 + 1,
  rlehuff_inter_last_run_5 + 1,
  rlehuff_inter_last_run_6 + 1,
  rlehuff_inter_last_run_7 + 1,
  rlehuff_inter_last_run_8 + 1,
  rlehuff_inter_last_run_9 + 1,
  rlehuff_inter_last_run_10 + 1,
  rlehuff_inter_last_run_11 + 1,
  rlehuff_inter_last_run_12 + 1,
  rlehuff_inter_last_run_13 + 1,
  rlehuff_inter_last_run_14 + 1,
  rlehuff_inter_last_run_15 + 1,
  rlehuff_inter_last_run_16 + 1,
  rlehuff_inter_last_run_17 + 1,
  rlehuff_inter_last_run_18 + 1,
  rlehuff_inter_last_run_19 + 1,
  rlehuff_inter_last_run_20 + 1,
  rlehuff_inter_last_run_21 + 1,
  rlehuff_inter_last_run_22 + 1,
  rlehuff_inter_last_run_23 + 1,
  rlehuff_inter_last_run_24 + 1,
  rlehuff_inter_last_run_25 + 1,
  rlehuff_inter_last_run_26 + 1,
  rlehuff_inter_last_run_27 + 1,
  rlehuff_inter_last_run_28 + 1,
  rlehuff_inter_last_run_29 + 1,
  rlehuff_inter_last_run_30 + 1,
  rlehuff_inter_last_run_31 + 1,
  rlehuff_inter_last_run_32 + 1,
  rlehuff_inter_last_run_33 + 1,
  rlehuff_inter_last_run_34 + 1,
  rlehuff_inter_last_run_35 + 1,
  rlehuff_inter_last_run_36 + 1,
  rlehuff_inter_last_run_37 + 1,
  rlehuff_inter_last_run_38 + 1,
  rlehuff_inter_last_run_39 + 1,
  rlehuff_inter_last_run_40 + 1
};

/*****************************************************************************/
/* Maximum run & level                                                       */
/*****************************************************************************/

static char rlehuff_intra_max_level[64] = 
{27,10, 5, 4, 3, 3, 3, 3, 2, 2, 1, 1, 1, 1, 1, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static char rlehuff_intra_max_level_last[64] = 
{ 8, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static char rlehuff_inter_max_level[64] = 
{12, 6, 4, 3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static char rlehuff_inter_max_level_last[64] = 
{ 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static char rlehuff_intra_max_run[256] = 
{ 0,14, 9, 7, 3, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

static char rlehuff_intra_max_run_last[256] = 
{ 0,20, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

static char rlehuff_inter_max_run[256] = 
{ 0,26,10, 6, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 ,0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

static char rlehuff_inter_max_run_last[256] = 
{ 0,40, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
