/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier
                            Damien Vincent

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static unsigned int MAE8x8_withmask(unsigned char *ref,
				    unsigned char *input,
				    unsigned char *shape,
				    int pitch)
{
  int j,i;

  unsigned int error = 0;

  for(i=0; i<8; i++)
  {
    for(j=0; j<8; j++)
      if(shape[j])
	error += (unsigned int) abs(input[j] - ref[j]);

    ref += pitch;
    input += pitch;
    shape += pitch;
  }
        
  return error;
}

static unsigned int MAE8x8_withoutmask(unsigned char *ref,
				       unsigned char *input,
				       unsigned char *shape,
				       int pitch)
{
  int j,i;

  unsigned int error = 0;

  for(i=0; i<8; i++)
  {
    for(j=0; j<8; j++)
      error += (unsigned int) abs(input[j] - ref[j]);

    ref += pitch;
    input += pitch;
  }
        
  return error;
}
