/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if defined(HAS_MMX)
/* use transposed tables to avoid transpose operation after DCT/iDCT */

/* zigzaging table */
unsigned char mpeg4_zigzag_table[] = {
   0,  8,  1,  2,  9, 16, 24, 17,
  10,  3,  4, 11, 18, 25, 32, 40,
  33, 26, 19, 12,  5,  6, 13, 20,
  27, 34, 41, 48, 56, 49, 42, 35,
  28, 21, 14,  7, 15, 22, 29, 36,
  43, 50, 57, 58, 51, 44, 37, 30,
  23, 31, 38, 45, 52, 59, 60, 53,
  46, 39, 47, 54, 61, 62, 55, 63,
   0
};

unsigned char mpeg4_zigzag_alternate_horizontal_table[] = {
    0,  8, 16, 24,  1,  9,  2, 10,
   17, 25, 32, 40, 48, 56, 57, 49,
   41, 33, 26, 18,  3, 11,  4, 12,
   19, 27, 34, 42, 50, 58, 35, 43,
   51, 59, 20, 28,  5, 13,  6, 14,
   21, 29, 36, 44, 52, 60, 37, 45,
   53, 61, 22, 30,  7, 15, 23, 31,
   38, 46, 54, 62, 39, 47, 55, 63,
    0
};

unsigned char mpeg4_zigzag_alternate_vertical_table[] = {
   0,  1,  2,  3,  8,  9, 16, 17,
  10, 11,  4,  5,  6,  7, 15, 14,
  13, 12, 19, 18, 24, 25, 32, 33,
  26, 27, 20, 21, 22, 23, 28, 29,
  30, 31, 34, 35, 40, 41, 48, 49,
  42, 43, 36, 37, 38, 39, 44, 45,
  46, 47, 50, 51, 56, 57, 58, 59,
  52, 53, 54, 55, 60, 61, 62, 63,
   0  
};

#else

/* zigzaging table */
unsigned char mpeg4_zigzag_table[] = {
   0,  1,  8, 16,  9,  2,  3, 10,
  17, 24, 32, 25, 18, 11,  4,  5,
  12, 19, 26, 33, 40, 48, 41, 34,
  27, 20, 13,  6,  7, 14, 21, 28,
  35, 42, 49, 56, 57, 50, 43, 36,
  29, 22, 15, 23, 30, 37, 44, 51,
  58, 59, 52, 45, 38, 31, 39, 46,
  53, 60, 61, 54, 47, 55, 62, 63,
   0
};

unsigned char mpeg4_zigzag_alternate_horizontal_table[] = {
   0,  1,  2,  3,  8,  9, 16, 17,
  10, 11,  4,  5,  6,  7, 15, 14,
  13, 12, 19, 18, 24, 25, 32, 33,
  26, 27, 20, 21, 22, 23, 28, 29,
  30, 31, 34, 35, 40, 41, 48, 49,
  42, 43, 36, 37, 38, 39, 44, 45,
  46, 47, 50, 51, 56, 57, 58, 59,
  52, 53, 54, 55, 60, 61, 62, 63,
   0  
};

unsigned char mpeg4_zigzag_alternate_vertical_table[] = {
    0,  8, 16, 24,  1,  9,  2, 10,
   17, 25, 32, 40, 48, 56, 57, 49,
   41, 33, 26, 18,  3, 11,  4, 12,
   19, 27, 34, 42, 50, 58, 35, 43,
   51, 59, 20, 28,  5, 13,  6, 14,
   21, 29, 36, 44, 52, 60, 37, 45,
   53, 61, 22, 30,  7, 15, 23, 31,
   38, 46, 54, 62, 39, 47, 55, 63,
    0
};

#endif
