/* 
 * Copyright (C) 2002 the xine project
 * 
 * This file is part of xine, a unix video player.
 * 
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: svq1_cb.h,v 1.1 2002/06/22 23:07:41 arpi Exp $
 */

#include <inttypes.h>


/* 6x16-entry codebook for inter-coded 4x2 vectors */
static int8_t inter_codebook_4x2[768] = {
    7,  2, -6, -7,  7,  3, -3, -4, -7, -2,  7,  8, -8, -4,  3,  4,
   19, 17,  9,  3,-14,-16,-12, -8,-18,-16, -8, -3, 11, 14, 12,  8,
    7,-16,-10, 20,  7,-17,-10, 20, -6, 18,  8,-21, -7, 18,  9,-20,
   25,  3,-20,-14, 29,  7,-18,-13,-29, -4, 21, 14,-31, -6, 20, 14,
  -19,-26,-28,-24, 31, 32, 22, 10, 15, 24, 31, 28,-32,-32,-22,-13,
    2, -8,-23,-26, -9,  3, 27, 35,  3, 11, 21, 21,  8, -4,-27,-34,
  -30,-31, 12, 47,-29,-30, 13, 47, 38, 30,-17,-46, 34, 26,-19,-46,
  -42,-50,-51,-43, 34, 48, 55, 48, 48, 54, 51, 42,-44,-52,-53,-47,
    4,  5,  0, -6, -2, -2,  0,  1,-11, -6, -1, -2,  1,  8,  9,  1,
    0,  1, -6,  5,  8,  1,-12,  2,  7,-14, -7,  8,  5, -8,  0,  8,
    1,  4, 11,  8,-12, -8,  0, -5, -1,  1,  0,  4,-15, -8,  3, 16,
   17,  8, -4, -6,  9, -4,-13, -8,  2,  6,  1,-18, -1, 11, 11,-12,
    6,  0,  2,  0, 14,  6, -7,-21,  1, -1,-13,-20,  1,  1, 10, 21,
  -22, -5,  7, 13,-11, -1,  4, 12, -7,  0, 14, 19, -4,  3, -5,-19,
  -26,-14, 10, 15, 18,  4, -6, -2, 25, 19, -5,-18,-20, -7,  4,  2,
  -13, -6, -1, -4, 25, 37, -2,-35,  5,  4,  1,  1,-21,-36,  2, 43,
    2, -2, -1,  3,  8, -2, -6, -1, -2, -3,  2, 12, -5, -2, -2, -1,
   -3, -1, -1, -5, -1,  7,  8, -2,  2,  7,  5, -3,  1,  1, -3, -8,
   -3, -1, -3, -2, -2, -3,  2, 13, 15,  0,-11, -6,  3,  0,  0,  0,
   -6, -9, -5, -4, 18,  4,  1,  3, 12,  3,  0,  4,-16, -3,  3, -3,
  -17,  3, 18,  2, -1, -3, -1, -1, -6, 16, -8,  0, -9, 14, -7,  0,
    3,-13, 14, -5,  3,-13, 14, -4, -7, 20, 14,-23,  8, -7, -8,  4,
    8,-15,-19, 16,-10, 13, 11, -3,  9, -1,  1, 26,  5,-15,-27,  2,
  -20,  7, 16, -4,-40,  9, 31,  1, 26,-12,-30, -7, 40, -2,-19,  4,
    6,  0,  0,  0, -6, -2,  1,  2,  0, -1,  0, -6,  9,  0, -2, -1,
   -7,  8,  2, -3, -1,  2, -3,  2,  7, -4, -2,  4,  2,  0,  0, -6,
   -3, -2,  9,  2, -2, -1,  0, -4, -3, -3,  0, -3, -6,  2, 10,  4,
    3,  0,-10,  8,  0,  0, -4,  4, -1,  1,  4,  2,  3, -7, -9,  7,
    2,  1, -9, -4, -1, 12,  0,  0,  3, -1,  7, -4,  3,-14,  4,  2,
  -12, -9,  1, 11,  2,  5,  1,  0,  3,  1,  0,  2,  0,  8,  6,-19,
   -6,-10, -7, -4,  9,  7,  5,  7,  6, 21,  3, -3,-11, -9, -5, -2,
   -4, -9,-16, -1, -2, -5,  1, 36,  8, 11, 19,  0,  2,  5, -4,-41,
   -1, -1, -2, -1, -2, -2,  1,  6,  0,  4,  1, -8,  1,  1,  1,  0,
   -2, -3,  4,  0,  2, -1,  3, -3,  1,  3, -4,  1, -1,  3,  0, -5,
    3,  4,  2,  3, -2, -3, -6, -1, -2, -3, -2,  2, -4,  8,  1,  0,
   -7,  4,  2,  6, -7, -1,  1,  0, -2,  2, -4,  1,  8, -6,  2, -1,
   -6,  2,  0,  2,  5,  4, -8, -1, -1,-11,  0,  9,  0, -2,  2,  2,
   17, -5, -4, -1, -1, -4, -2, -2,  0,-13,  9, -3, -1, 12, -7,  2,
    0, -2, -5,  2, -7, -5, 20, -3,  7,  7, -1,-30,  3,  5,  8,  1,
   -6,  3, -1, -4,  2, -2,-11, 18,  0, -7,  3, 14, 20, -3,-18, -9,
    7, -2,  0, -1, -2,  0,  0, -1, -4, -1,  1,  0, -2,  2,  0,  4,
    1, -3,  2,  1,  3,  1, -5,  1, -3,  0, -1, -2,  7,  1,  0, -3,
    2,  5,  0, -2,  2, -5, -1,  1, -1, -2,  4, -1,  0, -3,  5,  0,
    0,  3, -1, -2, -4,  1,  5, -1, -1,  0, -1,  9, -1, -2, -1, -1,
   -2,  5,  5, -1, -2,  2, -3, -2,  1,  2,-11,  1,  2,  1,  3,  2,
    2,-10, -1, -2,  4,  2,  4,  1,  4,  5, -5,  1,  0,  6,-11,  1,
    1,  0,  6,  6,  0,  2,  1,-15,  7,  3,  5,  9,-30,  2,  2,  2,
  -34,  1,  9,  2,  5,  8,  8,  2,  7,  2,  6,  6,  2,-27,  1,  4
};

/* 6x16-entry codebook for inter-coded 4x4 vectors */
static int8_t inter_codebook_4x4[1536] = {
    4,  0, -6, -7, -4, -8,-13, -9, -8, -8, -1,  6, -2,  5, 22, 27,
  -16, -7, 11, 10,-18, -7, 13, 10,-15, -4, 12,  8, -9, -1,  9,  5,
   -2,  2, 15,-16, -3,  2, 19,-19, -3,  2, 19,-19, -2,  3, 15,-14,
   17, 22, 22, 16, -6, -7, -5, -2,-12,-16,-16,-12,  1,  1, -1, -3,
   11,-17,  0,  8, 14,-21, -1,  9, 14,-21, -2,  8, 11,-16, -2,  6,
    7, -2,-16, 11,  9, -2,-21, 14, 10, -1,-22, 14,  8, -1,-18, 10,
  -10, 16,  3, -9,-13, 20,  4,-11,-14, 21,  4,-10,-11, 16,  3, -8,
   11,  4, -9, -9, 15,  6,-12,-14, 17,  8,-12,-14, 16, 10, -7,-11,
    4, 10, 14, 13, -1,  7, 15, 16,-12, -7,  3,  8,-20,-23,-18,-10,
  -10,-18,-26,-25,  4,  1, -6,-11, 13, 15, 11,  3, 12, 15, 13,  8,
  -16,-19,-16,-11,  7, 12, 15, 11, 11, 16, 16, 11, -6, -9,-11,-10,
   18, 19, 12,  5, 18, 16,  5, -4,  6,  0,-10,-15, -9,-17,-23,-22,
  -10,-14, -1, 21,-11,-17,  0, 29,-11,-16,  1, 30,-10,-14,  0, 23,
  -16,-17,-12, -6,-19,-19,-14, -7, -3, -1,  1,  2, 27, 35, 29, 19,
  -37, -8, 23, 23,-42, -9, 28, 29,-43,-10, 26, 28,-38,-11, 19, 22,
   32, 16,-16,-33, 39, 20,-18,-37, 38, 19,-19,-38, 32, 15,-17,-34,
   24,  9, -6, -4, -1,-10, -6,  3, -8, -9, -1,  3,  3,  7,  2, -6,
   -1, -3, -1,  0, -1,  4,  2, -7, -3, 11,  3,-16,  1, 20,  9,-18,
   -3, -8,  6, 12, -5,-10,  7, 13, -6, -9,  5,  7, -5, -5,  2, -1,
   -8, 12, -3, -1,-10, 15, -3,  1,-11, 13, -4,  1,-11,  8, -3,  2,
    9,  6, -5,-12,  3,  0, -8,-13, -4, -4, -1, -1, -4,  1, 15, 18,
    9, 13, 14, 12,  4,  3, -1, -2, -2, -5, -8, -5, -7,-11, -9, -4,
    7, -5, -7, -4, 14, -2, -7, -4, 17,  0, -8, -5, 15,  1, -7, -5,
  -10, -1,  6,  4,-15, -9,  2,  4,  2, -1, -3,  0, 25, 13, -8,-10,
    7, 11, -3,-16,  7, 11, -3,-15,  6,  7, -2, -9,  4,  2, -3, -5,
   -7, -1, -1,  0, -9, -2,  2,  6,-12, -4,  6, 14,-13, -6,  8, 19,
  -18,-18,-11, -5, -3,  0,  3,  4,  6,  8,  6,  6,  6,  6,  6,  6,
   -5,  3, 13,-10, -6,  1, 15, -9, -6, -3, 15, -6, -6, -6, 10, -3,
    9,  1, -9, -9, 11,  9,  6,  5,  0,  3,  8,  7,-15,-14, -6, -5,
  -11, -6, 11, 19, -2, -5, -9, -8,  6,  2, -9,-10,  6,  5,  4,  5,
   -7, -3,  8, 15, -1,  3, 10, 15,  5,  5, -1, -2,  4, -2,-21,-25,
    6, -6, -6,  5,  8, -9, -7,  9,  8,-12, -7, 13,  4,-14, -7, 14,
   -4, -3,  1,  1, -3, -5, -2, -3,  7,  0, -2, -4, 20,  7, -4, -4,
   -3,-20, -6, 10,  6,  0,  0,  1,  5,  8,  5, -1, -3,  0,  0, -2,
   13,  6, -1,  2,  5,  3,  2,  3, -3,  0,  3,  0,-16, -8, -2, -5,
   -2, -7, -6,  0, -3, -6, -3,  1, -5, -1,  2, -1, -1, 12, 16,  5,
   -7,  1,  9,  8,-10, -2,  5,  3, -6,  2,  7,  3, -4,  0, -1, -7,
    3,  4, -9,-24,  0,  2,  6,  3, -1, -1,  4,  7,  5,  3, -1, -2,
    3,  6, -9,  2,  1,  6,-13,  1,  1,  8,-10,  2,  1,  8, -7,  1,
   -3, -3,  2, 22, -2, -3, -5, 12, -2, -3,-10,  2, -3, -1, -4,  2,
   11, 12,  8,  2, -5, -5, -5, -8, -6, -4,  0, -3, -2, -1,  3,  3,
   12, -6, -2, -1, 12, -8, -2, -2,  9, -7,  0, -3,  4, -6,  2, -2,
  -19,  1, 12, -3, -4,  4,  5, -4,  6,  1, -2, -1,  4, -4, -2,  7,
   -3, -4, -7, -8, -4, -4, -2,  0, -1,  2, 14, 16, -4, -2,  4,  4,
   -1,  7,  2, -5, -2,  0, -1,  1,  4, -3, -1, 13,  6,-12,-14,  8,
   -1,  5,  4, -5, -2,  5,  3, -9, -2,  7,  4,-12, -1,  7,  4, -9,
   -6, -3,  1,  1, 11, 11,  0, -6,  6,  4, -2, -7,-12,-10,  3, 10,
   -2, -3, -3, -2,  6, 11, 14, 10, -9,-11,-10,-10,  2,  2,  3,  2,
   -7, -5, -7, -1, -1,  2,  0,  7, -1,  1,  0,  9,  3,  4, -5, -1,
   10, -1,-15, -1,  4,  1, -5,  2, -3,  1, -1,  1, -3,  1,  4,  4,
    2, -1,  4, 10,  6,  2, -1,  0,  2,  2, -7,-12, -4,  2,  0, -3,
   -1, -4, -1, -8,  3, -1,  2, -9,  4,  0,  5, -5,  2,  0,  8,  3,
    3,  2,  1,  1,  4, -2,  0,  3,  2, -1,  4,  1,  0,  6, -1,-25,
   -1, -2, -2, -4, -3,  0, -1, -4, -1, -1, -4,  2,  0, -6,  2, 25,
  -11, -1,  5,  0,  7,  0, -2,  2, 10, -1, -3,  4, -5, -5, -2, -1,
    0,  6,  3, -1, -2, -1, -1,  1, -1, -7,-12, -5,  8,  6,  2,  4,
    2,  6, -1, -6,  9, 10, -1, -4,  1,  0, -4,  0,  3, -2, -9, -5,
   -4,  3,  4,  0, -4,  3,  3,  0,-11,  0,  3,  2,-11,  3,  7,  2,
    2, -4,  7,  3,  1, -8,  7,  1, -1,-12,  4,  1,  3, -9,  2,  2,
    2, -2, -2,  9,-17, -3,  3,  1, -4,  7,  1, -6,  5,  4, -1,  3,
   -1,  2,  0, -4, -7,  8, 12, -1, -2,  5,  4, -5,  3, -5, -8, -2,
    0,  0, -5, -2, -2, -8,  3, 27, -1, -4, -3,  6, -3,  1, -2, -7,
    4,  4,  1, -1, -7,-10, -7, -3, 10, 10,  5,  3, -2, -2, -4, -3,
    0,  1,  5,  7,  4, -2,-16,-20,  0,  4,  7,  8,  2,  0, -2, -1,
   -2,  1,  3, 17, -3,  1, -2, -1, -1, -2, -1, -2, -1, -5, -1,  0,
    5, -3,  1,  0,  6, -2,  0,  0, -1, -2,  0, -3,-11,  1,  8, -1,
    3,  0,  0,  0,  0,  2,  4,  1,  2,  0,  6,  1, -2,-18, -3,  2,
  -14,  0,  6,  1, -5, -2, -1,  1, -1,  1,  0,  1,  1,  7,  4,  0,
   -1,  0,  1, -4,  1,  8,  3, -4, -3,  4,  1,  3, -6,  1, -4,  1,
    1,-12,  3,  3, -1,-10,  0, -1,  2,  0,  2,  1,  3,  2,  2,  4,
    3,  0,  0,  3,  2,  0, -2,  1,  5,  2, -5,  0,  6, -1,-14, -1,
   -2, -6, -3, -3,  2, -1,  4,  5,  6, -1, -2,  0,  4,  4, -1, -5,
   -4,  1,-11,  0, -1,  2, -4,  1,  2, -3,  3, -1,  1, -2, 15,  0,
    1, -1,  0, -2,  1, -4, -7,  1, -2, -6, -1, 21, -2,  2, -1,  1,
   21, -1, -2,  0, -1, -3,  1, -2, -9, -2,  2, -1,  2,  1, -4, -1,
    1,  8,  2, -6,-10, -1,  4,  0, -4, -3,  3,  3,  5,  0, -1, -1,
    3,  2,  1, -2, -2, -2,  4,  3,  5,  2, -4,-17,  0, -2,  4,  3,
   -7, -4,  0,  3,  9,  9,  2, -1,-11, -6,  0, -1,  5,  1,  0,  1,
    0, 17,  5,-11,  3, -2, -6,  0,  2, -2, -4,  1, -4,  1,  2, -1,
   -5, -1, -5, -3, -3,  5, -3, -2,  4, 16,  2, -5, -2,  5, -1, -1,
    0,  0, -4,  1, -1,  2,  5, 11, -1, -1, -2,  1, -4, -2, -3, -1,
   -5, -1, 10,  0,  6,  1,  0, -3,  0, -4,  1,  0, -2, -4,  3, -1,
    6,  9,  3,  0, -2,  1, -2,  0, -2, -3, -2, -2,  1,  0,  1, -6,
    1,  0,  2,  1, -1,  3, -2,  1,  0, -1,-15,  0, -1,  5,  2,  6,
    2,  0,  2,  2,  0,-12, -4,  6,  0,  1,  4, -1,  1,  2,  1, -4,
    1, -2, -7,  0,  0,  0,  0, -1, -5,  2, 11,  3,  1,  3,  0, -6,
    0, -3, -9, -4,  1,  3, -1,  0,  4,  1, -2,  0,  7, -3, -1,  6,
    1, -2,  6,  2,  0, -1,  3, -2, -2,  4,  0,  2, -1,  2,-14,  2,
    2,  2,  0, -1, -2,  3, -3,-14,  0,  2,  3, -3,  5,  1,  3,  2,
    1, -3,  4,-14,  1, -2, 11, -1,  0, -1,  3,  0, -1,  1,  0,  2,
   -2,  3, -3,  2, -4, -1, -4,  3, -1,  2,  1,  3, -6, -2,  2,  7,
   -2,  1,  2,  0, -2,  0,  0, -1, 12,  5, -1,  2, -8, -1,  1, -7,
    2, -2, -4,  2, 11,  0,-11, -2,  3,  1, -3, -1,  0,  3,  1, -1,
    0,  3,  0, -2,  0, -6, -1, -3, 12, -7, -2,  0,  7, -2,  1,  1,
    1,  2,  2,  2, -1,  2,  0,  2,-23,  0,  4,  0,  3,  2,  1,  3,
   -4, -5, -1,  5, -3,  5, 10, -1,  0,  0,  3, -4,  1, -1,  2, -5
};

/* 6x16-entry codebook for inter-coded 8x4 vectors */
static int8_t inter_codebook_8x4[3072] = {
    9,  8,  4,  0, -3, -4, -4, -3,  9,  8,  4, -1, -4, -5, -5, -3,
    8,  7,  3, -2, -5, -5, -5, -4,  6,  4,  1, -2, -4, -5, -4, -3,
  -12,-14,-11, -4,  1,  5,  6,  6, -8,-10, -7, -5, -2,  1,  1,  1,
    5,  4,  3,  1,  0,  0, -1, -1, 13, 13,  9,  6,  3,  0, -1, -2,
   -4, -4, -3, -1,  1,  4,  8, 11, -5, -6, -4, -2,  0,  3,  8, 12,
   -7, -7, -6, -4, -2,  2,  7, 10, -7, -7, -5, -4, -2,  1,  5,  8,
   -3, -2, -1,  1,  3,  6,  7,  6,  2,  3,  5,  7,  8,  8,  6,  4,
    4,  5,  4,  3,  1, -2, -6, -7,  1,  0, -2, -7,-10,-14,-17,-16,
   -5, -4,  1,  8,  9,  3, -3, -7, -7, -6,  1, 11, 12,  5, -3, -8,
   -8, -7,  0,  9, 11,  5, -3, -7, -8, -6, -1,  5,  8,  4, -2, -6,
   -4, -5, -7, -8, -9, -9, -8, -6, -4, -5, -6, -7, -7, -6, -4, -2,
    0,  1,  2,  3,  5,  8, 10,  9,  1,  2,  3,  6,  9, 12, 14, 13,
    5,  6,  6,  5,  4,  3,  2,  1,  5,  6,  7,  7,  6,  6,  6,  4,
   -1,  0,  1,  1,  3,  5,  5,  5,-13,-16,-17,-17,-14,-10, -6, -4,
    9, 11, 13, 16, 15, 13, 12, 10, -4, -5, -6, -7, -7, -7, -6, -5,
   -6, -6, -7, -7, -7, -7, -6, -5, -2, -1,  0,  0,  0,  0,  0, -1,
  -11,-13,-15,-16,-16,-14,-12,-10,  2,  3,  4,  5,  4,  3,  3,  3,
    6,  7,  8,  8,  8,  7,  6,  5,  3,  4,  3,  3,  3,  3,  3,  3,
    3,  4,  4,  1, -2, -7,-13,-17,  5,  7,  7,  5,  1, -5,-13,-19,
    6,  8,  9,  8,  5, -1, -9,-16,  6,  8, 10, 10,  7,  2, -4,-11,
   18,  9, -1,-10,-13, -9, -4,  0, 22, 12, -1,-12,-15,-10, -4,  2,
   23, 13,  0,-10,-13, -9, -3,  2, 20, 12,  2, -6, -9, -6, -2,  2,
   -6, -6, -6, -7, -7, -7, -7, -6, -6, -7, -8, -8, -9, -9, -9, -8,
   -3, -3, -3, -3, -3, -3, -3, -3, 12, 15, 18, 21, 21, 19, 17, 14,
   14, 16, 18, 18, 18, 16, 15, 13,  5,  6,  6,  5,  5,  4,  4,  3,
   -6, -7, -9,-10,-10,-10, -9, -7,-10,-11,-13,-14,-14,-13,-12,-10,
  -27,-17, -4,  5,  9, 10, 10,  7,-32,-19, -3,  7, 11, 12, 11,  8,
  -30,-16, -2,  8, 12, 12, 10,  7,-23,-12,  0,  7, 10, 11,  9,  6,
   16, 17, 16, 12,  6, -1, -8,-12, 17, 18, 15, 10,  1, -8,-15,-18,
   15, 14, 10,  4, -5,-14,-20,-23, 10,  8,  4, -1, -9,-16,-21,-22,
  -10,-12,-12,-11, -5,  4, 14, 20,-11,-13,-15,-12, -4,  7, 19, 27,
  -11,-13,-14,-11, -3,  8, 21, 28,-10,-11,-12, -9, -2,  8, 18, 25,
   -1, -1, -1,  1,  4,  6,  6,  5,  0,  0,  0,  2,  4,  3,  1, -2,
    0,  0,  2,  4,  4, -1, -7,-10,  0,  0,  3,  5,  3, -3,-11,-15,
  -14,-13, -8, -1,  3,  3, -1, -4, -5, -4, -1,  4,  8,  8,  3,  0,
    3,  2,  2,  3,  4,  5,  3,  1,  5,  3,  0, -2, -2, -1, -1, -1,
    9,  1, -6, -6, -5, -3, -2, -1, 12,  1, -6, -6, -4, -2, -1,  0,
   14,  4, -4, -4, -2, -2, -1, -1, 14,  6, -1, -1, -1, -1, -1, -1,
    4,  6,  8, 10, 11,  9,  7,  5, -1, -1, -1,  0,  0, -1, -1, -2,
   -2, -4, -4, -5, -5, -5, -5, -4, -2, -3, -3, -4, -4, -3, -2, -1,
    2,  3,  4,  4,  3,  1,  0,  0, -1,  1,  4,  5,  6,  5,  4,  3,
   -8, -6, -2,  2,  3,  4,  4,  3,-14,-13, -9, -5, -2, -1,  0,  0,
   -3, -4, -5, -4,  0,  7, 12, 13, -3, -4, -5, -5, -2,  4,  9, 10,
   -2, -3, -4, -5, -4, -1,  3,  4, -1, -1, -2, -3, -3, -2,  0,  1,
    9,  5, -2, -8,-11,-10, -7, -4, 12, 10,  6,  2,  0, -1,  0,  0,
    2,  2,  3,  4,  3,  1,  1,  1, -9, -8, -4,  0,  1,  2,  1,  0,
    6,  8,  8,  5,  1, -5,-11,-13,  0,  1,  2,  2, -1, -4, -8,-11,
   -3, -2,  1,  3,  3,  1, -1, -4, -2, -1,  2,  5,  6,  6,  4,  1,
    3,  4,  5,  5,  4,  1, -3, -6,  5,  6,  4,  2,  2,  2,  0, -3,
    6,  5,  0, -5, -5, -2, -1, -2,  7,  4, -3,-11,-12, -7, -3, -2,
    1,  0, -1, -1, -1,  0,  0,  0,  2,  3,  4,  4,  5,  5,  4,  3,
   -7, -9, -9,-10,-10, -9, -7, -6,  3,  4,  5,  6,  5,  5,  5,  5,
   -7, -7, -7, -7, -6, -6, -5, -4, -5, -4, -3, -1, -1, -1,  0,  0,
   -3, -2,  1,  4,  5,  5,  5,  5, -2, -1,  3,  6,  9, 10, 10,  9,
  -14,  1, 10,  3, -2,  0,  1,  1,-16,  2, 13,  3, -3, -1,  1,  0,
  -15,  2, 12,  3, -4, -2,  1,  1,-10,  3, 10,  2, -3, -1,  1,  1,
    0,  1,  4,  2, -5,-10, -3, 11, -1,  1,  4,  2, -6,-13, -2, 15,
   -1,  0,  3,  1, -6,-12, -1, 15, -1,  1,  2,  1, -4, -8,  0, 11,
   10,  5, -2, -2,  2,  5,  1, -4,  7,  0, -8, -6,  1,  5,  2, -4,
    2, -5,-12, -7,  2,  7,  4, -1, -1, -7,-10, -4,  4,  9,  7,  2,
   -5, -5, -4, -6, -6, -5, -5, -3, -1, -2, -2, -4, -5, -6, -5, -4,
    6,  7,  7,  4,  0, -2, -3, -3, 13, 14, 13, 10,  5,  1, -1, -2,
    1,  1,  2,  2,  2,  2,  2,  2, -5, -6, -8, -9, -9, -8, -7, -6,
    7,  9, 10, 11, 11,  9,  7,  5, -1, -2, -3, -3, -4, -4, -4, -3,
   -1, -1,  0,  0,  0,  0, -1, -1, -3, -3, -4, -5, -4, -3, -3, -2,
    2,  1, -1, -3, -3, -2, -1,  0, 12, 12,  8,  3,  1,  0,  0,  1,
   -6, -8, -8, -6, -2,  2,  6,  8,  1,  1, -1, -2,  0,  3,  5,  7,
    3,  3,  1, -1, -1,  0,  0,  2,  0,  1,  0, -1, -1, -1, -2, -1,
    1,  0,  0,  0,  0,  0,  2,  4,  2,  1,  3,  4,  3,  1,  0,  2,
    2,  1,  0,  0, -1, -1,  0,  3,  5,  1, -6,-12,-13, -8, -1,  4,
   -2,  0, -1, -2, -1,  0,  2,  3, -6, -3, -2,  0,  1,  1,  1,  1,
   -9, -5,  0,  4,  5,  3,  1,  0, -8, -3,  3,  7,  8,  4,  1,  0,
    1,  2,  2,  3,  3,  1, -1, -3,  4,  5,  5,  6,  6,  5,  2,  0,
    0,  0,  0,  0,  1,  0, -2, -4, -3, -3, -4, -3, -3, -4, -7, -8,
   14, 12,  6, -1, -3, -3,  0,  0,  7,  5,  1, -3, -5, -4, -2, -1,
   -2, -2, -2, -2, -2, -2, -1, -1, -6, -4, -1,  1,  1,  1,  0, -1,
    2,  2,  1, -3, -6, -7, -6, -3,  1,  0, -1, -3, -2,  1,  4,  6,
    0,  0,  1,  2,  4,  7,  8,  7,  0,  0,  0,  0, -1, -4, -7, -8,
    0,  2,  1, -2, -3, -3, -2, -1, -1,  1,  0, -3, -5, -2,  0,  2,
   -2, -1, -2, -5, -4,  1,  6,  9, -3, -2, -3, -4, -2,  5, 11, 13,
   -4, -2,  2,  6,  4, -3,-10,-14, -2, -1,  1,  4,  4,  1, -1, -2,
    0,  0, -1, -2, -2,  0,  4,  6,  2,  2,  0, -3, -3,  0,  5,  9,
   -4, -4, -2,  1,  6,  9,  3, -7, -2, -2, -2, -1,  4,  8,  0,-11,
    1,  1,  0,  0,  2,  6, -1,-10,  2,  2,  1,  0,  2,  4,  0, -7,
   -1, -2, -3, -6, -7, -8, -8, -8,  2,  3,  3,  1, -1, -2, -3, -4,
    5,  5,  5,  4,  3,  2,  0, -1,  3,  3,  3,  3,  2,  2,  1,  1,
    3,  3,  2, -2, -3,  0,  7, 10,  1,  2,  2, -2, -5, -4,  0,  3,
    0,  3,  4,  2, -3, -5, -6, -4,  0,  2,  4,  4,  1, -4, -7, -7,
    2,  4,  5,  5,  5,  5,  6,  6, -4, -4, -3, -5, -5, -3, -3, -2,
   -3, -4, -4, -5, -4, -2, -2, -2,  1,  1,  0,  0,  2,  4,  5,  4,
   -2,  0,  3,  4,  4,  3,  2,  2, -9, -7, -4,  0,  3,  6,  6,  6,
   -5, -5, -3, -2,  0,  1,  3,  4,  5,  5,  2, -2, -4, -6, -5, -3,
    1, -6, -4,  7,  5, -2, -2,  1,  5, -5, -4,  6,  4, -5, -4,  1,
    5, -5, -4,  6,  4, -5, -3,  1,  1, -7, -3,  8,  7, -1, -3,  1,
   -8, -7, -4,  0,  2,  4,  5,  5,  5,  6,  5,  2, -1, -5, -7, -7,
    5,  6,  4,  1, -3, -5, -6, -5, -7, -7, -5, -2,  1,  6,  9, 10,
    6,  3,  0,  1,  3,  0, -8,-14,  3,  0, -1,  1,  4,  3,  0, -4,
    1,  0,  0,  1,  2,  1,  1,  1, -1, -1,  1,  2,  1, -1, -1,  0,
    1,  1,  1,  1,  0, -2, -3,  0,  1,  2,  1,  0, -2, -8, -9, -4,
    1,  3,  3,  2,  1, -3, -3,  1,  0,  1,  1,  1,  1,  1,  4,  8,
    2,  5,  9,  7,  2, -1, -1,  1, -4, -1,  1,  0, -3, -4, -1,  2,
   -3,  0,  3,  3,  0, -1,  0,  2, -4, -1,  1,  1, -2, -4, -5, -4,
    1, -1, -2, -2, -1,  2,  4,  5,  2,  1,  1,  0, -1, -1,  0,  0,
    2,  3,  4,  5,  4,  2,  1,  0, -9, -9, -6, -3, -1, -1, -1, -1,
   -6, -6,  4,  7,  0, -2, -1, -2, -1, -2,  5,  6, -1, -2,  0, -1,
    4, -1,  1,  0, -4, -2,  0, -2,  7,  1, -1, -2, -3,  1,  3,  1,
    4,  2,  1,  3,  3,  1,  1,  2,  2, -2, -4,  0,  3,  1,  0,  0,
    1, -4, -8, -4,  1,  2,  1,  0,  2, -3, -9, -6,  0,  3,  3,  2,
   -1, -1,  0, -1, -1,  0,  1,  2,  3,  1, -4, -8, -7, -3,  1,  2,
    2, -1, -3, -2, -1,  0,  1,  0, -1,  0,  5, 11,  9,  3, -1, -3,
   -1, -2, -2, -1,  1,  1,  1,  1,  0, -1,  0,  3,  6,  6,  5,  5,
    2,  1, -1, -1, -2, -5, -6, -4,  2,  2,  2,  1, -1, -4, -5, -5,
   -1, -3, -6, -7, -6, -4, -1,  1,  5,  5,  3,  4,  4,  3,  4,  5,
   -1, -2, -3, -2, -2, -2,  0,  1,  0,  0,  0,  0,  0,  1,  2,  3,
   -6, -6, -4, -1,  2,  2,  2,  2, -6, -7, -5, -2,  0, -1, -1,  0,
    2,  2,  2,  4,  4,  3,  3,  4,  2,  1,  0, -1,  0,  0,  2,  4,
   12,  5, -5, -8, -5,  0,  2,  2,  2, -3, -6, -3,  0,  0, -1, -2,
   -2, -3, -1,  3,  4,  1, -2, -3,  2,  2,  3,  4,  3,  1, -1, -1,
    3,  2,  1,  0,  1,  4,  3,  0,  4,  3,  0, -5, -6,  0,  3,  3,
    2,  3,  1, -7,-12, -6,  1,  3,  1,  3,  4, -1, -6, -4,  0,  1,
   -9, -4,  2,  6,  7,  4,  1,  0, -7, -1,  4,  6,  4,  0, -3, -3,
   -6,  0,  4,  4,  1, -2, -3, -2, -4,  1,  3,  2,  0, -2, -1,  0,
    0,  5,  2, -5, -3,  3,  1, -4, -2,  4,  2, -6, -3,  6,  4, -3,
   -1,  5,  3, -5, -1,  7,  3, -4, -1,  2,  0, -6, -3,  5,  3, -3,
   -8, -3,  3,  5,  3,  1, -2, -2,  2,  4,  4, -2, -4, -3,  1,  3,
    2,  1, -3, -5, -3,  3,  4,  3, -5, -6, -5,  3, 10,  8, -1, -5,
    0,  3,  2, -4, -9, -7,  0,  6, -5, -1,  5,  7,  4, -1, -3, -3,
   -5, -5, -2,  3,  6,  5, -1, -4,  9,  6,  0, -4, -2,  1,  1, -1,
   -1, -1, -1,  1,  1,  0, -1,  0, -1,  0,  0,  0,  0, -1, -1,  0,
    2,  1, -2, -1,  1,  1,  0,  0, 12,  8,  2, -1, -1, -4, -7, -7,
    2,  1,  3,  6,  7,  4,  2,  0,  1,  0, -1,  0, -1, -4, -7, -8,
    0,  0, -1,  0,  0,  0, -1, -3,  0,  0,  0,  0,  1,  1,  0, -2,
   -1,  0,  1,  1,  0,  0, -1, -2,  0,  0, -1, -3, -4, -3, -1,  1,
   -1,  0,  0,  0,  1,  4, 10, 12, -1,  0, -2, -2, -3, -3, -1,  1,
   -3, -1, -2, -4,  2,  9,  9,  7, -3,  0, -1, -3,  0,  2, -1,  1,
   -1,  1, -2, -3,  0, -1, -3,  0,  0,  0, -3, -2,  0, -1, -1,  1,
   -1, -2, -1, -1, -2, -1, -1, -2,  2, -1, -2, -1,  0,  1,  0, -2,
    3, -1, -2,  2,  5,  3, -1, -3,  1, -5, -5,  1,  6,  6,  2,  0,
    1,  2,  0, -1,  0,  1,  0, -2, -5, -3, -1,  0,  1,  2,  1, -2,
   -7, -5, -2, -2, -2, -2,  0,  1, -1,  0,  1,  1,  0,  3,  9, 12,
    0,  6,  5,  1, -2, -3,  0,  3,  0,  6,  5,  1,  1,  1,  2,  3,
   -5, -2, -2, -3,  0,  0,  0,  0, -6, -3, -3, -2,  0,  0, -1, -2,
    4,  4,  2,  1,  0, -1, -1,  0, -2, -2,  0,  1,  2,  1,  1,  0,
    2,  2,  1, -1, -3, -5, -9,-10,  2,  1, -1, -1,  1,  4,  4,  1,
    4,  0, -2, -2, -2, -2, -1,  0,  7,  1, -4, -3, -2,  0,  1,  1,
   10,  5, -1, -2,  0,  1,  1,  0,  5,  1, -3, -4, -3, -1, -1, -2,
    2,  1, -1, -3, -3,  1,  1, -1, -2, -1,  3,  0, -1,  1,  1,  0,
   -3,  1,  7,  2, -3, -2, -1,  0, -2,  4,  8, -1, -8, -5,  0,  2,
   -4, -1,  1,  2,  1, -3, -4, -2, -5, -3, -2,  1,  4,  4,  4,  6,
   -3, -2, -4, -3,  0,  1,  1,  2,  2,  2,  2,  1,  2,  1, -1, -1,
   -4, -1,  0, -1, -3, -3, -1, -1,  1,  4,  4,  2,  0, -1, -2, -3,
    4,  6,  5,  3,  2,  1, -2, -4,  0,  1,  1,  1,  1, -1, -4, -6,
    1,  2,  2, -1, -6, -5, -1,  2, -3, -2,  1,  1, -4, -3,  2,  5,
   -2, -1,  2,  2, -3, -4,  0,  3, -2, -2,  2,  6,  5,  2,  1,  2,
    2, -3, -3,  0,  0,  2,  3,  1,  3, -1,  1,  3,  1,  2, -1, -5,
   -5, -7, -4, -2,  1,  8,  8,  1, -1,  0,  2,  0, -3,  0,  1, -3,
   -2, -5, -5, -2, -3, -1,  0, -2, -1, -4,  0,  4,  0,  2,  4,  0,
    0,  0,  8, 10,  2,  1,  3, -1, -4, -3,  2,  3, -3, -3,  1, -1,
    1, -2, -4,  2,  7,  3, -2, -1,  6,  4, -2, -1,  2,  0, -1,  3,
    1,  1, -2, -2, -2, -5, -3,  4, -6, -2,  1,  1, -1, -4, -2,  4,
   -2, -1, -2, -2,  0,  1,  0, -2, -1,  1,  0, -1,  0,  0, -1, -3,
    0,  1, -2, -4, -3, -1,  0,  0,  6,  8,  5,  0,  0,  1,  2,  3,
   -2, -2,  2,  5,  2,  0,  0,  1,  2, -2, -2, -1, -1,  1,  2,  4,
    2, -1,  0,  1,  0,  0,  0,  1, -8, -7, -1,  1, -1, -1,  1,  3,
    0,  3,  6,  2, -2,  1,  2,  0,-10, -7, -1,  0, -3, -1,  2,  1,
    0,  0,  2,  2,  1,  1,  1, -1,  3,  0, -2, -2,  0,  2,  1,  0,
    8,  1,  0,  0, -2, -3, -1,  0,  2, -2,  2,  5,  1, -2, -1,  1,
   -3, -6, -3, -1, -3, -3, -1,  2,  2,  0,  1,  2,  2,  1,  0,  0,
    1, -1, -1, -2, -1,  0,  1,  0, 15,  9,  2, -1, -2, -3, -3, -3,
    0, -3, -2,  0,  0, -1, -1, -1,  1,  0,  1,  0,  0, -1, -1, -1,
    0,  2,  2, -2, -3, -3, -7, -8,  0,  2,  2,  0,  1,  2,  1,  1,
    1,  2,  2,  2,  3,  1,  0,  3,  1,  0, -1, -2, -1, -2,  0,  5,
  -11, -6, -1,  1,  2,  3,  1, -3,  1,  4,  3, -1, -2,  1,  2, -1,
    2,  2,  1, -1, -2,  0,  1, -1,  0,  0, -1, -1,  0,  2,  3,  2,
    1,  1,  2,  1, -1,  1,  0, -4,  0,  0,  0, -2, -2,  2,  4, -2,
   -2, -3,  0,  0, -1,  2,  1, -6,  0,  2,  5,  5,  3,  2, -1, -7,
    4,  2,  0,  0,  3,  3,  1, -1,  0, -1, -1,  3,  6,  4,  1, -1,
   -2, -2,  0,  2,  2,  0, -2, -2, -1,  0, -1, -5, -7, -5, -1,  1,
    5, -1, -2,  0,  2,  4,  2, -5,  0, -5, -2,  2,  1,  2,  0, -6,
    6,  1,  0,  1, -2, -1,  4,  2,  2, -3, -3,  0, -1, -2,  0,  0,
    1, -1,  0,  2,  0,  0,  6, 11,  2, -1, -1,  0, -3, -2,  3,  5,
    0, -2, -1,  0, -1,  0,  0, -3,  1, -1, -1, -1, -2, -1, -3, -7,
    1,  1, -2, -2,  1,  3,  1, -2, -1,  2,  0, -1, -1,  1,  0,  0,
   -4,  2,  3, -1, -2, -2,  0,  1,-11, -2,  4,  5,  6,  2, -1, -2,
   -6, -2,  1, -1, -3, -4,  1,  9, -3,  0,  3,  3,  2, -3, -3,  3,
    1,  1,  0,  0,  1, -1, -2,  3,  2,  0, -3, -3,  0, -1, -1,  3,
    1, -1, -3,  1,  2, -6, -4,  6,  0, -2, -5, -2,  0, -3, -2,  3,
    2,  2,  1, -2, -2,  1,  2, -1, -1,  1,  1, -2, -1,  6,  7, -1,
    1,  0, -4, -2,  1, -2, -3,  1, -4,  0, -3, -2,  2,  0, -3,  0,
   -3,  4,  3,  1,  8,  7,  0, -1, -3,  4,  1, -4,  2,  3, -2, -3,
   -3,  6,  1, -4,  1,  1, -1, -1, -2,  4, -3, -3,  3,  0, -1, -1,
    1,  2, -4,  2,  4, -3, -1,  2,  3, -1, -4,  5,  4, -6, -3,  2
};

/* 6x16-entry codebook for inter-coded 8x8 vectors */
static int8_t inter_codebook_8x8[6144] = {
   -4, -3,  4,  5,  2,  1,  1,  0, -5, -3,  5,  5,  2,  1,  0,  0,
   -6, -4,  5,  5,  2,  1,  0,  0, -7, -4,  4,  5,  2,  1,  0,  0,
   -8, -5,  3,  4,  2,  1,  0,  0, -8, -6,  3,  4,  1,  1,  1,  0,
   -8, -6,  2,  4,  2,  1,  1,  0, -8, -6,  2,  4,  1,  1,  1,  1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2,
   -2, -3, -3, -3, -3, -3, -3, -3, -2, -3, -3, -3, -3, -3, -4, -3,
   -2, -2, -2, -2, -2, -3, -3, -2,  1,  1,  1,  1,  1,  0, -1, -1,
    4,  5,  5,  5,  4,  3,  3,  2,  7,  7,  8,  8,  8,  7,  6,  5,
    2,  1,  2,  4,  4,  0, -4, -6,  1,  1,  2,  5,  5,  1, -5, -7,
    1,  2,  1,  4,  5,  1, -5, -8,  1,  1,  1,  5,  5,  0, -6, -8,
    0,  1,  1,  5,  6,  1, -6, -9,  0,  0,  1,  4,  5,  0, -5, -8,
    0,  0,  1,  4,  5,  0, -5, -7,  0,  0,  1,  4,  4,  1, -4, -7,
    1,  2,  3,  0, -3, -4, -3, -1,  1,  3,  4,  0, -3, -4, -3, -1,
    2,  4,  5,  1, -3, -4, -3, -2,  2,  5,  6,  1, -3, -5, -4, -2,
    3,  6,  6,  1, -3, -5, -4, -2,  3,  6,  6,  1, -3, -5, -4, -2,
    3,  6,  6,  1, -3, -5, -4, -2,  3,  5,  5,  1, -3, -4, -4, -2,
    2,  2,  2,  2,  1,  0,  0, -1,  4,  4,  4,  3,  2,  1,  1,  0,
    4,  5,  4,  4,  3,  3,  2,  1,  4,  4,  4,  4,  4,  3,  2,  2,
    2,  3,  3,  3,  3,  3,  2,  1, -1, -1, -1, -1,  0,  0,  0,  0,
   -5, -6, -6, -5, -5, -4, -3, -3, -7, -9, -9, -8, -7, -6, -6, -5,
    6,  6,  6,  6,  6,  5,  5,  4,  4,  4,  4,  3,  3,  3,  3,  2,
    0, -1, -1, -1, -2, -2, -1, -1, -3, -5, -6, -6, -6, -6, -5, -4,
   -3, -5, -6, -7, -6, -6, -5, -4, -1, -2, -2, -2, -2, -2, -1, -1,
    0,  1,  1,  1,  1,  1,  1,  1,  3,  3,  3,  3,  3,  3,  3,  3,
    2,  1, -2, -5, -4,  0,  2,  5,  2,  1, -2, -6, -5,  0,  3,  5,
    2,  1, -2, -6, -6, -1,  3,  6,  3,  2, -2, -7, -6,  0,  4,  7,
    2,  1, -2, -7, -5,  0,  5,  7,  2,  1, -2, -6, -5,  0,  4,  7,
    2,  1, -2, -6, -4,  0,  4,  6,  1,  1, -2, -5, -4,  0,  3,  6,
  -10, -9, -6, -4, -1,  2,  3,  2,-10, -9, -5, -3,  0,  4,  4,  3,
   -9, -7, -3, -1,  2,  5,  5,  3, -7, -5, -2,  0,  3,  5,  5,  3,
   -6, -3,  0,  1,  4,  6,  5,  3, -4, -2,  1,  2,  3,  5,  4,  2,
   -2,  0,  1,  2,  2,  4,  3,  1, -1,  1,  2,  2,  2,  3,  3,  1,
   -4, -5, -5, -6, -6, -6, -6, -5, -3, -3, -4, -4, -4, -4, -4, -4,
    0,  0,  0,  0, -1, -1, -1, -1,  5,  5,  6,  5,  5,  4,  3,  2,
    5,  6,  7,  7,  7,  6,  5,  4,  3,  3,  4,  4,  4,  4,  3,  2,
    0, -1,  0,  0, -1, -1,  0, -1, -3, -3, -4, -4, -4, -4, -3, -3,
    1, -2, -5,  1,  5,  4,  2,  0,  1, -3, -6,  1,  6,  5,  2,  0,
    0, -4, -7,  0,  6,  6,  2,  1, -1, -5, -9, -1,  6,  6,  3,  1,
   -1, -6,-10, -2,  6,  6,  3,  1, -1, -6, -9, -2,  5,  6,  3,  1,
   -2, -6, -9, -2,  5,  5,  3,  1, -2, -6, -7, -2,  4,  4,  2,  1,
   -5, -7, -8, -9, -9, -8, -7, -6, -5, -6, -6, -7, -7, -6, -6, -5,
   -3, -3, -3, -4, -5, -5, -4, -4, -1,  0,  0, -1, -1, -1, -1, -1,
    0,  1,  2,  2,  2,  2,  2,  1,  2,  3,  4,  5,  5,  5,  5,  4,
    3,  4,  5,  6,  8,  8,  8,  7,  3,  4,  5,  6,  7,  7,  7,  6,
    5,  6,  7,  8,  9, 10, 10,  9,  3,  4,  6,  7,  8,  9,  9,  8,
    0,  1,  2,  3,  4,  5,  5,  5, -1, -2, -1, -1,  0,  1,  2,  2,
   -2, -3, -3, -3, -3, -2, -1,  0, -3, -4, -5, -5, -5, -5, -5, -4,
   -4, -5, -5, -6, -7, -7, -6, -5, -3, -4, -5, -6, -7, -7, -6, -6,
   13,  7,  0, -3, -3, -4, -4, -5, 14,  7,  0, -3, -3, -4, -4, -4,
   15,  8, -1, -4, -4, -4, -5, -4, 15,  8, -1, -4, -4, -5, -4, -3,
   15,  7, -1, -4, -5, -5, -5, -4, 14,  7, -1, -4, -4, -4, -4, -3,
   12,  6, -1, -4, -4, -4, -4, -3, 11,  5, -1, -4, -4, -4, -4, -3,
  -17, -4,  5,  4,  4,  4,  3,  3,-18, -5,  5,  4,  4,  4,  3,  3,
  -19, -5,  6,  4,  4,  4,  3,  2,-20, -5,  6,  4,  4,  4,  3,  3,
  -20, -4,  6,  4,  4,  5,  3,  3,-19, -5,  6,  4,  4,  5,  3,  3,
  -18, -4,  5,  4,  4,  4,  3,  2,-17, -5,  4,  3,  4,  4,  3,  3,
   -6, -6, -6, -4, -2,  1,  6, 11, -6, -7, -7, -4, -2,  2,  8, 13,
   -8, -8, -7, -4, -2,  3,  9, 14, -8, -8, -7, -5, -1,  4, 10, 16,
   -8, -8, -7, -5, -1,  4, 10, 17, -8, -8, -7, -4,  0,  5, 10, 16,
   -8, -8, -6, -3,  0,  4,  9, 15, -7, -7, -5, -3,  0,  4,  8, 12,
    8,  7,  7,  5,  2, -2, -8,-14,  8,  8,  7,  5,  2, -2, -8,-15,
    8,  8,  7,  5,  1, -3, -9,-16,  8,  8,  7,  5,  1, -3,-10,-17,
    8,  9,  8,  5,  1, -3,-10,-17,  8,  8,  7,  4,  1, -4,-10,-16,
    7,  7,  7,  4,  1, -3, -9,-14,  6,  7,  6,  3,  0, -3, -9,-13,
    5,  1, -4, -4, -3, -1,  0,  0,  7,  2, -3, -3, -2, -1,  1,  0,
    7,  1, -3, -3, -1,  0,  1,  1,  6,  1, -3, -2, -1,  1,  1,  0,
    6,  0, -4, -2, -1,  0,  1,  0,  5,  0, -4, -3, -1,  0,  0, -1,
    5,  0, -3, -1,  0,  0,  0, -2,  4,  1, -2, -1,  0,  1,  0, -1,
    2,  2,  1,  1, -2, -6, -8, -8,  1,  1,  1,  1, -2, -5, -8, -8,
    1,  1,  1,  0, -1, -3, -5, -5,  0,  0,  0,  0, -1, -1, -1, -2,
    0, -1,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  1,  2,  3,  2,
    2,  1,  1,  1,  2,  3,  4,  3,  3,  3,  3,  3,  4,  4,  5,  4,
   -4, -4, -3, -2,  0,  0,  1,  1, -4, -4, -3, -2, -1,  0,  0,  1,
   -2, -2, -2, -1, -1, -1,  0,  0,  0,  1,  0,  0,  0,  0,  0, -1,
    2,  2,  2,  2,  2,  2,  1,  1,  3,  4,  4,  4,  4,  4,  4,  3,
    1,  1,  1,  3,  3,  4,  3,  3, -5, -6, -5, -4, -3, -3, -2, -2,
   -4, -2, -1, -1, -1, -1,  0,  1, -4, -2, -1, -1, -1, -1,  0,  1,
   -3, -2, -1, -1, -1,  0,  1,  2, -4, -3, -2, -1, -1,  1,  3,  3,
   -4, -3, -3, -1, -1,  1,  4,  5, -4, -3, -2, -2, -1,  1,  4,  7,
   -2, -2, -1, -1,  0,  2,  6,  8, -1,  0,  0,  1,  1,  4,  7,  8,
   -3, -3, -3, -2, -2, -1, -1,  0, -1, -1,  0,  1,  2,  2,  3,  3,
    0,  1,  2,  4,  5,  6,  6,  5, -1,  0,  2,  3,  5,  6,  5,  3,
   -1, -1,  0,  2,  3,  3,  2,  1, -2, -2, -1,  0, -1, -3, -4, -4,
    0,  0, -1, -1, -2, -4, -8, -7,  1,  2,  1,  0, -1, -4, -6, -7,
   -2,  4,  1, -6,  0,  3,  0,  0, -2,  5,  1, -7,  0,  3,  0,  0,
   -3,  5,  1, -8,  0,  3, -1, -1, -2,  6,  1, -9,  0,  3,  0, -1,
   -2,  6,  2, -8,  0,  4,  0, -1, -3,  5,  1, -7,  1,  4,  0,  0,
   -2,  4,  1, -7,  0,  4,  1,  0, -1,  4,  1, -6,  0,  3,  1,  0,
    0,  0,  0,  3,  4,  5,  4,  1,  1,  1,  1,  2,  3,  3,  2,  0,
    2,  2,  1,  2,  2,  1, -1, -2,  4,  3,  1,  1,  0, -1, -3, -5,
    5,  3,  1, -1, -2, -3, -4, -6,  5,  3,  0, -2, -3, -5, -6, -7,
    4,  3,  0, -2, -3, -4, -5, -5,  4,  3,  0, -1, -2, -2, -3, -3,
    0,  0,  0,  0, -1, -5, -2,  6,  0,  0,  0,  1, -1, -6, -2,  8,
    0,  0,  0,  2,  0, -6, -3,  9,  0, -1,  0,  2,  0, -7, -2, 10,
    0, -1,  0,  2, -1, -8, -3, 10,  0, -1, -1,  2, -1, -7, -3,  9,
    0, -1,  0,  1, -1, -6, -3,  8,  0,  0,  0,  1,  0, -5, -2,  7,
    2,  3,  3,  2,  1,  0, -1, -1,  3,  4,  3,  2,  1,  0, -1, -2,
    3,  4,  4,  2,  1, -1, -2, -3,  2,  3,  3,  2,  0, -1, -2, -3,
   -1,  0,  1,  1,  0, -1, -2, -2, -5, -4, -3, -1,  0,  1,  1,  1,
   -8, -8, -5, -1,  1,  3,  4,  3,-10, -9, -5,  0,  3,  5,  6,  5,
   -5, -1,  4,  5,  3,  1,  0,  0, -6, -1,  4,  5,  2,  0, -1, -2,
   -6, -1,  5,  4,  2, -1, -2, -2, -7, -1,  4,  4,  1, -2, -3, -3,
   -6, -1,  5,  4,  1, -2, -3, -3, -5,  0,  4,  4,  1, -1, -2, -2,
   -4,  0,  5,  4,  1, -1, -1, -2, -3,  1,  4,  3,  1, -1, -1, -2,
   -2, -3, -2,  1,  4,  6,  5,  3, -3, -4, -4,  0,  3,  5,  4,  2,
   -3, -5, -5, -1,  2,  4,  3,  1, -4, -6, -4, -1,  2,  4,  2, -1,
   -2, -4, -3,  1,  2,  4,  2, -1, -2, -4, -2,  1,  3,  3,  1, -2,
   -2, -3, -2,  1,  3,  3,  1, -2, -2, -2, -1,  1,  3,  3,  0, -2,
   -4, -4, -3, -2, -1,  2,  5,  7, -4, -4, -3, -3, -2,  1,  5,  7,
   -2, -3, -2, -3, -3, -1,  3,  5, -1, -1,  0, -2, -3, -2,  2,  4,
    1,  1,  1, -1, -4, -3,  1,  3,  4,  3,  2, -1, -4, -3, -1,  1,
    6,  4,  3,  0, -3, -3, -2,  0,  6,  5,  3,  1, -2, -3, -2, -1,
   12, 11,  8,  4,  0, -2, -2, -1, 10,  9,  6,  2, -1, -2, -1,  0,
    4,  3,  2,  0, -1, -1,  0,  1, -1, -1, -1, -1, -2,  0,  1,  2,
   -3, -5, -4, -2, -2,  0,  2,  3, -5, -5, -4, -2, -1,  0,  1,  2,
   -5, -5, -4, -2, -1,  0,  1,  1, -4, -4, -3, -2, -2, -1,  0,  0,
    3,  3,  2, -1, -3, -4, -3, -2,  3,  2,  0, -2, -4, -4, -3, -2,
    2,  2,  1, -1, -3, -5, -4, -3,  3,  3,  3,  1, -2, -3, -3, -3,
    4,  4,  4,  3,  0, -2, -2, -2,  5,  5,  5,  3,  0, -1, -2, -2,
    5,  5,  4,  2, -1, -2, -3, -2,  3,  3,  3,  0, -2, -4, -4, -4,
   -1, -1,  4, -2, -2,  6,  2, -5, -1,  0,  4, -2, -3,  6,  2, -6,
   -1,  0,  4, -2, -3,  7,  3, -7, -1, -1,  4, -3, -4,  8,  3, -7,
    0, -1,  4, -3, -4,  7,  3, -6, -1, -1,  4, -3, -4,  7,  3, -6,
   -1, -1,  3, -3, -4,  6,  3, -6, -1,  0,  3, -2, -3,  6,  3, -5,
    1, -2, -7,  2,  5, -2, -1,  1,  1, -2, -8,  3,  6, -3, -1,  2,
    2, -2, -9,  4,  7, -4, -2,  2,  3, -1, -9,  5,  7, -4, -1,  3,
    3, -1, -9,  4,  7, -4, -2,  2,  3, -1, -7,  4,  6, -4, -2,  1,
    2,  0, -6,  4,  6, -4, -1,  1,  2,  0, -5,  3,  4, -3, -1,  1,
   -2,  2,  2,  0,  0, -1, -3, -4, -2,  2,  2,  1,  1,  0, -2, -4,
   -2,  2,  2,  2,  2,  1, -1, -2, -3,  2,  3,  3,  4,  2,  0, -2,
   -3,  2,  3,  2,  4,  2,  0, -3, -4,  1,  2,  1,  2,  1, -1, -3,
   -5,  0,  1,  0,  1,  1, -2, -3, -4,  0,  0,  0,  1,  0, -2, -3,
    0,  0, -1, -2, -2,  2,  7,  8,  0,  0, -1, -3, -2,  1,  6,  7,
    0,  1, -1, -3, -3,  0,  4,  5,  0,  1,  0, -1, -1,  0,  1,  3,
    0,  2,  1,  1,  0, -1,  0,  1, -2,  0,  1,  2,  1,  0, -1, -1,
   -5, -2,  0,  1,  1,  0, -3, -3, -6, -4, -1,  1,  1, -1, -3, -4,
   -4, -2,  2,  5,  6,  4,  3,  2, -5, -3,  1,  4,  4,  2,  0,  0,
   -4, -2,  0,  2,  1, -1, -2, -2, -2, -1,  0,  1,  0, -2, -3, -2,
   -2,  0,  0,  0, -1, -1, -2, -1, -2, -1, -1,  0,  0,  0,  1,  2,
   -2, -2, -1, -1,  0,  1,  3,  4, -2, -3, -2, -1,  0,  2,  4,  5,
    2,  1, -2, -2, -1,  0,  1,  0,  1,  0, -3, -3, -1,  0,  1,  0,
    0, -1, -3, -3, -1,  1,  1,  1,  0,  0, -3, -1,  1,  2,  3,  3,
    0, -1, -3, -1,  1,  3,  3,  3, -2, -2, -4, -2,  1,  3,  4,  4,
   -3, -3, -4, -2,  1,  3,  3,  4, -2, -3, -5, -2,  1,  2,  3,  3,
    4,  5,  3,  4,  4,  4,  4,  5,  3,  3,  1,  0,  0,  0,  0,  1,
    1,  1, -1, -2, -3, -4, -3, -2,  2,  2,  0, -2, -2, -4, -3, -2,
    2,  3,  1, -1, -1, -3, -3, -2,  1,  2,  0,  0, -1, -2, -2, -1,
    0,  1,  0, -1, -1, -3, -2, -1,  1,  1,  0, -1, -1, -2, -2, -2,
   -2, -1, -1,  0,  1,  2,  1,  0,  1,  2,  3,  5,  6,  5,  5,  3,
    1,  2,  3,  4,  5,  5,  4,  3, -2, -2, -3, -3, -2, -1,  0,  0,
   -3, -3, -4, -5, -4, -3, -2, -1, -1, -1, -2, -2, -2, -1,  0,  0,
    0,  1,  0, -1, -1,  0,  0,  1, -1,  0, -1, -2, -3, -2, -2, -1,
    7,  7,  6,  5,  4,  2, -1, -2,  3,  3,  2,  2,  1,  0, -2, -3,
    0, -1, -1, -1,  0, -1, -2, -2, -1, -3, -2, -1,  0,  0,  0,  1,
    0, -2, -2, -1, -1,  1,  2,  2,  3,  1, -1, -1, -1,  1,  2,  2,
    3,  1, -2, -3, -2, -1,  1,  2,  1, -2, -5, -6, -5, -3, -2,  0,
    0, -1, -2, -3, -1,  0, -2, -2,  0,  0, -1, -1,  0,  1, -1, -2,
    0,  0, -2, -1,  0,  0,  0, -2, -1, -2, -3, -3, -2, -1, -3, -3,
   -1, -2, -3, -3, -2, -2, -3, -4,  2,  2,  0,  0,  0,  0, -1, -2,
    5,  5,  3,  2,  2,  2,  0, -1,  8,  8,  6,  5,  4,  4,  2,  1,
   -7, -8, -6, -3, -1, -1, -2, -1, -5, -5, -3,  0,  2,  1,  0,  0,
   -1, -1,  0,  3,  4,  3,  1,  1,  2,  1,  1,  3,  4,  3,  2,  2,
    3,  2,  0,  2,  3,  2,  1,  2,  4,  2, -1, -1,  0,  1,  1,  1,
    3,  2, -2, -3, -2, -1,  0,  1,  3,  1, -3, -4, -3, -2,  0,  1,
   -4, -2, -1,  2,  3,  3,  1,  0, -7, -5, -4, -2,  0,  0, -1, -2,
   -6, -5, -5, -4, -2, -2, -2, -3, -1,  0, -1, -1,  0,  0,  0, -1,
    2,  3,  2,  2,  2,  2,  1,  0,  3,  5,  4,  3,  1,  0,  1,  0,
    3,  4,  3,  2,  0, -1, -1, -1,  5,  5,  3,  1,  0, -1, -1, -1,
    1,  1,  0, -1, -3, -5, -6, -4,  1,  1,  0,  0,  0, -3, -3, -1,
    0, -1, -1,  0,  1,  0,  1,  3, -2, -2, -3, -1,  2,  2,  4,  7,
   -2, -2, -2,  0,  2,  2,  3,  6, -1,  0,  0,  1,  1,  0,  0,  3,
    0,  3,  3,  3,  1, -2, -3, -1,  1,  3,  4,  3,  0, -3, -5, -4,
    0,  2,  0, -1, -3, -4, -2, -2,  1,  4,  2,  0, -2, -3, -2, -1,
    3,  6,  3,  1, -2, -2,  0, -1,  4,  7,  4,  1, -2, -3, -1,  0,
    3,  6,  3,  0, -3, -3, -1,  0,  1,  3,  0, -1, -3, -2,  1,  1,
    0,  1, -1, -2, -3, -1,  2,  2, -2, -1, -3, -3, -3, -1,  1,  2,
    3,  1, -1,  0,  1,  0,  0,  0,  2, -1, -2, -1,  1,  0, -1, -1,
    1, -1, -2,  0,  1,  0, -2, -3,  0, -2, -1,  1,  3,  1, -3, -5,
    0, -2, -1,  2,  5,  2, -3, -5,  0, -2, -1,  4,  6,  3, -2, -5,
    0, -2,  0,  4,  7,  4, -2, -4,  0, -2,  0,  4,  6,  4, -2, -4,
   -2, -2, -3, -4, -3, -2, -1,  0,  1,  1,  0, -1, -1, -1,  0,  1,
    3,  3,  2,  2,  1,  1,  1,  1,  2,  2,  2,  2,  1,  0,  0,  1,
    0,  0,  0,  0, -1, -1, -1, -1, -4, -4, -4, -4, -4, -4, -4, -3,
   -3, -3, -2, -3, -2, -1, -1,  0,  3,  4,  4,  5,  5,  6,  6,  7,
   -1, -2,  7, -2, -4, -1, -1,  0, -1, -2,  9, -1, -4, -1, -1,  0,
   -1, -3, 10, -1, -4, -1, -1,  1, -1, -3, 10, -2, -3, -1, -1,  2,
   -1, -2, 10, -2, -4, -1, -1,  2, -1, -2,  9, -2, -4, -1, -1,  2,
   -1, -2,  8, -2, -4,  0, -1,  1,  0, -2,  7, -2, -3, -1,  0,  2,
    3, -4,  1,  3, -3, -2,  1,  0,  3, -5,  1,  4, -3, -2,  1,  0,
    3, -6,  2,  5, -3, -1,  3,  0,  3, -6,  2,  5, -3, -1,  2,  0,
    3, -6,  1,  5, -4, -2,  3,  0,  3, -6,  1,  5, -3, -2,  2,  0,
    2, -6,  1,  4, -3, -1,  1,  0,  2, -6,  1,  4, -2, -1,  1,  0,
    0,  0,  1,  1,  1,  0,  0,  2,  0, -1,  1,  1,  1,  0,  0,  2,
    0, -1,  0,  0,  0,  0,  0,  2,  0, -1,  0,  0,  0,  0, -1,  0,
    1,  0,  1,  0,  0, -1, -2, -1,  3,  1,  1,  0,  0, -2, -4, -3,
    5,  3,  2,  1,  0, -3, -5, -4,  5,  4,  2,  0, -1, -4, -5, -5,
    1,  0, -1, -2, -2, -3, -6, -9,  2,  0, -1, -1,  0,  0, -3, -6,
    1,  0,  0, -1,  0,  0, -2, -5,  2,  1,  1,  1,  1,  2, -1, -3,
    1,  1,  2,  1,  2,  2,  1, -1,  1,  1,  2,  1,  1,  1,  1,  1,
    0,  0,  2,  1,  0,  0,  2,  2,  0,  1,  2,  2,  0,  0,  2,  2,
   -4, -3,  0,  1,  4,  6,  4,  3, -3, -2,  0,  0,  2,  4,  1,  0,
   -1, -1,  0,  0,  1,  1, -2, -3,  1,  1,  1,  0,  1,  1, -3, -5,
    1,  1,  1,  0,  1,  1, -3, -5, -1,  0,  0, -1,  1,  1, -2, -4,
   -1,  0,  0, -1,  1,  2,  0, -2, -1,  0,  0,  0,  2,  3,  1,  0,
   -1,  0,  3,  4,  0, -4, -5, -5,  0,  0,  4,  5,  2, -2, -3, -2,
    0, -1,  2,  4,  2, -1, -1,  0,  0, -2, -1,  1,  0, -2,  0,  1,
    1, -2, -2,  0,  0, -1, -1,  1,  1, -2, -3,  0,  1,  0, -1,  0,
    1, -2, -2,  1,  3,  1,  0,  0,  1, -2, -1,  2,  4,  2,  0,  0,
    1,  2,  3,  2,  0,  2,  2,  1, -1,  0,  1,  0, -3,  1,  1,  1,
   -1,  0,  0, -2, -4,  0,  2,  1, -1,  2,  2, -1, -5,  0,  2,  1,
   -1,  3,  4, -1, -5,  0,  2,  1, -2,  2,  4,  0, -4, -1,  0,  0,
   -4,  0,  2,  0, -4, -2,  0,  0, -5, -1,  2,  1, -2,  1,  3,  2,
    1,  0,  1,  0,  1,  2, -1, -2,  2,  0, -1, -2,  1,  3,  0, -1,
    3,  0, -2, -4,  0,  3,  1,  0,  5,  1, -3, -5, -2,  2,  1,  1,
    6,  1, -2, -5, -2,  1,  0,  1,  5,  1, -1, -5, -2,  0, -1,  0,
    3,  0, -2, -4, -2,  0, -1,  0,  1, -1,  0, -2,  0,  1,  0,  1,
    1,  1,  2,  3,  2,  1,  1,  2, -1, -1,  0,  1,  1,  0,  1,  1,
   -4, -3,  0,  0,  1,  1,  1,  2, -4, -3,  0,  2,  2,  2,  3,  2,
   -5, -4,  0,  1,  1,  1,  1,  2, -5, -4, -1, -1, -2, -2, -1,  0,
   -3, -2,  0,  0, -2, -3, -2, -1,  2,  3,  4,  4,  2,  0,  0,  0,
   -4, -2,  0,  1,  0,  0,  0,  0, -3, -1,  1,  1,  0,  0,  0,  0,
   -2,  0,  2,  2,  0,  0,  0,  2, -1,  1,  2,  1, -1,  0,  3,  5,
    0,  2,  1, -1, -2,  0,  5,  6,  0,  1,  0, -3, -3,  0,  4,  6,
    1,  1, -2, -4, -4, -3,  1,  2,  1,  0, -2, -4, -5, -4, -2,  0,
   -1, -3, -3, -3, -3, -2, -1, -1,  3,  2,  1,  0,  0,  1,  1,  1,
    5,  4,  3,  2,  1,  1,  2,  2,  2,  1,  0, -2, -2, -2, -1, -1,
    0,  0,  0, -1, -2, -2, -2, -2,  0,  1,  3,  3,  2,  1, -1, -1,
    0,  1,  3,  4,  3,  2,  1, -1, -4, -3, -1,  1,  0, -2, -3, -3,
   -3, -4, -7, -8, -7, -4, -1,  2,  0, -1, -3, -4, -4, -2,  0,  2,
    1,  0,  0, -1, -3, -2,  0,  2,  2,  1,  1,  0, -1, -1,  0,  2,
    1,  1,  1,  1,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    0,  0,  1,  2,  3,  3,  2,  2,  0,  0,  1,  3,  4,  4,  3,  2,
    3,  3,  3,  0, -1,  0,  1,  2,  1,  1,  1, -1, -2, -1, -1,  1,
   -2, -2, -1, -3, -3, -2, -2,  0, -4, -4, -2, -2, -2, -2, -3,  0,
   -4, -4, -1,  1,  1,  0, -1,  2, -3, -1,  2,  3,  4,  3,  3,  5,
   -2,  0,  2,  3,  3,  3,  3,  3, -2, -2,  0,  0,  0,  0,  0,  1,
    0,  2,  1, -1, -3, -1,  3, -2, -1,  0, -1, -1, -3,  0,  4, -2,
   -2, -2, -2, -2, -2,  1,  5, -2, -3, -2, -3, -1, -2,  1,  4, -3,
   -2,  0, -1,  0, -1,  0,  3, -5,  1,  2,  1,  2,  0,  0,  2, -5,
    2,  4,  2,  3,  1,  1,  3, -3,  1,  2,  1,  1,  0,  1,  4, -2,
    4, -3, -4, -1,  3,  3,  1,  3,  4, -4, -4, -1,  3,  2,  0,  2,
    4, -3, -4,  0,  2,  2, -1,  1,  4, -3, -2,  1,  2,  1, -2,  0,
    2, -4, -2,  1,  2,  0, -3,  0,  2, -3, -2,  0,  1,  0, -2,  2,
    3, -1, -1,  0,  0,  0,  0,  3,  2, -2, -2, -2, -1, -1, -1,  2,
    2,  2,  3,  4,  3,  1,  0, -1,  1,  0,  1,  2,  1, -1, -2, -2,
    2,  1,  2,  1,  1,  0, -1, -1,  4,  3,  4,  3,  2,  1,  1,  1,
    3,  2,  2,  2,  1,  1,  1,  1, -1, -2, -1,  0, -1, -1, -1, -1,
   -3, -3, -2, -1, -2, -2, -2, -2, -4, -4, -3, -3, -4, -4, -3, -3,
    2,  1, -1, -3, -4, -2,  3,  4,  2,  2,  1, -1, -3, -2,  1,  2,
    1,  2,  3,  3,  0, -2, -1, -2, -1,  0,  2,  4,  2,  0, -1, -3,
   -2, -2,  0,  3,  3,  2,  0, -3,  0, -2, -3, -1,  1,  2,  2, -1,
    3, -1, -4, -5, -3,  0,  2,  0,  6,  3, -2, -6, -5,  0,  3,  1,
   -2,  3, -2,  0,  3, -2, -2,  1, -3,  4, -3,  0,  3, -2, -1,  2,
   -3,  5, -3,  0,  4, -2, -1,  2, -2,  4, -4, -1,  3, -3, -2,  2,
   -3,  4, -3,  0,  3, -3, -1,  2, -2,  5, -2,  0,  3, -3, -1,  2,
   -2,  4, -3,  1,  3, -2, -1,  2, -2,  3, -2,  1,  3, -2,  0,  2,
    1,  0,  0, -1,  1,  2, -4, -1,  2,  0,  0, -1,  1,  2, -4, -2,
    1,  1,  1, -1,  2,  4, -2,  0,  0, -1,  1, -1,  2,  5, -1,  1,
    0, -1,  0, -2,  1,  5, -1,  1,  0, -1, -1, -2,  0,  3, -3, -1,
    1,  1,  0, -2,  0,  3, -3, -1,  1,  1,  0, -3,  0,  3, -2,  0,
    1,  0, -1,  1,  1,  2,  4,  5,  1,  0, -1,  1,  1,  1,  5,  7,
    0,  0, -2, -1, -1,  0,  3,  5,  0, -1, -2, -1, -1, -1,  2,  3,
    0, -1, -3, -1, -1, -1,  1,  2, -1, -2, -4, -2, -2, -2,  0,  0,
   -1, -2, -2, -1, -2, -2,  0,  0,  0, -1, -1,  0, -1, -1,  0,  0,
    3,  3,  0, -1, -1,  1,  4,  4,  2,  3,  0, -2, -2,  0,  1,  1,
    2,  3,  1, -1, -1,  0,  1,  0,  1,  2,  0, -1, -1, -1,  0, -2,
    0,  1,  0, -1, -2, -1,  0, -2,  0,  1,  0, -1, -2, -1,  1,  0,
    1,  1, -1, -3, -4, -3,  1,  3,  1,  2, -1, -3, -5, -4,  1,  3,
   -3, -2,  0,  1,  1,  1,  0, -2,  0,  1,  1,  1,  0,  0, -1, -3,
    1,  2,  1,  1,  0, -1, -1, -2,  0, -1, -3, -1, -1, -1,  0, -1,
    0, -3, -6, -3, -2, -1,  1,  1,  2, -1, -4, -3, -2,  0,  2,  2,
    5,  4,  1,  1,  0,  1,  3,  2,  5,  4,  2,  1,  0, -1,  0,  1,
   -2,  0, -2, -5, -6, -3,  0,  0, -2,  0,  1,  0, -1,  1,  2,  2,
   -2,  0,  1,  3,  2,  2,  2,  1, -2,  0,  2,  4,  3,  2,  1,  1,
   -2,  0,  2,  3,  2,  0, -1,  0, -3, -1,  1,  1,  0, -1, -1,  1,
   -4, -1,  1,  0, -1, -2,  0,  2, -4, -1,  0, -1, -1, -2,  1,  4,
   -3,  0,  0, -1,  1,  1,  1,  0, -3,  1,  0, -1,  0,  0, -1, -1,
   -1,  3,  3,  0,  1,  0,  0,  1, -3,  2,  2, -2, -1,  0,  0,  1,
   -5,  0,  0, -2, -1,  1,  0,  2, -7, -2,  1,  0,  1,  2,  2,  2,
   -5,  0,  3,  2,  3,  3,  2,  2, -3,  2,  4,  1,  0,  0, -2, -3,
    5,  2, -2, -2,  0, -1, -1, -1,  2, -1, -4, -3, -1, -2, -1, -1,
    0, -2, -2,  1,  2, -1,  0,  1, -1, -2, -1,  3,  3, -1,  0,  2,
    1,  0,  0,  3,  3, -2, -1,  2,  2,  1,  1,  3,  2, -2, -2,  0,
    1,  0, -1,  1,  1, -3, -3, -2,  1,  0,  1,  2,  3,  0,  0,  0,
   -4, -5, -3,  0,  1, -1, -2, -1, -2, -3, -1,  1,  2,  0,  0,  0,
    1,  1,  2,  1,  2,  1,  1,  1,  3,  4,  3,  1,  0, -2, -1, -1,
    3,  3,  2,  0, -2, -3, -3, -2,  1,  1,  0, -1, -2, -4, -2, -2,
    2,  1,  0,  0,  0, -1,  0,  1,  2,  1,  1,  1,  1,  1,  1,  3,
    0,  0,  0, -1, -2, -1,  1,  0, -2, -1, -1, -2, -3, -2,  0,  0,
   -1,  0,  0, -1, -2,  0,  1,  1,  1,  1,  0, -1, -1,  1,  3,  1,
    2,  2,  0, -2, -1,  2,  3,  0,  3,  1, -1, -1,  1,  4,  2, -2,
    2,  0, -3, -1,  3,  5,  0, -5,  1, -1, -2,  0,  3,  3, -1, -6,
   -1,  0,  3,  4,  2,  0,  1,  2, -2, -1,  0,  1, -1, -2,  0,  1,
   -2, -3, -2, -3, -6, -7, -6, -3,  2,  2,  3,  1, -1, -2, -3, -2,
    2,  2,  3,  1,  0,  0,  0,  0,  2,  1,  1,  0,  1,  1,  0,  1,
    1,  0,  0,  0,  0,  1,  1,  2,  1,  0, -1,  0,  0,  2,  2,  1,
    1,  1,  3,  1, -1, -1, -1,  1, -2, -1,  0,  0, -2, -2, -1,  2,
   -2, -2,  1,  1,  1,  0,  1,  3, -2, -2,  0, -1,  0, -1,  0,  2,
    0,  0,  1,  0, -1, -1, -2,  1,  3,  2,  2,  1,  0, -2, -2,  1,
    5,  3,  3,  2,  1,  1,  1,  4,  0, -3, -4, -5, -4, -3, -1,  1,
   -6, -4, -1,  2,  2,  0,  0, -1, -4, -2,  1,  3,  3,  2,  2,  0,
   -3, -2, -1,  2,  3,  3,  2,  0, -3, -2, -2,  1,  2,  1,  1, -1,
   -2, -2, -2,  0,  2,  2,  1, -1, -1, -1, -1,  1,  2,  3,  2,  0,
   -1, -1, -2,  1,  2,  2,  2, -1,  0, -1, -2,  0,  2,  1,  0, -1,
    6,  4,  2,  1,  0,  0,  0,  1,  4,  2, -1, -2, -2, -2, -1, -1,
    2,  1, -1, -2, -2, -2, -2, -1,  2,  2,  0, -2, -2, -2, -1,  0,
    0,  0, -1, -2, -2, -1,  0,  1, -3, -3, -2, -1, -1, -2, -1,  0,
   -3, -2,  2,  3,  2,  0, -1, -2, -2,  0,  4,  5,  5,  2,  0, -1,
    5,  4,  2,  0, -1, -2, -1, -1,  4,  3,  2,  1,  0, -1,  0, -1,
    1,  1,  0,  1,  1,  0,  1, -1, -2, -1, -1,  0,  0, -2, -2, -3,
   -1,  0,  0,  0, -1, -3, -3, -5,  0,  1,  1, -1, -1, -2, -2, -3,
   -1, -1, -1, -2, -1,  1,  3,  1, -1, -2, -2, -1,  2,  5,  6,  5,
   -3, -3, -2,  1,  1, -2, -1, -1,  1,  2,  3,  4,  1, -3, -1, -3,
    3,  2,  0,  1, -1, -3, -1, -3,  1,  0, -1,  0, -1, -1,  1,  0,
    1,  1,  0,  1,  2,  2,  5,  3,  1,  1,  1,  2,  2,  2,  3,  0,
   -3, -1, -2, -2, -3, -3, -1, -3, -1,  1,  1,  0, -1, -1,  0, -2,
    2,  0, -2, -2,  2,  4,  1, -2,  1,  0, -2, -1,  3,  5,  2, -1,
   -1, -2, -3, -2,  1,  3,  1, -2, -1, -2, -1, -1,  0,  2,  1, -1,
    0,  0,  1,  1,  1,  2,  2,  0,  0,  1,  4,  4,  2,  2,  3,  1,
   -2, -1,  2,  1, -2, -3, -2, -3, -1,  0,  1,  0, -3, -4, -4, -5,
    4,  0, -3, -4, -4, -4, -2, -1,  5,  0, -1,  0, -1, -3, -2, -1,
    4,  0,  0,  1,  1,  0,  0,  0,  0, -3, -2, -1,  0,  0,  1,  0,
    0, -2,  0,  0,  1,  1,  2,  1,  2,  0,  0,  0,  1,  1,  1,  0,
    2,  0, -1, -1,  1,  1,  1,  0,  1, -1, -2, -2,  0,  2,  2,  2,
   -3, -5, -2,  0, -1, -3, -3,  0,  0, -2,  0,  2,  2,  0,  0,  3,
    2, -1, -2,  0,  0, -1, -1,  2,  5,  2, -1, -1, -1, -1, -1,  2,
    5,  2,  0, -1, -1,  0, -1,  2,  2,  1,  0,  0,  0,  1,  0,  2,
   -1, -1,  1,  1,  2,  2,  1,  2, -3, -2,  0,  0,  0,  0, -2, -1,
    0,  3,  2,  0, -2, -3, -3, -3,  0,  3,  3,  1,  0,  0,  1,  2,
   -1,  0, -1, -2, -1, -1,  1,  3, -1,  0, -1, -2, -1, -1,  0,  2,
   -1,  0, -1, -2,  0,  0, -1,  2, -1,  0, -1, -2, -1, -1, -2,  1,
    0,  1,  0, -3, -1, -1, -1,  2,  5,  5,  2, -1, -1, -1,  1,  3,
    0,  0,  1, -1, -3, -2,  0,  2,  1,  1,  3,  0, -2, -2,  0,  1,
    1,  1,  3,  1,  0,  0, -1, -1,  0, -1,  2,  1,  1,  0, -1, -3,
   -1, -2,  1,  1,  1,  0, -2, -4, -1,  0,  2,  1,  1,  0, -1, -3,
    1,  1,  3,  2,  1,  0, -2, -3,  2,  2,  4,  2,  1, -1, -2, -4,
    1,  2,  2,  2,  0, -2,  0,  2, -1, -1, -2, -3, -4, -5, -3,  1,
    0,  1,  1,  0, -1, -1, -1,  1,  0,  1,  1,  1,  0,  0,  0,  2,
    0,  1,  1,  2,  1,  1,  1,  2, -1, -1,  0,  2,  2,  2,  2,  3,
   -2, -4, -4, -1, -2, -2, -2,  0,  1,  0,  0,  1,  0,  0,  0,  1,
    0, -1, -3, -2,  0,  2,  2,  1,  0, -1, -2, -3,  0,  1,  1,  2,
    1,  0, -2, -3, -1,  0,  0,  1, -1,  0, -1, -2,  0,  0, -1,  0,
   -1,  1,  1,  0,  2,  2,  0,  0,  0,  2,  3,  1,  3,  5,  3,  2,
   -1,  1,  1, -2,  0,  3,  1,  1, -1,  0,  0, -4, -4, -1, -1, -1,
   -1,  1,  1,  0,  1,  2,  1,  2, -3,  0,  1,  0,  1,  1,  0,  2,
   -5, -3, -1, -1,  0,  1,  0,  1, -4, -3, -2, -3, -2, -1, -1,  0,
    0,  0, -1, -2, -2, -2, -2,  0,  3,  4,  2,  0,  0,  0,  0,  1,
    2,  1,  0,  0,  0,  0, -1,  0,  0,  1,  2,  3,  4,  4,  3,  2,
   -1,  4,  7,  4,  0,  0,  0,  0, -1,  4,  6,  3,  0,  1,  1,  1,
    0,  3,  4,  0, -1,  0,  0,  1,  0,  1,  1, -2, -1,  0, -1, -1,
   -1,  0, -1, -1, -1,  0,  0,  0, -1, -1, -1,  0,  0,  0,  0,  0,
   -1, -3, -3,  0,  1, -1, -2, -1, -3, -4, -4, -2, -1, -2, -2, -1,
    2,  2,  1,  0,  1,  1,  0, -3, -2, -1,  0,  0,  1,  1,  0, -3,
   -2, -1,  0,  1,  2,  1,  1, -2,  1,  2,  2,  2,  3,  3,  2, -1,
    1,  2,  1,  0,  1,  1,  2, -1,  0,  1, -2, -4, -2,  0,  1, -1,
    1,  1, -1, -3, -2,  0, -1, -3,  1,  2,  0, -1,  0,  1, -1, -4,
   -1, -1, -2, -2,  0,  3,  4,  3,  1,  1, -1, -3, -2,  0,  0,  0,
    2,  2,  2,  2,  2,  1, -1, -1,  1,  1,  1,  3,  3,  0, -2, -2,
    0, -1, -1, -1,  0, -2, -1, -1, -1, -3, -4, -3, -2, -2,  0,  2,
   -1, -1,  0,  1,  2,  2,  3,  5, -2, -1, -1,  0,  0,  0,  0,  1,
   -2, -3,  2,  0,  0,  1,  1, -1, -1, -4,  1, -2, -1,  2,  2,  0,
    1, -4,  0, -2, -2,  1,  1, -1,  2, -3,  1, -1, -1,  1,  1, -1,
    3, -2,  3,  1,  0,  1,  1, -1,  1, -3,  2,  1,  0,  1,  0, -1,
   -1, -5,  1,  0, -1,  0,  1,  1,  0, -3,  3,  3,  1,  2,  3,  3,
    0, -1, -2,  1,  5,  5,  2, -1,  1, -1, -2, -1,  1,  1, -2, -5,
    1,  1, -1, -2, -1, -1, -1, -3,  1,  1, -1, -1, -1,  2,  4,  3,
   -1, -1, -1, -1, -1,  0,  4,  3, -1, -1,  0,  1, -1, -3, -1, -1,
    0,  0,  0,  2,  2,  0,  0, -1,  0, -2, -3,  0,  1,  1,  3,  2,
    2,  3,  2,  1,  0,  0, -2, -2,  2,  3,  0,  1,  1,  3,  3,  2,
    0,  0, -3, -1, -1,  2,  2,  3, -2, -2, -3,  1,  1,  2,  1,  1,
   -2, -1, -2,  2,  1,  1, -1, -2,  0,  1,  0,  2,  0,  0, -2, -2,
    0,  1,  0,  2,  0,  0, -2, -2, -3, -2, -2,  0, -1, -2, -2, -3,
    0,  1, -1,  3, -1,  1,  3, -1,  0,  1, -1,  3, -1, -1,  2, -3,
    1,  1, -2,  3, -1, -3,  0, -3,  2,  2, -2,  3,  0, -2,  1, -2,
    1,  1, -3,  3, -1, -2,  1, -3,  1,  1, -3,  3,  0, -1,  1, -2,
    1,  2, -1,  4,  0, -1,  1, -2,  0,  1, -1,  3, -1, -3,  0, -3,
   -3, -3, -1,  1,  2,  1, -1, -2, -2, -2,  0,  2,  1,  0, -2, -2,
   -3, -2,  1,  2,  1, -1, -2, -1, -3, -2,  2,  4,  0, -2, -2,  1,
   -3, -1,  2,  4,  0, -2, -2,  2, -1,  1,  4,  3, -1, -3, -2,  2,
    0,  2,  4,  2, -1, -2, -1,  2,  0,  1,  2,  0, -1,  0,  1,  3,
    3,  0, -5,  1,  4,  0,  0,  1,  1, -2, -5,  2,  5, -1, -2,  1,
   -1,  0,  0,  3,  3,  1,  0, -1, -2,  3,  4, -2, -3, -1,  0, -2,
   -3,  3,  5, -3, -3,  0,  0, -2, -1,  3,  2, -2, -2,  2,  2, -1,
    2,  0,  0, -1,  0,  0,  0,  0,  0, -3, -2,  1,  3,  0, -2, -2
};

/* list of codebooks for inter-coded vectors */
static uint8_t *inter_codebooks[4] = {
  inter_codebook_4x2, inter_codebook_4x4, inter_codebook_8x4, inter_codebook_8x8
};

/* 6x16-entry codebook for intra-coded 4x2 vectors */
static int8_t intra_codebook_4x2[768] = {
   12, 13, 13, 11, -7,-10,-15,-17,-16,-15,-12,-10, 11, 15, 15, 12,
    2, 17, 20, 15,-45,-24,  2, 13, 21, 20, -6,-36, 12, 16, -1,-27,
  -18,-21, 10, 45,-11,-20, -7, 21, 43, -8,-28,  0, 33,-16,-28,  3,
  -12,-18,-18, -6,-20,-10, 28, 55, -5,-18,-21,-18, 56, 30, -6,-20,
  -34, 27, 29,-22,-30, 29, 26,-25, 30, 34, 33, 26,-25,-31,-35,-33,
  -31,-35,-36,-32, 29, 36, 37, 31,-71,-12, 38, 34,-63, -1, 42, 33,
   58, 37,-31,-60, 55, 34,-33,-61,-57,-57, 22, 93,-57,-58, 21, 93,
   59, 69, 70, 62,-63,-68,-68,-60,-64,-71,-71,-64, 63, 73, 72, 62,
   -2,  0,  7, 15,-11,-10, -3,  5, -5, -8,-10,-10,  1,  9, 14,  9,
   15,  8, -4,-11, 12,  2,-11,-12, -8,  0, 19, 28,  4, -1,-15,-26,
  -15, 27,  2,-14,-14, 22,  1, -9, -4, -6,-13,-10, -6,-14,  6, 47,
  -35,-20,  6, 23,  6,  9,  6,  4, -6,  2, 23,-22, -7,  4, 28,-21,
   20,-22, -2,  6, 22,-28, -5,  8,-10,-18,-16,-12, 36, 19,  2, -1,
   -3,  0,  4,  8,-45,-10, 23, 23, 40, 15,-20,-35, -4, -1,  4,  1,
    9, -5,-33, 24,  8,  3,-26, 19, -1,  4,  6, -3, 32, 25,-13,-49,
   24, 24, 15,  7,-17,-27,-19, -7,-47,  0, 39, 24,-21, -6,  7,  4,
   -1,  0,-10,-13,  1,  1,  5, 16, 20,  5, -3, -9, -1, -4, -2, -6,
  -17, -7,  1,  4, 12,  7,  0,  0,  3,  0, 12, 11, -3,  1,  0,-23,
    4, 17, -6,  0,  6,  3,-25,  0,-17, 10,  8,  5,-14,  4,  1,  4,
   13, 10,  4,  2,-23, -9,  1,  2,  3, -3,  1,  7,  1,-23, -7, 20,
   -7,-18,  2, 12, -5, -4, 10,  9,  4, 10,  7,-24,  6,  3,  4,-10,
   22,-14,-22,  6,  0,  5,  5, -1, -4,  3,-11, -4, -7, 31,  7,-14,
   -5,-16, -1, 42, -4, -2, -9, -5,  5, -8, -6, -3, 42, -4,-21, -5,
  -18, 12, 20,-12, 13,-13,-10,  7, -8, -9, -2,-18,-16,  6, 40,  8,
   10, -1,  0,  4, -3,  4, -1,-13, -2,  6,  1,-15,  5,  3,  1,  2,
   -4, -2,  1,  3, 15,  0, -9, -4, -3, -4, -4, -4, -3,  5, 16, -3,
    2, 13,  3,  4, -3, -8,-10,  0, -6, -2, -4, -1, -2, -3, -6, 23,
    6, -6,  7,  1,  4,-18,  5,  1, -1,  1,-15, 14, -5,  6, -4,  4,
    2,  2,  2,  6,-24,  2,  7,  3,-26,  0,  3,  3,  5,  7,  1,  6,
   14, -2,-18, -3,  7,  5, -4,  2, -6,  3, 32,  1, -6, -6, -6,-12,
    5,-36,  7,  6,  9, -1, 11,  0,  4,  4,  5,  3,  4, 15,  3,-38,
   10, 23, -5,-42,  0,  4,  4,  4, 23, 17, -6,-13,-13,-37,  1, 29,
    5,-14, -1,  1,  5,  0,  3,  1,  0,  4, -5,  2,  8,  0,  0,-10,
    4,  7, -2, -3,-10,  3,  1,  1,-12, -1, 13,  3,  0, -1,  1, -3,
    0, -1,  3,  1, -6, -9,  3,  9, -6,  1, -4, -6,  8, -1,  0,  8,
   -3, -3,  0, 18, -5, -1, -4, -1, -8, -2,  3, -4,  0, 17, -1, -5,
    5, -2,  9,-10,  1, -5,  6, -5,  4,  2,  2,  3, 10,-14, -8,  1,
   -1, -2,-18, -1, -1, 20,  1,  2, -1,  1, -9,  1, -1, -9, 22, -4,
    6, -4,  8, -3, -1,  7,-19,  5, -7, 31, -4, -4, -6,  0, -5, -5,
   -7, -8,-19, -4,  1,  1,  4, 32, 38, -1, -8,  4, -7, -8, -6,-12,
   -1,  0, -7,  1, -1,  9, -1,  0,  9, -1, -1,  0,  2, -6,  1, -3,
  -12,  0,  2,  1,  1,  1,  8,  0,  9,  1,  0,  2, -2,  1,-11,  0,
    0,  8,  2,-10, -1,  2, -1,  0, -2, -4,  0, -5, -2, -1, -1, 14,
   -3,  7, -1,  5,  0,-10,  1,  1, -1, -5, 14, -1, -2,  1, -3, -2,
   -6,  0,  0,  6,  2,  3, -9,  4,  4, -5, -1, -1, -7,  3,  8, -1,
    2, -4, -1,-11, 11,  2,  1,  0, -1,  2,  3,  9,  0,  2,  0,-15,
    3,  5,-20,  3,  3, -1,  3,  3,  1, -1, 16,  1,  2,-29,  9,  2,
  -13, -6, -1, -3, 36, -1, -8, -3,  2,  5,  4,  2,-37,  9, 11,  3
};

/* 6x16-entry codebook for intra-coded 4x4 vectors */
static int8_t intra_codebook_4x4[1536] = {
  -11, -3,  3,  6,-10, -1,  5,  7, -9, -1,  6,  7, -9, -1,  4,  6,
    5,  7,  0,-14,  6,  9,  2,-15,  6,  9,  2,-15,  4,  6,  0,-14,
   16,  3, -5, -6, 16,  1, -8, -8, 14, -1, -9, -9, 12,  0, -8, -8,
    8, 12, 16, 17, -2,  2,  6,  9,-10, -8, -4,  0,-15,-14,-11, -7,
   -7,-10, -2, 16, -7,-11, -3, 18, -7,-11, -1, 20, -6, -8,  1, 19,
   -9,-13,-16,-17,  2, -2, -7, -9, 11,  8,  4, -1, 16, 15, 11,  7,
  -22, -2, 13, 15,-24, -2, 14, 16,-25, -4, 13, 15,-25, -6, 10, 13,
   26, 26, 22, 16, 17, 15,  9,  3, -2, -6,-11,-14,-20,-25,-28,-28,
  -27,-27,-25,-21,-16,-15,-11, -7,  3,  8, 12, 13, 23, 28, 31, 30,
   20, 16, -7,-33, 22, 19, -6,-35, 22, 19, -6,-34, 20, 17, -6,-32,
  -20,-20,  2, 38,-21,-22,  2, 40,-21,-22,  2, 40,-20,-20,  3, 38,
  -47, -4, 24, 26,-50, -3, 26, 27,-50, -3, 26, 27,-47, -4, 24, 26,
   45,  6,-23,-27, 48,  5,-25,-28, 48,  5,-26,-28, 44,  6,-24,-27,
  -30,-36,-10, 76,-31,-37,-11, 78,-31,-37,-11, 78,-31,-36,-10, 77,
  -53,-32, 35, 52,-54,-34, 36, 52,-54,-34, 36, 52,-53,-33, 34, 51,
  -93,-34, 62, 65,-93,-34, 62, 66,-93,-34, 62, 65,-93,-34, 60, 64,
   -7,  0,  2,  2, -8, -1,  3,  3, -8,  0,  4,  5, -6,  1,  5,  5,
    3,  7, 11, 11,  2,  2,  3,  3,  1, -2, -6, -7,  1, -5,-11,-13,
    3, -2, -4, -3,  7,  0, -5, -5, 12,  4, -5, -7, 14,  6, -4, -7,
   18, 14,  3, -2,  6,  4,  0, -3, -8, -5, -2,  0,-16,-11, -2,  2,
   -8, -6,  7, 18, -7, -8,  2, 13, -4, -6, -2,  6,  0, -4, -3,  1,
    1, -3,-13,-18,  0, -1, -5, -7, -1,  1,  6,  7, -2,  4, 15, 17,
  -15,-14, -7, -2, -6, -5, -1,  0,  6,  6,  3,  1, 15, 13,  6,  1,
    2, -2,-11, 10,  2, -1,-12, 11,  3, -1,-12, 11,  2, -2,-11, 11,
   -9, 14, -1, -5, -9, 15, -2, -5, -8, 16, -2, -5, -7, 15, -1, -4,
    2,  6,  8,  8, -2,  3,  9, 12,-11, -5,  4, 10,-19,-16, -8,  0,
   14,  8, -7,-15, 12,  7, -7,-14,  8,  5, -4, -9,  5,  3, -1, -4,
   12,-14, -2,  2, 13,-15, -1,  3, 14,-15, -1,  3, 13,-14, -1,  3,
    0,  6, 10,-13,  0,  6, 10,-15,  0,  7,  9,-17,  1,  6,  8,-16,
   -8, -5, 15, -2, -8, -6, 17, -2, -8, -6, 16, -3, -8, -5, 15, -2,
   -9,-11,-11,-10,  9, 10,  9,  8,  8, 10, 10,  9, -8, -9, -8, -7,
    9, 10,  9,  7, -8,-10,-10,-10, -7,-10,-11,-11, 11, 12, 11,  8,
    0, 10,  7,  0,  0,  7,  0, -6,  0,  2, -5, -6, -2, -1, -4, -1,
    5,  0, -6, -9,  2,  2,  2,  1, -2,  0,  5,  7, -6, -5,  1,  4,
    3, -8,  2, -1,  4, -9,  3,  0,  5, -7,  3,  0,  7, -5,  3,  0,
   -5, -3,  2,  9, -6, -3,  1,  8, -6, -3,  1,  7, -5, -2,  0,  4,
   13,  8,  3,  1, -3, -5, -4, -1, -8, -7, -3,  0, -1,  1,  3,  2,
    3,  2, -5,-12,  4,  3, -2, -9,  3,  4,  1, -4,  3,  5,  4, -1,
   -9, -8, -4,  0,  8,  6,  2,  0, 10,  8,  3,  0, -6, -5, -3, -1,
   -3, -9,-12, -5,  0, -3, -5,  0,  2,  3,  2,  4,  5,  8,  7,  6,
   -1, -2,  5, 12, -1, -1,  5,  9,  2,  1, -1, -2,  2, -1,-11,-17,
   -7,  3,  3, -1, -9,  3,  4, -1,-10,  4,  6, -1, -9,  5,  7,  0,
  -18, -7,  2,  2, -8,  1,  5,  3,  3,  4,  1,  0,  9,  5, -2, -3,
   -2,  0,  6,  8, -4, -5, -5, -3,  1, -2, -6, -8, 10,  9,  3, -1,
    0, -2, -2,  0,  0, -4, -5,  0, -2, -8, -4,  8, -5, -7,  6, 24,
    9,  1, -7,  1,  9,  1, -8,  1,  8,  0,-10,  1,  8, -1,-11, -1,
    8,  8,  6,  3,  5,  4,  3,  2, -2, -3, -1,  0,-10,-13, -8, -4,
    0,  4,  2, -3,  0,  6,  3, -5,  3, 10,  2,-12,  5, 10, -4,-22,
    0, -4, -1,  3,  1, -4, -1,  5,  1, -5,  0,  8, -1, -6, -2,  7,
   -1, -1, -2, -4, -1, -2, -4, -6, -1, -1, -1, -2,  1,  5, 10,  9,
   10,  3,  0, -2,  6, -1, -2, -5,  3, -1, -2, -6,  2,  0,  0, -5,
    6,  3,  0,  0,  6,  3,  1,  1,  4, -2, -2,  1,  0, -9, -9, -2,
  -11, -3,  1,  2, -6,  2,  4,  5, -3,  2,  3,  4, -2,  1,  1,  2,
   -6, -4, -1, -2,  2, -1, -1, -2, 10,  2, -2, -2, 11,  2, -4, -1,
    6,  0, -2,  2,  3,  3,  0,  0, -6,  3,  3,  0,-17, -1,  5,  0,
   -1,  4, 10, 11, -3, -2,  0,  1, -3, -4, -5, -3, -1, -2, -2, -1,
    2, -3, -9,-12,  3,  3,  3,  2,  2,  2,  4,  4,  2,  1, -1, -2,
   -2,  9,  5,-10, -3,  5,  5, -5, -2,  1,  2,  0, -1, -2, -2,  1,
   -2, -3,  7, -2, -1, -3,  7, -3, -1, -2,  8, -4, -2, -2,  7, -3,
    1, -8, -3, 12,  2, -2, -2,  4,  1,  3,  0, -5, -1,  5,  2, -7,
   -1,  3,  1, -5, -7, -2,  3,  1, -2, -7, -2,  2, 20,  3, -5, -1,
    5,  0, -3, -2, -7, -7,  0,  6, -6,  0,  7,  6,  2,  6,  0, -7,
   -2,  6, -7,  1, -2,  7, -8,  3, -2,  7, -7,  3, -1,  7, -6,  2,
   -5, -2,  5,  7,  4,  1, -4, -8,  6,  3, -2, -5, -7, -5,  3,  7,
   -1, -1,  6,  5,  0, -1,  1, -4,  2,  1,  0, -7,  1,  0,  0, -4,
   -8,  0,  3,  1, -2,  1, -1, -1,  1, -1, -3,  1,  1, -2,  1,  9,
    5,  2, -3, -4, -1,  0, -1, -3, -3,  1,  3,  1, -4,  0,  4,  2,
    2, -2, -2, 12,  0, -2, -5,  3, -1,  0, -3,  1, -3, -1, -2,  1,
    1,  5,  3,  0, -6, -4, -2,  1,  0, -2, -2,  2,  6,  1, -4, -1,
   -3, -5, -5, -1,  3,  5,  5,  4,  0,  3,  1, -1, -2,  1, -2, -3,
    2, -4, -5, -3,  4, -2, -3, -2,  6,  0, -1, -1,  7,  1,  0,  0,
   -3, -2, -2,  0, -2, -3, -5, -1, -2,  2,  0, -1, -1, 11,  9, -1,
    0,  1, -1,-10, -1,  1,  0, -6,  1,  0,  1,  4,  2, -5, -1, 13,
   -2,  4,  5,  0, -5,  1,  6,  3, -6, -2,  3,  2, -5, -2,  0, -2,
   -1,  1,  1, -2, -1, -2,  0,  2,  5,  5,  5,  7,  0, -4, -8, -7,
    0,  2, -1, -5, -1,  2,  2, -3,  0,  5,  3, -5,  3,  8,  2,-12,
    8,  4,  0, -2, 10, -1, -4, -1,  3, -6, -3,  0, -4, -5,  0,  0,
    0,-10, -4,  2, -1, -6,  3,  5, -1, -3,  6,  4,  0, -2,  4,  2,
    0,  8,  1, -1,  0, 11,  1, -3, -1,  6, -2, -4, -3, -2, -7, -4,
    0, -1, -1, -1,  4,  5,  6,  5, -5, -9, -8, -5,  2,  2,  3,  2,
    0,  2,  6,  1,  2,  0,  3,  0,  1, -2, -1, -2,  0, -1, -3, -6,
    0,  0,  2,  0,  4,  0,  2,  1,  5, -2,  0,  0, -2, -9, -1,  2,
    0,  1,  0,-10, -1,  1,  8,  0, -1, -2,  4,  0,  1, -1,  2, -1,
   -3, -2,  2, -1, -3, -1,  2, -3,  0, -1,  1,  0,  8,  1, -1,  3,
    0,  1,  1,  2,  0, -4, -2,  0, -1, -5,  1, -1, -2, -1, 11,  2,
    1,  5, -2, -2,  0,  2, -4,  0, -2,  1, -5,  1,  0,  5,  0,  1,
   -5, -3,  0,  6, -4,  2,  0,  0, -3,  5,  1,  0, -3,  3,  0,  0,
    3, -2, -3,  1,  1, -4,  0,  8, -2, -3, -2,  3,  1,  2, -1, -1,
    1,  1,  0,  2,  2,  0,  1,  6,  1, -1,  2,  1,  0,  3,  0,-19,
    1, -3, -2,  2,  6,  5, -2, -7, -3,  1,  3,  1, -1, -1,  0,  2,
   -8, -1, -1, -4,  1,  1, -1,  2,  4,  3,  2,  3, -5,  1,  3,  0,
    0,  2, -1,  1, -3,  0,  0,  5, -5, -2,  0,  8, -4, -4, -4,  6,
    1,  2,  1,  2,  2,  2, -3,  2,  4,  0, -9,  0,  7,  0,-11,  1,
    0,  0,  0, -2,  3,  3, -1, -6,  4,  3, -3,-10, -1,  2,  6,  2,
    7, -2, -3,  5, -4,  0,  3, -1, -4,  2,  1, -7,  2, -1, -1,  3,
    3,  2,  2,  2, -5, -7, -7, -5,  5,  6,  4,  2, -2, -1,  0,  1
};

/* 6x16-entry codebook for intra-coded 8x4 vectors */
static int8_t intra_codebook_8x4[3072] = {
    5,  6,  6,  6,  7,  7,  8,  8,  0,  0,  0,  0,  0,  1,  2,  3,
   -3, -4, -4, -5, -5, -4, -3, -2, -4, -4, -4, -5, -4, -4, -3, -3,
    1,  2,  2,  2,  2,  3,  3,  3,  2,  3,  3,  4,  4,  5,  5,  5,
   -1,  0,  1,  1,  2,  3,  4,  4, -9,-10, -9, -9, -8, -7, -6, -5,
   -4, -4, -5, -6, -6, -7, -7, -7,  0, -1, -2, -2, -3, -3, -4, -4,
    4,  4,  3,  3,  2,  1,  1,  0,  7,  7,  7,  6,  6,  5,  4,  4,
    2,  4,  5,  6,  4,  1, -3, -6,  3,  4,  5,  5,  4,  0, -5, -8,
    2,  3,  4,  4,  2, -2, -7,-10,  2,  2,  2,  1,  0, -4, -9,-12,
   -9, -7, -3,  1,  4,  4,  3,  3,-10, -7, -2,  3,  5,  5,  3,  3,
   -9, -6, -2,  3,  6,  5,  4,  3, -8, -6, -1,  3,  4,  4,  3,  2,
   -5, -5, -5, -5, -3,  1,  4,  7, -5, -5, -5, -4, -2,  1,  6,  8,
   -4, -5, -4, -3, -1,  3,  8, 10, -3, -4, -3, -2,  1,  5,  9, 11,
   -2, -2, -2, -2, -2, -2, -2, -2, -4, -5, -5, -5, -5, -5, -5, -4,
   -3, -4, -4, -4, -4, -4, -4, -3,  9, 10, 10, 11, 11, 11, 10, 10,
    7,  4,  1, -2, -4, -6, -9,-10,  9,  7,  3,  0, -2, -4, -8, -9,
   11,  8,  4,  2,  0, -3, -6, -8, 11,  9,  5,  3,  1, -2, -5, -7,
  -13,-13,-13,-12,-11,-10, -8, -8,  0,  1,  2,  3,  4,  4,  4,  3,
    3,  4,  5,  6,  6,  6,  5,  4,  3,  4,  4,  4,  3,  3,  3,  2,
   10, 10, 11, 10,  9,  9,  8,  7,  6,  6,  6,  6,  5,  4,  3,  2,
    0,  0,  0, -1, -2, -3, -4, -4,-10,-10,-11,-12,-13,-14,-14,-14,
   16, 16, 17, 16, 15, 13, 12, 11, -1, -2, -3, -4, -4, -4, -4, -3,
   -4, -5, -6, -6, -6, -6, -6, -6, -5, -6, -6, -6, -6, -6, -5, -5,
  -13,-13,-13,-12,-11,-10, -8, -6, -9, -8, -7, -6, -4, -2,  0,  1,
   -2, -1,  1,  3,  5,  7,  8,  9,  5,  7,  9, 11, 13, 14, 15, 15,
   16, 14, 11,  7,  2, -3, -7, -9, 14, 12,  8,  3, -1, -6, -9,-11,
   11,  9,  4,  0, -4, -8,-11,-13,  8,  5,  1, -3, -6,-10,-12,-14,
  -18,-15, -9, -3,  1,  6,  9, 11,-17,-13, -7, -1,  3,  7, 11, 12,
  -15,-11, -5,  1,  5,  9, 12, 13,-13, -9, -3,  2,  5,  9, 11, 13,
   22, 21, 19, 15, 10,  3, -4, -9, 20, 18, 15,  9,  2, -5,-12,-17,
   16, 13,  8,  1, -7,-14,-20,-24, 10,  6, -1, -8,-15,-21,-25,-27,
  -25,-23,-20,-14, -7,  1,  9, 14,-23,-21,-16, -9,  0,  9, 16, 21,
  -20,-16,-10, -1,  8, 16, 22, 25,-15,-11, -3,  6, 14, 20, 25, 27,
   -4, -2,  0,  1,  2,  2,  2,  2, -5, -2,  0,  2,  3,  3,  3,  3,
   -6, -4, -1,  1,  2,  3,  3,  3, -7, -5, -2,  0,  1,  1,  2,  2,
    2,  1,  1,  1,  1,  0, -2, -3,  3,  3,  2,  1,  0, -1, -3, -4,
    4,  3,  2,  1,  0, -2, -4, -6,  5,  4,  3,  1, -1, -3, -5, -6,
    5,  6,  6,  4,  2,  0, -2, -3,  3,  4,  4,  4,  3,  1,  0, -1,
   -2, -2, -1, -1, -1, -1, -2, -2, -5, -4, -3, -2, -2, -2, -3, -3,
   -1, -1, -1, -1, -1, -1, -1, -1, -3, -4, -4, -4, -3, -3, -3, -3,
   -1, -1, -1, -1, -1, -1, -1, -2,  5,  6,  6,  6,  6,  5,  4,  3,
    4,  4,  4,  4,  4,  5,  6,  7,  0, -1, -1, -1, -1,  0,  1,  2,
   -2, -3, -3, -3, -3, -2, -1,  0, -3, -3, -4, -4, -4, -3, -2, -1,
    0, -2, -4, -4, -2,  0,  2,  3,  0, -2, -3, -3, -1,  2,  4,  5,
   -1, -2, -4, -3,  0,  3,  5,  6, -2, -3, -4, -3, -1,  2,  4,  5,
    9,  4,  0, -3, -3, -1,  0,  1,  8,  4, -1, -4, -3, -1,  1,  2,
    6,  2, -3, -5, -4, -2,  0,  1,  5,  1, -3, -4, -4, -2,  0,  1,
    5,  3,  1, -1, -4, -8,-10,-10,  3,  3,  2,  1,  0, -2, -3, -4,
    1,  1,  1,  2,  3,  2,  1,  0, -1,  0,  1,  2,  3,  4,  3,  2,
    0,  1,  2,  2,  1, -1, -3, -3,  0,  1,  1,  1, -1, -2, -4, -3,
   -3, -3, -3, -3, -3, -3, -1,  2, -4, -4, -3,  0,  3,  7, 12, 14,
   -5, -5, -6, -6, -6, -6, -6, -5,  2,  2,  2,  1,  0,  0,  0,  0,
    4,  4,  3,  2,  1,  0,  0,  0,  6,  6,  5,  4,  2,  2,  1,  1,
   -7, -7, -6, -3,  0,  4,  7,  8, -1, -2, -3, -3, -2, -1,  1,  2,
    3,  3,  1, -1, -2, -2, -2, -1,  6,  6,  4,  2,  0, -2, -2, -2,
   -6, -5, -2,  2,  5,  9, 11, 12, -4, -4, -2,  0,  2,  4,  5,  6,
   -3, -2, -2, -2, -2, -1,  0,  1, -2, -2, -2, -3, -3, -3, -3, -2,
   -7, -3,  1,  3,  3,  0, -3, -5, -6, -2,  3,  5,  4,  1, -3, -5,
   -5, -1,  4,  6,  5,  2, -3, -4, -4,  0,  5,  7,  6,  3, -1, -3,
    0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -3, -3, -3, -3, -2, -1,
    6,  7,  8,  9,  9,  8,  7,  6, -4, -4, -5, -5, -6, -6, -5, -4,
   -9, -8, -6, -4,  0,  3,  6,  6, -5, -4, -1,  3,  5,  6,  5,  3,
    1,  3,  6,  6,  4,  1, -2, -5,  6,  7,  5,  1, -3, -7,-10,-11,
   10,  9,  5,  1, -3, -6, -6, -4,  5,  3, -1, -5, -6, -5, -2,  2,
   -2, -4, -6, -6, -4,  1,  6, 10, -6, -7, -7, -4,  1,  7, 11, 12,
    6,  5,  3,  2,  0,  0,  0,  0,  2,  1, -1, -2, -3, -2, -1, -1,
    0, -1, -2, -4, -4, -2, -1,  1,  0,  0, -1, -2, -1,  0,  2,  3,
    0, -1, -2, -2, -2, -2, -1, -1,  5,  4,  2,  1,  0,  0,  0,  0,
    6,  5,  3,  1,  0,  0,  0,  0,  2,  0, -2, -4, -4, -3, -2, -2,
   -7, -4,  0,  2,  2,  2,  2,  1, -7, -3,  0,  0,  0,  0,  0,  0,
   -4, -1,  1,  1,  0,  0,  0,  1, -1,  1,  2,  2,  2,  2,  3,  3,
   -2,  0,  2,  2,  1,  1,  1,  1, -1,  1,  2,  2,  1,  0,  0, -1,
    0,  2,  4,  2,  0, -1, -2, -3,  1,  2,  3,  1, -2, -4, -6, -6,
    1,  2,  2,  4,  5,  6,  4,  1,  0, -1, -1, -1,  0,  0, -2, -4,
    0,  0, -1, -2, -2, -2, -4, -6,  2,  1,  0,  0,  1,  1, -1, -3,
    1,  1,  1,  1,  1,  2,  3,  3,  0,  0,  1,  0,  1,  2,  4,  4,
   -1, -1, -1, -1,  0,  1,  2,  3, -4, -4, -5, -5, -5, -3, -1,  0,
   -6, -5, -5, -4, -3, -2, -1, -1, -1,  0,  0,  1,  1,  2,  3,  3,
    0,  1,  1,  1,  2,  2,  3,  4,  0,  0, -1, -1,  0,  1,  2,  3,
    0,  1,  1,  1,  0,  0, -1, -1,  1,  3,  3,  2,  1, -1, -2, -2,
   -2,  0,  2,  2,  2,  2,  1,  1, -9, -8, -4, -2,  1,  3,  3,  3,
   -1, -1, -1, -2, -3, -3, -3, -4,  0,  0,  0, -1, -2, -2, -3, -3,
    2,  2,  2,  0, -1, -1, -1, -1,  5,  5,  4,  3,  2,  2,  2,  2,
    6,  3, -1, -4, -3, -1,  1,  1,  2, -1, -3, -4, -1,  2,  2,  0,
   -1, -2, -2,  1,  4,  4,  1, -3, -2, -1,  1,  4,  6,  3, -3, -8,
    3,  3,  2,  1, -1, -2, -2, -2, -4, -4, -2, -1,  1,  3,  4,  4,
   -4, -5, -5, -4, -2,  0,  2,  2,  7,  7,  4,  1, -1, -2, -3, -2,
   -1,  1,  3,  0, -4, -6,  0,  6, -2,  1,  4,  1, -4, -6, -1,  7,
   -3,  1,  4,  2, -3, -6, -1,  6, -2,  0,  3,  2, -2, -5, -1,  4,
    1, -1, -2,  1,  4,  4, -1, -7,  1, -1, -4, -1,  5,  6,  0, -6,
    3,  0, -4, -3,  3,  6,  2, -4,  3,  0, -5, -4,  1,  4,  1, -3,
    2,  2,  3,  3,  3,  3,  2,  2, -4, -5, -6, -7, -7, -7, -7, -6,
    1,  2,  3,  3,  3,  3,  2,  2,  0,  0,  1,  1,  1,  2,  2,  1,
    3, -3, -3,  3,  4, -2, -2,  2,  3, -4, -4,  4,  4, -4, -4,  2,
    4, -4, -4,  4,  4, -4, -3,  3,  3, -3, -4,  3,  3, -3, -3,  3,
   -2, -2, -2, -2, -2, -2, -1, -1,  6,  7,  8,  8,  8,  7,  6,  5,
   -5, -6, -7, -7, -8, -7, -6, -5,  1,  1,  2,  2,  2,  2,  1,  1,
    0,  0,  0,  0,  0, -1,  0,  0, -1,  0,  0,  0,  0, -1,  0,  0,
   -2, -3, -2, -2, -2, -3, -3, -3,  2,  3,  5,  6,  4,  2,  1,  0,
    8,  6,  2,  0,  0,  0,  0,  0,  4,  1,  0,  0,  0, -1, -1, -1,
    1, -1,  0,  0,  0, -1, -2, -3, -2, -2, -1,  0,  0, -2, -4, -5,
    3,  1, -1, -2, -3, -4, -5, -5,  2,  1,  0,  0,  1,  1,  0,  0,
    0, -1, -1,  0,  2,  2,  2,  2, -1, -2, -1,  1,  2,  2,  2,  2,
    0, -1, -2, -1, -1, -1, -1,  0, -1, -2, -2, -1, -1,  0,  0,  1,
    2,  1,  1,  2,  2,  1,  1,  0,  6,  5,  3,  1,  0, -2, -4, -4,
   -3, -2, -1,  0,  1,  1,  0, -1,  0,  1,  3,  4,  5,  5,  3,  1,
   -1, -1, -1,  0,  1,  0, -1, -2, -2, -2, -2, -1,  0, -1, -2, -3,
    0, -1, -2, -2, -1, -1,  0,  2,  1, -1, -2, -1, -1, -1,  0,  2,
    1,  0, -2, -2, -2, -2,  1,  5,  1, -1, -2, -2, -2,  0,  5, 10,
    0,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1,  0,  0,  0,  1,  2,
    1,  2,  2,  3,  4,  4,  6,  5, -3, -3, -3, -2, -2, -3, -3, -3,
    1, -1, -2, -2,  0,  3,  5,  7,  2,  0, -2, -3, -2,  0,  2,  3,
    3,  1, -2, -3, -3, -2, -1, -1,  3,  1,  0, -1, -1, -1, -1, -1,
    1,  3,  5,  4,  2, -1, -3, -4, -3, -2,  1,  2,  1,  0, -1, -2,
   -5, -3,  0,  2,  2,  1,  0,  0, -3, -1,  1,  2,  2,  1,  0,  0,
    0, -1, -1, -1,  1,  2,  3,  4, -3, -4, -4, -3, -1,  0,  0,  1,
   -2, -3, -2, -1,  1,  1,  1,  1, -2, -2,  0,  3,  4,  4,  3,  2,
   -4, -4, -3, -2, -1,  1,  2,  3,  0,  1,  1,  1, -1, -2, -3, -3,
    3,  4,  5,  4,  2, -1, -3, -3, -2, -2,  0,  2,  2,  2,  1,  0,
   -4,  0,  5,  7,  4, -1, -4, -4, -1,  2,  4,  3,  0, -3, -3, -2,
    2,  1,  0, -1, -2, -2,  0,  1,  0,  0, -1, -2, -2, -1,  1,  2,
   -4, -3, -2, -1,  0,  1,  2,  2, 10,  9,  5,  0, -3, -4, -3, -2,
    1, -1, -2, -2, -1,  0,  0,  0, -2, -2, -1,  1,  1,  1,  0, -1,
   -5, -3,  0,  3,  4,  2,  0, -2, -2, -1,  0,  1,  1,  0, -1, -1,
    3,  2, -1, -2, -2, -1,  1,  1,  7,  5, -1, -5, -6, -2,  2,  4,
   -2,  3,  3, -3, -4,  1,  2, -2, -3,  3,  4, -3, -4,  2,  3, -2,
   -3,  3,  4, -3, -4,  2,  3, -2, -4,  2,  4, -2, -3,  1,  2, -1,
    4,  3, -1, -3, -3, -1,  1,  2, -4, -6, -4,  0,  4,  5,  4,  1,
    0,  2,  5,  6,  2, -3, -5, -4,  1,  1, -1, -3, -5, -2,  2,  4,
   -1,  0,  1,  2,  2,  3,  3,  4, -1,  0,  1,  1,  0, -1, -1, -1,
   -1,  0,  1,  2,  2,  1, -1, -2, -3, -2, -1,  0,  0, -1, -2, -3,
    1,  1,  1,  1,  0,  0,  1,  2,  1,  0, -1,  0,  0,  1,  1,  0,
    1, -2, -4, -1,  1,  2,  1,  0,  1, -4, -7, -3,  1,  3,  2,  1,
    1,  1,  1,  1,  1,  1,  0, -1,  1,  1,  1,  0,  1,  2,  2,  0,
    1,  1,  0,  0,  0,  2,  0, -3,  3,  2,  0, -1, -1, -2, -6, -9,
    0,  0,  0,  1,  0,  0,  1,  2,  1,  0,  0,  0, -1, -1,  0,  2,
    0,  1,  1,  1, -1, -3, -2,  0, -7, -5,  1,  6,  6,  2, -1, -1,
    3,  1, -1, -3, -4, -2,  1,  4,  2,  0, -2, -3, -4, -3, -1,  2,
    2,  2,  1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  0,  0,  0,  1,
   -1,  1,  1, -2, -5, -6, -4, -1, -1,  1,  4,  3,  2,  0,  1,  2,
   -1,  0,  2,  3,  1,  0,  0,  1, -1,  0,  1,  0,  0, -1, -1,  0,
    0,  1,  2,  2,  0, -2, -1,  1, -2, -1, -1, -2, -1,  2,  6,  8,
   -1, -1, -2, -3, -2,  0,  1,  2, -1,  0,  0, -1, -1,  0, -1, -1,
    2,  1,  1,  1,  1,  0,  0,  0,  0,  0,  1,  1,  1, -1, -1,  1,
   -1,  0,  2,  2, -1, -3, -2,  3,  0,  2,  3,  0, -5, -7, -2,  4,
   -1,  0,  0,  0, -1, -2, -3, -3, -1,  0, -1, -2, -2, -2, -2, -2,
    1,  1,  0,  0,  1,  2,  0, -1,  1,  2,  1,  2,  5,  6,  2,  0,
   -2, -4, -3,  0,  2,  2,  0, -3,  3,  1,  0,  1,  2,  1, -2, -3,
    3,  1,  0,  0,  0,  0,  0, -1,  1, -1, -2, -2, -1,  1,  3,  3,
    3,  2,  1,  2,  4,  3,  1, -2, -2, -4, -4, -3, -1,  0, -2, -3,
    1,  0, -1, -1,  0,  1,  0, -1,  3,  2,  0,  0,  0,  1,  1,  0,
    1,  1,  0,  0,  0,  0,  0,  0,  2,  3,  3,  2,  2,  2,  1,  1,
    0, -1, -2, -3, -5, -5, -5, -4,  1,  1,  0, -1,  0,  1,  3,  3,
   -9, -6, -2,  0,  1,  1,  2,  2, -6, -2,  1,  2,  1,  1,  0,  1,
   -2,  1,  2,  2,  1,  1,  1,  1,  0,  2,  2,  1,  0,  1,  1,  1,
    1,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,  0, -1, -3, -2,  0,
   -3, -3, -3, -2, -1,  3,  7,  9,  1,  2,  2,  2,  0, -2, -4, -3,
    2,  0, -2, -1,  3,  4, -1, -6,  1,  0, -2, -3, -1,  3,  3,  0,
    0,  3,  3,  0, -2, -1,  1,  1, -6, -1,  3,  2, -1, -2,  0,  1,
    5,  3,  0, -2, -3,  0,  2,  1,  1,  1,  2,  2,  0, -2, -4, -7,
   -3, -2,  1,  2,  2,  1, -1, -4,  2,  2,  0, -2, -2,  0,  2,  2,
    0,  0, -2, -3, -2, -1,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,
   -2, -1,  0,  1,  0,  1,  2,  3, -4, -2,  0,  0, -1,  0,  2,  3,
   -2, -2, -2, -1, -1,  0,  2,  4,  0,  0,  0,  0, -1, -1,  0,  1,
    0, -1, -1, -1, -1, -1,  0,  0,  6,  4,  2,  0, -1, -2, -1, -1,
    0,  1,  1,  1,  1, -1, -5,-10,  1,  1,  1,  1,  1,  1,  0, -4,
    1,  0,  1,  1,  1,  1,  1, -1,  2,  1,  1,  1,  0,  0,  0,  0,
   -3,  1,  4,  3,  3,  1, -1,  0, -4,  0,  1,  0, -1,  0,  0,  0,
   -5,  0,  2,  1,  1,  1,  0, -1, -1,  2,  1, -2, -2, -1,  0, -1,
    2,  4,  5,  3,  0, -1,  1,  2,  0,  0,  1,  0, -2, -2, -1, -1,
   -2, -2, -2, -2, -3, -2, -1,  0,  0,  0,  1,  0,  0,  0,  1,  2,
    0, -2, -2, -3, -1,  2,  2, -1,  1,  0,  0,  0,  1,  5,  3, -2,
   -1, -1,  0, -1,  0,  2,  0, -5, -1,  0,  1,  0,  0,  2,  2, -2,
    3,  1, -1, -1,  0,  1,  1,  2,  1,  0,  0,  1,  1,  1,  1,  1,
  -10, -8, -2,  1,  2,  1,  1,  1, -1,  1,  2,  1,  0,  0,  0,  0,
   -1, -1,  0,  1,  2,  2,  2,  1, -1, -1, -1,  0, -1, -3, -5, -4,
    1,  1,  2,  1,  1,  0,  0,  2, -1, -2, -1, -1, -1,  0,  2,  4,
   -3, -7, -5,  0,  2,  0,  0,  0,  3, -1, -2,  1,  2,  1,  1,  2,
    1, -2, -1,  1,  2,  1,  0,  1,  0, -1,  0,  3,  2, -1, -1, -1,
    2,  1,  1,  0,  0,  0,  0,  0, -9, -7, -2,  3,  3,  2,  1,  1,
    3,  2,  0, -2, -2, -1,  1,  1,  0, -1,  0,  0,  1,  1,  0,  0,
   -2, -1,  1,  1,  1,  0,  0,  0,  1,  2,  1, -2, -4, -3,  1,  2,
    1,  2,  1, -2, -3,  0,  3,  1, -1, -1,  0,  0,  1,  3,  0, -4,
    2,  0, -1,  1,  2, -2, -2,  3,  2,  0, -1,  2,  3, -2, -4,  1,
    0,  1,  1,  1,  2, -2, -6, -2, -1,  0,  0,  0,  2,  0, -2, -1,
   -1, -1,  1,  2,  1, -2, -3, -2,  3, -1, -2, -1, -1,  0,  1,  2,
   10,  4,  0,  0, -1, -2, -2, -1,  3, -1, -2, -1,  0, -1, -1,  0,
   -5,  2,  7,  1, -4, -2,  1,  0, -2,  2,  3, -1, -3,  0,  2,  0,
    2,  1,  0,  0,  1,  1, -1, -2,  1, -2, -2, -1, -1, -2,  0,  0,
    0,  3, -2, -7, -1,  3,  0,  0,  1,  3, -3, -5,  2,  3, -1,  0,
    0,  2, -2, -2,  4,  2, -2,  0, -1,  1, -1,  0,  2, -1, -2,  1,
    4,  0, -3, -4, -2,  1,  2,  1,  0,  0,  3,  5,  3,  1, -1, -2,
    1,  1,  1, -1, -3, -1,  1,  1,  1, -1, -2, -2,  0,  0, -1, -2
};

/* 6x16-entry codebook for intra-coded 8x8 vectors */
static int8_t intra_codebook_8x8[6144] = {
    4,  4,  3,  2,  2,  1,  0, -1,  4,  3,  3,  2,  1,  0, -1, -1,
    3,  3,  2,  2,  1,  0, -1, -2,  3,  2,  2,  1,  0, -1, -2, -3,
    2,  2,  1,  0, -1, -1, -2, -3,  2,  1,  0,  0, -1, -2, -3, -4,
    1,  0,  0, -1, -2, -3, -4, -4,  0,  0, -1, -2, -2, -3, -4, -4,
    2,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  3,  3,
    1,  2,  2,  2,  2,  2,  2,  2,  0,  1,  1,  1,  1,  1,  1,  1,
   -1,  0,  0,  0,  0,  0,  1,  1, -2, -2, -1, -1, -1, -1, -1, -1,
   -3, -3, -3, -3, -3, -3, -2, -2, -5, -4, -4, -4, -4, -4, -4, -3,
   -4, -2, -1,  0,  1,  2,  2,  3, -4, -2, -1,  0,  1,  2,  3,  3,
   -4, -3, -1,  0,  1,  2,  3,  3, -4, -3, -1,  0,  1,  2,  3,  3,
   -5, -3, -1,  0,  1,  2,  3,  3, -5, -3, -1,  0,  1,  2,  3,  3,
   -5, -3, -1,  0,  1,  1,  2,  3, -5, -3, -2, -1,  0,  1,  2,  3,
    4,  4,  5,  5,  6,  6,  7,  7,  2,  2,  2,  3,  3,  4,  4,  4,
    0,  0,  0,  0,  1,  1,  1,  2, -2, -2, -2, -2, -1, -1, -1,  0,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
   -1, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, -2, -2,
    5,  3,  1, -1, -2, -3, -3, -3,  5,  3,  1, -1, -2, -3, -3, -3,
    5,  3,  1, -1, -2, -3, -3, -3,  5,  3,  1, -1, -2, -3, -3, -3,
    5,  4,  1,  0, -2, -3, -3, -3,  6,  4,  2,  0, -2, -2, -3, -3,
    6,  4,  2,  0, -1, -2, -2, -3,  6,  4,  2,  1, -1, -2, -2, -2,
   -1,  1,  3,  3,  2,  0, -3, -6, -1,  1,  3,  4,  3,  0, -3, -6,
   -1,  1,  4,  4,  3,  1, -3, -6, -1,  1,  3,  4,  3,  1, -3, -6,
   -2,  1,  3,  4,  3,  1, -3, -6, -2,  1,  3,  4,  3,  1, -3, -7,
   -2,  1,  3,  3,  2,  0, -3, -7, -2,  0,  2,  3,  2,  0, -3, -6,
   10,  9,  8,  6,  6,  5,  4,  4,  6,  5,  4,  3,  2,  2,  2,  1,
    2,  1,  0, -1, -2, -2, -2, -1, -1, -2, -3, -4, -4, -4, -4, -3,
   -2, -3, -4, -4, -5, -4, -4, -3, -2, -2, -3, -3, -3, -3, -2, -2,
   -1, -1, -1, -1, -1, -1, -1,  0,  1,  1,  1,  1,  1,  1,  1,  2,
   -2, -1,  1,  2,  4,  5,  7,  8, -3, -2,  0,  1,  3,  5,  7,  8,
   -4, -3, -1,  0,  2,  4,  6,  7, -5, -4, -2, -1,  1,  3,  5,  7,
   -6, -5, -3, -2,  0,  2,  4,  6, -6, -5, -4, -2, -1,  1,  3,  5,
   -7, -6, -5, -3, -2,  0,  2,  3, -8, -7, -5, -4, -3, -1,  1,  2,
   11,  9,  7,  5,  3,  1, -1, -1, 10,  8,  6,  3,  1,  0, -2, -2,
    9,  7,  5,  2,  0, -2, -3, -4,  8,  6,  3,  1, -1, -3, -4, -4,
    6,  4,  2, -1, -3, -4, -5, -5,  5,  3,  0, -2, -4, -5, -6, -6,
    3,  1, -1, -3, -5, -6, -7, -7,  2,  0, -2, -4, -6, -6, -7, -7,
    5,  6,  7,  7,  7,  8,  8,  8,  3,  4,  5,  5,  6,  6,  6,  6,
    0,  2,  2,  3,  4,  4,  4,  5, -2, -1,  0,  1,  2,  2,  3,  3,
   -4, -3, -2, -1,  0,  1,  1,  2, -6, -5, -4, -3, -2, -2, -1,  0,
   -8, -7, -6, -6, -5, -4, -3, -3,-10, -9, -8, -8, -7, -6, -6, -5,
    6,  5,  3,  1, -1, -3, -6, -8,  6,  5,  4,  2, -1, -3, -6, -8,
    6,  5,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2,  0, -3, -6, -8,
    6,  6,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2,  0, -3, -6, -8,
    6,  5,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2, -1, -3, -5, -8,
   11, 10,  9,  8,  7,  6,  5,  4,  8,  8,  7,  6,  5,  4,  3,  2,
    6,  5,  4,  4,  2,  2,  1,  0,  3,  3,  2,  1,  0,  0, -1, -2,
    1,  1,  0, -1, -2, -2, -3, -3, -1, -1, -2, -3, -4, -4, -5, -5,
   -3, -4, -4, -5, -6, -6, -7, -7, -5, -5, -6, -7, -8, -8, -8, -8,
  -14,-13,-12,-11, -9, -7, -6, -4,-12,-11,-10, -9, -7, -5, -3, -1,
  -10, -9, -7, -6, -3, -2,  0,  2, -8, -6, -4, -2,  0,  2,  4,  5,
   -5, -3,  0,  2,  4,  5,  7,  8, -2,  0,  2,  4,  6,  8,  9, 10,
    0,  3,  5,  7,  8, 10, 11, 12,  3,  5,  7,  8, 10, 11, 12, 12,
  -19,-19,-18,-18,-17,-16,-15,-14,-15,-15,-14,-13,-12,-11,-10, -9,
  -11,-10, -9, -8, -6, -5, -4, -3, -6, -5, -3, -2, -1,  0,  1,  2,
   -1,  0,  2,  3,  4,  5,  6,  6,  4,  6,  7,  8,  9, 10, 10, 10,
    9, 10, 11, 12, 13, 14, 14, 14, 12, 14, 14, 15, 16, 16, 16, 16,
   22, 21, 19, 17, 14, 11,  9,  5, 20, 19, 17, 14, 11,  8,  4,  1,
   17, 15, 13, 10,  6,  3,  0, -4, 13, 11,  8,  5,  1, -2, -5, -9,
    9,  6,  3, -1, -4, -7,-11,-13,  4,  0, -3, -6, -9,-12,-15,-17,
   -2, -5, -8,-11,-14,-16,-18,-20, -8,-10,-13,-16,-17,-19,-21,-22,
   17, 18, 18, 18, 17, 16, 16, 14, 16, 16, 15, 15, 14, 13, 12, 11,
   12, 12, 11, 10,  9,  8,  7,  5,  7,  6,  6,  4,  3,  2,  1, -1,
    1,  0, -1, -2, -3, -4, -5, -6, -5, -6, -7, -8, -9,-10,-11,-12,
  -11,-12,-13,-14,-15,-16,-16,-17,-16,-17,-17,-18,-19,-20,-20,-20,
    0,  0,  0,  0, -1, -1, -2, -3,  1,  0,  0,  0,  0, -1, -2, -3,
    1,  1,  0,  0, -1, -1, -2, -2,  1,  1,  1,  0,  0, -1, -1, -2,
    2,  1,  1,  1,  0, -1, -1, -2,  2,  2,  1,  1,  0,  0, -1, -2,
    2,  2,  1,  1,  1,  0, -1, -1,  2,  2,  1,  1,  1,  0,  0, -2,
    0, -1, -1,  0,  0,  1,  2,  3,  0, -1, -1,  0,  1,  1,  2,  2,
   -1, -1, -1, -1,  0,  1,  2,  2, -1, -1, -2, -1,  0,  1,  1,  2,
   -1, -2, -2, -1,  0,  0,  1,  2, -1, -2, -2, -2, -1,  0,  1,  2,
   -1, -1, -2, -1,  0,  0,  1,  2, -1, -1, -1, -1,  0,  1,  1,  2,
    3,  2,  2,  2,  1,  1,  0,  0,  3,  2,  2,  2,  2,  1,  0,  0,
    2,  2,  2,  1,  1,  1,  0,  0,  2,  2,  1,  1,  1,  0,  0, -1,
    1,  1,  1,  0,  0,  0, -1, -1,  0,  0, -1, -1, -1, -1, -1, -1,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -2, -2, -2, -2,
    5,  2,  0,  0, -1,  0,  0,  0,  4,  2,  0, -1, -1, -1,  0, -1,
    4,  1, -1, -1, -2, -1, -1, -1,  4,  1, -1, -1, -2, -1, -1, -1,
    4,  1, -1, -2, -2, -1, -1, -1,  4,  1, -1, -2, -2, -1, -1, -1,
    4,  1, -1, -1, -1, -1, -1, -1,  4,  2,  0, -1,  0,  0,  0, -1,
   -2, -1,  0,  1,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  1,  1,
   -3, -1,  0,  1,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  1,  1,
   -3, -2,  0,  1,  2,  2,  1,  1, -4, -2,  0,  1,  2,  2,  2,  2,
   -5, -3, -1,  1,  1,  2,  1,  2, -5, -3, -2,  0,  1,  1,  1,  1,
    3,  3,  1,  0, -2, -4, -4, -5,  3,  3,  2,  0, -1, -2, -3, -4,
    2,  2,  1,  1,  0, -1, -2, -2,  1,  1,  1,  1,  1,  0,  0,  0,
    0,  0,  0,  1,  1,  1,  1,  1, -2, -1, -1,  0,  0,  1,  2,  2,
   -3, -2, -2, -1,  0,  1,  2,  3, -3, -3, -2, -1,  0,  1,  2,  3,
   -3, -3, -3, -3, -3, -2, -2, -2, -3, -3, -2, -2, -2, -1, -1, -1,
   -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  1,  1,  0,  0,  1,  1,  2,  2,  2,  2,
    1,  1,  1,  2,  2,  3,  3,  3,  2,  2,  2,  2,  3,  3,  3,  3,
   -8, -7, -5, -3, -2, -1,  0, -1, -4, -3, -1,  0,  1,  2,  1,  1,
   -1,  1,  2,  3,  3,  2,  2,  1,  1,  2,  3,  3,  2,  2,  1,  0,
    2,  3,  3,  2,  1,  0,  0, -1,  1,  2,  1,  0, -1, -1, -1, -1,
    1,  1,  0, -1, -1, -2, -2, -1,  1,  1,  0,  0, -1, -1,  0, -1,
   -4, -3, -2,  0,  1,  2,  3,  3, -4, -3, -2,  0,  1,  2,  2,  2,
   -3, -3, -2, -1,  0,  1,  1,  1, -2, -2, -2, -1, -1,  0,  0,  0,
    0, -1, -1, -1, -1, -1, -1, -1,  2,  1,  1,  0,  0, -1, -1, -2,
    3,  3,  3,  1,  0, -1, -2, -2,  5,  4,  4,  2,  1,  0, -1, -2,
    0,  0,  0,  0,  1,  2,  3,  3,  0, -1,  0,  0,  1,  2,  3,  3,
    0, -1,  0,  0,  1,  2,  3,  2,  0,  0,  0,  1,  1,  2,  2,  2,
    2,  1,  1,  1,  1,  1,  1,  0,  2,  2,  2,  1,  0,  0, -1, -2,
    2,  1,  0,  0, -2, -3, -5, -6,  0, -1, -1, -3, -5, -6, -8, -9,
   -2,  0,  1,  2,  2,  1, -1, -4, -2,  0,  2,  2,  2,  1, -1, -4,
   -2,  0,  2,  2,  2,  1, -1, -3, -2,  0,  2,  2,  2,  1, -1, -3,
   -2, -1,  2,  2,  2,  1, -1, -3, -2, -1,  1,  2,  2,  1, -1, -3,
   -3, -1,  1,  2,  2,  1, -1, -3, -2, -1,  1,  2,  2,  1, -1, -3,
   -1,  1,  1, -1, -3, -3,  0,  4, -1,  1,  1, -1, -3, -3,  0,  4,
   -1,  1,  1,  0, -3, -3,  0,  4, -1,  1,  2,  0, -3, -3,  0,  5,
    0,  1,  2,  0, -3, -4,  0,  4,  0,  1,  2,  0, -3, -4,  0,  5,
    0,  1,  2,  0, -3, -3,  0,  4,  0,  1,  2, -1, -2, -2,  0,  4,
    6,  6,  5,  6,  5,  5,  5,  5,  2,  2,  2,  2,  2,  2,  2,  2,
    0,  0,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1, -2, -2, -2, -2,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
   -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    2,  2,  2,  2,  2,  2,  2,  2,  0,  1,  1,  0,  0,  0,  0,  0,
   -1, -2, -2, -2, -2, -2, -2, -1, -3, -3, -3, -3, -3, -3, -3, -2,
   -3, -4, -4, -3, -3, -3, -2, -2, -2, -2, -2, -2, -1, -1,  0,  0,
    0,  1,  1,  1,  2,  2,  3,  3,  3,  4,  4,  5,  5,  6,  6,  6,
    4,  1, -2, -3, -3, -1,  1,  3,  4,  1, -2, -4, -3, -1,  1,  3,
    5,  1, -2, -4, -3, -1,  1,  4,  5,  1, -2, -3, -3, -1,  2,  4,
    5,  1, -2, -3, -3, -1,  2,  4,  4,  0, -3, -4, -3, -1,  2,  4,
    4,  0, -3, -3, -3, -1,  1,  3,  3,  0, -2, -3, -2, -1,  1,  3,
   -3, -4, -4, -4, -4, -4, -4, -4, -1, -1, -1, -1, -1, -1, -2, -2,
    2,  1,  1,  2,  2,  1,  1,  1,  3,  3,  3,  4,  4,  3,  3,  3,
    3,  3,  3,  4,  4,  4,  3,  3,  1,  2,  1,  2,  2,  2,  2,  2,
   -2, -2, -2, -1, -1, -1,  0,  0, -4, -4, -4, -4, -3, -3, -3, -3,
   -1, -2, -3, -3, -2, -2, -1,  0,  0, -1, -2, -2, -2, -1,  0,  1,
    2,  1, -1, -1, -1, -1,  0,  1,  3,  1,  0, -1, -1,  0,  0,  1,
    3,  2,  0, -1,  0,  0,  0,  1,  3,  1,  0, -1,  0,  0,  0,  1,
    3,  1,  0, -1,  0,  0,  0,  1,  2,  1,  0,  0,  0,  0,  0,  1,
    0,  0,  0,  1,  1,  2,  3,  4,  0,  0, -1,  0,  0,  0,  2,  3,
    0, -1, -1, -1, -1, -1,  0,  1,  0, -1, -1, -1, -1, -1, -1,  0,
    0,  0, -1, -1, -1, -2, -2, -1,  1,  0,  0, -1, -1, -2, -2, -1,
    2,  2,  1,  0, -1, -1, -1, -1,  3,  3,  2,  1,  0, -1, -1,  0,
    1,  0,  1,  0,  0, -1, -2, -1,  0,  0,  0,  0, -1, -1, -2, -1,
    0, -1,  0,  0, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,
   -1, -1, -1,  0,  0,  0,  1,  1, -1, -1, -1,  0,  1,  1,  2,  3,
   -2, -2, -1,  0,  1,  2,  3,  4, -2, -2, -1,  0,  1,  2,  4,  5,
   -3, -1,  1,  0,  0, -1,  0,  1, -3,  0,  1,  0, -1, -1,  0,  2,
   -3,  0,  1,  0, -1, -1,  0,  2, -2,  1,  2,  0, -1, -1,  0,  2,
   -2,  1,  2,  0, -1, -1,  0,  2, -2,  1,  2,  0, -1, -1,  0,  2,
   -1,  2,  2,  0, -1, -1,  0,  2, -1,  1,  1,  0, -1, -1, -1,  1,
   -2, -2, -1,  1,  3,  4,  3,  1, -2, -2, -1,  0,  2,  3,  2,  0,
   -2, -2, -1,  0,  1,  2,  1, -1, -1, -1, -1,  0,  1,  2,  1, -1,
   -1, -1, -1,  0,  1,  1,  0, -2,  0, -1, -1,  0,  1,  1,  0, -1,
    0, -1, -1,  0,  1,  1,  1, -1,  0, -1, -1,  0,  0,  1,  0, -1,
   -2, -1,  0,  1,  1,  1,  1,  1, -2, -1,  0,  0,  0,  0,  0,  0,
   -2, -1, -1,  0, -1, -1, -2, -2, -2, -1, -1, -1, -1, -2, -2, -3,
   -1,  0,  1,  1,  0, -1, -2, -2,  1,  2,  3,  3,  2,  1,  0,  0,
    1,  2,  3,  3,  3,  2,  1,  0,  0,  0,  1,  1,  1,  1,  0,  0,
    0, -1, -1, -1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1, -1,  0,  0,  1,  1,  0,  0,  0,
   -3, -2, -1, -1, -1, -1,  0, -1, -5, -5, -4, -3, -2, -2, -2, -1,
    1,  1,  1,  1,  2,  1,  0, -1,  1,  1,  1,  2,  1,  1,  0, -1,
    1,  1,  1,  1,  1,  1,  0, -2,  2,  1,  1,  1,  1,  1,  0, -2,
    1,  1,  0,  0,  0,  0, -1, -3,  1,  1,  0,  0,  0, -1, -2, -3,
    1,  1,  0,  0, -1, -1, -2, -4,  1,  0,  0, -1, -2, -2, -3, -4,
    8,  7,  5,  3,  2,  1,  1,  1,  2,  1,  0,  0, -1, -1, -2, -1,
   -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -1,  0, -1, -1,  0,
    0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  1,  1,  1,  0,  0,  0,
   -1,  0,  0,  0,  0,  0, -1, -1, -2, -2, -1, -1, -1, -2, -2, -1,
    9,  4,  0, -2, -2, -2, -1, -1,  7,  2, -1, -2, -2, -1,  0,  0,
    4,  0, -2, -2, -1,  0,  1,  1,  1, -2, -2, -2, -1,  0,  1,  1,
   -1, -2, -2, -1,  0,  1,  1,  1, -1, -2, -1,  0,  1,  1,  1,  0,
   -1, -1,  0,  1,  1,  1,  0, -1,  0, -1,  0,  1,  0,  0, -1, -1,
    0,  1,  1,  1,  1,  1,  0,  0,  1,  2,  2,  2,  1,  0,  0,  0,
    2,  2,  2,  2,  1,  0, -1, -1,  1,  1,  1,  0, -1, -2, -2, -2,
    0,  0,  0, -1, -2, -3, -2, -2, -1, -1, -1, -2, -2, -2, -1,  0,
   -1, -1, -1, -1,  0,  0,  1,  2, -1, -1, -1,  0,  1,  2,  3,  4,
   -1, -1,  0,  0, -1, -2, -3, -3, -1, -1,  0,  0,  0, -1, -1, -1,
   -2, -2, -1,  0,  1,  1,  1,  1, -2, -2, -2,  0,  1,  2,  3,  3,
   -1, -1, -1,  0,  1,  3,  3,  3,  1,  0,  0,  0,  1,  1,  2,  2,
    2,  2,  1,  0,  0, -1, -1, -1,  3,  2,  1,  0, -1, -2, -3, -3,
   -1, -1, -1, -2, -2, -3, -4, -5,  0,  0,  0, -1, -1, -3, -3, -4,
    1,  1,  1,  0,  0, -1, -2, -3,  2,  2,  2,  1,  1,  0, -1, -1,
    2,  2,  2,  2,  1,  1,  0, -1,  2,  2,  2,  2,  2,  1,  0,  0,
    1,  1,  2,  1,  1,  1,  0,  0,  0,  0,  1,  1,  0,  0,  0, -1,
   -2,  2,  3,  1, -1,  1,  1, -1, -3,  2,  3,  0, -1,  1,  1, -1,
   -3,  2,  3,  0, -1,  1,  1, -1, -4,  2,  3,  0, -1,  1,  1, -2,
   -4,  1,  3,  0, -1,  1,  1, -2, -4,  1,  3, -1, -2,  1,  1, -2,
   -3,  1,  2,  0, -1,  1,  1, -2, -3,  1,  2,  0, -1,  1,  1, -1,
   -1, -1, -1, -2, -2, -2, -2, -2,  1,  1,  1,  1,  0,  0,  0,  0,
    1,  2,  2,  2,  2,  2,  2,  2,  0,  0,  1,  1,  1,  2,  2,  2,
   -2, -2, -1, -1, -1,  0,  0,  0, -3, -3, -3, -3, -3, -3, -3, -2,
   -1, -1, -1, -1, -2, -2, -2, -2,  4,  4,  4,  4,  4,  3,  3,  2,
   -3, -3, -2, -1,  0,  1,  2,  5, -3, -3, -3, -2, -1,  1,  3,  6,
   -3, -3, -2, -2,  0,  2,  3,  5, -3, -2, -2, -2,  0,  1,  3,  5,
   -2, -2, -2, -1, -1,  1,  3,  5, -2, -2, -1, -1,  0,  1,  2,  4,
   -1, -1, -1, -1,  0,  1,  1,  4, -1, -1, -1, -1,  0,  1,  2,  3,
    0, -1,  0,  1,  1,  0, -1, -1,  0,  0,  0,  1,  2,  0, -1, -1,
    1,  0, -1,  0,  1,  0,  0,  0,  1, -1, -2, -1,  0,  0,  0,  0,
    1, -2, -3, -1,  0,  0,  0,  1,  1, -1, -3, -2,  0,  1,  1,  2,
    1, -1, -2, -1,  0,  1,  1,  2,  2,  0, -1,  0,  1,  1,  2,  2,
    1,  1,  1,  1,  0,  0,  1,  2, -1,  0,  0, -1,  0,  0,  0,  1,
   -3, -2, -1, -1, -1,  0,  1,  1, -4, -2, -1,  0,  0,  1,  1,  1,
   -3, -2,  0,  0,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  0,  0,
   -1,  0,  1,  1,  1,  0,  0, -1,  0,  1,  2,  2,  1,  0,  0, -1,
   -4, -4, -4, -3, -2, -1, -1, -1, -2, -2, -2, -1,  0,  0,  0,  0,
   -1,  0,  0,  0,  1,  1,  1,  1,  0,  0,  1,  1,  1,  1,  1,  1,
    0,  0,  1,  1,  2,  2,  1,  0,  0,  0,  1,  1,  1,  1,  1,  0,
    0,  0,  0,  1,  1,  1,  1,  0, -1,  0,  0,  1,  1,  1,  0,  0,
    1,  2,  2,  2,  1, -1, -2, -4,  1,  1,  2,  2,  1,  0, -2, -4,
    0,  1,  1,  1,  1,  0, -1, -3, -1,  0,  1,  1,  0,  0, -1, -2,
   -1,  0,  1,  1,  1,  0,  0, -1, -2, -1,  0,  0,  0,  0,  0, -1,
   -1, -1,  0,  1,  1,  0,  0,  0, -1,  0,  1,  1,  1,  1,  1,  0,
    2,  2,  0, -1, -2, -1, -1, -2,  1,  1, -1, -2, -2, -1, -1, -2,
    1,  1, -1, -2, -2,  0,  0, -1,  1,  1,  0, -2, -1,  1,  1,  0,
    1,  1,  0, -1, -1,  1,  2,  1,  1,  1,  0, -1, -1,  1,  2,  1,
    1,  1,  0, -1, -1,  1,  1,  1,  1,  1,  0, -1,  0,  1,  1,  1,
    0,  0, -1, -2, -4, -4, -4, -4,  3,  3,  3,  2,  1,  0,  0,  0,
    3,  3,  3,  3,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  1,
   -1, -1, -1, -1, -1, -1, -1,  0,  0, -1,  0,  0, -1,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1, -1,  0,
   -1, -1,  0, -1, -1,  1,  2, -1,  1,  1,  0,  0,  0,  2,  3, -1,
    1,  1,  0, -1, -1,  1,  3, -1,  1,  1,  0, -2, -2,  0,  1, -2,
    1,  0,  0, -2, -2,  0,  1, -3,  0,  0,  0,  0, -1,  1,  1, -3,
    0,  1,  1,  0,  1,  2,  1, -3, -1,  0,  1,  1,  1,  2,  1, -4,
   -4, -3,  0,  1,  1,  1,  0,  0, -4, -2,  0,  1,  1,  1,  0, -1,
   -3, -1,  1,  1,  1,  0, -1, -1, -1,  1,  1,  1,  1,  0, -1,  0,
    1,  2,  2,  1,  0, -1,  0,  0,  2,  2,  1,  0, -1, -1,  0,  1,
    2,  1,  0, -1, -2, -1,  0,  1,  2,  2,  0, -1, -2, -1,  1,  1,
    1,  1,  0,  0, -1, -1, -1, -1,  0, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -1, -1, -1, -1, -1,
    1,  0,  0, -1, -1, -1, -1, -1,  2,  1,  0,  0, -1, -1, -1, -1,
    5,  3,  2,  1,  0,  0,  0,  0,  6,  5,  3,  2,  1,  0,  0,  0,
    4,  4,  3,  1,  0,  0,  0,  1,  3,  3,  2,  1,  0,  0,  0,  1,
    2,  2,  1,  0, -1, -1,  0,  1,  0,  0,  0, -1, -1, -1,  0,  1,
    0,  0, -1, -1, -2, -1,  0,  2,  0, -1, -1, -2, -2, -2,  0,  1,
    0, -1, -1, -2, -2, -2, -1,  0,  0,  0, -1, -2, -2, -2, -1,  0,
    0,  0, -1, -1, -1,  0,  2,  3,  0, -1, -2, -2, -1, -1,  1,  2,
    1,  0, -1, -1, -1,  0,  0,  0,  1,  1,  1,  0,  0,  0, -1, -1,
    1,  2,  1,  0,  0, -1, -1, -1, -1,  0,  0,  0, -1, -1, -1, -1,
   -3, -2, -1, -1,  0,  1,  1,  2, -4, -3, -1,  1,  2,  3,  5,  5,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,
    0,  0,  0, -1,  0,  0,  0,  1, -1, -1, -2, -2, -2, -1, -1,  0,
    0,  0,  0,  0,  0,  1,  1,  1,  2,  2,  2,  2,  2,  3,  3,  3,
    1,  1,  1,  1,  2,  2,  1,  1, -4, -3, -4, -4, -4, -4, -3, -3,
   -1,  0,  1,  2,  2,  3,  3,  3, -1, -1, -1, -1,  0,  0,  0,  0,
    0,  0, -1, -2, -2, -3, -3, -2,  3,  2,  1,  0, -1, -2, -2, -2,
    4,  3,  2,  1,  1,  0,  0,  0,  2,  2,  1,  1,  0,  1,  1,  1,
    0, -1, -1, -1, -1,  0,  0,  1, -2, -2, -2, -2, -2, -1,  0,  0,
    1, -1,  0,  2,  1, -2, -1,  1,  1, -1,  0,  2,  1, -2, -2,  1,
    1, -1,  0,  3,  2, -2, -1,  1,  0, -2,  0,  3,  2, -2, -2,  1,
    0, -2,  0,  3,  2, -2, -2,  1,  0, -2,  0,  3,  1, -2, -1,  1,
    0, -2,  0,  2,  1, -2, -2,  1,  0, -1,  0,  2,  1, -2, -1,  1,
    0,  1,  2,  2,  3,  3,  2,  2,  0,  1,  1,  2,  3,  3,  2,  1,
    0,  0,  1,  2,  2,  2,  2,  1, -1,  0,  0,  1,  1,  1,  1,  1,
   -1, -1,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1, -1, -1,
   -2, -2, -2, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -1,
    0,  0, -1, -2, -1,  0,  3,  5,  0,  0, -1, -1, -1,  0,  2,  4,
    1,  1,  0,  0, -1, -1,  1,  2,  1,  2,  1,  1,  0, -1, -1,  0,
    0,  1,  2,  1,  0, -1, -2, -2, -1,  0,  1,  2,  1,  0, -3, -3,
   -2, -1,  1,  2,  2,  0, -2, -4, -2, -1,  0,  2,  2,  1, -1, -3,
    0,  0,  0,  0,  0,  0, -1, -1,  0,  0, -1,  0,  0,  0,  0,  0,
   -1, -1, -1, -1,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1, -1,  0,
   -1, -1, -1, -1, -1, -1, -1,  0, -1,  0,  0,  0,  0, -1, -1,  0,
    0,  0,  1,  1,  0,  0,  0,  1,  3,  3,  3,  4,  3,  3,  3,  3,
    5,  1, -2, -2,  0,  0,  0, -1,  4, -1, -3, -1,  0,  0,  0, -1,
    3, -1, -1,  0,  1,  1,  0, -1,  2,  0,  0,  1,  1,  1,  0, -2,
    1,  0,  0,  1,  1,  1,  0, -2,  0, -1, -1, -1,  0,  0,  0, -1,
    0, -1, -1, -1, -1,  0,  0, -1,  2,  1,  0,  0,  0,  1,  0,  0,
    1,  0,  1,  1,  1,  1,  0,  0,  1,  0,  0,  1,  1,  0,  0,  0,
    1, -1, -1,  0,  0,  0,  0,  0,  2,  0, -1, -1, -1, -1, -1,  0,
    3,  1, -1, -1, -2, -2, -2, -1,  4,  2,  1,  0, -1, -2, -2, -1,
    2,  1,  0,  0, -1, -1,  0,  0,  0, -1, -1, -1, -1,  0,  1,  1,
    0,  1,  2,  2,  2,  1, -1, -3,  0,  0,  1,  1,  1,  0, -1, -2,
    0,  0,  0,  0,  0,  0, -1, -1,  0,  0, -1,  0,  0,  1,  1,  0,
    0,  0, -1,  0,  1,  1,  1,  1,  0,  0,  0,  0,  1,  1,  1,  0,
    0,  0,  1,  1,  2,  1, -1, -3,  0,  0,  0,  1,  1, -1, -4, -5,
   -2, -2, -2, -1,  0,  2,  2,  2,  0,  0,  0,  0,  1,  1,  1,  0,
    1,  1,  1,  1,  1,  0, -2, -3,  0,  0,  1,  1,  0, -1, -3, -4,
   -1, -1,  0,  1,  0,  0, -2, -3, -1, -1,  0,  1,  1,  1,  0, -1,
    0,  0,  0,  1,  1,  1,  1,  0,  1,  1,  1,  1,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  1,  1,  2,  1,  2,  0,  0,  0,  0, -1,  1,
    0,  2,  0, -1,  1,  0, -1,  0,  0,  1,  0,  0,  2,  1,  0,  1,
    0,  1, -1,  0,  2,  2,  0,  1, -1,  0, -1, -1,  2,  1,  1,  2,
   -2, -2, -3, -2,  0,  1,  1,  1, -2, -2, -3, -3, -1, -1, -1,  0,
   -3, -1,  0,  1,  2,  1,  1,  0, -3, -1,  0,  1,  2,  1,  1,  1,
   -2,  0,  0,  1,  1,  1,  1,  1, -1,  0,  0,  0,  0,  0,  0,  0,
   -2,  0,  0,  0,  0, -1, -1,  0, -2,  0,  0,  0,  0,  0, -1, -1,
   -3,  0,  1,  1,  1,  1,  0,  1, -5, -2,  0,  1,  2,  2,  1,  2,
   -2, -1, -1,  0,  0,  1,  2,  3,  0,  0,  1,  1,  0,  0,  1,  2,
    0,  0,  1,  0, -1, -1,  0,  1, -1, -1, -1, -1, -2, -2, -1,  0,
   -2, -2, -2, -2, -2, -1,  0,  1,  0,  0,  0, -1,  0,  1,  2,  2,
    2,  1,  0,  0,  0,  1,  2,  2,  2,  1,  0, -1, -1, -1,  0,  0,
    0,  1,  1,  1,  1,  1, -1, -4, -1, -1,  0,  1,  1,  1,  0, -3,
   -2, -1,  0,  0,  1,  2,  2, -2, -1,  0,  0,  0,  0,  2,  3, -1,
   -1,  0,  0,  0,  0,  1,  2,  0,  0,  0, -1, -2, -1,  1,  1,  0,
    0,  0, -1, -2, -2,  0,  2,  1,  0,  0, -1, -2, -1,  1,  2,  2,
    1,  0,  0,  0, -2, -3, -2, -3,  0,  0,  1,  0, -2, -2, -1, -1,
    0, -1,  1,  1, -1, -1,  0,  0,  0, -1,  1,  1, -1, -1,  0,  0,
    0,  1,  2,  1, -1, -1,  0,  1,  1,  2,  3,  2,  0,  0,  1,  2,
   -1,  0,  2,  1,  0,  0,  2,  3, -2, -1,  0,  0, -1,  0,  1,  2,
    1,  1,  0, -1, -2, -2, -1,  1,  1,  1,  1, -1, -2, -2,  0,  2,
    1,  1,  1, -1, -1, -1,  0,  2,  0,  0,  0,  0,  0,  0,  1,  2,
   -1, -1, -1,  0,  0,  0,  1,  2, -1, -2, -1,  1,  1,  1,  0,  0,
   -1, -2, -1,  1,  2,  2,  0, -1, -1, -2, -1,  2,  2,  2,  0, -1,
   -1, -1, -1, -2, -1, -1,  0,  1,  0,  0, -1, -1, -1,  0,  1,  2,
    1,  0,  0,  0,  0,  1,  1,  2,  1,  1,  0,  0,  1,  1,  1,  1,
    1,  1,  0,  1,  1,  0,  1,  1,  1,  1,  1,  1,  0, -1, -1, -1,
    1,  2,  1,  0, -1, -2, -2, -3,  2,  2,  1,  0, -2, -3, -4, -4,
   -4, -2,  1,  1,  1,  1,  0,  0, -2,  0,  1,  0,  0,  0,  0,  0,
    0,  1,  1, -2, -2, -1,  0,  1,  2,  2,  1, -2, -2, -1,  1,  2,
    1,  2,  1, -2, -2, -1,  1,  2, -1,  1,  1, -1, -1, -1,  0,  1,
   -2,  0,  1,  1,  0, -1, -1,  0, -2,  0,  2,  2,  1, -1, -1,  0,
    1,  1,  0,  0,  0,  1,  0,  0, -2, -3, -3, -2, -2, -1,  0,  0,
   -3, -4, -3, -2, -1,  0,  0,  0, -1, -1,  0,  1,  2,  3,  2,  1,
    0,  1,  2,  3,  3,  3,  2,  1,  1,  1,  1,  2,  1,  0,  0, -1,
    0,  0,  0,  0, -1, -1, -1, -1,  0, -1, -1,  0,  0,  0,  0,  0,
    1,  1,  0,  0, -1, -1,  0,  2,  0,  0,  1,  0, -1, -1,  1,  1,
   -2, -1,  0,  1,  1,  1,  1,  1, -3, -3,  0,  2,  2,  1,  1,  0,
   -2, -2,  0,  1,  1,  1,  0,  0,  1,  0,  0,  0,  0,  0, -1, -1,
    3,  1, -1, -3, -2, -1,  0,  1,  4,  2, -1, -3, -3, -1,  1,  2,
    0,  0,  0, -1, -1, -1, -1, -1,  1,  2,  1,  0,  0,  0, -1, -1,
    2,  3,  3,  2,  1,  0, -1, -1,  3,  4,  4,  2,  1,  0, -1, -2,
    3,  3,  2,  1,  0, -1, -2, -2,  1,  1,  0, -1, -1, -2, -2, -3,
    0,  0,  0, -1, -1, -2, -2, -2, -1, -1, -1, -1, -1, -2, -2, -1,
    1,  2,  2,  2,  2,  1,  2,  2,  0,  1,  1,  1,  1,  0,  0,  0,
    0,  0,  0,  1,  1,  0, -1, -2,  0,  0,  0,  0,  1,  0, -1, -4,
    1,  0,  0,  0,  0,  0, -2, -5,  1,  0,  0,  0,  0,  0, -1, -4,
    1,  0, -1,  0,  0,  0, -1, -3,  0, -1, -1,  0,  1,  1,  1, -1,
   -2, -1,  0,  0, -1, -1, -1, -2, -1,  0,  0,  0, -1, -1, -2, -2,
    0,  1,  1,  0, -1, -1, -1, -2,  0,  1,  1,  0,  0,  0, -1, -1,
    0,  1,  0,  0,  1,  1,  1,  0,  1,  1,  0,  0,  1,  2,  2,  1,
    1,  1,  0,  0,  1,  2,  2,  1,  1,  1,  0, -1,  0,  1,  1,  0,
    4,  2,  1,  0,  0,  1,  1,  1,  4,  2,  1,  0,  0,  0,  0,  1,
    3,  1,  0,  0, -1, -1, -1,  0,  1,  0,  0, -1, -1, -2, -1,  0,
    0,  0,  0,  0, -1, -1, -1,  0, -1, -1,  0,  0, -1, -1,  0,  1,
   -2, -1,  0, -1, -1,  0,  0,  1, -2, -2, -1, -2, -1,  0,  0,  1,
    0,  1,  1,  1,  2,  1,  0, -1, -1, -1, -1,  0,  0, -1, -2, -2,
   -1,  0, -1,  0,  0, -1, -2, -1,  0,  0,  0,  0,  0,  0,  1,  2,
    0,  0,  0,  0,  0,  0,  2,  3, -1,  0, -1, -1, -1, -1,  0,  3,
   -1,  0,  0, -1, -1, -2,  0,  3,  0,  0,  0,  0, -1, -1,  1,  4,
    2,  2,  0,  0,  0,  0,  0,  1,  1,  1, -1, -2, -1, -2, -1,  1,
   -1, -1, -2, -2, -2, -3, -2,  0, -1,  0, -1, -1, -1, -2, -1,  1,
    1,  1,  0,  0,  1,  0,  0,  1,  2,  2,  0,  0,  1,  0,  0,  1,
    2,  2,  0,  0,  0,  0, -1, -1,  2,  2,  0,  0,  1,  0, -1, -1,
   -1,  0,  1,  1,  0, -1, -1, -1,  1,  2,  3,  2,  1,  0,  0,  0,
    0,  1,  1,  1,  0, -1,  0,  0, -2, -2, -1,  0,  1,  0,  0,  0,
   -2, -2, -1,  2,  2,  2,  1,  0, -2, -1,  0,  1,  1,  0,  0, -1,
   -1, -1,  0,  0, -1, -2, -1, -2,  0,  1,  1,  1,  0,  0,  1,  1,
   -3, -3, -3, -2, -1, -1, -2, -2, -1, -1,  0,  1,  2,  1,  0,  0,
    1,  1,  1,  2,  2,  1,  0,  0,  1,  1,  1,  1,  1,  0, -1,  1,
    1,  0, -1, -1,  0,  0, -1,  1,  0, -1, -1, -1,  0, -1, -1,  1,
    1,  0, -1,  0,  0, -1,  0,  2,  2,  0, -1,  0,  0,  0,  0,  2,
    1,  0, -2, -1,  0,  1,  1,  0,  2,  0, -1, -1,  0,  1,  1,  0,
    1,  0, -2, -1,  0,  1,  0, -1,  1,  0, -1, -1,  0,  1,  0, -1,
    0,  1,  1,  0,  1,  1,  0,  0, -2,  1,  2,  1,  0,  0,  0,  1,
   -5,  0,  2,  1,  0, -1,  0,  1, -6, -1,  2,  1,  0, -1,  0,  0,
    5,  3,  0, -1, -2, -1, -1, -1,  1,  1,  0, -1, -1,  0, -1, -1,
   -1,  0,  1,  1,  2,  2,  1,  0, -2, -1,  0,  1,  2,  1,  1,  1,
   -2, -1, -1, -1,  0, -1,  0,  1,  0,  1,  0,  0, -1, -1,  0,  0,
    0,  1,  1,  1,  1,  0,  0,  0, -3, -2,  0,  1,  1,  0,  0, -1,
   -1,  0,  1,  0, -1,  0,  2,  3, -1,  0,  0, -2, -4, -2, -1,  0,
    0,  1,  1,  0, -2, -1,  0, -1,  1,  2,  3,  1,  0,  1,  1,  0,
   -1,  0,  1,  1,  1,  1,  1,  0, -2, -3, -2,  0,  0,  0,  1,  0,
   -1, -2, -2,  0,  1,  0,  0, -1,  3,  1,  0,  0,  1,  0, -1, -1,
   -2, -1,  0,  0, -1, -1,  0,  0, -1,  0,  0,  0,  0,  1,  1,  1,
   -1, -1, -1,  0,  1,  1,  1,  1,  0, -2, -3, -1,  1,  0,  0,  0,
    1, -1, -3, -1,  1,  1,  0, -1,  3,  1, -1,  1,  2,  2,  0, -1,
    3,  1,  0,  1,  2,  1,  1,  0,  0, -2, -2, -1, -1,  0,  0,  0,
    1,  0, -1, -1,  1,  2,  1,  0,  0, -1, -2, -1,  1,  2,  2,  1,
   -1, -1, -1,  0,  0,  1,  2,  0, -2,  0,  0,  0,  0,  0,  1, -1,
   -1,  0,  1,  0, -1, -1, -1, -1,  0,  1,  1,  2,  0, -2, -1,  0,
    1,  2,  2,  2,  1, -1, -1,  0,  0,  1,  1,  1,  0, -2, -2, -1,
    0,  0, -1, -1, -1, -1, -2, -2,  0,  0, -1,  0,  1,  2,  2,  1,
    0,  0, -1, -1,  0,  1,  2,  2,  1,  1, -1, -2, -1, -1, -1, -1,
    2,  2,  1,  0,  0, -1, -2, -2,  1,  2,  2,  1,  0,  0, -2, -2,
    0,  0,  0,  0,  1,  1,  0, -1,  0, -1, -1, -1,  2,  3,  2,  1,
    0, -2,  1,  2, -1,  0,  0,  1, -1, -2,  2,  3, -1,  0,  0,  0,
    0, -2,  2,  3, -1, -1,  0,  0,  0, -1,  3,  2, -2,  0,  1,  0,
    0, -1,  3,  1, -2,  0,  1,  0,  0, -1,  2,  1, -1,  1,  0, -1,
    0,  0,  1, -1, -2,  0,  0, -1,  1,  0,  0, -2, -2, -1, -1, -1,
    1,  1,  1,  1,  1, -1, -1, -2,  0,  0,  0,  1,  1,  1,  1,  1,
    0,  0,  0,  1,  1,  1,  2,  3,  1,  0,  0, -1,  0,  0,  1,  2,
    0, -1, -1, -2, -1,  0,  1,  2, -2, -2, -2, -2, -1,  0,  1,  1,
   -1, -1, -1, -1,  0,  0,  0, -1,  2,  2,  2,  0, -1, -1, -2, -4,
   -1, -2, -1, -1,  0,  1,  2,  3, -1, -1, -1, -1,  0,  1,  2,  3,
    1,  0, -1,  0, -1,  0,  1,  2,  1,  0,  0,  0, -1,  0,  2,  2,
    1,  0, -1, -1, -2,  0,  1,  2,  0, -2, -2, -2, -3, -1,  0,  1,
    0, -2, -2, -2, -2, -1,  1,  1,  0,  0,  0,  0,  0,  1,  2,  2
};

/* list of codebooks for intra-coded vectors */
static uint8_t *intra_codebooks[4] = {
  intra_codebook_4x2, intra_codebook_4x4, intra_codebook_8x4, intra_codebook_8x8
};

/* block type, codes 000 .. 1xx */
static vlc_code_t block_type_table[8] = {
  { SVQ1_BLOCK_INTRA, 3 }, { SVQ1_BLOCK_INTER_4V, 3 },
  { SVQ1_BLOCK_INTER, 2 }, { SVQ1_BLOCK_INTER,    2 },
  { SVQ1_BLOCK_SKIP,  1 }, { SVQ1_BLOCK_SKIP,     1 },
  { SVQ1_BLOCK_SKIP,  1 }, { SVQ1_BLOCK_SKIP,     1 }
};

/* motion vector, codes 0000011 .. 011xxxx */
static vlc_code_t motion_table_0[61] = {
  { 7, 8 }, { 6, 8 }, { 5, 8 }, { 4, 7 }, { 4, 7 },
  { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 },
  { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
  { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }
};

/* motion vector, codes 000000000010 ... 0000010111xx */
static vlc_code_t motion_table_1[94] = {
  {32, 13}, {31, 13}, {30, 12}, {30, 12}, {29, 12}, {29, 12},
  {28, 12}, {28, 12}, {27, 12}, {27, 12}, {26, 12}, {26, 12}, {25, 12}, {25, 12},
  {24, 11}, {24, 11}, {24, 11}, {24, 11}, {23, 11}, {23, 11}, {23, 11}, {23, 11},
  {22, 11}, {22, 11}, {22, 11}, {22, 11}, {21, 11}, {21, 11}, {21, 11}, {21, 11},
  {20, 11}, {20, 11}, {20, 11}, {20, 11}, {19, 11}, {19, 11}, {19, 11}, {19, 11},
  {18, 11}, {18, 11}, {18, 11}, {18, 11}, {17, 11}, {17, 11}, {17, 11}, {17, 11},
  {16, 11}, {16, 11}, {16, 11}, {16, 11}, {15, 11}, {15, 11}, {15, 11}, {15, 11},
  {14, 11}, {14, 11}, {14, 11}, {14, 11}, {13, 11}, {13, 11}, {13, 11}, {13, 11},
  {12, 11}, {12, 11}, {12, 11}, {12, 11}, {11, 11}, {11, 11}, {11, 11}, {11, 11},
  {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10},
  { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10},
  { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10},
};

/* inter-coded vector codebook count tables, codes 000000 ... 111111 */
static vlc_code_t inter_vector_tables[6][64] = {
  /* 4x2 vector, codes 0000xxx ... 11xxxxx */
  { { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 } },

  /* 4x4 vector, codes 0000xxx ... 11xxxxx */
  { { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 } },

  /* 8x4 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 8x8 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 16x8 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 16x16 vector, codes 000000x ... 1xxxxxx */
  { { 6, 6 }, { 5, 6 }, { 4, 5 }, { 4, 5 }, { 3, 5 }, { 3, 5 }, { 2, 5 }, { 2, 5 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } }
};

/* vector codebook count tables, codes 0000000 ... 1111111 */
static vlc_code_t intra_vector_tables[6][128] = {
  /* 4x2 vector, codes 00000xx ... 1xxxxxx */
  { { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 4x4 vector, codes 0000xxx ... 11xxxxx */
  { { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 } },

  /* 8x4 vector, codes 00000xx ... 1xxxxxx */
  { { 2, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },  
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 8x8 vector, codes 000000x ... 1xxxxxx */
  { { 2, 6 }, { 2, 6 }, {-1, 6 }, {-1, 6 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 16x8 vector, codes 000000x ... 1xxxxxx */
  { { 4, 6 }, { 4, 6 }, {-1, 6 }, {-1, 6 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 },
    { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 16x16 vector, codes 0000000 ... 1xxxxxx */
  { { 5, 7 }, {-1, 7 }, { 4, 6 }, { 4, 6 }, { 6, 5 }, { 6, 5 }, { 6, 5 }, { 6, 5 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } }
};

/* intra mean value, codes 00100101 ... 1111xxxx */
static vlc_code_t intra_mean_table_0[219] = {
  {135, 8 }, {136, 8 }, {165, 8 },
  {134, 8 }, {129, 8 }, {164, 8 }, {163, 8 }, {133, 8 }, {162, 8 }, {174, 8 }, {175, 8 },
  {161, 8 }, {160, 8 }, {159, 8 }, {158, 8 }, {157, 8 }, {156, 8 }, {155, 8 }, {154, 8 },
  {153, 8 }, {151, 8 }, {152, 8 }, {132, 8 }, {110, 8 }, {131, 8 }, {108, 8 }, {130, 8 },
  {166, 8 }, {105, 8 }, {104, 8 }, {103, 8 }, {127, 8 }, {101, 8 }, {167, 8 }, {168, 8 },
  { 98, 8 }, {128, 8 }, { 48, 8 }, { 95, 8 }, { 62, 8 }, { 93, 8 }, { 92, 8 }, { 91, 8 },
  { 90, 8 }, { 89, 8 }, { 60, 8 }, { 87, 8 }, { 86, 8 }, { 57, 8 }, { 84, 8 }, { 83, 8 },
  { 82, 8 }, { 81, 8 }, { 80, 8 }, { 79, 8 }, { 78, 8 }, { 77, 8 }, { 76, 8 }, { 75, 8 },
  { 74, 8 }, { 73, 8 }, { 72, 8 }, { 71, 8 }, { 70, 8 }, { 69, 8 }, { 68, 8 }, { 67, 8 },
  { 66, 8 }, { 65, 8 }, { 56, 8 }, { 63, 8 }, { 23, 8 }, { 61, 8 }, { 30, 8 }, { 59, 8 },
  { 58, 8 }, { 52, 8 }, { 29, 8 }, { 55, 8 }, { 54, 8 }, { 53, 8 }, { 50, 8 }, { 51, 8 },
  { 22, 8 }, { 49, 8 }, { 85, 7 }, { 85, 7 }, { 97, 7 }, { 97, 7 }, { 88, 7 }, { 88, 7 },
  { 64, 7 }, { 64, 7 }, { 94, 7 }, { 94, 7 }, {106, 7 }, {106, 7 }, {107, 7 }, {107, 7 },
  {109, 7 }, {109, 7 }, {111, 7 }, {111, 7 }, {112, 7 }, {112, 7 }, {113, 7 }, {113, 7 },
  {114, 7 }, {114, 7 }, {115, 7 }, {115, 7 }, {116, 7 }, {116, 7 }, {117, 7 }, {117, 7 },
  {118, 7 }, {118, 7 }, {119, 7 }, {119, 7 }, {120, 7 }, {120, 7 }, { 99, 7 }, { 99, 7 },
  {102, 7 }, {102, 7 }, { 28, 7 }, { 28, 7 }, {100, 7 }, {100, 7 }, { 96, 7 }, { 96, 7 },
  {139, 7 }, {139, 7 }, { 24, 7 }, { 24, 7 }, {  1, 7 }, {  1, 7 }, {138, 7 }, {138, 7 },
  {121, 7 }, {121, 7 }, {122, 7 }, {122, 7 }, {123, 7 }, {123, 7 }, {124, 7 }, {124, 7 },
  {125, 7 }, {125, 7 }, {126, 7 }, {126, 7 }, {137, 7 }, {137, 7 }, {140, 7 }, {140, 7 },
  {150, 7 }, {150, 7 }, {144, 7 }, {144, 7 }, {141, 7 }, {141, 7 }, {142, 7 }, {142, 7 },
  {143, 7 }, {143, 7 }, {145, 7 }, {145, 7 }, {147, 7 }, {147, 7 }, {146, 7 }, {146, 7 },
  { 27, 6 }, { 27, 6 }, { 27, 6 }, { 27, 6 }, {148, 6 }, {148, 6 }, {148, 6 }, {148, 6 },
  {149, 6 }, {149, 6 }, {149, 6 }, {149, 6 }, {  0, 6 }, {  0, 6 }, {  0, 6 }, {  0, 6 },
  { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 },
  { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 },
  { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 },
  { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }
};

/* intra mean value, codes 0000001101 ... 001001001x */
static vlc_code_t intra_mean_table_1[135] = {
  {218, 10}, {219, 10}, {220, 10},
  {221, 10}, {222, 10}, {217, 10}, {230, 10}, {215, 10}, {208, 10}, {207, 10}, {206, 10},
  {214, 10}, {204, 10}, {223, 10}, {224, 10}, {225, 10}, {226, 10}, {227, 10}, {228, 10},
  {229, 10}, {213, 10}, {212, 10}, {231, 10}, {232, 10}, {211, 10}, {210, 10}, {236, 10},
  {209, 10}, {216, 10}, {205, 10}, { 18, 10}, {186, 9 }, {186, 9 }, {185, 9 }, {185, 9 },
  {184, 9 }, {184, 9 }, {182, 9 }, {182, 9 }, {183, 9 }, {183, 9 }, {180, 9 }, {180, 9 },
  {181, 9 }, {181, 9 }, {178, 9 }, {178, 9 }, {187, 9 }, {187, 9 }, {176, 9 }, {176, 9 },
  {188, 9 }, {188, 9 }, {179, 9 }, {179, 9 }, {173, 9 }, {173, 9 }, {172, 9 }, {172, 9 },
  {171, 9 }, {171, 9 }, {170, 9 }, {170, 9 }, {169, 9 }, {169, 9 }, {189, 9 }, {189, 9 },
  {190, 9 }, {190, 9 }, {191, 9 }, {191, 9 }, {192, 9 }, {192, 9 }, {193, 9 }, {193, 9 },
  {194, 9 }, {194, 9 }, {195, 9 }, {195, 9 }, {196, 9 }, {196, 9 }, {197, 9 }, {197, 9 },
  {198, 9 }, {198, 9 }, {200, 9 }, {200, 9 }, {201, 9 }, {201, 9 }, {202, 9 }, {202, 9 },
  {203, 9 }, {203, 9 }, {199, 9 }, {199, 9 }, {177, 9 }, {177, 9 }, { 40, 9 }, { 40, 9 },
  { 39, 9 }, { 39, 9 }, { 38, 9 }, { 38, 9 }, { 37, 9 }, { 37, 9 }, { 36, 9 }, { 36, 9 },
  { 35, 9 }, { 35, 9 }, { 34, 9 }, { 34, 9 }, { 33, 9 }, { 33, 9 }, { 32, 9 }, { 32, 9 },
  { 31, 9 }, { 31, 9 }, { 21, 9 }, { 21, 9 }, { 11, 9 }, { 11, 9 }, { 41, 9 }, { 41, 9 },
  { 45, 9 }, { 45, 9 }, { 44, 9 }, { 44, 9 }, { 42, 9 }, { 42, 9 }, { 43, 9 }, { 43, 9 },
  { 47, 9 }, { 47, 9 }, { 46, 9 }, { 46, 9 }
};

/* intra mean value, codes 00000000000001 ... 00000011001xxx */
static vlc_code_t intra_mean_table_2[207] = {
  {255, 14}, { 14, 14}, { 13, 14}, { 17, 12}, { 17, 12}, { 17, 12}, { 17, 12},
  {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11},
  {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11},
  {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11},
  {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11},
  {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11},
  {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11},
  {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11},
  {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11},
  {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11},
  {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11},
  {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11},
  { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11},
  {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11},
  {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11},
  {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11},
  {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11},
  {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11},
  {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11},
  {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11},
  { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11},
  { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11},
  {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11},
  {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11},
  { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11},
  {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}
};

/* intra mean value, codes 00000000000000000000 ... 000000000000001xxxxx */
static vlc_code_t intra_mean_table_3[64] = {
  {  6, 20}, {  3, 20}, {  4, 20}, {  5, 20}, {  7, 20}, {  8, 20}, {  9, 19}, {  9, 19},
  {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17},
  { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16},
  { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}
};

/* inter mean value, codes 00001011 ... 1xxxxxxx */
static vlc_code_t inter_mean_table_0[245] = {
  { 10, 8 }, { 12, 8 }, { 11, 8 }, {-11, 8 }, {-12, 8 },
  {-10, 8 }, { -9, 8 }, { -7, 7 }, { -7, 7 }, { -6, 7 }, { -6, 7 }, {  8, 7 }, {  8, 7 },
  { -8, 7 }, { -8, 7 }, {  9, 7 }, {  9, 7 }, {  6, 7 }, {  6, 7 }, {  7, 7 }, {  7, 7 },
  { -5, 6 }, { -5, 6 }, { -5, 6 }, { -5, 6 }, { -4, 6 }, { -4, 6 }, { -4, 6 }, { -4, 6 },
  {  5, 6 }, {  5, 6 }, {  5, 6 }, {  5, 6 }, {  4, 6 }, {  4, 6 }, {  4, 6 }, {  4, 6 },
  {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 },
  {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 },
  { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 },
  { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 },
  { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 },
  { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }
};

/* inter mean value, codes 000000010010 ... 00001011xxxx */
static vlc_code_t inter_mean_table_1[158] = {
  {-30, 12}, {-31, 12}, {-32, 12}, {-33, 12}, { 31, 12}, {-34, 12},
  {-35, 12}, { 29, 12}, { 30, 12}, { 33, 12}, { 34, 12}, { 32, 12}, {-29, 11}, {-29, 11},
  {-28, 11}, {-28, 11}, { 28, 11}, { 28, 11}, {-27, 11}, {-27, 11}, {-26, 11}, {-26, 11},
  { 27, 11}, { 27, 11}, { 26, 11}, { 26, 11}, { 25, 11}, { 25, 11}, { 24, 11}, { 24, 11},
  { 23, 11}, { 23, 11}, { 22, 11}, { 22, 11}, {-24, 11}, {-24, 11}, {-25, 11}, {-25, 11},
  {-23, 10}, {-23, 10}, {-23, 10}, {-23, 10}, {-21, 10}, {-21, 10}, {-21, 10}, {-21, 10},
  {-20, 10}, {-20, 10}, {-20, 10}, {-20, 10}, {-19, 10}, {-19, 10}, {-19, 10}, {-19, 10},
  {-18, 10}, {-18, 10}, {-18, 10}, {-18, 10}, {-22, 10}, {-22, 10}, {-22, 10}, {-22, 10},
  { 19, 10}, { 19, 10}, { 19, 10}, { 19, 10}, { 21, 10}, { 21, 10}, { 21, 10}, { 21, 10},
  { 20, 10}, { 20, 10}, { 20, 10}, { 20, 10}, { 18, 10}, { 18, 10}, { 18, 10}, { 18, 10},
  {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 },
  {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 },
  { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 },
  { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 },
  { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 },
  { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 },
  { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 },
  {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 },
  {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 },
  {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }
};

/* inter mean value, codes 000000000010111 ... 0000000100011xx */
static vlc_code_t inter_mean_table_2[121] = {
  { 61, 15},
  { 52, 15}, { 58, 15}, {-56, 15}, {-57, 15}, { 59, 15}, {-55, 15}, { 60, 15}, {-54, 15},
  { 53, 15}, {-62, 15}, {-60, 15}, {-59, 15}, {-58, 15}, { 57, 15}, { 56, 15}, {-53, 15},
  { 55, 15}, { 54, 15}, { 50, 14}, { 50, 14}, { 45, 14}, { 45, 14}, {-52, 14}, {-52, 14},
  {-51, 14}, {-51, 14}, {-50, 14}, {-50, 14}, { 46, 14}, { 46, 14}, {-49, 14}, {-49, 14},
  {-48, 14}, {-48, 14}, { 48, 14}, { 48, 14}, {-47, 14}, {-47, 14}, { 49, 14}, { 49, 14},
  {-45, 14}, {-45, 14}, {-44, 14}, {-44, 14}, { 47, 14}, { 47, 14}, { 51, 14}, { 51, 14},
  { 44, 14}, { 44, 14}, {-46, 14}, {-46, 14}, {-43, 13}, {-43, 13}, {-43, 13}, {-43, 13},
  {-42, 13}, {-42, 13}, {-42, 13}, {-42, 13}, {-41, 13}, {-41, 13}, {-41, 13}, {-41, 13},
  {-40, 13}, {-40, 13}, {-40, 13}, {-40, 13}, {-39, 13}, {-39, 13}, {-39, 13}, {-39, 13},
  {-38, 13}, {-38, 13}, {-38, 13}, {-38, 13}, {-37, 13}, {-37, 13}, {-37, 13}, {-37, 13},
  {-36, 13}, {-36, 13}, {-36, 13}, {-36, 13}, { 42, 13}, { 42, 13}, { 42, 13}, { 42, 13},
  { 36, 13}, { 36, 13}, { 36, 13}, { 36, 13}, { 43, 13}, { 43, 13}, { 43, 13}, { 43, 13},
  { 41, 13}, { 41, 13}, { 41, 13}, { 41, 13}, { 40, 13}, { 40, 13}, { 40, 13}, { 40, 13},
  { 35, 13}, { 35, 13}, { 35, 13}, { 35, 13}, { 39, 13}, { 39, 13}, { 39, 13}, { 39, 13},
  { 38, 13}, { 38, 13}, { 38, 13}, { 38, 13}, { 37, 13}, { 37, 13}, { 37, 13}, { 37, 13}
};

/* inter mean value, codes 000000000000100101 ... 0000000000101101xx */
static vlc_code_t inter_mean_table_3[147] = {
  {111, 18}, {102, 18}, { 99, 18},
  {-86, 18}, { 97, 18}, {-97, 18}, { 96, 18}, {-95, 18}, {-76, 18}, {-77, 18}, {-78, 18},
  {-85, 18}, {-80, 18}, {-81, 18}, { 89, 18}, { 90, 18}, {-84, 18}, {-89, 18}, { 80, 18},  
  {-90, 18}, {-88, 18}, { 92, 18}, { 93, 18}, { 95, 18}, {-109,18}, {-79, 17}, {-79, 17},
  {-83, 17}, {-83, 17}, {-75, 17}, {-75, 17}, {-74, 17}, {-74, 17}, {-73, 17}, {-73, 17},
  {-72, 17}, {-72, 17}, { 87, 17}, { 87, 17}, { 86, 17}, { 86, 17}, { 75, 17}, { 75, 17},
  { 85, 17}, { 85, 17}, { 84, 17}, { 84, 17}, { 81, 17}, { 81, 17}, { 79, 17}, { 79, 17},
  { 74, 17}, { 74, 17}, { 72, 17}, { 72, 17}, { 82, 17}, { 82, 17}, { 78, 17}, { 78, 17},
  { 83, 17}, { 83, 17}, { 76, 17}, { 76, 17}, { 73, 17}, { 73, 17}, { 77, 17}, { 77, 17},
  { 70, 16}, { 70, 16}, { 70, 16}, { 70, 16}, { 69, 16}, { 69, 16}, { 69, 16}, { 69, 16},
  { 64, 16}, { 64, 16}, { 64, 16}, { 64, 16}, {-68, 16}, {-68, 16}, {-68, 16}, {-68, 16},
  {-66, 16}, {-66, 16}, {-66, 16}, {-66, 16}, { 68, 16}, { 68, 16}, { 68, 16}, { 68, 16},
  {-69, 16}, {-69, 16}, {-69, 16}, {-69, 16}, { 65, 16}, { 65, 16}, { 65, 16}, { 65, 16},
  { 71, 16}, { 71, 16}, { 71, 16}, { 71, 16}, {-70, 16}, {-70, 16}, {-70, 16}, {-70, 16},
  {-65, 16}, {-65, 16}, {-65, 16}, {-65, 16}, {-67, 16}, {-67, 16}, {-67, 16}, {-67, 16},
  {-63, 16}, {-63, 16}, {-63, 16}, {-63, 16}, {-71, 16}, {-71, 16}, {-71, 16}, {-71, 16},
  { 67, 16}, { 67, 16}, { 67, 16}, { 67, 16}, {-61, 16}, {-61, 16}, {-61, 16}, {-61, 16},
  {-64, 16}, {-64, 16}, {-64, 16}, {-64, 16}, { 63, 16}, { 63, 16}, { 63, 16}, { 63, 16},
  { 62, 16}, { 62, 16}, { 62, 16}, { 62, 16}, { 66, 16}, { 66, 16}, { 66, 16}, { 66, 16}
};

/* inter mean value, codes 00000000000001001001 ... 0000000000001001001x */
static vlc_code_t inter_mean_table_4[75] = {
  {142, 20}, {135, 20}, {125, 20}, {123, 20}, {122, 20}, {119, 20}, {117, 20},
  {113, 20}, {104, 20}, {103, 20}, {-120,20}, {-114,20}, {-108,20}, {-104,20}, {-102,20},
  {-101,20}, {-93, 20}, {-91, 19}, {-91, 19}, {-96, 19}, {-96, 19}, { 88, 19}, { 88, 19},
  { 91, 19}, { 91, 19}, { 94, 19}, { 94, 19}, {121, 19}, {121, 19}, {120, 19}, {120, 19},
  {-110,19}, {-110,19}, {118, 19}, {118, 19}, {115, 19}, {115, 19}, {114, 19}, {114, 19},
  {112, 19}, {112, 19}, {107, 19}, {107, 19}, {110, 19}, {110, 19}, {109, 19}, {109, 19},
  {108, 19}, {108, 19}, {-103,19}, {-103,19}, {106, 19}, {106, 19}, {105, 19}, {105, 19},
  {-100,19}, {-100,19}, {101, 19}, {101, 19}, {100, 19}, {100, 19}, {-99, 19}, {-99, 19},
  {-82, 19}, {-82, 19}, {-87, 19}, {-87, 19}, {-94, 19}, {-94, 19}, {-98, 19}, {-98, 19},
  { 98, 19}, { 98, 19}, {-92, 19}, {-92, 19}
};

/* inter mean value, codes 0000000000000000000000 ... 000000000000010010001x */
static vlc_code_t inter_mean_table_5[292] = {
  {255, 22}, {254, 22}, {253, 22}, {252, 22}, {251, 22}, {250, 22}, {249, 22}, {248, 22},
  {247, 22}, {246, 22}, {245, 22}, {244, 22}, {243, 22}, {242, 22}, {241, 22}, {240, 22},
  {239, 22}, {238, 22}, {237, 22}, {236, 22}, {235, 22}, {234, 22}, {233, 22}, {232, 22},
  {231, 22}, {230, 22}, {229, 22}, {228, 22}, {227, 22}, {226, 22}, {225, 22}, {224, 22},
  {223, 22}, {222, 22}, {221, 22}, {220, 22}, {219, 22}, {218, 22}, {217, 22}, {216, 22},
  {215, 22}, {214, 22}, {213, 22}, {212, 22}, {211, 22}, {210, 22}, {209, 22}, {208, 22},
  {207, 22}, {206, 22}, {205, 22}, {204, 22}, {203, 22}, {202, 22}, {201, 22}, {200, 22},
  {199, 22}, {198, 22}, {197, 22}, {196, 22}, {195, 22}, {194, 22}, {193, 22}, {192, 22},
  {191, 22}, {190, 22}, {189, 22}, {188, 22}, {187, 22}, {186, 22}, {185, 22}, {184, 22},
  {183, 22}, {182, 22}, {181, 22}, {180, 22}, {179, 22}, {178, 22}, {177, 22}, {176, 22},
  {175, 22}, {174, 22}, {173, 22}, {172, 22}, {171, 22}, {170, 22}, {169, 22}, {168, 22},
  {167, 22}, {166, 22}, {-256,22}, {164, 22}, {-211,22}, {162, 22}, {161, 22}, {160, 22},
  {-210,22}, {-168,22}, {157, 22}, {156, 22}, {155, 22}, {154, 22}, {153, 22}, {152, 22},
  {151, 22}, {150, 22}, {149, 22}, {148, 22}, {147, 22}, {146, 22}, {145, 22}, {144, 22},
  {143, 22}, {-208,22}, {141, 22}, {140, 22}, {139, 22}, {-200,22}, {137, 22}, {136, 22},
  {-198,22}, {134, 22}, {133, 22}, {-196,22}, {-201,22}, {130, 22}, {129, 22}, {128, 22},
  {127, 22}, {126, 22}, {-195,22}, {124, 22}, {-167,22}, {-166,22}, {-165,22}, {-164,22},
  {-163,22}, {-162,22}, {-161,22}, {-180,22}, {-160,22}, {-159,22}, {-158,22}, {-157,22},
  {-156,22}, {-155,22}, {-154,22}, {-153,22}, {-152,22}, {-151,22}, {-150,22}, {-149,22},
  {-148,22}, {-147,22}, {-146,22}, {-145,22}, {-144,22}, {-143,22}, {-142,22}, {-141,22},
  {-140,22}, {-139,22}, {-138,22}, {-137,22}, {-136,22}, {-135,22}, {-134,22}, {-133,22},
  {-132,22}, {-131,22}, {-130,22}, {-129,22}, {-126,22}, {-125,22}, {-124,22}, {-123,22},
  {-122,22}, {-121,22}, {-118,22}, {-116,22}, {-115,22}, {-113,22}, {-112,22}, {-107,22},
  {-106,22}, {-169,22}, {-170,22}, {-171,22}, {-172,22}, {-173,22}, {-174,22}, {-175,22},
  {-176,22}, {-177,22}, {-178,22}, {-187,22}, {-179,22}, {-181,22}, {-182,22}, {-183,22},
  {-184,22}, {-185,22}, {-186,22}, {-235,22}, {-188,22}, {-189,22}, {-190,22}, {-191,22},
  {-192,22}, {-193,22}, {-194,22}, {-197,22}, {-255,22}, {-254,22}, {-253,22}, {-252,22},
  {-251,22}, {-250,22}, {-249,22}, {-248,22}, {-247,22}, {-246,22}, {-245,22}, {-244,22},
  {-243,22}, {-242,22}, {-241,22}, {-240,22}, {-239,22}, {-238,22}, {-237,22}, {-232,22},
  {-236,22}, {-234,22}, {-233,22}, {-217,22}, {-231,22}, {-230,22}, {-229,22}, {-228,22},
  {-227,22}, {-226,22}, {-225,22}, {-224,22}, {-223,22}, {-222,22}, {-221,22}, {-220,22},
  {-219,22}, {-216,22}, {-202,22}, {-205,22}, {-215,22}, {-214,22}, {-213,22}, {-204,22},
  {-212,22}, {-209,22}, {-218,22}, {-199,22}, {-207,22}, {-206,22}, {165, 21}, {165, 21},
  {131, 21}, {131, 21}, {163, 21}, {163, 21}, {-203,21}, {-203,21}, {116, 21}, {116, 21},
  {159, 21}, {159, 21}, {138, 21}, {138, 21}, {158, 21}, {158, 21}, {-105,21}, {-105,21},
  {-111,21}, {-111,21}, {132, 21}, {132, 21}, {128, 21}, {128, 21}, {-127,21}, {-127,21},
  {-119,21}, {-119,21}, {-117,21}, {-117,21}
};


