#!/usr/local/bin/perl -w
#
# servers.cgi : Version 1.0 
#
# Tested with RRDTool v1.0.7, v1.0.13, v1.0.24
#
# Create server monitoring pages 
#

use strict;
use CGI qw/:standard *ul *table/;

my ($VERSION ) = "1.0";
my ($APPURL  ) = "http://ukpavu99.adsweu.com/pub/";

##############################################################################
# You MUST set this to the location of the configuration file!
#
my ($conffile) = "/usr/local/etc/webdev.conf";
##############################################################################
#
# Create server monitoring pages

my ($mtype, $gtype, $q, %servers, @gtype, @gtypedesc, $querystring, $server);
my ($statistic, @stype, @stypedesc);
my (%headeropts, %config);
my( $refreshrate );

# These are not done as a hash so as to preserve ordering
@gtype = ( "dw", "my", "dwmy", "summary" );
@gtypedesc = ( "Short Term", "Long Term", "Full", "Summary" );
@stype = ( "cpu", "page", "users" );
@stypedesc = ( "CPU", "Paging", "User count" );

# initialize CGI
$q = new CGI;
$q->import_names('CGI');

my $meurl = $q->url();

#################################
# Sort functions
sub bydesc()
{
	my( $da, $db ) = ( $servers{ $a }, $servers{ $b } );
	$da cmp $db;
}

#################################
# Read in confgiuration file

# readconf: pass it a list of section names
sub readconf(@)
{
	my ($inlist, $i, @secs, $sec);
	
	@secs = @_;
	%config = ();

	( open CFH, "<".$conffile ) || do {
		print $q->header({-expires=>"now"});	
		print $q->start_html({ -title => "Error" });	
		print "Cannot read config file $conffile.";
		print $q->end_html();
		exit(1);
	};

	$inlist=0;
	$sec = "";
	while( <CFH> ) {
		/^\s*#/ && next;
		/\[(\S*)\]/ && do { 
			$sec = $1;
			$inlist=0;	
			foreach $i ( @secs ) {
				if ( $i eq $1 ) { $inlist=1; last; }
			}
			next ;
		};
		if ( $inlist and /(\w+)\s*=\s*(\S.*)$/ ) {
			$config{"$sec-$1"}=$2; 
			if( $sec eq "serverdesc" ) { # set up servers hash
				$servers{$1} = $2;
				$servers{$1} =~ s/ /\&nbsp;/g ;
			}
		}
	}
	
}

#################################
# Top menu

sub do_head()
{
print $q->start_html({ -title => "Server Performance Monitor" ,
					   -bgcolor => "d0d0d0"});
#print "<FORM onSubmit=\"parent.graph.location.reload(true);return false;\">\n";
print $q->table( { -border=>"0", -width=>"100%" },
  $q->Tr( { -valign=>"TOP", -width=>"100%" }, 
    $q->td({ -align=>"LEFT", -width=>150, -valign=>"TOP" }, 
      $q->a({ href=>$config{'web-backurl'}, target=>"_top"}, 
      $q->img({ src=>"$config{'servers.cgi-iconpath'}mainmenu-red.gif", alt=>"Main Menu", border=>0 }))."\n"
      .$q->br.$q->a({href=>"javascript:parent.graph.location.reload(true)"},
	    $q->img({src=>"$config{'servers.cgi-iconpath'}refresh.gif",border=>"0",alt=>"Refresh"}))
	)."\n"
    .$q->td({ -align=>"CENTER" }, $q->h1("Server Performance"))."\n"
    .$q->td({ -align=>"RIGHT", -width=>200, -valign=>"TOP" }, 
		$q->img({ src=>"$config{'servers.cgi-iconpath'}rrdtool.gif", alt=>"RRDTool"}))."\n"
  )
),"\n";

# Finish off the page
print $q->end_html();
}

###########################
# Side menu

sub do_menu()
{
my $options;

$options = "&xmtype=$mtype&xgtype=$gtype&xstat=$statistic";

# Start it off
print $q->start_html({ -title => "Server Performance Monitor",
					   -bgcolor => "d0d0d0"});

if ( $mtype eq 'servers' ) {
	print "\n",$q->a({ href=>"$meurl?page=menu&xgtype=$gtype&xmtype=options&host=$server&xstat=$statistic", target=>"_self" ,
		onMouseOver=>"{images[0].src='$config{'servers.cgi-iconpath'}options-dn-w.gif'; window.status='Show display options';}", 
		onmouseout=>"{images[0].src='$config{'servers.cgi-iconpath'}options-dn.gif'; window.status='';}" },
		$q->img({ src=>"$config{'servers.cgi-iconpath'}options-dn.gif", alt=>"Options", border=>0 })),
		"\n";

# Main stuff and links
print $q->br, $q->img({ src=>"$config{'servers.cgi-iconpath'}servers.gif", alt=>"Servers" }),
	$q->br(),"\n";
foreach ( sort bydesc keys (%servers) ) {
	print $q->img({ src=>"$config{'servers.cgi-iconpath'}server-sm.gif",
		alt=>$servers{$_}, width=>15, height=>15
	}),"&nbsp;";
	if( $server and ($_ eq $server) ) {
		print $q->b($servers{$_}),$q->br(),"\n";
	} else {
		print $q->a({ href=>"$meurl?page=graph&host=$_$options", target=>"graph" }, $servers{$_} ),$q->br(),"\n";
	}
}

} else { # mtype=options
	print "\n",$q->a({ href=>"$meurl?page=menu&xgtype=$gtype&xmtype=servers&host=$server&xstat=$statistic", target=>"_self" ,
		onMouseOver=>"{images[0].src='$config{'servers.cgi-iconpath'}servers-dn-w.gif'; window.status='Show display options';}", 
		onmouseout=>"{images[0].src='$config{'servers.cgi-iconpath'}servers-dn.gif'; window.status='';}" },
		$q->img({ src=>"$config{'servers.cgi-iconpath'}servers-dn.gif", alt=>"Servers", border=>0 })),"\n";

print $q->br(), $q->img({ src=>"$config{'servers.cgi-iconpath'}graphs.gif", alt=>"Graphs" }),
	$q->br(),"\n";
foreach (0..$#gtype) {
	print $q->img({ src=>"$config{'servers.cgi-iconpath'}graph-sm.gif",
		width=>15, height=>15  }),"&nbsp;";
	if($gtype and ($gtype eq $gtype[$_])) {
		print $q->b($gtypedesc[$_]),$q->br(),"\n";
	} else {
		print $q->a({ href=>"$meurl?page=graph&host=$server&xmtype=$mtype&xgtype=$gtype[$_]&xstat=$statistic", target=>"graph" }, $gtypedesc[$_] ),$q->br(),"\n";
	}
}
print $q->br(), $q->img({ src=>"$config{'servers.cgi-iconpath'}statistics.gif", alt=>"Statistic" }),
	$q->br,"\n"; 
# Statistics menu
# find out if we have a new version RRD
#my( $hash ) = RRDs::info ( $config{'servers.cgi-dbpath'}."/$server.rrd" );
foreach (0..$#stype) {
	print $q->img({ src=>"$config{'servers.cgi-iconpath'}menu-sm.gif",
		width=>15, height=>15 }),"&nbsp;";
	if($statistic eq $stype[$_]) {
		print $q->b($stypedesc[$_]),$q->br(),"\n";
#	} elsif( $stype[$_] ne "users" or $$hash{'ds[usercount].type'} ) {
	} else {
		print $q->a({ href=>"$meurl?page=graph&host=$server&xmtype=$mtype&xgtype=$gtype&xstat=$stype[$_]", target=>"graph" }, $stypedesc[$_] ),$q->br(),"\n";
	}
}
print $q->br(), $q->img({ src=>"$config{'servers.cgi-iconpath'}otherstuff.gif", alt=>"Other Stuff" }),
	$q->br,"\n", $q->img({ src=>"$config{'servers.cgi-iconpath'}query.gif" }),"&nbsp;",
	$q->a({href=>"$meurl?page=help", target=>"graph"}, "Information"),
	$q->br,"\n";

} # mtype
# Finish off the page
print $q->end_html();
}

############################
# Main frame set

sub do_main()
{
	$server="" if(!$server);
	$gtype="" if(!$gtype);
	$statistic="" if(!$statistic);
	print <<"EOT"
<HTML><HEAD><TITLE>Server Performance Monitor</TITLE></HEAD>
<FRAMESET border=0 marginheight=1 marginwidth=1 rows=65,*>
 <FRAME name=head src=$meurl?page=head noresize scrolling=no>
 <FRAMESET border=0 marginheight=1 marginwidth=1 cols=135,*>
  <FRAME name=menu src=$meurl?page=menu&host=$server&xgtype=$gtype&xstat=$statistic scrolling=auto nowrap>
  <FRAME name=graph src=$meurl?page=graph&host=$server&xgtype=$gtype&xstat=$statistic noresize scrolling=auto>
 </FRAMESET>
</FRAMESET>
<NOFRAMES>
 <BODY>
  Sorry, I'm too lazy to support non-frames browsers.
 </BODY>
</NOFRAMES>
</HTML>
EOT
}

##########################
# Graph panel

sub make_graph($$)
{
	my (@params, $e, $thisgraph, $thisurl);
	my ($tstr, $width);
	my ($dwmy,$stat) = @_;

	$tstr = "Daily" if( $dwmy =~ /d/ ) ;
	$tstr = "Weekly" if( $dwmy =~ /w/ ) ;
	$tstr = "Monthly" if( $dwmy =~ /m/ ) ;
	$tstr = "Yearly" if( $dwmy =~ /y/ ) ;

	$stat = "cpu" if (!$stat);

	@params = ();
	$thisurl   = "$config{'servers.cgi-graphurl'}/${server}-$stat-$dwmy.gif";
	$thisgraph = "$config{'servers.cgi-graphpath'}/${server}-$stat-$dwmy.gif";
	if ( $dwmy =~ /s/ ) { $width = 200 } else { $width = 400 }
	push @params, $thisgraph;
	push @params, qw/--lazy -l 0 --interlaced/;
	if( $stat eq "cpu" ) {
		push @params, qw/-u 100 -r/;
		push @params, "-v", "Percent" if ( $dwmy !~ /s/ );
		push @params, "-v", ""        if ( $dwmy =~ /s/ );
	} elsif ( $stat eq "page" ) {
		push @params, "-v", "Pages In/s", "-u", "10";
	} elsif ( $stat eq "users" ) {
		push @params, "-v", "Count";
	} else {
		push @params, "-v", "";
	}
	push @params, "-w", $width;
	push @params, "-s", (-5 * $width)."m"  if ( $dwmy =~ /d/ );
	push @params, "-s", (-30 * $width)."m" if ( $dwmy =~ /w/ );
	push @params, "-s", (-2 * $width)."h"  if ( $dwmy =~ /m/ );
	push @params, "-s", (-1 * $width)."d"   if ( $dwmy =~ /y/ );
	push @params,"--x-grid","HOUR:1:HOUR:24:HOUR:2:0:%k"  if ( $dwmy =~ /d/ );
	push @params,"--x-grid","HOUR:6:DAY:1:DAY:1:86400:%a" if ( $dwmy =~ /w/ );

	if ( $stat eq "cpu" ) {
		if ( $dwmy !~ /s/ and $dwmy !~ /d/) {
#			add maximum line...
			push @params, "DEF:t=$config{'servers.cgi-dbpath'}/$server.rrd:total:MAX","LINE1:t#d0d0ff:Peak total CPU usage\\l";
		}
		push @params, "DEF:u=$config{'servers.cgi-dbpath'}/$server.rrd:user:AVERAGE", 
			"DEF:s=$config{'servers.cgi-dbpath'}/$server.rrd:system:AVERAGE", 
			"DEF:w=$config{'servers.cgi-dbpath'}/$server.rrd:wait:AVERAGE",
			"AREA:u#ff0000:User", "STACK:s#00ff00:System", "STACK:w#0000ff:Wait";
		push @params, "CDEF:down=u,UN,100,0,IF", "AREA:down#d0d0d0:Unavailable";
		push @params,"--title", (ucfirst lc $server)." $tstr CPU Usage";
	} elsif ( $stat eq "page" ) {
		push @params, "DEF:page=$config{'servers.cgi-dbpath'}/$server.rrd:page:AVERAGE", 
			"AREA:page#0000ff:Paging";
		if ( $dwmy !~ /s/ and $dwmy !~ /d/) {
#			add maximum line...
			push @params, "DEF:max=$config{'servers.cgi-dbpath'}/$server.rrd:page:MAX","LINE1:max#ff8080:Peak paging";
		}
		push @params, "CDEF:down=page,UN,INF,0,IF", "AREA:down#d0d0d0:Unavailable";
		push @params,"--title", (ucfirst lc $server)." $tstr Paging";
	} elsif ( $stat eq "users" ) {
		push @params, "DEF:users=$config{'servers.cgi-dbpath'}/$server.rrd:usercount:AVERAGE", 
			"AREA:users#ff00ff:Connected Users",
			"CDEF:down=users,UN,INF,0,IF", "AREA:down#d0d0d0:Unavailable",
			"--title", (ucfirst lc $server)." $tstr User count";
	} else {
		push @params, "DEF:x=$config{'servers.cgi-dbpath'}/$server.rrd:user:AVERAGE", 
			"CDEF:down=x,UN,INF,0,IF", "AREA:down#d0d0d0:Unavailable",
			"--title", (ucfirst lc $server)." $tstr Availability";
	}
	RRDs::graph(@params);
	$e = RRDs::error();
	if ( $e ) {
		print $q->p($e),"\n";
	} else {
		print $q->img({ src => $thisurl, alt => "$tstr Usage"});
	}
}

sub do_graph()
{
# Start off.  We use onload() and Javascript to force reload the 
# lefthand (menu) panel.
my ($javascript, $e);
my ($thisgraph, $thisurl);

$javascript = "function LoadMenu() 
{ 
parent.menu.location = \"$meurl?page=menu&host=$server&xgtype=$gtype&xmtype=$mtype&xstat=$statistic\"; 
}";

print $q->start_html({ -title => "Server Performance Monitor", 
	-expires => "+5s",  -script => $javascript, -bgcolor=>"#ffffff",
	-onload => "LoadMenu()" }),"\n";
#print $q->h1("Host: ". ucfirst lc $server),"\n";
#
# Now for the RRD stuff
require 'RRDs.pm';
#
# Now, we have to do this differently depending on which gtype we have
# We do a switch for the different graphs.
# We have to call RRD to create them, and the IMG tag is created ready to
# stuff into the page!  Oooh!
if ( $gtype eq "dw" or $gtype eq "dwmy" ) {
#	day and week graphs
	make_graph("d",$statistic);
	make_graph("w",$statistic); print $q->br,"\n";
}
if ( $gtype eq "my" or $gtype eq "dwmy" ) {
#	month and year graphs
	make_graph("m",$statistic);
	make_graph("y",$statistic); print $q->br,"\n";
}
if ( $gtype eq "summary") {
#	day/week and month/year small graphs
	make_graph("ds",$statistic);
	make_graph("ws",$statistic); print $q->br,"\n";
	make_graph("ms",$statistic);
	make_graph("ys",$statistic); print $q->br,"\n";
}
# Last update stuff.
my $lastupdate = RRDs::last($config{'servers.cgi-dbpath'}."/".$server.".rrd");
$e = RRDs::error();
if( $e ) {
	print $q->p("Error reading RRD database $config{'servers.cgi-dbpath'}/$server.rrd"),"\n";
	print $q->p($e),"\n";
} else {
	print $q->p("Last update: ".scalar(localtime($lastupdate))),"\n";
}

#print "\n<FORM onSubmit=\"location.reload(true);return false;\"><INPUT type=submit name=R value=Refresh></form>\n";
print $q->a( { href=>"javascript:location.reload(true)", target=>"_self" }, 
	$q->img( { src=>"$config{'servers.cgi-iconpath'}refresh.gif" , alt=>"Refresh", border=>"0" } )),
	"\n";
print $q->hr,"\n";

if ( $statistic eq "cpu" ) {
	print $q->p("CPU statistics are built by averaging CPU time over all processors over a 5 minute interval.  Activity over this period is classified as User, System or Wait.");
	print $q->ul(
		$q->li($q->b("User:")." User activity is any process that is not part of the operating system.  In practice, this means almost all processes.").
		$q->li($q->b("System:")." System activity is work that is part of the operating system, for example, the I/O subsystem, network protocol stacks, and so on.").
		$q->li($q->b("Wait:")." This is the big timewaster.  A CPU is in a Wait state when it is hanging around waiting for I/O.  This usually means waiting for disk reads or writes.")
	);
	print $q->p("You should watch out for too much time being spent in the Wait state (an indication of the need for a faster disk array), or too much time being spent in User state (an indication that more, or faster, CPUs are required).  Too much time in System and Wait can also indicate a memory problem if it coincides with excessive Page activity (see the other graphs).");
} elsif ( $statistic eq "page" ) {
	print $q->p("Paging statistics show the number of Pages In per second, averaged over a 20 second interval.  This may not notice short bursts of high paging, or may give excessive weight to a brief interval of activity, so you should look for prolonged periods of excessive page activity.");
	print $q->p("On the whole, Page activity under 100 Pages/s is not a cause for concern, unless this activity is prolonged.  If this is the case, you should consider increasing the system core memory, or decreasing the resources required by the processes running.");
} else {
	print $q->p("No additional information is available for this statistic.");
}
print $q->hr,$q->small("servers.cgi Version $VERSION : Steve Shipway 2000 : "
	.$q->a({href=>$APPURL},$APPURL)),"\n";


# Finish off the page (this does the ending body and html tags)
print $q->end_html();
}

sub do_help()
{
	my $javascript;
	$javascript = "function LoadMenu() 
	{ 
	parent.menu.location = \"$meurl?page=menu\"; 
	}";
	print $q->start_html({-script => $javascript, -onload => "LoadMenu()" });
	print $q->start_html();

	print $q->h1("Information and Help");

	print $q->p("See the bottom of each graph frame for information on the data contained in the page."),"\n";
	print $q->hr,
		$q->small("servers.cgi Version $VERSION : Steve Shipway 2000 : "
			.$q->a({href=>$APPURL},$APPURL)),"\n";
	print $q->end_html();
}

###########################
# If we get a bad page request

sub do_bad()
{
	print $q->h1("Eeek, an error!");
	print $q->start_html();
	print $q->dump;
	print $q->end_html();
}

########################################################################
# Initialise parameters

readconf ( 'web', 'servers.cgi', 'serverdesc' );

$server = ($CGI::host or ( $CGI::page ne "graph" ))?$CGI::host:(sort bydesc (keys %servers))[0] ;
$gtype = ($CGI::xgtype or ( $CGI::page ne "graph" ))?$CGI::xgtype:"dw" ;
$statistic = ($CGI::xstat or ( $CGI::page ne "graph" ))?$CGI::xstat:"cpu" ;
$mtype = ($CGI::xmtype)?$CGI::xmtype:"servers" ;

$refreshrate="3600";                       # 1 hour - for weekly graphs
$refreshrate="300" if( $gtype =~ /[sd]/ ); # 5 mins - there is a daily graph

# Start the page off
if( $CGI::page eq "graph" ) {
	$headeropts{-expires} = "+5s";
	$headeropts{-Refresh} = $refreshrate;
}
$headeropts{-target} = "_top"     if( ! $CGI::page );
$headeropts{-target} = $CGI::page if( $CGI::page =~ /head|menu|graph/ );

print $q->header( %headeropts );

#
# Now, we check the passed parameters to find out what sort of page to
# serve up.  If we can't work out which one to do, then we just serve the
# index page
if($CGI::page) {
	foreach($CGI::page) {
		/head/ and do {	do_head(); last; };
		/menu/ and do { do_menu(); last; };
		/graph/ and do { do_graph(); last; };
		/help/ and do { do_help(); last; };
		/main/ and do { do_main(); last; };
		do_bad();
	}
} else { do_main() }


