/* call helper for 14all
 * (c) Rainer Bawidamann 2000
 *
 * does an exec on its first arg
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#define DEBUG 0
#define EXEC14ALL "/usr/local/bin/14all.cgi"

char ** split(char *, char);
void printarray(char **);

int main(int argc, char *argv[])
{

	char **newargs, **script;
	int newargspos, newargssize, scriptpos, argpos;
#if DEBUG
	printf("cinter called with %d args: \n",argc);
	printarray(argv);
#endif
	if (argc == 1 || argc > 3) {
		printf("usage: %s [scriptinterpreter] script\ndefault scriptinterpreter is %s\n",
			argv[0], EXEC14ALL );
		exit(127);
	}
	script = split(argv[1], ' ');
#if DEBUG
	printf("split second arg:\n");
	printarray(script);
#endif
	newargspos=0;
	newargssize=10;
	newargs = malloc(newargssize * sizeof(char*));
	if (argc == 2) {
		newargs[newargspos++] = EXEC14ALL;
		newargs[newargspos++] = EXEC14ALL;
		argpos = 1;
	} else {
		newargs[newargspos++] = script[0];
		newargs[newargspos++] = script[0];
		argpos = 2;
	}
	for(scriptpos=1; script[scriptpos] != NULL; ) {
		if (newargspos >= newargssize-1) {
			newargssize += 10;
			newargs = realloc(newargs, newargssize * sizeof(char*));
			if (newargs == NULL) {
				exit(1);
			}
		}
		newargs[newargspos++] = script[scriptpos++];
	}
	for(; argv[argpos] != NULL; ) {
		if (newargspos >= newargssize-1) {
			newargssize += 10;
			newargs = realloc(newargs, newargssize * sizeof(char*));
			if (newargs == NULL) {
				exit(1);
			}
		}
		newargs[newargspos++] = argv[argpos++];
	}
	if (newargspos >= newargssize-1) exit(1);
	newargs[newargspos] = NULL;
#if DEBUG
	printf("calling:\n");
	printarray(newargs);
#endif
	if (argc == 2) {
		execvp(newargs[0], newargs+1);
	} else {
		execv(newargs[0], newargs+1);
	}
	fprintf(stderr, "cannot exec interpreter '%s': ", newargs[0]);
	perror("");
	exit(1);
}

char ** split(char *from, char c) {
	char **narg, *p;
	int arg=0;
	int argc = 10;

	narg = malloc(argc * sizeof(char*));
	/* memset((void *)narg, 0, argc * sizeof(char*)); */
	narg[arg++] = from;
	/* split from at ' ' */
	for(p=from; *p; p++) {
		if (arg >= argc-1) {
			argc += 10;
			narg = realloc(narg, argc * sizeof(char*));
			if (narg == NULL) {
				return(NULL);
			}
			/* memset((void *)narg, 0, argc * sizeof(char*)); */
		}
		p=index(p, c);
		if (!p) {
			break;
		}
		*p = 0;
		narg[arg++] = ++p;
	}
	if (arg >= argc) return(NULL);
	narg[arg] = NULL;
	return narg;
}

#if DEBUG
void printarray(char **ary)
{
	int i;
	if (ary == NULL) {
		return;
	}
	for(i=0; ary[i] != NULL; i++) {
		printf("'%s' ",ary[i]);
	}
	printf("\n");
}
#endif
