#!/usr/bin/perl
# ircstats2.pl v1.0 18 Aug 2000 Lucas Nussbaum <lucas@ians.be>
# More info and updates can be obtained on http://lucas.ians.be/ircstats2
# based on ircstats from Matt Ramsey (MR227) mjr@geeks.org, mjr@nin.com
# Used to generate stats on the Kewl.Org IRC Network
# If you see something that should be changed, please notify me !

use Socket;

# pseudo-client parameters
$nick = "StatsMaker";
$ident = "Stats";
$realname = "http://lucas.ians.be/ircstats2";

# server and port to connect to
$ircserver = "issy.fr.eu.kewl.org";
$ircport = "6667";

# Where to store the output data (directory MUST exist)
# The number of users on each server will be in a file named like the server.
# An additionnal file named 'global' will be created, containing the sum of
# all servers' users.
# An example configuration file is included.
$datapath = "/home/lucas/mrtg/output";

# Servers to poll
$server{"angers.fr.eu.kewl.org"}=0;
$server{"issy.fr.eu.kewl.org"}=0;
$server{"faubourg.fr.eu.kewl.org"}=0;
$server{"la.defense.fr.eu.kewl.org"}=0;
$server{"london.uk.eu.kewl.org"}=0;
$server{"nanterre.fr.eu.kewl.org"}=0;
$server{"paris.fr.eu.kewl.org"}=0;
$server{"worldnet.fr.eu.kewl.org"}=0;
$server{"cracow.pl.eu.kewl.org"}=0;
$server{"hub.fr.eu.kewl.org"}=0;
$server{"eole.fr.eu.kewl.org"}=0;
$server{"cybernet.be.eu.kewl.org"}=0;

##############################################
### DO NOT MODIFY ANYTHING BELOW THIS LINE ###
##############################################

while (true) {
   ($g, $g, $proto) = getprotobyname("tcp");
   ($g, $g, $g, $g, $rawserver) = gethostbyname($ircserver);
   $serveraddr = pack("Sna4x8", 2, $ircport, $rawserver);
   socket(SOCKET, AF_INET, SOCK_STREAM, $proto) || die "No socket: $!";
   if (connect(SOCKET, $serveraddr)){
      select(SOCKET); $| = 1;
      select(STDOUT); $| = 1; 
      print SOCKET "USER $ident a b :$realname\n";
      print SOCKET "NICK $nick\n";
      while (<SOCKET>){
         @i = split(" ",$_);
         if ($i[1] eq "433") {print SOCKET "NICK ".$nick.time()."\n";}
         elsif ($i[1] eq "437") {print SOCKET "NICK ".$nick.time()."\n";}
         elsif ($i[1] eq "376") {&getinfo;}
         elsif ($i[1] eq "402") {$server{lc($i[3])}=0;}
         elsif ($i[1] eq "255") {
            $i[0]=~s/\://;
            $server{lc($i[0])}=$i[5];
         }
         elsif ($i[0] eq "PING") {
            &saveinfo;
            print SOCKET "PONG $i[1]\n";
            &getinfo;
         }
      }
   }
   close(SOCKET);
   sleep(120); 
}

sub saveinfo {
   foreach $s (keys %server){
      open(OUTPUT,">$datapath/$s");
      print OUTPUT "$server{$s}\n$server{$s}\n$time\n";
      close(OUTPUT); 
   }
   $global=0;
   foreach $s (keys %server){
      $global = $global + $server{$s}
   }
   open(OUTPUT,">$datapath/global");
   print OUTPUT "$global\n$global\n$time\n";
   close(OUTPUT);
}
 
sub getinfo {
   foreach $s (keys %server){print SOCKET "lusers * $s\n";}
   $time=time();
}
