//gcc -pipe -Wall -s mrtg5.c -o mrtg5.Exe

#define UNICODE
#define _UNICODE

#include <Tchar.h>
#include <Windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

#include "messages.h"

#define MY_REGISTRY	_T("SOFTWARE\\MMM\\mrtg5")

#ifdef _DEBUG
#pragma comment( linker , "/SECTION:.Shared0,S" )
#else
#pragma comment( linker , "/SECTION:.Shared0,S /RELEASE /WS:AGGRESSIVE /OPT:REF /SWAPRUN:NET /SWAPRUN:CD" )
#endif

#pragma data_seg(".Shared0") 
DWORD dwMagic = 0;
DWORD dwMarker = 0;
_TCHAR szStartTime[32]=_T("");
struct {
int isDebug;
int isRunOnly;
_TCHAR szRunCmd5[MAX_PATH];
_TCHAR szCrontab[MAX_PATH];
}Config={0,0,_T("C:\\MRTG\\Run\\MrtgKick.Cmd"),_T("C:\\Etc\\Crontab")};
#pragma data_seg() 

_TCHAR szServiceKeyName[] = _T("MRTG5");
_TCHAR szServiceDisplayName[] = _T("MRTG launcher");

SERVICE_STATUS_HANDLE hSS;
SERVICE_STATUS ss;
HANDLE hMainThread;
HANDLE hEvent;
int isServicePaused=0;
int isServiceStopped=0;

_TCHAR sTmp[256];
//============================================================================
void WINAPI ServiceHandler(DWORD fdwControl);
void WINAPI ServiceMain(DWORD dwArgc, LPTSTR *pszArgv);
void OutDebug(_TCHAR * psFormat, ... );
void OutDebugError(_TCHAR * psFormat, ... );
int WriteErrEvent(_TCHAR * pszMsg, ...);
void alltrim(_TCHAR *pszDst);
void AddToEnvironment(void);
int GetConfigValueInt(_TCHAR * pszKeyName);
_TCHAR *GetConfigValueString(_TCHAR * pszKeyName);
int ReadConfig(VOID);
int HandleTimeEvent(_TCHAR * pszCmd);
void ReadCrontab(void);
void CrontabExecute(SYSTEMTIME *pst);
void CrontabFirstExecute(SYSTEMTIME *pst);
void InstallService(void);
void RemoveService(void);
void UpdateConfig(void);
void GetLocalTimeString(_TCHAR *pszBuff);
//============================================================================
//============================================================================
void
WINAPI
ServiceHandler(DWORD fdwControl)
{

switch(fdwControl){
case SERVICE_CONTROL_STOP:
	OutDebug(_T("SERVICE_CONTROL_STOP"));
	ss.dwCurrentState = SERVICE_STOP_PENDING;
	SetServiceStatus(hSS, &ss);
	SetEvent(hEvent);
	ss.dwCurrentState = SERVICE_STOPPED;
	SetServiceStatus(hSS, &ss);
	isServiceStopped=1;
	break;
case SERVICE_CONTROL_PAUSE:
	OutDebug(_T("SERVICE_CONTROL_PAUSE"));
	ss.dwCurrentState = SERVICE_PAUSE_PENDING;
	SetServiceStatus(hSS, &ss);
	ss.dwCurrentState = SERVICE_PAUSED;
	SetServiceStatus(hSS, &ss);
	isServicePaused=1;
	break;
case SERVICE_CONTROL_CONTINUE:
	OutDebug(_T("SERVICE_CONTROL_CONTINUE"));
	ss.dwCurrentState = SERVICE_CONTINUE_PENDING;
	SetServiceStatus(hSS, &ss);
	ss.dwCurrentState = SERVICE_RUNNING;
	SetServiceStatus(hSS, &ss);
	isServicePaused=isServiceStopped=0;
	break;
case SERVICE_CONTROL_INTERROGATE:
	OutDebug(_T("SERVICE_CONTROL_INTERROGATE"));
	SetServiceStatus(hSS, &ss);
	break;
case SERVICE_CONTROL_SHUTDOWN:
	OutDebug(_T("SERVICE_CONTROL_SHUTDOWN"));
	ss.dwCurrentState = SERVICE_STOP_PENDING;
	SetServiceStatus(hSS, &ss);
	SetEvent(hEvent);
	ss.dwCurrentState = SERVICE_STOPPED;
	SetServiceStatus(hSS, &ss);
	break;
default:
	OutDebug(_T("SERVICE_CONTROL_default"));
	break;
}

return ;
}
//============================================================================
void
WINAPI
ServiceMain(DWORD dwArgc, LPTSTR *pszArgv)
{

dwMagic = 0x4D6D4D40;

hMainThread=GetCurrentThread();
hSS = RegisterServiceCtrlHandler((LPCTSTR)szServiceKeyName, (LPHANDLER_FUNCTION)ServiceHandler);
hEvent=CreateEvent(NULL,TRUE,FALSE,NULL);

//===========================*
ss.dwServiceType = SERVICE_WIN32_OWN_PROCESS; 
ss.dwCurrentState = SERVICE_START_PENDING;
ss.dwControlsAccepted = SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_PAUSE_CONTINUE|SERVICE_ACCEPT_SHUTDOWN;
ss.dwWin32ExitCode = NO_ERROR;
ss.dwServiceSpecificExitCode = 0;
ss.dwCheckPoint = 0; 
ss.dwWaitHint = 500;
SetServiceStatus(hSS, &ss);
//===========================*
//===========================*
ss.dwCurrentState = SERVICE_RUNNING;
ss.dwWaitHint = 0;
SetServiceStatus(hSS, &ss);
//===========================*
OutDebug(_T("SERVICE_CONTROL_RUN"));
isServicePaused=isServiceStopped=0;


GetLocalTimeString(szStartTime);
ReadConfig();
ReadCrontab();
AddToEnvironment();

//*===========================================*
{
SYSTEMTIME st;
int iPreviousMin=-1;
for(;;){

switch(WaitForSingleObject(hEvent,3000)){
case WAIT_FAILED:
	OutDebugError(_T("WAIT_FAILED"));
	break;
case WAIT_ABANDONED:
	OutDebug(_T("WAIT_ABANDONED"));
	break;
case WAIT_OBJECT_0:
	OutDebug(_T("WAIT_OBJECT_0"));
	goto EventIsSet;//sygnalizacja koca
	break;
case WAIT_TIMEOUT:// obsuga
	//***
	if(dwMarker){
		OutDebug(_T("dwMarker ON"));
		dwMarker=0;
		ReadConfig();
		ReadCrontab();
	}
	//***
	OutDebug(_T("WAIT_TIMEOUT"));
	memset((PVOID)&st,0,sizeof(st));
	GetLocalTime(&st);
	if(iPreviousMin == st.wMinute)continue;
	if(iPreviousMin<0)CrontabFirstExecute(&st);
	iPreviousMin=st.wMinute;
	if(!(st.wMinute%5)){OutDebug(_T("HandleTimeEvent(`%s')\n"),Config.szRunCmd5);HandleTimeEvent(Config.szRunCmd5);}
//	if(!(st.wMinute%2)){OutDebug(_T("HandleTimeEvent(`%s')\n"),Config.szRunCmd5);HandleTimeEvent(Config.szRunCmd5);}
	//***
	CrontabExecute(&st);
	break;
default:
	OutDebug(_T("WAIT_debug???"));
	break;
}//switch

}//for
}
//*===========================================*

EventIsSet:;


CloseHandle(hEvent);

return ;
}
//============================================================================
void
OutDebug(_TCHAR * psFormat, ... )
{
va_list VaArgs;

if(!Config.isDebug)return ;

va_start( VaArgs, psFormat);
_vsntprintf(sTmp,sizeof(sTmp),psFormat, VaArgs);
_tcscat(sTmp,_T("\n"));
if(!Config.isRunOnly)OutputDebugString((LPCTSTR)sTmp);
if(Config.isRunOnly)_ftprintf(stderr,_T("\r%s"), sTmp);

return ;
}
//============================================================================
void
OutDebugError(_TCHAR * psFormat, ... )
{
LPVOID lpMsgBuf;
va_list VaArgs;

if(!Config.isDebug)return ;

va_start( VaArgs, psFormat);

FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,NULL,GetLastError(),MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),(LPTSTR)&lpMsgBuf,0,NULL);
if(!lpMsgBuf)lpMsgBuf=_tcsdup(_T("?"));
_vsntprintf(sTmp,sizeof(sTmp),psFormat, VaArgs);
_tcscat(sTmp,_T(" : "));
_tcscat(sTmp,(_TCHAR*)lpMsgBuf);
LocalFree(lpMsgBuf);

_tcscat(sTmp,_T("\n"));
if(!Config.isRunOnly)OutputDebugString((LPCTSTR)sTmp);
if(Config.isRunOnly)_ftprintf(stderr,_T("\r%s"), sTmp);

return ;
}
//============================================================================
int
WriteErrEvent(_TCHAR * psFormat, ...)
{
HANDLE hEventLog;
_TCHAR *pszBuff[1];
va_list VaArgs;

va_start( VaArgs, psFormat);

_vsntprintf(sTmp,sizeof(sTmp),psFormat, VaArgs);

pszBuff[0]=sTmp;

if(INVALID_HANDLE_VALUE != (hEventLog=RegisterEventSource((LPCTSTR)NULL,(LPCTSTR)szServiceKeyName))){
	ReportEvent(hEventLog,EVENTLOG_ERROR_TYPE,0,MRTG5_ERROR,NULL,1,0,(LPCTSTR *)&pszBuff,NULL);
	DeregisterEventSource(hEventLog);
	return 0;
}

return -1;
}
//============================================================================
void
alltrim(_TCHAR *pszDst)
{
_TCHAR *dp;
int i;

for(dp=pszDst; _T(' ')==*dp||_T('\t')==*dp||_T('\n')==*dp||_T('\r')==*dp; dp++);
if(pszDst != dp)memmove(pszDst, dp, (_tcslen(dp)+1)*sizeof(_TCHAR));
for(i=_tcslen(pszDst); i; i--)if(_T(' ')==*(pszDst+i-1)||_T('\t')==*(pszDst+i-1)||_T('\n')==*(pszDst+i-1)||_T('\r')==*(pszDst+i-1) )*(pszDst+i-1)=0; else break;

}
//============================================================================
void
AddToEnvironment(void)
{
DWORD dw;

dw=sizeof(sTmp);
_tcscpy(sTmp,_T("system"));
if(!GetUserName(sTmp,&dw)){
	OutDebug(_T("ERROR: GetUserName()"));
}
else {
	SetEnvironmentVariable(_T("LOGNAME"), sTmp);
}

if(GetEnvironmentVariable(_T("ComSpec"),sTmp,sizeof(sTmp))){
	SetEnvironmentVariable(_T("SHELL"), sTmp);
}
else SetEnvironmentVariable(_T("SHELL"), _T("cmd.exe"));
 
if(GetEnvironmentVariable(_T("TEMP"),sTmp,sizeof(sTmp))){
	SetEnvironmentVariable(_T("HOME"), sTmp);
}
else SetEnvironmentVariable(_T("HOME"), _T("C:\\TEMP"));

return ;
}
//============================================================================
int
GetConfigValueInt(_TCHAR * pszKeyName)
{
HKEY hKeySource = NULL;
DWORD dwType = REG_NONE;
static int dwBuffer;
DWORD dwSize = sizeof(dwBuffer);

dwBuffer=0;
if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE,MY_REGISTRY,0,KEY_QUERY_VALUE,&hKeySource)){
if((ERROR_SUCCESS == RegQueryValueEx(hKeySource,pszKeyName,NULL,&dwType,(LPBYTE)&dwBuffer,&dwSize)) ){
	RegCloseKey(hKeySource);
	OutDebug(_T("GetConfigValueInt(%s)=%d"),pszKeyName, (int)dwBuffer);
}
else {
	RegCloseKey(hKeySource);
	OutDebug(_T("ERROR: GetConfigValueInt(%s)"),pszKeyName);
	return 0;
}
}//RegOpenKeyEx



return (int)dwBuffer;
}
//============================================================================
_TCHAR *
GetConfigValueString(_TCHAR * pszKeyName)
{
HKEY hKeySource = NULL;
DWORD dwType = REG_NONE;
static _TCHAR sBuffer[_MAX_PATH];
DWORD dwSize = sizeof(sBuffer);

*sBuffer=_T('\0');
if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE,MY_REGISTRY,0,KEY_QUERY_VALUE,&hKeySource)){
if((ERROR_SUCCESS == RegQueryValueEx(hKeySource,pszKeyName,NULL,&dwType,(LPBYTE)sBuffer,&dwSize)) ){
	RegCloseKey(hKeySource);
	OutDebug(_T("GetConfigValueString(%s)=[%s]"),pszKeyName, sBuffer);
}
else {
	RegCloseKey(hKeySource);
	OutDebug(_T("ERROR: GetConfigValueString(%s)"),pszKeyName);
	return (_TCHAR *)NULL;
}
}//RegOpenKeyEx
else return (_TCHAR *)NULL;

return (_TCHAR *)sBuffer;
}
//============================================================================
//============================================================================
int
ReadConfig(VOID)
{
_TCHAR * pszValue;

if(!Config.isRunOnly)Config.isDebug=GetConfigValueInt(_T("Debug"));

if(!(pszValue=GetConfigValueString(_T("MrtgKick-PathName")))){
	OutDebug(_T("ERROR: ReadConfig(MrtgKick-PathName)"));
	if(!Config.isDebug)WriteErrEvent(_T("ERROR: ReadConfig(MrtgKick-PathName)"));
}
else wcscpy(Config.szRunCmd5, pszValue);

if(!(pszValue=GetConfigValueString(_T("Crontab-PathName")))){
	OutDebug(_T("ERROR: ReadConfig(Crontab-PathName)"));
	if(!Config.isDebug)WriteErrEvent(_T("ERROR: ReadConfig(Crontab-PathName)"));
}
else wcscpy(Config.szCrontab, pszValue);

if(!*Config.szRunCmd5)OutDebug(_T("WARNING: MrtgKick-PathName is empty"));
if(!*Config.szCrontab)OutDebug(_T("WARNING: Crontab-PathName is empty"));

return 0;
}
//============================================================================
int
HandleTimeEvent(_TCHAR * pszCmd)
{
STARTUPINFO si;
PROCESS_INFORMATION pi;
LPVOID lpMsgBuf;

if(isServicePaused || isServiceStopped)return 0;

while(*pszCmd && (_T('*')==*pszCmd || _T('!')==*pszCmd))pszCmd++;

if(!*pszCmd){
	OutDebug(_T("ERROR: HandleTimeEvent() - No command to execute\n"));
	return 0;
}

//if(!GetEnvironmentVariable("ComSpec",sTmp,sizeof(sTmp)))wcscpy(sTmp,"CMD.EXE");
//strcat(sTmp," /C "); strcat(sTmp,pszCmd);

memset(&si, 0, sizeof(si)); si.cb = sizeof(si);
if(!CreateProcess(NULL,pszCmd,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,(LPCTSTR)NULL,&si,&pi))
{
FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,NULL,GetLastError(),MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),(LPTSTR)&lpMsgBuf,0,NULL);
if(!lpMsgBuf)lpMsgBuf=_tcsdup(_T("not executed"));
OutDebug(_T("ERROR: CreateProcess(%s) - %s"),pszCmd, (_TCHAR*)lpMsgBuf);
if(!Config.isDebug)WriteErrEvent(_T("ERROR: CreateProcess(%s) - %s\n"),pszCmd, (_TCHAR*)lpMsgBuf);
LocalFree(lpMsgBuf);

return 1;
}
else {CloseHandle(pi.hThread); CloseHandle(pi.hProcess);}

return 0;
}
//============================================================================
//============================================================================
// -- CRONTAB --

static
struct CRONTAB {
int min, hour, mday, month, wday;
_TCHAR * pszCmd;
}crontab[100];

void
ReadCrontab(void)
{
FILE * fpi;
_TCHAR buff[2*MAX_PATH];
_TCHAR *cp;
int i,n,kount;
int iFileLine, iDataLine; _TCHAR *pszErr;

if(NULL==(fpi=_tfopen(Config.szCrontab,_T("rt")))){
  OutDebug(_T("Can't open crontab"));
  return ;
}

for(i=0; i<(sizeof(crontab)/sizeof(crontab[0]));i++){
if(crontab[i].pszCmd)free(crontab[i].pszCmd);
}
memset((void *)&crontab,0,sizeof(crontab));

n=iFileLine=iDataLine=0; pszErr=NULL;
while(_fgetts(buff, sizeof(buff),fpi)){iFileLine++;
  //
  alltrim(buff);
  if(_T('#')==*buff)continue;
  if(!*buff)continue;
  //
  iDataLine++;
  kount=0; cp = _tcstok(buff,_T(" \t"));
  while(cp){
  if( !((_T('*')==*cp)||(_T('0')<=*cp && *cp<=_T('9'))) ){pszErr=_T("Illegal char in field (only: *0-9)"); _tprintf(_T("-%s-\n"),cp);goto next_line;}
  switch(kount){
    case 0://MIN
      if(_T('*')==*cp)i=-1;
      else {i=_ttoi(cp); if(i<0 || i>59){pszErr=_T("Field `min' out of range"); goto next_line;}}
      crontab[n].min=i;
      break;
    case 1://HOUR
      if(_T('*')==*cp)i=-1;
      else {i=_ttoi(cp); if(i<0 || i>23){pszErr=_T("Field `hour' out of range"); goto next_line;}}
      crontab[n].hour=i;
      break;
    case 2://MDAY
      if(_T('*')==*cp)i=-1;
      else {i=_ttoi(cp); if(i<1 || i>31){pszErr=_T("Field `mday' out of range"); goto next_line;}}
      crontab[n].mday=i;
      break;
    case 3://MONTH
      if(_T('*')==*cp)i=-1;
      else {i=_ttoi(cp); if(i<1 || i>12){pszErr=_T("Field `month' out of range"); goto next_line;}}
      crontab[n].month=i;
      break;
    case 4://WDAY
      if(_T('*')==*cp)i=-1;
      else {i=_ttoi(cp); if(i<0 || i>7){pszErr=_T("Field `wday' out of range"); goto next_line;}}
      if(7==i)i=0;
      crontab[n].wday=i;
      cp=_tcstok(NULL,_T(""));
      if(cp){kount++; crontab[n].pszCmd=_tcsdup(cp);}
      else pszErr=_T("Field `command' not exists");
      goto next_line;
      break;
  }
  kount++;
  cp=_tcstok(NULL,_T(" \t"));
}
next_line:;
if(5 != kount)OutDebug(_T("Line %d: error %s\n"), iFileLine, pszErr);

OutDebug(_T("%2d) %d %d %d %d %d  [%s]\n"), n, crontab[n].min,crontab[n].hour,crontab[n].mday,crontab[n].month,crontab[n].wday,crontab[n].pszCmd);

if(crontab[n].min<0 && crontab[n].hour<0){
  OutDebug(_T("Line %d: error: hour and minute not defined\n"), iFileLine);
  continue;
}

n++;
if(n>=(sizeof(crontab)/sizeof(crontab[0]))){
  OutDebug(_T("Too many rows in `%s', > %d\n"),Config.szCrontab, (sizeof(crontab)/sizeof(crontab[0])));
  break;
}

}//while(fgetws)
fclose(fpi);

return ;
}
//----------------------------------------------------------------------------
void
CrontabExecute(SYSTEMTIME *pst)
{
int i;

for(i=0; i<(sizeof(crontab)/sizeof(crontab[0]));i++){
if(!crontab[i].pszCmd)continue;
/*
_tprintf("%d/%d  %d/%d  %d/%d  %d/%d  %d/%d  \n",
crontab[i].min,pst->wMinute,
crontab[i].hour,pst->wHour,
crontab[i].mday,pst->wDay,
crontab[i].month,pst->wMonth,
crontab[i].wday,pst->wDayOfWeek);
*/

if(
(
((crontab[i].min<0)?1:crontab[i].min==pst->wMinute)&&
((crontab[i].hour<0)?1:crontab[i].hour==pst->wHour)&&
((crontab[i].month<0)?1:crontab[i].month==pst->wMonth)
)
&&
( (crontab[i].mday<0)?1:crontab[i].mday==pst->wDay||(crontab[i].wday<0)?1:crontab[i].wday==pst->wDayOfWeek) ){
	OutDebug(_T("CrontabExecute(`%s')\n"),crontab[i].pszCmd);
	HandleTimeEvent(crontab[i].pszCmd);
}
else OutDebug(_T("Skipped CrontabExecute(`%s')\n"),crontab[i].pszCmd);

}

return ;
}
//----------------------------------------------------------------------------
void
CrontabFirstExecute(SYSTEMTIME *pst)
{
int i;

for(i=0; i<(sizeof(crontab)/sizeof(crontab[0]));i++){
if(!crontab[i].pszCmd)continue;
if(_T('*')!=*crontab[i].pszCmd)continue;
if((crontab[i].month>0)?crontab[i].month!=pst->wMonth:0)continue;
if((crontab[i].mday>0)?crontab[i].mday!=pst->wDay:0)continue;
if((crontab[i].wday>0)?crontab[i].wday!=pst->wDayOfWeek:0)continue;

if(
((crontab[i].hour<0)?1:crontab[i].hour<=pst->wHour)
&&
(
 ((crontab[i].hour<0)?1:crontab[i].hour!=pst->wHour)?1:(crontab[i].min<0)?1:(crontab[i].min<pst->wMinute)
)
){
	OutDebug(_T("CrontabFirstExecute(`%s')\n"),crontab[i].pszCmd);
	Sleep(500); HandleTimeEvent(crontab[i].pszCmd);
}
else OutDebug(_T("Skipped CrontabFirstExecute(`%s')\n"),crontab[i].pszCmd);

}

return ;
}
//============================================================================
void
InstallService(void)
{
_TCHAR szModulePathname[MAX_PATH];
SC_HANDLE hSCM, hService;

OutDebug(_T("InstallService()"));

if(NULL==(hSCM=OpenSCManager(NULL,NULL,SC_MANAGER_CREATE_SERVICE))){
	OutDebugError(_T("ERROR: OpenSCManager(NULL,NULL,SC_MANAGER_CREATE_SERVICE)"));
	return ;
}

GetModuleFileName(NULL, (LPTSTR)szModulePathname, sizeof(szModulePathname));

// Add this service to the SCM's database.
if(NULL==(hService=CreateService(hSCM, (LPCTSTR)szServiceKeyName, (LPCTSTR)szServiceDisplayName, 0, SERVICE_WIN32_OWN_PROCESS, SERVICE_AUTO_START, SERVICE_ERROR_IGNORE, (LPCTSTR)szModulePathname, (LPCTSTR)NULL, NULL, (LPCTSTR)_T("NtLmSsp\0"), (LPCTSTR)NULL, (LPCTSTR)NULL))){
	OutDebugError(_T("ERROR: CreateService(%s)"),szServiceKeyName);
}
else _tprintf(_T("Service '%s' installed.\n"), szServiceDisplayName);

CloseServiceHandle(hService);
CloseServiceHandle(hSCM);

return ;
}
//============================================================================
void
RemoveService(void)
{
SC_HANDLE hSCM, hService;

OutDebugError(_T("RemoveService()"));

if(NULL==(hSCM=OpenSCManager(NULL,NULL,SC_MANAGER_CONNECT))){
	OutDebugError(_T("ERROR: OpenSCManager(NULL,NULL,SC_MANAGER_CONNECT)"));
	return ;
}

if(NULL==(hService=OpenService(hSCM, (LPCTSTR)szServiceKeyName, DELETE))){
	OutDebugError(_T("ERROR: OpenService(%s)"),szServiceKeyName);
	goto Exit0;
}

if(!DeleteService(hService)){
	OutDebugError(_T("ERROR: DeleteService(%s)"),szServiceKeyName);
	goto Exit1;
}
else _tprintf(_T("Service '%s' removed.\n"), szServiceDisplayName);

Exit1:;
CloseServiceHandle(hService);
Exit0:;
CloseServiceHandle(hSCM);

return ;
}
//============================================================================
void
UpdateConfig(void)
{
dwMarker=1;

if(0x4D6D4D40 != dwMagic){
	_tprintf(_T("\nWarning: service not running!\n\n"));
}
else
{
	_tprintf(_T("\nConfig will be updated.\n\n"));
}

return ;
}
//============================================================================
void
PrintConfig(void)
{

if(0x4D6D4D40 != dwMagic)_tprintf(_T("\nWarning: service not running!\n\n"));
else _tprintf(_T("\nStart Time: %s\n\n"), szStartTime);

_tprintf(_T("Service Key Name: `%s'\n"), szServiceKeyName);
_tprintf(_T("Service Display Name: `%s'\n\n"), szServiceDisplayName);

if(Config.szRunCmd5)_tprintf(_T("MrtgKick: `%s'\n"), Config.szRunCmd5);
else _tprintf(_T("MrtgKick NOT DEFINED!\n"));

if(*Config.szCrontab)_tprintf(_T("CronTab: `%s'\n\n"), Config.szCrontab);
else _tprintf(_T("CronTab NOT DEFINED!\n\n"));

_tprintf(_T("Debug: %s\n"), Config.isDebug?_T("Yes"):_T("No"));
_tprintf(_T("Run Only: %s\n\n"), Config.isRunOnly?_T("Yes"):_T("No"));

return ;
}
//============================================================================
void
GetLocalTimeString(_TCHAR *pszBuff)
{
SYSTEMTIME st;

memset((PVOID)&st,0,sizeof(st));
GetLocalTime(&st);
_stprintf(pszBuff,_T("%4d-%02d-%02d %2d:%02d:%02d"),st.wYear,st.wMonth,st.wDay,st.wHour,st.wMinute,st.wSecond);

return ;
}
//============================================================================
int
wmain(int argc, _TCHAR **argv)
{
int i;
SERVICE_TABLE_ENTRY ServiceTable[]={
  {(LPTSTR)szServiceKeyName, (LPSERVICE_MAIN_FUNCTION)ServiceMain},
  {NULL,        NULL}
};


argc--;argv++;

for(i=0; i<argc; i++,argv++){
   if((_T('-')==**argv)||(_T('/')==**argv)){
	if(!_tcsicmp(*argv+1, _T("install")))InstallService();
	if(!_tcsicmp(*argv+1, _T("remove")) )RemoveService();
	if(!_tcsicmp(*argv+1, _T("run"))  ){Config.isRunOnly=Config.isDebug=TRUE;}
	if(!_tcsicmp(*argv+1, _T("update"))  ){UpdateConfig(); exit(0);}
	if(!_tcsicmp(*argv+1, _T("info"))  ){PrintConfig(); exit(0);}
	if(!_tcsicmp(*argv+1, _T("h"))||!_tcsicmp(*argv+1, _T("help"))||!_tcsicmp(*argv+1, _T("?"))){
		_tprintf(_T("Usage: %s      option\n"),*(argv-1));
		_tprintf(_T("\t-install - install service\n"));
		_tprintf(_T("\t-remove  - remove service\n"));
		_tprintf(_T("\t-run     - run as executable\n"));
		_tprintf(_T("\t-update  - update service configuration\n"));
		_tprintf(_T("\t-info    - print configuration\n"));
		exit(0);
	}
   }
}


if(Config.isRunOnly){
	// Running as EXE not as service, just run the service for debugging
	OutDebug(_T("*** DEBUG ***"));
	ServiceMain(0, NULL);
	exit(0);
}
else {

LPVOID lpMsgBuf;
if(!StartServiceCtrlDispatcher(ServiceTable)){
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,NULL,GetLastError(),MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),(LPTSTR)&lpMsgBuf,0,NULL);
	OutDebug(_T("ERROR: StartServiceCtrlDispatcher() - %s\n"),(_TCHAR*)lpMsgBuf);
	LocalFree(lpMsgBuf);
}

}


return(0);
}
//============================================================================
//-=EOF=-

