
      SUBROUTINE INVBLD(N)
C-----------------------------------------------
C     Element inverse-solution editing routine.
C-----------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 VAR, PVAR
      CHARACTER*4 VAR4
      CHARACTER*8 CHTMP
      CHARACTER*80 LINE, LINET
      LOGICAL ERROR, NEWOFF
C




      SUBROUTINE QPLINI(LDEF)
C----------------------------------------------
C     Sets up Qspec(s) plot.
C     If LDEF=t, sets default offsets.
C----------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LDEF
      LOGICAL LAIR
C
C---- number of x/c grid lines
      PARAMETER (NG=10,NQ=20)
      DIMENSION SSPG(-NG:NG), SLPG(-NG:NG), QSPG(-NQ:NQ)
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      INCLUDE 'AIRDES.INC'
C
C---- make room for airfoil plot if complex-mapping routine is being used
      LAIR = NSP .EQ. NC1
C
C---- annotation character height
      CHT = 0.7*CH
C
C---- speed annotation increment
      DQANN = 0.5
C
C---- find max and min speeds for current Qgamm and Qspec
      QMIN = QGAMM(1)
      QMAX = QGAMM(1)
      DO 5 I=2, NSP
        QMIN = MIN(QMIN,QGAMM(I))
        QMAX = MAX(QMAX,QGAMM(I))
    5 CONTINUE
C
      DO 7 KQSP=1, NQSP
        DO 72 I=2, NSP
          QMIN = MIN(QMIN,QSPEC(I,KQSP))
          QMAX = MAX(QMAX,QSPEC(I,KQSP))
 72     CONTINUE
 7    CONTINUE
C
      QMIN = QCOMP(QMIN)/QINF
      QMAX = QCOMP(QMAX)/QINF
C
C---- round up to bounding annotations
      NMIN = INT(QMIN/DQANN) - 1
      NMAX = INT(QMAX/DQANN) + 1
C
      IF(LQREFL) THEN
C----- set limits so reflectes Qspec(s) also fits on plot
       NMAX = MAX( ABS(NMIN) , ABS(NMAX) )
       NMIN = -NMAX
      ENDIF
C
      QMIN = DQANN*FLOAT(NMIN)
      QMAX = DQANN*FLOAT(NMAX)
C
C
C---- start new plot
      CALL PLTINI
C
C---- speed plotting scale factor
      QFAC = 1.0/(QMAX-QMIN)
C
C---- default offsets
      IF(LDEF) THEN
        XADD = 0.050
        YADD = 0.075
        XSF = (XWIND/SIZE) / (1.0 + 2.0*XADD)
        YSF = (YWIND/SIZE) / (1.0 + 2.0*YADD)
        XOFF = -XADD - 2.0*CHT/XSF
        YOFF = -YADD + QMIN*QFAC
      ENDIF
C
      CALL SPLIND(XSPOC,W7,SSPEC,NSP,-999.0,-999.0)
      CALL SPLIND(YSPOC,W8,SSPEC,NSP,-999.0,-999.0)
C
      DO 11 IG=1, NG
        XOC = FLOAT(IG)/FLOAT(NG)
        SSP = SSPLE + (SSPEC(1)-SSPLE)*XOC
        CALL SINVRT(SSP,XOC,XSPOC,W7,SSPEC,NSP)
        SSPG(IG) = XMOD(1.0-SSP)
C
        XOC = 0.1*FLOAT(IG)/FLOAT(NG)
        SSP = SSPLE + (SSPEC(1)-SSPLE)*XOC
        CALL SINVRT(SSP,XOC,XSPOC,W7,SSPEC,NSP)
        SLPG(IG) = XMOD(1.0-SSP)
   11 CONTINUE
C
      SSPG(0) = XMOD(1.0-SSPLE)
      SLPG(0) = XMOD(1.0-SSPLE)
C
      DO 12 IG=-NG,-1
        XOC = FLOAT(-IG)/FLOAT(NG)
        SSP = SSPLE + (SSPEC(NSP)-SSPLE)*XOC
        CALL SINVRT(SSP,XOC,XSPOC,W7,SSPEC,NSP)
        SSPG(IG) = XMOD(1.0-SSP)
C
        XOC = 0.1*FLOAT(-IG)/FLOAT(NG)
        SSP = SSPLE + (SSPEC(NSP)-SSPLE)*XOC
        CALL SINVRT(SSP,XOC,XSPOC,W7,SSPEC,NSP)
        SLPG(IG) = XMOD(1.0-SSP)
   12 CONTINUE
C
C
C---- plot axes
      CALL NEWPEN(1)
      CALL PLOT(XMOD(0.0),YMOD(0.0),3)
      CALL PLOT(XMOD(1.0),YMOD(0.0),2)
      CALL PLOT(XMOD(0.0),YMOD(QFAC*QMIN),3)
      CALL PLOT(XMOD(0.0),YMOD(QFAC*QMAX),2)
      CALL PLOT(XMOD(1.0),YMOD(QFAC*QMIN),3)
      CALL PLOT(XMOD(1.0),YMOD(QFAC*QMAX),2)
C
C---- plot sonic lines if within range
      IF( QSTAR/QINF.LE.QMAX)
     &  CALL DASH(XMOD(0.0),XMOD(1.0),YMOD( QFAC*QSTAR/QINF))
      IF(-QSTAR/QINF.GE.QMIN)
     &  CALL DASH(XMOD(0.0),XMOD(1.0),YMOD(-QFAC*QSTAR/QINF))
C
C---- annotate axes
      DO 20 NT=NMIN, NMAX
        YPLT = QFAC*(QMAX-QMIN)*FLOAT(NT)/FLOAT(NMAX-NMIN)
ccc        IF(MOD(NT,2).EQ.0) THEN
         RNUM = DQANN*FLOAT(NT)
         CALL NEWPEN(2)
         XNUM = XMOD( 0.0)-3.5*CHT 
         YNUM = YMOD(YPLT)-0.5*CHT
         IF(RNUM.LT.0.0) XNUM = XNUM - CHT
         CALL NUMBER(XNUM,YNUM,CHT,RNUM,0.0,1)
ccc        ENDIF
C
        QSPG(NT) = YMOD(0.0)
        IF(IABS(NT).LE.NQ) QSPG(NT) = YMOD(YPLT)
C
        CALL NEWPEN(1)
        CALL PLOT(XMOD(0.0)        ,YMOD(YPLT),3)
        CALL PLOT(XMOD(0.0)-0.3*CHT,YMOD(YPLT),2)
        CALL PLOT(XMOD(1.0)        ,YMOD(YPLT),3)
        CALL PLOT(XMOD(1.0)+0.3*CHT,YMOD(YPLT),2)
   20 CONTINUE
C
      XPLT = 0.5*(SSPG(NG-2)+SSPG(NG-3)) - 1.2*CHT
      CALL PLCHAR(XPLT,YMOD(0.0)-1.6*CHT,CHT,'x/c',0.0,3)
C
      YPLT = QFAC*(QMAX-QMIN)*(FLOAT(NMAX)-1.5)/FLOAT(NMAX-NMIN)
      CALL PLCHAR(XMOD(0.0)-4.5*CHT,YMOD(YPLT)-0.6*CHT,
     &            1.2*CHT,'q/q ',0.0,4)
      CALL PLMATH(XMOD(0.0)-4.5*CHT,YMOD(YPLT)-0.6*CHT,
     &            1.2*CHT,'   &',0.0,4)
C
      INCR = MAX((2*NG)/20,1)
      DO 21 IG=-NG+INCR, NG-INCR, INCR
        CALL PLOT(SSPG(IG),QSPG(0)+0.20*CHT,3)
        CALL PLOT(SSPG(IG),QSPG(0)-0.20*CHT,2)
        CALL PLOT(SLPG(IG),QSPG(0)+0.15*CHT,3)
        CALL PLOT(SLPG(IG),QSPG(0)-0.15*CHT,2)
   21 CONTINUE
C
      INCR = MAX((2*NG)/4,1)
      DO 22 IG=-NG+INCR, NG-INCR, INCR
        CALL PLOT(SSPG(IG),QSPG(0)+0.40*CHT,3)
        CALL PLOT(SSPG(IG),QSPG(0)-0.40*CHT,2)
        CALL PLOT(SLPG(IG),QSPG(0)+0.30*CHT,3)
        CALL PLOT(SLPG(IG),QSPG(0)-0.30*CHT,2)
   22 CONTINUE
C
      INCR = MAX((2*NG)/2,1)
      DO 23 IG=-NG+INCR, NG-INCR, INCR
        CALL PLOT(SSPG(IG),QSPG(0)+0.80*CHT,3)
        CALL PLOT(SSPG(IG),QSPG(0)-0.80*CHT,2)
        CALL PLOT(SLPG(IG),QSPG(0)+0.60*CHT,3)
        CALL PLOT(SLPG(IG),QSPG(0)-0.60*CHT,2)
   23 CONTINUE
C
C
      IF(LQGRID) THEN
        DO 30 K=1, NG
          W1(K) = SSPG(K-NG) - SSPG(K-1-NG)
          W2(K) = SSPG(K)    - SSPG(K-1)
          W6(K) = SLPG(K-NG) - SLPG(K-1-NG)
          W7(K) = SLPG(K)    - SLPG(K-1)
   30   CONTINUE
        DO 33 K=1, -NMIN
          W3(K) = QSPG(K+NMIN) - QSPG(K-1+NMIN)
   33   CONTINUE
        DO 34 K=1, NMAX
          W4(K) = QSPG(K)      - QSPG(K-1)
   34   CONTINUE
C
        CALL NEWPEN(1)
        CALL PLGRID(SSPG(-NG),QSPG(NMIN),1000+NG,W1,1000-NMIN,W3,LMASK2)
        CALL PLGRID(SSPG(0)  ,QSPG(0)   ,1000+NG,W2,1000+NMAX,W4,LMASK2)
cc        CALL PLGRID(SLPG(-NG),QSPG(NMIN),1000+NG,W6,1000-NMIN,W3,LMASK1)
cc        CALL PLGRID(SLPG(0)  ,QSPG(0)   ,1000+NG,W7,1000+NMAX,W4,LMASK1)
      ENDIF
C
      CALL PLFLUSH
C
      RETURN
      END


      SUBROUTINE QSPLOT
C------------------------------------------------
C     Plots Gamma(s) and Qspec(s) distributions.
C------------------------------------------------
      INCLUDE 'AIRSET.INC'
      INCLUDE 'AIRDES.INC'
C
C---- symbol width
      SHT = 0.4*CH
C
      IF(LSYM) THEN
       DO 50 I=1, NSP
         XPLT = 1.0 - SSPEC(I)
         YPLT = QFAC*QCOMP(QGAMM(I))/QINF
         CALL PLSYMB(XMOD(XPLT),YMOD(YPLT),SHT,3,0.0,0)
   50  CONTINUE
      ENDIF
C
      NTQSPL = 1
      IF(LQSLOP) NTQSPL = 8
C
C---- plot individual Qspec lines
      DO 60 KQSP=1, NQSP
        CALL QSPPLT(1,NSP,KQSP,NTQSPL)
 60   CONTINUE
C
C
      IF(LQVDES) THEN
       DO 65 I=2, N
         DSP = S(I) - S(I-1)
         DQV = QCOMP(QVIS(I)) - QCOMP(QVIS(I-1))
         SP1 = (S(I-1) + 0.25*DSP)/S(N)
         SP2 = (S(I)   - 0.25*DSP)/S(N)
         QV1 = QCOMP(QVIS(I-1)) + 0.25*DQV
         QV2 = QCOMP(QVIS(I)  ) - 0.25*DQV
         CALL PLOT(XMOD(1.0-SP1),YMOD(QFAC*QV1/QINF),3)
         CALL PLOT(XMOD(1.0-SP2),YMOD(QFAC*QV2/QINF),2)
   65  CONTINUE
      ENDIF
C
      IF(LQREFL) THEN
C
       KQSP = 1
C
C----- find stagnation point SSPEC value SSPST
       DO 70 ISTSP=1, NSP-1
         IF(QSPEC(ISTSP+1,KQSP).LT.0.0) GO TO 71
   70  CONTINUE
   71  DSSP = SSPEC(ISTSP+1)   - SSPEC(ISTSP)
       DQSP = QSPEC(ISTSP+1,KQSP) - QSPEC(ISTSP,KQSP)
       SSPST = SSPEC(ISTSP) - QSPEC(ISTSP,KQSP)*DSSP/DQSP
C
C----- plot reflected suction side QSPEC over pressure side QSPEC,
C-     fudging arc length SSPEC so stagnation points conside
       SPFUDG = (SSPEC(NSP) - SSPST) / (SSPST - SSPEC(1))
       DO 80 I=2, ISTSP
         DSP = (SSPEC(I) - SSPEC(I-1))*SPFUDG
         DQS = QCOMP(QSPEC(I,KQSP)) - QCOMP(QSPEC(I-1,KQSP))
         SP1 = (SSPEC(I-1) + 0.35*DSP)*SPFUDG
         SP2 = (SSPEC(I)   - 0.35*DSP)*SPFUDG
         QS1 = QCOMP(QSPEC(I-1,KQSP)) + 0.35*DQS
         QS2 = QCOMP(QSPEC(I  ,KQSP)) - 0.35*DQS
         CALL PLOT(XMOD(SP1),YMOD(-QFAC*QS1/QINF),3)
         CALL PLOT(XMOD(SP2),YMOD(-QFAC*QS2/QINF),2)
   80  CONTINUE
C
C----- plot reflected pressure side QSPEC over suction side QSPEC,
C-     again fudging arc length SSPEC so stagnation points coincide
       SPFUDG = (SSPST - SSPEC(1)) / (SSPEC(NSP) - SSPST)
       DO 85 I=ISTSP+1, NSP
         DSP = (SSPEC(I) - SSPEC(I-1))*SPFUDG
         DQS = QCOMP(QSPEC(I,KQSP)) - QCOMP(QSPEC(I-1,KQSP))
         SP1 = 1.0 - SSPST + (SSPEC(I-1) + 0.35*DSP - SSPST)*SPFUDG
         SP2 = 1.0 - SSPST + (SSPEC(I)   - 0.35*DSP - SSPST)*SPFUDG
         QS1 = QCOMP(QSPEC(I-1,KQSP)) + 0.35*DQS
         QS2 = QCOMP(QSPEC(I  ,KQSP)) - 0.35*DQS
         CALL PLOT(XMOD(SP1),YMOD(-QFAC*QS1/QINF),3)
         CALL PLOT(XMOD(SP2),YMOD(-QFAC*QS2/QINF),2)
   85  CONTINUE
C
      ENDIF
C
      CALL PLFLUSH
      LQSPPL = .TRUE.
C
      IF(.NOT.LIQSET) RETURN
C
      KQSP = KQTARG
C
      YPLT1 = QFAC*QCOMP(QSPEC(IQ1,KQSP))/QINF
      YPLT2 = QFAC*QCOMP(QSPEC(IQ2,KQSP))/QINF
      CALL PLOT(XMOD(1.0-SSPEC(IQ1)),YMOD(YPLT1)-0.03,3)
      CALL PLOT(XMOD(1.0-SSPEC(IQ1)),YMOD(YPLT1)+0.03,2)
      CALL PLOT(XMOD(1.0-SSPEC(IQ2)),YMOD(YPLT2)-0.03,3)
      CALL PLOT(XMOD(1.0-SSPEC(IQ2)),YMOD(YPLT2)+0.03,2)
      CALL PLFLUSH
C
      RETURN
      END


      SUBROUTINE QSPPLT(IQSPL1,IQSPL2,KQSP,NT)
      INCLUDE 'AIRSET.INC'
      INCLUDE 'AIRDES.INC'
C
      DO 10 I=IQSPL1+1, IQSPL2
        DS = SSPEC(I) - SSPEC(I-1)
C
        XPLT = 1.0 - SSPEC(I-1)
        YPLT = QFAC*QCOMP(QSPEC(I-1,KQSP))/QINF
        CALL PLOT(XMOD(XPLT),YMOD(YPLT),3)
C
        DO 102 IT=1, NT
          SSPT = SSPEC(I-1) + DS*FLOAT(IT)/FLOAT(NT)
          QSPT = SEVAL(SSPT,QSPEC(1,KQSP),QSPECP(1,KQSP),SSPEC,NSP)
          XPLT = 1.0 - SSPT
          YPLT = QFAC*QCOMP(QSPT)/QINF
          CALL PLOT(XMOD(XPLT),YMOD(YPLT),2)
 102    CONTINUE
 10   CONTINUE
C
      RETURN
      END

 
 
      SUBROUTINE IQSGET
C------------------------------------------------------------
C     Sets target segment endpoint indices from cursor input.
C------------------------------------------------------------
      INCLUDE 'AIRSET.INC'
      DIMENSION IQNEW(2)
      CHARACTER*1 CHKEY
      INCLUDE 'AIRDES.INC'
C
      IF(.NOT.LQSPPL) THEN
       CALL QPLINI(.FALSE.)
       CALL QSPLOT
      ENDIF
C
      SH = 0.01*XSF
C
      IQNEW(1) = 0
      IQNEW(2) = 0
      WRITE(*,*)
      WRITE(*,*) 'Mark off segment endpoints'
      WRITE(*,*)
      DO 10 IE=1, 2
C
C------ get cursor location from user
    5   CALL GETCURSORXY(XE,YE,CHKEY)
        DMIN = 1.0E9
        IQNEW(IE) = 1
        KQMIN = 1
C
C------ search all Qspec lines only for first selected point
        IF(IE.EQ.1) THEN
          KQSP1 = 1
          KQSPN = NQSP
        ELSE
          KQSP1 = KQTARG
          KQSPN = KQTARG
        ENDIF
C
C------ find plot point closest to cursor point
        DO 102 KQSP=KQSP1, KQSPN
          DO 1024 I=1, NSP
            GCOMP = QCOMP(QSPEC(I,KQSP))/QINF
            XPNT = XMOD(1.0-SSPEC(I))
            YPNT = YMOD(QFAC*GCOMP)
            DIST = (XE - XPNT)**2 + (YE - YPNT)**2
            IF(DIST.GT.DMIN) GO TO 1024
              DMIN = DIST
              IQNEW(IE) = I
              KQMIN = KQSP
 1024     CONTINUE
 102    CONTINUE
C
C------ nearest point to first clicked point sets target line
        IF(IE.EQ.1) KQTARG = KQMIN
C
        I = IQNEW(IE)
        QSCOMP = QCOMP(QSPEC(I,KQTARG))/QINF 
        CALL PLOT(XMOD(1.0-SSPEC(I)),YMOD(QFAC*QSCOMP)-0.03,3)
        CALL PLOT(XMOD(1.0-SSPEC(I)),YMOD(QFAC*QSCOMP)+0.03,2)
        CALL PLFLUSH
   10 CONTINUE
C
      IF(IQNEW(1).EQ.IQNEW(2)) THEN
       WRITE(*,*) '***  Endpoints must be distinct  ***'
       WRITE(*,*) '***  NEW SEGMENT NOT MARKED OFF  ***'
       RETURN
      ENDIF
C
      IQ1 = MIN0(IQNEW(1),IQNEW(2))
      IQ2 = MAX0(IQNEW(1),IQNEW(2))
C
      LIQSET = .TRUE.
      RETURN
      END


      SUBROUTINE MODQ(IQMOD1,IQMOD2,KQSP)
C--------------------------------------------------
C     Modifies current Qspec(s) from cursor input.
C
C     The extent of the modification is returned 
C     in the two indices:    IDMOD1 < i < IQMOD2
C
C     The index of the Qspec curve modified is
C     returned in KQSP.
C--------------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 CHKEY
      LOGICAL LSLOP1, LSLOP2
      LOGICAL LABORT
      INCLUDE 'AIRDES.INC'
C
      IF(.NOT.LQSPPL) THEN
       CALL QPLINI(.FALSE.)
       CALL QSPLOT
      ENDIF
C
      SHT = 0.3*CH
C
      DO 5 I=1, IQX
        W1(I) = 0.
        W2(I) = 0.
        W3(I) = 0.
    5 CONTINUE
C
      CALL PABORT(1.0,0.0)
      CALL PLFLUSH
C
      WRITE(*,*)
      WRITE(*,*) 'Input Qspec values'
      WRITE(*,*) 'Terminate last entry with 3 clicks on one point'
      WRITE(*,*)
C
C---- read first Qspec point plot coordinates
      K = 1
      CALL GETCURSORXY(W1(K),W2(K),CHKEY)
C
      IF(LABORT(W1(K),W2(K))) THEN
C------ return with no changes
        IQMOD1 = 1
        IQMOD2 = 1
        RETURN
      ENDIF
C
      IF(NQSP.EQ.1) THEN
        KQSP = 1
      ELSE
C------ multiple Qspec lines...
C       ... find nearest point to set target Qspec index
        DMIN = 1.0E9
        DO 7 KQSP=1, NQSP
          DO 72 I=1, NSP
            GCOMP = QCOMP(QSPEC(I,KQSP))/QINF
            XPNT = XMOD(1.0-SSPEC(I))
            YPNT = YMOD(QFAC*GCOMP)
            DIST = (W1(K) - XPNT)**2 + (W2(K) - YPNT)**2
            IF(DIST.GT.DMIN) GO TO 72
              DMIN = DIST
              IMIN = I
              KMIN = KQSP
 72       CONTINUE
 7      CONTINUE
C
        KQSP = KMIN
      ENDIF
C
      IF(.NOT.LQSLOP) CALL PLSYMB(W1(K),W2(K),SHT,3,0.0,0)
C
C---- convert plot coordinates W1,W2 to actual Qi, s
      W1(K) = 1.0 - (W1(K)/XSF + XOFF)
      QSCOM =  QINF*(W2(K)/YSF + YOFF)/QFAC
      W2(K) = QINCOM(QSCOM,QINF,TKLAM)
C
      LSLOP1 = LQSLOP .AND. W1(K).GE.SSPEC(1) .AND. W1(K).LE.SSPEC(NSP)
      IF(LSLOP1) THEN
C------ reset first point from spline, draw "o" symbol there
        W2(K) = SEVAL(W1(K),QSPEC(1,KQSP),QSPECP(1,KQSP),SSPEC,NSP)
        QSCOM = QCOMP(W2(K))
        CALL PLSYMB(XMOD(1.0-W1(K)),YMOD(QFAC*QSCOM/QINF),SHT,1,0.0,0)
      ENDIF
C
C---- read in subsequent points
      DO 10 K=2, IQX
        CALL GETCURSORXY(W1(K),W2(K),CHKEY)
C
        IF(LABORT(W1(K),W2(K))) THEN
C-------- return with no changes
          IQMOD1 = 1
          IQMOD2 = 1
          RETURN
        ENDIF
C
CCCC------ draw pixel (zero-length vector) at cursor location
CCC        CALL PLOT(W1(K),W2(K),3)
CCC        CALL PLOT(W1(K),W2(K),2)
C
C------ draw a "+" symbol at cursor location
        CALL PLSYMB(W1(K),W2(K),SHT,3,0.0,0)
C
C------ remove offset and scaling to get true incompressible Q,s values
        W1(K) = 1.0 - (W1(K)/XSF + XOFF)
        QSCOM =  QINF*(W2(K)/YSF + YOFF)/QFAC
        W2(K) = QINCOM(QSCOM,QINF,TKLAM)
C
C------ if at least three points exist, check if this is last point
        IF(K.GE.3) THEN
         IF(W1(K).EQ.W1(K-1) .AND. W1(K).EQ.W1(K-2)) GO TO 11
        ENDIF
   10 CONTINUE
   11 CONTINUE
C
      LSLOP2 = LQSLOP .AND. W1(K).GE.SSPEC(1) .AND. W1(K).LE.SSPEC(NSP)
      IF(LSLOP2) THEN
C------ reset last point from spline, draw "o" symbol there
        W2(K) = SEVAL(W1(K),QSPEC(1,KQSP),QSPECP(1,KQSP),SSPEC,NSP)
        QSCOM = QCOMP(W2(K))
        CALL PLSYMB(XMOD(1.0-W1(K)),YMOD(QFAC*QSCOM/QINF),SHT,1,0.0,0)
      ENDIF
C
C---- set number of input points
      KK = K
C
C---- sort points, removing identical pairs
      CALL SORT(KK,W1,W2)
C
C---- assume no points have been changed
      IQMOD1 = 1
      IQMOD2 = 1
C
      IF(KK.LT.2) THEN
       WRITE(*,*)
       WRITE(*,*) '***  Need at least 2 points    ***'
       WRITE(*,*) '***     NO CHANGES MADE        ***'
       WRITE(*,*)
       RETURN
      ENDIF
C
C---- default natural (zero 3rd derivative) end conditions
      QP1 = -999.0
      QP2 = -999.0
C
C---- set spline endpoint derivatives to match current Qspec's
      IF(LSLOP1)
     &   QP1 = DEVAL(W1(1) ,QSPEC(1,KQSP),QSPECP(1,KQSP),SSPEC,NSP)
      IF(LSLOP2)
     &   QP2 = DEVAL(W1(KK),QSPEC(1,KQSP),QSPECP(1,KQSP),SSPEC,NSP)
C
C---- set suitable number of plotting sub-intervals
      DSP = (SSPEC(NSP)-SSPEC(1))/FLOAT(NSP-1)
      DW1 = (W1(KK)    -W1(1)   )/FLOAT(KK-1 )
      NT = INT( 10.0 * MAX(DW1/DSP,1.0) )
C
C---- strip out any remaining double points
      K = 1
 20   K = K+1
 21   IF(K.GT.KK) GO TO 25
      IF(W1(K) .EQ. W1(K-1)) THEN
C------ eliminate point K by pulling down all points after it
        DO 22 KT=K, KK-1
          W1(KT) = W1(KT+1)
          W2(KT) = W2(KT+1)
          W3(KT) = W3(KT+1)
 22     CONTINUE
        KK = KK-1
        GO TO 21
      ELSE
C------ check next point
        GO TO 20
      ENDIF
C
 25   CONTINUE
      IF(KK.LT.2) THEN
       WRITE(*,*) '***  Corrupted input detected  ***'
       WRITE(*,*) '***       NO CHANGES MADE      ***'
       RETURN
      ENDIF
C
C---- spline new Qspec segment coordinates
      CALL SPLIND(W2,W3,W1,KK,QP1,QP2)
C
cC---- plot segment as piecewise linear or with spline, depending on NT
c      DO 30 K=2, KK
c        DS = W1(K) - W1(K-1)
cC
c        SSPT = W1(K-1)
c        QSPT = W2(K-1)
c        XPLT = 1.0 - SSPT
c        YPLT = QFAC*QCOMP(QSPT)/QINF
c        CALL PLOT(XMOD(XPLT),YMOD(YPLT),3)
cC
c        DO 310 IT=1, NT
c          SSPT = W1(K-1) + DS*FLOAT(IT)/FLOAT(NT)
c          QSPT = SEVAL(SSPT,W2,W3,W1,KK)
c          XPLT = 1.0 - SSPT
c          YPLT = QFAC*QCOMP(QSPT)/QINF
c          CALL PLOT(XMOD(XPLT),YMOD(YPLT),2)
c  310   CONTINUE
c   30 CONTINUE
c      CALL PLFLUSH
cC
C---- set Qspec array inside modified interval W1(1) < s < W1(KK)
      DO 40 I=1, NSP
        SSP = SSPEC(I)
        IF(SSP.LT.W1(1)) THEN
         IQMOD1 = I
         GO TO 40
        ELSE IF(SSP.LE.W1(KK)) THEN
C------- set new Qspec, and also opposite point if symmetry flag is set
         QSPEC(I,KQSP) = SEVAL(SSP,W2,W3,W1,KK)
cc         IF(LQSYM) QSPEC(NSP-I+1,KQSP) = -QSPEC(I,KQSP)
        ELSE
         IQMOD2 = I
         GO TO 41
        ENDIF
   40 CONTINUE
   41 CONTINUE
C
      LQSPPL = .FALSE.
C
      RETURN
      END


      SUBROUTINE SPLQSP(KQSP)
C------------------------------------------------------
C     Splines Qspec(s).  The end intervals are treated
C     specially to avoid Gibbs-type problems from 
C     blindly splining to the stagnation point.
C------------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
C---- usual spline with natural end BCs
ccc   CALL SPLIND(QSPEC(2,KQSP),QSPECP(2,KQSP),SSPEC(2),NSP-2,
ccc  &            -999.0,-999.0)
C
C---- pseudo-monotonic spline with simple secant slope calculation
      CALL SPLINA(QSPEC(2,KQSP),QSPECP(2,KQSP),SSPEC(2),NSP-2)
C
C---- end intervals are splined separately with natural BCs at
C     the trailing edge and matching slopes at the interior points
C
      I = 1
      CALL SPLIND(QSPEC(I,KQSP),QSPECP(I,KQSP),SSPEC(I),2,
     &            -999.0,QSPECP(I+1,KQSP))
C
      I = NSP-1
      CALL SPLIND(QSPEC(I,KQSP),QSPECP(I,KQSP),SSPEC(I),2,
     &            QSPECP(I,KQSP),-999.0)
C
      RETURN
      END


      SUBROUTINE SMOOQ(KQ1,KQ2,KQSP)
C--------------------------------------------
C     Smooths Qspec(s) inside target segment
C--------------------------------------------
      INCLUDE 'AIRSET.INC'
C
cC---- calculate smoothing coordinate
ccc      IF(NSP.EQ.NC1) THEN
cC
cC------ mapping inverse: use circle plane coordinate
c        I = 1
c        W8(I) = 0.0
c        DO 10 I=2, NSP
c          SINW = 2.0*SIN( 0.25*(WC(I)+WC(I-1)) )
c          SINWE = SINW**(1.0-AGTE)
cC
c          DSDW = SINWE * EXP( REAL(0.5*(PIQ(I)+PIQ(I-1)) ))
c          W8(I) = W8(I-1) + (WC(I)-WC(I-1))/DSDW
c   10   CONTINUE
c        DO 11 I=1, NSP
c          W8(I) = W8(I)/W8(NSP)
c 11     CONTINUE
cC
cC------ do not smooth first and last intervals in circle plane
c        KQ1 = MAX(IQ1,2)
c        KQ2 = MIN(IQ2,NSP-1)
cC
ccc      ELSE
C
C------ mixed inverse: use arc length coordinate
        DO 15 I=1, NSP
          W8(I) = SSPEC(I)
   15   CONTINUE
C
ccc      ENDIF
C
C
      IF(KQ2-KQ1 .LT. 2) THEN
       WRITE(*,*) 'Segment is too short.  No smoothing possible.'
       RETURN
      ENDIF
C
C---- set smoothing length ( ~ distance over which data is smeared )
      SMOOL = 0.002*(W8(NSP) - W8(1))
CCC   CALL ASKR('Enter Qspec smoothing length^',SMOOL)
C
C---- set up tri-diagonal system for smoothed Qspec
      SMOOSQ = SMOOL**2
      DO 20 I=KQ1+1, KQ2-1
        DSM = W8(I  ) - W8(I-1)
        DSP = W8(I+1) - W8(I  )
        DSO = 0.5*(W8(I+1) - W8(I-1))
C
        W1(I) =  SMOOSQ * (         - 1.0/DSM) / DSO
        W2(I) =  SMOOSQ * ( 1.0/DSP + 1.0/DSM) / DSO  +  1.0
        W3(I) =  SMOOSQ * (-1.0/DSP          ) / DSO
   20 CONTINUE
C
C---- set fixed-Qspec end conditions
      W2(KQ1) = 1.0
      W3(KQ1) = 0.0
C
      W1(KQ2) = 0.0
      W2(KQ2) = 1.0
C
      IF(LQSLOP) THEN
C----- also enforce slope matching at endpoints
       I = KQ1 + 1
       DSM = W8(I  ) - W8(I-1)
       DSP = W8(I+1) - W8(I  )
       DS  = W8(I+1) - W8(I-1)
       W1(I) = -1.0/DSM - (DSM/DS)/DSM
       W2(I) =  1.0/DSM + (DSM/DS)/DSM + (DSM/DS)/DSP
       W3(I) =                         - (DSM/DS)/DSP
       QSPP1 = W1(I)*QSPEC(I-1,KQSP)
     &       + W2(I)*QSPEC(I  ,KQSP)
     &       + W3(I)*QSPEC(I+1,KQSP)
C
       I = KQ2 - 1
       DSM = W8(I  ) - W8(I-1)
       DSP = W8(I+1) - W8(I  )
       DS  = W8(I+1) - W8(I-1)
       W1(I) =                           (DSP/DS)/DSM
       W2(I) = -1.0/DSP - (DSP/DS)/DSP - (DSP/DS)/DSM
       W3(I) =  1.0/DSP + (DSP/DS)/DSP
       QSPP2 = W1(I)*QSPEC(I-1,KQSP)
     &       + W2(I)*QSPEC(I  ,KQSP)
     &       + W3(I)*QSPEC(I+1,KQSP)
C
       QSPEC(KQ1+1,KQSP) = QSPP1
       QSPEC(KQ2-1,KQSP) = QSPP2
      ENDIF
C
C
C---- solve for smoothed Qspec array
      CALL TRISOL(W2(KQ1),W1(KQ1),W3(KQ1),QSPEC(KQ1,KQSP),(KQ2-KQ1+1))
C
C
cc      IF(LQSYM) THEN
cc        DO 40 I=KQ1+1, KQ2-1
cc          QSPEC(NSP-I+1,KQSP) = -QSPEC(I,KQSP)
cc 40     CONTINUE
cc      ENDIF
C
      RETURN
      END
 

      FUNCTION QINCOM(QC,QINF,TKLAM)
C-------------------------------------
C     Sets incompressible speed from
C     Karman-Tsien compressible speed
C-------------------------------------
C
      IF(TKLAM.LT.1.0E-4 .OR. ABS(QC).LT.1.0E-4) THEN
C----- for nearly incompressible case or very small speed, use asymptotic
C      expansion of singular quadratic formula to avoid numerical problems
       QINCOM = QC/(1.0 - TKLAM)
      ELSE
C----- use quadratic formula for typical case
       TMP = 0.5*(1.0 - TKLAM)*QINF/(QC*TKLAM)
       QINCOM = QINF*TMP*(SQRT(1.0 + 1.0/(TKLAM*TMP**2)) - 1.0)
      ENDIF
      RETURN
      END 

 
      SUBROUTINE SORT(KK,S,W)
      DIMENSION S(KK), W(KK)
      LOGICAL DONE
C
C---- sort arrays
      DO 10 IPASS=1, 1234
        DONE = .TRUE.
        DO 101 N=1, KK-1
          NP = N+1
          IF(S(NP).GE.S(N)) GO TO 101
           TEMP = S(NP)
           S(NP) = S(N)
           S(N) = TEMP
           TEMP = W(NP)
           W(NP) = W(N)
           W(N) = TEMP
           DONE = .FALSE.
  101   CONTINUE
        IF(DONE) GO TO 11
   10 CONTINUE
      WRITE(*,*) 'Sort failed'
C
C---- search for duplicate pairs and eliminate each one
   11 KKS = KK
      DO 20 K=1, KKS
        IF(K.GE.KK) RETURN
        IF(S(K).NE.S(K+1)) GO TO 20
C------- eliminate pair
         KK = KK-2
         DO 201 KT=K, KK
           S(KT) = S(KT+2)
           W(KT) = W(KT+2)
  201    CONTINUE
   20 CONTINUE
C
      RETURN
      END
 
 
 
      SUBROUTINE GAMQSP(KQSP)
C------------------------------------------------
C     Sets Qspec(s,k) from current speed Gamma(s).
C------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      ALQSP(KQSP) = ALGAM
      CLQSP(KQSP) = CLGAM
      CMQSP(KQSP) = CMGAM
C
      DO 10 I=1, NSP
        QSPEC(I,KQSP) = QGAMM(I)
 10   CONTINUE
C
C---- zero out Qspec DOFs
      QDOF0 = 0.0
      QDOF1 = 0.0
      QDOF2 = 0.0
      QDOF3 = 0.0
C
      CALL SPLQSP(KQSP)
C
C---- reset target segment endpoints
      IF(.NOT.LIQSET) THEN
       IQ1 = 1
       IQ2 = NSP
      ENDIF
C
      RETURN
      END


      SUBROUTINE SYMQSP(KQSP)
C-----------------------------------------
C     Forces symmetry of Qspec(KQSP) array
C-----------------------------------------
      INCLUDE 'AIRSET.INC'
C
      ALQSP(KQSP) = 0.
      CLQSP(KQSP) = 0.
      CMQSP(KQSP) = 0.
C
      SSPMID = 0.5*(SSPEC(NSP) - SSPEC(1))
      DO 10 I=1, (NSP+1)/2
        SSPEC(I) = SSPMID + 0.5*(SSPEC(I)      - SSPEC(NSP-I+1)  )
        QSPEC(I,KQSP) =     0.5*(QSPEC(I,KQSP) - QSPEC(NSP-I+1,KQSP))
 10   CONTINUE
C
      DO 15 I=(NSP+1)/2+1, NSP
        SSPEC(I)      = -SSPEC(NSP-I+1)      + 2.0*SSPMID
        QSPEC(I,KQSP) = -QSPEC(NSP-I+1,KQSP)
 15   CONTINUE
C
C---- zero out Qspec DOFs
      QDOF0 = 0.0
      QDOF1 = 0.0
      QDOF2 = 0.0
      QDOF3 = 0.0
C
      CALL SPLQSP(KQSP)
C
      WRITE(*,1000) KQSP
 1000 FORMAT(/' Qspec',I2,'  made symmetric')
C
      RETURN
      END



      SUBROUTINE MIXED(KQSP)
C-------------------------------------------------
C     Performs a mixed-inverse calculation using 
C     the specified surface speed array QSPEC.
C-------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      COSA = COS(ALFA)
      SINA = SIN(ALFA)
      CALL SCALC(X,Y,S,N)
C
C---- zero-out and set DOF shape functions
      DO 1 I=1, N
        QF0(I) = 0.0
        QF1(I) = 0.0
        QF2(I) = 0.0
        QF3(I) = 0.0
    1 CONTINUE
C
C---- set DOF shape functions and specified speed
      DO 2 I=IQ1, IQ2
        FS = (S(I)-S(IQ1)) / (S(IQ2)-S(IQ1))
CCC        QF0(I) = (1.0-FS)**2
CCC        QF1(I) = FS**2
        QF0(I) = 1.0 - FS
        QF1(I) = FS
        IF(LCPXX) THEN
         QF2(I) = EXP(-5.0*     FS )
         QF3(I) = EXP(-5.0*(1.0-FS))
        ELSE
         QF2(I) = 0.0
         QF3(I) = 0.0
        ENDIF
        GAM(I) = QSPEC(I,KQSP) + QDOF0*QF0(I) + QDOF1*QF1(I)
     &                         + QDOF2*QF2(I) + QDOF3*QF3(I)
    2 CONTINUE
C
   99 CONTINUE
C
C---- perform Newton iterations on the new geometry
      ITMAX = 5
      CALL ASKI('Enter max number of iterations^',ITMAX)
      DO 1000 ITER=1, ITMAX
C
      DO 3 I=1, N+5
        DO 31 J=1, N+5
          Q(I,J) = 0.
   31   CONTINUE
    3 CONTINUE
C
C---- calculate normal direction vectors along which the nodes move
      CALL NCALC(X,Y,S,N,NX,NY)
C
C---- go over all nodes, setting up  Psi = Psi0  equations
      DO 20 I=1, N
        CALL PSILIN(I,X(I),Y(I),NX(I),NY(I),PSI,PSI_N,.TRUE.,.FALSE.)
C
        DZDN(I) = DZDN(I) + PSI_N
C
C------ fill columns for specified geometry location
        DO 201 J=1, IQ1-1
          Q(I,J) = Q(I,J) + DZDG(J)
  201   CONTINUE
C
C------ fill columns for specified surface speed location
        DO 202 J=IQ1, IQ2
          Q(I,J) = Q(I,J) + DZDN(J)
  202   CONTINUE
C
C------ fill columns for specified geometry location
        DO 203 J=IQ2+1, N
          Q(I,J) = Q(I,J) + DZDG(J)
  203   CONTINUE
C
C------ set residual
        DQ(I) = PSIO - PSI
C
C------ fill global unknown columns
        Q(I,N+1) = Q(I,N+1) - 1.0
        Q(I,N+2) = Q(I,N+2) + Z_QDOF0
        Q(I,N+3) = Q(I,N+3) + Z_QDOF1
        Q(I,N+4) = Q(I,N+4) + Z_QDOF2
        Q(I,N+5) = Q(I,N+5) + Z_QDOF3
   20 CONTINUE
C
C---- set up Kutta condition
      DQ(N+1) = -( GAM(1) + GAM(N) )
      CALL GAMLIN(N+1,1,1.0)
      CALL GAMLIN(N+1,N,1.0)
C
      IF(SHARP) THEN
C----- TE Gamma extrapolation
C
       XTE = 0.5*(X(1) + X(N))
C
       XXM = MIN( XTE , X(3)+X(N-2) - XTE )
       XXO = MIN( XTE , X(2)+X(N-1) - XTE )
       XXP = MIN( XTE , X(1)+X(N  ) - XTE )
C
C----- extrapolation is performed in the Glauert angle arccos(2x/c-1)
       TM = ACOS( XXM/XTE )
       TO = ACOS( XXO/XTE )
       TP = ACOS( XXP/XTE )
C
       DM = 1.0 / (TP - TO)
       DP = 1.0 / (TO - TM)
       DO = 2.0 / (TP - TM)
C
       DO 40 J=1, N+5
         Q(N,J) = 0.
   40  CONTINUE
C
       RES = ( (GAM(1)-GAM(N  )) - (GAM(2)-GAM(N-1)) ) * DP 
     &     - ( (GAM(2)-GAM(N-1)) - (GAM(3)-GAM(N-2)) ) * DM
       DQ(N) = -RES
       CALL GAMLIN(N,1,  DP    )
       CALL GAMLIN(N,2,-(DP+DM))
       CALL GAMLIN(N,3,     DM )
       CALL GAMLIN(N,N  ,-DP    )
       CALL GAMLIN(N,N-1,(DP+DM))
       CALL GAMLIN(N,N-2,   -DM )
      ENDIF
C
C---- pinned IQ1 point condition
      Q(N+2,IQ1) = 1.0
      DQ(N+2) = 0.0
C
C---- pinned IQ2 point condition
      Q(N+3,IQ2) = 1.0
      DQ(N+3) = 0.0
C
      IF(IQ1.GT.1 .AND. LCPXX) THEN
C----- speed regularity IQ1 condition
       RES = GAM(IQ1-1)      - 2.0*  GAM(IQ1)      +   GAM(IQ1+1)
     &  - (QSPEC(IQ1-1,KQSP) - 2.0*QSPEC(IQ1,KQSP) + QSPEC(IQ1+1,KQSP) )
       CALL GAMLIN(N+4,IQ1-1, 1.0)
       CALL GAMLIN(N+4,IQ1  ,-2.0)
       CALL GAMLIN(N+4,IQ1+1, 1.0)
       DQ(N+4) = -RES
      ELSE
C----- zero DOF condition
       Q(N+4,N+4) = 1.0
       DQ(N+4) = -QDOF2
      ENDIF
C
      IF(IQ2.LT.N .AND. LCPXX) THEN
C----- speed regularity IQ2 condition
       RES = GAM(IQ2-1)      - 2.0*  GAM(IQ2)      +   GAM(IQ2+1)
     &  - (QSPEC(IQ2-1,KQSP) - 2.0*QSPEC(IQ2,KQSP) + QSPEC(IQ2+1,KQSP) )
       CALL GAMLIN(N+5,IQ2-1, 1.0)
       CALL GAMLIN(N+5,IQ2  ,-2.0)
       CALL GAMLIN(N+5,IQ2+1, 1.0)
       DQ(N+5) = -RES
      ELSE
C----- zero DOF condition
       Q(N+5,N+5) = 1.0
       DQ(N+5) = -QDOF3
      ENDIF
C
      CALL GAUSS(IQX,N+5,Q,DQ,1)
C
      INMAX = 0
      IGMAX = 0
      DNMAX = 0.0
      DGMAX = 0.0
C
C---- update surface speed GAM before target segment
      DO 100 I=1, IQ1-1
        GAM(I) = GAM(I) + DQ(I)
        IF(ABS(DQ(I)) .GT. ABS(DGMAX)) THEN
         DGMAX = DQ(I)
         IGMAX = I
        ENDIF
  100 CONTINUE
C
C---- update panel nodes inside target segment
      DO 110 I=IQ1, IQ2
        X(I) = X(I) + NX(I)*DQ(I)
        Y(I) = Y(I) + NY(I)*DQ(I)
        IF(ABS(DQ(I)) .GT. ABS(DNMAX)) THEN
         DNMAX = DQ(I)
         INMAX = I
        ENDIF
  110 CONTINUE
C
C---- update surface speed GAM after target segment
      DO 120 I=IQ2+1, N
        GAM(I) = GAM(I) + DQ(I)
        IF(ABS(DQ(I)) .GT. ABS(DGMAX)) THEN
         DGMAX = DQ(I)
         IGMAX = I
        ENDIF
  120 CONTINUE
C
C---- update gloabal variables
      PSIO  = PSIO  + DQ(N+1)
      QDOF0 = QDOF0 + DQ(N+2)
      QDOF1 = QDOF1 + DQ(N+3)
      QDOF2 = QDOF2 + DQ(N+4)
      QDOF3 = QDOF3 + DQ(N+5)
C
      COSA = COS(ALFA)
      SINA = SIN(ALFA)
      CALL SCALC(X,Y,S,N)
C
C---- set correct surface speed over target segment including DOF contributions
      DO 140 I=IQ1, IQ2
        GAM(I) = QSPEC(I,KQSP) + QDOF0*QF0(I) + QDOF1*QF1(I)
     &                         + QDOF2*QF2(I) + QDOF3*QF3(I)
  140 CONTINUE
C
C---- update everything else
      CALL TECALC
      CALL CLCALC(N,X,Y,GAM,GAM_A,ALFA,MINF,QINF, CL,CM, CL_ALF,CL_MSQ,
     &            0.25,0.0,.FALSE.)
      WRITE(*,2000) DNMAX,INMAX,DGMAX,IGMAX,CL
     &             ,DQ(N+2),DQ(N+3)
     &             ,DQ(N+4),DQ(N+5)
 2000 FORMAT(/' dNmax =',E10.3,I4,'   dQmax =',E10.3,I4,'    CL =',F7.4
     &       /' dQf1  =',E10.3,4X,'   dQf2  =',E10.3
     &       /' dQf3  =',E10.3,4X,'   dQf4  =',E10.3)
C
      IF(ABS(DNMAX).LT.5.0E-5 .AND. ABS(DGMAX).LT.5.0E-4) THEN
       WRITE(*,*)
       WRITE(*,*) 'New current airfoil generated'
       RETURN
      ENDIF
C
 1000 CONTINUE
      WRITE(*,*) 'Not quite converged.  Can EXEC again if necessary.'
      RETURN
C
      END

 
      SUBROUTINE GAMLIN(I,J,COEF)
C-------------------------------------------------------------------
C     Adds on Jacobian entry for point I due to node speed GAM at J.
C     GAM is either a local unknown if outside target segment,
C     or dependent on global Qspec DOF's if inside target segment.
C-------------------------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      IF(J.GE.IQ1 .AND. J.LE.IQ2) THEN
C----- inside target segment
       Q(I,N+2) = Q(I,N+2) + COEF*QF0(J)
       Q(I,N+3) = Q(I,N+3) + COEF*QF1(J)
       Q(I,N+4) = Q(I,N+4) + COEF*QF2(J)
       Q(I,N+5) = Q(I,N+5) + COEF*QF3(J)
      ELSE
C----- outside target segment
       Q(I,J) = Q(I,J) + COEF
      ENDIF
      RETURN
      END

