
      SUBROUTINE EDTBLD(N)
C---------------------------------------------
C     Element position/scale editing routine.
C---------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 VAR, PVAR, CHKEY
      CHARACTER*4 VAR4
      CHARACTER*8 CHTMP
      CHARACTER*80 LINE, LINET
      LOGICAL ERROR, NEWOFF
C
C---- set geometry limits and turn on offset-initialization request flag
      CALL SETLIM
      NEWOFF = .TRUE.
C
C---- start of graphics loop
   10 CALL SETLIM
      CALL PLTINI
      IF(NEWOFF) CALL GOFINI(LCPSHO)
      NEWOFF = .FALSE.
      CALL GEAXES
      CALL GEOPLT(N)
C
      IF(LCPSHO) THEN
C
C------ see if geometry-movement sensitivities are available
        IF((.NOT.LGLIN)) THEN
C
C-------- make sure everything is at home position for new sensitivities
          DO 11 L=1, NBL
            IF(.NOT.LHOME(L)) GO TO 12
 11       CONTINUE
          GO TO 14
C
 12       WRITE(*,*)
          WRITE(*,*) 'Saving home positions for all elements ...'
          DO 13 L=1, NBL
            CALL CLRHOM(L)
            LHOME(L) = .TRUE.
 13       CONTINUE
C
C-------- calculate sensitivities
 14       CALL GEOLIN
        ENDIF
C
        CALL POFINI(.TRUE.)
        CALL CPAXES
C
        XLAB = 0.75
        YLAB = (-CPMIN-POFF)*PSF
        CALL CPLAB(XLAB,YLAB,XL1,XL2,XL3)
C
        ADEG = ALFA/DTOR
C
C------ plot baseline Cp and airfoil with dashed line
        CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.FALSE.)
        CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.FALSE.,3)
        CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
        CALL AIRHPL(3)
C
C------ plot perturbed Cp with solid line
        CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.TRUE.)
        CALL GETCOLOR(ICOL0)
        CALL NEWCOLORNAME('magenta')
        CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.TRUE.,1)
        CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
        CALL NEWCOLOR(ICOL0)
C
        CALL PLFLUSH
      ENDIF
C
C
   15 CALL ELINFO(N)
C
      WRITE(*,1100)
 1100 FORMAT(/'  T ranslate Point by delta X,Y   ' , 5X,
     &        '  F ix   (save home position)     '
     &       /'  M ove Point to X,Y              ' , 5X,
     &        '  H ome  (goto home position)     '
     &       /'  A ngle change about Point       ' , 5X,
     &        '  P oint (set Point location)     '
     &       /'  S cale about Point              ' , 5X,
     &        '  C oordinate location            '
     &       /'  B lowup                         ' , 5X,
     &        '  D istance                       '
     &       /'  R eset plot scaling, Replot     ' , 5X,
     &        '  G aps between TEs and surfaces  '
     &       /'  N ew target element             ' , 5X,
     &        '  L ink element motions           '
     &       /'  O verlay airfoil from disk file ' , 5X,
     &        ' sW ap element numbers            '
     &       /'  I nstant-Cp plotting toggle     ' , 5X,
     &        '  K ey definition                 ' )
C
C-- E J Q U V X Y Z
C
C
   20 CALL ASKS('.POSI^',LINE)
C
      IF(LINE(1:8) .EQ. '        ') RETURN
      CALL STRIP(LINE,NLINE)
C
      IF(LINE(1:1) .EQ. '?') GO TO 15
C
C---- check if this is a defined key
      DO 21 K=1, NKEYX
        IF(.NOT.LKEY(K)) GO TO 21
        IF(INDEX(LINE(1:8),KEYNAM(K)) .NE. 0) THEN
C-------- set input line from key definition, print it, go execute it
          LINE = KEYDEF(K)
          WRITE(*,1300) LINE(1:70)
          GO TO 22
        ENDIF
 21   CONTINUE
C
C---- save command character in VAR, set remainder of line for decoding
 22   VAR = LINE(1:1)
      LINE( 1:79) = LINE(2:80)
      LINE(80:80) = ' '
C
      IF(INDEX('Cc',VAR).GT.0) THEN
C
        CALL XYLOC(LINE)
        GO TO 20
C
      ELSE IF(INDEX('Tt',VAR).GT.0) THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LE.0 .OR. ERROR) THEN
          CALL ASKR('Enter  delta X ^',DX)
          CALL ASKR('Enter  delta Y ^',DY)
        ELSE IF(NINPUT.EQ.1) THEN
          DX = AINPUT(1)
          CALL ASKR('Enter  delta Y ^',DY)
        ELSE
          DX = AINPUT(1)
          DY = AINPUT(2)
        ENDIF
        CALL TRANS(N,DX,DY)
        CALL SETLIM
C
      ELSE IF(INDEX('Mm',VAR).GT.0) THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
C
        IF(NINPUT.LE.0 .OR. ERROR) THEN
          CALL ASKR('Enter REF X location^',XL)
          CALL ASKR('Enter REF Y location^',YL)
        ELSE IF(NINPUT.EQ.1) THEN
          XL = AINPUT(1)
          CALL ASKR('Enter REF Y location^',YL)
        ELSE
          XL = AINPUT(1)
          YL = AINPUT(2)
        ENDIF
        DX = XL-XREF(N)
        DY = YL-YREF(N)
        CALL TRANS(N,DX,DY)
        CALL SETLIM
C
      ELSE IF(INDEX('Ss',VAR).GT.0) THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LE.0 .OR. ERROR) THEN
          CALL ASKR('Enter Scale factor (0 for separate X,Y Scales)^',
     &              SCL)
        ELSE
          SCL = AINPUT(1)
        ENDIF
C
        IF(SCL .NE. 0.0) THEN
          XSCL = SCL
          YSCL = SCL
        ELSE IF(NINPUT.LE.1) THEN
          CALL ASKR('Enter X Scale factor for element^',XSCL)
          CALL ASKR('Enter Y Scale factor for element^',YSCL)
        ELSE IF(NINPUT.EQ.2) THEN
          XSCL = AINPUT(2)
          CALL ASKR('Enter Y Scale factor for element^',YSCL) 
        ELSE
          XSCL = AINPUT(2)
          YSCL = AINPUT(3)
        ENDIF
        CALL SCAL(N,XSCL,YSCL,XREF(N),YREF(N))
        CALL SETLIM
C
      ELSE IF(INDEX('Aa',VAR).GT.0) THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LE.0 .OR. ERROR) THEN
          CALL ASKR('Enter Rotation Angle (+ clockwise)^',ANGL)
        ELSE
          ANGL = AINPUT(1)
        ENDIF
        CALL ROTATE(N,ANGL,XREF(N),YREF(N))
        CALL SETLIM
C
      ELSE IF(INDEX('Pp',VAR).GT.0) THEN
C
        CALL STRIP(LINE,NLINE)
        PVAR = LINE(1:1)
        LINE( 1:79) = LINE(2:80)
        LINE(80:80) = ' '
C
        IF(INDEX('OLTKColtkc',PVAR).GT.0) THEN
          CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        ELSE
          WRITE(*,1110)
 1110     FORMAT(/'   O rigin (0,0)'
     &           /'   L eading edge'
     &           /'   T railing edge'
     &           /'   K eypad-specified location'
     &           /'   C ursor-specified location')
C
          CALL ASKC('Set point at...^',VAR4)
          PVAR = VAR4(1:1)
          CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        ENDIF
C
        IF(NINPUT.NE.2 .OR. ERROR) THEN
          IF     (INDEX('Oo',PVAR).GT.0) THEN
             XRNEW = 0.0
             YRNEW = 0.0
          ELSE IF(INDEX('Ll',PVAR).GT.0) THEN
             XRNEW = XLE(N)
             YRNEW = YLE(N)
          ELSE IF(INDEX('Tt',PVAR).GT.0) THEN
             XRNEW = XTE(N)
             YRNEW = YTE(N)
          ELSE IF(INDEX('Kk',PVAR).GT.0) THEN
             CALL ASKR('Enter REF x point^',XRNEW)
             CALL ASKR('Enter REF y point^',YRNEW)
          ELSE IF(INDEX('Cc',PVAR).GT.0) THEN
             WRITE(*,*)
             WRITE(*,*) 'Click on Point location'
             CALL GETCURSORXY(XX,YY,CHKEY)
             XRNEW = XX/SF + XOFF
             YRNEW = YY/SF + YOFF
          ELSE
             XRNEW = XREF(N)
             YRNEW = YREF(N)
             WRITE(*,1200) 'Point unchanged for element', N
          ENDIF
        ELSE
          XRNEW = AINPUT(1)
          YRNEW = AINPUT(2)
        ENDIF
C
        XREF(N) = XRNEW
        YREF(N) = YRNEW
        CALL SETLIM
C
      ELSE IF(INDEX('Hh',VAR).GT.0) THEN
C
C------ undo accumulated changes referenced to origin
        CALL TRANS(N,-DXSUM(N),-DYSUM(N))
        CALL ROTATE(N,-ANGSUM(N),0.0,0.0)
        CALL SCAL(N,1.0/XFTOT(N),1.0/YFTOT(N),0.0,0.0)
        CALL CLRHOM(N)
        LHOME(N) = .TRUE.
C
        CALL SETLIM
C
      ELSE IF(INDEX('Ff',VAR).GT.0) THEN
C
        LGLIN = .FALSE.
        IF(LCPSHO) THEN
          DO 30 L=1, NBL
            CALL CLRHOM(L)
            LHOME(L) = .TRUE.
 30       CONTINUE
          WRITE(*,*)
          WRITE(*,*) 'Home positions saved for all elements'
        ELSE
          CALL CLRHOM(N)
          LHOME(N) = .TRUE.
          WRITE(*,1200) 'Home position saved for element', N
          GO TO 20
        ENDIF
C
      ELSE IF(INDEX('Bb',VAR).GT.0) THEN
C
        XLEN = XWIND/SIZE
        YLEN = YWIND/SIZE
        CALL OFFGET(XOFF,YOFF,SF,SF,XLEN,YLEN,.TRUE.,.TRUE.)
C
      ELSE IF(INDEX('Rr',VAR).GT.0) THEN
C
        NEWOFF = .TRUE.
C
      ELSE IF(INDEX('Dd',VAR).GT.0) THEN
C
        CALL DIST
        GO TO 20
C
      ELSE IF(INDEX('Gg',VAR).GT.0) THEN
C
        IF(NBL.LE.1) THEN
         WRITE(*,*)
         WRITE(*,*) 'Only one element present!'
         GO TO 20
        ENDIF
C
        CALL GAPS
        GO TO 20
C
      ELSE IF(INDEX('Nn',VAR).GT.0) THEN
C
       IF(NBL.EQ.1) THEN
         N = NBL
       ELSE
         NOLD = N
         CALL GETINT(LINE,IINPUT,NINPUT,ERROR)
         IF(NINPUT.GE.1 .AND. (.NOT.ERROR)) THEN
          N = IINPUT(1)
          GO TO 47
         ENDIF
C
   46    CALL ASKI('Enter target element number^',N)
   47    IF (N.GT.NBL ) GO TO 46
C
         IF (N.NE.NOLD) GO TO 10
       ENDIF
       GO TO 15
C
      ELSE IF(INDEX('Ll',VAR).GT.0) THEN
C
       IF(NBL.LE.1) THEN
        WRITE(*,*)
        WRITE(*,*) 'No other elements to link to !'
        GO TO 20
       ENDIF
C
       CALL GETINT(LINE,IINPUT,NINPUT,ERROR)
C
       IF(NINPUT.LE.0 .OR. ERROR) THEN
         WRITE(*,*)
         WRITE(*,*) 'Present link status...'
         CALL SHOLNK
         WRITE(LINE,1400) 'Enter element to follow', N,
     &                    '   (0..none, -1..clear all)^'
         CALL ASKI(LINE,NLINK(N))
       ELSEIF(IINPUT(1).EQ.999) THEN
         DO L=1, NBL-1
           NLINK(L) = L+1
         ENDDO
         N = 1
       ELSE
         NLINK(N) = IINPUT(1)
       ENDIF
C
       IF(NLINK(N).GT.NBL) THEN
         NLINK(N) = 0
       ELSE IF(NLINK(N).EQ.-1) THEN
         DO 52 L=1, NBL
           NLINK(L) = 0
 52      CONTINUE
       ENDIF
C
       WRITE(*,*)
       WRITE(*,*) 'New link status...'
       CALL SHOLNK
C
       GO TO 10
C
      ELSE IF(INDEX('Oo',VAR).GT.0) THEN
C
        CALL OVER(LINE)
        GO TO 20
C
      ELSE IF(INDEX('Ww',VAR).GT.0) THEN
C
        IF(NBL.LE.1) THEN
         WRITE(*,*)
         WRITE(*,*) 'No other elements to swap with !'
         GO TO 20
        ENDIF
C
        CALL GETINT(LINE,IINPUT,NINPUT,ERROR)
        IF(NINPUT.LE.0 .OR. ERROR) THEN
          CALL ASKI('Swap with which other element ?^',N2)
        ELSE
          N2 = IINPUT(1)
        ENDIF
C
        CALL SWAP(N,N2)
        N = N2
C
      ELSE IF(INDEX('Ii',VAR).GT.0) THEN
C
        LCPSHO = .NOT.LCPSHO
        NEWOFF = .TRUE.
C
        WRITE(*,*)
        IF(LCPSHO) THEN
          WRITE(*,*) 'Cp response to element movement will be plotted'
        ELSE
          WRITE(*,*) 'Cp plotting disabled'
        ENDIF
C
      ELSE IF(INDEX('Kk',VAR).GT.0) THEN
C
        WRITE(*,*)
        WRITE(*,*) 'Current key definitions...'
        DO 60 K=1, NKEYX
          IF(LKEY(K)) WRITE(*,6000) KEYPRT(K), KEYDEF(K)
 6000     FORMAT(A8,':   ',A60)
 60     CONTINUE
        CALL ASKS('Press key to be defined^',LINE)
        KBLANK = 0
        DO 62 K=NKEYX, 1, -1
          IF(.NOT.LKEY(K)) KBLANK = K
          IF(INDEX(LINE,KEYNAM(K)).NE.0) GO TO 63
 62     CONTINUE
        K = KBLANK
C
 63     CONTINUE
        IF(K.EQ.0) THEN
          WRITE(*,*)
          WRITE(*,*) 'Key array full.  Key not defined.'
          GO TO 15
        ENDIF
C
C------ set key  name,printname,definition
        KEYNAM(K) = LINE(1:8)
        CALL ASKS('Enter key definition^',KEYDEF(K))
        IF(.NOT.LKEY(K))
     &      CALL ASKS('Enter key printname (8 chars max)^',KEYPRT(K))
        LKEY(K) = .TRUE.
C
      ELSE
C
        WRITE(*,*)
        WRITE(*,*) 'Specify again'
        GO TO 20
C
      ENDIF
C
      GO TO 10
C..........................................
 1200 FORMAT(/1X,A,I3)
 1300 FORMAT(A)
 1400 FORMAT(A,I3,A)
      END   ! EDTBLD


      SUBROUTINE ELINFO(N)
      INCLUDE 'AIRSET.INC'
      CHARACTER*8 CHTMP
C
      CHTMP =              '        '
      IF(LHOME(N)) CHTMP = '  (home)'
C
      WRITE(*,1000) N, CHTMP,  XLE(N),  YLE(N),
     &               CHRD(N),  XTE(N),  YTE(N),
     &           ANG(N)/DTOR, XREF(N), YREF(N)
C
 1000 FORMAT(/' Target element:',I3, A8,   9X,' LE   at', 2F12.5,
     &       /'          Chord:', F11.5,   9X,' TE   at', 2F12.5,
     &       /'          Angle:',  F9.3,2X,9X,'Point at', 2F12.5 )
C
      RETURN
      END


      SUBROUTINE CLRHOM(N)
      INCLUDE 'AIRSET.INC'
C
      ANGSUM(N) = 0.0
      DXSUM(N) = 0.0
      DYSUM(N) = 0.0
      XFTOT(N) = 1.0
      YFTOT(N) = 1.0
C
      CALL CLRXYA(N)
C
      RETURN
      END


      SUBROUTINE SHOLNK
      INCLUDE 'AIRSET.INC'
      LOGICAL NOLINK
C
      NOLINK = .TRUE.
C
      DO 10 L=1, NBL
        IF(NLINK(L) .GT. 0) THEN
          WRITE(*,1010) NLINK(L), L
          NOLINK = .FALSE.
        ENDIF
 10   CONTINUE
C
      IF(NOLINK) WRITE(*,*) ' * no links set *'
      RETURN
C
 1010 FORMAT(1X,' Element', I2,' follows', I2)
      END



      SUBROUTINE GEOLIN
      INCLUDE 'AIRSET.INC'
      CHARACTER*80 LINE
C
      LOGICAL LALSP
      DATA LALSP /.TRUE./
C
      CLSPEC = CL
      ALSPEC = ALFA/DTOR
C
      IF(.NOT.LGAMU) THEN
C------ panel airfoil and calculate unit vorticity distributions
        CALL PANSET
        CALL PANSOL(YGROUND)
        LGAMU = .TRUE.
        LGLIN = .FALSE.
      ENDIF
C
 11   CONTINUE
      IF(LIMAGE) THEN
C
        ALFA = 0.0
        CALL ALSET(ALFA)
C
      ELSE IF(LALSP) THEN
C
C------ get new alpha for baseline Cp
        WRITE(*,*)
 12     WRITE(*,1400)
     &  'Enter alpha for baseline Cp (or 999 to specify CL):', ALSPEC
        READ (*,1300) LINE
        IF(LINE(1:1) .NE. ' ') READ(LINE,*,ERR=12) ALSPEC
C
        LALSP = ALSPEC .NE. 999.0
        IF(LALSP) THEN
          ALFA = ALSPEC*DTOR
          CALL ALSET(ALFA)
        ENDIF
C
      ELSE
C
C------ get new CL for baseline Cp
        WRITE(*,*)
 13     WRITE(*,1400)
     &  'Enter CL for baseline Cp (or 999 to specify alpha):', CLSPEC
        READ (*,1300) LINE
        IF(LINE(1:1) .NE. ' ') READ(LINE,*,ERR=13) CLSPEC
C
        LALSP = CLSPEC .EQ. 999.0
        IF(LALSP) GO TO 11
C
        CALL CLSET(CLSPEC,ALFA,MINF)
      ENDIF
C
C---- calculate new geometry sensitivities
      CALL PANSEN(YGROUND)
      LGLIN = .TRUE.
C
      RETURN
 1300 FORMAT(A)
 1400 FORMAT(A,F12.4)
      END ! GEOLIN


      SUBROUTINE MODBLD(N)
C---------------------------------------
C     Element shape editing routine.
C---------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 VAR
      CHARACTER*80 LINE
      LOGICAL ERROR
C
      CALL SETLIM
      CALL GOFINI(LCPSHO)
C
   10 CALL SETLIM
      CALL PLTINI
      CALL GEAXES
      CALL GEOPLT(N)
C
   15 CALL ELINFO(N)
C
      WRITE(*,1100)
 1100 FORMAT(/' M odify contour'
     &       /' P lot refresh'
     &       /' T angent-endpoints toggle'
     &       /' B lowup'
     &       /' R eset plot scaling, Replot'
     &       /' O verlay airfoil from disk file'
     &       /' D istance'
     &       /' S plit into two elements'
     &       /' C orner add/delete'
     &       /' A lter camber line with splined input'
     &       /' N ew target element' )
C
   20 CALL ASKS('.MODI^',LINE)
C
      IF(LINE(1:8) .EQ. '        ') RETURN
C
      CALL STRIP(LINE,NLINE)
C
      IF(LINE(1:1) .EQ. '?') GO TO 15
C
C---- save command character in VAR, set remainder of line for decoding
      VAR = LINE(1:1)
      LINE( 1:79) = LINE(2:80)
      LINE(80:80) = ' '
C
      IF     (INDEX('Mm',VAR).NE.0) THEN
        CALL MODG(N)
        GO TO 15
C
      ELSE IF(INDEX('Ii',VAR).NE.0) THEN
        CALL MOVP(N)
        GO TO 15
C
      ELSE IF(INDEX('Pp',VAR).NE.0) THEN
        GO TO 10
C
      ELSE IF(INDEX('Tt',VAR).NE.0) THEN
        LGSLOP = .NOT. LGSLOP
        IF(     LGSLOP) WRITE(*,*)
     &      'Modified segment will be made tangent at endpoints'
        IF(.NOT.LGSLOP) WRITE(*,*)
     &      'Modified segment will not be made tangent at endpoints'
        GO TO 20
C
      ELSE IF(INDEX('Bb',VAR).NE.0) THEN
        XLEN = XWIND/SIZE
        YLEN = YWIND/SIZE
        CALL OFFGET(XOFF,YOFF,SF,SF,XLEN,YLEN,.TRUE.,.TRUE.)
C
      ELSE IF(INDEX('Rr',VAR).NE.0) THEN
        CALL GOFINI(.FALSE.)
C
      ELSE IF(INDEX('Oo',VAR).NE.0) THEN
        CALL OVER(LINE)
        GO TO 20
C
      ELSE IF(INDEX('Dd',VAR).NE.0) THEN
        CALL DIST
        GO TO 20
C
      ELSE IF(INDEX('Ss',VAR).NE.0) THEN
        CALL SPLIT(N)
C
      ELSE IF(INDEX('Cc',VAR).NE.0) THEN
        CALL CORNER(N)
C
      ELSE IF(INDEX('Aa',VAR).NE.0) THEN
        CALL CAMS(N)
C
      ELSE IF(INDEX('Nn',VAR).NE.0) THEN
        IF(NBL.EQ.1) THEN
          N = NBL
        ELSE
          NOLD = N
          CALL GETINT(LINE,IINPUT,NINPUT,ERROR)
          IF(NINPUT.GT.0 .AND. .NOT.ERROR) THEN
           N = IINPUT(1)
           GO TO 37
          ENDIF
C
   36     CALL ASKI('Enter target element number^',N)
   37     IF (N.GT.NBL ) GO TO 36
C
          IF (N.NE.NOLD) GO TO 10
        ENDIF
        GO TO 15
C
      ELSE
        WRITE(*,*)
        WRITE(*,*) 'Specify again'
        GO TO 20
      ENDIF
C
      GO TO 10
      END   ! MODBLD




      SUBROUTINE CAMS(N)
C-----------------------------------------
C     Adds to buffer airfoil camber line
C     another shape splined in x/c.
C-----------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*4 OPTION
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      CALL GETCOLOR(ICOL0)
C
C---- plot element chord line from which x/c,y/c camber line is defined
      CALL NEWPEN(1)
      CALL NEWCOLORNAME('violet')
      TMAX = 0.0
      XMAX = 0.0
      CALL PLOT(XMOD(XLE(N)),YMOD(YLE(N)),3)
      CALL PLOT(XMOD(XTE(N)),YMOD(YTE(N)),2)
      DO ITIK=1, 9
        XK = 0.1*FLOAT(ITIK)
        YK = 0.004
        IF(ITIK.EQ.5) YK = 0.008
        XTIK = XLE(N) + (XTE(N)-XLE(N))*XK - (YTE(N)-YLE(N))*YK
        YTIK = YLE(N) + (XTE(N)-XLE(N))*YK + (YTE(N)-YLE(N))*XK
        CALL PLOT(XMOD(XTIK),YMOD(YTIK),3)
        XTIK = XLE(N) + (XTE(N)-XLE(N))*XK + (YTE(N)-YLE(N))*YK
        YTIK = YLE(N) - (XTE(N)-XLE(N))*YK + (YTE(N)-YLE(N))*XK
        CALL PLOT(XMOD(XTIK),YMOD(YTIK),2)
      ENDDO
      CALL PLFLUSH
C
    2 WRITE(*,1000)
 1000 FORMAT(/' Type in x/c, y/c pairs from  x/c = 0  to  x/c = 1'
     &       /' Identical successive points enable a slope break')
C
      DO 5 NS=1, IX
    3   READ(*,*,ERR=4) W6(NS), W7(NS)
C
        IF(W6(NS).EQ.1.0) GO TO 6
        GO TO 5
C
    4   WRITE(*,*) 'Read error.  Try again.'
        GO TO 3
    5 CONTINUE
C
C---- spline camber line y(x)
    6 CALL SEGSPL(W7,W8,W6,NS)
C
C---- plot splined camber line
      CALL NEWCOLORNAME('magenta')
      XK = 0.0
      YK = SEVAL(XK,W7,W8,W6,NS)
      XCAM = XLE(N) + (XTE(N)-XLE(N))*XK - (YTE(N)-YLE(N))*YK
      YCAM = YLE(N) + (XTE(N)-XLE(N))*YK + (YTE(N)-YLE(N))*XK
      CALL PLOT(XMOD(XCAM),YMOD(YCAM),3)
      DO 7 K=1, 100
        XK = 0.01*FLOAT(K)
        YK = SEVAL(XK,W7,W8,W6,NS)
        XCAM = XLE(N) + (XTE(N)-XLE(N))*XK - (YTE(N)-YLE(N))*YK
        YCAM = YLE(N) + (XTE(N)-XLE(N))*YK + (YTE(N)-YLE(N))*XK
        CALL PLOT(XMOD(XCAM),YMOD(YCAM),2)
        IF(ABS(YK) .GT. TMAX) THEN
         TMAX = YK
         XMAX = XK
        ENDIF
    7 CONTINUE
C
C---- plot spline knots
      CALL NEWCOLORNAME('red')
      SH = 0.7*CH
      DO IS=1, NS
        XK = W6(IS)
        YK = W7(IS)
        XCAM = XLE(N) + (XTE(N)-XLE(N))*XK - (YTE(N)-YLE(N))*YK
        YCAM = YLE(N) + (XTE(N)-XLE(N))*YK + (YTE(N)-YLE(N))*XK
        CALL PLSYMB(XMOD(XCAM),YMOD(YCAM),SH,1,0.0,0)
      ENDDO
C
      CALL PLFLUSH
C
C
      ALE = ATAN( DEVAL(0.0,W7,W8,W6,NS) ) / DTOR
      ATE = ATAN( DEVAL(1.0,W7,W8,W6,NS) ) / DTOR
C
      WRITE(*,1100) ALE, ATE, TMAX, XMAX
 1100 FORMAT(/' Added camber line incidence at LE = ', F6.2, '  deg.',
     &       /' Added camber line incidence at TE = ', F6.2, '  deg.',
     &       /' Max added camber = ', F6.3, '  at x/c = ', F6.2  )
C
    9 CALL ASKC('Add camber, Re-enter, or Cancel [ A R C ]?^',OPTION)
C
      IF(OPTION.EQ.'C   ' .OR. OPTION.EQ.'c   ') THEN
        CALL NEWCOLOR(ICOL0)
        RETURN
      ENDIF
      IF(OPTION.EQ.'R   ' .OR. OPTION.EQ.'r   ') GO TO 2
      IF(OPTION.EQ.'A   ' .OR. OPTION.EQ.'a   ') GO TO 10
      GO TO 9
C
C
   10 NP = NPBL(N)
C
      CA = COS(ANG(N))
      SA = SIN(ANG(N))
C
C---- go over each point, changing the camber line appropriately
      DO 30 I=1, NP
        XK = ( CA*(X(I,N)-XLE(N)) - SA*(Y(I,N)-YLE(N)) ) / CHRD(N) 
        YK = SEVAL(XK,W7,W8,W6,NS)
        X(I,N) = X(I,N) - (YTE(N)-YLE(N))*YK
        Y(I,N) = Y(I,N) + (XTE(N)-XLE(N))*YK
   30 CONTINUE
C
      CALL BLDFIX(N)
      LGAMU = .FALSE.
      LGLIN = .FALSE.
C
C---- restore original color
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! CAMS


 
      SUBROUTINE MODG(N)
C-----------------------------------------
C     Takes cursor x,y pairs defining 
C     new element contour shape.
C-----------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 CHKEY
      LOGICAL LABORT
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      NP = NPBL(N)
C
      CALL GETCOLOR(ICOL0)
      CALL PABORT(1.0,0.0)
C
      WRITE(*,*)
      WRITE(*,*) 'Input geometry'
      WRITE(*,*) 'Terminate last entry with 3 clicks on same point'
      WRITE(*,*)
C
C---- read first geometry point coordinates
      KW = 1
      CALL GETCURSORXY(W1(KW),W2(KW),CHKEY)
      IF(LABORT(W1(KW),W2(KW))) THEN
        CALL NEWCOLOR(ICOL0)
        RETURN
      ENDIF
C
      CALL NEWCOLORNAME('red')
C
C---- go from screen to internal coordinates x/c, y/c
      W1(KW) = W1(KW)/SF + XOFF
      W2(KW) = W2(KW)/SF + YOFF
C
C---- find the closest buffer airfoil node and draw a small symbol there
      DMIN = 1000.
      DO 7 I=1, NP
        DIST = (X(I,N) - W1(KW))**2 + (Y(I,N) - W2(KW))**2
        IF(DIST.GT.DMIN) GO TO 7
         DMIN = DIST
C------- set first node index of airfoil segment to be modified
         IG1 = I
    7 CONTINUE
      CALL PLSYMB(XMOD(X(IG1,N)),YMOD(Y(IG1,N)),0.01,1,0.0,0)
C
C---- reset first geometry point to cooincide with the buffer airfoil node
      W1(KW) = X(IG1,N)
      W2(KW) = Y(IG1,N)
C
C---- read in subsequent geometry point coordinates
      DO 10 KW=2, IX
        CALL GETCURSORXY(W1(KW),W2(KW),CHKEY)
        IF(LABORT(W1(KW),W2(KW))) THEN
          CALL NEWCOLOR(ICOL0)
          RETURN
        ENDIF
C
        CALL PLSYMB(W1(KW),W2(KW),0.005,4,0.0,0)
CCC        CALL PLOT(W1(KW),W2(KW),3)
CCC        CALL PLOT(W1(KW),W2(KW),2)
C
        W1(KW) = W1(KW)/SF + XOFF
        W2(KW) = W2(KW)/SF + YOFF
C
        IF(KW.LT.3) GO TO 10
C------- test for 3 identical consecutive geometry points
         IF(W1(KW).EQ.W1(KW-1) .AND. W1(KW).EQ.W1(KW-2)) GO TO 11
   10 CONTINUE
C
   11 KW = KW-2
C
      IF(KW.LT.2) THEN
       WRITE(*,*) '***  Need at least two points  ***'
       WRITE(*,*) '***      NO CHANGES MADE       ***'
       CALL NEWCOLOR(ICOL0)
       RETURN
      ENDIF
C
C---- find the closest buffer airfoil node to last geometry point & draw symbol
      DMIN = 1000.
      DO 17 I=1, NP
        DIST = (X(I,N) - W1(KW))**2 + (Y(I,N) - W2(KW))**2
        IF(DIST.GT.DMIN) GO TO 17
         DMIN = DIST
C------- set last node index of airfoil segment to be modified
         IG2 = I
   17 CONTINUE
      CALL PLSYMB(XMOD(X(IG2,N)),YMOD(Y(IG2,N)),0.01,1,0.0,0)
C
C---- reset last geometry point to cooincide with the buffer airfoil node
      W1(KW) = X(IG2,N)
      W2(KW) = Y(IG2,N)
C
C---- set index of pseudo-LE point (most distant point from TE modpoint)
      ILED = 1
      DSQMAX = 0.0
      DO I = 1, NP
        DSQ = (X(I,N)-XTE(N))**2 + (Y(I,N)-YTE(N))**2
        IF(DSQ.GT.DSQMAX) THEN
         ILED = I
         DSQMAX = DSQ
        ENDIF
      ENDDO
C
      DXTE = X(1,N) - X(NP,N)
      DYTE = Y(1,N) - Y(NP,N)
      DSTE = SQRT(DXTE**2 + DYTE**2)
      DSTOT = S(NP,N) - S(1,N)
C
C---- if TE is sharp...
      IF(DSTE/DSTOT .LT. 1.0E-5) THEN
C
C----- if one of the modified airfoil segment endpoints is at TE,
C-     make sure the other endpoint is on the same airfoil side.
       IF(IG1.EQ.1  .AND. IG2.GT.ILED) IG1 = NP
       IF(IG1.EQ.NP .AND. IG2.GT.ILED) IG1 = 1
C
       IF(IG2.EQ.1  .AND. IG1.GT.ILED) IG2 = NP
       IF(IG2.EQ.NP .AND. IG1.GT.ILED) IG2 = 1
C
      ENDIF
C
c      IF(IG1.EQ.1 .OR. IG1.EQ.NP) THEN
c       DOTP = XP(IG1,N)*XP(IG2,N) + YP(IG1,N)*YP(IG2,N)
c       IF(DOTP.LT.0.0) THEN
c        ITEMP = IG1
c        IF(ITEMP.EQ.1 ) IG1 = NP
c        IF(ITEMP.EQ.NP) IG1 = 1
c       ENDIF
c      ENDIF
cC
c      IF(IG2.EQ.1 .OR. IG2.EQ.NP) THEN
c       DOTP = XP(IG1,N)*XP(IG2,N) + YP(IG1,N)*YP(IG2,N)
c       IF(DOTP.LT.0.0) THEN
c        ITEMP = IG2
c        IF(ITEMP.EQ.1 ) IG2 = NP
c        IF(ITEMP.EQ.NP) IG2 = 1
c       ENDIF
c      ENDIF
C
      IF(IG1.EQ.IG2) THEN
       WRITE(*,*) '***  Endpoints must be distinct  ***'
       WRITE(*,*) '***       NO CHANGES MADE        ***'
       CALL NEWCOLOR(ICOL0)
       RETURN
      ENDIF
C
C---- set spline endpoint derivatives to match airfoil's
      IF(IG2 .GT. IG1) THEN
       XP1 = XP(IG1,N)
       YP1 = YP(IG1,N)
       XP2 = XP(IG2,N)
       YP2 = YP(IG2,N)
      ELSE
       XP1 = -XP(IG1,N)
       YP1 = -YP(IG1,N)
       XP2 = -XP(IG2,N)
       YP2 = -YP(IG2,N)
      ENDIF
C
      INCR = SIGN(1,IG2-IG1)
C
C
C---- if endpoint is at TE or corner, set force-free BC (zero 3rd derivative)
C
      IF((.NOT.LGSLOP) .OR. IG1.EQ.1 .OR. IG1.EQ.NP) THEN
       XP1 = -999.
       YP1 = -999.
      ELSE
       DELSM = (X(IG1-1,N)-X(IG1,N))**2 + (Y(IG1-1,N)-Y(IG1,N))**2
       DELSP = (X(IG1+1,N)-X(IG1,N))**2 + (Y(IG1+1,N)-Y(IG1,N))**2
       IF(DELSM.EQ.0.0  .OR.  DELSP.EQ.0.0) THEN
        XP1 = -999.
        YP1 = -999.
       ENDIF
      ENDIF
C
      IF((.NOT.LGSLOP) .OR. IG2.EQ.1 .OR. IG2.EQ.NP) THEN
       XP2 = -999.
       YP2 = -999.
      ELSE
       DELSM = (X(IG2-1,N)-X(IG2,N))**2 + (Y(IG2-1,N)-Y(IG2,N))**2
       DELSP = (X(IG2+1,N)-X(IG2,N))**2 + (Y(IG2+1,N)-Y(IG2,N))**2
       IF(DELSM.EQ.0.0  .OR.  DELSP.EQ.0.0) THEN
        XP2 = -999.
        YP2 = -999.
       ENDIF
      ENDIF
C
C---- spline new geometry segment coordinates
      CALL SCALC(W1,W2,W5,KW)
      CALL SPLIND(W1,W3,W5,KW,XP1,XP2)
      CALL SPLIND(W2,W4,W5,KW,YP1,YP2)
C
C---- go over splined new-geometry segment
      KK = 20
      CALL NEWCOLORNAME('red')
      CALL PLOT(XMOD(X(IG1,N)),YMOD(Y(IG1,N)),3)
      DO 50 I=IG1+INCR, IG2, INCR
C------ plot using many sub-intervals to get smooth splined shape
        DO K=1, KK
C-------- arc length on old airfoil shape
          SK = S(I-INCR,N) + (S(I,N)-S(I-INCR,N))*FLOAT(K)/FLOAT(KK)
C
C-------- interpolating fraction to new airfoil shape
          SFRACT = (SK-S(IG1,N))/(S(IG2,N)-S(IG1,N))
C
C-------- arc length on new airfoil shape
          WK = SFRACT*(W5(KW)-W5(1))
C
          XK = SEVAL(WK,W1,W3,W5,KW)
          YK = SEVAL(WK,W2,W4,W5,KW)
          CALL PLOT(XMOD(XK),YMOD(YK),2)
        ENDDO
C
C------ set new buffer airfoil coordinates inside segment
        IF(I .NE. IG2) THEN
          X(I,N) = XK
          Y(I,N) = YK
        ENDIF
   50 CONTINUE
      CALL PLFLUSH
C
      CALL CHKBLD(N)
      CALL BLDFIX(N)
C
      LGAMU = .FALSE.
      LGLIN = .FALSE.
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! MODG


 
      SUBROUTINE SPLIT(N)
C--------------------------------------------------------------
C     Takes cursor x,y pairs to define a split line
C     between the upper and lower surface of target element.
C     Two new elements are thus created, replacing the parent.
C--------------------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL OK, YES
      CHARACTER*1 CHKEY
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      NP = NPBL(N)
C
      IF(NBL .EQ. LX) THEN
       WRITE(*,*) 
     &   '*** Element arrays will overflow.  No action taken. ***'
       RETURN
      ENDIF
C
      CALL ASKR('Enter split line x/c on upper surface^',XOCU)
      IF(XOCU.EQ.0.0) RETURN
C
      CALL ASKR('Enter split line x/c on lower surface^',XOCL)
      IF(XOCL.EQ.0.0) RETURN
C
      SU =            XTE(N) - XOCU
      SL = S(NP,N) - (XTE(N) - XOCL)
C
      CALL SINVRT(SU,XOCU,X(1,N),XP(1,N),S(1,N),NP)
      CALL SINVRT(SL,XOCL,X(1,N),XP(1,N),S(1,N),NP)
C
      YOCU = SEVAL(SU,Y(1,N),YP(1,N),S(1,N),NP)
      YOCL = SEVAL(SL,Y(1,N),YP(1,N),S(1,N),NP)
C
    3 CALL PLSYMB(XMOD(XOCU),YMOD(YOCU),0.01,1,0.0,0)
      CALL PLSYMB(XMOD(XOCL),YMOD(YOCL),0.01,1,0.0,0)
C
      WRITE(*,*)
      WRITE(*,*) 'Input split line geometry in airfoil interior'
      WRITE(*,*) 'Terminate last entry with 3 clicks on same point'
      WRITE(*,*)
C
C---- read in geometry point coordinates
      DO 10 KW=2, IX
        CALL GETCURSORXY(W1(KW),W2(KW),CHKEY)
        CALL PLSYMB(W1(KW),W2(KW),0.005,4,0.0,0)
CCC        CALL PLOT(W1(KW),W2(KW),3)
CCC        CALL PLOT(W1(KW),W2(KW),2)
C
        W1(KW) = W1(KW)/SF + XOFF
        W2(KW) = W2(KW)/SF + YOFF
C
        IF(KW.LT.3) GO TO 10
C------- test for 3 identical consecutive geometry points
         IF(W1(KW).EQ.W1(KW-1) .AND. W1(KW).EQ.W1(KW-2)) GO TO 11
   10 CONTINUE
C
   11 KW = KW-1
C
      W1(1)  = XOCL
      W2(1)  = YOCL
      W1(KW) = XOCU
      W2(KW) = YOCU
C
      DSQ1 = (W1(2)   -W1(1))**2 + (W2(2)   -W2(1))**2
      DSQ2 = (W1(KW-1)-W1(1))**2 + (W2(KW-1)-W2(1))**2
      IF(DSQ1 .GT. DSQ2) THEN
C----- reorder interior points so they run from lower to upper surface
       DO 13 IW=2, KW/2
         TMP1 = W1(IW)
         TMP2 = W2(IW)
         W1(IW) = W1(KW-IW+1)
         W2(IW) = W2(KW-IW+1)
         W1(KW-IW+1) = TMP1
         W2(KW-IW+1) = TMP2
   13  CONTINUE
      ENDIF
C
C---- spline new geometry segment coordinates
      CALL SCALC(W1,W2,W5,KW)
      CALL SPLIND(W1,W3,W5,KW,-999.0,-999.0)
      CALL SPLIND(W2,W4,W5,KW,-999.0,-999.0)
C
C---- set number of points on new geometry segment
      NG = INT(FLOAT(NP)*W5(KW)/S(NP,N)) + 2
C
      CALL SETLIM
      CALL PLTINI
      CALL GEAXES
      CALL GEOPLT(N)
C
C---- plot new geometry segment
      IPEN = 3
      DO 15 IG=1, NG
        SG = W5(KW) * FLOAT(IG-1)/FLOAT(NG-1)
        XG = SEVAL(SG,W1,W3,W5,KW)
        YG = SEVAL(SG,W2,W4,W5,KW)
        CALL PLOT(XMOD(XG),YMOD(YG),IPEN)
        IPEN = 2
   15 CONTINUE
      CALL PLFLUSH
C
      CALL ASKL('Is this acceptable ?^',OK)
C
      IF(.NOT. OK) GO TO 3
C
      IF(KW.EQ.3) THEN
       CALL ASKL('Continue with splitting ?^',YES)
       IF(.NOT. YES) RETURN
      ENDIF
C
C---- move elements above current one to make room for new element
      DO 20 L=NBL, N, -1
        NPBL(L+1) = NPBL(L)
        CHRD(L+1) = CHRD(L)
        ANG(L+1) = ANG(L)
C
        LCLOCK(L+1) = LCLOCK(L)
        LHOME(L+1) = LHOME(L)
C
        SLE(L+1) = SLE(L)
        XLE(L+1) = XLE(L)
        YLE(L+1) = YLE(L)
        XTE(L+1) = XTE(L)
        YTE(L+1) = YTE(L)
C
        XREF(L+1) = XREF(L)
        YREF(L+1) = YREF(L)
C
        ANGSUM(L+1) = ANGSUM(L)
        DXSUM(L+1) = DXSUM(L)
        DYSUM(L+1) = DYSUM(L)
        XFTOT(L+1) = XFTOT(L)
        YFTOT(L+1) = YFTOT(L)
C
        XCENT(L+1) = XCENT(L)
        YCENT(L+1) = YCENT(L)
        DO 205 I=1, NPBL(L)
          X(I,L+1) = X(I,L)
          Y(I,L+1) = Y(I,L)
          S(I,L+1) = S(I,L)
          XB(I,L+1) = XB(I,L)
          YB(I,L+1) = YB(I,L)
          XP(I,L+1) = XP(I,L)
          YP(I,L+1) = YP(I,L)
  205   CONTINUE
   20 CONTINUE
C
      NBL = NBL + 1
C
C
C---- find intervals containing split line
      DO 25 I=1, NP-1
        IF(SU.GE.S(I,N) .AND. SU.LT.S(I+1,N)) IU = I 
        IF(SL.GE.S(I,N) .AND. SL.LT.S(I+1,N)) IL = I 
   25 CONTINUE
C
      DELX = XOCL - X(IL,N)
      DELY = YOCL - Y(IL,N)
      IF(ABS(DELX) .LT. 0.0001 .AND. ABS(DELY) .LT. 0.0001) IL = IL-1
C
C---- set new element N
      I = 1
      X(I,N) = XOCU
      Y(I,N) = YOCU
      DO 30 K=IU+1, IL
        I = I+1
        X(I,N) = X(K,N)
        Y(I,N) = Y(K,N)
   30 CONTINUE
C
      DO 32 IG=1, NG
        I = I+1
        SG = W5(KW) * FLOAT(IG-1)/FLOAT(NG-1)
        X(I,N) = SEVAL(SG,W1,W3,W5,KW)
        Y(I,N) = SEVAL(SG,W2,W4,W5,KW)
   32 CONTINUE
      NPBL(N) = I
      IF(NPBL(N) .GT. IX) STOP 'Array overflow.'
C
C---- set new element N+1
      DELX = XOCU - X(IU,N+1)
      DELY = YOCU - Y(IU,N+1)
      IF(ABS(DELX) .LT. 0.0001 .AND. ABS(DELY) .LT. 0.0001) IU = IU-1
C
      I = IU
      DO 42 IG=NG, 1, -1
        I = I+1
        SG = W5(KW) * FLOAT(IG-1)/FLOAT(NG-1)
        X(I,N+1) = SEVAL(SG,W1,W3,W5,KW)
        Y(I,N+1) = SEVAL(SG,W2,W4,W5,KW)
   42 CONTINUE
C
      DELX = XOCL - X(IL+1,N+1)
      DELY = YOCL - Y(IL+1,N+1)
      IF(ABS(DELX) .LT. 0.0001 .AND. ABS(DELY) .LT. 0.0001) IL = IL+1
C
      DO 44 K=IL+1, NPBL(N+1)
        I = I+1
        X(I,N+1) = X(K,N+1)
        Y(I,N+1) = Y(K,N+1)
   44 CONTINUE
      NPBL(N+1) = I
      IF(NPBL(N+1) .GT. IX) STOP 'Array overflow.'
C
      CALL CHKBLD(N)
      CALL CHKBLD(N+1)
C
      CALL BLDFIX(N)
      CALL BLDFIX(N+1)
C
      CALL CLRHOM(N)
      CALL CLRHOM(N+1)
      LHOME(N)   = .TRUE.
      LHOME(N+1) = .TRUE.
C
      WRITE(*,*)
      WRITE(*,*) '***  Home positions set for new elements  ***'
C
      LGAMU = .FALSE.
      LGLIN = .FALSE.
      RETURN
      END  ! SPLIT


      SUBROUTINE CORNER(N)
C--------------------------------------------------
C     Finds node nearest to cursor, and
C      1) If it's a normal node makes it a corner
C      2) It it's a corner makes it a normal node
C--------------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 CHKEY
C
CCC      XMOD(XTMP) = SF * (XTMP - XOFF)
CCC      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      NP = NPBL(N)
C
      WRITE(*,*)
      WRITE(*,*) 'Specify corner location'
      WRITE(*,*)
C
C---- read geometry point coordinates
      CALL GETCURSORXY(XCRS,YCRS,CHKEY)
C
C---- go from screen to internal coordinates x/c, y/c
      XOC = XCRS/SF + XOFF
      YOC = YCRS/SF + YOFF
C
C---- find the closest buffer airfoil node
      DMIN = 1.0E9
      DO 7 I=1, NP
        DIST = (X(I,N) - XOC)**2 + (Y(I,N) - YOC)**2
        IF(DIST.GE.DMIN) GO TO 7
         DMIN = DIST
         IC = I
    7 CONTINUE
C
C---- don't do anything if this is a TE point
      IF(IC .EQ. 1 .OR. IC .EQ. NP) THEN
       WRITE(*,*) 'Trailing edge point cannot be a corner point.'
       WRITE(*,*) 'No action taken.'
       RETURN
      ENDIF
C
C---- check if this is already a corner point
      DELSP = (X(IC+1,N)-X(IC,N))**2 + (Y(IC+1,N)-Y(IC,N))**2
      DELSM = (X(IC-1,N)-X(IC,N))**2 + (Y(IC-1,N)-Y(IC,N))**2
      IF(DELSP.EQ.0.0) THEN
C
C------ remove corner
        DO 10 I=IC+1, NP-1
          X(I,N) = X(I+1,N)
          Y(I,N) = Y(I+1,N)
   10   CONTINUE
        NPBL(N) = NP-1
C
      ELSE IF(DELSM.EQ.0.0) THEN
C
C------ remove corner
        DO 12 I=IC, NP-1
          X(I,N) = X(I+1,N)
          Y(I,N) = Y(I+1,N)
   12   CONTINUE
        NPBL(N) = NP-1
C
      ELSE
C
        IF(NP.GE.IX) THEN
         WRITE(*,*) 'Cannot add corner.  X,Y arrays will overflow.'
         RETURN
        ENDIF
C
C------ add corner
        DO 20 I=NP, IC, -1
          X(I+1,N) = X(I,N)
          Y(I+1,N) = Y(I,N)
   20   CONTINUE
        NPBL(N) = NP+1
C
      ENDIF
C
      CALL BLDFIX(N)
C
      LGAMU = .FALSE.
      LGLIN = .FALSE.
      RETURN
      END ! CORNER



      SUBROUTINE SWAP(N1,N2)
      INCLUDE 'AIRSET.INC'
      LOGICAL LTMP
C
      IF(N2.LT.1 .OR. N2.EQ.N1 .OR. N2.GT.NBL) THEN
       WRITE(*,*) 'No action taken'
       RETURN
      ENDIF
C
      DO 10 I=1, NPBL(N1)
        W1(I) = S(I,N1)
        W2(I) = X(I,N1)
        W3(I) = Y(I,N1)
        W4(I) = XP(I,N1)
        W5(I) = YP(I,N1)
 10   CONTINUE
C
      DO 12 I=1, NPBL(N2)
        S(I,N1)  = S(I,N2)
        X(I,N1)  = X(I,N2)
        Y(I,N1)  = Y(I,N2)
        XP(I,N1) = XP(I,N2)
        YP(I,N1) = YP(I,N2)
 12   CONTINUE
C
      DO 14 I=1, NPBL(N1)
        S(I,N2)  = W1(I)
        X(I,N2)  = W2(I)
        Y(I,N2)  = W3(I)
        XP(I,N2) = W4(I)
        YP(I,N2) = W5(I)
 14   CONTINUE
C
      ITMP = NPBL(N1)
      NPBL(N1) = NPBL(N2)
      NPBL(N2) = ITMP
C
      ITMP = NLINK(N1)
      NLINK(N1) = NLINK(N2)
      NLINK(N2) = ITMP
C
      LTMP = LCLOCK(N1)
      LCLOCK(N1) = LCLOCK(N2)
      LCLOCK(N2) = LTMP
C
      LTMP = LHOME(N1)
      LHOME(N1) = LHOME(N2)
      LHOME(N2) = LTMP
C
      W1( 1) = SLE(N1)   
      W1( 2) = CHRD(N1)  
      W1( 3) = ANG(N1)   
      W1( 4) = XLE(N1)   
      W1( 5) = YLE(N1)   
      W1( 6) = XTE(N1)   
      W1( 7) = YTE(N1)   
      W1( 8) = XREF(N1)  
      W1( 9) = YREF(N1)  
      W1(10) = ANGSUM(N1)
      W1(11) = DXSUM(N1)
      W1(12) = DYSUM(N1)
      W1(13) = XFTOT(N1)
      W1(14) = YFTOT(N1)
      W1(15) = XCENT(N1)
      W1(16) = YCENT(N1)
C
      SLE(N1)    = SLE(N2)   
      CHRD(N1)   = CHRD(N2)  
      ANG(N1)    = ANG(N2)   
      XLE(N1)    = XLE(N2)   
      YLE(N1)    = YLE(N2)   
      XTE(N1)    = XTE(N2)   
      YTE(N1)    = YTE(N2)   
      XREF(N1)   = XREF(N2)  
      YREF(N1)   = YREF(N2)  
      ANGSUM(N1) = ANGSUM(N2)
      DXSUM(N1)  = DXSUM(N2)
      DYSUM(N1)  = DYSUM(N2)
      XFTOT(N1)  = XFTOT(N2)
      YFTOT(N1)  = YFTOT(N2)
      XCENT(N1)  = XCENT(N2)
      YCENT(N1)  = YCENT(N2)
C
      SLE(N2)    = W1( 1)
      CHRD(N2)   = W1( 2)
      ANG(N2)    = W1( 3)
      XLE(N2)    = W1( 4)
      YLE(N2)    = W1( 5)
      XTE(N2)    = W1( 6)
      YTE(N2)    = W1( 7)
      XREF(N2)   = W1( 8)
      YREF(N2)   = W1( 9)
      ANGSUM(N2) = W1(10)
      DXSUM(N2)  = W1(11)
      DYSUM(N2)  = W1(12)
      XFTOT(N2)  = W1(13)
      YFTOT(N2)  = W1(14)
      XCENT(N2)  = W1(15)
      YCENT(N2)  = W1(16)
C
      LGAMU = .FALSE.
      LGLIN = .FALSE.
      RETURN
      END ! SWAP



      SUBROUTINE TRANS(NN,DX,DY)
C-------------------------------------------
C     Translates element NN and any linked 
C     elements by distance DX,DY.
C-------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LDONE(LX)
C
      DO 3 L=1, LX
        LDONE(L) = .FALSE.
 3    CONTINUE
C
      N = NN
C
 5    IF(LDONE(N)) RETURN
C
C---- send changes to panel routines
      CALL ADDXYA(N,DX,DY,0.0,0.0)
C
C---- shift element nodes
      DO 10 I=1, NPBL(N)
        X(I,N) = X(I,N) + DX
        Y(I,N) = Y(I,N) + DY
 10   CONTINUE
C
C---- shift other associated points
      XLE(N) = XLE(N) + DX
      YLE(N) = YLE(N) + DY
      XTE(N) = XTE(N) + DX
      YTE(N) = YTE(N) + DY
      XREF(N) = XREF(N) + DX
      YREF(N) = YREF(N) + DY
      XCENT(N) = XCENT(N) + DX
      YCENT(N) = YCENT(N) + DY
C
C---- accumulate shifts
      DXSUM(N) = DXSUM(N) + DX
      DYSUM(N) = DYSUM(N) + DY
C
      LGAMU = .FALSE.
      LDONE(N) = .TRUE.
      LHOME(N) = .FALSE.
C
C---- if another element is linked to the current one, shift that one too
      IF(NLINK(N).GT.0 .AND. NLINK(N).NE.N) THEN
       N = NLINK(N)
       GO TO 5
      ENDIF
C
      RETURN
      END ! TRANS


      SUBROUTINE SCAL(NN,XSCL,YSCL,XCT,YCT)
C------------------------------------------------
C     Scales element NN and any linked elements
C     by XSCL,YSCL, about point XCT,YCT.
C------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LDONE(LX)
C
      DO 3 L=1, LX
        LDONE(L) = .FALSE.
 3    CONTINUE
C
      XC = XCT
      YC = YCT
C
      N = NN
C
 5    IF(LDONE(N)) RETURN
C
C---- set changes about origin from changes about reference point
      DF = 0.5*LOG(ABS(XSCL*YSCL))
      DA = 0.0
      DX = (1.0-XSCL)*XC
      DY = (1.0-YSCL)*YC
C
C---- send changes to panel routines
      CALL ADDXYA(N,DX,DY,DF,DA)
C
C---- scale element nodes
      DO 10 I=1, NPBL(N)
        X(I,N) = XSCL*X(I,N) + DX
        Y(I,N) = YSCL*Y(I,N) + DY
   10 CONTINUE
C
C---- scale other associated points
      XLE(N) = XSCL*XLE(N) + DX
      YLE(N) = YSCL*YLE(N) + DY
      XTE(N) = XSCL*XTE(N) + DX
      YTE(N) = YSCL*YTE(N) + DY
      CHRD(N) = SQRT((XTE(N)-XLE(N))**2+(YTE(N)-YLE(N))**2)
      XCENT(N) = XSCL*XCENT(N) + DX
      YCENT(N) = YSCL*YCENT(N) + DY
      XREF(N) = XSCL*XREF(N) + DX
      YREF(N) = YSCL*YREF(N) + DY
C
      DXSUM(N) = XSCL*DXSUM(N) + DX
      DYSUM(N) = YSCL*DYSUM(N) + DY
C
C---- new chord angle (will change if XSCL and YSCL are different)
      ANG(N) = -ATAN2((YTE(N)-YLE(N)),(XTE(N)-XLE(N)))
C
      IF(XSCL*YSCL .LT. 0.0) THEN
C----- airfoil was flipped, so reverse node ordering
       DO 20 I=1, NPBL(N)/2
         IB = NPBL(N)-I+1
         XTMP = X(I,N)
         YTMP = Y(I,N)
         X(I,N) = X(IB,N)
         Y(I,N) = Y(IB,N)
         X(IB,N) = XTMP
         Y(IB,N) = YTMP
 20    CONTINUE
      ENDIF
C
      CALL SCALC(X(1,N),Y(1,N),S(1,N),NPBL(N))
      CALL SEGSPL(X(1,N),XP(1,N),S(1,N),NPBL(N))
      CALL SEGSPL(Y(1,N),YP(1,N),S(1,N),NPBL(N))
C
C---- accumulate scales
      XFTOT(N) = XFTOT(N)*XSCL
      YFTOT(N) = YFTOT(N)*YSCL
C
      LGAMU = .FALSE.
      LDONE(N) = .TRUE.
      LHOME(N) = .FALSE.
C
C---- geometry sensitiviti
      IF(XSCL .NE. YSCL) LGLIN = .FALSE.
C
C---- if another element is linked to the current one, scale that one too
      IF(NLINK(N).GT.0 .AND. NLINK(N).NE.N) THEN
       N = NLINK(N)
       GO TO 5
      ENDIF
C
      RETURN
      END ! SCAL

 
      SUBROUTINE ROTATE(NN,ANGL,XCT,YCT)
C------------------------------------------------
C     Rotates element NN and any linked elements
C     by ANGL (degrees) about the point XCT,YCT.
C------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LDONE(LX)
C
      DO 3 L=1, LX
        LDONE(L) = .FALSE.
 3    CONTINUE
C
      XC = XCT
      YC = YCT
C
      ARAD = ANGL * DTOR
      SA = SIN(ARAD)
      CA = COS(ARAD)
C
      N = NN
C
 5    IF(LDONE(N)) RETURN
C
C---- set changes about origin from changes about reference point
      DF = 0.0
      DA = ARAD
      DX = XC - (CA*XC + SA*YC)
      DY = YC - (CA*YC - SA*XC)
C
C---- send changes to panel routines
      CALL ADDXYA(N,DX,DY,DF,DA)
C
C---- rotate element nodes
      DO 10 I=1, NPBL(N)
        XX = X(I,N)
        YY = Y(I,N)
        X(I,N) = CA*XX + SA*YY + DX
        Y(I,N) = CA*YY - SA*XX + DY
   10 CONTINUE
C
C---- rotate other associated points
      XX = XLE(N)
      YY = YLE(N)
      XLE(N) = CA*XX + SA*YY + DX
      YLE(N) = CA*YY - SA*XX + DY
      XX = XTE(N)
      YY = YTE(N)
      XTE(N) = CA*XX + SA*YY + DX
      YTE(N) = CA*YY - SA*XX + DY
      XX = XCENT(N)
      YY = YCENT(N)
      XCENT(N) = CA*XX + SA*YY + DX
      YCENT(N) = CA*YY - SA*XX + DY
      XX = XREF(N)
      YY = YREF(N)
      XREF(N) = CA*XX + SA*YY + DX
      YREF(N) = CA*YY - SA*XX + DY
C
      XX = DXSUM(N)
      YY = DYSUM(N)
      DXSUM(N) = CA*XX + SA*YY + DX
      DYSUM(N) = CA*YY - SA*XX + DY
C
      ANG(N) = -ATAN2((YTE(N)-YLE(N)),(XTE(N)-XLE(N)))
C
      CALL SEGSPL(X(1,N),XP(1,N),S(1,N),NPBL(N))
      CALL SEGSPL(Y(1,N),YP(1,N),S(1,N),NPBL(N))
C
C---- accumulate rotation
      ANGSUM(N) = ANGSUM(N) + ANGL
C
      LGAMU = .FALSE.
      LDONE(N) = .TRUE.
      LHOME(N) = .FALSE.
C
C---- if another element is linked to the current one, rotate that one too
      IF(NLINK(N).GT.0 .AND. NLINK(N).NE.N) THEN
       N = NLINK(N)
       GO TO 5
      ENDIF
C
      RETURN
      END ! ROTATE


      SUBROUTINE MOVP(N)
C--------------------------------------------------
C     Moves cursor-selected point.
C--------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LABORT
      CHARACTER*1 KCHAR
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SHT = 0.35*CH
C
      CALL GETCOLOR(ICOL0)
      CALL PABORT(1.0,0.0)
C
      CALL POINTF(X(1,N),XP(1,N),Y(1,N),YP(1,N),S(1,N),NPBL(N),
     &            XOFF,SF,YOFF,SF,IPNT,XC,YC)
      IF(IPNT.EQ.0) RETURN
C
      CALL PLSYMB(XMOD(X(IPNT,N)),YMOD(Y(IPNT,N)),SHT,1,0.0,0)
C
      WRITE(*,1010) IPNT, XC, YC
 1010 FORMAT(' Move point',I4,' :  x =',F10.6,'   y =',F10.6,
     &       '   to cursor click ...')
C
      CALL GETCURSORXY(XCRS,YCRS,KCHAR)
      IF(LABORT(XCRS,YCRS)) RETURN
C
C---- go from screen to internal coordinates X,Y
      X(IPNT,N) = XCRS/SF + XOFF
      Y(IPNT,N) = YCRS/SF + YOFF
C
      IF(X(IPNT,N).EQ.XC .AND. Y(IPNT,N).EQ.YC) THEN
        CALL ASKR('Enter new x coordinate^',X(IPNT,N))
        CALL ASKR('Enter new y coordinate^',Y(IPNT,N))
      ENDIF
C
C---- spline new geometry
      CALL CHKBLD(N)
      CALL BLDFIX(N)
      LGAMU = .FALSE.
      LGLIN = .FALSE.
C
      KK = 1
      IF(LSPLIN) KK = 5000 / NPBL(N)
C
      CALL NEWCOLORNAME('red')
      CALL PLOT(XMOD(X(1,N)),YMOD(Y(1,N)),3)
      DO 30 I=2, NPBL(N)
        DSK = (S(I,N) - S(I-1,N))/FLOAT(KK)
C
C------ go over sub-intervals in this node interval
C-      (note that this will be skipped if  LSPLIN = F)
        DO 305 K=1, KK-1
          SK = S(I-1,N) + DSK*FLOAT(K)
          XK = SEVAL(SK,X(1,N),XP(1,N),S(1,N),NPBL(N))
          YK = SEVAL(SK,Y(1,N),YP(1,N),S(1,N),NPBL(N))
          CALL PLOT(XMOD(XK),YMOD(YK),2)
  305   CONTINUE
        CALL PLOT(XMOD(X(I,N)),YMOD(Y(I,N)),2)
   30 CONTINUE
      CALL NEWCOLOR(ICOL0)
      CALL PLFLUSH
C
      WRITE(*,1020) IPNT, X(IPNT,N), YB(IPNT,N)
 1020 FORMAT(' New  point',I4,' :  x =',F10.6,'   y =',F10.6)
      RETURN
      END



      SUBROUTINE POINTF(X,XP,Y,YP,S,N,XOFF,XSF,YOFF,YSF,IC,XX,YY)
      DIMENSION X(N),XP(N),Y(N),YP(N),S(N)
      LOGICAL LABORT
      CHARACTER*1 KCHAR
C--------------------------------------------------------
C     Finds the node IC nearest to cursor location XX,YY.
C--------------------------------------------------------
CCC      XMOD(XTMP) = XSF * (XTMP - XOFF)
CCC      YMOD(YTMP) = YSF * (YTMP - YOFF)
C
      WRITE(*,*)
      WRITE(*,*) 'Specify point with cursor'
C
C---- read geometry point coordinates
      CALL GETCURSORXY(XCRS,YCRS,KCHAR)
C
      IF(LABORT(XCRS,YCRS)) THEN
C------ abort: return with point selected
        IC = 0
        RETURN
      ENDIF
C
C---- go from screen to internal coordinates X,Y
      XX = XCRS/XSF + XOFF
      YY = YCRS/YSF + YOFF
C
C---- find closest airfoil node
      IC = 1
      DMIN = 1.0E9
      DO 7 I=1, N
        DIST = (X(I) - XX)**2 + (Y(I) - YY)**2
        IF(DIST .LT. DMIN) THEN
          DMIN = DIST
          IC = I
        ENDIF
    7 CONTINUE
C
      RETURN
      END ! POINTF
