

      SUBROUTINE SETLIM
      INCLUDE 'AIRSET.INC'
C------------------------------------
C     Sets geometry plotting limits
C------------------------------------
C
      XMAX = X(1,1)
      XMIN = X(1,1)
      YMAX = Y(1,1)
      YMIN = Y(1,1)
      DO 20 N = 1, NBL
        DO 10 I = 1, NPBL(N)
          XMAX = MAX(XMAX,X(I,N))
          XMIN = MIN(XMIN,X(I,N))
          YMAX = MAX(YMAX,Y(I,N))
          YMIN = MIN(YMIN,Y(I,N))
   10   CONTINUE
   20 CONTINUE
C
      IF(LIMAGE) THEN
       YMAX = MAX(YMAX,YGROUND)
       YMIN = MIN(YMIN,YGROUND)
      ENDIF
C
C---- set x,y scaling factors needed for O(1) size plot with "nice" limits
      CALL SCALIT(1,XMAX,XMIN,XSF,ANN,NANN)
      CALL SCALIT(1,YMAX,YMIN,YSF,ANN,NANN)
C
cccC---- grid increment as a fraction of a nice upper bound on delta x,y
ccc      DXY = 0.1 / MIN(XSF,YSF)
C
C---- grid increment as a fraction of a nice upper bound on delta x
      DXY = 0.1 / XSF
C
C---- set "nice" limits as integer multiples of DXY
      XMAX = DXY*(INT(XMAX/DXY+1000.05) - 999)
      XMIN = DXY*(INT(XMIN/DXY-1000.05) + 999)
      YMAX = DXY*(INT(YMAX/DXY+1000.25) - 999)
      YMIN = DXY*(INT(YMIN/DXY-1000.25) + 999)
C
      RETURN
      END


      SUBROUTINE GOFINI(LPG)
C-------------------------------------------------
C     Sets initial scaling and offset parameters   
C-------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LPG
C
C---- get current window size
      IF(LPLOT) CALL GETWINSIZE(XWIND,YWIND)
C
C---- fraction of X,Y window dimension taken up by airfoil grid
      XWF = (XWIND/SIZE) / 1.10
      YWF = (YWIND/SIZE) / 1.10
C
C---- window aspect ratio
      WAR = YWIND/XWIND
C
C---- airfoil grid extent
      XRANGE = XMAX-XMIN
      YRANGE = YMAX-YMIN
C
ccc      IF(LPG) THEN
C
CCC    SF = MIN( 1.0/XRANGE ,  AR/YRANGE )
       SF = MIN( 1.0/XRANGE , WAR/YRANGE )
       XOFF = XMIN - 7.5*CH/SF
       YOFF = YMIN - 4.0*CH/SF
C
ccc      ELSE
C
CCC    SF = MIN( 1.0/XRANGE ,  AR/YRANGE )
CCC    SF = MIN( 1.0/XRANGE , WAR/YRANGE )
c       SF = MIN( XWF/XRANGE , YWF/YRANGE )
C
CCC    XOFF = XMIN - 0.5*(1.0-SF*XRANGE)/SF - 7.5*CH/SF
CCC    YOFF = YMIN - 0.5*(WAR-SF*YRANGE)/SF - 4.0*CH/SF
c       XOFF = XMIN - 0.5*(XWF-SF*XRANGE)/SF - 7.5*CH/SF
c       YOFF = YMIN - 0.5*(YWF-SF*YRANGE)/SF - 4.0*CH/SF
C
ccc      ENDIF
C
      RETURN
      END ! GOFINI  
        

      SUBROUTINE POFINI(LPG)
C--------------------------------------------------------------
C     Initializes offsets,scales for  Cp vs x  plot.
C     If LPG=.true., set up for placing above geometry plot.
C--------------------------------------------------------------
      INCLUDE 'AIRSET.INC'
      LOGICAL LPG
C
      IF(CPMIN .GE. CPMAX) THEN
       CPMIN = -(1.0 + FLOAT(NBL))
       CPDEL = -0.5
       IF(CPMIN.LT.-3.9) CPDEL = -1.0
       CPMIN = CPDEL * AINT(CPMIN/CPDEL + 0.01)
       CPMIN = MIN( CPMIN , -1.0E0 )
      ENDIF
C
      IF(LPG) THEN
C
C------ airfoil offset,scale same as for geometry plot
        FACAIR = SF
        XOFAIR = XOFF
        YOFAIR = YOFF
C
C------ get window size
        IF(LPLOT) CALL GETWINSIZE(XWIND,YWIND)
C
        WAR = YWIND/XWIND
C
C------ length of Cp axis (with x-axis length = 1) ...
C-       ... no more than 1.5*AR, but no less than 0.5*AR
        YAX = MAX( MIN(WAR,1.5*AR) - (YMAX-YMIN)*SF , 0.5*AR )
C
C------ Cp offset,scale to place  Cp vs x  plot above geometry plot
        PSF = YAX/(CPMAX-CPMIN)
        POFF = -CPMAX - ((YMAX-YOFF)*SF + 2.0*CH) / PSF
C
      ELSE
C
C------ normal airfoil offset,scale
        FACAIR = 0.9/(XMAX-XMIN)
        XOFAIR = XMIN - 9.0*CH/FACAIR
C
C------ set length of Cp axis and place Cp axis flush with top
        YAX = 0.7*AR
        PSF = YAX/(CPMAX-CPMIN)
        POFF = -CPMAX - (AR-YAX)/PSF
C
C------ airfoil is centered in bottom part of y-space not filled by Cp axis
        YOFAIR = 0.5*(YMIN+YMAX) - 0.5*(AR-YAX)/FACAIR
C
      ENDIF
C
      RETURN
      END



      SUBROUTINE PLTINI
      INCLUDE 'AIRSET.INC'
C
C---- close previous plot, if any
      IF(LPLOT) CALL PLEND
C
C---- initialize new plot and set absolute size
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
      CALL NEWFACTOR(SIZE)
C
C---- get window size
      CALL GETWINSIZE(XWIND,YWIND)
C
      RETURN
      END



      SUBROUTINE CPAXES
C--------------------------------
C     Initializes Cp vs x/c plot
C--------------------------------
      INCLUDE 'AIRSET.INC'
      AXMOD(XTMP) = FACAIR * (XTMP - XOFAIR)
ccc   AYMOD(YTMP) = FACAIR * (YTMP - YOFAIR)
      PMOD(PTMP) = PSF * (-PTMP - POFF)
C
      CH2 = 1.6*CH
C
C
C---- plot Cp axis from Cpmax to Cpmin
      CALL YAXIS(AXMOD(XMIN),PMOD(CPMAX),
     &          (CPMAX-CPMIN)*PSF,-CPDEL*PSF,
     &           CPMAX,CPDEL,0.9*CH2,1)
C
      CALL NEWPEN(3)
      YPLT = CPDEL * (FLOAT(INT(CPMIN/CPDEL + 0.01)/2) + 0.5)
      CALL PLCHAR(AXMOD(XMIN)-4.0*CH2,PMOD(YPLT)-0.6*CH2,
     &            1.2*CH2,'C',0.0,1)
      CALL PLCHAR(AXMOD(XMIN)-2.9*CH2,PMOD(YPLT)-0.9*CH2,
     &            0.9*CH2,'p',0.0,1)
C
C---- add sonic Cp dashed line if within plot
      IF(CPSTAR.GE.CPMIN)
     &   CALL DASH(AXMOD(XMIN),AXMOD(XMAX),PMOD(CPSTAR))
C
C---- plot Cp=0 line
      YAX = PMOD(0.0)
      CALL NEWPEN(1)
      CALL PLOT(AXMOD(XMIN),YAX,3)
      CALL PLOT(AXMOD(XMAX),YAX,2)
C
C---- add tick marks
      DO 10 IT=0, 2
        XTIK = 0.5*FLOAT(IT)
        CALL PLOT(AXMOD(XTIK),YAX+0.005,3)
        CALL PLOT(AXMOD(XTIK),YAX-0.005,2)
   10 CONTINUE
C
      DO 15 IT=1, 9
        XTIK = 0.1*FLOAT(IT)
        CALL PLOT(AXMOD(XTIK),YAX+0.0025,3)
        CALL PLOT(AXMOD(XTIK),YAX-0.0025,2)
   15 CONTINUE
C
      CALL PLFLUSH
C
      RETURN
      END ! CPAXES



      SUBROUTINE GEAXES
      INCLUDE 'AIRSET.INC'
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
C
C---- plot outline
      CALL NEWPEN(1)
ccc   CALL PLOT(XMOD(XMIN),YMOD(YMIN),3)
      CALL PLOT(XMOD(XMAX),YMOD(YMIN),3)
      CALL PLOT(XMOD(XMAX),YMOD(YMAX),2)
      CALL PLOT(XMOD(XMIN),YMOD(YMAX),2)
ccc   CALL PLOT(XMOD(XMIN),YMOD(YMIN),2)
C
C---- fine grid
      CALL NEWPEN(1)
      NXG = INT((XMAX-XMIN)/DXY + 0.01)
      NYG = INT((YMAX-YMIN)/DXY + 0.01)
      X0 = XMOD(XMIN)
      Y0 = YMOD(YMIN)
      DXG = (XMOD(XMAX)-X0)/NXG
      DYG = (YMOD(YMAX)-Y0)/NYG
C
C==========================================
C---- plot dashed grid
      CALL PLGRID(X0,Y0,NXG,DXG,NYG,DYG, LMASK2)
C==========================================
cC---- plot solid-line grid
c      XN = X0 + DXG*FLOAT(NXG)
c      YN = Y0 + DYG*FLOAT(NYG)
c      DO 10 K=0, NXG
c        XLIN = X0 + DXG*FLOAT(K)
c        CALL PLOT(XLIN,Y0,3)
c        CALL PLOT(XLIN,YN,2)
c   10 CONTINUE
c      DO 20 K=0, NYG
c        YLIN = Y0 + DYG*FLOAT(K)
c        CALL PLOT(X0,YLIN,3)
c        CALL PLOT(XN,YLIN,2)
c   20 CONTINUE
C==========================================
C
      NDIG = INT(0.99-ALOG10(DXY))
      IF(NDIG.LE.0) NDIG = -1
C
      CALL XAXIS(XMOD(XMIN),YMOD(YMIN),(XMAX-XMIN)*SF,DXY*SF,
     &           XMIN,DXY,CH,NDIG)
      CALL YAXIS(XMOD(XMIN),YMOD(YMIN),(YMAX-YMIN)*SF,DXY*SF,
     &           YMIN,DXY,CH,NDIG)
C
      CALL PLFLUSH
C
      RETURN
      END


      SUBROUTINE GEOPLT(NTARG)
C--------------------------------------------------
C     Plots the entire current geometry with a grid.
C--------------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*32 COLORN(LX)
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SSF = SQRT(SQRT(SF))
C
C---- size of node tick mark
      DTICK = 0.001 * MAX( (XMAX-XMIN) , (YMAX-YMIN) )
C
      CALL GETCOLOR(ICOL0)
C
C---- set default color for each element
      DO L=1, NBL
        COLORN(L) = 'black'
      ENDDO
C
C---- set different color for target element
      IF(NTARG.GE.1 .AND. NTARG.LE.NBL) THEN
        L = NTARG
        COLORN(L) = 'blue'
C
C------ if another element is linked to the current one, color it also
 5      CONTINUE
        IF(NLINK(L).GT.0 .AND. NLINK(L).NE.L) THEN
         L = NLINK(L)
         COLORN(L) = 'cyan'
         GO TO 5
        ENDIF
      ENDIF
C
      IF(LIMAGE) THEN
        YSG = 1.0
        IF(Y(1,1) .GT. YGROUND) YSG = -1.0
        CALL NEWCOLORNAME('brown')
        CALL GNDPLT(XMIN,XMAX,YGROUND,XOFF,YOFF,SF,YSG)
      ENDIF
C
C---- go over each element...
      CALL NEWPEN(2)
      DO 100 L=1, NBL
        NP = NPBL(L)
C
        KK = 1
        IF(LSPLIN) KK = 5000 / NP
C
        CALL NEWCOLORNAME(COLORN(L))
C
C------ plot a "+" at reference point
        CALL PLSYMB(XMOD(XREF(L)),YMOD(YREF(L)),2.0*CH*SSF,3,0.0,0)
C
        CALL PLOT(XMOD(X(1,L)),YMOD(Y(1,L)),3)
        DO 30 I=2, NPBL(L)
          DSK = (S(I,L) - S(I-1,L))/FLOAT(KK)
C
C-------- go over sub-intervals in this node interval
C-        (note that this will be skipped if  LSPLIN = F)
          DO 305 K=1, KK-1
            SK = S(I-1,L) + DSK*FLOAT(K)
            XK = SEVAL(SK,X(1,L),XP(1,L),S(1,L),NP)
            YK = SEVAL(SK,Y(1,L),YP(1,L),S(1,L),NP)
            CALL PLOT(XMOD(XK),YMOD(YK),2)
  305     CONTINUE
          CALL PLOT(XMOD(X(I,L)),YMOD(Y(I,L)),2)
C
C-------- plot symbol at doubled (corner) node
          IF(X(I,L).EQ.X(I-1,L) .AND. Y(I,L).EQ.Y(I-1,L)) THEN
           CALL NEWCOLORNAME('green')
           CALL PLSYMB(XMOD(X(I,L)),YMOD(Y(I,L)),0.010*SSF,5,0.0,0)
           CALL NEWCOLORNAME(COLORN(L))
          ENDIF
C
   30   CONTINUE
C
        IF(LNODE) THEN
C------- add node tick marks
         DO 50 I=1, NPBL(L)
           XX = X(I,L) 
           YY = Y(I,L)
           CALL PLOT(XMOD(XX),YMOD(YY),3)
           XX = X(I,L) - DTICK*YP(I,L)
           YY = Y(I,L) + DTICK*XP(I,L)
           CALL PLOT(XMOD(XX),YMOD(YY),2)
   50    CONTINUE
        ENDIF
C
        IF(LNUMB) THEN
C------- plot element number at centroid
         CHN = 1.2*CH*SSF
         XNUM = XMOD(XCENT(L))
         YNUM = YMOD(YCENT(L))
         CALL PLNUMB(XNUM-0.5*CHN,YNUM-0.5*CHN,CHN,FLOAT(L),0.0,-1)
        ENDIF
C
  100 CONTINUE
C
      IF(NTARG.GE.1 .AND. NTARG.LE.NBL) THEN
C----- add plot ornaments for target element
C
       L = NTARG
       CALL NEWCOLORNAME(COLORN(L))
C
C----- plot a "+" at reference point (plot last, so target color shows up)
       CALL PLSYMB(XMOD(XREF(L)),YMOD(YREF(L)),2.0*CH*SSF,3,0.0,0)
C
       IF(LNUMB) THEN
C------ add box around target-element number
        XNUM = XMOD(XCENT(L))
        YNUM = YMOD(YCENT(L))
        CALL PLOT(XNUM-1.0*CHN,YNUM-0.9*CHN,3)
        CALL PLOT(XNUM+0.8*CHN,YNUM-0.9*CHN,2)
        CALL PLOT(XNUM+0.8*CHN,YNUM+0.9*CHN,2)
        CALL PLOT(XNUM-1.0*CHN,YNUM+0.9*CHN,2)
        CALL PLOT(XNUM-1.0*CHN,YNUM-0.9*CHN,2)
       ENDIF
C
C----- add circle around reference point
       CALL PLSYMB(XMOD(XREF(L)),YMOD(YREF(L)),1.2*CH*SSF,1,0.0,0)
      ENDIF
C
      CALL PLFLUSH
C
C---- restore original color
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! GEOPLT


      SUBROUTINE GNDPLT(X1,X2,Y,XOFF,YOFF,SF,YSGN)
C-----------------------------------------------
C     Plots nifty ground plane with tick marks.
C-----------------------------------------------
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      NT = 25
      DS = 0.2*(X2-X1)/FLOAT(NT)
C
      CALL NEWPEN(5)
      CALL PLOT(XMOD(X1),YMOD(Y),3)
      CALL PLOT(XMOD(X2),YMOD(Y),2)
C
      CALL NEWPEN(3)
      DO 10 IT=1, NT
        X = X1 + (X2-X1)*(FLOAT(IT)-0.5)/FLOAT(NT)
        CALL PLOT(XMOD(X   ),YMOD(Y        ),3)
        CALL PLOT(XMOD(X+DS),YMOD(Y+DS*YSGN),2)
 10   CONTINUE
C
      RETURN
      END


      SUBROUTINE AIRHPL(ILIN)
C-------------------------------------------
C     Plots home position of all elements.
C-------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      DO 100 N=1, NBL
C
        ARAD = -ANGSUM(N) * DTOR
        SA = SIN(ARAD)
        CA = COS(ARAD)
C
C------ shift, rotate, scale  element nodes
        DO 10 I=1, NPBL(N)
          XX = X(I,N) - DXSUM(N)
          YY = Y(I,N) - DYSUM(N)
          W1(I) = (CA*XX + SA*YY)/XFTOT(N)
          W2(I) = (CA*YY - SA*XX)/YFTOT(N)
   10   CONTINUE
C
        CALL XYLINE(NPBL(N),W1,W2,XOFAIR,FACAIR,YOFAIR,FACAIR,ILIN)
C
 100  CONTINUE
      CALL PLFLUSH
C
      RETURN
      END ! AIRHPL


      SUBROUTINE AIRFPL(ILIN)
C-------------------------------------------
C     Plots all elements.
C-------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      DO 100 N=1, NBL
        CALL XYLINE(NPBL(N),X(1,N),Y(1,N),
     &              XOFAIR,FACAIR,YOFAIR,FACAIR,ILIN)
 100  CONTINUE
      CALL PLFLUSH
C
      RETURN
      END ! AIRFPL



      SUBROUTINE OVER(LINE)
C-------------------------------------------------------
C     Overlays configuration from disk on current plot.
C-------------------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*(*) LINE
C
      CHARACTER*32 NAME1
      CHARACTER*4 DUMMY
      DIMENSION KPBL(LX)
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      CALL STRIP(LINE,NLINE)
C
      IF(NLINE.EQ.0) THEN
C------ print default filename and get user's input
        WRITE(*,1005) OFNAME(1:60)
        READ (*,1010) FNAME
        CALL STRIP(FNAME,NFNAME)
      ELSE
C------ input was passed in through LINE string
        FNAME = LINE
        NFNAME = NLINE
      ENDIF
C
      IF(NFNAME .NE. 0) THEN
C----- non-blank input: set new default filename
       OFNAME = FNAME
      ELSE
C----- blank input: use default filename
       FNAME = OFNAME
      ENDIF
C
      CALL READBL(FNAME,IX,LX,XB,YB,
     &            KPBL,KBL,
     &            NAME1,XINL1,XOUT1,YBOT1,YTOP1)
C
      CALL GETCOLOR(ICOL0)
C
      CALL NEWCOLORNAME('magenta')
C
      CALL NEWPEN(1)
      DO 100 L=1, KBL
        NP = KPBL(L)
C
        KK = 1
        IF(LSPLIN) KK = 5000/NP
C
        CALL SCALC(XB(1,L),YB(1,L),W3(1),NP)
        CALL SEGSPL(XB(1,L),W1(1),W3(1),NP)
        CALL SEGSPL(YB(1,L),W2(1),W3(1),NP)
C
        CALL PLOT(XMOD(XB(1,L)),YMOD(YB(1,L)),3)
        DO 50 I=2, KPBL(L)
          DSK = (W3(I) - W3(I-1))/FLOAT(KK)
C
C-------- go over sub-intervals in this node interval
C-        (note that this will be skipped if  LSPLIN = F)
          DO 505 K=1, KK-1
            SK = W3(I-1) + DSK*FLOAT(K)
            XK = SEVAL(SK,XB(1,L),W1(1),W3(1),NP)
            YK = SEVAL(SK,YB(1,L),W2(1),W3(1),NP)
            CALL PLOT(XMOD(XK),YMOD(YK),2)
  505     CONTINUE
C
          CALL PLOT(XMOD(XB(I,L)),YMOD(YB(I,L)),2)
   50   CONTINUE
C
  100 CONTINUE
C
      CALL PLFLUSH
C
      CALL NEWCOLOR(ICOL0)
      RETURN
C
C...............................................................
 1005 FORMAT(1X,'Enter filename:  ', A60)
 1010 FORMAT(A80)
      END ! OVER



      SUBROUTINE CPLAB(XLAB,YLAB,XL1,XL2,XL3)
      INCLUDE 'AIRSET.INC'
C
      CCH = 2.0*CH
      CH3 = 1.6*CH
C
      CALL NEWPEN(3)
      YLAB = YLAB - CCH
      XPLT = XLAB - 0.5*CCH*FLOAT(NNAME) + 10.0*CH3
      XPLT = MIN(XPLT,1.0-CCH*FLOAT(NNAME))
      CALL PLCHAR(XPLT,YLAB,CCH,NAME,0.0,NNAME)
C
      IF(MINF .GT. 0.0) THEN
       YLAB = YLAB - 2.0*CCH
       XPLT = XLAB + 2.0*CCH
       CALL PLCHAR(XPLT        ,YLAB,0.9*CCH,'Mach = ',0.0,7)
       CALL PLNUMB(XPLT+5.6*CCH,YLAB,0.9*CCH, MINF    ,0.0,3)
      ENDIF
C
      XL1 = XLAB
      XL2 = XL1 + 8.0*CH3
      XL3 = XL2 + 9.0*CH3
      YLAB = YLAB - 2.7*CH3
      CALL NEWPEN(3)
      CALL PLCHAR(XL1+0.5*CH3,YLAB,CH3,'Alfa',0.0,4)
      CALL PLCHAR(XL2+2.0*CH3,YLAB,CH3,'CL'  ,0.0,2)
      CALL PLCHAR(XL3+2.0*CH3,YLAB,CH3,'CM'  ,0.0,2)
C
      CALL NEWPEN(1)
      CALL PLOT(XL1        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL1+5.0*CH3,YLAB-0.4*CH3,2)
      CALL PLOT(XL2        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL2+6.0*CH3,YLAB-0.4*CH3,2)
      CALL PLOT(XL3        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL3+6.0*CH3,YLAB-0.4*CH3,2)
C
      YLAB = YLAB - 0.3*CH3
      RETURN
      END ! CPLAB


      SUBROUTINE ALMPLT(YLAB,XL1,XL2,XL3,ALT,CLT,CMT)
      INCLUDE 'AIRSET.INC'
C
      CH3 = 1.8*CH
C
      CALL NEWPEN(2)
      DXL1 = 0.
      DXL2 = 0.
      DXL3 = 0.
      IF(ALT.LT.0.0) DXL1 = -CH3
      IF(CLT.LT.0.0) DXL2 = -CH3
      IF(CMT.LT.0.0) DXL3 = -CH3
      IF(ABS(ALT) .GE. 10.0) DXL1 = DXL1 - CH3
C
      NDIGA = 3
      NDIGL = 4
      NDIGM = 4
C
      GCL = ALOG10( MAX(ABS(CLT),0.9) )
      GCM = ALOG10( MAX(ABS(CMT),0.9) )
C
      NDIGL = NDIGL - INT(GCL)
      NDIGM = NDIGM - INT(GCM)
C
      YLAB = YLAB - 2.0*CH3
      CALL PLNUMB(XL1+DXL1,YLAB,CH3,ALT,0.0,NDIGA)
      CALL PLNUMB(XL2+DXL2,YLAB,CH3,CLT,0.0,NDIGL)
      CALL PLNUMB(XL3+DXL3,YLAB,CH3,CMT,0.0,NDIGM)
C
      RETURN
      END ! ALMPLT



      SUBROUTINE DIST
C--------------------------------------------------
C     Displays distance between two cursor points.
C--------------------------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 CHKEY
C
      WRITE(*,*)
      WRITE(*,*) 'Click mouse or hit a key on each point'
      WRITE(*,*)
      CALL GETCURSORXY(XX1,YY1,CHKEY) 
      CALL PLOT(XX1,YY1,3)
      CALL PLOT(XX1,YY1,2)
      CALL PLFLUSH
      XX1 = XX1/SF + XOFF
      YY1 = YY1/SF + YOFF
      WRITE(*,1010) XX1,YY1
C
      CALL GETCURSORXY(XX2,YY2,CHKEY)
      CALL PLOT(XX2,YY2,3)
      CALL PLOT(XX2,YY2,2)
      CALL PLFLUSH
      XX2 = XX2/SF + XOFF
      YY2 = YY2/SF + YOFF
      WRITE(*,1020) XX2,YY2
C
      DX = XX2 - XX1
      DY = YY2 - YY1
      DS = SQRT(DX*DX + DY*DY)
      WRITE(*,1050) DX, DY, DS
C
 1010 FORMAT(' x1 =', F10.6, '    y1 =', F10.6)
 1020 FORMAT(' x2 =', F10.6, '    y2 =', F10.6)
 1050 FORMAT(' dx =', F10.6, '    dy =', F10.6,'    ds =', F10.6)
C
      RETURN
      END
