
      PROGRAM AIRSET
C-------------------------------------------------------
C     Creates and edits multi-element MSES datasets.
C-------------------------------------------------------
C
      INCLUDE 'AIRSET.INC'
      CHARACTER*80 ARGP1, LINE
      CHARACTER*4 COMAND
      LOGICAL ERROR
C
      VERSION = 2.3
C
      WRITE(*,1000) VERSION
C
      CALL INIT
      NTARG = 0
C
      ARGP1 = ' '
      CALL GETARG(1,ARGP1)
      IF(ARGP1(1:1) .NE. ' ') THEN
       FNAME = 'blade.' // ARGP1
       CALL LOAD
      ENDIF
C
      WRITE(*,1100)
C
 500  CALL ASKC('AIRSET^',COMAND)
      IF(COMAND.EQ.'    ') GO TO 500
C
      IF(COMAND.EQ.'?   ') THEN
C
        WRITE(*,1100)
C
      ELSE IF(COMAND.EQ.'QUIT') THEN
C
        IF(LPLOT) CALL PLEND
        CALL PLCLOSE
        STOP
C
      ELSE IF(COMAND.EQ.'ADDE') THEN
C
        CALL RDNEW
C
      ELSE IF(COMAND.EQ.'DELE') THEN
C
        CALL ASKI('Specify element to delete^',N)
        CALL DELEL(N)
C
      ELSE IF(COMAND.EQ.'LOAD') THEN
C
        FNAME = ' '
        CALL LOAD
        NTARG = 0
C
      ELSE IF(COMAND.EQ.'CLR ') THEN
C
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        CALL INIT
C
      ELSE IF(COMAND.EQ.'POSI') THEN
C
        CALL GETEL(NTARG)
        CALL EDTBLD(NTARG)
C
      ELSE IF(COMAND.EQ.'MODI') THEN
C
        CALL GETEL(NTARG)
        CALL MODBLD(NTARG)
C
      ELSE IF(COMAND.EQ.'DOUB') THEN
C
C------ explicitly ask for target element
        NTARG = 0
        CALL GETEL(NTARG)
        CALL DOUBLE(NTARG)
C
      ELSE IF(COMAND.EQ.'HALF') THEN
C
C------ explicitly ask for target element
        NTARG = 0
        CALL GETEL(NTARG)
        CALL HALF(NTARG)
C
      ELSE IF(COMAND.EQ.'OPER') THEN
C
        CALL OPER
C
      ELSE IF(COMAND.EQ.'GROU') THEN
C
       YGROLD = YGROUND
       CALL ASKR('Enter y location of ground plane (999=none)^',YGROUND)
       LIMAGE = YGROUND .NE. 999.0
       IF(YGROUND.NE.YGROLD) THEN
        LGAMU = .FALSE.
        LGLIN = .FALSE.
       ENDIF
C
      ELSE IF(COMAND.EQ.'PLOT') THEN
C
        CALL SETLIM
        CALL GOFINI(.FALSE.)
        CALL PLTINI
        CALL GEAXES
        CALL GEOPLT(0)
C
      ELSE IF(COMAND.EQ.'ANNO') THEN
C
        CALL ANNOT(1.4*CH)
C
      ELSE IF(COMAND.EQ.'OVER') THEN
C
        IF(.NOT.LPLOT) THEN
         CALL SETLIM
         CALL GOFINI(.FALSE.)
         CALL PLTINI
         CALL GEAXES
         CALL GEOPLT(0)
        ENDIF
C
        DO 4 K=1, LEN(LINE)
          LINE(K:K) = ' '
 4      CONTINUE
        CALL OVER(LINE)
C
      ELSE IF(COMAND.EQ.'SAVE') THEN
C
        CALL SAVE
C
      ELSE IF(COMAND.EQ.'CDIR') THEN
C
        WRITE(*,*)
        DO N=1, NBL
          LCLOCK(N) = .NOT. LCLOCK(N)
          IF(.NOT.LCLOCK(N)) WRITE(*,1341) N
          IF(     LCLOCK(N)) WRITE(*,1342) N
 1341     FORMAT(1X,'Element', I3,':  Counterclockwise ordering.')
 1342     FORMAT(1X,'Element', I3,':  Clockwise ordering.')
        ENDDO
C
      ELSE IF(COMAND.EQ.'NODE') THEN

        LNODE = .NOT. LNODE
        WRITE(*,*)
        IF(     LNODE) WRITE(*,*) 'Element nodes will be plotted'
        IF(.NOT.LNODE) WRITE(*,*) 'Element nodes will not be plotted'
C
      ELSE IF(COMAND.EQ.'NUMB') THEN

        LNUMB = .NOT. LNUMB
        WRITE(*,*)
        IF(     LNUMB) WRITE(*,*) 'Element numbers will be plotted'
        IF(.NOT.LNUMB) WRITE(*,*) 'Element numbers will not be plotted'
C
      ELSE IF(COMAND.EQ.'SPLI') THEN
C
        LSPLIN = .NOT. LSPLIN
        WRITE(*,*)
        IF(     LSPLIN) WRITE(*,*) 'Spline plotting enabled'
        IF(.NOT.LSPLIN) WRITE(*,*) 'Spline plotting disabled'
C
      ELSE IF(COMAND.EQ.'SIZE') THEN
C
        WRITE(*,*)
        WRITE(*,*) 'Currently plot size = ', SIZE
        CALL ASKR('Enter new plot size^',SIZE)
C
      ELSE IF(COMAND.EQ.'NAME') THEN
C
        WRITE(*,28) NAME
   28   FORMAT(/1X,'Old name: ',A32)
        CALL ASKS('Enter new name^',NAME)
        CALL STRIP(NAME,NNAME)
C
      ELSE IF(COMAND.EQ.'HARD') THEN
C
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        CALL REPLOT(IDEVRP)
C
      ELSE IF(COMAND.EQ.'COOR') THEN
C
        N = 1
        IF(NBL.GT.1) CALL ASKI('Enter element number^',N)
        CALL COORDS(N)
C
      ELSE
C
        WRITE(*,1050) COMAND
C
      ENDIF
      GO TO 500
C
C.....................................................................
 1000 FORMAT(/' ========================='
     &       /'    AIRSET Version', F4.1             
     &       /' =========================')
C
 1050 FORMAT(1X,A4,' command not recognized.  Type a "?" for list')
 1100 FORMAT(/'   QUIT  Exit program'
     &      //'   ADDE  Add on element(s) from single-airfoil file(s)'
     &       /'   DELE  Delete specified element'
     &      //'   LOAD  Read  multielement airfoil file'
     &       /'   SAVE  Write multielement airfoil file'
     &      //'   CDIR  Change x,y coordinate direction'
     &       /'   CLR   Clear element(s) and re-initialize'
     &      //'  .POSI  Edit position/size of element(s)'
     &       /'  .MODI  Modify contour shape and/or split off flap'
     &      //'  .OPER  Calculate operating point(s)'
     &       /'   GROU  Specify/eliminate ground plane'
     &      //'   DOUB  Double the number of points in an element'
     &       /'   HALF  Halve  the number of points in an element'
     &      //'   PLOT  Plot current airfoil'
     &       /'   OVER  Overlay airfoil from disk file'
     &       /'   ANNO  Annotate current plot'
     &       /'   HARD  Hardcopy current plot'
     &      //'   NODE  Enable/disable element node plotting'
     &       /'   NUMB  Enable/disable element number plotting'
     &       /'   SPLI  Enable/disable plotting via spline'
     &       /'   SIZE  Change absolute plot size'
     &      //'   NAME  Change airfoil name'
     &       /'   COOR  Locate specified surface x,y coordinates')
      END ! AIRSET

 
 
      SUBROUTINE INIT
C-----------------------------------------------
C     Variable initialization/default routine.
C-----------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      PI = 4.0*ATAN(1.0)
      DTOR = PI/180.0
C
      MINF = 0.0
      CPSTAR = -999.0
C
C---- initialize various flags
      LAIR   = .FALSE.  ! airfoil currently loaded ?
      LPLOT  = .FALSE.  ! plot currently open ?
      LGAMU  = .FALSE.  ! unit-vorticity distributions exist ?
      LGLIN  = .FALSE.  ! element-displacement sensitivities exist ?
      LCPSHO = .FALSE.  ! Cp response to element displacements is plotted ?
C
      LNUMB  = .TRUE.   ! element numbers to be plotted ?
      LNODE  = .TRUE.   ! nodes to be plotted ?
      LSPLIN = .TRUE.   ! plotting via spline interpolation ?
      LGSLOP = .TRUE.   ! slope matching to be performed in MODI ?
C
      LIMAGE = .FALSE.  ! ground-plane image present ?
      YGROUND = 999.0
C
      DO 10 L=1, LX
        CALL CLRHOM(L)
        LHOME(L) = .TRUE.   ! element L in its home position ?
   10 CONTINUE
C
C---- default paneling parameters
      NPAN1 = 80
      FNBLD1 = 0.3
      CVPAR1 = 1.0
      CTERAT1 = 0.2
C
C---- default CM reference location
      XCMOM = 0.25
      YCMOM = 0.0
C
C---- no elements present to begin with
      NBL = 0
C
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU 4    (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU 10+?
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.70
C
C---- Default plot size in inches
      SIZE = 10.0
C
C---- default window size in inches
      XWIND = 11.0
      YWIND =  8.5
C
C---- plot aspect ratio, character height
      AR = 0.75
      CH = 0.009
C
C---- Cp axis limits (if equal, auto-scaling will be used)
      CPMAX = 1.0
      CPMIN = 1.0
C
      CALL PLINITIALIZE
C
C---- default MSES domain parameters
      MGPARS = '-2.0 3.0  -2.5 3.5'
C
      DO 50 K=1, 80
        OFNAME(K:K) = ' '
 50   CONTINUE
C
C=======================================
C---- predefined keys for .EDIT menu
C
C---- up-arrow
      KEYNAM(1) = CHAR(27) // '[A     '
      KEYPRT(1) = 'up-arrow'
      KEYDEF(1) = 'T  0.0  0.005'
      LKEY(1) = .TRUE.
C
C---- down-arrow
      KEYNAM(2) = CHAR(27) // '[B     '
      KEYPRT(2) = 'dn-arrow'
      KEYDEF(2) = 'T  0.0 -0.005'
      LKEY(2) = .TRUE.
C
C---- right-arrow
      KEYNAM(3) = CHAR(27) // '[C     '
      KEYPRT(3) = 'rt-arrow'
      KEYDEF(3) = 'T  0.005 0.0 '
      LKEY(3) = .TRUE.
C
C---- left-arrow
      KEYNAM(4) = CHAR(27) // '[D     '
      KEYPRT(4) = 'lf-arrow'
      KEYDEF(4) = 'T -0.005 0.0 '
      LKEY(4) = .TRUE.
C
C---- page-up
      KEYNAM(5) = CHAR(27) // '[5~    '
      KEYPRT(5) = 'page-up '
      KEYDEF(5) = 'A  1.0       '
      LKEY(5) = .TRUE.
C
C---- page-down
      KEYNAM(6) = CHAR(27) // '[6~    '
      KEYPRT(6) = 'page-dwn'
      KEYDEF(6) = 'A -1.0       '
      LKEY(6) = .TRUE.
C=======================================
C
      RETURN
      END ! INIT



      SUBROUTINE LOAD
C-----------------------------------
C     Reads in MSES element dataset
C-----------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*80 LINE
C
      IF(INDEX(FNAME(1:1),' ').EQ.1) CALL ASKS('Enter filename^',FNAME)
C
      CALL READBL(FNAME,IX,LX,X,Y,
     &            NPBL,NBL,
     &            NAME,XINL,XOUT,YBOT,YTOP)
C
      IF(NBL.LE.0) THEN
       WRITE(*,*) ' *** LOAD NOT COMPLETED ***' 
       RETURN
      ENDIF
C
C---- get name ?
      IF(NAME(1:8) .EQ. '        ') THEN
        WRITE(*,*)
        WRITE(*,*) 'Enter case name:'
        READ(*,1000) NAME
 1000   FORMAT(A)
      ENDIF
C
C---- get domain info ?
      IF(ABS(XINL-XOUT) .LT. 1.0E-8) THEN
 10     WRITE(*,1005)
 1005   FORMAT(/' Enter  Xinl, Xout, Ybot, Ytop :')
        READ(*,*,ERR=10) XINL,XOUT,YBOT,YTOP
      ENDIF
C
      CALL STRIP(NAME,NNAME)
      WRITE(MGPARS,2000) XINL,XOUT,YBOT,YTOP
 2000 FORMAT(1X,4F12.6)
C
      DO 50 N = 1, NBL
        CALL CHKBLD(N)
   50 CONTINUE
C
      DO 60 N = 1, NBL
        CALL BLDFIX(N)
        CALL CLRHOM(N)
        LHOME(N) = .TRUE.
   60 CONTINUE
C
      LAIR = .TRUE.
      LGAMU = .FALSE.
      LGLIN = .FALSE.
      LCPSHO = .FALSE.
C
C---- set CPmin so it will be auto-scaled later
      CPMIN = CPMAX
C
      CALL SETLIM
C
      RETURN
      END ! LOAD
 


      SUBROUTINE CHKBLD(N)
C------------------------------------------------------
C     Checks element N, reversing points if necessary 
C------------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      NP = NPBL(N)
C
C---- calculate airfoil area assuming counterclockwise ordering
      I = 1
      RX = X(I,N) + X(NP,N)
      RY = Y(I,N) + Y(NP,N)
      DX = X(I,N) - X(NP,N)
      DY = Y(I,N) - Y(NP,N)
      DA = -0.5*DX*RY
      AREA = DA
      XSUM = DA * 0.50*RX
      YSUM = DA * 0.25*RY
      DO 36 I=2, NP
        RX = X(I,N) + X(I-1,N)
        RY = Y(I,N) + Y(I-1,N)
        DX = X(I,N) - X(I-1,N)
        DY = Y(I,N) - Y(I-1,N)
        DA = -0.5*DX*RY
        AREA = AREA + DA
        XSUM = XSUM + DA * 0.50*RX
        YSUM = YSUM + DA * 0.25*RY
   36 CONTINUE
C
      IF(AREA .EQ. 0.0) THEN
        XCENT(N) = 0.5*(X(1,N) + X(NP,N))
        YCENT(N) = 0.5*(Y(1,N) + Y(NP,N))
      ELSE
        XCENT(N) = XSUM/AREA
        YCENT(N) = YSUM/AREA
      ENDIF
C
      IF(AREA.GE.0.0) THEN
       LCLOCK(N) = .FALSE.
       WRITE(*,1010) NP
      ELSE
C----- if area is negative (clockwise order), reverse coordinate order
       LCLOCK(N) = .TRUE.
       WRITE(*,1011) NP
       DO 37 I=1, NP/2
         IBACK = NP - I + 1
         XTMP = X(I,N)
         YTMP = Y(I,N)
         X(I,N) = X(IBACK,N)
         Y(I,N) = Y(IBACK,N)
         X(IBACK,N) = XTMP
         Y(IBACK,N) = YTMP
   37  CONTINUE
      ENDIF
C
 1010 FORMAT(/' Number of input coordinate points:', I4
     &       /' Counterclockwise ordering')
 1011 FORMAT(/' Number of input coordinate points:', I4
     &       /' Clockwise ordering')
C
      RETURN
      END ! CHKBLD


      SUBROUTINE BLDFIX(N)
C------------------------------------------------
C     Splines and sets parameters for element N
C------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      NP = NPBL(N)
C
      CALL SCALC(X(1,N),Y(1,N),S(1,N),NP)
      CALL SEGSPL(X(1,N),XP(1,N),S(1,N),NP)
      CALL SEGSPL(Y(1,N),YP(1,N),S(1,N),NP)
      CALL LEFIND(SLE(N),X(1,N),XP(1,N),Y(1,N),YP(1,N),S(1,N),NP)
C
      XTE(N) = 0.5*(X(1,N)+X(NP,N))
      YTE(N) = 0.5*(Y(1,N)+Y(NP,N))
      XLE(N) = SEVAL(SLE(N),X(1,N),XP(1,N),S(1,N),NP)
      YLE(N) = SEVAL(SLE(N),Y(1,N),YP(1,N),S(1,N),NP)
C
      CHRD(N) = SQRT((XTE(N)-XLE(N))**2+(YTE(N)-YLE(N))**2)
      ANG(N) = -ATAN2((YTE(N)-YLE(N)),(XTE(N)-XLE(N)))
C
C---- set default reference point
ccc      XREF(N) = XTE(N)
ccc      YREF(N) = YTE(N)
      XREF(N) = 0.0
      YREF(N) = 0.0
C
      RETURN
      END ! BLDFIX


      SUBROUTINE GETEL(N)
      INCLUDE 'AIRSET.INC'
C
      IF(NBL.EQ.1) THEN
       N = NBL
      ELSE IF(N.EQ.0) THEN
   1   CALL ASKI('Enter target element number^',N)
       IF (N.GT.NBL) GO TO 1
      ENDIF
C
      RETURN
      END


 
      SUBROUTINE SAVE
C--------------------------------
C     Writes out current airfoil 
C--------------------------------
      INCLUDE 'AIRSET.INC'
      CHARACTER*1 ANS
C
      LU = 3
C
      WRITE(*,*) 'Enter output filename'
      READ (*,1000) FNAME
C
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=30)
      WRITE(*,*)
      WRITE(*,*) '*** Output file exists.  Overwrite?  Y'
      READ (*,1000) ANS
      IF(INDEX('nN',ANS) .NE. 0) RETURN
      REWIND LU
      GO TO 35
C
 30   OPEN(LU,FILE=FNAME,STATUS='UNKNOWN',ERR=200)
 35   WRITE(LU,1000) NAME
      WRITE(LU,1000) MGPARS
C
      DO 100 N = 1, NBL
        IF(LCLOCK(N)) THEN
C----- if original input file was clockwise, write out in reverse order
         IBEG = NPBL(N)
         IEND = 1
         INCR = -1
        ELSE
         IBEG = 1
         IEND = NPBL(N)
         INCR = 1
        ENDIF
C
        DO 5 I=IBEG, IEND, INCR
          WRITE(LU,1100) X(I,N),Y(I,N)
    5   CONTINUE
        IF (N.LT.NBL) WRITE(LU,1110) 
C
 100  CONTINUE
      CLOSE(LU)
      RETURN
C
 200  WRITE(*,*) 'File OPEN error.  Coordinates not saved.'
      RETURN
C
 1000 FORMAT(A)
 1100 FORMAT(1X,2F13.6)
 1110 FORMAT(1X,'999.0    999.0')
      END ! SAVE


 
      SUBROUTINE RDNEW
      INCLUDE 'AIRSET.INC'
      CHARACTER*32 NAME1
C
      IF(NBL.EQ.LX) THEN
       WRITE(*,2010) LX
       RETURN
      ENDIF
C
      WRITE(*,2000) NBL
C
C---- read in, process, and append new elements to configuration
C
 10   CONTINUE
C
        WRITE(*,*) 'Enter new element filename (<cr> if no more)'
        READ (*,1000) FNAME
        CALL STRIP(FNAME,NFNAME)
        IF(NFNAME .EQ. 0) RETURN
C
        LXM = LX - NBL
        L = NBL + 1
        CALL READBL(FNAME,IX,LXM,X(1,L),Y(1,L),
     &              NPBL(L),NBLADD,
     &              NAME1,XINL1,XOUT1,YBOT1,YTOP1)
C
        IF(NBLADD.EQ.0) RETURN
C
C
C------ set new number of elements, limited to array size
        NBL = NBL + NBLADD
        NBL = MIN(NBL,LX)
C
C------ process new element(s)
        DO 15 N = L, NBL
          CALL CHKBLD(N)
          CALL BLDFIX(N)
          CALL CLRHOM(N)
          LHOME(N) = .TRUE.
 15     CONTINUE
C
        WRITE(*,2020)
        CALL EDTBLD(L)
C
        LAIR = .TRUE.
        LGAMU = .FALSE.
        LGLIN = .FALSE.
C
        IF(NBL.GE.LX) THEN
         WRITE(*,2010) LX
         RETURN
        ENDIF
C
C---- go read in new element
      GO TO 10
C
 1000 FORMAT(A)
 1005 FORMAT(/' Enter  Xinl, Xout, Ybot, Ytop :')
 2000 FORMAT(/' Current configuration has', I2, ' elements '
     &       /' Additional elements can be added next ...' )
 2010 FORMAT( ' Number of elements now equals array limit of', I2)
 2020 FORMAT(/' Entering edit menu for added element ...')
      END ! RDNEW


 
      SUBROUTINE DELEL(N)
C--------------------------------------------------------------
C     Deletes element N.
C--------------------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      IF(N.LT.1 .OR. N.GT.NBL) THEN
       WRITE(*,*) 'Element index out of range.  No action taken.'
       RETURN
      ENDIF
C
C---- move down all elements above target element
      DO 20 L=N+1, NBL
        NPBL(L-1) = NPBL(L)
        CHRD(L-1) = CHRD(L)
        ANG(L-1) = ANG(L)
C
        LCLOCK(L-1) = LCLOCK(L)
        LHOME(L-1) = LHOME(L)
C
        SLE(L-1) = SLE(L)
        XLE(L-1) = XLE(L)
        YLE(L-1) = YLE(L)
        XTE(L-1) = XTE(L)
        YTE(L-1) = YTE(L)
C
        XREF(L-1) = XREF(L)
        YREF(L-1) = YREF(L)
C
        ANGSUM(L-1) = ANGSUM(L)
        DXSUM(L-1) = DXSUM(L)
        DYSUM(L-1) = DYSUM(L)
        XFTOT(L-1) = XFTOT(L)
        YFTOT(L-1) = YFTOT(L)
C
        XCENT(L-1) = XCENT(L)
        YCENT(L-1) = YCENT(L)
        DO 205 I=1, NPBL(L)
          X(I,L-1) = X(I,L)
          Y(I,L-1) = Y(I,L)
          S(I,L-1) = S(I,L)
          XB(I,L-1) = XB(I,L)
          YB(I,L-1) = YB(I,L)
          XP(I,L-1) = XP(I,L)
          YP(I,L-1) = YP(I,L)
  205   CONTINUE
   20 CONTINUE
C
      NBL = NBL - 1
C
      LGAMU = .FALSE.
      LGLIN = .FALSE.
      RETURN
      END  ! DELEL



      SUBROUTINE DOUBLE(N)
C-------------------------------------------------
C     Doubles the number of points in element N.
C-------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      IF((2*NPBL(N)-1) .GT. IX) THEN
       WRITE(*,*)
       WRITE(*,*) '*** Array will overflow.  No action taken.  ***'
       RETURN
      ENDIF
C
      NP = NPBL(N)
C
      K = 0
      DO 20 I=1, NP-1
        K = K+1
        W1(K) = X(I,N)
        W2(K) = Y(I,N)
C
        IF(S(I,N) .EQ. S(I+1,N)) GO TO 20
C
        SMID = 0.5*(S(I,N) + S(I+1,N))
        K = K+1
        W1(K) = SEVAL(SMID,X(1,N),XP(1,N),S(1,N),NP)
        W2(K) = SEVAL(SMID,Y(1,N),YP(1,N),S(1,N),NP)
   20 CONTINUE
      K = K+1
      W1(K) = X(NP,N)
      W2(K) = Y(NP,N)
C
      NPBL(N) = K
      DO 22 I=1, NPBL(N)
        X(I,N) = W1(I)
        Y(I,N) = W2(I)
   22 CONTINUE
C
      CALL CHKBLD(N)
      CALL BLDFIX(N)
C
      RETURN
      END ! DOUBLE


      SUBROUTINE HALF(N)
C-------------------------------------------------
C     Halves the number of points in element N.
C-------------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      NP = NPBL(N)
C
      K = 1
      INEXT = 3
      DO 20 I=2, NP-1
C
C------ if corner is found, preserve it.
        IF(S(I,N) .EQ. S(I+1,N)) THEN
          K = K+1
          X(K,N) = X(I,N)
          Y(K,N) = Y(I,N)
          K = K+1
          X(K,N) = X(I+1,N)
          Y(K,N) = Y(I+1,N)
          INEXT = I+3
        ENDIF
C
        IF(I.EQ.INEXT) THEN
          K = K+1
          X(K,N) = X(I,N)
          Y(K,N) = Y(I,N)
          INEXT = I+2
        ENDIF
C
   20 CONTINUE
      K = K+1
      X(K,N) = X(NP,N)
      Y(K,N) = Y(NP,N)
C
C---- set new number of points in element N
      NPBL(N) = K
C
      CALL CHKBLD(N)
      CALL BLDFIX(N)
C
      RETURN
      END ! HALF



      SUBROUTINE XYLOC(LINE)
      INCLUDE 'AIRSET.INC'
      LOGICAL ERROR
      CHARACTER*(*) LINE
C
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SSF = SQRT(SF)
C
      CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
      IF(NINPUT.NE.2 .OR. ERROR) THEN
        CALL ASKR('Enter X^',XX)
        CALL ASKR('Enter Y^',YY)
      ELSE
        XX = AINPUT(1)
        YY = AINPUT(2)
      ENDIF
C
      CALL PLSYMB(XMOD(XX),YMOD(YY),0.01*SSF,3,0.0,0)
      RETURN
      END



      SUBROUTINE GAPS
C-------------------------------------
C     Finds and prints out slot gaps.
C-------------------------------------
      INCLUDE 'AIRSET.INC'
C
      IF(NBL.EQ.1) RETURN
C
      WRITE(*,1100)
C
      DO 100 N1=1, NBL-1
        N2 = N1+1
C
        NP1 = NPBL(N1)
        NP2 = NPBL(N2)
C
        X1 = X(NP1,N1)
        Y1 = Y(NP1,N1)
C
        DMIN = 1.0E9
        IMIN = 1
        DO 10 I=1, NP2
          X2 = X(I,N2)
          Y2 = Y(I,N2)
          DIST = SQRT((X1-X2)**2 + (Y1-Y2)**2)
          IF(DIST .LT. DMIN) THEN
           DMIN = DIST
           IMIN = I
          ENDIF
   10   CONTINUE
C
C------ first guess for minimum-point arc length
        SMIN = S(IMIN,N2)
C
        STOT = ABS(S(NP2,N2) - S(1,N2))
C
C------ Newton loop for minimum-point s location
        DO 20 ITPNT=1, 16
          X2 = SEVAL(SMIN,X(1,N2),XP(1,N2),S(1,N2),NP2) 
          Y2 = SEVAL(SMIN,Y(1,N2),YP(1,N2),S(1,N2),NP2)
          XD = DEVAL(SMIN,X(1,N2),XP(1,N2),S(1,N2),NP2) 
          YD = DEVAL(SMIN,Y(1,N2),YP(1,N2),S(1,N2),NP2)
          XE = D2VAL(SMIN,X(1,N2),XP(1,N2),S(1,N2),NP2) 
          YE = D2VAL(SMIN,Y(1,N2),YP(1,N2),S(1,N2),NP2)
C
C-------- set residual:  dot product of gap vector with tangent
          RES   = (X2-X1)*XD + (Y2-Y1)*YD
C
          IF(ABS(RES) .LT. 0.0001*STOT) GO TO 21

          RES_S = (XD   )*XD + (YD   )*YD
     &          + (X2-X1)*XE + (Y2-Y1)*YE
C
          DSMIN =  -RES / RES_S
C
          RLX = 1.0
          DSLIM = 0.2*ABS(RES)
C
          IF(RLX*DSMIN .GT.  DSLIM) RLX =  DSLIM/DSMIN
          IF(RLX*DSMIN .LT. -DSLIM) RLX = -DSLIM/DSMIN
C
          SMIN = SMIN + RLX*DSMIN
   20   CONTINUE
        WRITE(*,*) 'GAPS: Convergence failed.  dS = ', RES
C
   21   DX = X1 - X2
        DY = Y1 - Y2
        DS = SQRT(DX*DX + DY*DY)
C
        WRITE(*,1200) N1,N2, DX, DY, DS
C
  100 CONTINUE
C
      RETURN
C
 1100 FORMAT(/1X,'elements    gap dx     gap dy     gap ds')
C                '  1-2     -0.01234   -0.02345    0.02345'
 1200 FORMAT(3X,I1,'-',I1,2X, 3F11.5)
      END ! GAPS



      SUBROUTINE LEFIND(SLE,X,XP,Y,YP,S,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N),XP(N),Y(N),YP(N),S(N)
C
C**** Locates leading edge arc length value SLE
C
C---- set trailing edge point coordinates
      XTE = 0.5*(X(1) + X(N))
      YTE = 0.5*(Y(1) + Y(N))
C
C---- get first guess for SLE
      DO 10 I=3, N-2
        DXTE = X(I) - XTE
        DYTE = Y(I) - YTE
        DX = X(I+1) - X(I)
        DY = Y(I+1) - Y(I)
        DOTP = DXTE*DX + DYTE*DY
        IF(DOTP .LT. 0.0) GO TO 11
   10 CONTINUE
      I = N/2
C
   11 SLE = S(I)
C
C---- Newton iteration to get exact SLE value
      DO 20 ITER=1, 50
        XLE  = SEVAL(SLE,X,XP,S,N)
        YLE  = SEVAL(SLE,Y,YP,S,N)
        DXDS = DEVAL(SLE,X,XP,S,N)
        DYDS = DEVAL(SLE,Y,YP,S,N)
        DXDD = D2VAL(SLE,X,XP,S,N)
        DYDD = D2VAL(SLE,Y,YP,S,N)
C
        XCHORD = XLE - XTE
        YCHORD = YLE - YTE
C
C------ drive dot product between chord line and LE tangent to zero
        RES  = XCHORD*DXDS + YCHORD*DYDS
        RESS = DXDS  *DXDS + DYDS  *DYDS
     &       + XCHORD*DXDD + YCHORD*DYDD
C
        IF(RESS .EQ. 0.0) GO TO 21
C
C------ Newton delta for SLE 
        DSLE = -RES/RESS
C
        CHORD = SQRT(XCHORD**2 + YCHORD**2)
        CURV = (DXDS*DYDD - DYDS*DXDD) / SQRT((DXDS**2 + DYDS**2)**3)
C
        DSLIM = 0.01*CHORD
        IF(CURV .NE. 0.0) DSLIM = MIN( DSLIM , 0.1/ABS(CURV) )
C
        DSLE = MAX( DSLE , -DSLIM )
        DSLE = MIN( DSLE ,  DSLIM )
C
        SLE = SLE + DSLE
        IF(ABS(DSLE/(S(N)-S(1))) .LT. 5.0E-5) RETURN
 20   CONTINUE
 21   WRITE(*,*) 'LEFIND:  LE point not found.  Using rough estimate.'
      SLE = S(I)
C
      RETURN
      END ! LEFIND



      SUBROUTINE COORDS(N)
      INCLUDE 'AIRSET.INC'
C----------------------------------------------------
C     Takes distance along chord line, and returns
C     corresponding top & bottom surface locations
C     and surface-normal directions.
C----------------------------------------------------
CCC      REAL XT(IX), YT(IX), XTP(IX), YTP(IX), ST(IX)
C
      NP = NPBL(N)
C
      WRITE(*,1050) N, CHRD(N), ANG(N)/DTOR
 1050 FORMAT(/'  Element',I2,' chord =',F12.6
     &       /'  Chord line angle =',   F10.4,' deg' )
C
      CALL ASKR('Enter chord line angle to be used^',ANGLE)
C
      ANGLE = ANGLE*DTOR
      CA = COS(ANGLE)
      SA = SIN(ANGLE)
C
      DO 100 IPNT=1, 12345
C
        CALL ASKR('Enter distance along chord line (0 to finish)^',XCH)
        IF(XCH .LE. 0.0) RETURN
C
CCC     XCH = XCH*CHRD(N)
C
C------ top surface
        DO 10 I = 1, NP-1
          XBAR = X(I,N) - XLE(N)
          YBAR = Y(I,N) - YLE(N)
          XCT = XBAR*CA - YBAR*SA
          IF(XCT .LE. XCH) GO TO 11
   10   CONTINUE
   11   CONTINUE
C
        SCT = S(I,N)
C
        CALL SCFIND(SCT,XCH,
     &              X(1,N),XP(1,N),Y(1,N),YP(1,N),S(1,N),NP,
     &              XLE(N),YLE(N),CA,SA)
        XCT = SEVAL(SCT,X(1,N),XP(1,N),S(1,N),NP)
        YCT = SEVAL(SCT,Y(1,N),YP(1,N),S(1,N),NP)
C
        ANT = ATAN2( DEVAL(SCT,Y(1,N),YP(1,N),S(1,N),NP),
     &              -DEVAL(SCT,X(1,N),XP(1,N),S(1,N),NP) )
C
C------ bottom surface
        DO 20 I = NP, 2, -1
          XBAR = X(I,N) - XLE(N)
          YBAR = Y(I,N) - YLE(N)
          XCB = XBAR*CA - YBAR*SA
          IF(XCB .LE. XCH) GO TO 21
   20   CONTINUE
   21   CONTINUE
C
        SCB = S(I,N)
C
        CALL SCFIND(SCB,XCH,
     &              X(1,N),XP(1,N),Y(1,N),YP(1,N),S(1,N),NP,
     &              XLE(N),YLE(N),CA,SA)
        XCB = SEVAL(SCB,X(1,N),XP(1,N),S(1,N),NP)
        YCB = SEVAL(SCB,Y(1,N),YP(1,N),S(1,N),NP)
C
        ANB = ATAN2(-DEVAL(SCB,Y(1,N),YP(1,N),S(1,N),NP),
     &               DEVAL(SCB,X(1,N),XP(1,N),S(1,N),NP) ) / DTOR
C
        WRITE(*,1200) XCT, YCT, ANT,
     &                XCB, YCB, ANB
 1200   FORMAT( '    top  x, y, Anorm =', 3F12.6
     &         /'    bot  x, y, Anorm =', 3F12.6)
C
 100  CONTINUE
      RETURN
      END ! COORDS



      SUBROUTINE SCFIND(ST,XCH, X,XP,Y,YP,S,N, XLE,YLE,CA,SA)
      DIMENSION X(N),XP(N),Y(N),YP(N),S(N)
C----------------------------------------------------------------
C     Returns arc-length location ST of a point on contour X,Y,
C     which has the location XCH measured along axis starting
C     at XLE,YLE and having a direction vector CA,SA.
C
C     Typically, the axis would be the chord line, although
C     it can have any direction relative to the airfoil.
C
C     A reasonable first-guess for ST must be passed in.
C----------------------------------------------------------------
C
      DO 15 ITER=1, 10
        XBAR = SEVAL(ST,X,XP,S,N) - XLE
        YBAR = SEVAL(ST,Y,YP,S,N) - YLE
        XB_S = DEVAL(ST,X,XP,S,N)
        YB_S = DEVAL(ST,Y,YP,S,N)
C
        RES = XBAR*CA - YBAR*SA  -  XCH
C
        IF(ABS(RES) .LE. 1.0E-4) RETURN
        R_S = XB_S*CA - YB_S*SA
C
        ST = ST - RES/R_S
   15 CONTINUE
      WRITE(*,*) 'SCFIND:  Convergence failed.  Res = ', RES
      RETURN
      END



      SUBROUTINE OPER
C----------------------------------
C     Panel solution menu routine
C----------------------------------
      INCLUDE 'AIRSET.INC'
      DIMENSION ANGL1(2*LX)
      CHARACTER*4 COMAND
      DATA ADEG / 0.0 /
C
      PMOD(PTMP) = (-PTMP - POFF)*PSF
C
      CALL SETLIM
C
      IF(.NOT.LAIR) THEN
       WRITE(*,*)
       WRITE(*,*) 'No airfoil available'
       RETURN
      ENDIF
C
      IF(.NOT.LGAMU) THEN
C----- set paneling and generate unit solution
       CALL PANSET
       CALL PANSOL(YGROUND)
       LGAMU = .TRUE.
       LGLIN = .FALSE.
      ENDIF
C
C---- list menu
      WRITE(*,1100)
C
C---- plot current case
      IF(LIMAGE) ADEG = 0.0
      GO TO 11
C
 500  CALL ASKC('.OPER^',COMAND)
C
      IF(COMAND.EQ.'    ') THEN
       IF(LPLOT) CALL PLEND
       LPLOT = .FALSE.
       RETURN
      ENDIF
      IF(COMAND.EQ.'?   ') THEN
       WRITE(*,1100)
       GO TO 500
      ENDIF
      IF(COMAND.EQ.'ALFA') GO TO 10
      IF(COMAND.EQ.'ASEQ') GO TO 20
      IF(COMAND.EQ.'CL  ') GO TO 30
      IF(COMAND.EQ.'CSEQ') GO TO 40
      IF(COMAND.EQ.'GROU') GO TO 45
      IF(COMAND.EQ.'MACH') GO TO 50
      IF(COMAND.EQ.'VELS') GO TO 55
      IF(COMAND.EQ.'UEDG') GO TO 57
      IF(COMAND.EQ.'HARD') GO TO 60
      IF(COMAND.EQ.'SIZE') GO TO 70
      IF(COMAND.EQ.'CPMI') GO TO 80
      IF(COMAND.EQ.'FORC') GO TO 90
      IF(COMAND.EQ.'MREF') GO TO 92
      IF(COMAND.EQ.'PPAR') GO TO 95
C
      WRITE(*,1050) COMAND
      GO TO 500
C
C=============================================
C---- specified alpha
   10 IF(LIMAGE) THEN
        WRITE(*,*)
        WRITE(*,*) 'Only alpha = 0 allowed with ground plane present'
        WRITE(*,*) 'Rotate airfoil in POSI instead'
        ADEG = 0.0
      ELSE
        CALL ASKR('Enter angle of attack (deg)^',ADEG)
      ENDIF
C
   11 CALL POFINI(.FALSE.)
      CALL PLTINI
      CALL CPAXES
      CALL AIRFPL(1)
C
      IF(LIMAGE) THEN
        CALL NEWPEN(5)
        YSG = 1.0
        IF(Y(1,1) .GT. YGROUND) YSG = -1.0
        CALL GNDPLT(XMIN,XMAX,YGROUND,XOFAIR,YOFAIR,FACAIR,YSG)
      ENDIF
C
      XLAB = 0.72
      YLAB = PMOD(CPMIN)
      CALL CPLAB(XLAB,YLAB,XL1,XL2,XL3)
C
      ALFA = ADEG*DTOR
      CALL ALSET(ALFA)
      CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.FALSE.)
      CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.FALSE.,1)
      CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
C
      CALL PLFLUSH
      GO TO 500
C
C=============================================
C---- specified alpha sequence
   20 IF(LIMAGE) THEN
        WRITE(*,*) 'Only alpha = 0 allowed with ground plane present'
        GO TO 500
      ENDIF
      CALL ASKR('Enter first alpha value (deg)^',ADEG1)
      CALL ASKR('Enter last  alpha value (deg)^',ADEG2)
      CALL ASKR('Enter alpha increment   (deg)^',DADEG)
C
      CALL POFINI(.FALSE.)
      CALL PLTINI
      CALL CPAXES
      CALL AIRFPL(1)

      XLAB = 0.55
      YLAB = PMOD(CPMIN)
      CALL CPLAB(XLAB,YLAB,XL1,XL2,XL3)
C
      NAL = INT( (ADEG2-ADEG1)/DADEG ) + 1
      DO 205 IAL=1, NAL
        ADEG = ADEG1 + DADEG*FLOAT(IAL-1)
        ALFA = ADEG*DTOR
        CALL ALSET(ALFA)
        CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.FALSE.)
        CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.FALSE.,1)
        CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
 205  CONTINUE
C
      CALL PLFLUSH
      GO TO 500
C
C=============================================
C---- specified CL
   30 IF(LIMAGE) THEN
        WRITE(*,*) 'Only alpha = 0 allowed with ground plane present'
        GO TO 500
      ENDIF
      CALL ASKR('Enter CL^',CLSPEC)
C
      CALL POFINI(.FALSE.)
      CALL PLTINI
      CALL CPAXES
      CALL AIRFPL(1)
C
      XLAB = 0.55
      YLAB = PMOD(CPMIN)
      CALL CPLAB(XLAB,YLAB,XL1,XL2,XL3)
C
      CALL CLSET(CLSPEC,ALFA,MINF)
      ADEG = ALFA/DTOR
      CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.FALSE.)
      CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.FALSE.,1)
      CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
C
      CALL PLFLUSH
      GO TO 500
C
C=============================================
C---- specified CL sequence
   40 IF(LIMAGE) THEN
        WRITE(*,*) 'Only alpha = 0 allowed with ground plane present'
        GO TO 500
      ENDIF
      CALL ASKR('Enter first CL value^',CL1)
      CALL ASKR('Enter last  CL value^',CL2)
      CALL ASKR('Enter CL increment  ^',DCL)
C
      CALL POFINI(.FALSE.)
      CALL PLTINI
      CALL CPAXES
      CALL AIRFPL(1)
C
      XLAB = 0.55
      YLAB = PMOD(CPMIN)
      CALL CPLAB(XLAB,YLAB,XL1,XL2,XL3)
C
      NCL = INT( (CL2-CL1)/DCL ) + 1
      DO 405 ICL=1, NCL
        CLSPEC = CL1 + DCL*FLOAT(ICL-1)
        CALL CLSET(CLSPEC,ALFA,MINF)
        ADEG = ALFA/DTOR
        CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,0.25,0.0,.FALSE.)
        CALL CPPLOT(XOFAIR,FACAIR,POFF,PSF,MINF,.FALSE.,1)
        CALL ALMPLT(YLAB,XL1,XL2,XL3,ADEG,CL,CM)
 405  CONTINUE
C
      CALL PLFLUSH
      GO TO 500
C
C=============================================
C---- new ground-plane location
 45   YGROLD = YGROUND
      CALL ASKR('Enter y location of ground plane (999=none)^',YGROUND)
      LIMAGE = YGROUND .NE. 999.0
      IF(YGROUND.NE.YGROLD) THEN
       CALL PANSOL(YGROUND)
       LGAMU = .TRUE.
       LGLIN = .FALSE.
      ENDIF
C
C---- replot solution
      CALL SETLIM
      IF(LIMAGE) ADEG = 0.0
      GO TO 11
C
C=============================================
C---- set Mach number
 50   CALL ASKR('Enter Mach number^',MINF)
      IF(MINF.EQ.0.0) THEN
       CPSTAR = -999.0
      ELSE
C----- set sonic Pressure coefficient
       GAMMA = 1.4
       GAMM1 = GAMMA - 1.0
       CPSTAR = 2.0 / (GAMMA*MINF**2)
     &        * (( (1.0 + 0.5*GAMM1*MINF**2)
     &            /(1.0 + 0.5*GAMM1        ))**(GAMMA/GAMM1) - 1.0)
       WRITE(*,1300) CPSTAR
      ENDIF
      GO TO 11
C
C=============================================
C---- get velocity components
 55   CALL ASKR('Enter x^',XXX)
      CALL ASKR('Enter y^',YYY)
C
      CALL AVSPAC(XXX,YYY,ANGL1)
      CALL PSIPHI(0,0,XXX,YYY,ANGL1,PSII,PHII,UUU,VVV)
C
      QQQ = SQRT(UUU**2 + VVV**2)
      CPP = 1.0 - (UUU**2 + VVV**2)
      WRITE(*,1800) UUU,VVV,QQQ,CPP
 1800 FORMAT(/' u/Uinf = ', F8.4, '   v/Uinf = ', F8.4
     &       /' q/Uinf = ', F8.4, '   Cp     = ', F8.4 /  )
      GO TO 500
C
C=============================================
 57   CALL UEDUMP
      GO TO 500
C
C=============================================
C---- Hardcopy
 60   IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
C
      GO TO 500
C
C=============================================
C---- Plot size
 70   WRITE(*,*)
      WRITE(*,*) 'Currently plot size = ', SIZE
      CALL ASKR('Enter new plot size^',SIZE)
      IF(LIMAGE) GO TO 11
      GO TO 500
C
C=============================================
C---- Minimum Cp
 80   CALL ASKR('Enter new minimum Cp^',CPMIN)
      CPDEL = -0.5
      IF(CPMIN.LT.-3.9) CPDEL = -1.0
      GO TO 11
C
C=============================================
C---- Element forces
 90   CALL CLCALC(CL,CL_ALF,CM,MINF,CLEL,CDEL,CMEL,XCMOM,YCMOM,.FALSE.)
      WRITE(*,1400) XCMOM,YCMOM,(N,CLEL(N),CDEL(N),CMEL(N),N=1,NBL)
      GO TO 500
C
C=============================================
C---- Moment reference location
 92   WRITE(*,*)
      WRITE(*,*) 'Current reference location  x,y =', XCMOM, YCMOM
      CALL ASKR('Enter new x location^',XCMOM)
      CALL ASKR('Enter new y location^',YCMOM)
      GO TO 90
C
C=============================================
C---- modify element paneling
 95   CALL GETPAN
      IF(.NOT.LGAMU) THEN
       CALL PANSOL(YGROUND)
       LGAMU = .TRUE.
       LGLIN = .FALSE.
      ENDIF
      GO TO 11
C..........................................
C
 1050 FORMAT(1X,A4,' command not recognized.  Type a "?" for list')
 1100 FORMAT(/'   <cr>  Return to TOP LEVEL'
     &      //'   ALFA  Specify alpha'
     &       /'   ASEQ  Specify alpha sequence'
     &       /'   CL    Specify CL'
     &       /'   CSEQ  Specify CL sequence'
     &      //'   MACH  Specify Mach number'
     &       /'   GROU  Specify/eliminate ground plane'
     &      //'   VELS  Calculate velocity at a point'
     &       /'   UEDG  List surface speeds'
     &      //'   HARD  Hardcopy current plot'
     &       /'   SIZE  Change plot size'
     &       /'   CPMI  Change minimum annotation Cp'
     &      //'   FORC  Display forces on individual elements'
     &       /'   MREF  Change moment reference location'
     &       /'   PPAR  Change/show paneling')
 1300 FORMAT(/' Sonic Cp =', F12.2/)
 1400 FORMAT(/'  n       CL         CD         CM (about',2F11.5,' )',
     &         9(/1X,I2,3F11.5) )
      END ! OPER



      SUBROUTINE UEDUMP
      INCLUDE 'AIRSET.INC'
      LOGICAL LFILE
C
C---- set Karman-Tsien parameter TKLAM
      BETA = SQRT(1.0 - MINF**2)
      TKLAM   = MINF**2 / (1.0 + BETA)**2
C
      CALL ASKS('Enter output filename^',FNAME)
      LFILE = FNAME(1:1) .NE. ' '
C
      IF(LFILE) THEN
        OPEN(19,FILE=FNAME,STATUS='UNKNOWN')
        WRITE(19,8100)
      ENDIF
      WRITE(*,8100)
 8100 FORMAT(/'     s        x        y     Ue/Vinf')
C                1.23456  0.23451  0.23451  0.23451 
C
      DO 10 N=1, NBL
        DO 105 I=1, NPAN(N)
          CALL XYUPAN(I,N,XI,YI,SI,UI)
          UC = UI * (1.0-TKLAM) / (1.0 - TKLAM*UI**2)

          IF(LFILE) WRITE(19,8500) SI, XI, YI, UI
          WRITE(*,8500) SI, XI, YI, UI
 105    CONTINUE
 10   CONTINUE
C
      IF(LFILE) CLOSE(19)
      RETURN
C
 8500 FORMAT(1X,4F9.5,3F10.6)
      END ! UEDUMP


      SUBROUTINE PANSET
C------------------------------------------
C     Sets up paneling parameters and 
C     calls panel initialization routines.
C------------------------------------------
      INCLUDE 'AIRSET.INC'
C
      CHRDMX = 0.0
      DO 3 N=1, NBL
        CHRDMX = MAX( CHRDMX , CHRD(N) )
    3 CONTINUE
C
C---- set paneling parameters for panel solution
      DO 5 N=1, NBL
        NPAN(N) = NPAN1 * (CHRD(N)/CHRDMX)**FNBLD1
        CVPAR(N) = CVPAR1
        CTERAT(N) = CTERAT1
    5 CONTINUE
C
C---- set paneling
      CALL PANGEN(IX,X,XP,Y,YP,S,NPBL,NBL,NPAN,CVPAR,CTERAT)
C
      RETURN
      END ! PANSET



      SUBROUTINE GETPAN
      INCLUDE 'AIRSET.INC'
      LOGICAL LCHANGE, ERROR
      CHARACTER*4 VAR
      CHARACTER*80 LINE
C
      CALL SETLIM
      CALL GOFINI(.FALSE.)
C
 5    CALL PLTINI
      CALL PANPLT(SF,XOFF,YOFF)
      CALL PLFLUSH
C
      LCHANGE = .FALSE.
C
   10 WRITE(*,1000) NPAN1, FNBLD1, CVPAR1, CTERAT1
 1000 FORMAT(
     & /'     Present paneling parameters:'
     & /'  N',I8  ,'   Number of panel nodes (for max chord)        E'
     & /'  E',F8.3,'   Exponent for number of panel nodes: n ~ chord '
     & /'  P',F8.3,'   Panel bunching parameter'
     & /'  T',F8.3,'   TE/LE panel density ratio')
C
   12 CALL ASKS('Change what ? (<cr> if nothing else)^',LINE)
      VAR = LINE(1:1) // '   '
      LINE( 1:79) = LINE(2:80)
      LINE(80:80) = ' '
C
      IF     (VAR.EQ.'    ') THEN
C
        IF(LCHANGE) THEN
          CALL PANSET
          LGAMU = .FALSE.
          LGLIN = .FALSE.
          GO TO 5
        ENDIF
        RETURN
C
      ELSE IF(VAR.EQ.'N   ' .OR. VAR.EQ.'n   ') THEN
C
        CALL GETINT(LINE,IINPUT,NINPUT,ERROR)
        IF(NINPUT.LT.1 .OR. ERROR) THEN
          CALL ASKI('Enter number of panel nodes^',NPAN1)
        ELSE
          NPAN1 = IINPUT(1)
        ENDIF
        LCHANGE = .TRUE.
C
      ELSE IF(VAR.EQ.'E   ' .OR. VAR.EQ.'e   ') THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LT.1 .OR. ERROR) THEN
          CALL ASKR('Enter exponent for number of panel nodes^',FNBLD1)
        ELSE
          FNBLD1 = AINPUT(1)
        ENDIF
        LCHANGE = .TRUE.
C
      ELSE IF(VAR.EQ.'P   ' .OR. VAR.EQ.'p   ') THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LT.1 .OR. ERROR) THEN
          CALL ASKR('Enter panel bunching parameter (0 to ~1)^',CVPAR1)
        ELSE
          CVPAR1 = AINPUT(1)
        ENDIF
        LCHANGE = .TRUE.
C
      ELSE IF(VAR.EQ.'T   ' .OR. VAR.EQ.'t   ') THEN
C
        CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
        IF(NINPUT.LT.1 .OR. ERROR) THEN
          CALL ASKR('Enter TE/LE panel density ratio^',CTERAT1)
        ELSE
          CTERAT1 = AINPUT(1)
        ENDIF
        LCHANGE = .TRUE.
C
      ELSE
C
        WRITE(*,*)
        WRITE(*,*) '***  Input not recognized  ***'
        GO TO 10
C
      ENDIF
C
      GO TO 12
C
      END ! GETPAN




