C---------------------------------------------------
C     BL routine indexing pointers.
C     See BLVAR (blvar.f) header for description
C---------------------------------------------------
C
C---- pointers for referencing primary variables
C- (first 4 variables must be primary flow variables for marching problem)
      PARAMETER (
     &    ICQ = 1,      ! Cq^1/2     r.m.s. turbulent velocity scale
     &    ITO = 2,      ! Theta_o    outer-layer momentum thickness
     &    IDO = 3,      ! Delta*_o   outer-layer displacement thickness
     &    IUE = 4,      ! u*         EIF velocity scale
     &    IUW = 5,      ! u_w        wall velocity (or at wake centerline)
     &    IRH = 6,      ! rho*       EIF density scale
     &    ICV = 7,      ! kappa      displacement surface curvature, + concave 
     &    IXI = 8,      ! xi         BL coordinate (in m'-theta space)
     &    IRR = 9,      ! r          radius
     &    IBB = 10,     ! b          streamtube thickness
     &    IAM = 11,     ! n          ln(amplification ratio)
     &    IMW = 12 )    ! m_wall     wall suction mass flow rate
      PARAMETER (ITOT=12)
C
C---- pointers for referencing primary parameters
      PARAMETER (
     &    LSH = 1,      ! Htot      total enthalpy  (or rothalpy)
     &    LSR = 2,      ! Rtot      total density
     &    LRE = 3,      ! REtot     Reynolds number at stagnation
     &    LRO = 4 )     ! rot       rotation rate
      PARAMETER (LTOT=4)
C
C---- pointers for referencing secondary variables and Jacobian arrays
      PARAMETER (
     &    JTH = 1,      ! Theta        momentum thickness
     &    JDS = 2,      ! Delta*       displacement thickness
     &    JRH = 3,      ! rho*         EIF density scale
     &    JMS = 4,      ! M*^2         EIF Mach^2
     &    JHK = 5,      ! Hk           kinematic shape parameter
     &    JHS = 6,      ! H*           KE shape parameter  Theta*/Theta
     &    JHC = 7,      ! H**          density-flux shape parameter
     &    JHD = 8,      ! Hr           density shape parameter
     &    JUS = 9,      ! Us           apparent slip velocity
     &    JCF = 10,     ! Cf           skin friction coefficient
     &    JDI = 11,     ! 2CD/H*       dissipation coefficient x 2/H*
     &    JCM = 12,     ! Cm           wall suction coefficient
     &    JUQ = 13,     ! (ln Ue)_x    equilibrium pressure gradient
     &    JCQ = 14,     ! CtauEQ^1/2   equilibrium shear stress coefficient
     &    JDE = 15,     ! Delta        BL thickness
     &    JRT = 16 )    ! Rtheta       momentum-thickness Reynolds number
      PARAMETER (JTOT=16)

