
       SUBROUTINE BLDIF(IDIF,BULE,ROT, AMCRIT,
     &                  VAR1,VAR2, VJ1,VJ2, PJ1,PJ2,
     &                  BL1, BL2, BLP, BLRES)
C------------------------------------------------------------
C     Sets up BL equation residuals and Jacobians
C     for a two-point differencing interval  1 - 2.
C
C   Input:  IDIF     0  similarity station
C                    1  laminar interval
C                    2  turbulent interval
C                    3  wake interval
C           BULE        similarity parameter x/Ue dUe/dx (for IDIF=0 case)
C           ROT         rotation rate
C           AMCRIT      critical amplification ratio
C
C           VAR1,2(.)   primary variables
C           VJ1,2(..)   secondary variables and derivatives
C           PJ1,2(..)   secondary variable derivatives wrt parameters
C
C  Output: BL1(1:3,1:8)  Jacobian for variables at "1"
C          BL2(1:3,1:8)  Jacobian for variables at "2"
C          BLP(1:3,1:4)  Jacobian for parameters
C          BLRES(.)      Residual vector for BL equations ...
C               (1)         lag equation (amplification eqn if IDIF=2)
C               (2)         momentum equation
C               (3)         shape parameter equation
C
C     This routine knows nothing about a transition interval,
C     which is assembled by BLSYS using lam/turb sub-intervals.
C------------------------------------------------------------
      IMPLICIT REAL (A-H,M,O-Z)
      INCLUDE 'BLPAR.INC'
      INCLUDE 'INDEX.INC'
      DIMENSION VAR1(ITOT), VAR2(ITOT), 
     &          VJ1(0:ITOT,JTOT), VJ2(0:ITOT,JTOT),
     &          PJ1(  LTOT,JTOT), PJ2(  LTOT,JTOT)
      DIMENSION BL1(3,ITOT), BL2(3,ITOT), BLP(3,LTOT), BLRES(3)
      LOGICAL LAGS
C
C---- unpack primary variables
      C1  = VAR1(ICT)
      T1  = VAR1(ITH)
      D1  = VAR1(IDS)
      U1  = VAR1(IUE)
      X1  = VAR1(IXI)
      RR1 = VAR1(IRR)
      BB1 = VAR1(IBB)
      AM1 = VAR1(IAM)
C
      C2  = VAR2(ICT)
      T2  = VAR2(ITH)
      D2  = VAR2(IDS)
      U2  = VAR2(IUE)
      X2  = VAR2(IXI)
      RR2 = VAR2(IRR)
      BB2 = VAR2(IBB)
      AM2 = VAR2(IAM)
C
C---- unpack secondary variables
      R1  = VJ1(0,JRH)
      M1  = VJ1(0,JMS)
      HK1 = VJ1(0,JHK)
      HS1 = VJ1(0,JHS)
      HC1 = VJ1(0,JHC)
      HD1 = VJ1(0,JHD)
      CF1 = VJ1(0,JCF)
      DI1 = VJ1(0,JDI)
      CM1 = VJ1(0,JCM)
      UQ1 = VJ1(0,JUQ)
      CQ1 = VJ1(0,JCQ)
      DE1 = VJ1(0,JDE)
      RT1 = VJ1(0,JRT)
C
      R2  = VJ2(0,JRH)
      M2  = VJ2(0,JMS)
      HK2 = VJ2(0,JHK)
      HS2 = VJ2(0,JHS)
      HC2 = VJ2(0,JHC)
      HD2 = VJ2(0,JHD)
      CF2 = VJ2(0,JCF)
      DI2 = VJ2(0,JDI)
      CM2 = VJ2(0,JCM)
      UQ2 = VJ2(0,JUQ)
      CQ2 = VJ2(0,JCQ)
      DE2 = VJ2(0,JDE)
      RT2 = VJ2(0,JRT)
C

      H1    =  D1/T1
      H1_T1 = -H1/T1
      H1_D1 = 1.0/T1
C
      H2    =  D2/T2
      H2_T2 = -H2/T2
      H2_D2 = 1.0/T2
C
      IF(IDIF.EQ.0) THEN
C----- similarity logarithmic differences  (prescribed)
       XLOG = 1.0
       ULOG = BULE
       TLOG = 0.5 - 0.5*BULE
       RLOG = 0.
       HLOG = 0.
       RRLOG = 0.
       BBLOG = 0.
       DDLOG = 0.
      ELSE
C----- usual logarithmic differences
       XLOG = LOG(X2/X1)
       ULOG = LOG(U2/U1)
       TLOG = LOG(T2/T1)
       RLOG = LOG(R2/R1)
       HLOG = LOG(HS2/HS1)
       RRLOG = LOG(RR2/RR1)
       BBLOG = LOG(BB2/BB1)
       DDLOG = 1.0
      ENDIF
C
      DO 55 K=1, 3
        BLRES(K) = 0.
        DO 551 L=1, ITOT
          BL1(K,L) = 0.
          BL2(K,L) = 0.
 551    CONTINUE
        DO 552 L=1, LTOT
          BLP(K,L) = 0.
 552    CONTINUE
 55   CONTINUE
C
C==========================================================
C---- set triggering constant for local upwinding
      HDCON = 5.0/HK2**2
      HD_HK1 =  0.0
      HD_HK2 = -2.0*HDCON/HK2
C
C---- less upwinding in the wake
      IF(IDIF.EQ.3) THEN
       HDCON = 1.0/HK2**2
       HD_HK1 =  0.0
       HD_HK2 = -2.0*HDCON/HK2
      ENDIF
C
C---- local upwinding is based on local change in   log (Hk-1)
      ARG = ABS((HK2-1.0)/(HK1-1.0))
      HL = LOG(ARG)
      HL_HK1 = -1.0/(HK1-1.0)
      HL_HK2 =  1.0/(HK2-1.0)
C
C---- set local upwinding parameter UPW and linearize it
C
C       UPW = 0.5   Trapezoidal
C       UPW = 1.0   Backward Euler
C
      HLSQ = MIN( HL**2 , 15.0E0 )
      EXH = EXP(-HLSQ*HDCON)
      UPW = 1.0 - 0.5*EXH
      UPW_HL =     EXH*HL  *HDCON
      UPW_HD = 0.5*EXH*HLSQ
C
      UPW_HK1 = UPW_HL*HL_HK1 + UPW_HD*HD_HK1
      UPW_HK2 = UPW_HL*HL_HK2 + UPW_HD*HD_HK2
C
C==========================================================
C---- set up amplification or shear lag equation
C
      IF(IDIF.EQ.0) THEN
C
C***** LE point...  set zero amplification factor
       RES1  = AM2
       Z_AM2 = 1.0
C
       BLRES(1) = RES1
       BL2(1,IAM) = Z_AM2
C
      ELSE IF(IDIF.EQ.1) THEN
C
C***** laminar part...  set amplification equation
C
C----- amplification taken over entire X1..X2 interval
       XT = X2
C
       CALL AXSET(HK1,   T1,   RT1,   AM1,   X1,
     &            HK2,   T2,   RT2,   AM2,   X2,    XT, AMCRIT,
     &     AX, AX_HK1,AX_T1,AX_RT1,AX_AM1,AX_X1,
     &         AX_HK2,AX_T2,AX_RT2,AX_AM2,AX_X2, AX_XT, AX_AMC,
     &     LAGS )
C
C----- Note:  AX_X1, AX_X2, AX_XT = 0 ,  since XT = X2
C
C
       RRA = 0.5*(RR1 + RR2)
C
       DS     = (X2 - X1)*RRA
       DS_X1  =     -     RRA
       DS_X2  =           RRA
       DS_RRA =  X2 - X1
C
       RES1 = AM2 - AM1 - AX*DS
       Z_AX = -DS
C
       Z_AM1 = Z_AX*AX_AM1 - 1.0
       Z_AM2 = Z_AX*AX_AM2 + 1.0
       Z_HK1 = Z_AX*AX_HK1
       Z_HK2 = Z_AX*AX_HK2
       Z_T1  = Z_AX*AX_T1
       Z_T2  = Z_AX*AX_T2
       Z_RT1 = Z_AX*AX_RT1
       Z_RT2 = Z_AX*AX_RT2
       Z_X1  =             - AX*DS_X1
       Z_X2  =             - AX*DS_X2
       Z_RR1 =             - AX*DS_RRA*0.5
       Z_RR2 =             - AX*DS_RRA*0.5
C
       BLRES(1) = RES1
       DO 11 L=1, ITOT
         BL1(1,L) = Z_HK1*VJ1(L,JHK)
     &            + Z_RT1*VJ1(L,JRT)
         BL2(1,L) = Z_HK2*VJ2(L,JHK)
     &            + Z_RT2*VJ2(L,JRT)
 11    CONTINUE
       DO 12 L=1, LTOT
         BLP(1,L) = Z_HK1*PJ1(L,JHK)
     &            + Z_RT1*PJ1(L,JRT)
     &            + Z_HK2*PJ2(L,JHK)
     &            + Z_RT2*PJ2(L,JRT)
 12    CONTINUE
       BL1(1,ITH) = BL1(1,ITH) + Z_T1
       BL1(1,IXI) = BL1(1,IXI) + Z_X1
       BL1(1,IRR) = BL1(1,IRR) + Z_RR1
       BL1(1,IAM) = BL1(1,IAM) + Z_AM1
       BL2(1,ITH) = BL2(1,ITH) + Z_T2
       BL2(1,IXI) = BL2(1,IXI) + Z_X2
       BL2(1,IRR) = BL2(1,IRR) + Z_RR2
       BL2(1,IAM) = BL2(1,IAM) + Z_AM2
C
      ELSE
C
C***** turbulent part -->  set shear lag equation
C
       CQA = (1.0-UPW)*CQ1 + UPW*CQ2
       UQA = (1.0-UPW)*UQ1 + UPW*UQ2
       CA  = (1.0-UPW)*C1  + UPW*C2
C
       RRA = 0.5*(RR1 + RR2)
       DEA = 0.5*(DE1 + DE2)
       CLOG = LOG(C2/C1)
C
       DS     = (X2 - X1)*RRA
       DS_X1  =     -     RRA
       DS_X2  =           RRA
       DS_RRA =  X2 - X1
C
       RES1  = SCC*(CQA - CA)*DS  +  2.0*DEA*(UQA*DS - ULOG - CLOG)
C
       Z_CQA = SCC           *DS
       Z_CA  =-SCC           *DS
       Z_DS  = SCC*(CQA - CA)     +  2.0*DEA* UQA
       Z_DEA =                       2.0    *(UQA*DS - ULOG - CLOG)
       Z_UQA =                       2.0*DEA     *DS
       Z_CL  =                     - 2.0*DEA
       Z_UL  =                     - 2.0*DEA          *DDLOG
       Z_RRA = Z_DS*DS_RRA
C
       Z_UPW = Z_CQA*(CQ2-CQ1) + Z_UQA*(UQ2-UQ1) + Z_CA*(C2-C1)
C
       Z_CQ1 = Z_CQA*(1.0-UPW)
       Z_CQ2 = Z_CQA*     UPW
       Z_UQ1 = Z_UQA*(1.0-UPW)
       Z_UQ2 = Z_UQA*     UPW
       Z_C1  = Z_CA *(1.0-UPW) - Z_CL/C1
       Z_C2  = Z_CA *     UPW  + Z_CL/C2
       Z_U1  =                 - Z_UL/U1
       Z_U2  =                   Z_UL/U2
       Z_RR1 = Z_RRA*0.5
       Z_RR2 = Z_RRA*0.5
       Z_DE1 = Z_DEA*0.5
       Z_DE2 = Z_DEA*0.5
       Z_X1  = Z_DS*DS_X1
       Z_X2  = Z_DS*DS_X2
       Z_HK1 = Z_UPW*UPW_HK1
       Z_HK2 = Z_UPW*UPW_HK2
C
       BLRES(1) = RES1
       DO 13 L=1, ITOT
         BL1(1,L) = Z_CQ1*VJ1(L,JCQ)
     &            + Z_UQ1*VJ1(L,JUQ)
     &            + Z_DE1*VJ1(L,JDE)
     &            + Z_HK1*VJ1(L,JHK)
         BL2(1,L) = Z_CQ2*VJ2(L,JCQ)
     &            + Z_UQ2*VJ2(L,JUQ)
     &            + Z_DE2*VJ2(L,JDE)
     &            + Z_HK2*VJ2(L,JHK)
 13    CONTINUE
       DO 14 L=1, LTOT
         BLP(1,L) = Z_CQ1*PJ1(L,JCQ)
     &            + Z_UQ1*PJ1(L,JUQ)
     &            + Z_DE1*PJ1(L,JDE)
     &            + Z_HK1*PJ1(L,JHK)
     &            + Z_CQ2*PJ2(L,JCQ)
     &            + Z_UQ2*PJ2(L,JUQ)
     &            + Z_DE2*PJ2(L,JDE)
     &            + Z_HK2*PJ2(L,JHK)
 14    CONTINUE
       BL1(1,ICT) = BL1(1,ICT) + Z_C1
       BL1(1,IUE) = BL1(1,IUE) + Z_U1
       BL1(1,IXI) = BL1(1,IXI) + Z_X1
       BL1(1,IRR) = BL1(1,IRR) + Z_RR1
       BL2(1,ICT) = BL2(1,ICT) + Z_C2
       BL2(1,IUE) = BL2(1,IUE) + Z_U2
       BL2(1,IXI) = BL2(1,IXI) + Z_X2
       BL2(1,IRR) = BL2(1,IRR) + Z_RR2
C
      ENDIF
C
C===================================================
C---- Set up x-momentum equation
C
      UA = 0.5*(U1 + U2)
      HA = 0.5*(H1 + H2)
      MA = 0.5*(M1 + M2)
      HDA = 0.5*(HD1 + HD2)
      RRA = 0.5*(RR1 + RR2)
C
C---- set skin friction term
      CFX = 0.5*((CF1 + 2.*CM1)*X1*RR1/T1 + (CF2 + 2.*CM2)*X2*RR2/T2)
C
      CFX_X1  = 0.5*(CF1 + 2.*CM1)   *RR1/T1
      CFX_X2  = 0.5*(CF2 + 2.*CM2)   *RR2/T2
      CFX_T1  = -.5*(CF1 + 2.*CM1)*X1*RR1/T1**2
      CFX_T2  = -.5*(CF2 + 2.*CM2)*X2*RR2/T2**2
      CFX_CF1 = 0.5               *X1*RR1/T1
      CFX_CF2 = 0.5               *X2*RR2/T2
      CFX_CM1 =                    X1*RR1/T1
      CFX_CM2 =                    X2*RR2/T2
      CFX_RR1 = 0.5*(CF1 + 2.*CM1)*X1    /T1
      CFX_RR2 = 0.5*(CF2 + 2.*CM2)*X2    /T2
C
C---- equation residual
      RES2  = TLOG + RLOG + ULOG*(HA + 2.0) - XLOG*0.5*CFX
     &      + BBLOG
     &      + (MA-HDA)*RRLOG * ROT**2 * RRA**2 / UA**2
C
      Z_CFX = -XLOG*0.5
      Z_HA  =  ULOG
      Z_XL  =-DDLOG * 0.5*CFX
      Z_UL  = DDLOG * (HA + 2.0)
      Z_TL  = DDLOG
      Z_RL  = DDLOG
      Z_BBL = DDLOG
      Z_RRL = (MA-HDA)*DDLOG * ROT**2 * RRA**2 / UA**2
      Z_MA  =          RRLOG * ROT**2 * RRA**2 / UA**2
      Z_HDA =    -     RRLOG * ROT**2 * RRA**2 / UA**2
      Z_UA  = (MA-HDA)*RRLOG * ROT**2 * RRA**2 / UA**3 * (-2.0)
      Z_RRA = (MA-HDA)*RRLOG * ROT**2 * RRA    / UA**2 * 2.0
      Z_ROT = (MA-HDA)*RRLOG * ROT    * RRA**2 / UA**2 * 2.0
C
C
      Z_CF1 =                       Z_CFX*CFX_CF1
      Z_CF2 =                       Z_CFX*CFX_CF2
      Z_CM1 =                       Z_CFX*CFX_CM1
      Z_CM2 =                       Z_CFX*CFX_CM2
C
      Z_T1  =           - Z_TL/T1 + Z_CFX*CFX_T1
      Z_T2  =             Z_TL/T2 + Z_CFX*CFX_T2
      Z_X1  =           - Z_XL/X1 + Z_CFX*CFX_X1
      Z_X2  =             Z_XL/X2 + Z_CFX*CFX_X2
      Z_U1  = Z_UA *0.5 - Z_UL/U1
      Z_U2  = Z_UA *0.5 + Z_UL/U2
      Z_M1  = Z_MA *0.5               
      Z_M2  = Z_MA *0.5               
      Z_HD1 = Z_HDA*0.5              
      Z_HD2 = Z_HDA*0.5              
      Z_R1  =           - Z_RL/R1
      Z_R2  =             Z_RL/R2
      Z_BB1 =           - Z_BBL/BB1
      Z_BB2 =             Z_BBL/BB2
      Z_RR1 = Z_RRA*0.5 - Z_RRL/RR1 + Z_CFX*CFX_RR1
      Z_RR2 = Z_RRA*0.5 + Z_RRL/RR2 + Z_CFX*CFX_RR2
C
C
      Z_T1  = Z_HA*0.5*H1_T1 + Z_T1
      Z_T2  = Z_HA*0.5*H2_T2 + Z_T2
      Z_D1  = Z_HA*0.5*H1_D1
      Z_D2  = Z_HA*0.5*H2_D2
C
C
      BLRES(2) = RES2
      DO 21 L=1, ITOT
        BL1(2,L) = Z_CF1*VJ1(L,JCF)
     &           + Z_CM1*VJ1(L,JCM)
     &           + Z_HD1*VJ1(L,JHD)
     &           + Z_R1 *VJ1(L,JRH)
     &           + Z_M1 *VJ1(L,JMS)
        BL2(2,L) = Z_CF2*VJ2(L,JCF)
     &           + Z_CM2*VJ2(L,JCM)
     &           + Z_HD2*VJ2(L,JHD)
     &           + Z_R2 *VJ2(L,JRH)
     &           + Z_M2 *VJ2(L,JMS)
 21   CONTINUE
      DO 22 L=1, LTOT
        BLP(2,L) = Z_CF1*PJ1(L,JCF)
     &           + Z_CM1*PJ1(L,JCM)
     &           + Z_HD1*PJ1(L,JHD)
     &           + Z_R1 *PJ1(L,JRH)
     &           + Z_M1 *PJ1(L,JMS)
     &           + Z_CF2*PJ2(L,JCF)
     &           + Z_CM2*PJ2(L,JCM)
     &           + Z_HD2*PJ2(L,JHD)
     &           + Z_R2 *PJ2(L,JRH)
     &           + Z_M2 *PJ2(L,JMS)
 22   CONTINUE
      BL1(2,ITH) = BL1(2,ITH) + Z_T1
      BL1(2,IDS) = BL1(2,IDS) + Z_D1
      BL1(2,IUE) = BL1(2,IUE) + Z_U1
      BL1(2,IXI) = BL1(2,IXI) + Z_X1
      BL1(2,IRR) = BL1(2,IRR) + Z_RR1
      BL1(2,IBB) = BL1(2,IBB) + Z_BB1
      BL2(2,ITH) = BL2(2,ITH) + Z_T2
      BL2(2,IDS) = BL2(2,IDS) + Z_D2
      BL2(2,IUE) = BL2(2,IUE) + Z_U2
      BL2(2,IXI) = BL2(2,IXI) + Z_X2
      BL2(2,IRR) = BL2(2,IRR) + Z_RR2
      BL2(2,IBB) = BL2(2,IBB) + Z_BB2
      BLP(2,LRO) = BLP(2,LRO) + Z_ROT
C
C
C==============================================
C---- Set up shape parameter equation
C
      XRT1 = X1*RR1/T1
      XRT2 = X2*RR2/T2
C
      HA  = 0.5*(H1  + H2 )
      HSA = 0.5*(HS1 + HS2)
      HCA = 0.5*(HC1 + HC2)
C
      UA  = 0.5*(U1  + U2 )
      HDA = 0.5*(HD1 + HD2)
      RRA = 0.5*(RR1 + RR2)
C
C
C------------------------------
      RTA = 0.5*(RT1 + RT2)
C
      IF(IDIF.EQ.2 .AND. (ULOG .GT. 0.0)) THEN
C----- inner dissipation dp/dx correction
       DDIX   = -ULOG*75.0/RTA
       DD_UL  =      -75.0/RTA
       DD_RTA = -DDIX/RTA
      ELSE
       DDIX   = 0.0
       DD_UL  = 0.0
       DD_RTA = 0.0
      ENDIF
C
C
      DIX = (1.0-UPW)*(DI1 + CM1/HS1)*XRT1 + UPW*(DI2 + CM2/HS2)*XRT2
      CFX = (1.0-UPW)*(CF1 + 2.*CM1 )*XRT1 + UPW*(CF2 + 2.*CM2 )*XRT2
C
      DIX_UPW = (DI2 + CM2/HS2)*XRT2 - (DI1 + CM1/HS1)*XRT1
      CFX_UPW = (CF2 + 2.*CM2 )*XRT2 - (CF1 + 2.*CM1 )*XRT1
C
      DIX_X1  =  (1.0-UPW)*(DI1 + CM1/HS1)   *RR1/T1
      DIX_X2  =       UPW *(DI2 + CM2/HS2)   *RR2/T2
      DIX_T1  = -(1.0-UPW)*(DI1 + CM1/HS1)*X1*RR1/T1**2
      DIX_T2  = -     UPW *(DI2 + CM2/HS2)*X2*RR2/T2**2
      DIX_DI1 =  (1.0-UPW)                *X1*RR1/T1
      DIX_DI2 =       UPW                 *X2*RR2/T2
      DIX_RR1 =  (1.0-UPW)*(DI1 + CM1/HS1)*X1    /T1
      DIX_RR2 =       UPW *(DI2 + CM2/HS2)*X2    /T2
      DIX_CM1 =  (1.0-UPW)    *XRT1/HS1
      DIX_CM2 =       UPW     *XRT2/HS2
      DIX_HS1 = -(1.0-UPW)*CM1*XRT1/HS1**2
      DIX_HS2 = -     UPW *CM2*XRT2/HS2**2
C
      CFX_X1  =  (1.0-UPW)*(CF1 + 2.*CM1)   *RR1/T1
      CFX_X2  =       UPW *(CF2 + 2.*CM2)   *RR2/T2
      CFX_T1  = -(1.0-UPW)*(CF1 + 2.*CM1)*X1*RR1/T1**2
      CFX_T2  = -     UPW *(CF2 + 2.*CM2)*X2*RR2/T2**2
      CFX_CF1 =  (1.0-UPW)               *X1*RR1/T1
      CFX_CF2 =       UPW                *X2*RR2/T2
      CFX_RR1 =  (1.0-UPW)*(CF1 + 2.*CM1)*X1    /T1
      CFX_RR2 =       UPW *(CF2 + 2.*CM2)*X2    /T2
      CFX_CM1 =  (1.0-UPW)*       2.     *X1*RR1/T1
      CFX_CM2 =       UPW *       2.     *X2*RR2/T2
C
C---- equation residual
      RES3  = HLOG
     &      + ULOG*(2.0*HCA/HSA + 1.0 - HA)
     &      + XLOG*(0.5*CFX-DIX) - DDIX
     &      + RRLOG*(HDA - 2.0*HCA/HSA) * ROT**2 * RRA**2 / UA**2
C
      Z_CFX =  XLOG*0.5
      Z_DIX = -XLOG
      Z_HA  = -ULOG
      Z_RTA =                                        - DD_RTA
      Z_XL  = DDLOG * (0.5*CFX-DIX)
      Z_UL  = DDLOG * (2.0*HCA/HSA + 1.0 - HA) - DD_UL
      Z_HL  = DDLOG
      Z_RRL = DDLOG*(HDA-2.0*HCA/HSA)         * ROT**2 * RRA**2 / UA**2
C
      Z_HSA = -2.0*HCA/HSA**2 * (ULOG - RRLOG * ROT**2 * RRA**2 / UA**2)
      Z_HCA =  2.0    /HSA    * (ULOG - RRLOG * ROT**2 * RRA**2 / UA**2)
      Z_HDA =                           RRLOG * ROT**2 * RRA**2 / UA**2
      Z_UA  =  -2.0*(HDA-2.0*HCA/HSA) * RRLOG * ROT**2 * RRA**2 / UA**3
      Z_RRA =   2.0*(HDA-2.0*HCA/HSA) * RRLOG * ROT**2 * RRA    / UA**2
      Z_ROT =   2.0*(HDA-2.0*HCA/HSA) * RRLOG * ROT    * RRA**2 / UA**2
C
      Z_UPW = Z_CFX*CFX_UPW + Z_DIX*DIX_UPW
C
C
      Z_HK1 = Z_UPW*UPW_HK1
      Z_HK2 = Z_UPW*UPW_HK2
      Z_HS1 = Z_HSA*0.5 - Z_HL/HS1 + Z_DIX*DIX_HS1
      Z_HS2 = Z_HSA*0.5 + Z_HL/HS2 + Z_DIX*DIX_HS2
      Z_HC1 = Z_HCA*0.5
      Z_HC2 = Z_HCA*0.5
      Z_HD1 = Z_HDA*0.5
      Z_HD2 = Z_HDA*0.5
      Z_RT1 = Z_RTA*0.5
      Z_RT2 = Z_RTA*0.5
      Z_RR1 = Z_RRA*0.5 - Z_RRL/RR1 + Z_CFX*CFX_RR1 + Z_DIX*DIX_RR1
      Z_RR2 = Z_RRA*0.5 + Z_RRL/RR2 + Z_CFX*CFX_RR2 + Z_DIX*DIX_RR2
C
      Z_CF1 =                         Z_CFX*CFX_CF1
      Z_CF2 =                         Z_CFX*CFX_CF2
      Z_DI1 =                                         Z_DIX*DIX_DI1
      Z_DI2 =                                         Z_DIX*DIX_DI2
      Z_CM1 =                         Z_CFX*CFX_CM1 + Z_DIX*DIX_CM1
      Z_CM2 =                         Z_CFX*CFX_CM2 + Z_DIX*DIX_CM2
C
      Z_T1  =                         Z_CFX*CFX_T1  + Z_DIX*DIX_T1
      Z_T2  =                         Z_CFX*CFX_T2  + Z_DIX*DIX_T2
      Z_X1  =           - Z_XL/X1   + Z_CFX*CFX_X1  + Z_DIX*DIX_X1
      Z_X2  =             Z_XL/X2   + Z_CFX*CFX_X2  + Z_DIX*DIX_X2
      Z_U1  = Z_UA*0.5  - Z_UL/U1
      Z_U2  = Z_UA*0.5  + Z_UL/U2
C
      Z_T1  = Z_HA*0.5*H1_T1 + Z_T1
      Z_T2  = Z_HA*0.5*H2_T2 + Z_T2
      Z_D1  = Z_HA*0.5*H1_D1
      Z_D2  = Z_HA*0.5*H2_D2
C
C
      BLRES(3) = RES3
      DO 31 L=1, ITOT
        BL1(3,L) = Z_CF1*VJ1(L,JCF)
     &           + Z_CM1*VJ1(L,JCM)
     &           + Z_DI1*VJ1(L,JDI)
     &           + Z_RT1*VJ1(L,JRT)
     &           + Z_HK1*VJ1(L,JHK)
     &           + Z_HS1*VJ1(L,JHS)
     &           + Z_HC1*VJ1(L,JHC)
     &           + Z_HD1*VJ1(L,JHD)
        BL2(3,L) = Z_CF2*VJ2(L,JCF)
     &           + Z_CM2*VJ2(L,JCM)
     &           + Z_DI2*VJ2(L,JDI)
     &           + Z_RT2*VJ2(L,JRT)
     &           + Z_HK2*VJ2(L,JHK)
     &           + Z_HS2*VJ2(L,JHS)
     &           + Z_HC2*VJ2(L,JHC)
     &           + Z_HD2*VJ2(L,JHD)
 31   CONTINUE
      DO 32 L=1, LTOT
        BLP(3,L) = Z_CF1*PJ1(L,JCF)
     &           + Z_CM1*PJ1(L,JCM)
     &           + Z_DI1*PJ1(L,JDI)
     &           + Z_RT1*PJ1(L,JRT)
     &           + Z_HK1*PJ1(L,JHK)
     &           + Z_HS1*PJ1(L,JHS)
     &           + Z_HC1*PJ1(L,JHC)
     &           + Z_HD1*PJ1(L,JHD)
     &           + Z_CF2*PJ2(L,JCF)
     &           + Z_CM2*PJ2(L,JCM)
     &           + Z_DI2*PJ2(L,JDI)
     &           + Z_RT2*PJ2(L,JRT)
     &           + Z_HK2*PJ2(L,JHK)
     &           + Z_HS2*PJ2(L,JHS)
     &           + Z_HC2*PJ2(L,JHC)
     &           + Z_HD2*PJ2(L,JHD)
 32   CONTINUE
      BL1(3,ITH) = BL1(3,ITH) + Z_T1
      BL1(3,IDS) = BL1(3,IDS) + Z_D1
      BL1(3,IUE) = BL1(3,IUE) + Z_U1
      BL1(3,IXI) = BL1(3,IXI) + Z_X1
      BL1(3,IRR) = BL1(3,IRR) + Z_RR1
      BL2(3,ITH) = BL2(3,ITH) + Z_T2
      BL2(3,IDS) = BL2(3,IDS) + Z_D2
      BL2(3,IUE) = BL2(3,IUE) + Z_U2
      BL2(3,IXI) = BL2(3,IXI) + Z_X2
      BL2(3,IRR) = BL2(3,IRR) + Z_RR2
      BLP(3,LRO) = BLP(3,LRO) + Z_ROT
C
      RETURN
      END ! BLDIF

