
      PROGRAM INTR
      IMPLICIT REAL*4 (A-H,O-Z)
C
      PARAMETER (NROMB=12)
      DIMENSION UINT(NROMB), UEXT(NROMB)
C
C---- local arrays
      PARAMETER (KK = 2**NROMB)
      DIMENSION U(0:KK)
C
      A = 50000.0
C
      U(0)  = LOG(1.0         )
      U(KK) = LOG(1.0 + A)
C
      DET = 1.0 / FLOAT(KK)
C
C---- fill profiles by stride increment KK, KK/2, KK/4, ... 2, 1
      DO 100 IROMB=1, NROMB
C
        KSTEP = KK / 2**IROMB
C
        DO 10 K=KSTEP, KK-KSTEP, 2*KSTEP
C
C-------- eta = y/delta  and  ln(eta)
          ET = DET*FLOAT(K)
C
C-------- normalized profile U(y) = u/ui
          U(K) = LOG(1.0 + A*ET)
C
 10     CONTINUE
C
        UREF = (1.0 + 1.0/A) * LOG(1.0 + A)  -  1.0
C
C------ integrate profiles for this Romberg stage
        U1SUM = 0.
C
        DETR = DET*FLOAT(KSTEP)
C
        DO 20 K=KSTEP, KK, KSTEP
          UA   = (U(K) + U(K-KSTEP))*0.5
C
          U1SUM = U1SUM + UA
C
 20     CONTINUE
C
        UINT(IROMB) = U1SUM * DETR
C
        write(*,*)

        DO KROMB=IROMB, 1, -1
          UEXT(KROMB) = UINT(KROMB)
          IF(KROMB.EQ.IROMB) WRITE(*,5000) UEXT(IROMB)-UREF
        ENDDO
C
        DO IPASS=1, 5
C
          FAC = 1.0 / (4.0**IPASS - 1.0)
C
        DO KROMB=IROMB, IPASS+1, -1
          DU = UEXT(KROMB) - UEXT(KROMB-1)
          UEXT(KROMB) = UEXT(KROMB) + DU*FAC
          IF(KROMB.EQ.IROMB) WRITE(*,5000) UEXT(IROMB)-UREF
        ENDDO
C
 5000   FORMAT(1X,3F25.20)
C
        ENDDO
C
 100  CONTINUE
C

C
      STOP
      END
