C
      PROGRAM RUN
      INCLUDE 'INDEX.INC'
C
      PARAMETER (NX=10001)
C
C---- passed variables
      DIMENSION XI(NX),RAD(NX),BST(NX),WGAP(NX),
     &          UEDG(NX),RHOE(NX),
     &          CTAU(NX),THET(NX),
     &          DSTR(NX),CURV(NX),
     &          UWAL(NX),MWAL(NX),TAU(NX)
      DIMENSION VISRES(3,NX),
     &          DVISR1(3,ITOT,NX),
     &          DVISR2(3,ITOT,NX),
     &          DVISPR(3,LTOT,NX), 
     &          DVISXT(3)
      DIMENSION DHSDHK(NX)
      LOGICAL LWALL
C
C
      DIMENSION PAR(LTOT), VAR(ITOT,NX), 
     &          VJ(0:ITOT,JTOT,NX), PJ(LTOT,JTOT,NX)
      DIMENSION CC(NX)
C
C
      HTOT  = 2.5
      RTOT  = 1.0
      RETOT = 1.0E6
      ROT   = 0.
C
      AMCRIT = 9.0
      XITRIP = 0.4502
C
      GAM   = 1.4
      HSUTH = 0.35*HTOT
      DWTE = 0.01
C
C
      NPTS = 7
      DO I=1, NPTS
        XI(I)  = FLOAT(I-1)/FLOAT(NPTS-1)
        RAD(I) = 1.0
        BST(I) = 1.0
        WGAP(I) = 0.
      ENDDO
C
      XI1 = 0.10
      XI2 = 0.40
      UE1 = 1.10
      UE2 = 0.70
C
      DO I=1, NPTS
        CURV(I) = 0.
        UWAL(I) = 0.
        MWAL(I) = 0.
C
        IF    (XI(I) .LE. XI1) THEN
C
          UEDG(I) = UE1 * XI(I)/XI1
C
        ELSEIF(XI(I) .LE. XI2) THEN
C
          UEDG(I) = UE1
C
        ELSE
C
          UEDG(I) = UE1 + (UE2-UE1)*(XI(I)-XI2)/(1.0-XI2)
C
        ENDIF
C
        HE = HTOT - 0.5*UEDG(I)**2
        RHOE(I) = RTOT * (HE/HTOT)**(1.0/(GAM-1.0))
C
      ENDDO
C
C
C
      IMODE = 1
      LWALL = .TRUE.
C
      IPRNT1 = 1
      I = 1
C
      CALL MRCHBL(IMODE,
     &            HTOT,RTOT,RETOT,ROT,
     &            GAM,HSUTH, AMCRIT,XITRIP,DWTE,
     &            LWALL,IPRNT1,
     &            NPTS,XI(I),RAD(I),BST(I),WGAP(I),
     &            UEDG(I),CTAU(I),THET(I),DSTR(I),
     &            RHOE(I),CURV(I),UWAL(I),
     &            MWAL(I),
     &            TAU(I),
     &            VISRES(3,I),DVISR1(3,ITOT,I),DVISR2(3,ITOT,I),
     &            DVISPR(3,LTOT,I),DVISXT,
     &            ITRAN,KTRAN,XITRAN,DHSDHK(I))
C

      PAR(LSH) = HTOT
      PAR(LSR) = RTOT
      PAR(LRE) = RETOT
      PAR(LRO) = ROT
C
      DO I=2, NPTS
        VAR(ICT,I) = CTAU(I)
        VAR(ITH,I) = THET(I)
        VAR(IDS,I) = DSTR(I)
        VAR(IUE,I) = UEDG(I)
        VAR(IUW,I) = UWAL(I)
        VAR(IRH,I) = RHOE(I)
        VAR(ICV,I) = CURV(I)
        VAR(IXI,I) = XI  (I)
        VAR(IRR,I) = RAD (I)
        VAR(IBB,I) = BST (I)
        VAR(IMW,I) = MWAL(I)
C
        IF(I.LT.ITRAN) THEN
          VAR(ICT,I) = 0.
          VAR(IAM,I) = CTAU(I)
        ELSE
          VAR(ICT,I) = CTAU(I)
          VAR(IAM,I) = 0.
        ENDIF
C
C
        IF(LWALL) THEN
          IF(I.LT.ITRAN) THEN
            IVTYP = 1
          ELSE
            IVTYP = 2
          ENDIF
        ELSE
          IVTYP = 3
        ENDIF
C
        DWTE = 0.
        CALL BLVAR( IVTYP, PAR, GAM,HSUTH,
     &              WGAP(I), DWTE, VAR(1,I), VJ(0,1,I), PJ(1,1,I) )
C
        CC(I) = VJ(0,JDI,I) - 0.5*VJ(0,JCF,I)

      ENDDO
C
C
      I = 1
      CALL VADUMP('th.',VAR,ITH,NPTS,1.0,100.0)
      CALL VADUMP('ds.',VAR,IDS,NPTS,1.0,100.0)
      CALL VADUMP('ue.',VAR,IUE,NPTS,1.0,1.0  )
      CALL VADUMP('ct.',VAR,ICT,NPTS,1.0,10.0 )
C
      CALL VJDUMP('hk.',VAR,VJ,JHK,NPTS,1.0,1.0 )
      CALL VJDUMP('cf.',VAR,VJ,JCF,NPTS,1.0,1000.0)
      CALL VJDUMP('cq.',VAR,VJ,JCQ,NPTS,1.0,10.0)
      CALL VJDUMP('uq.',VAR,VJ,JUQ,NPTS,1.0,0.1)
C
      CALL XYDUMP('cc.',XI(I),CC(I),NPTS,1.0,1000.0)
C
      STOP
      END



      SUBROUTINE VADUMP(FNAME,VAR,IVAR,N,XFAC,YFAC)
      INCLUDE 'INDEX.INC'
      DIMENSION VAR(ITOT,N)
C
      CHARACTER*(*) FNAME
C
      OPEN(1,FILE=FNAME,STATUS='UNKNOWN')
      DO I=1, N
        WRITE(1,*) XFAC*VAR(IXI,I), YFAC*VAR(IVAR,I)
      ENDDO
      CLOSE(1)
C
      RETURN
      END


      SUBROUTINE VJDUMP(FNAME,VAR,VJ,JVAR,N,XFAC,YFAC)
      INCLUDE 'INDEX.INC'
      DIMENSION VAR(ITOT,N), VJ(0:ITOT,JTOT,N)
C
      CHARACTER*(*) FNAME
C
      OPEN(1,FILE=FNAME,STATUS='UNKNOWN')
      DO I=1, N
        WRITE(1,*) XFAC*VAR(IXI,I), YFAC*VJ(0,JVAR,I)
      ENDDO
      CLOSE(1)
C
      RETURN
      END




      SUBROUTINE XYDUMP(FNAME,X,Y,N,XFAC,YFAC)
      DIMENSION X(N), Y(N)
C
      CHARACTER*(*) FNAME
C
      OPEN(1,FILE=FNAME,STATUS='UNKNOWN')
      DO I=1, N
        WRITE(1,*) XFAC*X(I), YFAC*Y(I)
      ENDDO
      CLOSE(1)
C
      RETURN
      END

