
      PROGRAM TEST1
C-----------------------------------------
C     Tests BLVAR routine linearizations
C-----------------------------------------
C
      IMPLICIT REAL (A-H,M,O-Z)
      INCLUDE 'INDEX.INC'
C
      DIMENSION PAR(LTOT), PAR$(LTOT)
      DIMENSION VAR1(ITOT), VAR1$(ITOT)
      DIMENSION VJ1(0:ITOT,JTOT), VJ1$(0:ITOT,JTOT)
      DIMENSION PJ1(1:LTOT,JTOT), PJ1$(1:LTOT,JTOT)
C
      CHARACTER*1 DUMMY
C
      INCLUDE 'LABELS.INC'
C
C---- perturbation epsilon
      EPS = 5.0D-6
C
C
      HTOT  = 2.5
      RTOT  = 1.0
      RETOT = 1.0E4
      ROT   = 0.5
C
      GAM   = 1.4
      HSUTH = 0.35*HTOT
      DW   = 0.1
      DWTE = 0.15
C
C
C
C---- set variables and parameters about which perturbation is done
      VAR1(ICT) = 0.1
      VAR1(ITH) = 0.2
      VAR1(IDS) = 0.7
      VAR1(IUE) = 1.5
      VAR1(IUW) = 0.4
      VAR1(IRH) = 0.7
      VAR1(ICV) = 0.1
      VAR1(IXI) = 0.50
      VAR1(IRR) = 1.0
      VAR1(IBB) = 1.0
      VAR1(IAM) = 8.9
      VAR1(IMW) = 0.001
C
      PAR(LSH) = HTOT
      PAR(LSR) = RTOT
      PAR(LRE) = RETOT
      PAR(LRO) = ROT
C
      ITYP = 2
      CALL BLVAR( ITYP,
     &            PAR, GAM, HSUTH, DW, DWTE,
     &            VAR1,  VJ1, PJ1 )
C
C
C
C---- show parameters, primary variables, and derived (secondary) variables
 500  FORMAT(1X,I3,3X,A3,' =', F13.6)
C
      WRITE(*,*)
      DO L=1, LTOT
        WRITE(*,500) L, LCH(L), PAR(L)
      ENDDO
C
      WRITE(*,*)
      DO I=1, ITOT
        WRITE(*,500) I, ICH(I), VAR1(I)
      ENDDO
C
      WRITE(*,*)
      DO J=1, JTOT
        WRITE(*,500) J, JCH(J), VJ1(0,J)
      ENDDO
C
C
C---- set initial perturbed variables and parameters
      DO I=1, LTOT
        PAR$(I) = PAR(I)
      ENDDO
      DO I=1, ITOT
        VAR1$(I) = VAR1(I)
      ENDDO
C
 9000 FORMAT(A)
 1000 FORMAT(/1X,I3,A)
 1010 FORMAT(/1X,I3,2X,A2,'_',A2,E18.8
     &       /1X,3X,2X,2X,1X ,2X,E18.8 )
C
C
C---- test dependence on primary variables
      DO IVAR=1, ITOT
        DVAR = VAR1(IVAR)*EPS
        VAR1$(IVAR) = VAR1(IVAR) + DVAR
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        VAR1$(IVAR) = VAR1(IVAR)
C
        WRITE(*,1000) IVAR, '  ===================='
C
        DO J=1, JTOT
          WRITE(*,1010) J, JCH(J), ICH(IVAR),
     &      0.5*(VJ1$(IVAR,J)+VJ1(IVAR,J)),
     &          (VJ1$(   0,J)-VJ1(   0,J))/DVAR
        ENDDO
C
        READ(*,9000) DUMMY
      ENDDO
C
C
C---- test dependence on parameters
      DO LPAR=1, LTOT
        DPAR = PAR(LPAR)*EPS
        PAR$(LPAR) = PAR(LPAR) + DPAR
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        PAR$(LPAR) = PAR(LPAR)
C
        WRITE(*,1000) LPAR, '  ===================='
C
        DO J=1, JTOT
          WRITE(*,1010) J, JCH(J), LCH(LPAR),
     &      0.5*(PJ1$(LPAR,J)+PJ1(LPAR,J)),
     &          (VJ1$(   0,J)-VJ1(   0,J))/DPAR
        ENDDO
C
        READ(*,9000) DUMMY
      ENDDO
C
      STOP
      END


