
      PROGRAM TEST2
C-----------------------------------------
C     Tests BLDIF routine linearizations
C-----------------------------------------
C
      IMPLICIT REAL (A-H,M,O-Z)
      INCLUDE 'INDEX.INC'
C
      DIMENSION PAR(LTOT), PAR$(LTOT)
      DIMENSION VAR1(ITOT), VAR1$(ITOT)
      DIMENSION VAR2(ITOT), VAR2$(ITOT)
      DIMENSION VJ1(0:ITOT,JTOT), VJ1$(0:ITOT,JTOT)
      DIMENSION VJ2(0:ITOT,JTOT), VJ2$(0:ITOT,JTOT)
      DIMENSION PJ1(1:LTOT,JTOT), PJ1$(1:LTOT,JTOT)
      DIMENSION PJ2(1:LTOT,JTOT), PJ2$(1:LTOT,JTOT)
C
      DIMENSION BL1(3,ITOT), BL2(3,ITOT), BLP(3,LTOT), BLRES(3)
      DIMENSION BL1$(3,ITOT), BL2$(3,ITOT), BLP$(3,LTOT), BLRES$(3)
C
      DIMENSION Z_V1(3), Z_V2(3), Z_VP(3),
     &          Z_D1(3), Z_D2(3), Z_DP(3)
C
      CHARACTER*1 DUMMY
C
      INCLUDE 'LABELS.INC'
C
C
C---- perturbation epsilon
      EPS = 5.0D-6
C
C
      HTOT  = 2.5
      RTOT  = 1.0
      RETOT = 1.0E4
      ROT   = 0.5
C
      GAM   = 1.4
      HSUTH = 0.35*HTOT
      DW   = 0.1
      DWTE = 0.15
C
      BULE = 0.7
      AMCRIT = 9.0
C
      ITYP = 1
      IDIF = 1
C
C---- set variables and parameters about which perturbation is done
      VAR1(ICT) = 0.1
      VAR1(ITH) = 0.18
      VAR1(IDS) = 1.05
      VAR1(IUE) = 1.5
      VAR1(IUW) = 0.4
      VAR1(IRH) = 0.7
      VAR1(ICV) = 0.1
      VAR1(IXI) = 0.50
      VAR1(IRR) = 1.0
      VAR1(IBB) = 1.0
      VAR1(IAM) = 8.9
      VAR1(IMW) = 0.001
C
      VAR2(ICT) = 0.08
      VAR2(ITH) = 0.21
      VAR2(IDS) = 1.20
      VAR2(IUE) = 1.45
      VAR2(IUW) = 0.5
      VAR2(IRH) = 0.75
      VAR2(ICV) = 0.08
      VAR2(IXI) = 0.55
      VAR2(IRR) = 1.05
      VAR2(IBB) = 0.95
      VAR2(IAM) = 8.98
      VAR2(IMW) = 0.0008
C
      PAR(LSH) = HTOT
      PAR(LSR) = RTOT
      PAR(LRE) = RETOT
      PAR(LRO) = ROT
C
      CALL BLVAR( ITYP,
     &            PAR, GAM, HSUTH, DW, DWTE,
     &            VAR1,  VJ1, PJ1 )
      CALL BLVAR( ITYP,
     &            PAR, GAM, HSUTH, DW, DWTE,
     &            VAR2,  VJ2, PJ2 )
C
C---- set initial residuals and Jacobians
      CALL BLDIF(IDIF,BULE,ROT, AMCRIT,
     &           VAR1,VAR2, VJ1,VJ2, PJ1,PJ2,
     &           BL1, BL2, BLP, BLRES)
C
C
C
C---- show parameters, primary variables, and derived (secondary) variables
 500  FORMAT(1X,I3,3X,A3,' =', 2F13.6)
C
      WRITE(*,*)
      DO L=1, LTOT
        WRITE(*,500) L, LCH(L), PAR(L)
      ENDDO
C
      WRITE(*,*)
      DO I=1, ITOT
        WRITE(*,500) I, ICH(I), VAR1(I), VAR2(I)
      ENDDO
C
      WRITE(*,*)
      DO J=1, JTOT
        WRITE(*,500) J, JCH(J), VJ1(0,J), VJ2(0,J)
      ENDDO
C
C
C---- set initial perturbed parameters and variables
      DO L=1, LTOT
        PAR$(L) = PAR(L)
      ENDDO
      DO I=1, ITOT
        VAR1$(I) = VAR1(I)
        VAR2$(I) = VAR2(I)
      ENDDO
      CALL BLVAR(ITYP,
     &           PAR$, GAM, HSUTH, DW, DWTE,
     &           VAR1$,  VJ1$, PJ1$ )
      CALL BLVAR(ITYP,
     &           PAR$, GAM, HSUTH, DW, DWTE,
     &           VAR2$,  VJ2$, PJ2$ )
C
C
C
 9000 FORMAT(A)
 1000 FORMAT(/1X,I3,A)
 1010 FORMAT(/1X,'Res',I1,'_',A2,E18.8,
     &       /1X,3X   ,1X,1X ,2X,E18.8 )
 1020 FORMAT(/1X,'Res',I1,'_',A2,E18.8,2X,E18.8
     &       /1X,3X   ,1X,1X ,2X,E18.8,2X,E18.8 )
C
C
C---- test dependence on primary variables
      DO IVAR=1, ITOT
        DVAR = VAR1(IVAR)*EPS
C
C
C------ perturb "1" variable
        VAR1$(IVAR) = VAR1(IVAR) + DVAR
        CALL BLVAR(ITYP,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR1$,  VJ1$, PJ1$ )
C
        CALL BLDIF(IDIF,BULE,ROT, AMCRIT,
     &             VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &             BL1$, BL2$, BLP$, BLRES$)
C
C------ restore "1" variable
        VAR1$(IVAR) = VAR1(IVAR)
        CALL BLVAR(ITYP,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR1$,  VJ1$, PJ1$ )
C
C------ save analytic and finite-difference derivatives
        DO K=1, 3
          Z_V1(K) = (BL1$(K,IVAR) + BL1(K,IVAR))*0.5
          Z_D1(K) = (BLRES$(K)    - BLRES(K)   )/DVAR
        ENDDO
C
C
C
C------ perturb "2" variable
        VAR2$(IVAR) = VAR2(IVAR) + DVAR
        CALL BLVAR(ITYP,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR2$,  VJ2$, PJ2$ )
C
        CALL BLDIF(IDIF,BULE,ROT, AMCRIT,
     &             VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &             BL1$, BL2$, BLP$, BLRES$)
C
C------ restore "2" variable
        VAR2$(IVAR) = VAR2(IVAR)
        CALL BLVAR(ITYP,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR2$,  VJ2$, PJ2$ )
C
C------ save analytic and finite-difference derivatives
        DO K=1, 3
          Z_V2(K) = (BL2$(K,IVAR) + BL2(K,IVAR))*0.5
          Z_D2(K) = (BLRES$(K)    - BLRES(K)   )/DVAR
        ENDDO
C
C
        WRITE(*,1000) IVAR, '  ===================='
C
        DO K=1, 3
          WRITE(*,1020) K, ICH(IVAR),
     &      Z_V1(K), Z_V2(K),
     &      Z_D1(K), Z_D2(K)
        ENDDO
C
        READ(*,9000) DUMMY
      ENDDO
C
C
C---- test dependence on parameters
      DO LPAR=1, LTOT
        DPAR = PAR(LPAR)*EPS
C
        PAR$(LPAR) = PAR(LPAR) + DPAR
        IF(LPAR.EQ.LRO) ROT = PAR$(LRO)
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR2$,  VJ2$, PJ2$ )
C
        CALL BLDIF(IDIF,BULE,ROT, AMCRIT,
     &             VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &             BL1$, BL2$, BLP$, BLRES$)
C
        PAR$(LPAR) = PAR(LPAR)
        IF(LPAR.EQ.LRO) ROT = PAR(LRO)
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        CALL BLVAR( ITYP,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR2$,  VJ2$, PJ2$ )
C
C
C
        DO K=1, 3
          Z_VP(K) = (BLP$(K,LPAR) + BLP(K,LPAR))*0.5
          Z_DP(K) = (BLRES$(K)    - BLRES(K)   )/DPAR
        ENDDO
C
C
        WRITE(*,1000) LPAR, '  ===================='
C
        DO K=1, 3
          WRITE(*,1010) K, LCH(LPAR),
     &      Z_VP(K),
     &      Z_DP(K)
        ENDDO
C
        READ(*,9000) DUMMY
      ENDDO
C
      STOP
      END


