
      PROGRAM TESTT
C-----------------------------------------
C     Tests TRCHEK routine linearizations
C-----------------------------------------
      IMPLICIT REAL (A-H,M,O-Z)
      INCLUDE 'INDEX.INC'
C
      DIMENSION PAR(LTOT), PAR$(LTOT)
      DIMENSION VAR1(ITOT), VAR1$(ITOT)
      DIMENSION VAR2(ITOT), VAR2$(ITOT)
      DIMENSION VJ1(0:ITOT,JTOT), VJ1$(0:ITOT,JTOT)
      DIMENSION VJ2(0:ITOT,JTOT), VJ2$(0:ITOT,JTOT)
      DIMENSION PJ1(1:LTOT,JTOT), PJ1$(1:LTOT,JTOT)
      DIMENSION PJ2(1:LTOT,JTOT), PJ2$(1:LTOT,JTOT)
C
      DIMENSION XIT_VAR1(ITOT) , XIT_VAR2(ITOT) , XIT_PAR(LTOT)
      DIMENSION XIT_VAR1$(ITOT), XIT_VAR2$(ITOT), XIT_PAR$(LTOT)
C
      CHARACTER*1 DUMMY
C
      INCLUDE 'LABELS.INC'
C
C
C---- perturbation epsilon
      EPS = 5.0D-6
C
C
      HTOT  = 2.5
      RTOT  = 1.0
      RETOT = 1.0E4
      ROT   = 0.5
C
      GAM   = 1.4
      HSUTH = 0.35*HTOT
      DW   = 0.1
      DWTE = 0.15
C
      BULE = 0.7
      AMCRIT = 9.0
C
      ITYP1 = 1
      ITYP2 = 2
C
C---- set variables and parameters about which perturbation is done
      VAR1(ICT) = 0.1
      VAR1(ITH) = 0.18
      VAR1(IDS) = 1.05
      VAR1(IUE) = 1.5
      VAR1(IUW) = 0.4
      VAR1(IRH) = 0.7
      VAR1(ICV) = 0.1
      VAR1(IXI) = 0.50
      VAR1(IRR) = 1.0
      VAR1(IBB) = 1.0
      VAR1(IAM) = 8.98
      VAR1(IMW) = 0.001
C
      VAR2(ICT) = 0.08
      VAR2(ITH) = 0.21
      VAR2(IDS) = 1.20
      VAR2(IUE) = 1.45
      VAR2(IUW) = 0.5
      VAR2(IRH) = 0.75
      VAR2(ICV) = 0.08
      VAR2(IXI) = 0.55
      VAR2(IRR) = 1.05
      VAR2(IBB) = 0.95
      VAR2(IAM) = 8.98
      VAR2(IMW) = 0.0008
C
      PAR(LSH) = HTOT
      PAR(LSR) = RTOT
      PAR(LRE) = RETOT
      PAR(LRO) = ROT
C
      XIFORC = VAR2(IXI) + 1000.0
C
      CALL BLVAR( ITYP1,
     &            PAR, GAM, HSUTH, DW, DWTE,
     &            VAR1,  VJ1, PJ1 )
      CALL BLVAR( ITYP2,
     &            PAR, GAM, HSUTH, DW, DWTE,
     &            VAR2,  VJ2, PJ2 )
C
      CALL TRCHEK(VAR1,VAR2, VJ1,VJ2, PJ1,PJ2,
     &            AMCRIT, XIFORC, 
     &            KTRAN,
     &            XIT, XIT_VAR1, XIT_VAR2, XIT_PAR, XIT_XIF,
     &            AMPL2 )
C
      WRITE(*,400) VAR1(IXI), XIT, VAR2(IXI), VAR1(IAM), AMCRIT, AMPL2
 400  FORMAT(/1X,'X1 XT X2 =', 3F12.6
     &       /1X,'A1 Ac A2 =', 3F12.6 )
      WRITE(*,*) 'KTRAN =', KTRAN
C
C---- show parameters, primary variables, and derived (secondary) variables
 500  FORMAT(1X,I3,3X,A3,' =', 2F13.6)
C
      WRITE(*,*)
      DO L=1, LTOT
        WRITE(*,500) L, LCH(L), PAR(L)
      ENDDO
C
      WRITE(*,*)
      DO I=1, ITOT
        WRITE(*,500) I, ICH(I), VAR1(I), VAR2(I)
      ENDDO
C
      WRITE(*,*)
      DO J=1, JTOT
        WRITE(*,500) J, JCH(J), VJ1(0,J), VJ2(0,J)
      ENDDO
C
C
C---- set initial perturbed parameters and variables
      DO L=1, LTOT
        PAR$(L) = PAR(L)
      ENDDO
      DO I=1, ITOT
        VAR1$(I) = VAR1(I)
        VAR2$(I) = VAR2(I)
      ENDDO
      CALL BLVAR(ITYP1,
     &           PAR$, GAM, HSUTH, DW, DWTE,
     &           VAR1$,  VJ1$, PJ1$ )
      CALL BLVAR(ITYP2,
     &           PAR$, GAM, HSUTH, DW, DWTE,
     &           VAR2$,  VJ2$, PJ2$ )
C
      XIT$ = XIT
C
C
 9000 FORMAT(A)
 1000 FORMAT(/1X,I3,A)
 1010 FORMAT(/1X,'XT','_',A2,E18.8,
     &       /1X, 2X , 1X,2X,E18.8 )
 1020 FORMAT(/1X,'XT','_',A2,E18.8,2X,E18.8
     &       /1X, 2X , 1X,2X,E18.8,2X,E18.8 )
C
C
C---- test dependence on primary variables
      DO IVAR=1, ITOT
        DVAR = VAR1(IVAR)*EPS
C
C
C------ perturb "1" variable
        VAR1$(IVAR) = VAR1(IVAR) + DVAR
        CALL BLVAR(ITYP1,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR1$,  VJ1$, PJ1$ )
C
        CALL TRCHEK(VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &              AMCRIT, XIFORC,
     &              KTRAN,
     &              XIT$, XIT_VAR1$, XIT_VAR2$, XIT_PAR$, XIT_XIF$,
     &              AMPL2 )
C
C------ restore "1" variable
        VAR1$(IVAR) = VAR1(IVAR)
        CALL BLVAR(ITYP1,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR1$,  VJ1$, PJ1$ )
C
C------ save analytic and finite-difference derivatives
        XIT_V1 = (XIT_VAR1$(IVAR) + XIT_VAR1(IVAR))*0.5
        XIT_D1 = (XIT$            - XIT           )/DVAR
C
C
C
C------ perturb "2" variable
        VAR2$(IVAR) = VAR2(IVAR) + DVAR
        CALL BLVAR(ITYP2,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR2$,  VJ2$, PJ2$ )
C
        CALL TRCHEK(VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &              AMCRIT, XIFORC,
     &              KTRAN,
     &              XIT$, XIT_VAR1$, XIT_VAR2$, XIT_PAR$, XIT_XIF$,
     &              AMPL2 )
C
C------ restore "2" variable
        VAR2$(IVAR) = VAR2(IVAR)
        CALL BLVAR(ITYP2,
     &             PAR$, GAM, HSUTH, DW, DWTE,
     &             VAR2$,  VJ2$, PJ2$ )
C
C------ save analytic and finite-difference derivatives
        XIT_V2 = (XIT_VAR2$(IVAR) + XIT_VAR2(IVAR))*0.5
        XIT_D2 = (XIT$            - XIT           )/DVAR
C
C
        WRITE(*,1020) ICH(IVAR),
     &    XIT_V1, XIT_V2,
     &    XIT_D1, XIT_D2
C
        READ(*,9000) DUMMY
      ENDDO
C
C
      WRITE(*,*)
C
C---- test dependence on parameters
      DO LPAR=1, LTOT
        DPAR = PAR(LPAR)*EPS
C
        PAR$(LPAR) = PAR(LPAR) + DPAR
        IF(LPAR.EQ.LRO) ROT = PAR$(LRO)
        CALL BLVAR( ITYP1,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        CALL BLVAR( ITYP2,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR2$,  VJ2$, PJ2$ )
C
        CALL TRCHEK(VAR1$,VAR2$, VJ1$,VJ2$, PJ1$,PJ2$,
     &              AMCRIT, XIFORC,
     &              KTRAN,
     &              XIT$, XIT_VAR1$, XIT_VAR2$, XIT_PAR$, XIT_XIF$,
     &              AMPL2 )
C
        PAR$(LPAR) = PAR(LPAR)
        IF(LPAR.EQ.LRO) ROT = PAR(LRO)
        CALL BLVAR( ITYP1,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR1$,  VJ1$, PJ1$ )
        CALL BLVAR( ITYP2,
     &              PAR$, GAM, HSUTH, DW, DWTE,
     &              VAR2$,  VJ2$, PJ2$ )
C
C
C------ save analytic and finite-difference derivatives
        XIT_VP = (XIT_PAR$(LPAR) + XIT_PAR(LPAR))*0.5
        XIT_DP = (XIT$           - XIT          )/DPAR
C
C
        WRITE(*,1010) LCH(LPAR),
     &    XIT_VP,
     &    XIT_DP
C
        READ(*,9000) DUMMY
      ENDDO
C
      STOP
      END

