set terminal x11 
set output 
set noclip points
set clip one
set noclip two
set border
set boxwidth
set dummy x,y
set format x "%g"
set format y "%g"
set format z "%g"
set nogrid
set key
set nolabel
set noarrow
set nologscale
set offsets 0, 0, 0, 0
set nopolar
set angles radians
set noparametric
set view 60, 30, 1, 1
set samples 100, 100
set isosamples 10, 10
set surface
set nocontour
set clabel
set nohidden3d
set cntrparam order 4
set cntrparam linear
set cntrparam levels auto 5
set cntrparam points 5
set size 1,1
set data style points
set function style lines
set xzeroaxis
set yzeroaxis
set tics in
set ticslevel 0.5
set xtics
set ytics
set ztics
set title "" 0,0
set notime
set rrange [-0 : 10]
set trange [-5 : 5]
set urange [-5 : 5]
set vrange [-5 : 5]
set xlabel "" 0,0
set xrange [0 : 1]
set ylabel "" 0,0
set yrange [0 : 1]
set zlabel "" 0,0
set zrange [-10 : 10]
set autoscale r
set autoscale t
set autoscale x 
set autoscale z
set zero 1e-08
b1(b) =  3*(b+2)*(b+3)/(b+7)
b2(b) = -5*(b+1)*(b+3)/(b+7)
b3(b) =  2*(b+1)*(b+2)/(b+7)
f(y,b) = (b1(b)*y + b2(b)*y**2 + b3(b)*y**3)*y**b
Ulog(y) = sqrt(Cf/2) * (log(y*sqrt(Cf/2)*R)/k + 5.0)
Ut(y) = (y<1/c) ? sqrt(Cf/2) * ((log(y*sqrt(Cf/2)*R) - c*y)/k + 5.0) : sqrt(Cf/2) * ((log(sqrt(Cf/2)*R/c) - 1)/k + 5.0)
Utmod(y) = (y<1/c) ? sqrt(Cf/2) * ((log(y*sqrt(Cf/2)*R+ypw) - c*y)/k + 5.0) : sqrt(Cf/2) * ((log(sqrt(Cf/2)*R/c+ypw) - 1)/k + 5.0)
Ul(y) = (y<1/c) ? (Cf/2)*R*(y - c*y**2 + (c**2/3)*y**3) : (Cf/2)*R/(3*c)
w(y) = (y<1/c) ? tanh( R*sqrt(Cf/2)* y/(1-c*y) / 20.0 ) : 1.0
Ui(y) = Ut(y)*w(y)
U(y,b) = Ui(y) + (1 - Ui(1.0))*f(y,b)
Cf = 0.003
R = 10000
k = 0.41
c = 1.0
ypw = 1.0
plot [y=0:1] Ul(y), Ut(y), U(y,1.0)
