C
C---- Primary limits for LINDOP arrays
      PARAMETER (IX=220,NMODX=40,NPOSX=1,NBX=1,NPX=15,NVX=2,NHISX=100)
      PARAMETER (NUPX=10,NUCX=10,NTHX=3,NHKX=5)
C
C  IX    = number of streamwise points
C  NMODX = number of element geometry perturbation modes
C  NPOSX = number of element position perturbation modes
C  NBX   = number of elements
C  NPX   = number of operating points
C  NVX   = number of surface flow variables (Cp, Mdef, Hk, n)
C  NHISX = number of optimization history points
C  NUPX  = number of user-defined parameters
C  NUCX  = number of user-defined constraints
C  NTHX  = number of thickness-constraint locations
C  NHKX  = number of shape parameter constraints
C
      PARAMETER (ISX=2*NBX)
      PARAMETER (NHESX=NPX*(NMODX+NPOSX+3),NCONX=5*NPX+NUCX)
      PARAMETER (NSYSX=NHESX+NCONX)
C
      IMPLICIT REAL (A-H,M,O-Z)
      INTEGER SYSPIV,PRJPIV
      LOGICAL LPLOT,LMODES, LPOLAR,LSWEEP,L2SIDE
      LOGICAL LOPDIR,LDSET, LXPAR, LXHES, LXCON, LXSYS, LXQLQ
      LOGICAL LSEQ, LGSCPL, LTRNSF, LHESUP, LPRSET, LFCSET, LOPSET
      LOGICAL LSLFIX,LSRFIX,LHKFIX
      LOGICAL LALFIX,LARFIX,LCVFIX,LTHFIX,LABFIX,LSGFIX,LEIFIX
      LOGICAL LCLFIX,LCMFIX,LMAFIX,LREFIX,LUCFIX,LUCDEF
      LOGICAL LALFA,LMACH,LREYN,LMOD,LPOS,LUPAR
      LOGICAL LNKMOD,LNKPOS,LDEPMA,LDEPRE,LMAFIX1,LREFIX1
      CHARACTER*80 ARGP1, ARGP2, FNAME, LINE
      CHARACTER*32 CODE, NAME
      CHARACTER*2 PNUM
      CHARACTER*8 UPNAME, UCNAME, DPNAME
C
      COMMON/C00/ ARGP1, ARGP2, FNAME, LINE, 
     &            UPNAME(NUPX), UCNAME(NUCX), DPNAME(NHESX)
C
      COMMON/C01/ CODE, NAME(NPX), PNUM(99)
C
      COMMON/C02/ 
     &  VERSION,
     &  PI,DTOR, 
     &  SIZE,XMARG,YMARG,CH,PLAR,
     &  GAM,GM1,
     &  FRDX1,PLDX1,PLDX2,
     &  PLDY1,PLDY2,PLDY3,
     &  XFR,YFR,
     &  XLIM(2),YLIM(2),
     &  XLIMV(2),YLIMV(2),
     &  XOFFV(ISX),YOFFV(ISX),XSFV(ISX),YSFV(ISX),
     &  VAROFF(NVX),ANNFAC(NVX),VARSF(ISX,NPX,NVX),
     &  DNRMS(NPX),DRRMS(NPX),DVRMS(NPX),
     &  DNMAX(NPX),DRMAX(NPX),DVMAX(NPX)
C
      COMMON/C03/ 
     &  XBMIN,XBMAX,YBMIN,YBMAX,
     &  XELMIN(NBX),XELMAX(NBX),YELMIN(NBX),YELMAX(NBX),
     &  SBLEGN(NBX,NPX),
     &  XCENT(NBX,NPX),YCENT(NBX,NPX),
     &  CHPLT(NBX,NPX),AGPLT(NBX,NPX),
     &  XPL1(ISX,NPX),XPL2(ISX,NPX),
     &  XPL(IX,ISX,NPX),
     &  XPL_POS(IX,ISX,NPOSX,NPX),
     &  TBSKIN(NBX), XSTRF(NBX), XSTRB(NBX),
     &  XTHFIX(0:NTHX,NBX), XHKFIX(NHKX),
     &  XBLFIX(ISX),XBRFIX(ISX),
     &  YBLFIX(ISX),YBRFIX(ISX),
     &  SBLFIX(ISX),SBRFIX(ISX)
C
      COMMON/C04/ IDEV,IHARD,IXPLT, NANN(ISX,NPX,NVX), LPLOT
C
      COMMON/C05/ 
     &  NVAR, NHIS, NSTEP(NHISX), IDTYPE(NHISX),
     &  NPOINT, KPOINT(NPX), IPGSEN, II(NPX), NBL(NPX),
     &  NPOSEL(NPOSX,NPX), NBPOS(NBX,NPOSX,NPX),
     &  NTHFIX(NBX), NHKFIX, NMODMX, NPOSMX, NMOD(NPX),NPOS(NPX), 
     &  NUPAR, NUCON, NPAR, NPARH(NHISX),
     &  ILEB(NBX,NPX), ITEB(NBX,NPX), IEND(NBX,NPX),
     &  IPHFIX(NHKX),ISHFIX(NHKX),
     &  LMODES(ISX,NPX), 
     &  LSLFIX(ISX),LSRFIX(ISX),LHKFIX(NHKX),
     &  LALFIX(NBX),LARFIX(NBX),LCVFIX(NBX),
     &  LTHFIX(0:NTHX,NBX),
     &  LABFIX(NBX),LSGFIX(NBX),LEIFIX(NBX),
     &  LCLFIX(NPX),LCMFIX(NPX),LMAFIX(NPX),LREFIX(NPX),
     &  LUCFIX(NUCX),LUCDEF(NUCX),
     &  KHESAL(NPX),KHESMA(NPX),KHESLR(NPX),KHESUP(NUPX),
     &  KHESMOD(NMODX,NPX),KHESPOS(NPOSX,NPX),
     &  KCONSL(ISX),KCONSR(ISX),KCONHK(NHKX),
     &  KCONAL(NBX),KCONAR(NBX),KCONCV(NBX),
     &  KCONTH(0:NTHX,NBX),
     &  KCONAB(NBX),KCONSG(NBX),KCONEI(NBX),
     &  KCONCL(NPX),KCONCM(NPX),
     &  KCONMA(NPX),KCONRE(NPX),
     &  KCONUC(NUCX),
     &  KALFA(NPX),KMACH(NPX),KREYN(NPX), 
     &  LALFA(NPX),LMACH(NPX),LREYN(NPX), LUPAR(NUPX),
     &  LMOD(NMODX,NPX),LPOS(NPOSX,NPX),
     &  LDEPMA(NPX),LDEPRE(NPX),LMAFIX1,LREFIX1,
     &  LPOLAR,LSWEEP,L2SIDE, LOPDIR, LDSET,
     &  LXPAR, LXHES, LXCON, LXSYS, LXQLQ, 
     &  LSEQ, LGSCPL, LTRNSF, LHESUP, LPRSET, LFCSET, LOPSET,
     &  LNKMOD,LNKPOS,
     &  IPTARG,ISTARG,IVTARG, IFTYPE,IFTHOP, IHISOP,
     &  NHESOP,NHES,NCON, NSYS,
     &  SYSPIV(NSYSX),PRJPIV(NCONX)
C
      COMMON/C06/ 
     &  WP(NPX), FUN_WP(NPX),
     &  GSCAL, 
     &  GSCMA, 
     &  GSCLR, 
     &  GSCMOD(NMODX),
     &  GSCPOS(NPOSX),
     &  GSCUP(NUPX),
     &  OPSTEP(NHISX), VABS(NHISX), FUNMOD, DFCON(NHISX), CNSTEP,
     &  FUN(NHISX), FC_SOP(NHISX), FU_SOP,
     &  FU_AL(NPX)       ,
     &  FU_MA(NPX)       ,
     &  FU_RE(NPX)       ,
     &  FU_MOD(NMODX,NPX),
     &  FU_POS(NPOSX,NPX),
     &  FU_UP(NUPX)
C
      COMMON/C07/ 
     &  XBI(IX,ISX,NPX),
     &  YBI(IX,ISX,NPX),
     &  SBI(IX,ISX,NPX),
     &  XBI_MOD(IX,ISX,NMODX,NPX),
     &  YBI_MOD(IX,ISX,NMODX,NPX),
     &  SBI_MOD(IX,ISX,NMODX,NPX),
     &  XBI_POS(IX,ISX,NPOSX,NPX),
     &  YBI_POS(IX,ISX,NPOSX,NPX),
     &  SBI_POS(IX,ISX,NPOSX,NPX),
     &  XBPOS(NBX,NPOSX,NPX),YBPOS(NBX,NPOSX,NPX),ABPOS(NBX,NPOSX,NPX),
     &  XLEB(NBX,NPX), YLEB(NBX,NPX),
     &  XTEB(NBX,NPX), YTEB(NBX,NPX),
     &  ANGLL(NBX,NPX), AGL_MOD(NMODX,NBX,NPX),
     &  ANGLR(NBX,NPX), AGR_MOD(NMODX,NBX,NPX),
     &  AREAB(NBX,NPX), ARB_MOD(NMODX,NBX,NPX),
     &  CSIGB(NBX,NPX), CSG_MOD(NMODX,NBX,NPX),
     &  TSIGB(NBX,NPX), TSG_MOD(NMODX,NBX,NPX),
     &  ASIGB(NBX,NPX), ASG_MOD(NMODX,NBX,NPX),
     &  EI11B(NBX,NPX), EI1_MOD(NMODX,NBX,NPX),
     &  THIKB(0:NTHX,NBX,NPX), THB_MOD(NMODX,0:NTHX,NBX,NPX),
     &  SLL_MOD(NMODX,ISX,NPX),
     &  SLR_MOD(NMODX,ISX,NPX),
     &  CVLE(NBX,NPX),CVLE_MOD(NMODX,NBX,NPX),
     &  HKLOC(NHKX), HKL_MOD(NMODX,NHKX), HKL_POS(NPOSX,NHKX),
     &  HKL_ALFA(NHKX), HKL_MACH(NHKX), HKL_REYN(NHKX)
C
      COMMON/C08/
     &  ALSPEC(NBX),ARSPEC(NBX),CVSPEC(NBX),
     &  ABSPEC(NBX),SGSPEC(NBX),EISPEC(NBX),
     &  THSPEC(0:NTHX,NBX),
     &  HKSPEC(NHKX),
     &  CLSPEC(NPX),CMSPEC(NPX),
     &  UCRES(NUCX), DUCRES(NUCX),
     &  ALGM(0:NCONX),BLGM(0:NCONX)
C
      COMMON/C09/
     &  ALFA(NPX), DALFA(NPX), DALFAC(NPX), DALFAF(NPX),
     &  MACH(NPX), DMACH(NPX), DMACHC(NPX), DMACHF(NPX),
     &  REYN(NPX),
     &             DLNRE(NPX), DLNREC(NPX), DLNREF(NPX),
     &  MSQCL(NPX),
     &  RSQCL(NPX),
     &  MODN(NMODX,NPX),
     &  DMOD(NMODX,NPX),
     &  DMODC(NMODX,NPX),
     &  DMODF(NMODX,NPX),
     &  POSN(NPOSX,NPX),
     &  DPOS(NPOSX,NPX),
     &  DPOSC(NPOSX,NPX),
     &  DPOSF(NPOSX,NPX),
     &  UPAR(NUPX), DUPAR(NUPX), DUPARC(NUPX), DUPARF(NUPX),
     &  EPUPAR(NUPX)
C
      COMMON/C10/
     &           AL_ALFA(NPX), AL_MACH(NPX), AL_REYN(NPX), 
     &  CL(NPX), CL_ALFA(NPX), CL_MACH(NPX), CL_REYN(NPX), 
     &  CM(NPX), CM_ALFA(NPX), CM_MACH(NPX), CM_REYN(NPX), 
     &  CD(NPX), CD_ALFA(NPX), CD_MACH(NPX), CD_REYN(NPX),
     &  AL_MOD(NMODX,NPX), AL_POS(NPOSX,NPX),
     &  CL_MOD(NMODX,NPX), CL_POS(NPOSX,NPX),
     &  CM_MOD(NMODX,NPX), CM_POS(NPOSX,NPX),
     &  CD_MOD(NMODX,NPX), CD_POS(NPOSX,NPX),
     &  CDW(NPX),CDW_ALFA(NPX),CDW_MACH(NPX),CDW_REYN(NPX),
     &  CDV(NPX),CDV_ALFA(NPX),CDV_MACH(NPX),CDV_REYN(NPX),
     &  CDF(NPX),CDF_ALFA(NPX),CDF_MACH(NPX),CDF_REYN(NPX),
     &  CDP(NPX),CDP_ALFA(NPX),CDP_MACH(NPX),CDP_REYN(NPX),
     &  CDW_MOD(NMODX,NPX),CDW_POS(NPOSX,NPX),
     &  CDV_MOD(NMODX,NPX),CDV_POS(NPOSX,NPX),
     &  CDF_MOD(NMODX,NPX),CDF_POS(NPOSX,NPX),
     &  CDP_MOD(NMODX,NPX),CDP_POS(NPOSX,NPX) 
C
      COMMON/C11/ 
     &  CP(IX,ISX,NPX),
     &  HK(IX,ISX,NPX),
ccc  &  MD(IX,ISX,NPX),
ccc  &  AF(IX,ISX,NPX),
     &  CP_ALFA(IX,ISX,NPX),
     &  HK_ALFA(IX,ISX,NPX),
ccc  &  MD_ALFA(IX,ISX,NPX),
ccc  &  AF_ALFA(IX,ISX,NPX),
     &  CP_MACH(IX,ISX,NPX),
     &  HK_MACH(IX,ISX,NPX),
ccc  &  MD_MACH(IX,ISX,NPX),
ccc  &  AF_MACH(IX,ISX,NPX),
     &  CP_REYN(IX,ISX,NPX),
     &  HK_REYN(IX,ISX,NPX),
ccc  &  MD_REYN(IX,ISX,NPX),
ccc  &  AF_REYN(IX,ISX,NPX),
     &  CP_MOD(IX,ISX,NMODX,NPX),
     &  HK_MOD(IX,ISX,NMODX,NPX),
ccc  &  MD_MOD(IX,ISX,NMODX,NPX),
ccc  &  AF_MOD(IX,ISX,NMODX,NPX),
     &  CP_POS(IX,ISX,NPOSX,NPX),
     &  HK_POS(IX,ISX,NPOSX,NPX)
ccc  &  MD_POS(IX,ISX,NPOSX,NPX),
ccc  &  AF_POS(IX,ISX,NPOSX,NPX) 
C
      DIMENSION VAR(IX,ISX,NPX,NVX),
     &          VAR_ALFA(IX,ISX,NPX,NVX),
     &          VAR_MACH(IX,ISX,NPX,NVX),
     &          VAR_REYN(IX,ISX,NPX,NVX),
     &          VAR_MOD(IX,ISX,NMODX,NPX,NVX),
     &          VAR_POS(IX,ISX,NPOSX,NPX,NVX)
C
      EQUIVALENCE (CP(1,1,1)      ,VAR(1,1,1,1)),
     &            (CP_ALFA(1,1,1) ,VAR_ALFA(1,1,1,1)),
     &            (CP_MACH(1,1,1) ,VAR_MACH(1,1,1,1)),
     &            (CP_REYN(1,1,1) ,VAR_REYN(1,1,1,1)),
     &            (CP_MOD(1,1,1,1),VAR_MOD(1,1,1,1,1)),
     &            (CP_POS(1,1,1,1),VAR_POS(1,1,1,1,1))
C
      COMMON/C21/ GN(IX,ISX,NMODX,NPX),
     &            VARSP(IX,ISX,NPX),DVAR(IX,ISX,NPX),
     &            HESSLS(NHESX,NHESX),CONJAC(0:NHESX,0:NCONX),
     &            BMAT(NHESX,NCONX),
     &            SYS(NSYSX,NSYSX),PRJ(NCONX,NCONX),
     &            DPAR(0:NSYSX)
C
      COMMON/C22/ HESSOP(NHESX,NHESX),EGVEC(NHESX,NHESX),
     &            EGVAL(NHESX), SEGVAL(NHESX), CONDMX
C
      COMMON/C23/ GSCPAR(NHESX),
     &            PAR(0:NHESX,NHISX),
     &            FU_PAR(0:NHESX,NHISX),
     &            FC_PAR(0:NHESX,NHISX),
     &            VPAR(NHESX,NHISX)
C
      COMMON/C25/ GVARMS(IX,ISX,NPX),GCLRMS(NPX),GCDRMS(NPX),DELTRY
C
C---------------------------------------------------------------------
C
C   Indices:  p  operating point
C             n  element
C             s  element side   (1,2 = element 1   3,4 = element 2 ...)
C             i  streamwise grid point
C             k  geometric or position mode
C             v  variable   (1=Cp, 2=Hk, 3=Mdef, 4=n)
C             h  optimization history index
C             u  user-defined variable or constraint
C             x  location index for element thickness constraints
C
C  ARGP1,2   Unix arguments:  % lindop ARGP1 ARGP2
C  FNAME     Filename string
C  LINE      Input buffer string
C  UPNAME    user-parameter name
C  UCNAME    user-constraint name
C  DPNAME    design-parameter name
C
C  CODE
C  NAME(p)   name of airfoil
C  CNUM(p)   character array containing integers "1","2",...
C
C  PI        3.14159...
C  DTOR      degrees-to-radians conversion factor
C  SIZE      hardcopy plot width (in inches)
C  XMARG     left   edge margin  (in inches)
C  YMARG     bottom edge margin  (in inches)
C  CH        baseline character height
C  PAR       plot aspect ratio
C 
C  GAM       cp/cv
C  GM1       cp/cv - 1
C
C  FRDX1     fraction of left plot section taken up by obj. fun. info
C  PLDX1     left  plot section box width  (total width = 1)
C  PLDX2     right plot section box width
C  PLDY1     bottom left  plot section box width
C  PLDY2     middle left  plot section box width
C  PLDY3     top    left  plot section box width
C  
C  XFR,YFR   fraction of box width,height taken up by x,y-axes
C  
C  XLIM(2)     box x-limits for clipping
C  YLIM(2)     box y-limits for clipping
C  
C  XLIMV(2)    x-limits of active variable plot box
C  YLIMV(2)    y-limits of active variable plot box
C  
C  XOFFV,YOFFV offsets in active variable plot box
C  XSFV,YSFV   scaling factors in active variable plot box
C  
C  VAROFF(v)    plot offset for variable v
C  ANNFAC(v)    annotation scale factor for variable v
C  VARSF(s,p,v) plot scaling factor for variable v
C
C  DNRMS(p)    rms and max variable Newton changes from MSES solution
C  DRRMS(p)
C  DVRMS(p)
C  DNMAX(p)
C  DRMAX(p)
C  DVMAX(p)
C
C  XBMIN       x,y limits of entire airfoil configuration
C  XBMAX 
C  YBMIN
C  YBMAX
C
C  GNMAX       max geometry deformation mode height
C  PSMAX       max position mode value (translation)
C  PRMAX       max position mode value (rotation)
C
C  XELMIN(n)   x,y limits of element n
C  XELMAX(n)
C  YELMIN(n)
C  YELMAX(n)
C  SBLEGN(n,p) left mode endpoint arc length
C  XCENT(n,p)  centroid of element n
C  YCENT(n,p)
C  CHPLT(n,p)  chord of plot axis
C  AGPLT(n,p)  angle of plot axis
C  XPL1(s,p)   starting and ending values of XPL on x-axis
C  XPL2(s,p)
C  XPL(i,s,p)  x-axis plot coordinate
C
C  TBSKIN(n)   top/bottom skin thickness ratio
C  XSTRF(n)    forward x/c limit of structural skin (i.e. spar box)
C  XSTRB(n)    aft     x/c limit of structural skin
C
C  XTHFIX(x,n) x/c for element thickness constraints
C
C  XHKFIX(s)   x/c where Hk constraint is imposed
C
C  IDEV        device number
C  IHARD       hardcopy flag
C  IXPLT       gives type of x-axis plot coordinate
C  NANN(s,p,v) number of y-axis annotation intervals for variable v
C  LPLOT       .TRUE. of plot is active
C
C  NVAR        number of surface variables (typically 4)
C  NHIS        number of optimization history points (includes current one)
C  NSTEP(h)    number of line-minimization sub-steps taken
C  IDTYPE(h)   type of conjugate-gradient method being used
C
C  NPOINT      number of operating points
C  KPOINT(p)
C  IPGSEN      index of point where geometric sensitivities are defined
C  II(p)       horizontal grid size
C  NBL(p)      number of elements
C
C  NPOSEL(k,p)  number of elements influenced by position mode k
C  NBPOS(n,k,p) element influenced by position mode k
C
C  NTHFIX(n)   number of thickness constraints on element
C  NHKFIX      number of Hk constraints
C  NMODMX      max number of geometry deformation modes over points
C  NPOSMX      max number of element position modes over points
C  NMOD(p)     number of geometry deformation modes for each point
C  NPOS(p)     number of element position modes for each point
C  NUPAR       number of user parameters
C  NUCON       number of user constraints
C  NPAR        number of active parameters in Hessian system
C
C  ILEB(n,p)   leading edge index
C  ITEB(n,p)   trailing edge index
C  IEND(n,p)   index of last point plotted
C
C  IPHFIX(k)   operating point at which Hk constraint is imposed
C  ISHFIX(k)   side at which Hk constraint is imposed
C  
C  LMODES(s,p) a mode is present on side s of point p
C
C=============================
C  Active-constraint flags for...
C
C  LSLFIX(s)   left  surface slope change angle
C  LSRFIX(s)   right surface slope change angle
C  LHKFIX(s)   kinematic shape parameter constraint
C
C  LALFIX(n)   left  thickness angle
C  LARFIX(n)   right thickness angle
C  LCVFIX(n)   LE curvature
C
C  LTHFIX(x,n) thickness
C  LABFIX(n)   enclosed area
C  LSGFIX(n)   RMS strain
C  LEIFIX(n)   bending stiffness
C
C  LCLFIX(p)   CL
C  LCMFIX(p)   CM
C
C  LMAFIX(p)   Ma
C  LREFIX(p)   Re
C
C  LUCFIX(u)   user-defined constraint
C=============================
C  
C  KALFA(p)    1 if alpha is a DOF, 0 otherwise
C  KMACH(p)    1 if Mach  is a DOF, 0 otherwise
C  KREYN(p)    1 if Re    is a DOF, 0 otherwise
C
C=============================
C  Hessian matrix column pointers for active design parameters...
C
C  KHESAL(p)   alpha
C  KHESMA(p)   Mach
C  KHESLR(p)   ln(Reynolds number)
C
C  KHESMOD(k,p) geometry mode
C  KHESPOS(k,p) position mode
C
C  KHESUP(u)   user-defined parameters
C=============================
C
C=============================
C  Constraint Jacobian column pointers for active constraints...
C
C  KCONSL(s)   left  slope
C  KCONSR(s)   right slope
C  KCONHK(s)   kinematic shape parameter
C
C  KCONAL(n)   left  angle
C  KCONAR(n)   right angle
C  KCONCV(n)   LE curvature
C
C  KCONTH(x,n) thickness
C  KCONAB(n)   area
C  KCONSG(n)   strain
C  KCONEI(n)   EI
C
C  KCONCL(p)   CL
C  KCONCM(p)   CM
C
C  KCONMA(p)   Mach
C  KCONRE(p)   Re
C
C  KCONUC(u)   user-defined constraints
C=============================
C
C=============================
C  Active design-parameter flags...
C  LALFA(p)    alpha
C  LMACH(p)    Mach
C  LREYN(p)    Reynolds number
C  LMOD(k)     geometry mode
C  LPOS(k)     position mode
C  LUPAR(u)    user-defined parameter
C=============================
C
C  LDEPMA(p) .TRUE. if MACH*sqrt(CL) is held constant in MSES solution
C  LDEPRE(p) .TRUE. if RE  *sqrt(CL) is held constant in MSES solution
C  LMAFIX1   .TRUE. if MACH*sqrt(CL) can be enforced at any point
C  LREFIX1   .TRUE. if RE  *sqrt(CL) can be enforced at any point
C
C  LPOLAR   .TRUE. if points constitute a drag polar sweep
C  LSWEEP   .TRUE. if points constitute a Mach sweep
C  L2SIDE   .TRUE. if variable on both element sides is to be specified
C
C  LOPDIR   .TRUE. if optimization descent-direction is defined
C  LDSET    .TRUE. if changes have been generated and not saved
C
C  LXPAR    .TRUE. if parameter pointers are defined
C  LXHES    .TRUE. if Hessian is defined
C  LXCON    .TRUE. if constraint-Jacobian is defined
C  LXSYS    .TRUE. if factored constrained Hessian is defined
C  LXQLQ    .TRUE. if optimization-Hessian QLQ decomposition is defined
C
C  LSEQ     .TRUE. if a sequence of sensx.xxx_nn was read in
C  LGSCPL   .TRUE. if scaling-menu perturbations are to be plotted
C
C  LTRNSF   .TRUE. if transformed (eigenvector-basis) space is used
C  LHESUP   .TRUE. if approximate Hessian has been updated
C  LPRSET   .TRUE. if flags and settings have been changed and not saved
C
C  LFCSET   .TRUE. if constrained obj.-function derivatives have been set
C  LOPSET   .TRUE. if optimization step has been generated and not saved
C
C  LNKMOD   .TRUE. if geometry modes are linked (1 DOF/mode for all points)
C  LNKPOS   .TRUE. if position modes are linked
C  
C  IPTARG      p index of target point
C  ISTARG      s index of target element side
C  IVTARG      v index of target variable
C
C  IFTYPE      current objective-function type
C  IFTHOP      objective-function type of approximate Hessian
C  IHISOP      history index at which approximate Hession was last updated
C  
C  NHESOP      number of DOFs in optimization approximate-Hessian matrix
C  NHES        number of DOFs in least-squares Hessian matrix
C  NCON        number of constraints in constraint-Jacobian
C  NSYS        number of DOFs in constrained least-squares system
C  SYSPIV(.)   permutation vector for factored least-squares system
C  PRJPIV(.)   permutation vector for factored direction-projection matrix
C
C
C  WP(p)      point weight 
C
C  Gradient-component scales...
C  GSCAL      alpha
C  GSCMA      Mach
C  GSCLR      ln(Reynolds number)
C  GSCMOD(k)  geometry mode
C  GSCPOS(k)  position mode
C
C  OPSTEP(h)   optimization step size "eps" in scaled space
C  VABS(h)     modulus of search direction vector in scaled space
C  DFCON(h)    forced function change from constraint enforcement
C  FUNMOD      modified objective function (after linear step)
C  FUN(h)      objective function
C  FC_SOP(h)   dFUN/deps   (should = FU_SOP)
C       (directional derivative in scaled space along search direction)
C
C  FU_AL(p)    dFUN/dalpha            (unconstrained derivatives)
C  FU_MA(p)      "   Mach
C  FU_RE(p)      "   Reyn
C  FU_MOD(k,p)       geometry mode
C  FU_POS(k,p)       position mode
C  FU_UP(u)          user parameter
C
C  GSCPAR(k)   parameter gradient scales
C  PAR(k,h)    design parameter values over optimization history
C  FU_PAR(k,h) dF/dXk (unconstrained) over optimization history
C  FC_PAR(k,h) dF/dXk ( constrained ) over optimization history
C  VPAR(k,h)   search direction vector components in physical space
C
C  XBI(i,s,p)  element geometry x coordinates
C  YBI(i,s,p)  element geometry y coordinates
C  SBI(i,s,p)  element geometry arc-length array
C
C  XBPOS(n,k,p) position mode x-amplitude (rotation center x if ABPOS.ne.0)
C  YBPOS(n,k,p) position mode y-amplitude (rotation center y if ABPOS.ne.0)
C  ABPOS(n,k,p) rotation mode amplitude
C
C  XLEB(n,p)   element leading edge point coordinates
C  YLEB(n,p)
C  XTEB(n,p)   element trailing edge point coordinates
C  YTEB(n,p)
C
C  THIKB(x,n,p) element thickness (max and local) normal to its chord line
C  AREAB(n,p)   element cross-sectional area
C  CSIGB(n,p)   element max compressive strain
C  TSIGB(n,p)   element max tensile strain
C  ASIGB(n,p)   element rms thickness-weighted strain
C  EI11B(n,p)   element unit bending stiffness
C  [ ]_MOD      d[ ]/dMOD  sensitivity of geometric quantity to geo. mode
C
C  SLL_MOD(k,s,p)  left-endpoint slope derivative wrt geometry mode
C  SLR_MOD(k,s,p) right-endpoint slope derivative wrt geometry mode
C
C  HKLOC(j)    local shape parameter
C
C  ALSPEC(n)   specified left  angle
C  ARSPEC(n)   specified right angle
C  CVSPEC(n)   specified LE curvature
C  ABSPEC(n)   specified element area
C  SGSPEC(n)   specified element rms unit strain
C  EISPEC(n)   specified element unit stiffness
C  THSPEC(x,n) specified element max or local stiffness
C
C  HKSPEC(j)   specified Hk (kinematic shape parameter)
C
C  CLSPEC(p)   specified CL
C  CMSPEC(p)   specified CM
C  UCRES(u)    user-constraint residual
C  DUCRES(u)   user-constraint residual change 
C                from all active and inactive parameter changes
C
C  ALGM(.)     Lagrange multipliers
C  BLGM(.)
C
C  ALFA(p),DALFA(p)  angle of attack and current change
C  MACH(p),DMACH(p)  freestream Mach number and current change
C  REYN(p)           freestream Reynolds number
C          DLNRE(p)  d ln(Re) (fractional Reynolds number change)
C
C  MSQCL(p)     Mach x sqrt(CL)  to be imposed with LMAFIX constraint
C  RSQCL(p)     Reyn x sqrt(CL)  to be imposed with LREFIX constraint
C
C  MODN(k,p)      accumulated element geometry modes
C  POSN(k,p)      accumulated element position modes
C  DMOD(k,p)      current change in geometry mode k
C  DPOS(k,p)      current change in position mode k
C
C  UPAR(u)        user-defined parameter
C  DUPAR(u)       current change in user-defined parameter
C  EPUPAR(u)      differencing perturbation for user-defined parameter
C
C  DALFAC(p)      changes due to constraint enforcement
C  DMACHC(p) 
C   .
C   .
C
C  DALFAL(p)      angle of attack change from linear update
C  DMACHL(p) 
C   .
C   .
C
C  [ ]_ALFA(p)   sensitivity wrt angle of attack
C  [ ]_MACH(p)   sensitivity wrt Mach number
C  [ ]_REYN(p)   sensitivity wrt freestream Reynolds number
C  [ ]_MOD(k,p)  sensitivity wrt geometric mode
C  [ ]_POS(k,p)  sensitivity wrt position mode
C
C  CL(p)         total lift coefficient
C  CM(p)         total moment coefficient
C  CD(p)         total drag coefficient
C 
C  CDW(p)        wave     CD      Note: CD = CDW + CDV
C  CDV(p)        viscous  CD               = CDF + CDP
C  CDF(p)        friction CD
C  CDP(p)        pressure CD
C
C  CP(i,s,p)     surface pressure coefficient
C  HK(i,s,p)     kinematic shape parameter
C  MD(i,s,p)     momentum defect  (Rho Ue^2 Theta)
C  AF(i,s,p)     amplification factor
C
C  VAR(i,s,p,v)   overlay array equivalenced with CP,HK,MD,AF
C
C  GN(i,s,k,p)    geometric deformation modes
C  VARSP(i,s,p)   specified variable distributions
C  DVAR(i,s,p)    current total variable change
C                    due to active AND inactive parameters
C
C  HESSLS(..)     unconstrained least-squares Hessian matrix
C  CONJAC(..)     constraint-Jacobian matrix in physical space
C
C  BMAT(k,l)      constraint-Jacobian matrix in scaled or eigenvector space
C  SYS(..)        factored constrained-Hessian matrix
C  PRJ(..)        factored projection matrix
C  DPAR(.)        least-squares system righthand side
C
C  HESSOP(..)     approximate unconstrained optimization Hessian matrix
C  EGVEC(..)      Hessian eigenvector matrix (unit, orthogonal)
C  EGVAL(.)       Hessian eigenvalues
C  SEGVAL(.)      sqrt(Hessian eigenvalues)
C  CONDMX         maximum allowable condition number of Hessian
C
C  GSCROW(.)      temporary vectors for setting up Hessian systems
C  GROW(.)
C  VROW(.)
C
C  GVARMS(i,s,p)  rms variable gradient wrt design parameters at location i
C  GCDRMS(p)      rms CD gradient wrt design parameters for point p
C  DELTRY         parameter-perturbation step for interactive scaling

