
      SUBROUTINE EDIT
C-----------------------------------------
C     Design-parameter editing routine.
C-----------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 OPTION, ANS
      LOGICAL NEWTAR, LREF
      CHARACTER*80 FNREF
C
      PARAMETER (NREFX=1000)
      DIMENSION XREF(NREFX), YREF(NREFX)
C
      WRITE(*,*)
      CALL TARGET(NEWTAR)
C
      IF(NEWTAR) THEN
       CALL INITSP(0,0)
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
C
C---- reset user blowup parameters
      CALL CLRZOOM
C
      WRITE(*,5000)
 5000 FORMAT(
     & /' M odify target    => parameters   A ctivate/freeze parameters'
     & /' O ptimize on line => parameters   I mpose/remove constraints'
     & /' D irection for line descent       C lear active parameters'
     & /' Q uasi-Newton toggle              K eyboard parameter input'
     & /' L ift coefficient spec => alphas  W eights for points'
     & /' P oint    target select           B lowup'
     & /' S ide     target select           R eset plot scaling'
     & /' V ariable target select           X coordinate-type change'
     & /' E xternal reference data overlay  H ardcopy current plot'
     & /'                                  aN notate plot' )
C
cccc  F G J T U Y Z
C
 7    CALL PLTINI
      CALL PLTALL(.FALSE.)
      LREF = .FALSE.
C
 8    WRITE(*,1005)
      READ (*,1010) OPTION
 1005 FORMAT(/1X,'Enter mod option: ', $)
 1010 FORMAT(A1)
C
      IF(OPTION.EQ.' ' .OR. OPTION.EQ.'0') THEN
       IF(LPLOT) CALL PLOT(0.0,0.0,-999)
       LPLOT = .FALSE.
       CALL CLRZOOM
       RETURN
      ENDIF
C
      IF(OPTION.EQ.'m' .OR. OPTION.EQ.'M') THEN
C
        IF(IPTARG.NE.0) CALL MODFUN
C
        IF(.NOT.LXHES) CALL HESGEN
        IF(.NOT.LXCON) CALL CONGEN
        IF(.NOT.LXSYS) CALL SYSSET
C
        IF(LXSYS) THEN
         CALL DELLSQ
         CALL SHOPAR
        ENDIF
        GO TO 7
C
      ELSE IF(OPTION.EQ.'o' .OR. OPTION.EQ.'O') THEN
C
        CALL LINMIN
        CALL PLTINI
        CALL PLTALL(.FALSE.)
        LREF = .FALSE.
C
        CALL SHOPAR
C
        IF(LOPSET) THEN
          WRITE(*,1050)
 1050     FORMAT(/1X,'Save optimization step results ?   N ')
          READ (*,1010) ANS
C
          IF(ANS.EQ.'Y' .OR. ANS.EQ.'y') THEN
            CALL HISWRT
            CALL MODWRT
            IF(.NOT.LDSET) THEN
              K = INDEX(CODE,' ') - 1
              WRITE(*,*)
              WRITE(*,*) 'Ready for ',CODE(1:K),' reconvergence'
            ENDIF
          ENDIF
        ENDIF
C
        GO TO 8
C
      ELSE IF(OPTION.EQ.'d' .OR. OPTION.EQ.'D') THEN
C
        CALL DIRSET
        GO TO 8
C
      ELSE IF(OPTION.EQ.'q' .OR. OPTION.EQ.'Q') THEN
C
        LTRNSF = .NOT. LTRNSF
        IF(LTRNSF) THEN
         WRITE(*,*) 'Eigenvector design space will be used ',
     &              '(Quasi-Newton)'
         IF(.NOT.LXQLQ) CALL QLQGET
         IF(.NOT.LXQLQ) CALL QLQINI
        ELSE
         WRITE(*,*) 'Scaled design space will be used ',
     &              '(Steepest-Descent, Conjugate-Gradient)'
        ENDIF
        LPRSET = .TRUE.
        GO TO 8
C
      ELSE IF(OPTION.EQ.'a' .OR. OPTION.EQ.'A') THEN
C
        CALL SHOPAR
        CALL SELPAR
        GO TO 8
C
      ELSE IF(OPTION.EQ.'i' .OR. OPTION.EQ.'I') THEN
C
        CALL SHOCON
        CALL SELCON
        GO TO 8
C
      ELSE IF(OPTION.EQ.'k' .OR. OPTION.EQ.'K') THEN
C
        CALL KEYMOD
        GO TO 7
C
      ELSE IF(OPTION.EQ.'l' .OR. OPTION.EQ.'L') THEN
C
        CALL CLASET
        GO TO 7
C
      ELSE IF(OPTION.EQ.'c' .OR. OPTION.EQ.'C') THEN
C
        CALL CLRMOD(.FALSE.)
        CALL CLRAMR(.FALSE. , 0)
        CALL CLRUSR(.FALSE.)
        CALL INITSP(IPTARG,ISTARG)
        GO TO 7
C
      ELSE IF(OPTION.EQ.'p' .OR. OPTION.EQ.'P') THEN
C
        IPTARG = 999
        CALL TARGET(NEWTAR)
        LXHES = .FALSE.
        LXCON = .FALSE.
        LPRSET = .TRUE.
        GO TO 7
C
      ELSE IF(OPTION.EQ.'s' .OR. OPTION.EQ.'S') THEN
C
        ISTARG = 999
        CALL TARGET(NEWTAR)
        LXHES = .FALSE.
        LPRSET = .TRUE.
        GO TO 7
C
      ELSE IF(OPTION.EQ.'v' .OR. OPTION.EQ.'V') THEN
C
        IVTARG = 999
        CALL TARGET(NEWTAR)
        CALL INITSP(0,0)
        LXHES = .FALSE.
        LPRSET = .TRUE.
        GO TO 7
C
      ELSE IF(OPTION.EQ.'b' .OR. OPTION.EQ.'B') THEN
C
ccc        CALL BLOWUP(.TRUE.)
        CALL USETZOOM(.TRUE.,.TRUE.)
        GO TO 7
C
      ELSE IF(OPTION.EQ.'r' .OR. OPTION.EQ.'R') THEN
C
        CALL CLRZOOM
        GO TO 7
C
      ELSE IF(OPTION.EQ.'x' .OR. OPTION.EQ.'X') THEN
C
        CALL GETXPL
        CALL SETXPL
        GO TO 7
C
      ELSE IF(OPTION.EQ.'h' .OR. OPTION.EQ.'H') THEN
C
        IF(LPLOT) THEN
         CALL REPLOT(IDEVRP)
        ELSE
         WRITE(*,*) 'No active plot'
        ENDIF
        GO TO 8
C
      ELSE IF(OPTION.EQ.'n' .OR. OPTION.EQ.'N') THEN
C
        IF(LPLOT) THEN
         CALL ANNOT(CH)
        ELSE
         WRITE(*,*) 'No active plot'
        ENDIF
        GO TO 8
C
      ELSE IF(OPTION.EQ.'w' .OR. OPTION.EQ.'W') THEN
C
        CALL SHOWGT
        CALL SELWGT
        GO TO 8
C
      ELSE IF(OPTION.EQ.'e' .OR. OPTION.EQ.'E') THEN
C
        LREF = .TRUE.
        NREF = NREFX
        IF(IPTARG.EQ.0) THEN
         IF(LPOLAR) THEN
           WRITE(*,*) 'Enter reference polar filename'
         ELSE
           WRITE(*,*) 'Enter reference sweep filename'
         ENDIF
         READ (*,4000) FNREF
         CALL GETPSW(LPOLAR,FNREF,NREF,XREF,YREF)
        ELSE
         WRITE(*,*) 'Enter x-y reference data filename'
         READ (*,4000) FNREF
         CALL GETREF(FNREF,NREF,XREF,YREF)
        ENDIF
 4000   FORMAT(A80)
C
        SH = 0.6*CH
        IF(IPTARG.EQ.0) THEN
         IS = 1
        ELSE IF(ISTARG.EQ.0) THEN
         IS = 1
        ELSE
         IS = ISTARG
        ENDIF
        CALL XYPLOT(NREF,XREF,YREF,
     &              XOFFV(IS),XSFV(IS),YOFFV(IS),YSFV(IS),
     &              1,SH,5,XLIMV,YLIMV)
        CALL PLFLUSH
        GO TO 8
C
      ELSE
C
        WRITE(*,5000)
        GO TO 8
C
      ENDIF
C
      END ! EDIT


      SUBROUTINE MODFUN
C-------------------------------------------------------------
C     Set up call to modify specified-variable distributions.
C-------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION ILES(ISX), ITES(ISX)
C
      IP = IPTARG
C
C---- fill LE, TE index arrays over sides
      DO 10 IS=1, 2*NBL(IP)
        N = (IS+1)/2
        ILES(IS) = ILEB(N,IP)
        ITES(IS) = ITEB(N,IP)
 10   CONTINUE
C
      IF(ISTARG.EQ.0) THEN
        WRITE(*,*) 'Can modify all sides'
        IS = 1
        NSIDE = 2*NBL(IP)
      ELSE
       IF(L2SIDE) THEN
        WRITE(*,*) 'Can modify either side of target element'
        N = (ISTARG+1)/2
        IS = 2*N - 1
        NSIDE = 2
       ELSE
        WRITE(*,*) 'Can modify target side only'
        IS = ISTARG
        NSIDE = 1
       ENDIF
      ENDIF
C
      CALL MODIFY(IX,ILES(IS),ITES(IS),NSIDE,
     &            XPL(1,IS,IP),VARSP(1,IS,IP),
     &            XLIMV,YLIMV, XOFFV(IS),YOFFV(IS),XSFV(IS),YSFV(IS))
C
      RETURN
      END ! MODFUN


      SUBROUTINE TARGET(NEWTAR)
C----------------------------------------------
C     Asks user for target point, side, and/or 
C     variable if it is currently undefined.
C----------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL NEWTAR
      CHARACTER*1 CVAR
C
      IPOLD = IPTARG
      ISOLD = ISTARG
      IVOLD = IVTARG
C
      IF(NPOINT.EQ.1) THEN
       IPTARG = 1
      ELSE
       IF(IPTARG.EQ.999) THEN
 1      WRITE(*,*) 'Enter target point (0 for whole sweep)'
        READ (*,*,ERR=1) IPTARG
        IF(IPTARG.LT.0 .OR. IPTARG.GT.NPOINT) GO TO 1
cc       ELSE
cc        WRITE(*,1010) IPTARG
cc 1010   FORMAT(' Current target point:', I3)
       ENDIF
      ENDIF
C
      IF(IPTARG.NE.0) IPGSEN = IPTARG
C
      IP = IPTARG
      IF(IPTARG.EQ.0) IP = 1
C
       IF(ISTARG.EQ.999) THEN
 2      WRITE(*,*)
     &   'Enter target side (- for two-side influence, 0 for all)'
        READ (*,*,ERR=2) ISTARG
        L2SIDE = ISTARG .LT. 0
        ISTARG = IABS(ISTARG)
        IF(ISTARG.LT.0 .OR. ISTARG.GT.2*NBL(IP)) GO TO 2
cc       ELSE
cc        IF(L2SIDE) THEN
cc         WRITE(*,1022) ISTARG, (ISTARG+1)/2
cc        ELSE
cc         WRITE(*,1021) ISTARG, (ISTARG+1)/2
cc        ENDIF
cc 1021   FORMAT(' Current target side: ',I3, ', element', I3,
cc     &         '   (one-side influence)')
cc 1022   FORMAT(' Current target side: ',I3, ', element', I3,
cc     &         '   (two-side influence)')
C
        IF(ISTARG.EQ.0 .AND. IXPLT.NE.1) THEN
C------- all-side plotting must be done in cartesian x,y
         IXPLT = 1
         CALL SETXPL
        ENDIF
C
       ENDIF
C
      IF(IVTARG.EQ.999) THEN
ccc 3     WRITE(*,*) 'Enter target variable (Cp Hk Mdef n)'
 3     WRITE(*,*) 'Enter target variable (Cp Hk)'
       READ (*,1000) CVAR
       IF(CVAR.EQ.'c' .OR. CVAR.EQ.'C') THEN
        IVTARG = 1
       ELSE IF(CVAR.EQ.'h' .OR. CVAR.EQ.'H') THEN
        IVTARG = 2
ccc       ELSE IF(CVAR.EQ.'m' .OR. CVAR.EQ.'M') THEN
ccc        IVTARG = 3
ccc       ELSE IF(CVAR.EQ.'n' .OR. CVAR.EQ.'N') THEN
ccc        IVTARG = 4
       ELSE
        GO TO 3
       ENDIF
cc      ELSE
cc       IF(IVTARG.EQ.1) WRITE(*,*) 'Current target variable:  Cp'
cc       IF(IVTARG.EQ.2) WRITE(*,*) 'Current target variable:  Hk'
cc       IF(IVTARG.EQ.3) WRITE(*,*) 'Current target variable:  Mdef'
cc       IF(IVTARG.EQ.4) WRITE(*,*) 'Current target variable:  n'
      ENDIF
C
      NEWTAR = IPTARG.NE.IPOLD
     &    .OR. ISTARG.NE.ISOLD
     &    .OR. IVTARG.NE.IVOLD
C
      RETURN
 1000 FORMAT(A1)
      END ! TARGET



      SUBROUTINE GETXPL
C-----------------------------------------------
C     Gets airfoil plot-axis type from user.
C-----------------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 CXPLT(3), CXNEW
      DATA CXPLT / 'X', 'C', 'S' /
C
      IF(ISTARG.EQ.0) THEN
       WRITE(*,*) 'Plotting X-coordinate options are ',
     &            'for single target element only.'
       RETURN
      ENDIF
C
      WRITE(*,1100) CXPLT(IXPLT)
      READ (*,1200) CXNEW
C
      IF(CXNEW.EQ.'X' .OR. CXNEW.EQ.'x') IXPLT = 1
      IF(CXNEW.EQ.'C' .OR. CXNEW.EQ.'c') IXPLT = 2
      IF(CXNEW.EQ.'S' .OR. CXNEW.EQ.'s') IXPLT = 3
      LPRSET = .TRUE.
C
      RETURN
C
 1100 FORMAT(/'  X   cartesian  X/C'
     &       /'  C   chordline  x/c'
     &       /'  S   arc length s/smax'
     &      //' Enter new coordinate type (currently = ',A1,'): ',$)
 1200 FORMAT(A1)
      END ! GETXPL


      SUBROUTINE SETXPL
C----------------------------------------------------
C     Sets up airfoil plotting limits and parameters.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION CX_POS(NPOSX), CY_POS(NPOSX)
C
      DO 1 IP=1, NPOINT
        DO 10 IS=1, 2*NBL(IP)
          N = (IS+1)/2
          ILE = ILEB(N,IP)
          ITE = ITEB(N,IP)
          IFF = IEND(N,IP)
C
          CHXB = XTEB(N,IP) - XLEB(N,IP)
          CHYB = YTEB(N,IP) - YLEB(N,IP)
          CH2B = CHXB**2 + CHYB**2
          CHB = SQRT(CH2B)
C
          DO 101 K=1, NPOS(IP)
            CX_POS(K) = XBI_POS(ITE,IS,K,IP) - XBI_POS(ILE,IS,K,IP)
            CY_POS(K) = YBI_POS(ITE,IS,K,IP) - YBI_POS(ILE,IS,K,IP)
 101      CONTINUE
C
          IF(IXPLT.EQ.1) THEN
C
            DO 111 I=ILE, IFF-1
              XPL(I,IS,IP) = XBI(I,IS,IP)
              DO 1114 K=1, NPOS(IP)
                XPL_POS(I,IS,K,IP) = XBI_POS(I,IS,K,IP)
 1114         CONTINUE
 111        CONTINUE
            XPL1(IS,IP) = XLEB(N,IP)
            XPL2(IS,IP) = XTEB(N,IP)
            CHPLT(N,IP) = CHXB
            AGPLT(N,IP) = 0.0
C
          ELSE IF(IXPLT.EQ.2) THEN
C
            DO 121 I=ILE, IFF-1
              XPL(I,IS,IP) = (XBI(I,IS,IP)-XLEB(N,IP))*CHXB/CHB
     &                     + (YBI(I,IS,IP)-YLEB(N,IP))*CHYB/CHB
     &                     + XLEB(N,IP)
              DO 1214 K=1, NPOS(IP)
                XPL_POS(I,IS,K,IP) =
     &     (XBI_POS(I,IS,K,IP) - XBI_POS(ILE,IS,K,IP))*CHXB/CHB
     &   + (YBI_POS(I,IS,K,IP) - YBI_POS(ILE,IS,K,IP))*CHYB/CHB
     &                     + (XBI(I,IS,IP)-XLEB(N,IP))*CX_POS(K)/CHB
     &                     + (YBI(I,IS,IP)-YLEB(N,IP))*CY_POS(K)/CHB
     &                     + XBI_POS(ILE,IS,K,IP)
 1214         CONTINUE
 121        CONTINUE
            XPL1(IS,IP) = XLEB(N,IP)
            XPL2(IS,IP) = XLEB(N,IP) + CHB
            CHPLT(N,IP) = CHB
            AGPLT(N,IP) = ATAN2(CHYB,CHXB)
C
          ELSE IF(IXPLT.EQ.3) THEN
C
            DO 131 I=ILE, IFF-1
              XPL(I,IS,IP) = SBI(I,IS,IP) - SBI(ILE,IS,IP)
     &                     + XLEB(N,IP)
              DO 1314 K=1, NPOS(IP)
                XPL_POS(I,IS,K,IP) = 
     &                       SBI_POS(I,IS,K,IP) - SBI_POS(ILE,IS,K,IP)
     &                     + XBI_POS(ILE,IS,K,IP)
 1314         CONTINUE
 131        CONTINUE
            XPL1(IS,IP) = XPL(ILE,IS,IP)
            XPL2(IS,IP) = XPL(ITE,IS,IP)
            CHPLT(N,IP) = CHB
            AGPLT(N,IP) = ATAN2(CHYB,CHXB)
C
          ENDIF
 10     CONTINUE
 1    CONTINUE
C
      RETURN
      END ! SETXPL



      SUBROUTINE DELVAR(IPOINT,ISIDE)
C--------------------------------------------------
C     Sets current total change in surface variable.
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      IV = IVTARG
C
      IF(IPOINT.EQ.0) THEN
       IP1 = 1
       IP2 = NPOINT
      ELSE
       IP1 = IPOINT
       IP2 = IPOINT
      ENDIF
C
      DO 1 IP=IP1, IP2
C
        IF(ISIDE.EQ.0) THEN
         IS1 = 1
         IS2 = 2*NBL(IP)
        ELSE
         N = (ISIDE+1)/2
         IS1 = 2*N-1
         IS2 = 2*N
        ENDIF
C
        DREYN = DLNRE(IP)*REYN(IP)
        DO 10 IS=IS1, IS2
          N = (IS+1)/2
C
          DO 100 I=ILEB(N,IP), ITEB(N,IP)
C
            DVSUM = VAR_ALFA(I,IS,IP,IV)*DALFA(IP)
     &            + VAR_MACH(I,IS,IP,IV)*DMACH(IP)
     &            + VAR_REYN(I,IS,IP,IV)*DREYN
C
            DO 1002 K=1, NMOD(IP)
              DVSUM = DVSUM + VAR_MOD(I,IS,K,IP,IV)*DMOD(K,IP)
 1002       CONTINUE
C
            DO 1004 K=1, NPOS(IP)
              DVSUM = DVSUM + VAR_POS(I,IS,K,IP,IV)*DPOS(K,IP)
 1004       CONTINUE
C
            DVAR(I,IS,IP) = DVSUM
C
 100      CONTINUE
 10     CONTINUE
 1    CONTINUE
C
      RETURN
      END ! DELVAR


      SUBROUTINE INITSP(IPOINT,ISIDE)
C--------------------------------------------------
C     Initializes specified-variable distributions
C     to current modified distributions.
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      CALL DELVAR(IPOINT,ISIDE)
C
      IV = IVTARG
C
      IF(IPOINT.EQ.0) THEN
       IP1 = 1
       IP2 = NPOINT
      ELSE
       IP1 = IPOINT
       IP2 = IPOINT
      ENDIF
C
      DO 1 IP=IP1, IP2
C
        IF(ISIDE.EQ.0) THEN
         IS1 = 1
         IS2 = 2*NBL(IP)
        ELSE
         N = (ISIDE+1)/2
         IS1 = 2*N-1
         IS2 = 2*N
        ENDIF
C
        DO 10 IS=IS1, IS2
          N = (IS+1)/2
          DO 100 I=ILEB(N,IP), ITEB(N,IP)
            VARSP(I,IS,IP) = VAR(I,IS,IP,IV) + DVAR(I,IS,IP)
 100      CONTINUE
 10     CONTINUE
 1    CONTINUE
C
      RETURN
      END ! INITSP



      SUBROUTINE HESGEN
C--------------------------------------------------
C     Computes the unconstrained Hessian matrix of 
C     the least-squares integral of variable VAR
C     over the airfoil surface(s).
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      WRITE(*,*) 'Generating Hessian matrix...'
C
C---- set active-parameter pointers to Hessian-matrix columns
      IF(.NOT.LXPAR) CALL KHES
C
C---- clear entire Hessian matrix
      DO 2 L=1, NHES
        DO 2 K=1, NHES
          HESSLS(K,L) = 0.0
 2    CONTINUE
C
C
      IV = IVTARG
C
      IF(IPTARG.EQ.0) THEN
        IP1 = 1
        IP2 = NPOINT
      ELSE
        IP1 = IPTARG
        IP2 = IPTARG
      ENDIF
C
C---- loop over points, adding weighted Hessian contributions
      DO 90 IP=IP1, IP2
C
      IF(ISTARG.EQ.0) THEN
        IS1 = 1
        IS2 = 2*NBL(IP)
        WV = WP(IP)
      ELSE
        IF(L2SIDE) THEN
         N = (ISTARG+1)/2
         IS1 = 2*N-1
         IS2 = 2*N
        ELSE
         IS1 = ISTARG
         IS2 = ISTARG
        ENDIF
        WV = 1.0
      ENDIF
C
C---- skip this point if its weight is zero
      IF(WV .EQ. 0.0) GO TO 90
C
C---- integrate each column vector entry with VAR_? weight functions
      DO 10 K=1, NMOD(IP)
        IF(LMOD(K,IP)) THEN
         LCOL = KHESMOD(K,IP)
         DO 105 IS=IS1, IS2
           CALL VARDOT(IP,IS,IV,WV,VAR_MOD(1,IS,K,IP,IV),HESSLS(1,LCOL))
 105     CONTINUE
        ENDIF
 10   CONTINUE
C
      DO 20 K=1, NPOS(IP)
        IF(LPOS(K,IP)) THEN
         LCOL = KHESPOS(K,IP)
         DO 205 IS=IS1, IS2
           CALL VARDOT(IP,IS,IV,WV,VAR_POS(1,IS,K,IP,IV),HESSLS(1,LCOL))
 205     CONTINUE
        ENDIF
 20   CONTINUE
C
      IF(LALFA(IP)) THEN
       LCOL = KHESAL(IP)
       DO 31 IS=IS1, IS2
         CALL VARDOT(IP,IS,IV,WV,VAR_ALFA(1,IS,IP,IV),HESSLS(1,LCOL))
 31    CONTINUE
      ENDIF
C
      IF(LMACH(IP)) THEN
       LCOL = KHESMA(IP)
       DO 32 IS=IS1, IS2
         CALL VARDOT(IP,IS,IV,WV,VAR_MACH(1,IS,IP,IV),HESSLS(1,LCOL))
 32    CONTINUE
      ENDIF
C
      IF(LREYN(IP)) THEN
       LCOL = KHESLR(IP)
       WVRE = WV*REYN(IP)
       DO 33 IS=IS1, IS2
         CALL VARDOT(IP,IS,IV,WVRE,VAR_REYN(1,IS,IP,IV),HESSLS(1,LCOL))
 33    CONTINUE
      ENDIF
C
 90   CONTINUE
C
      LXHES = .TRUE.
      LXSYS = .FALSE.
      RETURN
      END ! HESGEN



      SUBROUTINE CONGEN
C-------------------------------------------------
C     Calculates constraint residual derivatives
C     which will augment the Hessian matrix.
C     Also calculates current user-defined
C     constraint residuals and current changes.
C-------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION
     &   UC_MACH(NPX), 
     &   UC_ALFA(NPX), 
     &   UC_REYN(NPX),
     &   UC_MOD(NMODX,NPX),
     &   UC_POS(NPOSX,NPX),
     &   UC_CL(NPX) ,
     &   UC_CM(NPX) ,
     &   UC_CDF(NPX),
     &   UC_CDP(NPX),
     &   UC_ARB(NBX,NPX),
     &   UC_EI1(NBX,NPX),
     &   UC_ASG(NBX,NPX),
     &   UC_THB(0:NTHX,NBX,NPX),
     &   UC_UPAR(NUPX)
C
C
      WRITE(*,*) 'Generating constraint Jacobian matrix ...'
C
C---- set pointers to constraint-matrix columns
      CALL KCON
C
C---- clear entire constraint coefficient matrix
      DO 5 L=1, NCON
        DO 5 K=1, NHES
          CONJAC(K,L) = 0.0
 5    CONTINUE
C
C
C---- set additional columns for Lagrange multipliers,
C-    and additional rows for constraint equations
      IP = IPGSEN
C
      DO 10 IS=1, 2*NBL(IP)
        N = (IS+1)/2
C
C------ left slope constraint:  Res = slope
        LCOL = KCONSL(IS)
        DO 102 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + SLL_MOD(K,IS,IP)
          ENDIF
 102    CONTINUE
C
C------ right slope constraint:  Res = slope
        LCOL = KCONSR(IS)
        DO 103 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + SLR_MOD(K,IS,IP)
          ENDIF
 103    CONTINUE
 10   CONTINUE
C
      DO 20 N=1, NBL(IP)
        IS1 = 2*N-1
        IS2 = 2*N
C
C------ LE curvature constraint:  Res = curv - curv_spec
        LCOL = KCONCV(N)
        DO 201 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CVLE_MOD(K,N,IP)
          ENDIF
 201    CONTINUE
C
C------ left angle constraint:  Res = angle - angle_spec
        LCOL = KCONAL(N)
        DO 202 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + AGL_MOD(K,N,IP)
          ENDIF
 202    CONTINUE
C
C------ right angle constraint:  Res = angle - angle_spec
        LCOL = KCONAR(N)
        DO 203 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + AGR_MOD(K,N,IP)
          ENDIF
 203    CONTINUE
C
        DO 205 ITH=0, NTHFIX(N)
C-------- thickness constraint:  Res = Th - Th_spec
          LCOL = KCONTH(ITH,N)
          DO 2052 K=1, NMOD(IP)
            KROW = KHESMOD(K,IP)
            CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + THB_MOD(K,ITH,N,IP)
 2052     CONTINUE
 205    CONTINUE
C
C------ area constraint:  Res = Area - Area_spec
        LCOL = KCONAB(N)
        DO 206 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + ARB_MOD(K,N,IP)
          ENDIF
 206    CONTINUE
C
C------ skin strain constraint:  Res = strain - strain_spec
        LCOL = KCONSG(N)
        DO 207 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + ASG_MOD(K,N,IP)
          ENDIF
 207    CONTINUE
C
C------ EI constraint:  Res = EI - EI_spec
        LCOL = KCONEI(N)
        DO 208 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + EI1_MOD(K,N,IP)
          ENDIF
 208    CONTINUE
 20   CONTINUE
C
      DO 100 IP=1, NPOINT
C
      IF(LCLFIX(IP)) THEN
C------ CL constraint:  Res = CL - CL_spec
        LCOL = KCONCL(IP)
C
        DO 31 K=1, NMOD(IP)
          KROW = KHESMOD(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CL_MOD(K,IP)
 31     CONTINUE
C
        DO 32 K=1, NPOS(IP)
          KROW = KHESPOS(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CL_POS(K,IP)
 32     CONTINUE
C
        KROW = KHESAL(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CL_ALFA(IP)
C
        KROW = KHESMA(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CL_MACH(IP)
C
        KROW = KHESLR(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CL_REYN(IP)*REYN(IP)
      ENDIF
C
C
      IF(LCMFIX(IP)) THEN
C------ CM constraint:  Res = CM - CM_spec
        LCOL = KCONCM(IP)
C
        DO 41 K=1, NMOD(IP)
          KROW = KHESMOD(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CM_MOD(K,IP)
 41     CONTINUE
C
        DO 42 K=1, NPOS(IP)
          KROW = KHESPOS(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CM_POS(K,IP)
 42     CONTINUE
C
        KROW = KHESAL(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CM_ALFA(IP)
C
        KROW = KHESMA(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CM_MACH(IP)
C
        KROW = KHESLR(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + CM_REYN(IP)*REYN(IP)
C
      ENDIF
C
C
      IF(LMAFIX(IP)) THEN
C------ Mach-CL constraint:    Res = Ma*sqrt(CL) - Ma1
        SQCL = SQRT( ABS(CL(IP)) )
        RES_CL = 0.5*MACH(IP)/SQCL * SIGN( 1.0 , CL(IP) )
        RES_MA =              SQCL
C
        LCOL = KCONMA(IP)
C
        DO 51 K=1, NMOD(IP)
          KROW = KHESMOD(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_MOD(K,IP)
 51     CONTINUE
C
        DO 52 K=1, NPOS(IP)
          KROW = KHESPOS(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_POS(K,IP)
 52     CONTINUE
C
        KROW = KHESAL(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_ALFA(IP)
C
        KROW = KHESMA(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_MACH(IP)
     &                                        + RES_MA
C
        KROW = KHESLR(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_REYN(IP)
     &                                                   *REYN(IP)
C
      ENDIF
C
C
      IF(LREFIX(IP)) THEN
C------ Re-CL constraint:    Res = Re*sqrt(CL) - Re1
        SQCL = SQRT( ABS(CL(IP)) )
        RES_CL = 0.5*REYN(IP)/SQCL * SIGN( 1.0 , CL(IP) )
        RES_RE =              SQCL
C
        LCOL = KCONRE(IP)
C
        DO 56 K=1, NMOD(IP)
          KROW = KHESMOD(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_MOD(K,IP)
 56     CONTINUE
C
        DO 57 K=1, NPOS(IP)
          KROW = KHESPOS(K,IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_POS(K,IP)
 57     CONTINUE
C
        KROW = KHESAL(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_ALFA(IP)
C
        KROW = KHESMA(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_MACH(IP)
C
        KROW = KHESLR(IP)
        CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + RES_CL*CL_REYN(IP)
     &                                                   *REYN(IP)
     &                                        + RES_RE   *REYN(IP)
C
      ENDIF
C
C
 100  CONTINUE
C
C---- user constraints
      DO 200 ICON=1, NUCON
        IF(.NOT.LUCFIX(ICON)) GO TO 200
C
        CALL UCDIFF(NTHX,NBX,NBL,NUPAR,NPOINT,
     &              NMODX,NMOD,NPOSX,NPOS,
     &              ICON,UCNAME(ICON), UCRES(ICON),
     &              UPAR, UC_UPAR, EPUPAR,
     &              ALFA, UC_ALFA,
     &              MACH, UC_MACH,
     &              REYN, UC_REYN,
     &              CL  , UC_CL ,
     &              CDF , UC_CDF,
     &              CDP , UC_CDP,
     &              CM  , UC_CM ,
     &              AREAB, UC_ARB,
     &              EI11B, UC_EI1,
     &              ASIGB, UC_ASG,
     &              THIKB, UC_THB,
     &              MODN, UC_MOD,
     &              POSN, UC_POS )
C
        LCOL = KCONUC(ICON)
        DUCRES(ICON) = 0.
C
C
        DO 64 IP=1, NPOINT
C
          DO K=1, NMOD(IP)
            KROW = KHESMOD(K,IP)
            DO N=1, NBL(IP)
              UCP_MOD = UC_ARB(N,IP)*ARB_MOD(K,N,IP)
     &                + UC_EI1(N,IP)*EI1_MOD(K,N,IP)
     &                + UC_ASG(N,IP)*ASG_MOD(K,N,IP)
              CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_MOD
              DUCRES(ICON)      = DUCRES(ICON)      + UCP_MOD*DMOD(K,IP)
            ENDDO
          ENDDO
C
          KROW = KHESAL(IP)
          UCP_ALFA = UC_CL (IP)* CL_ALFA(IP)
     &             + UC_CDF(IP)*CDF_ALFA(IP)
     &             + UC_CDP(IP)*CDP_ALFA(IP)
     &             + UC_CM (IP)* CM_ALFA(IP)
     &             +             UC_ALFA(IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_ALFA
          DUCRES(ICON)      = DUCRES(ICON)      + UCP_ALFA*DALFA(IP)
C
          KROW = KHESMA(IP)
          UCP_MACH = UC_CL (IP)* CL_MACH(IP)
     &             + UC_CDF(IP)*CDF_MACH(IP)
     &             + UC_CDP(IP)*CDP_MACH(IP)
     &             + UC_CM (IP)* CM_MACH(IP)
     &             +             UC_MACH(IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_MACH
          DUCRES(ICON)      = DUCRES(ICON)      + UCP_MACH*DMACH(IP)
C
          KROW = KHESLR(IP)
          UCP_REYN = UC_CL (IP)* CL_REYN(IP)
     &             + UC_CDF(IP)*CDF_REYN(IP)
     &             + UC_CDP(IP)*CDP_REYN(IP)
     &             + UC_CM (IP)* CM_REYN(IP)
     &             +             UC_REYN(IP)
          UCP_LNRE = UCP_REYN*REYN(IP)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_LNRE
          DUCRES(ICON)      = DUCRES(ICON)      + UCP_LNRE*DLNRE(IP)
C
C
          DO 641 K=1, NMOD(IP)
            KROW = KHESMOD(K,IP)
            UCP_MOD = UC_CL (IP)* CL_MOD(K,IP)
     &              + UC_CDF(IP)*CDF_MOD(K,IP)
     &              + UC_CDP(IP)*CDP_MOD(K,IP)
     &              + UC_CM (IP)* CM_MOD(K,IP)
     &              +             UC_MOD(K,IP)
            DO N = 1, NBL(IP)
              DO ITH=0, NTHFIX(N)
                UCP_MOD = UCP_MOD + UC_THB(ITH,N,IP)*THB_MOD(K,ITH,N,IP)
              ENDDO
            ENDDO
C
            CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_MOD
            DUCRES(ICON)      = DUCRES(ICON)      + UCP_MOD*DMOD(K,IP)
 641      CONTINUE
C
          DO 642 K=1, NPOS(IP)
            KROW = KHESPOS(K,IP)
            UCP_POS = UC_CL (IP)* CL_POS(K,IP)
     &              + UC_CDF(IP)*CDF_POS(K,IP)
     &              + UC_CDP(IP)*CDP_POS(K,IP)
     &              + UC_CM (IP)* CM_POS(K,IP)
     &              +             UC_POS(K,IP)
            CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UCP_POS
            DUCRES(ICON)      = DUCRES(ICON)      + UCP_POS*DPOS(K,IP)
 642      CONTINUE
C
 64     CONTINUE
C
        DO 67 K=1, NUPAR
          KROW = KHESUP(K)
          CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + UC_UPAR(K)
          DUCRES(ICON)      = DUCRES(ICON)      + UC_UPAR(K)*DUPAR(K)
 67     CONTINUE
C
 200  CONTINUE
C
C
C---- Hk constraints:  Res = HK - HK_spec
      DO 300 J=1, NHKFIX
        IF(LHKFIX(J)) THEN
C
         IP = IPHFIX(J)
         IS = ISHFIX(J)
         N = (IS+1)/2
C
         LCOL = KCONHK(J)
C
         DO 71 K=1, NMOD(IP)
           KROW = KHESMOD(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + HKL_MOD(K,J)
 71      CONTINUE
C
         DO 72 K=1, NPOS(IP)
           KROW = KHESPOS(K,IP)
           CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + HKL_POS(K,J)
 72      CONTINUE
C
         KROW = KHESAL(IP)
         CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + HKL_ALFA(J)
C
         KROW = KHESMA(IP)
         CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + HKL_MACH(J)
C
         KROW = KHESLR(IP)
         CONJAC(KROW,LCOL) = CONJAC(KROW,LCOL) + HKL_REYN(J)*REYN(IP)
C
        ENDIF
 300  CONTINUE
C
      LXCON = .TRUE.
      LXSYS = .FALSE.
      RETURN
      END ! CONGEN


      SUBROUTINE KHES
C------------------------------------------
C     Calculates pointers for all active
C     parameters to Hessian matrix columns.
C     Also sets Hessian matrix size NHES.
C------------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*10 DIGITS
      DATA DIGITS / '0123456789' /
C
C---- clear all pointers first
      DO 1 IP=1, NPX
        DO 12 K=1, NMODX
          KHESMOD(K,IP) = 0
 12     CONTINUE
        DO 14 K=1, NPOSX
          KHESPOS(K,IP) = 0
 14     CONTINUE
C
        KHESAL(IP) = 0
        KHESMA(IP) = 0
        KHESLR(IP) = 0
 1    CONTINUE
C
      DO 5 K=1, NUPX
        KHESUP(K) = 0
 5    CONTINUE
C
      KH = 0
C
C---- set element geometry pointer... if LNKMOD=t, tie them to first point
      DO 20 IP=1, NPOINT
        DO 204 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
C
           IF(LNKMOD) THEN
C---------- look back through operating points for pointer for this mode
            DO 2041 JP=IP-1, 1, -1
              IF(KHESMOD(K,JP) .NE. 0) THEN
               KHESMOD(K,IP) = KHESMOD(K,JP)
               GO TO 204
              ENDIF
 2041       CONTINUE
           ENDIF
C
C--------- set new pointer if one wasn't found
           KH = KH + 1
           KHESMOD(K,IP) = KH
C
           K3 =  K/100
           K2 = (K - 100*K3)/10
           K1 =  K - 100*K3 - 10*K2
           K3 = K3 + 1
           K2 = K2 + 1
           K1 = K1 + 1
           IF(K3 .EQ. 0) THEN
             DPNAME(KH) = 'MOD  ' // DIGITS(K2:K2) // DIGITS(K1:K1)
           ELSE
             DPNAME(KH) = 'MOD ' 
     &           // DIGITS(K3:K3) // DIGITS(K2:K2) // DIGITS(K1:K1)
           ENDIF
C
          ENDIF
 204    CONTINUE
 20   CONTINUE
C
C
C---- rest of operating points... if LNKPOS=t, tie them to first point
      DO 30 IP=1, NPOINT
        DO 304 K=1, NPOS(IP)
          IF(LPOS(K,IP)) THEN
C
           IF(LNKPOS) THEN
C---------- look back through operating points for pointer for this mode
            DO 3041 JP=IP-1, 1, -1
              IF(KHESPOS(K,JP) .NE. 0) THEN
               KHESPOS(K,IP) = KHESPOS(K,JP)
               GO TO 304
              ENDIF
 3041       CONTINUE
           ENDIF
C
C--------- set new pointer if one wasn't found
           KH = KH + 1
           KHESPOS(K,IP) = KH
C
           K3 =  K/100
           K2 = (K - 100*K3)/10
           K1 =  K - 100*K3 - 10*K2
           K3 = K3 + 1
           K2 = K2 + 1
           K1 = K1 + 1
           IF(K3 .EQ. 0) THEN
             DPNAME(KH) = 'POS  ' // DIGITS(K2:K2) // DIGITS(K1:K1)
           ELSE
             DPNAME(KH) = 'POS ' 
     &           // DIGITS(K3:K3) // DIGITS(K2:K2) // DIGITS(K1:K1)
           ENDIF
C
          ENDIF
 304    CONTINUE
 30   CONTINUE
C
C
      DO 42 IP=1, NPOINT
        IF(LALFA(IP)) THEN
         KH = KH + 1
         KHESAL(IP) = KH
         K2 =          IP/10   + 1
         K1 = IP - 10*(IP/10)  + 1
         DPNAME(KH) = 'ALFA ' // DIGITS(K2:K2) // DIGITS(K1:K1)
        ENDIF
 42   CONTINUE
C
      DO 44 IP=1, NPOINT
        IF(LMACH(IP)) THEN
         KH = KH + 1
         KHESMA(IP) = KH
         K2 =          IP/10   + 1
         K1 = IP - 10*(IP/10)  + 1
         DPNAME(KH) = 'MACH ' // DIGITS(K2:K2) // DIGITS(K1:K1)
        ENDIF
 44   CONTINUE
C
      DO 46 IP=1, NPOINT
        IF(LREYN(IP)) THEN
         KH = KH + 1
         KHESLR(IP) = KH
         K2 =          IP/10   + 1
         K1 = IP - 10*(IP/10)  + 1
         DPNAME(KH) = 'LNRE ' // DIGITS(K2:K2) // DIGITS(K1:K1)
        ENDIF
 46   CONTINUE
C
      DO 50 K=1, NUPAR
        IF(LUPAR(K)) THEN
         KH = KH + 1
         KHESUP(K) = KH
         DPNAME(KH) = UPNAME(K)
        ENDIF
 50   CONTINUE
C
C---- size of unconstrained Hessian matrix
      NHES = KH
C
      IF(NHES.GT.NHESX) STOP 'KHES:  Array overflow.  Increase NHESX.'
C
C---- number of active parameters
      NPAR = NHES
C
      LXPAR = .TRUE.
C
      RETURN
      END ! KHES


      SUBROUTINE KCON
C------------------------------------------
C     Calculates pointers for all active
C     constraint Lagrange multipliers.
C------------------------------------------
      INCLUDE 'LINDOP.INC'
C
C---- clear all pointers first
      DO 4 N=1, NBX
        IS1 = 2*N-1
        IS2 = 2*N
        KCONSL(IS1) = 0
        KCONSL(IS2) = 0
        KCONSR(IS1) = 0
        KCONSR(IS2) = 0
        KCONCV(N) = 0
        KCONAL(N) = 0
        KCONAR(N) = 0
        KCONAB(N) = 0
        KCONSG(N) = 0
        KCONEI(N) = 0
        DO 42 ITH=1, NTHX
          KCONTH(ITH,N) = 0
 42     CONTINUE
 4    CONTINUE
C
      DO 6 IP=1, NPX
        KCONCL(IP) = 0
        KCONCM(IP) = 0
        KCONMA(IP) = 0
        KCONRE(IP) = 0
 6    CONTINUE
C
      DO 8 ICON=1, NUCX
        KCONUC(ICON) = 0
 8    CONTINUE
C
      DO 9 J=1, NHKX
        KCONHK(J) = 0
 9    CONTINUE
C
C
      KC = 0
C
C---- slope, thickness and area constraints for geometry-sensitivity point
      IP = IPGSEN
C
      DO 10 IS=1, 2*NBL(IP)
        IF(LSLFIX(IS)) THEN
          KC = KC + 1
          KCONSL(IS) = KC
        ENDIF
C
        IF(LSRFIX(IS)) THEN
          KC = KC + 1
          KCONSR(IS) = KC
        ENDIF
 10   CONTINUE
C
      DO 20 N=1, NBL(IP)
        IF(LCVFIX(N)) THEN
          KC = KC + 1
          KCONCV(N) = KC
        ENDIF
C
        IF(LALFIX(N)) THEN
          KC = KC + 1
          KCONAL(N) = KC
        ENDIF
C
        IF(LARFIX(N)) THEN
          KC = KC + 1
          KCONAR(N) = KC
        ENDIF
C
        DO 205 ITH=0, NTHFIX(N)
          IF(LTHFIX(ITH,N)) THEN
            KC = KC + 1
            KCONTH(ITH,N) = KC
          ENDIF
 205    CONTINUE
C
        IF(LABFIX(N)) THEN
          KC = KC + 1
          KCONAB(N) = KC
        ENDIF
C
        IF(LSGFIX(N)) THEN
          KC = KC + 1
          KCONSG(N) = KC
        ENDIF
C
        IF(LEIFIX(N)) THEN
          KC = KC + 1
          KCONEI(N) = KC
        ENDIF
 20   CONTINUE
C
C---- CL and CM constraints possibly for all points
      DO 100 IP=1, NPOINT
C
      IF(LCLFIX(IP)) THEN
        KC = KC + 1
        KCONCL(IP) = KC
      ENDIF
C
      IF(LCMFIX(IP)) THEN
        KC = KC + 1
        KCONCM(IP) = KC
      ENDIF
C
      IF(LMAFIX(IP)) THEN
        KC = KC + 1
        KCONMA(IP) = KC
      ENDIF
C
      IF(LREFIX(IP)) THEN
        KC = KC + 1
        KCONRE(IP) = KC
      ENDIF
C
 100  CONTINUE
C
      DO 200 ICON=1, NUCON
        IF(LUCFIX(ICON)) THEN
          KC = KC + 1
          KCONUC(ICON) = KC
        ENDIF
 200  CONTINUE
C
      DO 300 J=1, NHKFIX
        IF(LHKFIX(J)) THEN
          KC = KC + 1
          KCONHK(J) = KC
        ENDIF
 300  CONTINUE
C
C---- number of constraints
      NCON = KC
C
      IF(NCON.GT.NCONX) STOP 'KCON: Array overflow. Increase NCONX.'
C
      RETURN
      END ! KCON



      SUBROUTINE SYSSET
C---------------------------------------------
C     Sets up and factors system matrix for
C     active-parameter changes by augmenting
C     basic Hessian with constraint Jacobian.
C---------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION SYS1(NSYSX,NSYSX)
      LOGICAL LSING
C
C---- size of overall constrained system
      NSYS = NHES + NCON
      IF(NSYS.GT.NSYSX) STOP 'SYSSET:  Array overflow. Increase NSYSX.'
C
      DO 5 L=1, NSYS
        DO 5 K=1, NSYS
          SYS(K,L) = 0.0
 5    CONTINUE
C
C---- fill in unconstrained Hessian part
      DO 10 L=1, NHES
        DO 10 K=1, NHES
          SYS(K,L) = HESSLS(K,L)
 10   CONTINUE
C
C---- fill in Lagrange multiplier columns and constraint rows
C-    with constraint-Jacobian matrix
      DO 20 L=1, NCON
        DO 20 K=1, NHES
          SYS(K     ,L+NHES) = CONJAC(K,L)
          SYS(L+NHES,K     ) = CONJAC(K,L)
 20   CONTINUE
C
c      write(*,*)
c      do 66 k=1, nsys
c        write(*,6666) (sys(k,l),l=1, nsys)
c 6666   format(/1x,20f8.2)
c 66   continue
c
C---- check for any unconstrained parameters or Lagrange multipliers
      CALL SYSCHK
C
      IF(NCON .GT. NHES) THEN
       WRITE(*,1020) NCON, NHES
 1020  FORMAT(/' Number of constraints (', I2,')',
     & '  >  number of free parameters (', I2,').'
     &        /' Cannot solve system.')
       LXSYS = .FALSE.
       RETURN
      ENDIF
C
      DO 25 L=1, NSYS
        DO 25 K=1, NSYS
          SYS1(K,L) = SYS(K,L)
 25   CONTINUE
C
C---- LU-factor system matrix
      WRITE(*,*) 'Factoring constrained Hessian matrix ...'
C
      CALL LUDCMP(NSYSX,NSYS,SYS,SYSPIV,LSING)
C
      IF(LSING) THEN
C
        CALL SHOBLK(SYS1,NSYSX,NSYS,NSYS,NHES,6)
C
        WRITE(*,*)
        WRITE(*,*)    '*** Singular constrained Hessian matrix ***'
        WRITE(*,1050) 'Equation   rows:', 1, NHES
        WRITE(*,1050) 'Constraint rows:', NHES+1, NSYS
        WRITE(*,*)
        WRITE(*,*) 'Least-squares problem not solved.'
 1050   FORMAT(1X,A,2X,I3,' - ',I3)
        LXSYS = .FALSE.
      ELSE
        LXSYS = .TRUE.
      ENDIF
C
      RETURN
      END ! SYSSET


      SUBROUTINE SYSCHK
C----------------------------------------------------------------
C     Checks all columns of augmented Hessian matrix.
C     Any all-zero column gets a "1" on its diagonal entry.
C     This fixes any unconstrained variables which might exist
C     due to poor objective-function definition by user.
C----------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      IF(LNKMOD) THEN
       IF(IPTARG.NE.0) THEN
        IP1 = IPTARG
        IP2 = IPTARG
       ELSE
        IP1 = 1
        IP2 = 1
       ENDIF
      ELSE
       IP1 = 1
       IP2 = NPOINT
      ENDIF
      DO 1 IP=IP1, IP2
        DO 11 K=1, NMOD(IP)
          LCOL = KHESMOD(K,IP)
          IF(LCOL.EQ.0) GO TO 11
          DO 112 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 11
 112      CONTINUE
C
          WRITE(*,1010) K, IP
 1010     FORMAT(1X,
     &        'No dependence on geometry mode',I3,', point',I3,'  ...',
     &        '  Adding fixing constraint.')
          SYS(LCOL,LCOL) = 1.0
 11     CONTINUE
 1    CONTINUE
C
      IF(LNKPOS) THEN
       IF(IPTARG.NE.0) THEN
        IP1 = IPTARG
        IP2 = IPTARG
       ELSE
        IP1 = 1
        IP2 = 1
       ENDIF
      ELSE
       IP1 = 1
       IP2 = NPOINT
      ENDIF
c
      DO 2 IP=IP1, IP2
        DO 21 K=1, NPOS(IP)
          LCOL = KHESPOS(K,IP)
          IF(LCOL.EQ.0) GO TO 21
          DO 212 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 21
 212      CONTINUE
C
          WRITE(*,1020) K, IP
 1020     FORMAT(1X,
     &        'No dependence on position mode',I3,', point',I3,'  ...',
     &        '  Adding fixing constraint.')
          SYS(LCOL,LCOL) = 1.0
 21     CONTINUE
 2    CONTINUE
C
C
      DO 3 IP=1, NPOINT
C
        LCOL = KHESAL(IP)
        IF(LCOL.EQ.0) GO TO 319
          DO 312 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 319
 312      CONTINUE
C
          WRITE(*,1031) IP
 1031     FORMAT(1X,'No dependence on Alfa(point',I3,') ...',
     &              '  Adding fixing constraint for now.'
     &       /1X,' Can add CL constraint instead.')
          SYS(LCOL,LCOL) = 1.0
 319    CONTINUE
C
        LCOL = KHESMA(IP)
          IF(LCOL.EQ.0) GO TO 329
          DO 322 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 329
 322      CONTINUE
C
          WRITE(*,1032) IP
 1032     FORMAT(1X,'No dependence on Mach(point',I3,') ...',
     &              '  Adding fixing constraint.')
          SYS(LCOL,LCOL) = 1.0
 329    CONTINUE
C
        LCOL = KHESLR(IP)
        IF(LCOL.EQ.0) GO TO 339
          DO 332 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 339
 332      CONTINUE
C
          WRITE(*,1033) IP
 1033     FORMAT(1X,'No dependence on Re(point',I3,') ...',
     &              '  Adding fixing constraint.')
          SYS(LCOL,LCOL) = 1.0
 339    CONTINUE
C
 3    CONTINUE
C
C
      DO 4 K=1, NUPAR
        LCOL = KHESUP(K)
        IF(LCOL.EQ.0) GO TO 4
C
        DO 412 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 4
 412    CONTINUE
C
        WRITE(*,1041) K, UPNAME(K)
 1041   FORMAT(1X,'No dependence on user-param.',I3,'  (',A,') ...',
     &            '  Adding fixing constraint.')
        SYS(LCOL,LCOL) = 1.0
 4    CONTINUE
C
C
C---- slope constraints
      IP = 1
      DO 5 IS=1, 2*NBL(IP)
        LCOL = KCONSL(IS) + NHES
        IF(LCOL.LE.NHES) GO TO 519
C
        DO 512 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 519
 512    CONTINUE
C
        WRITE(*,1051) IS
 1051   FORMAT(1X,'No influence of left slope constraint, side',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 519    CONTINUE
C
C
        LCOL = KCONSR(IS) + NHES
        IF(LCOL.LE.NHES) GO TO 529
C
        DO 522 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 529
 522    CONTINUE
C
        WRITE(*,1052) IS
 1052   FORMAT(1X,'No influence of right slope constraint, side',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 529    CONTINUE
C
 5    CONTINUE
C
C
C---- curvature, angle, and thickness constraints
      IP = IPGSEN
      DO 6 N=1, NBL(IP)
C
        LCOL = KCONCV(N) + NHES
        IF(LCOL.LE.NHES) GO TO 619
C
        DO 612 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 619
 612    CONTINUE
C
        WRITE(*,1061) N
 1061   FORMAT(1X,'No influence of LE curvature constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 619    CONTINUE
C
C
        LCOL = KCONAL(N) + NHES
        IF(LCOL.LE.NHES) GO TO 629
C
        DO 622 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 629
 622    CONTINUE
C
        WRITE(*,1062) N
 1062   FORMAT(1X,'No influence of left angle constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 629    CONTINUE
C
C
        LCOL = KCONAR(N) + NHES
        IF(LCOL.LE.NHES) GO TO 639
C
        DO 632 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 639
 632    CONTINUE
C
        WRITE(*,1063) N
 1063   FORMAT(1X,'No influence of right angle constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 639    CONTINUE
C
C
        DO 64 ITH=0, NTHFIX(N)
          LCOL = KCONTH(ITH,N) + NHES
          IF(LCOL.LE.NHES) GO TO 649
C
          DO 642 KROW=1, NSYS
            IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 649
 642      CONTINUE
C
          IF(ITH.EQ.0) THEN
           WRITE(*,1064) N
 1064      FORMAT(1X,'No influence of max thickness constraint',
     &               ' on element',I2,
     &            ' ... replacing with dummy equation.')
          ELSE
           WRITE(*,1164) ITH, N
 1164      FORMAT(1X,'No influence of thickness constraint ',I2,
     &               ' on element',I2,
     &            ' ... replacing with dummy equation.')
          ENDIF
          SYS(LCOL,LCOL) = 1.0
 64     CONTINUE
C
 649    CONTINUE
C
C
        LCOL = KCONAB(N) + NHES
        IF(LCOL.LE.NHES) GO TO 659
C
        DO 652 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 659
 652    CONTINUE
C
        WRITE(*,1065) N
 1065   FORMAT(1X,'No influence of area constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 659    CONTINUE
C
C
        LCOL = KCONSG(N) + NHES
        IF(LCOL.LE.NHES) GO TO 679
C
        DO 672 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 679
 672    CONTINUE
C
        WRITE(*,1067) N
 1067   FORMAT(1X,'No influence of strain constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 679    CONTINUE
C
C
        LCOL = KCONEI(N) + NHES
        IF(LCOL.LE.NHES) GO TO 689
C
        DO 682 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 689
 682    CONTINUE
C
        WRITE(*,1068) N
 1068   FORMAT(1X,'No influence of stiffness constraint, element',I2,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 689    CONTINUE
C
 6    CONTINUE
C
C
C---- CL, CM, Ma, Re  constraints possibly for all points
      DO 7 IP=1, NPOINT
C
        LCOL = KCONCL(IP) + NHES
        IF(LCOL.LE.NHES) GO TO 719
C
        DO 712 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 719
 712    CONTINUE
C
        WRITE(*,1071) IP
 1071   FORMAT(1X,'No influence of CL constraint, point',I3,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 719    CONTINUE
C
C
        LCOL = KCONCM(IP) + NHES
        IF(LCOL.LE.NHES) GO TO 729
C
        DO 722 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 729
 722    CONTINUE
C
        WRITE(*,1072) IP
 1072   FORMAT(1X,'No influence of CM constraint, point',I3,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 729    CONTINUE
C
C
        LCOL = KCONMA(IP) + NHES
        IF(LCOL.LE.NHES) GO TO 739
C
        DO 732 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 739
 732    CONTINUE
C
        WRITE(*,1073) IP
 1073   FORMAT(1X,'No influence of Mach ~ 1/sqrt(CL) constraint, point',
     &             I3,' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 739    CONTINUE
C
C
        LCOL = KCONMA(IP) + NHES
        IF(LCOL.LE.NHES) GO TO 749
C
        DO 742 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 749
 742    CONTINUE
C
        WRITE(*,1074) IP
 1074   FORMAT(1X,'No influence of Re ~ 1/sqrt(CL) constraint, point',
     &             I3,' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
C
 749    CONTINUE
C
C

 7    CONTINUE
C
C---- check user constraints
      DO 8 K=1, NUCON
        LCOL = KCONUC(K) + NHES
        IF(LCOL.LE.NHES) GO TO 8
C
        DO 82 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 8
 82     CONTINUE
C
        WRITE(*,1082) K
 1082   FORMAT(1X,'No influence of User-Constraint',I3,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
 8    CONTINUE
C
C---- check Hk constraints
      DO 9 J=1, NHKFIX
        LCOL = KCONHK(J) + NHES
        IF(LCOL.LE.NHES) GO TO 9
C
        DO 92 KROW=1, NSYS
          IF(SYS(KROW,LCOL) .NE. 0.0) GO TO 9
 92     CONTINUE
C
        WRITE(*,1092) J
 1092   FORMAT(1X,'No influence of Hk constraint',I3,
     &            ' ... replacing with dummy equation.')
        SYS(LCOL,LCOL) = 1.0
 9    CONTINUE
C
      RETURN
      END ! SYSCHK


      SUBROUTINE DELLSQ
C------------------------------------------------------------
C     Sets up righthand side to least-squares Hessian system
C     and computes corresponding design-parameter changes 
C     using previously-factored augmented system matrix.
C------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VDEL(IX)
C
      IF(NSYS.EQ.0) THEN
       WRITE(*,*) 'DELLSQ: No design-parameter LU matrix !'
       RETURN
      ENDIF
C
      CALL DELVAR(IPTARG,ISTARG)
C
ccC---- clear all free and forced changes
cc      CALL CLRMOD(.FALSE.)
cc      CALL CLRAMR(.FALSE. , 0)
cc      CALL CLRUSR(.FALSE.)
C
      DO 1 K=0, NSYS
        DPAR(K) = 0.0
 1    CONTINUE
C
      IV = IVTARG
C
      IF(IPTARG.EQ.0) THEN
       IP1 = 1
       IP2 = NPOINT
      ELSE
       IP1 = IPTARG
       IP2 = IPTARG
      ENDIF
C
C
C---- go over point(s)
      DO 3 IP=IP1, IP2
C
        IF(ISTARG.EQ.0) THEN
          IS1 = 1
          IS2 = 2*NBL(1)
          WV = WP(IP)
        ELSE
          IF(L2SIDE) THEN
           N = (ISTARG+1)/2
           IS1 = 2*N-1
           IS2 = 2*N
          ELSE
           IS1 = ISTARG
           IS2 = ISTARG
          ENDIF
          WV = 1.0
        ENDIF
C
C------ skip point if its weight is zero
        IF(WV .EQ. 0.0) GO TO 3
C
C------ set least-squares residuals over active sides
        DO 31 IS=IS1, IS2
C
          N = (IS+1)/2
          ILE = ILEB(N,IP)
          ITE = ITEB(N,IP)
C
          DO 312 I=ILE, ITE
            VDEL(I) = VARSP(I,IS,IP) - (VAR(I,IS,IP,IV) + DVAR(I,IS,IP))
 312      CONTINUE
C
          CALL VARDOT(IP,IS,IV,WV,VDEL,DPAR(1))
C
 31     CONTINUE
 3    CONTINUE
C
C
C---- append constraint residuals to RHS vector
      CALL CONRES(DPAR(NHES+1))
C
C---- calculate parameter changes
      CALL BAKSUB(NSYSX,NSYS,SYS,SYSPIV,DPAR(1))
C
C---- set changes to DALFA,DMACH,... from pointered array DPAR
      DPAR(0) = 0.0
      DO 5 IP=1, NPOINT
        DO 51 K=1, NMOD(IP)
          DMOD(K,IP) = DMOD(K,IP) + DPAR(KHESMOD(K,IP))
 51     CONTINUE
C
        DO 52 K=1, NPOS(IP)
          DPOS(K,IP) = DPOS(K,IP) + DPAR(KHESPOS(K,IP))
 52     CONTINUE
C
        DALFA(IP) = DALFA(IP) + DPAR(KHESAL(IP))
        DMACH(IP) = DMACH(IP) + DPAR(KHESMA(IP))
        DLNRE(IP) = DLNRE(IP) + DPAR(KHESLR(IP))
 5    CONTINUE
C
      DO 6 K=1, NUPAR
        DUPAR(K) = DUPAR(K) + DPAR(KHESUP(K))
 6    CONTINUE
C
C---- fill Lagrange multiplier array
      DPAR(NHES) = 0.0
      DO 7 K=1, NCON
        ALGM(K) = DPAR(K+NHES)
 7    CONTINUE
C
      LDSET = .TRUE.
C
      RETURN
      END ! DELLSQ



      SUBROUTINE CONRES(DCON)
C---------------------------------------------------------
C     Calculates constraint residuals to be used for
C     augmenting the linear system for parameter changes.
C---------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION DCON(NCONX)
C
      DO 10 L=1, NCON
        DCON(L) = 0.0
 10   CONTINUE
C
      IP = IPGSEN
C
      DO 30 IS=1, 2*NBL(IP)
        IF(LSLFIX(IS)) THEN
          DSUM = 0.
          DO 301 K=1, NMOD(IP)
            DSUM = DSUM + SLL_MOD(K,IS,IP)*DMOD(K,IP)
 301      CONTINUE
          KROW = KCONSL(IS)
          DCON(KROW) = -DSUM
        ENDIF
C
        IF(LSRFIX(IS)) THEN
          DSUM = 0.
          DO 302 K=1, NMOD(IP)
            DSUM = DSUM + SLR_MOD(K,IS,IP)*DMOD(K,IP)
 302      CONTINUE
          KROW = KCONSR(IS)
          DCON(KROW) = -DSUM
        ENDIF
 30   CONTINUE


      DO 72 N=1, NBL(IP)
        IF(LCVFIX(N)) THEN
          DSUM = 0.
          DO 721 K=1, NMOD(IP)
            DSUM = DSUM + CVLE_MOD(K,N,IP)*DMOD(K,IP)
 721      CONTINUE
          KROW = KCONCV(N)
          DCON(KROW) = CVSPEC(N) - (CVLE(N,IP) + DSUM)
        ENDIF
C
        IF(LALFIX(N)) THEN
          DSUM = 0.
          DO 722 K=1, NMOD(IP)
            DSUM = DSUM + AGL_MOD(K,N,IP)*DMOD(K,IP)
 722      CONTINUE
          KROW = KCONAL(N)
          DCON(KROW) = ALSPEC(N) - (ANGLL(N,IP) + DSUM)
        ENDIF
C
        IF(LARFIX(N)) THEN
          DSUM = 0.
          DO 723 K=1, NMOD(IP)
            DSUM = DSUM + AGR_MOD(K,N,IP)*DMOD(K,IP)
 723      CONTINUE
          KROW = KCONAR(N)
          DCON(KROW) = ARSPEC(N) - (ANGLR(N,IP) + DSUM)
        ENDIF
C
        DO 724 ITH=0, NTHFIX(N)
          IF(LTHFIX(ITH,N)) THEN
            DSUM = 0.
            DO 7241 K=1, NMOD(IP)
              DSUM = DSUM + THB_MOD(K,ITH,N,IP)*DMOD(K,IP)
 7241       CONTINUE
            KROW = KCONTH(ITH,N)
            DCON(KROW) = THSPEC(ITH,N) - (THIKB(ITH,N,IP) + DSUM)
          ENDIF
 724    CONTINUE
C
        IF(LABFIX(N)) THEN
          DSUM = 0.
          DO 725 K=1, NMOD(IP)
            DSUM = DSUM + ARB_MOD(K,N,IP)*DMOD(K,IP)
 725      CONTINUE
          KROW = KCONAB(N)
          DCON(KROW) = ABSPEC(N) - (AREAB(N,IP) + DSUM)
        ENDIF
C
        IF(LSGFIX(N)) THEN
          DSUM = 0.
          DO 726 K=1, NMOD(IP)
            DSUM = DSUM + ASG_MOD(K,N,IP)*DMOD(K,IP)
 726      CONTINUE
          KROW = KCONSG(N)
          DCON(KROW) = SGSPEC(N) - (ASIGB(N,IP) + DSUM)
        ENDIF
C
        IF(LEIFIX(N)) THEN
          DSUM = 0.
          DO 727 K=1, NMOD(IP)
            DSUM = DSUM + EI1_MOD(K,N,IP)*DMOD(K,IP)
 727      CONTINUE
          KROW = KCONEI(N)
          DCON(KROW) = EISPEC(N) - (EI11B(N,IP) + DSUM)
        ENDIF
 72   CONTINUE
C
      DO 75 IP=1, NPOINT
C
        DCL = CL_ALFA(IP)*DALFA(IP)
     &      + CL_MACH(IP)*DMACH(IP)
     &      + CL_REYN(IP)*DLNRE(IP)*REYN(IP)
        DCM = CM_ALFA(IP)*DALFA(IP)
     &      + CM_MACH(IP)*DMACH(IP)
     &      + CM_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 751 K=1, NMOD(IP)
          DCL = DCL + CL_MOD(K,IP)*DMOD(K,IP)
          DCM = DCM + CM_MOD(K,IP)*DMOD(K,IP)
 751    CONTINUE
        DO 752 K=1, NPOS(IP)
          DCL = DCL + CL_POS(K,IP)*DPOS(K,IP)
          DCM = DCM + CM_POS(K,IP)*DPOS(K,IP)
 752    CONTINUE

        IF(LCLFIX(IP)) THEN
          KROW = KCONCL(IP)
          DCON(KROW) = CLSPEC(IP) - (CL(IP) + DCL)
        ENDIF
C
        IF(LCMFIX(IP)) THEN
          KROW = KCONCM(IP)
          DCON(KROW) = CMSPEC(IP) - (CM(IP) + DCM)
        ENDIF
C
        IF(LMAFIX(IP)) THEN
          SQCL   = SQRT( ABS(CL(IP)) )
          RES    =     MACH(IP)*SQCL - MSQCL(IP)
          RES_CL = 0.5*MACH(IP)/SQCL * SIGN( 1.0 , CL(IP) )
          RES_MA =              SQCL
C
          KROW = KCONMA(IP)
          DCON(KROW) = -(RES + RES_CL*DCL + RES_MA*DMACH(IP))
        ENDIF
C
        IF(LREFIX(IP)) THEN
          SQCL   = SQRT( ABS(CL(IP)) ) 
          RES    =     REYN(IP)*SQCL - RSQCL(IP)
          RES_CL = 0.5*REYN(IP)/SQCL * SIGN( 1.0 , CL(IP) )
          RES_RE =              SQCL
C
          KROW = KCONRE(IP)
          DCON(KROW) = -(RES + RES_CL*DCL + RES_RE*DLNRE(IP)*REYN(IP))
        ENDIF
C
 75   CONTINUE
C
      DO 80 ICON=1, NUCON
        IF(LUCFIX(ICON)) THEN
          KROW = KCONUC(ICON)
          DCON(KROW) = -(UCRES(ICON) + DUCRES(ICON))
        ENDIF
 80   CONTINUE
C
      DO 90 J=1, NHKFIX
        IF(LHKFIX(J)) THEN
          IP = IPHFIX(J)
          IS = ISHFIX(J)
          DHKL = HKL_ALFA(J)*DALFA(IP)
     &         + HKL_MACH(J)*DMACH(IP)
     &         + HKL_REYN(J)*DLNRE(IP)*REYN(IP)
          DO 955 K=1, NMOD(IP)
            DHKL = DHKL + HKL_MOD(K,J)*DMOD(K,IP)
 955      CONTINUE
          DO 956 K=1, NPOS(IP)
            DHKL = DHKL + HKL_POS(K,J)*DPOS(K,IP)
 956      CONTINUE
C
          KROW = KCONHK(J)
          DCON(KROW) = HKSPEC(J) - (HKLOC(J) + DHKL)
        ENDIF
 90   CONTINUE
C
      RETURN
      END ! CONRES



      SUBROUTINE VARDOT(IPOINT,ISIDE,IVAR,WPV,VEC,DOT)
C---------------------------------------------------
C     Forms dot-product integrals of VEC array with
C     all sensitivity arrays of variable IVAR, over
C     point IPOINT and side ISIDE.  The integral
C     for each active parameter is returned in 
C     one component of the DOT vector.
C---------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VEC(IX),DOT(NHESX)
C
      IP = IPOINT
      IS = ISIDE
      IV = IVAR
C
      N = (IS+1)/2
      I = ILEB(N,IP)
      NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
C
      DO 10 K=1, NMOD(IP)
        IF(LMOD(K,IP)) THEN
          KROW = KHESMOD(K,IP)
          DOT(KROW) = DOT(KROW)
     &              + WPV
     &       *DOTP(VAR_MOD(I,IS,K,IP,IV),VEC(I),SBI(I,IS,IP),NPTS)
        ENDIF
 10   CONTINUE
C
      DO 20 K=1, NPOS(IP)
        IF(LPOS(K,IP)) THEN
          KROW = KHESPOS(K,IP)
          DOT(KROW) = DOT(KROW)
     &              + WPV
     &       *DOTP(VAR_POS(I,IS,K,IP,IV),VEC(I),SBI(I,IS,IP),NPTS)
        ENDIF
 20   CONTINUE
C
      IF(LALFA(IP)) THEN
        KROW = KHESAL(IP)
        DOT(KROW) = DOT(KROW)
     &            + WPV
     &     *DOTP(VAR_ALFA(I,IS,IP,IV),VEC(I),SBI(I,IS,IP),NPTS)
      ENDIF
C
      IF(LMACH(IP)) THEN
        KROW = KHESMA(IP)
        DOT(KROW) = DOT(KROW)
     &            + WPV
     &     *DOTP(VAR_MACH(I,IS,IP,IV),VEC(I),SBI(I,IS,IP),NPTS)
      ENDIF
C
      IF(LREYN(IP)) THEN
        KROW = KHESLR(IP)
        DOT(KROW) = DOT(KROW)
     &            + WPV
     &     *DOTP(VAR_REYN(I,IS,IP,IV),VEC(I),SBI(I,IS,IP),NPTS)
     &     *REYN(IP)
      ENDIF
C
      RETURN
      END ! VARDOT



      FUNCTION DOTP(A,B,S,N)
      DIMENSION A(N), B(N), S(N)
C
      SUM = 0.0
      DO 10 I=1, N-1
        DS = ABS(S(I+1) - S(I))
        SUM = SUM + (A(I+1) + A(I)) * (B(I+1) + B(I)) * DS
 10   CONTINUE
C
      DOTP = 0.25*SUM
      RETURN
      END



      SUBROUTINE CLASET
C-----------------------------------------------
C     Adjusts alphas to achieve specified CL(s).
C-----------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION CLSET(NPX)
      PARAMETER (NTX=40)
      DIMENSION KT(NTX), IPT(NTX)
      LOGICAL ERROR
C
      DO 10 IP=1, NPOINT
        CLSET(IP) = CLSPEC(IP)
 10   CONTINUE
C
C
      WRITE(*,*)
 22   WRITE(*,*) 'Set CL for what points (0=all)? :'
      READ (*,5010) LINE
 5010 FORMAT(A80)
C
      CALL GETINT(LINE,IPT,NIP,ERROR)
C
      IF(NIP.GT.0) THEN
        IF(IPT(1).EQ.0) THEN
          DO 24 KIP=1, NPOINT
            IPT(KIP) = KIP
 24       CONTINUE
          NIP = NPOINT
        ENDIF
C
        DO 26 KIP=1, NIP
          IP = IPT(KIP)
          IF(IP.LT.1 .OR. IP.GT.NPOINT) GO TO 26
C
 25       WRITE(*,2300) IP, CLSET(IP)
 2300     FORMAT(' Enter CL',I2,' :',F12.5)
          CALL READR(1,CLSET(IP),ERROR)
          IF(ERROR) GO TO 25
C
C-------- set current modified CL
          CLM = CL(IP) + CL_ALFA(IP)*DALFA(IP)
     &                 + CL_MACH(IP)*DMACH(IP)
     &                 + CL_REYN(IP)*DLNRE(IP)*REYN(IP)
          DO 261 K=1, NMOD(IP)
            CLM = CLM + CL_MOD(K,IP)*DMOD(K,IP)
 261      CONTINUE
          DO 262 K=1, NPOS(IP)
            CLM = CLM + CL_POS(K,IP)*DPOS(K,IP)
 262      CONTINUE

C-------- set alpha to get specified CL
          DDALFA = (CLSET(IP) - CLM)/CL_ALFA(IP)
          DALFA(IP) = DALFA(IP) + DDALFA
C
 26     CONTINUE
        GO TO 22
      ENDIF
C
      RETURN
      END ! CLASET



      SUBROUTINE GETPSW(LPOLAR,FNAME,NREF,XREF,YREF)
C---------------------------------------------
C     Reads and returns XFOIL/ISES/MSES polar
C---------------------------------------------
      LOGICAL LPOLAR
      CHARACTER*80 FNAME
      CHARACTER*1 DUMMY
      DIMENSION XREF(NREF), YREF(NREF)
C
 1000 FORMAT(A)
C
      OPEN(9,FILE=FNAME,STATUS='OLD',ERR=901)
C
      READ(9,1000,END=901,ERR=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      DO 40 I=1, NREF
        IF(LPOLAR) THEN
         READ(9,*,ERR=901,END=42) ALFA,XREF(I),YREF(I)
        ELSE
         READ(9,*,ERR=901,END=42) XREF(I),ALFA, CL, YREF(I)
        ENDIF
   40 CONTINUE
   42 NREF = I - 1
      CLOSE(9)
      RETURN
C
 901  CONTINUE
      WRITE(*,*) 'GETPSW: File read error'
      NREF = 0
      RETURN
      END ! GETPSW



      SUBROUTINE GETREF(FNAME,NREF,XREF,YREF)
      CHARACTER*80 FNAME
      DIMENSION XREF(NREF), YREF(NREF)
C----------------------------------------
C     Reads general x,y data file FNAME
C----------------------------------------
C
 1000 FORMAT(A)
C
      OPEN(9,FILE=FNAME,STATUS='OLD',ERR=901)
      DO 40 I=1, NREF
        READ(9,*,ERR=901,END=42) XREF(I),YREF(I)
   40 CONTINUE
   42 NREF = I - 1
      CLOSE(9)
      RETURN
C
 901  CONTINUE
      WRITE(*,*) 'GETREF: File read error'
      NREF = 0
      RETURN
      END ! GETREF



      SUBROUTINE SHOBLK(A,NDIM,NI,NJ,IMARK,LU)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION A(NDIM,NDIM)
      CHARACTER*2 LINE(132), BAR
C
      WRITE(LU,1000) (MOD(K,10), K=1, NJ)
      WRITE(LU,1010) ('__', K=1, NJ)
 1000 FORMAT(/1X,4X, 120(I1,1X))
 1010 FORMAT( 1X,4X, 120A2     )
C
      DO 10 I=1, NI
        DO 104 J=1, NJ
          LINE(J) = '  '
          IF(A(I,J) .NE. 0.0) LINE(J) = '* '
          IF(A(I,J) .EQ. 1.0) LINE(J) = '1 '
 104    CONTINUE
        BAR = ' |'
        IF(I.EQ.IMARK) BAR = '_|'
        WRITE(LU,1040) I, BAR, (LINE(J),J=1, NJ)
 1040   FORMAT(1X,I2,A2,120A2)
 10   CONTINUE
C
      RETURN
      END



