      
      SUBROUTINE SETSBI
      INCLUDE 'LINDOP.INC'
C
C---- set and linearize surface arc length arrays SBI
      DO 2 IP=1, NPOINT
        DO 20 IS=1, 2*NBL(IP)
C
          N = (IS+1)/2
C
          ILE  = ILEB(N,IP)
          NPTS = IEND(N,IP) - ILE
C
          DO 205 K=1, NMOD(IP)
            CALL SLIN(XBI(ILE,IS,IP),XBI_MOD(ILE,IS,K,IP),
     &                YBI(ILE,IS,IP),YBI_MOD(ILE,IS,K,IP),
     &                SBI(ILE,IS,IP),SBI_MOD(ILE,IS,K,IP), NPTS)
 205      CONTINUE
C
          DO 207 K=1, NPOS(IP)
            CALL SLIN(XBI(ILE,IS,IP),XBI_POS(ILE,IS,K,IP),
     &                YBI(ILE,IS,IP),YBI_POS(ILE,IS,K,IP),
     &                SBI(ILE,IS,IP),SBI_POS(ILE,IS,K,IP), NPTS)
 207      CONTINUE
C
 20     CONTINUE
 2    CONTINUE
C
      RETURN
      END ! SETSBI



      SUBROUTINE GEOLIN
      INCLUDE 'LINDOP.INC'
C
C---- calculate geometry for sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      DO 20 N=1, NBL(IPG)
C
        IS1 = 2*N-1
        IS2 = 2*N
C
        ILE = ILEB(N,IPG)
        ITE = ITEB(N,IPG)
C
        CALL SGCALC(N)
        CALL EICALC(N)
C
        DO 205 K=1, NMOD1
          IS = IS1
C
C-------- set cross-sectional area
          CALL ARCALC(IX,ILE,ITE,
     &         XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &         YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &         AREAB(N,IPG),ARB_MOD(K,N,IPG) )
C
 205    CONTINUE
C
C------ set same geometry parameters for all other points
        DO 207 IP=1, NPOINT
          AREAB(N,IP) = AREAB(N,IPG)
          TSIGB(N,IP) = TSIGB(N,IPG)
          CSIGB(N,IP) = CSIGB(N,IPG)
          EI11B(N,IP) = EI11B(N,IPG)
          NMOD1 = MAX( NMOD(IP) , 1 )
          DO 2071 K=1, NMOD1
            ARB_MOD(K,N,IP) = ARB_MOD(K,N,IPG)
            TSG_MOD(K,N,IP) = TSG_MOD(K,N,IPG)
            CSG_MOD(K,N,IP) = CSG_MOD(K,N,IPG)
            EI1_MOD(K,N,IP) = EI1_MOD(K,N,IPG)
 2071     CONTINUE
 207    CONTINUE
C
 20   CONTINUE
C
      RETURN
      END ! GEOLIN



      SUBROUTINE ANGLIN
      INCLUDE 'LINDOP.INC'
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      DO 20 N=1, NBL(IPG)
C
        IS1 = 2*N-1
        IS2 = 2*N
C
        ILE = ILEB(N,IPG)
        ITE = ITEB(N,IPG)
C
        DO 205 K=1, NMOD1
C
          IS = IS1
C
C-------- set left angle
          CALL AGCALC(IX,ILE,ITE,+1,SBLFIX(IS1),1, SBLEGN(N,IPG),
     &                XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &                YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &                SBI(1,IS,IPG), SBI_MOD(1,IS,K,IPG),
     &                AG1,AG1_MOD )
C
          CALL AGCALC(IX,ILE,ITE,+1,SBLFIX(IS2),2, SBLEGN(N,IPG),
     &                XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &                YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &                SBI(1,IS,IPG), SBI_MOD(1,IS,K,IPG),
     &                AG2,AG2_MOD )
C
          ANGLL(N,IPG)     = AG1     - AG2
          AGL_MOD(K,N,IPG) = AG1_MOD - AG2_MOD
          IF(ANGLL(N,IPG) .GT. 360.) ANGLL(N,IPG) = ANGLL(N,IPG) - 360.
          IF(ANGLL(N,IPG) .LT.-180.) ANGLL(N,IPG) = ANGLL(N,IPG) + 360.
C
          SLL_MOD(K,IS1,IPG) = AG1_MOD
          SLL_MOD(K,IS2,IPG) = AG2_MOD
C
C          IF(K.EQ.1) THEN
C             WRITE(*,*) (SBI(I,IS1,IPG),I=ILE,ILE+4)
C             WRITE(*,*) (SBI(I,IS2,IPG),I=ILE,ILE+4)
C             WRITE(*,*) SBLEGN(N,IPG), AG1, AG2
C          ENDIF
C
C-------- set right angle
          CALL AGCALC(IX,ILE,ITE,-1,SBRFIX(IS1),1, SBLEGN(N,IPG),
     &         XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &         YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &         SBI(1,IS,IPG), SBI_MOD(1,IS,K,IPG),
     &         AG1, AG1_MOD )
C
          CALL AGCALC(IX,ILE,ITE,-1,SBRFIX(IS2),2, SBLEGN(N,IPG),
     &         XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &         YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &         SBI(1,IS,IPG), SBI_MOD(1,IS,K,IPG),
     &         AG2, AG2_MOD )
C
          ANGLR(N,IPG)     = AG2     - AG1
          AGR_MOD(K,N,IPG) = AG2_MOD - AG1_MOD
          IF(ANGLR(N,IPG) .GT. 360.) ANGLR(N,IPG) = ANGLR(N,IPG) - 360.
          IF(ANGLR(N,IPG) .LT.-180.) ANGLR(N,IPG) = ANGLR(N,IPG) + 360.
C
          SLR_MOD(K,IS1,IPG) = AG1_MOD
          SLR_MOD(K,IS2,IPG) = AG2_MOD
C
          IS = IS1
C
 205    CONTINUE
C
C------ set same geometry parameters for all other points
        DO 207 IP=1, NPOINT
          ANGLL(N,IP) = ANGLL(N,IPG)
          ANGLR(N,IP) = ANGLR(N,IPG)
          NMOD1 = MAX( NMOD(IP) , 1 )
          DO 2071 K=1, NMOD1
            AGL_MOD(K,N,IP) = AGL_MOD(K,N,IPG)
            AGR_MOD(K,N,IP) = AGR_MOD(K,N,IPG)
            SLL_MOD(K,N,IP) = SLL_MOD(K,N,IPG)
            SLR_MOD(K,N,IP) = SLR_MOD(K,N,IPG)
 2071     CONTINUE
 207    CONTINUE
C
 20   CONTINUE
C
      RETURN
      END ! ANGLIN



      SUBROUTINE THBLIN
      INCLUDE 'LINDOP.INC'
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      DO 20 N=1, NBL(IPG)
C
        IS1 = 2*N-1
        IS2 = 2*N
C
        ILE = ILEB(N,IPG)
        ITE = ITEB(N,IPG)
C
        IS = IS1
C
C------ find max thickness location
        ITH = 0
        CALL XTHMAX(IX,ILE,ITE, 
     &              XBI(1,IS,IPG), YBI(1,IS,IPG),
     &              XLEB(N,IPG),YLEB(N,IPG),
     &              XTEB(N,IPG),YTEB(N,IPG),
     &              XTHFIX(ITH,N))
C
        DO 205 ITH=0, NTHFIX(N)
          DO 2052 K=1, NMOD1
C
C---------- set max and/or local thickness
            CALL THCALC(IX,ILE,ITE,
     &           XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &           YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &           XLEB(N,IPG),YLEB(N,IPG),
     &           XTEB(N,IPG),YTEB(N,IPG),
     &           XTHFIX(ITH,N),
     &           THIKB(ITH,N,IPG),THB_MOD(K,ITH,N,IPG) )
C
 2052     CONTINUE
C
          DO 2054 IP=1, NPOINT
            THIKB(ITH,N,IP) = THIKB(ITH,N,IPG)
            NMOD1 = MAX( NMOD(IP) , 1 )
            DO 2154 K=1, NMOD1
              THB_MOD(K,ITH,N,IP) = THB_MOD(K,ITH,N,IPG)
 2154       CONTINUE
 2054     CONTINUE
C
 205    CONTINUE
 20   CONTINUE
C
      RETURN
      END ! THBLIN



      SUBROUTINE CRVLIN
      INCLUDE 'LINDOP.INC'
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      DO 20 N=1, NBL(IPG)
C
        IS1 = 2*N-1
        IS2 = 2*N
C
        ILE = ILEB(N,IPG)
        ITE = ITEB(N,IPG)
C
        NMOD1 = MAX( NMOD(IPG) , 1 )
        DO 205 K=1, NMOD1
C
          IS = IS1
C
          SGLE = 0.0
          CALL CVCALC(IX,ILE,ITE,SGLE, SBLEGN(N,IPG),
     &                XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &                YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &                SBI(1,IS,IPG), SBI_MOD(1,IS,K,IPG),
     &                CVLE(N,IPG),CVLE_MOD(K,N,IPG))
C
 205    CONTINUE
C
C------ set same geometry parameters for all other points
        DO 207 IP=1, NPOINT
          CVLE(N,IP) = CVLE(N,IPG)
          DO 2071 K=1, NMOD1
            CVLE_MOD(K,N,IP) = CVLE_MOD(K,N,IPG)
 2071     CONTINUE
 207    CONTINUE
C
 20   CONTINUE
C
      RETURN
      END ! CRVLIN



      SUBROUTINE SGCALC(NBEL)
      INCLUDE 'LINDOP.INC'
      DIMENSION TBI(IX,2), TBI_MOD(IX,2)
C
      N = NBEL
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      IS1 = 2*N-1
      IS2 = 2*N
C
      ILE = ILEB(N,IPG)
      ITE = ITEB(N,IPG)
C
C---- element chord line components
      XCHB = XTEB(N,IPG) - XLEB(N,IPG)
      YCHB = YTEB(N,IPG) - YLEB(N,IPG)
      CHB = SQRT(XCHB**2 + YCHB**2)
C
C---- assume load acts normal to element chord line
      ALOAD = ATAN2(YCHB,XCHB)
C
C---- set skin-thickness array TBI
      CALL TSKIN(IX,TBI,N)
C
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      IS = IS1
      DO 205 K=1, NMOD1
C
C------ skin thickness is not dependent on any parameters
        DO 2054 I=ILE, ITE
          TBI_MOD(I,1) = 0.0
          TBI_MOD(I,2) = 0.0
 2054   CONTINUE
C
        IF(ISGTYP .EQ. 1) THEN
C------- set max tensile and compressive strains for skin section
         CALL SGSKIN(IX,ILE,ITE,
     &        XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &        YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &        TBI(1,1)     , TBI_MOD(1,1)       ,
     &        ALOAD,
     &        TSIGB(N,IPG),TSG_MOD(K,N,IPG),TSG_AL,ITSIG,KST,
     &        CSIGB(N,IPG),CSG_MOD(K,N,IPG),CSG_AL,ICSIG,KSC,
     &        ASIGB(N,IPG),ASG_MOD(K,N,IPG),ASG_AL,
     &        AP1, AP2 )
C
C------- put strain in units of element chord
         TSIGB(N,IPG) = TSIGB(N,IPG)*CHB**2
         CSIGB(N,IPG) = CSIGB(N,IPG)*CHB**2
         ASIGB(N,IPG) = ASIGB(N,IPG)*CHB**2
C
         TSG_MOD(K,N,IPG) = TSG_MOD(K,N,IPG)*CHB**2
         CSG_MOD(K,N,IPG) = CSG_MOD(K,N,IPG)*CHB**2
         ASG_MOD(K,N,IPG) = ASG_MOD(K,N,IPG)*CHB**2
C
        ELSE
C------- set max tensile and compressive strains for solid section
         CALL SGAREA(IX,ILE,ITE,
     &        XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &        YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &        ALOAD,
     &        TSIGB(N,IPG),TSG_MOD(K,N,IPG),TSG_AL,ITSIG,KST,
     &        CSIGB(N,IPG),CSG_MOD(K,N,IPG),CSG_AL,ICSIG,KSC,
     &        ASIGB(N,IPG),ASG_MOD(K,N,IPG),ASG_AL,
     &        AP1, AP2 )
C
C------- put strain in units of element chord
         TSIGB(N,IPG) = TSIGB(N,IPG)*CHB**3
         CSIGB(N,IPG) = CSIGB(N,IPG)*CHB**3
         ASIGB(N,IPG) = ASIGB(N,IPG)*CHB**3
C
         TSG_MOD(K,N,IPG) = TSG_MOD(K,N,IPG)*CHB**3
         CSG_MOD(K,N,IPG) = CSG_MOD(K,N,IPG)*CHB**3
         ASG_MOD(K,N,IPG) = ASG_MOD(K,N,IPG)*CHB**3
        ENDIF
C
 205  CONTINUE
C
      IST = IS1 + KST-1
      ISC = IS1 + KSC-1
      WRITE(*,5000) N, 
     &              CSIGB(N,IPG), XBI(ICSIG,ISC,IPG), ICSIG,
     &              TSIGB(N,IPG), XBI(ITSIG,IST,IPG), ITSIG,
     &              ASIGB(N,IPG)
 5000 FORMAT(
     & /1X,'Element',I2,'    Cstrain =', F9.3,'  at  X =',F8.3, I4
     & /1X,'       ',2X,'    Tstrain =', F9.3,'  at  X =',F8.3, I4
     & /1X,'       ',2X,'    Astrain =', F9.3 )
C
C---- set same geometry parameters for all other points
      DO 207 IP=1, NPOINT
        ASIGB(N,IP) = ASIGB(N,IPG)
        DO 2071 K=1, NMOD(IP)
          ASG_MOD(K,N,IP) = ASG_MOD(K,N,IPG)
 2071   CONTINUE
 207  CONTINUE
C
      RETURN
      END ! SGCALC



      SUBROUTINE EICALC(NBEL)
      INCLUDE 'LINDOP.INC'
      DIMENSION TBI(IX,2), TBI_MOD(IX,2)
C
      N = NBEL
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      IS1 = 2*N-1
      IS2 = 2*N
C
      ILE = ILEB(N,IPG)
      ITE = ITEB(N,IPG)
C
C---- element chord line components
      XCHB = XTEB(N,IPG) - XLEB(N,IPG)
      YCHB = YTEB(N,IPG) - YLEB(N,IPG)
      CHB = SQRT(XCHB**2 + YCHB**2)
C
C---- set skin-thickness array TBI
      CALL TSKIN(IX,TBI,N)
C
      IS = IS1
      DO 205 K=1, NMOD1
C
C------ skin thickness is not dependent on any parameters
        DO 2054 I=ILE, ITE
          TBI_MOD(I,1) = 0.0
          TBI_MOD(I,2) = 0.0
 2054   CONTINUE
C
        IF(ISGTYP .EQ. 1) THEN
C--------set smaller principal-axis EI11 (larger EI22 is set but not saved)
         CALL EISKIN(IX,ILE,ITE,
     &        XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &        YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &        TBI(1,1)     , TBI_MOD(1,1)       ,
     &        EI11B(N,IPG) , EI1_MOD(K,N,IPG)   ,
     &        EI22B        , EI2_MOD            ,
     &        AP1, AP2 )
C
C------- put EI (actually, EI per unit of thickness TBI) 
C-       in units of element chord
         EI11B(N,IPG) = EI11B(N,IPG)/CHB**3
         EI22B        = EI22B       /CHB**3
C
         EI1_MOD(K,N,IPG) = EI1_MOD(K,N,IPG)/CHB**3
         EI2_MOD          = EI2_MOD         /CHB**3
C
        ELSE
C--------set smaller principal-axis EI11 (larger EI22 is set but not saved)
         CALL EIAREA(IX,ILE,ITE,
     &        XBI(1,IS,IPG), XBI_MOD(1,IS,K,IPG),
     &        YBI(1,IS,IPG), YBI_MOD(1,IS,K,IPG),
     &        EI11B(N,IPG) , EI1_MOD(K,N,IPG)   ,
     &        EI22B        , EI2_MOD            ,
     &        AP1, AP2 )
C
C------- put EI (actually, EI per unit of thickness TBI) 
C-       in units of element chord
         EI11B(N,IPG) = EI11B(N,IPG)/CHB**4
         EI22B        = EI22B       /CHB**4
C
         EI1_MOD(K,N,IPG) = EI1_MOD(K,N,IPG)/CHB**4
         EI2_MOD          = EI2_MOD         /CHB**4
        ENDIF
C
 205  CONTINUE
C
      WRITE(*,5000) N, AP1*180.0/PI,
     &              100.0*EI11B(N,IPG),
     &              100.0*EI22B
 5000 FORMAT(
     & /1X,'Element',I2,'    Axis11   =', F9.2,' DEG.'
     & /1X,'       ',2X,'    EI11x100 =', F9.5,
     & /1X,'       ',2X,'    EI22x100 =', F9.5 )
C
C---- set same geometry parameters for all other points
      DO 207 IP=1, NPOINT
        ASIGB(N,IP) = ASIGB(N,IPG)
        DO 2071 K=1, NMOD(IP)
          ASG_MOD(K,N,IP) = ASG_MOD(K,N,IPG)
 2071   CONTINUE
 207  CONTINUE
C
      RETURN
      END ! EICALC


      SUBROUTINE TSKIN(NDIM,TBI,NBEL)
      INCLUDE 'LINDOP.INC'
      DIMENSION TBI(NDIM,2)
C
      N = NBEL
C
C---- calculate geometry for geometry-sensitivity point
      IPG = IPGSEN
      NMOD1 = MAX( NMOD(IPG) , 1 )
C
      IS1 = 2*N-1
      IS2 = 2*N
C
      ILE = ILEB(N,IPG)
      ITE = ITEB(N,IPG)
C
C---- element chord line components
      XCHB = XTEB(N,IPG) - XLEB(N,IPG)
      YCHB = YTEB(N,IPG) - YLEB(N,IPG)
C
C---- go over the two sides of this element
      DO 202 KS=1, 2
        IS = IS1 + KS-1
C
C------ set skin thickness for this side
        IF(KS.EQ.1) THEN
         TS = TBSKIN(N)
        ELSE
         TS = 1.0
        ENDIF
C
C------ set skin thickness array over structural region XSTRF => XSTRB
        DO 2023 I=ILE+1, ITE-1
          XBM = XBI(I-1,IS,IPG)
          XBO = XBI(I  ,IS,IPG)
          XBP = XBI(I+1,IS,IPG)
          XCM = (0.5*(XBM+XBO) - XLEB(N,IPG))/XCHB
          XCP = (0.5*(XBP+XBO) - XLEB(N,IPG))/XCHB
C
          XCF = MAX(XCM,XSTRF(N))
          XCB = MIN(XCP,XSTRB(N))
          DXC = MAX(XCB-XCF,0.0)
          TBI(I,KS) = TS * DXC/(XCP-XCM)
 2023   CONTINUE
        TBI(ILE,KS) = TBI(ILE+1,KS)
        TBI(ITE,KS) = TBI(ITE-1,KS)
 202  CONTINUE
C
      RETURN
      END ! TSKIN


      SUBROUTINE GSPINI
      INCLUDE 'LINDOP.INC'
C
      IP = MIN( MAX(IPGSEN,1) , NPOINT )
C
      DO 10 N=1, NBL(IP)
        IF(ABS(ALSPEC(N)-ANGLL(N,IP)) .GT. 1.0 ) ALSPEC(N) = ANGLL(N,IP)
        IF(ABS(ARSPEC(N)-ANGLR(N,IP)) .GT. 1.0 ) ARSPEC(N) = ANGLR(N,IP)
        IF(ABS(CVSPEC(N)- CVLE(N,IP)) .GT. 1.0 ) CVSPEC(N) =  CVLE(N,IP)
        IF(ABS(ABSPEC(N)-AREAB(N,IP)) .GT. 0.01) ABSPEC(N) = AREAB(N,IP)
        IF(ABS(SGSPEC(N)-ASIGB(N,IP)) .GT. 1.0 ) SGSPEC(N) = ASIGB(N,IP)
        IF(ABS(EISPEC(N)-EI11B(N,IP)) .GT. 0.01) EISPEC(N) = EI11B(N,IP)
        ITH = 0
        IF(ABS(THSPEC(ITH,N) - THIKB(ITH,N,IP)) .GT. 0.01)
     &         THSPEC(ITH,N) = THIKB(ITH,N,IP) 
 10   CONTINUE
C
      RETURN
      END ! GSPINI


      SUBROUTINE XYSFIX(NDIM,ILE,ITE,X,Y,S,
     &                  SOFF, ISIDE, SG, XX,YY )
      DIMENSION X(NDIM,2), Y(NDIM,2), S(NDIM,2)
C--------------------------------------------------------------
C     Calculates airfoil surface point coordinates XX,YY
C     specified by fractional arc length SG on side ISIDE.
C     The fractional arc length is measured from SOFF to S(TE).
C     SOFF is + counterclockwise from S(LE).
C--------------------------------------------------------------
C
C---- calculate arc length SA and index of side ISA which contains it
      IF(ISIDE.EQ.1) THEN
       IS = 1
       SS = SG*(S(ITE,IS) + SOFF) - SOFF
       IF(SS.LT.0.0) THEN
        IS = 2
        SS = -SS
       ENDIF
      ELSE
       IS = 2
       SS = SG*(S(ITE,IS) - SOFF) + SOFF
       IF(SS.LT.0.0) THEN
        IS = 1
        SS = -SS
       ENDIF
      ENDIF
C
C---- find interval containing SS
      DO 10 I=ILE, ITE-1
        IF(SS .LE. S(I+1,IS)) GO TO 11
 10   CONTINUE
      WRITE(*,*) 'XYSFIX: Point not found.'
      WRITE(*,*) 'SIDE, S/SMAX, S =',ISIDE,IS, SG
      WRITE(*,*) '                 ',S(ILE,IS),SS,S(ITE,IS)
C
C---- interpolate coodinates to SS
 11   FRAC = (SS-S(I,IS))/(S(I+1,IS)-S(I,IS))
      XX = X(I,IS) + FRAC*(X(I+1,IS) - X(I,IS))
      YY = Y(I,IS) + FRAC*(Y(I+1,IS) - Y(I,IS))
C
      RETURN
      END ! XYSFIX


      SUBROUTINE SGSKIN(NDIM,ILE,ITE, X,XP,Y,YP,T,TP, ALFA,
     &                  TSIG,TSIGP,TSIGA,IT,IST,
     &                  CSIG,CSIGP,CSIGA,IC,ISC,
     &                  ASIG,ASIGP,ASIGA,
     &                  APX1, APX2 )
      DIMENSION  X(NDIM,2), Y(NDIM,2), T(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2),TP(NDIM,2)
C-----------------------------------------------------------------
C     Calculates max strains and sensitivities wrt a parameter.
C
C     X ,Y    airfoil coordinates
C     T       modulus-weighted skin thickness
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C     ALFA    angle of loading ccw from Y-axis
C           = angle of bending moment vector ccw from X-axis
C
C     TSIG    max tensile     strain       (negative X,Y)
C     CSIG    max compressive strain       (positive X,Y)
C     ASIG    T-weighted rms  strain
C
C     IT,IST  index and side of TSIG point
C     IC,ISC  index and side of CSIG point
C
C     APX1,2  angles of principal axes of inertia
C
C     notation convention:  ...P    = d.../dP
C                           ...A    = d.../dALFA
C-----------------------------------------------------------------
C
      IS1 = 1
      IS2 = 2
C
C---- integrate thickness and X,Y-weighted thickness
      TINT = 0.0
      XINT = 0.0
      YINT = 0.0
      TINTP = 0.0
      XINTP = 0.0
      YINTP = 0.0
      DO 1 IS=IS1, IS2
      DO 10 I=ILE+1, ITE
        DX = X(I,IS) - X(I-1,IS)
        DY = Y(I,IS) - Y(I-1,IS)
C
        DXP = XP(I,IS) - XP(I-1,IS)
        DYP = YP(I,IS) - YP(I-1,IS)
C
        DS = SQRT(DX*DX + DY*DY)
CCC        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XAV = 0.5*(X(I,IS) + X(I-1,IS))
        YAV = 0.5*(Y(I,IS) + Y(I-1,IS))
        TAV = 0.5*(T(I,IS) + T(I-1,IS))
C
        XAVP = 0.5*(XP(I,IS) + XP(I-1,IS))
        YAVP = 0.5*(YP(I,IS) + YP(I-1,IS))
        TAVP = 0.5*(TP(I,IS) + TP(I-1,IS))
C
        TINT  = TINT  + TAV*DS
        TINTP = TINTP + TAV*DSP + TAVP*DS
C
        XINT  = XINT  + TAV*XAV*DS
        YINT  = YINT  + TAV*YAV*DS
C
        XINTP = XINTP + TAV*XAV*DSP + TAV*XAVP*DS + TAVP*XAV*DS
        YINTP = YINTP + TAV*YAV*DSP + TAV*YAVP*DS + TAVP*YAV*DS
C
 10   CONTINUE
 1    CONTINUE
C
      IF(TINT .EQ. 0.0) THEN
       TSIG  = 0.0
       TSIGP = 0.0
       TSIGA = 0.0
       CSIG  = 0.0
       CSIGP = 0.0
       CSIGA = 0.0
       ASIG  = 0.0
       ASIGP = 0.0
       ASIGA = 0.0
C
       RETURN
      ENDIF
C
C---- calculate centroid location and its derivatives wrt P
      XCENT = XINT/TINT
      YCENT = YINT/TINT
C
      XCENTP = (XINTP - XCENT*TINTP)/TINT
      YCENTP = (YINTP - YCENT*TINTP)/TINT
C
C
C---- integrate inertias and derivatives wrt P
      EIXX = 0.0
      EIYY = 0.0
      EIXY = 0.0
      EIXXP = 0.0
      EIYYP = 0.0
      EIXYP = 0.0
      DO 2 IS=IS1, IS2
      DO 20 I=ILE+1, ITE
        DX = X(I,IS) - X(I-1,IS)
        DY = Y(I,IS) - Y(I-1,IS)
C
        DXP = XP(I,IS) - XP(I-1,IS)
        DYP = YP(I,IS) - YP(I-1,IS)
C
        DS = SQRT(DX*DX + DY*DY)
CCC        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XBAR = 0.5*(X(I,IS) + X(I-1,IS)) - XCENT
        YBAR = 0.5*(Y(I,IS) + Y(I-1,IS)) - YCENT
        TAV  = 0.5*(T(I,IS) + T(I-1,IS))
C
        XBARP = 0.5*(XP(I,IS) + XP(I-1,IS)) - XCENTP
        YBARP = 0.5*(YP(I,IS) + YP(I-1,IS)) - YCENTP
        TAVP  = 0.5*(TP(I,IS) + TP(I-1,IS))
C
        EIYY = EIYY + TAV*XBAR*XBAR*DS
        EIXX = EIXX + TAV*YBAR*YBAR*DS
        EIXY = EIXY + TAV*XBAR*YBAR*DS
C
        EIXXP = EIXXP + TAV *YBAR *YBAR *DSP
     &                + TAV *YBAR *YBARP*DS * 2.0
     &                + TAVP*YBAR *YBAR *DS
        EIYYP = EIYYP + TAV *XBAR *XBAR *DSP
     &                + TAV *XBAR *XBARP*DS * 2.0
     &                + TAVP*XBAR *XBAR *DS
        EIXYP = EIXYP + TAV *XBAR *YBAR *DSP
     &                + TAV *XBAR *YBARP*DS
     &                + TAV *XBARP*YBAR *DS
     &                + TAVP*XBAR *YBAR *DS
 20   CONTINUE
 2    CONTINUE
C
C---- set principal-axis inertias
      EISQ = 0.25*(EIXX - EIYY)**2 + EIXY**2
      EI11 = 0.5*(EIXX + EIYY) - SQRT(EISQ)
      EI22 = 0.5*(EIXX + EIYY) + SQRT(EISQ)
C
      C1 = EIXY
      S1 = EIXX-EI11
C
      C2 = EIYY-EI22
      S2 = EIXY
C
      SGN1 = SIGN( 1.0 , C1 )
      SGN2 = SIGN( 1.0 , C2 )
C
      APX1 = ATAN2(SGN1*S1,SGN1*C1)
      APX2 = ATAN2(SGN2*S2,SGN2*C2)
C
C
C---- solve unit-moment component matrix for X,Y beam curvatures u,v
C
C     | EIxx  EIxy ||v|   |Mx|   | COSA|
C     |            || | = |  | = |     |
C     | EIxy  EIyy ||u|   |My|   |-SINA|
C
C
      DET  = EIXX *EIYY  - EIXY**2
      DETP = EIXX *EIYYP - EIXY*EIXYP*2.0
     &     + EIXXP*EIYY
C
      SA = SIN(ALFA)
      CA = COS(ALFA)
C
      U = (-EIXX*SA - EIXY*CA)/DET
      V = ( EIYY*CA + EIXY*SA)/DET
C
      UP = (-EIXXP*SA - EIXYP*CA)/DET - U*DETP/DET
      VP = ( EIYYP*CA + EIXYP*SA)/DET - V*DETP/DET
C
      UA = (-EIXX*CA + EIXY*SA)/DET
      VA = (-EIYY*SA + EIXY*CA)/DET
C
C---- go over all points, set strain extrema, and set rms strain
      IC = 0
      IT = 0
      ISC = 0
      IST = 0
C
      TSIG = 0.0
      CSIG = 0.0
C
      EINT  = 0.0
      EINTP = 0.0
      EINTA = 0.0
C
      QINT  = 0.0
      QINTP = 0.0
C
      DO 4 IS=IS1, IS2
      DO 40 I=ILE+1, ITE
        DX = X(I,IS) - X(I-1,IS)
        DY = Y(I,IS) - Y(I-1,IS)
C
        DXP = XP(I,IS) - XP(I-1,IS)
        DYP = YP(I,IS) - YP(I-1,IS)
C
        DS = SQRT(DX*DX + DY*DY)
CCC        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XAV = 0.5*(X(I,IS) + X(I-1,IS))
        YAV = 0.5*(Y(I,IS) + Y(I-1,IS))
        TAV = 0.5*(T(I,IS) + T(I-1,IS))
C
        XAVP = 0.5*(XP(I,IS) + XP(I-1,IS))
        YAVP = 0.5*(YP(I,IS) + YP(I-1,IS))
        TAVP = 0.5*(TP(I,IS) + TP(I-1,IS))
C
        XBAR = XAV - XCENT
        YBAR = YAV - YCENT
C
        XBARP = XAVP - XCENTP
        YBARP = YAVP - YCENTP
C
C------ local strain
        SIG  = XBAR *U  + YBAR *V
        SIGP = XBAR *UP + YBAR *VP
     &       + XBARP*U  + YBARP*V
        SIGA = XBAR *UA + YBAR *VA
C
C------ set max compressive strain  (typically at -X,+Y)
        IF(SIG .GT. CSIG) THEN
          IC = I
          ISC = IS
          CSIG  = SIG
          CSIGP = SIGP
          CSIGA = SIGA
        ENDIF
C
C------ set max tensile strain  (typically at +X,-Y)
        IF(SIG .LT. -TSIG) THEN
          IT = I
          IST = IS
          TSIG  = -SIG
          TSIGP = -SIGP
          TSIGA = -SIGA
        ENDIF
C
        EINT  = EINT  + SIG**2 * TAV**2 * DS
        EINTP = EINTP + SIG**2 * TAV**2 * DSP
     &        + 2.0*TAV*SIG**2 * TAVP   * DS
     &        + 2.0*SIG*SIGP   * TAV**2 * DS
        EINTA = EINTA
     &        + 2.0*SIG*SIGA   * TAV**2 * DS
C
        QINT  = QINT  + TAV**2 * DS
        QINTP = QINTP + TAV**2 * DSP
     &        + 2.0*TAV*TAVP   * DS
C
 40   CONTINUE
 4    CONTINUE
C
      ASIG  = SQRT(EINT/QINT)
      ASIGP = 0.5*(ASIG/EINT)*EINTP - 0.5*(ASIG/QINT)*QINTP
      ASIGA = 0.5*(ASIG/EINT)*EINTA
C
      RETURN
      END ! SGSKIN


      SUBROUTINE EISKIN(NDIM,ILE,ITE,X,XP,Y,YP,T,TP,
     &                  EI11,EI11P,
     &                  EI22,EI22P,
     &                  APX1,APX2  )
      DIMENSION  X(NDIM,2), Y(NDIM,2), T(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2),TP(NDIM,2)
C-----------------------------------------------------------------
C     Calculates EIs and sensitivities wrt a parameter.
C
C     X ,Y    airfoil coordinates
C     T       modulus-weighted skin thickness
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C     ALFA    principal-axis angle (for smaller EI stiffness)
C             ccw from x-axis
C
C     EI11    EI in principal axes closest to EIxx
C     EI22    EI in principal axes closest to EIyy
C
C     notation convention:  ...P    = d.../dP
C-----------------------------------------------------------------
C
      IS1 = 1
      IS2 = 2
C
C---- integrate thickness and x,y-weighted thickness
      TINT = 0.0
      XINT = 0.0
      YINT = 0.0
      TINTP = 0.0
      XINTP = 0.0
      YINTP = 0.0
      DO 1 IS=IS1, IS2
      DO 10 I=ILE+1, ITE
        DX = X(I,IS) - X(I-1,IS)
        DY = Y(I,IS) - Y(I-1,IS)
C
        DXP = XP(I,IS) - XP(I-1,IS)
        DYP = YP(I,IS) - YP(I-1,IS)
C
        DS = SQRT(DX*DX + DY*DY)
ccc        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XAV = 0.5*(X(I,IS) + X(I-1,IS))
        YAV = 0.5*(Y(I,IS) + Y(I-1,IS))
        TAV = 0.5*(T(I,IS) + T(I-1,IS))
C
        XAVP = 0.5*(XP(I,IS) + XP(I-1,IS))
        YAVP = 0.5*(YP(I,IS) + YP(I-1,IS))
        TAVP = 0.5*(TP(I,IS) + TP(I-1,IS))
C
        TINT  = TINT  + TAV*DS
        TINTP = TINTP + TAV*DSP + TAVP*DS
C
        XINT  = XINT  + TAV*XAV*DS
        YINT  = YINT  + TAV*YAV*DS
C
        XINTP = XINTP + TAV*XAV*DSP + TAV*XAVP*DS + TAVP*XAV*DS
        YINTP = YINTP + TAV*YAV*DSP + TAV*YAVP*DS + TAVP*YAV*DS
C
 10   CONTINUE
 1    CONTINUE
C
      IF(TINT .EQ. 0.0) THEN
       EI11  = 0.0
       EI11P = 0.0
       EI22  = 0.0
       EI22P = 0.0
       APX1 = 0.0
       APX2 = ATAN2(1.0,0.0)
C
       RETURN
      ENDIF
C
C---- calculate centroid location and its derivatives wrt P
      XCENT = XINT/TINT
      YCENT = YINT/TINT
C
      XCENTP = (XINTP - XCENT*TINTP)/TINT
      YCENTP = (YINTP - YCENT*TINTP)/TINT
C
C
C---- integrate inertias and derivatives wrt P
      EIXX = 0.0
      EIYY = 0.0
      EIXY = 0.0
      EIXXP = 0.0
      EIYYP = 0.0
      EIXYP = 0.0
      DO 2 IS=IS1, IS2
      DO 20 I=ILE+1, ITE
        DX = X(I,IS) - X(I-1,IS)
        DY = Y(I,IS) - Y(I-1,IS)
C
        DXP = XP(I,IS) - XP(I-1,IS)
        DYP = YP(I,IS) - YP(I-1,IS)
C
        DS = SQRT(DX*DX + DY*DY)
ccc        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XBAR = 0.5*(X(I,IS) + X(I-1,IS)) - XCENT
        YBAR = 0.5*(Y(I,IS) + Y(I-1,IS)) - YCENT
        TAV  = 0.5*(T(I,IS) + T(I-1,IS))
C
        XBARP = 0.5*(XP(I,IS) + XP(I-1,IS)) - XCENTP
        YBARP = 0.5*(YP(I,IS) + YP(I-1,IS)) - YCENTP
        TAVP  = 0.5*(TP(I,IS) + TP(I-1,IS))
C
        EIYY = EIYY + TAV*XBAR*XBAR*DS
        EIXX = EIXX + TAV*YBAR*YBAR*DS
        EIXY = EIXY + TAV*XBAR*YBAR*DS
C
        EIXXP = EIXXP + TAV *YBAR *YBAR *DSP
     &                + TAV *YBAR *YBARP*DS * 2.0
     &                + TAVP*YBAR *YBAR *DS
        EIYYP = EIYYP + TAV *XBAR *XBAR *DSP
     &                + TAV *XBAR *XBARP*DS * 2.0
     &                + TAVP*XBAR *XBAR *DS
        EIXYP = EIXYP + TAV *XBAR *YBAR *DSP
     &                + TAV *XBAR *YBARP*DS
     &                + TAV *XBARP*YBAR *DS
     &                + TAVP*XBAR *YBAR *DS
 20   CONTINUE
 2    CONTINUE
C
C---- set principal-axis inertias
      EISQ  = 0.25*(EIXX  - EIYY )**2  + EIXY**2
      EISQP = 0.50*(EIXX  - EIYY )
     &            *(EIXXP - EIYYP) + 2.0*EIXY*EIXYP
C
C---- set +/- quadratic-formula factor so EI11 stiffness is 
C-    the one closest to "up-down"
      SGN = SIGN( 1.0 , EIYY-EIXX )
      EI11 = 0.5*(EIXX + EIYY) - SGN*SQRT(EISQ)
      EI22 = 0.5*(EIXX + EIYY) + SGN*SQRT(EISQ)
C
      IF(EISQ/(EI11*EI22) .LT. 1.0E-8) THEN
C----- rotationally-invariant section (circle, square, etc.)
C
       EI11P = 0.5*(EIXXP + EIYYP)
       EI22P = 0.5*(EIXXP + EIYYP)
C
C----- set principal axes arbitrarily to (0, pi/2)
       APX1 = 0.0
       APX2 = ATAN2(1.0,0.0)
C
      ELSE
C
       EI11P = 0.5*(EIXXP + EIYYP) - SGN*EISQP * 0.5/SQRT(EISQ)
       EI22P = 0.5*(EIXXP + EIYYP) + SGN*EISQP * 0.5/SQRT(EISQ)
C
       C1 = EIXY
       S1 = EIXX - EI11
       C2 = EIXY
       S2 = EIXX - EI22
C
       SGN1 = SIGN( 1.0 , C1 )
       SGN2 = SIGN( 1.0 , C2 )
C
       APX1 = ATAN2(SGN1*S1,SGN1*C1)
       APX2 = ATAN2(SGN2*S2,SGN2*C2)
C
      ENDIF
C
      RETURN
      END ! EISKIN



      SUBROUTINE SGAREA(NDIM,ILE,ITE, X,XP,Y,YP, ALFA,
     &                  TSIG,TSIGP,TSIGA,IT,IST,
     &                  CSIG,CSIGP,CSIGA,IC,ISC,
     &                  ASIG,ASIGP,ASIGA,
     &                  APX1, APX2 )
      DIMENSION  X(NDIM,2), Y(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2)
C-----------------------------------------------------------------
C     Calculates max strains and sensitivities wrt a parameter.
C
C     X ,Y    airfoil coordinates
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C     ALFA    angle of loading ccw from Y-axis
C           = angle of bending moment vector ccw from X-axis
C
C     TSIG    max tensile     strain       (negative X,Y)
C     CSIG    max compressive strain       (positive X,Y)
C     ASIG    T-weighted rms  strain
C
C     IT,IST  index and side of TSIG point
C     IC,ISC  index and side of CSIG point
C
C     APX1,2  angles of principal axes of inertia
C
C     notation convention:  ...P    = d.../dP
C                           ...A    = d.../dALFA
C-----------------------------------------------------------------
      PARAMETER (NX=500)
      DIMENSION XB(NX), YB(NX), XBP(NX), YBP(NX)
C
      IF(2*(ITE-ILE+1).GT.NX) STOP 'SGAREA: Array overflow on NX.'
C
      K = 0
      IS = 1
      DO I = ITE, ILE, -1
        K = K+1
        XB(K) = X(I,IS)
        YB(K) = Y(I,IS)
        XBP(K) = XP(I,IS)
        YBP(K) = YP(I,IS)
      ENDDO
      IS = 2
      DO I = ILE, ITE
        K = K+1
        XB(K) = X(I,IS)
        YB(K) = Y(I,IS)
        XBP(K) = XP(I,IS)
        YBP(K) = YP(I,IS)
      ENDDO
      KK = K
C
C---- integrate area and X,Y-weighted area
      XINT = 0.0
      YINT = 0.0
      AINT = 0.0
      XINTP = 0.0
      YINTP = 0.0
      AINTP = 0.0
      DO 10 K = 1, KK
        KM = K-1
        IF(K.EQ.1) KM = KK
C
        DX = XB(K) - XB(KM)
        DY = YB(K) - YB(KM)
C
        DXP = XBP(K) - XBP(KM)
        DYP = YBP(K) - YBP(KM)
C
        XAV = 0.5*(XB(K) + XB(KM))
        YAV = 0.5*(YB(K) + YB(KM))
C
        XAVP = 0.5*(XBP(K) + XBP(KM))
        YAVP = 0.5*(YBP(K) + YBP(KM))
C
        XINT  = XINT  + 0.5*XAV**2*DY
        YINT  = YINT  - 0.5*YAV**2*DX
        AINT  = AINT  -     YAV   *DX
C
        XINTP = XINTP + 0.5*XAV**2*DYP + XAV*XAVP*DY
        YINTP = YINTP - 0.5*YAV**2*DXP - YAV*YAVP*DX
        AINTP = AINTP -     YAV   *DXP -     YAVP*DX
 10   CONTINUE
C
C---- calculate centroid location and its derivatives wrt P
      XCENT = XINT/AINT
      YCENT = YINT/AINT
C
      XCENTP = (XINTP - XCENT*AINTP)/AINT
      YCENTP = (YINTP - YCENT*AINTP)/AINT
C
C
C---- integrate inertias and derivatives wrt P
      EIXX = 0.0
      EIYY = 0.0
      EIXY = 0.0
      EIXXP = 0.0
      EIYYP = 0.0
      EIXYP = 0.0
      DO 20 K = 1, KK
        KM = K-1
        IF(K.EQ.1) KM = KK
C
        DX = XB(K) - XB(KM)
        DY = YB(K) - YB(KM)
C
        DXP = XBP(K) - XBP(KM)
        DYP = YBP(K) - YBP(KM)
C
        XBAR = 0.5*(XB(K) + XB(KM)) - XCENT
        YBAR = 0.5*(YB(K) + YB(KM)) - YCENT
C
        XBARP = 0.5*(XBP(K) + XBP(KM)) - XCENTP
        YBARP = 0.5*(YBP(K) + YBP(KM)) - YCENTP
C
        EIXX = EIXX - 0.33333*YBAR**3 *DX
        EIYY = EIYY + 0.33333*XBAR**3 *DY
        EIXY = EIXY - 0.5*YBAR**2*XBAR*DX
C
        EIXXP = EIXXP -   YBARP*YBAR**2 *DX
     &                - 0.33333*YBAR**3 *DXP
        EIYYP = EIYYP +   XBARP*XBAR**2 *DY
     &                + 0.33333*XBAR**3 *DYP
        EIXYP = EIXYP - YBARP*YBAR*XBAR *DX
     &               - 0.5*YBAR**2*XBARP*DX
     &               - 0.5*YBAR**2*XBAR *DXP
 20   CONTINUE
C
C---- set principal-axis inertias
      EISQ = 0.25*(EIXX - EIYY)**2 + EIXY**2
      EI11 = 0.5*(EIXX + EIYY) - SQRT(EISQ)
      EI22 = 0.5*(EIXX + EIYY) + SQRT(EISQ)
C
      C1 = EIXY
      S1 = EIXX-EI11
C
      C2 = EIYY-EI22
      S2 = EIXY
C
      SGN1 = SIGN( 1.0 , C1 )
      SGN2 = SIGN( 1.0 , C2 )
C
      APX1 = ATAN2(SGN1*S1,SGN1*C1)
      APX2 = ATAN2(SGN2*S2,SGN2*C2)
C
C
C---- solve unit-moment component matrix for X,Y beam curvatures u,v
C
C     | EIxx  EIxy ||v|   |Mx|   | COSA|
C     |            || | = |  | = |     |
C     | EIxy  EIyy ||u|   |My|   |-SINA|
C
C
      DET  = EIXX *EIYY  - EIXY**2
      DETP = EIXX *EIYYP - EIXY*EIXYP*2.0
     &     + EIXXP*EIYY
C
      SA = SIN(ALFA)
      CA = COS(ALFA)
C
      U = (-EIXX*SA - EIXY*CA)/DET
      V = ( EIYY*CA + EIXY*SA)/DET
C
      UP = (-EIXXP*SA - EIXYP*CA)/DET - U*DETP/DET
      VP = ( EIYYP*CA + EIXYP*SA)/DET - V*DETP/DET
C
      UA = (-EIXX*CA + EIXY*SA)/DET
      VA = (-EIYY*SA + EIXY*CA)/DET
C
C
      XBMAX = ABS(XB(1)-XCENT)
      YBMAX = ABS(YB(1)-YCENT)
      DO K = 1, KK
        XBMAX = MAX(XBMAX,ABS(XB(K)-XCENT))
        YBMAX = MAX(YBMAX,ABS(YB(K)-YCENT))
      ENDDO
C
      UVSCAL = SQRT((U*XBMAX)**2 + (V*YBMAX)**2)
C
C---- go over all points, set strain extrema, and set rms strain
      IC = 0
      IT = 0
      ISC = 0
      IST = 0
C
      TSIG = 0.0
      CSIG = 0.0
C
      EINT  = 0.0
      EINTP = 0.0
      EINTA = 0.0
C
      SINT  = 0.0
      SINTP = 0.0
C
      EXS  = 16.0
      EXSI = 1.0/EXS
C
      DO 40 K = 1, KK
        KM = K-1
        IF(K.EQ.1) KM = KK
C
        DX = XB(K) - XB(KM)
        DY = YB(K) - YB(KM)
C
        DXP = XBP(K) - XBP(KM)
        DYP = YBP(K) - YBP(KM)
C
        DS = SQRT(DX*DX + DY*DY)
CCC        DSP = (DX*DXP + DY*DYP)/DS
        DSP = 0.0
C
        XAV = 0.5*(XB(K) + XB(KM))
        YAV = 0.5*(YB(K) + YB(KM))
C
        XAVP = 0.5*(XBP(K) + XBP(KM))
        YAVP = 0.5*(YBP(K) + YBP(KM))
C
        XBAR = XAV - XCENT
        YBAR = YAV - YCENT
C
        XBARP = XAVP - XCENTP
        YBARP = YAVP - YCENTP
C
C------ local strain
        SIG  = XBAR *U  + YBAR *V
        SIGP = XBAR *UP + YBAR *VP
     &       + XBARP*U  + YBARP*V
        SIGA = XBAR *UA + YBAR *VA
C
C------ set max compressive strain  (typically at -X,+Y)
        IF(SIG .GT. CSIG) THEN
          IC = I
          ISC = IS
          CSIG  = SIG
          CSIGP = SIGP
          CSIGA = SIGA
        ENDIF
C
C------ set max tensile strain  (typically at +X,-Y)
        IF(SIG .LT. -TSIG) THEN
          IT = I
          IST = IS
          TSIG  = -SIG
          TSIGP = -SIGP
          TSIGA = -SIGA
        ENDIF
C
        SGN = SIGN(1.0,SIG) / UVSCAL
C
        EINT  = EINT  + (SGN*SIG)**EXS * DS
        EINTP = EINTP + (SGN*SIG)**EXS * DSP
     &            + EXS*(SGN*SIG)**(EXS-1.0)*SGN*SIGP  * DS
        EINTA = EINTA
     &            + EXS*(SGN*SIG)**(EXS-1.0)*SGN*SIGA  * DS
C
        SINT  = SINT  + DS
        SINTP = SINTP + DSP
C
 40   CONTINUE
C
      ASIG  = UVSCAL*(EINT/SINT)**EXSI
      ASIGP = EXSI*(ASIG/EINT)*EINTP - EXSI*(ASIG/SINT)*SINTP
      ASIGA = EXSI*(ASIG/EINT)*EINTA
C
      RETURN
      END ! SGAREA



      SUBROUTINE EIAREA(NDIM,ILE,ITE,X,XP,Y,YP,
     &                  EI11,EI11P,
     &                  EI22,EI22P,
     &                  APX1,APX2  )
      DIMENSION  X(NDIM,2), Y(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2)
C-----------------------------------------------------------------
C     Calculates EIs and sensitivities wrt a parameter.
C
C     X ,Y    airfoil coordinates
C     T       modulus-weighted skin thickness
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C     ALFA    principal-axis angle (for smaller EI stiffness)
C             ccw from x-axis
C
C     EI11    EI in principal axes closest to EIxx
C     EI22    EI in principal axes closest to EIyy
C
C     notation convention:  ...P    = d.../dP
C-----------------------------------------------------------------
      PARAMETER (NX=500)
      DIMENSION XB(NX), YB(NX), XBP(NX), YBP(NX)
C
      IF(2*(ITE-ILE+1).GT.NX) STOP 'SGAREA: Array overflow on NX.'
C
      K = 0
      IS = 1
      DO I = ITE, ILE, -1
        K = K+1
        XB(K) = X(I,IS)
        YB(K) = Y(I,IS)
        XBP(K) = XP(I,IS)
        YBP(K) = YP(I,IS)
      ENDDO
      IS = 2
      DO I = ILE, ITE
        K = K+1
        XB(K) = X(I,IS)
        YB(K) = Y(I,IS)
        XBP(K) = XP(I,IS)
        YBP(K) = YP(I,IS)
      ENDDO
      KK = K
C
      XINT = 0.0
      YINT = 0.0
      AINT = 0.0
      XINTP = 0.0
      YINTP = 0.0
      AINTP = 0.0
      DO 10 K = 1, KK
        KM = K-1
        IF(K.EQ.1) KM = KK
C
        DX = XB(K) - XB(KM)
        DY = YB(K) - YB(KM)
C
        DXP = XBP(K) - XBP(KM)
        DYP = YBP(K) - YBP(KM)
C
        XAV = 0.5*(XB(K) + XB(KM))
        YAV = 0.5*(YB(K) + YB(KM))
C
        XAVP = 0.5*(XBP(K) + XBP(KM))
        YAVP = 0.5*(YBP(K) + YBP(KM))
C
        XINT  = XINT  + 0.5*XAV**2*DY
        YINT  = YINT  - 0.5*YAV**2*DX
        AINT  = AINT  -     YAV   *DX
C
        XINTP = XINTP + 0.5*XAV**2*DYP + XAV*XAVP*DY
        YINTP = YINTP - 0.5*YAV**2*DXP - YAV*YAVP*DX
        AINTP = AINTP -     YAV   *DXP -     YAVP*DX
 10   CONTINUE
C
C---- calculate centroid location and its derivatives wrt P
      XCENT = XINT/AINT
      YCENT = YINT/AINT
C
      XCENTP = (XINTP - XCENT*AINTP)/AINT
      YCENTP = (YINTP - YCENT*AINTP)/AINT
C
C
C---- integrate inertias and derivatives wrt P
      EIXX = 0.0
      EIYY = 0.0
      EIXY = 0.0
      EIXXP = 0.0
      EIYYP = 0.0
      EIXYP = 0.0
      DO 20 K = 1, KK
        KM = K-1
        IF(K.EQ.1) KM = KK
C
        DX = XB(K) - XB(KM)
        DY = YB(K) - YB(KM)
C
        DXP = XBP(K) - XBP(KM)
        DYP = YBP(K) - YBP(KM)
C
        XBAR = 0.5*(XB(K) + XB(KM)) - XCENT
        YBAR = 0.5*(YB(K) + YB(KM)) - YCENT
C
        XBARP = 0.5*(XBP(K) + XBP(KM)) - XCENTP
        YBARP = 0.5*(YBP(K) + YBP(KM)) - YCENTP
C
        EIXX = EIXX - 0.33333*YBAR**3 *DX
        EIYY = EIYY + 0.33333*XBAR**3 *DY
        EIXY = EIXY - 0.5*YBAR**2*XBAR*DX
C
        EIXXP = EIXXP -   YBARP*YBAR**2 *DX
     &                - 0.33333*YBAR**3 *DXP
        EIYYP = EIYYP +   XBARP*XBAR**2 *DY
     &                + 0.33333*XBAR**3 *DYP
        EIXYP = EIXYP - YBARP*YBAR*XBAR *DX
     &               - 0.5*YBAR**2*XBARP*DX
     &               - 0.5*YBAR**2*XBAR *DXP
 20   CONTINUE
C
C---- set principal-axis inertias
      EISQ  = 0.25*(EIXX  - EIYY )**2  + EIXY**2
      EISQP = 0.50*(EIXX  - EIYY )
     &            *(EIXXP - EIYYP) + 2.0*EIXY*EIXYP
C
C---- set +/- quadratic-formula factor so EI11 stiffness is 
C-    the one closest to "up-down"
      SGN = SIGN( 1.0 , EIYY-EIXX )
      EI11 = 0.5*(EIXX + EIYY) - SGN*SQRT(EISQ)
      EI22 = 0.5*(EIXX + EIYY) + SGN*SQRT(EISQ)
C
      IF(EISQ/(EI11*EI22) .LT. 1.0E-8) THEN
C----- rotationally-invariant section (circle, square, etc.)
C
       EI11P = 0.5*(EIXXP + EIYYP)
       EI22P = 0.5*(EIXXP + EIYYP)
C
C----- set principal axes arbitrarily to (0, pi/2)
       APX1 = 0.0
       APX2 = ATAN2(1.0,0.0)
C
      ELSE
C
       EI11P = 0.5*(EIXXP + EIYYP) - SGN*EISQP * 0.5/SQRT(EISQ)
       EI22P = 0.5*(EIXXP + EIYYP) + SGN*EISQP * 0.5/SQRT(EISQ)
C
       C1 = EIXY
       S1 = EIXX - EI11
       C2 = EIXY
       S2 = EIXX - EI22
C
       SGN1 = SIGN( 1.0 , C1 )
       SGN2 = SIGN( 1.0 , C2 )
C
       APX1 = ATAN2(SGN1*S1,SGN1*C1)
       APX2 = ATAN2(SGN2*S2,SGN2*C2)
C
      ENDIF
C
      RETURN
      END ! EIAREA



      SUBROUTINE XTHMAX(NDIM,ILE,ITE,X,Y, XLE,YLE,XTE,YTE, XTH)
      DIMENSION X(NDIM,2),Y(NDIM,2)
C----------------------------------------------------------
C     Calculates max airfoil thickness location.
C
C     X ,Y    airfoil coordinates
C
C     XTH     max-thickness chord-based x/c
C----------------------------------------------------------
C
      THIK = 0.
C
      IS1 = 1
      IS2 = 2
C
C---- airfoil chord line components
      XCH = XTE - XLE
      YCH = YTE - YLE
      SCHSQ = XCH**2 + YCH**2
C
C---- go over surface points on side 1
      DO 4 I1=ILE+1, ITE
C
C------ go over surface points on side 2, looking for opposite point
        DO 42 I2=ILE+1, ITE
          DXO = X(I1,IS1) - X(I2  ,IS2)
          DYO = Y(I1,IS1) - Y(I2  ,IS2)
          DXM = X(I1,IS1) - X(I2-1,IS2)
          DYM = Y(I1,IS1) - Y(I2-1,IS2)
C
C-------- dot product with thickness segment and chord line is zero
          DPO = DXO*XCH + DYO*YCH
          DPM = DXM*XCH + DYM*YCH
C
          IF(DPO .LT. 0.0 .AND. DPM .GE. 0.0) GO TO 43
 42     CONTINUE
        GO TO 4
C
 43     CONTINUE
C
C------ interpolating weights to side 2 points bounding thickness segment
        FRACO = -DPM / (DPO - DPM)
        FRACM =  DPO / (DPO - DPM)
C
C------ thickness segment components
        DX  =  X(I1,IS1) - (FRACO* X(I2,IS2) + FRACM* X(I2-1,IS2))
        DY  =  Y(I1,IS1) - (FRACO* Y(I2,IS2) + FRACM* Y(I2-1,IS2))
C
C------ local thickness
        THLOC = SQRT(DX**2 + DY**2)
C
C------ if this is the biggest so far, save it and its sensitivities
        IF(THLOC .GT. THIK) THEN
C
C------- save current max thickness and location
         THIK = THLOC
         XTH = ( (X(I1,IS1)-XLE)*XCH + (Y(I1,IS1)-YLE)*YCH ) / SCHSQ
C
        ENDIF
C
 4    CONTINUE
C
      RETURN
      END ! XTHMAX



      SUBROUTINE THCALC(NDIM,ILE,ITE,X,XP,Y,YP,
     &                  XLE,YLE,XTE,YTE,
     &                  XTH,
     &                  THIK,THIKP)
      DIMENSION X(NDIM,2),Y(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2)
C----------------------------------------------------------
C     Calculates max airfoil thickness 
C     and its sensitivity wrt some parameter P.
C
C     X ,Y    airfoil coordinates
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C     XTH     chord-based x/c where thickness is to be set
C
C     THIK    local thickness
C----------------------------------------------------------
      DIMENSION FRACM(2), FRACO(2)
      DIMENSION IT(2)
C
      IS1 = 1
      IS2 = 2
C
C---- airfoil chord line components
      XCH = XTE - XLE
      YCH = YTE - YLE
      SCHSQ = XCH**2 + YCH**2
C
      THIK  = 0.0
      THIKP = 0.0
C
C---- go over each side
      DO 4 IS=IS1, IS2
C
        I = ILE
        XTHM = ( (X(I,IS)-XLE)*XCH + (Y(I,IS)-YLE)*YCH)/SCHSQ
        DO 41 I=ILE+1, ITE
          XTHO = ( (X(I,IS)-XLE)*XCH + (Y(I,IS)-YLE)*YCH)/SCHSQ
          IF(XTH.GE.XTHM .AND. XTH.LE.XTHO) GO TO 42
          XTHM = XTHO
 41     CONTINUE
        WRITE(*,*) '*** THCALC: x/c location not found:', XTH, XLE, XTE
        I = ITE
 42     CONTINUE
C
C------ interpolation fractions from bounding points to XTH
        DXTH = XTHO - XTHM
        FRACM(IS) = (XTHO-XTH)/DXTH
        FRACO(IS) = (XTH-XTHM)/DXTH
        IT(IS) = I
C
 4    CONTINUE
C
C---- thickness segment components
      I1 = IT(IS1)
      I2 = IT(IS2)
      DX  = (FRACO(IS1)* X(I1,IS1) + FRACM(IS1)* X(I1-1,IS1))
     &    - (FRACO(IS2)* X(I2,IS2) + FRACM(IS2)* X(I2-1,IS2))
      DY  = (FRACO(IS1)* Y(I1,IS1) + FRACM(IS1)* Y(I1-1,IS1))
     &    - (FRACO(IS2)* Y(I2,IS2) + FRACM(IS2)* Y(I2-1,IS2))
      DXP = (FRACO(IS1)*XP(I1,IS1) + FRACM(IS1)*XP(I1-1,IS1))
     &    - (FRACO(IS2)*XP(I2,IS2) + FRACM(IS2)*XP(I2-1,IS2))
      DYP = (FRACO(IS1)*YP(I1,IS1) + FRACM(IS1)*YP(I1-1,IS1))
     &    - (FRACO(IS2)*YP(I2,IS2) + FRACM(IS2)*YP(I2-1,IS2))
C
C---- local thickness and sensitivity
      THIK = SQRT(DX**2 + DY**2)
      THIKP = (DX*DXP + DY*DYP)/THIK
C
      RETURN
      END ! THCALC



      SUBROUTINE ARCALC(NDIM,ILE,ITE,X,XP,Y,YP, 
     &                  AREA,AREAP)
      DIMENSION X(NDIM,2),Y(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2)
C----------------------------------------------------------
C     Calculates airfoil area
C     and its sensitivity wrt some parameter P.
C
C     X ,Y    airfoil coordinates
C     XP,YP   dX/dP  dY/dP  ; P = parameter
C
C     AREA    cross-sectional area
C     AREAP   dAREA/dP
C----------------------------------------------------------
C
      IS1 = 1
      IS2 = 2
C
      AREA  = 0.0
      AREAP = 0.0
C
C---- go over both sides of this airfoil
      DO 6 IS=IS1, IS2
C
        SGN = 1.0
        IF(IS.EQ.IS2) SGN = -1.0
C
C------ go over surface points on this side
        DO 64 I=ILE+1, ITE
C
          YA  = ( Y(I,IS) +  Y(I-1,IS))*0.5
          YAP = (YP(I,IS) + YP(I-1,IS))*0.5
C
          DX  =   X(I,IS) -  X(I-1,IS)
          DXP =  XP(I,IS) - XP(I-1,IS)
C
C-------- accumulate area and sensitivities
          AREA  = AREA  + SGN* YA*DX
          AREAP = AREAP + SGN*(YA*DXP + YAP*DX)
C
 64     CONTINUE
 6    CONTINUE
C
      RETURN
      END ! ARCALC



      SUBROUTINE SLIN(X,XP,Y,YP,S,SP,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N) , Y(N) , S(N) ,
     &          XP(N), YP(N), SP(N)
C--------------------------------------------------------
C     Calculates arc length from x,y coordinates.
C     Also calculates derivative of S wrt a parameter P.
C
C     Input:  X, Y    x,y coordinate array
C             XP,YP   dX/dP, dX/dP arrays
C             N       number of points
C
C     Output: S       arc length array
C             SP      dS/dP array
C--------------------------------------------------------
C
      S(1) = 0.0
      SP(1) = 0.0
C
      DO 10 I=2, N
        DX = X(I) - X(I-1)
        DY = Y(I) - Y(I-1)
        DS = SQRT(DX**2 + DY**2)
C
        DSP = (DX*(XP(I) - XP(I-1)) + DY*(YP(I) - YP(I-1))) / DS

CCC     S(I) = DS + S(I-1)
        S(I) = DS

CCC     SP(I) = DSP + SP(I-1)
        SP(I) = DSP
 10   CONTINUE
C
      DO 15 I=2, N
        S(I) = S(I) + S(I-1)
        SP(I) = SP(I) + SP(I-1)
 15   CONTINUE
C
      RETURN
      END ! SLIN


      SUBROUTINE AGCALC(NDIM,ILE,ITE,INCR,SG,ISIDE, SOFF,
     &                  X,XP,Y,YP,S,SP,
     &                  ANGLE,ANGLEP)
      DIMENSION  X(NDIM,2), Y(NDIM,2), S(NDIM,2)
      DIMENSION XP(NDIM,2),YP(NDIM,2),SP(NDIM,2)
C----------------------------------------------------------
C     Calculates surface angle and its sensitivity
C     wrt some parameter P.
C
C     INCR      +1  left  angle (based on 3 points to right)
C               -1  right angle (based on 3 points to left )
C     SG        fractional arc length where angle is to be computed
C     ISIDE     1 angle of upper side
C               2 angle of lower side
C     SOFF      S offset of left mode endpoint location where SG=0
C                (+ counterclockwise from stagnation point)
C     X ,Y      airfoil coordinates
C     S         arc length
C     XP,YP,SP  dX/dP  dY/dP  dS/dP    ; P = parameter
C
C     ANGLE     surface angle from horizontal, + counterclockwise
C     ANGLEP    dANGLE/dP
C----------------------------------------------------------
      DATA  PI /3.1415926535897932384/
      DATA TPI /6.2831853071795864769/
C
      SINCR = SIGN( 1.0 , FLOAT(INCR) )
C
C---- calculate arc length SA and index of side ISA which contains it
      IF(ISIDE.EQ.1) THEN
       ISA = 1
       SA = SG*(S(ITE,ISA) + SOFF) - SOFF
       IF(SA.LT.0.0) THEN
        ISA = 2
        SA = -SA
       ENDIF
      ELSE
       ISA = 2
       SA = SG*(S(ITE,ISA) - SOFF) + SOFF
       IF(SA.LT.0.0) THEN
        ISA = 1
        SA = -SA
       ENDIF
      ENDIF
C
C---- set node on or just next to point SA
      IF(INCR.GT.0) THEN
C
       DO 11 IA=ILE, ITE
         IF(SA .LE. S(IA,ISA)) GO TO 15
 11    CONTINUE
       WRITE(*,*) 'AGCALC: Internal error. Left points not found.'
       IA = ILE+1
C
      ELSE
C
       DO 12 IA=ITE, ILE, -1
         IF(SA .GE. S(IA,ISA)) GO TO 15
 12    CONTINUE
       WRITE(*,*) 'AGCALC: Internal error. Right points not found.'
       IA = ILE+1
C
      ENDIF
C
C---- three points from which surface angle will be extrapolated to SA
 15   IA1 = IA
      IA2 = IA + INCR
      IA3 = IA + INCR + INCR
C
      IF(ISA.EQ.1) THEN
C------ point where angle is to be calculated lies on upper-side array
        IS1 = 1
        IS2 = 1
        IS3 = 1
        IF(ISIDE.EQ.2) THEN
C-------- angle of lower side is required
          IA1 = IA-1
          IA2 = IA-1 - INCR
          IA3 = IA-1 - INCR - INCR
C
C-------- see if we crossed LE point -- if so, switch side index
          IF(IA1.LT.ILE) THEN
           IA1 = 2*ILE - IA1
           IS1 = 2
          ENDIF
          IF(IA2.LT.ILE) THEN
           IA2 = 2*ILE - IA2
           IS2 = 2
          ENDIF
          IF(IA3.LT.ILE) THEN
           IA3 = 2*ILE - IA3
           IS3 = 2
          ENDIF
        ENDIF
      ELSE
C------ point where angle is to be calculated lies on lower-side array
        IS1 = 2
        IS2 = 2
        IS3 = 2
        IF(ISIDE.EQ.1) THEN
C-------- angle of upper side is required
          IA1 = IA-1
          IA2 = IA-1 - INCR
          IA3 = IA-1 - INCR - INCR
C
C-------- see if we crossed LE point -- if so, switch side index
          IF(IA1.LT.ILE) THEN
           IA1 = 2*ILE - IA1
           IS1 = 1
          ENDIF
          IF(IA2.LT.ILE) THEN
           IA2 = 2*ILE - IA2
           IS2 = 1
          ENDIF
          IF(IA3.LT.ILE) THEN
           IA3 = 2*ILE - IA3
           IS3 = 1
          ENDIF
        ENDIF
C
      ENDIF
C
      IF(IA3.GT.ITE)
     &  WRITE(*,*) '*** AGCALC: Point used for angle is past TE !'
C
C---- set surface segments and linearize wrt parameter
      DX12  =  X(IA1,IS1) -  X(IA2,IS2)
      DY12  =  Y(IA1,IS1) -  Y(IA2,IS2)
      DX23  =  X(IA2,IS2) -  X(IA3,IS3)
      DY23  =  Y(IA2,IS2) -  Y(IA3,IS3)
C
      DX12P = XP(IA1,IS1) - XP(IA2,IS2)
      DY12P = YP(IA1,IS1) - YP(IA2,IS2)
      DX23P = XP(IA2,IS2) - XP(IA3,IS3)
      DY23P = YP(IA2,IS2) - YP(IA3,IS3)
C
      DS12SQ = DX12**2 + DY12**2
      DS23SQ = DX23**2 + DY23**2
C
      DS12 = SQRT(DS12SQ)
      DS23 = SQRT(DS23SQ)
C
C---- set angles of 1-2 and 2-3 segments
      AG23  = ATAN2( -SINCR*DY23 , -SINCR*DX23 )
      AG23P = (DX23*DY23P - DY23*DX23P)/DS23SQ
C
      AG12  = ATAN2( -SINCR*DY12 , -SINCR*DX12 )
      AG12P = (DX12*DY12P - DY12*DX12P)/DS12SQ
C
C---- angle change between segments
      DAG  = AG12  - AG23
      DAGP = AG12P - AG23P
C
C---- remove any multiples of 2 pi  (in case ATAN branch cut was crossed)
      DAG = DAG - TPI*AINT( (DAG + SIGN(PI,DAG))/TPI )
C
C---- angle extrapolation distance from midpoint of 1-2 segment
      DSA = ABS( SA - 0.5*(S(IA1,IS1)+S(IA2,IS2)) )
C
C---- extrapolate angle to SA
      ANGLE  = AG12  + DAG *DSA*2.0/(DS12+DS23)
      ANGLEP = AG12P + DAGP*DSA*2.0/(DS12+DS23)
C
      ANGLE  = ANGLE * 180.0/PI
      ANGLEP = ANGLEP* 180.0/PI
C
      RETURN
      END ! AGCALC


      SUBROUTINE CVCALC(NDIM,ILE,ITE,SG, SSOFF,
     &                  XS,XSP,YS,YSP,SS,SSP,
     &                  CURV,CURVP)
      DIMENSION  XS(NDIM,2), YS(NDIM,2), SS(NDIM,2)
      DIMENSION XSP(NDIM,2),YSP(NDIM,2),SSP(NDIM,2)
C----------------------------------------------------------
C     Calculates surface curvature and its sensitivity
C     wrt some parameter P.
C
C     SG          fractional arc length where angle is to be computed
C                 0 < SG < 1 ... upper side
C                 0 > SG >-1 ... lower side
C     SSOFF       SS offset of left mode endpoint location where SG=0
C                 (+ counterclockwise from stagnation point)
C     XS ,YS       airfoil coordinates
C     SS           arc length
C     XSP,YSP,SSP  dXS/dP  dYS/dP  dSS/dP    ; P = some parameter
C
C     CURV     surface curvature
C     CURVP    dCURV/dP
C----------------------------------------------------------
      PARAMETER (IX=500)
      DIMENSION X(IX), Y(IX), S(IX), XP(IX), YP(IX), SP(IX)
C
      DATA  PI /3.1415926535897932384/
      DATA TPI /6.2831853071795864769/
C
      IF(2*(ITE-ILE) .GT. IX) STOP 'CVCALC:  Array overflow.'
C
C---- put two-side arrays into single arrays around element
      K = 0
      IS = 1
      DO 4 I=ITE, ILE, -1
        K = K+1
        X(K) = XS(I,IS)
        Y(K) = YS(I,IS)
        S(K) = SS(ITE,1) - SS(I,IS)
C
        XP(K) = XSP(I,IS)
        YP(K) = YSP(I,IS)
        SP(K) = SSP(ITE,1) - SSP(I,IS)
 4    CONTINUE
      KLE = K
C
      IS = 2
      DO 5 I=ILE+1, ITE
        K = K+1
        X(K) = XS(I,IS)
        Y(K) = YS(I,IS)
        S(K) = SS(ITE,1) - SS(ILE,1) + SS(I,IS)
C
        XP(K) = XSP(I,IS)
        YP(K) = YSP(I,IS)
        SP(K) = SSP(ITE,1) - SSP(ILE,1) + SSP(I,IS)
 5    CONTINUE
      KK = K
C
      SOFF = SSOFF + S(KLE)
C
C---- set location where curvature is to be evaluated
      IF(SG .GT. 0.0) THEN
        SC = SOFF + SG*(S( 1)-SOFF)
      ELSE
        SC = SOFF - SG*(S(KK)-SOFF)
      ENDIF
C
C---- set two nodes on each side of point SC
      DO 11 K=1, KK
        IF(SC .LE. S(K)) GO TO 15
 11   CONTINUE
      WRITE(*,*) 'CVCALC: Internal error. Bracketing points not found.'
      K = KLE
C
C---- points from which curvature will be calculated, SC is between 2,3
 15   K1 = K - 2
      K2 = K - 1
      K3 = K
      K4 = K + 1
C
      IF(K4.GT.KK .OR. K1.LT.1)
     &  WRITE(*,*) '*** AGCALC: Point used for curvature is past TE !'
C
C---- set surface segments and linearize wrt parameter
      DX12  =  X(K2) -  X(K1)
      DX23  =  X(K3) -  X(K2)
      DY12  =  Y(K2) -  Y(K1)
      DX34  =  X(K4) -  X(K3)
      DY23  =  Y(K3) -  Y(K2)
      DY34  =  Y(K4) -  Y(K3)
      DS12  =  S(K2) -  S(K1)
      DS23  =  S(K3) -  S(K2)
      DS34  =  S(K4) -  S(K3)
C
      DX12P = XP(K2) - XP(K1)
      DX23P = XP(K3) - XP(K2)
      DX34P = XP(K4) - XP(K3)
      DY12P = YP(K2) - YP(K1)
      DY23P = YP(K3) - YP(K2)
      DY34P = YP(K4) - YP(K3)
      DS12P = SP(K2) - SP(K1)
      DS23P = SP(K3) - SP(K2)
      DS34P = SP(K4) - SP(K3)
C
      DS12SQ = DS12**2
      DS23SQ = DS23**2
      DS34SQ = DS34**2
C
C---- x,y location at curvature point (assumed independent of parameter P)
      FC = (SC-S(K2))/DS23
      XC = (1.0-FC)*X(K2) + FC*X(K3)
      YC = (1.0-FC)*Y(K2) + FC*Y(K3)
C
C---- set angles of segments
      AG12  = ATAN2( DY12 , DX12 )
      AG12P = (DX12*DY12P - DY12*DX12P)/DS12SQ
C
      AG23  = ATAN2( DY23 , DX23 )
      AG23P = (DX23*DY23P - DY23*DX23P)/DS23SQ
C
      AG34  = ATAN2( DY34 , DX34 )
      AG34P = (DX34*DY34P - DY34*DX34P)/DS34SQ
C
C---- angle change between segments
      DAG123  = AG23  - AG12
      DAG123P = AG23P - AG12P
C
      DAG234  = AG34  - AG23
      DAG234P = AG34P - AG23P
C
C---- remove any multiples of 2 pi  (in case ATAN branch cut was crossed)
      DAG123 = DAG123 - TPI*AINT( (DAG123 + SIGN(PI,DAG123))/TPI )
      DAG234 = DAG234 - TPI*AINT( (DAG234 + SIGN(PI,DAG234))/TPI )
C
C---- curvatures at centroids of 123, 234
      CV123  = DAG123  * 2.0/(DS12+DS23)
      CV234  = DAG234  * 2.0/(DS23+DS34)
C
      CV123P = DAG123P * 2.0/(DS12+DS23)
     &       - CV123/(DS12+DS23) * (DS12P+DS23P)
      CV234P = DAG234P * 2.0/(DS23+DS34)
     &       - CV234/(DS23+DS34) * (DS23P+DS34P)
C
C---- set centroids where curvatures are known to 2nd order
      X123 = 0.25*X(K1) + 0.50*X(K2) + 0.25*X(K3)
      X234 = 0.25*X(K2) + 0.50*X(K3) + 0.25*X(K4)
      Y123 = 0.25*Y(K1) + 0.50*Y(K2) + 0.25*Y(K3)
      Y234 = 0.25*Y(K2) + 0.50*Y(K3) + 0.25*Y(K4)
C
      X123P = 0.25*XP(K1) + 0.50*XP(K2) + 0.25*XP(K3)
      X234P = 0.25*XP(K2) + 0.50*XP(K3) + 0.25*XP(K4)
      Y123P = 0.25*YP(K1) + 0.50*YP(K2) + 0.25*YP(K3)
      Y234P = 0.25*YP(K2) + 0.50*YP(K3) + 0.25*YP(K4)
C
C---- set distances from centroids to XC,YC
      DSOSQ = (X234-XC)**2 + (Y234-YC)**2
      DSO  = SQRT(DSOSQ)
      DSOP = ( (X234-XC)*X234P + (Y234-YC)*Y234P ) / DSO
C
      DSMSQ = (X123-XC)**2 + (Y123-YC)**2
      DSM  = SQRT(DSMSQ)
      DSMP = ( (X123-XC)*X123P + (Y123-YC)*Y123P ) / DSM
C
C---- interpolate curvatures from centroids to XC,YC
      FRAC  = DSM/(DSM+DSO)
      FRACP = ((1.0-FRAC)*DSMP - FRAC*DSOP)/(DSM+DSO)
C
      CURV  = (1.0-FRAC)*CV123  + FRAC*CV234
      CURVP = (1.0-FRAC)*CV123P + FRAC*CV234P
     &      + FRACP*(CV234-CV123)
C
      RETURN
      END ! CVCALC




      SUBROUTINE VRCALC(N,X,XP,Y,YP,V,VP,
     &                  XLE,YLE,XTE,YTE,
     &                  XVAR, VAR,VARP)
      DIMENSION X(N), XP(N),
     &          Y(N), YP(N),
     &          V(N), VP(N)
C----------------------------------------------------------
C     Calculates local surface variable
C     and its sensitivity wrt some parameter P.
C
C     N         number of points on surface
C     X ,Y ,V   airfoil coordinates, variable
C     XP,YP,VP  dX/dP  dY/dP  dV/dP    ; P = parameter
C     XVAR      chord-based x/c where variable is to be set
C
C     VAR       returned surface variable
C     VARP      dVAR/dP
C----------------------------------------------------------
C
C---- airfoil chord line components
      XCH = XTE - XLE
      YCH = YTE - YLE
      SCH = SQRT(XCH**2 + YCH**2)
C
      VAR  = 0.0
      VARP = 0.0
C
      I = 1
      XM  = ( (X(I) -XLE)*XCH + (Y(I) -YLE)*YCH)/SCH
      XMP = ( (XP(I)    )*XCH + (YP(I)    )*YCH)/SCH
      DO 41 I=2, N
        XO  = ( (X(I) -XLE)*XCH + (Y(I) -YLE)*YCH)/SCH
        XOP = ( (XP(I)    )*XCH + (YP(I)    )*YCH)/SCH
        IF(XVAR.GE.XM .AND. XVAR.LE.XO) GO TO 42
        XM  = XO
        XMP = XOP
 41   CONTINUE
      WRITE(*,*) '*** VRCALC: x/c location not found:', XVAR, XLE, XTE
      I = N
 42   CONTINUE
C
C---- interpolation fractions from bounding points to XVAR
      DX  = XO  - XM
      DXP = XOP - XMP
C
      FM = (XO-XVAR)/DX
      FO = (XVAR-XM)/DX
C
      FMP = ( XOP - DXP*FM)/DX
      FOP = (-XMP - DXP*FO)/DX
C
      VAR  = FO*V(I)  + FM*V(I-1)
      VARP = FO*VP(I) + FM*VP(I-1)
     &     + FOP*V(I) + FMP*V(I-1)
C
      RETURN
      END ! VRCALC



      SUBROUTINE HKLLIN
      INCLUDE 'LINDOP.INC'
      DIMENSION XBI_DUM(IX), YBI_DUM(IX)
      DATA XBI_DUM, YBI_DUM / IX*0.0, IX*0.0 /
C
C---- calculate sensitivities for shape parameter
      DO 20 J=1, NHKFIX
C
        IP = IPHFIX(J)
        IS = ISHFIX(J)
C
        N = (IS+1)/2
C
        I    = ILEB(N,IP)
        NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
C
        DO 205 K=1, NMOD(IP)
          CALL VRCALC(NPTS,
     &                XBI(I,IS,IP),XBI_MOD(I,IS,K,IP),
     &                YBI(I,IS,IP),YBI_MOD(I,IS,K,IP),
     &                 HK(I,IS,IP), HK_MOD(I,IS,K,IP),
     &                XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &                XHKFIX(J), HKLOC(J),HKL_MOD(K,J))
 205    CONTINUE
C
        DO 207 K=1, NPOS(IP)
          CALL VRCALC(NPTS,
     &                XBI(I,IS,IP),XBI_POS(I,IS,K,IP),
     &                YBI(I,IS,IP),YBI_POS(I,IS,K,IP),
     &                 HK(I,IS,IP), HK_POS(I,IS,K,IP),
     &                XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &                XHKFIX(J), HKLOC(J),HKL_POS(K,J))
 207    CONTINUE
C
        CALL VRCALC(NPTS,
     &              XBI(I,IS,IP),XBI_DUM(I),
     &              YBI(I,IS,IP),YBI_DUM(I),
     &               HK(I,IS,IP), HK_ALFA(I,IS,IP),
     &              XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &              XHKFIX(J), HKLOC(J), HKL_ALFA(J))
C
        CALL VRCALC(NPTS,
     &              XBI(I,IS,IP),XBI_DUM(I),
     &              YBI(I,IS,IP),YBI_DUM(I),
     &               HK(I,IS,IP), HK_MACH(I,IS,IP),
     &              XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &              XHKFIX(J), HKLOC(J), HKL_MACH(J))
C
        CALL VRCALC(NPTS,
     &              XBI(I,IS,IP),XBI_DUM(I),
     &              YBI(I,IS,IP),YBI_DUM(I),
     &               HK(I,IS,IP), HK_REYN(I,IS,IP),
     &              XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &              XHKFIX(J), HKLOC(J), HKL_REYN(J))
C
 20   CONTINUE
C
      RETURN
      END ! HKLLIN

