
      PROGRAM LINDOP
C----------------------------------------------------
C                                                    |
C     Program for                                    |
C                                                    |
C    LINear-perturbation Design and OPtimization     |
C                                                    |
C     of multi-element airfoils                      |
C     at multiple operating points.                  |
C                                                    |
C         Mark Drela                                 |
C         MIT Aero & Astro                           |
C                                                    |
C     Copyright MIT  1993                            |
C                                                    |
C     May not be used for commercial purposes        |
C     without license from:                          |
C                                                    |
C     MIT Technology Licensing Office.               |
C           (617) 253-6966                           |
C                                                    |
C     Academic use unrestricted with verbal          |
C     permission from Mark Drela: (617) 253-0067     |
C                                                    |
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 ANS
      LOGICAL ERROR
C
      VERSION = 2.5
C
C---- get run arguments as filename extensions
C     Input :  points.ARGP1  sensx.ARGP1
C              linpar.ARGP1  ophist.ARGP1  params.ARGP1
C     Output:  linpar.ARGP2  ophist.ARGP2  params.ARGP2
C
      ARGP1 = ' '
      ARGP2 = ' '
      CALL GETARG(1,ARGP1)
      CALL GETARG(2,ARGP2)
      IF(ARGP2(1:1).EQ.' ') ARGP2 = ARGP1
C
      LPLOT = .FALSE.
C
      WRITE(*,1005) VERSION
 1005 FORMAT(/' ========================'
     &       /'    LINDOP Version',F4.1
     &       /' ========================' )
C
C---- initialize everything and read sensitivity files
 1    CALL INIT
C
C---- read optimization history file, if any
      CALL HISGET
C
      CALL SHOPNT
C
 899  WRITE(*,1000)
 1000 FORMAT(/'  1  Design/optimization options'
     &       /'  2  Write modified parameters to  params.xxx  files'
     &       /'  3  Write modified-airfoil coordinate file'
     &       /'  4  Display operating points'
     &       /'  5  Sensitivity display options'
     &       /'  6  Gradient scaling options'
     &       /'  7  Save current settings to  linpar.xxx'
     &       /'  8  Plot options'
     &       /'  9  Toggle  CD-CL / CD-Mach  sweep type'
     &       /' 10  Toggle geometry mode linking among points'
     &       /' 11  Toggle position mode linking among points'
     &       /' 12  Read parameters from  params.xxx  files'
     &       /' 13  Change airfoil name'
     &       /' 14  Restart')
C
 900  WRITE(*,1008)
 1008 FORMAT(/1X,'Enter top-level option (0=quit): ',$)
      READ (*,*,ERR=899) IOPT
C
      IF(IOPT.EQ.0) THEN
C------ finish LINDOP session
C
        CALL PLOT(0.0,0.0,+999)
C
        IF(LOPSET) THEN
          FNAME = 'ophist.' // ARGP2
          IBLANK = INDEX(FNAME,' ')
          WRITE(*,9001) FNAME(1:IBLANK-1)
 9001     FORMAT(/1X,'Optimization step has not been appended to  ',A
     &           /1X,'Quit anyway ?  Y' )
          READ (*,9000) ANS
          IF(ANS.EQ.'N' .OR. ANS.EQ.'n') GO TO 900
        ENDIF
C
        IF(LPRSET) THEN
          FNAME = 'linpar.' // ARGP2
          IBLANK = INDEX(FNAME,' ')
          WRITE(*,9002) FNAME(1:IBLANK-1)
 9002     FORMAT(/1X,'Write current settings to  ',A,' ?   Y')
          READ (*,9000) ANS
          IF(ANS.NE.'N' .AND. ANS.NE.'n') CALL LPRWRT
        ENDIF
C
        IF(LDSET) THEN
          FNAME = 'params.' // ARGP2
          IBLANK = INDEX(FNAME,' ')
          WRITE(*,9003) FNAME(1:IBLANK-1)
 9003     FORMAT(/1X,'Write modified parameters to  ',A,'_nn ?   Y')
          READ (*,9000) ANS
          IF(ANS.NE.'N' .AND. ANS.NE.'n') CALL MODWRT
        ENDIF
C
        STOP
      ENDIF
C
      GO TO ( 10, 20, 30, 40, 50, 60, 70, 80, 90, 100,
     &       110,120,130,140                           ),IOPT
      GO TO 899
C
C=================================
 10   CALL EDIT
      GO TO 900
C
C=================================
 20   CALL MODWRT
      GO TO 900
C
C=================================
 30   CALL BLDWRT
      GO TO 900
C
C=================================
 40   CALL SHOPNT
      GO TO 900
C
C=================================
 50   CALL SHOSEN
      GO TO 900
C
C=================================
 60   CALL SCALES
      GO TO 900
C
C=================================
 70   CALL LPRWRT
      GO TO 900
C
C=================================
 80   CALL PLOPTS
      GO TO 900
C
C=================================
 90   LSWEEP = .NOT.LSWEEP
      LPOLAR = .NOT.LSWEEP
      IF(LSWEEP) WRITE(*,*) 'CD-Mach sweep is assumed'
      IF(LPOLAR) WRITE(*,*) 'CD-CL   polar is assumed'
      GO TO 900
C
C=================================
 100  LNKMOD = .NOT.LNKMOD
      IF(     LNKMOD) WRITE(*,*) 'Geometry modes will be linked.'
      IF(.NOT.LNKMOD) WRITE(*,*) 'Geometry modes will not be linked.'
      LXPAR = .FALSE.
      LXHES = .FALSE.
      LXCON = .FALSE.
      LXQLQ = .FALSE.
      LXSYS = .FALSE.
      LPRSET = .TRUE.      
      GO TO 900
C
C=================================
 110  LNKPOS = .NOT.LNKPOS
      IF(     LNKPOS) WRITE(*,*) 'Position modes will be linked.'
      IF(.NOT.LNKPOS) WRITE(*,*) 'Position modes will not be linked.'
      LXPAR = .FALSE.
      LXHES = .FALSE.
      LXCON = .FALSE.
      LXQLQ = .FALSE.
      LXSYS = .FALSE.
      LPRSET = .TRUE.
      GO TO 900
C
C=================================
 120  CALL MODGET
      GO TO 900
C
C=================================
 130  CALL NAMGET
      GO TO 900
C
C=================================
 140  IF(LPRSET) THEN
       FNAME = 'linpar.' // ARGP2
       IBLANK = INDEX(FNAME,' ')
       WRITE(*,9002) FNAME(1:IBLANK-1)
       READ (*,9000) ANS
       IF(ANS.NE.'N' .AND. ANS.NE.'n') CALL LPRWRT
      ENDIF
      GO TO 1
C
C..............................................
 9000 FORMAT(A)
      END ! LINDOP



      SUBROUTINE INIT
      INCLUDE 'LINDOP.INC'
C
      LOGICAL LUPINI
      CHARACTER*10 DIGITS
      DATA DIGITS / '0123456789' /
C
C---- set digit string array for filename operating-point suffix
      DO 2 KP=1, 99
        K2 =          KP/10   + 1
        K1 = KP - 10*(KP/10)  + 1
        PNUM(KP) = DIGITS(K2:K2) // DIGITS(K1:K1)
 2    CONTINUE
C
C---- global constants
      PI = 4.0*ATAN(1.0)
      DTOR = PI/180.0
C
C---- cp/cv
      GAM = 1.4
      GM1 = GAM - 1.0
C
C---- initialize plot parameters
      CALL PPINIT
C
C---- read all sensitivity input files
      CALL INPUT
C
C---- default geometry-sensitivity point
cc    IPGSEN = 1
      IPGSEN = NPOINT
C
C---- default stress-type calculation
ccc   ISGTYP = 1       ! skin
      ISGTYP = 2       ! solid
C
C---- check if solutions were adequately converged
      CALL RESCHK
C
cC---- read user-defined parameter file
c      CALL USRGET
cC
cC---- check for as many user constraints as array limits permit
c      CALL UCCHEK
C
C---- assume max number of user parameters,constraints for initialization
      NUPAR = NUPX
      NUCON = NUCX
C
C---- initialize active-parameter indicator flags
      DO 22 IP=1, NPOINT
        LALFA(IP) = .FALSE.
        LMACH(IP) = LDEPMA(IP)
        LREYN(IP) = LDEPRE(IP)
C
        DO 221 K=1, NMOD(IP)
          LMOD(K,IP) = .TRUE.
 221    CONTINUE
        DO 222 K=1, NPOS(IP)
          LPOS(K,IP) = .TRUE.
 222    CONTINUE
 22   CONTINUE
      DO 28 IPAR=1, NUPAR
        LUPAR(IPAR) = .FALSE.
 28   CONTINUE
C
      DO 40 IP=1, NPOINT
C------ initialize mode-presence flag for each element side
        DO 406 IS=1, 2*NBL(IP)
          N = (IS+1)/2
          NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
          LMODES(IS,IP) = .FALSE.
          DO 4064 K=1, NMOD(IP)
            DO 4064 IG=1, NPTS
              LMODES(IS,IP) = GN(IG,IS,K,IP) .NE. 0.0
              IF(LMODES(IS,IP)) GO TO 406
 4064     CONTINUE
 406    CONTINUE
 40   CONTINUE
C
C---- set and linearize surface arc lengths
      CALL SETSBI
C
C---- set horizontal plot coordinate arrays according to IXPLT
      CALL SETXPL
C
C---- number of function variables
      NVAR = 2
ccc      NVAR = 4
      IF(REYN(1) .EQ. 0.0) NVAR = 1
      IF(NVAR.GT.NVX) STOP 'Too many function variables. Increase NVX.'
C
C---- set variable offsets for scaling
      VAROFF(1) = 1.0
      VAROFF(2) = 0.0
ccc      VAROFF(3) = 0.0
ccc      VAROFF(4) = 0.0
C
      ANNFAC(1) = 1.0
      ANNFAC(2) = 1.0
ccc      ANNFAC(3) = 100.0
ccc      ANNFAC(4) = 1.0
C
C---- set plot scale factors for each point
      DO 50 IP=1, NPOINT
        CALL VARSCL(IP)
 50   CONTINUE
C
C---- set element centroids
      CALL XYCENT
C
C---- default locations for left and right angle and slope constraints
      CALL XYFINI
C
C---- default structural parameters for skin strain
      DO 55 N=1, NBL(IPGSEN)
C------ top/bottom skin-thickness ratio
        TBSKIN(N) = 1.5
C
C------ front,back x/c limits of stressed load-bearing material
        XSTRF(N) = 0.15
        XSTRB(N) = 0.65
C
C------ no local-thickness positions defined yet
        NTHFIX(N) = 0
 55   CONTINUE
C
C---- initialize all mods
      CALL CLRMOD(.TRUE.)
      CALL CLRAMR(.TRUE. , 0)
      CALL CLRUSR(.TRUE.)
C
C---- initialize constraints
      CALL CLRCON
C
      DO 61 IP=1, NPOINT
        IF(LMAFIX(IP)) WRITE(*,1600)
     &   'Ma sqrt(CL) =',MSQCL(IP),'    constraint set for point', IP
 61   CONTINUE
C
      DO 62 IP=1, NPOINT
        IF(LREFIX(IP)) WRITE(*,1600)
     &   'Re sqrt(CL) =',RSQCL(IP) / 1.0E6,
     &                             'E6  constraint set for point', IP
 62   CONTINUE
C
 1600 FORMAT(1X,A,F9.5,A,I4)
C
      WRITE(*,*)
C
C---- initialize unwritten-change flag, 
C-    modified-settings flag,
C-    unwritten optimization-change flag
      LDSET  = .FALSE.
      LPRSET = .FALSE.
      LOPSET = .FALSE.
C
C---- initialize various existence flags
      LXPAR = .FALSE.
      LXHES = .FALSE.
      LXCON = .FALSE.
      LXSYS = .FALSE.
      LXQLQ = .FALSE.
C
C---- transformed-space optimization will be performed
      LTRNSF = .TRUE.
C
C---- approximate Hessian has not been updated
      LHESUP = .FALSE.
C
C---- constrained objective-function derivatives have not been set
      LFCSET = .FALSE.
C
C---- geometry and position modes will be linked for all points
      LNKMOD = .TRUE.
      LNKPOS = .TRUE.
C
C---- check if this is a Mach sweep or an alpha sweep
      LSWEEP = NPOINT .GT. 1
      DO 70 IP=2, NPOINT
        LSWEEP = LSWEEP .AND. 
     &           (ABS(CL  (IP)-CL  (IP-1)) .LT. 0.01  .OR.
     &            ABS(ALFA(IP)-ALFA(IP-1)) .LT. 0.001 .OR.
     &            ABS(MACH(IP)-MACH(IP-1)) .GT. 0.001     )
 70   CONTINUE
      LPOLAR = .NOT. LSWEEP
C
C---- set airfoil geometry x,y extrema for plot scaling
      CALL XYBLIM
C
C---- set default objective-function type
      IFTYPE = 1
      IF(NUPAR.GT.0) IFTYPE = 0
C
C---- initialize optimization step size
      LOPDIR = .FALSE.
      DO 72 IH=1, NHISX
        OPSTEP(IH) = 0.0
 72   CONTINUE
C
C---- initialize objective-function derivative estimates ...
C---- ... with respect to alpha, Mach, ln(Re)
      GSCAL = 1.0
      GSCMA = 1.0
      GSCLR = 1.0
C
C---- ... with respect to geometry and position modes
      DO 84 K=1, NMODMX
        GSCMOD(K) = 1.0
 84   CONTINUE
C
      DO 86 K=1, NPOSMX
        GSCPOS(K) = 1.0
 86   CONTINUE
C
C---- ... with respect to user parameters 
C-    (will likely need interactive re-scaling)
      DO 90 K=1, NUPX
        GSCUP(K) = 1.0
 90   CONTINUE

C---- initialize perturbation for visual gradient-scaling options
      DELTRY = 0.01
C
C---- max allowable condition number of optimization Hessian
cc      CONDMX = 1.0E5
      CONDMX = 1.0E6
C
C---- plot gradient-scaling perturbations
      LGSCPL = .TRUE.
C
C---- no Hk constraints set
      NHKFIX = 0
C
C---- read previous settings if file exists
      CALL LPRGET
C
C---- initialize specified-variable array
      IF(IPTARG.NE.999 .AND.
     &   ISTARG.NE.999 .AND.
     &   IVTARG.NE.999      ) CALL INITSP(0,0)
C
C---- set geometric quantity sensitivities
      CALL GEOLIN
      CALL THBLIN
      CALL ANGLIN
      CALL CRVLIN
      CALL HKLLIN
C
C---- initialize specified geometric quantities
      CALL GSPINI
C
C
C---- read user-defined parameter file
      CALL USRGET
C
C---- initialize user routines
      CALL USRINI
C
C---- check for as many user constraints as array limits permit
      CALL UCCHEK
C
      RETURN
      END ! INIT



      SUBROUTINE XYFINI
      INCLUDE 'LINDOP.INC'
C
C---- default locations for left and right angle and slope constraints
      IP = IPGSEN
      DO 45 IS=1, 2*NBL(IP)
        N = (IS+1)/2
        IS1 = 2*N - 1
        KS = IS - IS1 + 1
C
        DXB = XTEB(N,IP) - XLEB(N,IP)
        DYB = YTEB(N,IP) - YLEB(N,IP)
        CHB = SQRT(DXB**2 + DYB**2)
C
        SBLFIX(IS) = 0.
        SBRFIX(IS) = 1.0
C
C------ set x/c locations at default s/smax locations
        CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &              XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &              SBLEGN(N,IP), KS, SBLFIX(IS), XB1, YB1)
        XBLFIX(IS) = ( (XB1-XLEB(N,IP))*DXB
     &               + (YB1-YLEB(N,IP))*DYB ) / CHB
C
        CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &              XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &              SBLEGN(N,IP), KS, SBRFIX(IS), XB1, YB1)
        XBRFIX(IS) = ( (XB1-XLEB(N,IP))*DXB
     &               + (YB1-YLEB(N,IP))*DYB ) / CHB
C
 45   CONTINUE
C
      RETURN
      END ! XYFINI


      SUBROUTINE INPUT
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 ANS
      LOGICAL ERROR
C
C---- first assume all points will be used
      DO 4 IP=1, NPX
        KPOINT(IP) = IP
 4    CONTINUE
      NPMAX = NPX
C
C---- try to read  points.xxx  file
      LEN1 = INDEX(ARGP1,' ') - 1
      FNAME = 'points.' // ARGP1(1:LEN1)
      OPEN(9,FILE=FNAME,STATUS='OLD',ERR=7)
      WRITE(*,*)
      WRITE(*,*) 'Read points specified in ',FNAME(1:LEN1+7),' ?   Y'
      READ (*,1000) ANS
C
      IF(ANS.NE.'N' .AND. ANS.NE.'n') THEN
       DO 5 IP=1, NPX
         READ(9,*,END=6) KPOINT(IP)
 5     CONTINUE
 6     NPMAX = IP-1
      ENDIF
C
      CLOSE(9)
 7    CONTINUE
C
      NPOINT = 0
C
C---- try to read in all sensx.xxx_n files
      DO 10 IP=1, NPMAX
        KP = KPOINT(IP)
        FNAME = 'sensx.' // ARGP1(1:LEN1) // '_' // PNUM(KP)
        CALL SNREAD(FNAME,IP,ERROR)
        IF(ERROR) GO TO 11
C
ccc        WRITE(*,1020) KP, MACH(IP), REYN(IP)/1.0E6,
ccc     &                     ALFA(IP)/DTOR, CL(IP), CD(IP)
        IF(IP.EQ.1) WRITE(*,1010) 'Reading ',FNAME(1:LEN1+7)
        WRITE(*,1025) PNUM(KP)
 10   CONTINUE
      IP = NPMAX+1
C
 11   CONTINUE
      NPOINT = IP-1
C
C---- assume a sequence of points will be read
      LSEQ = .TRUE.
C
      IF(NPOINT.EQ.NPX) THEN
       WRITE(*,*)
       WRITE(*,*) 'INPUT: Operating-point array limit NPX reached.'
      ENDIF
C
      IF(NPOINT.LE.0) THEN
C----- read single dump file with no number suffix
       FNAME = 'sensx.' // ARGP1(1:LEN1)
       IP = 1
       CALL SNREAD(FNAME,IP,ERROR)
       IF(ERROR) GO TO 18
C
       WRITE(*,1010) 'Reading ',FNAME(1:LEN1+6)
C
       NPOINT = 1
       LSEQ = .FALSE.
      ENDIF
C
C
 18   WRITE(*,*)
      IF(NPOINT.LE.0) STOP 'No sensitivity dump files found'
C
      NMODMX = NMOD(1)
      NPOSMX = NPOS(1)
      DO 20 IP=2, NPOINT
        NMODMX = MAX(NMODMX,NMOD(IP))
        NPOSMX = MAX(NPOSMX,NPOS(IP))
        IF(NMOD(IP-1).NE.NMOD(IP)) WRITE(*,1050) IP-1, IP
        IF(NPOS(IP-1).NE.NPOS(IP)) WRITE(*,1060) IP-1, IP
 20   CONTINUE
C
      RETURN
C.......................................................................
 1000 FORMAT(A1)
 1010 FORMAT(/1X,A,A, $)
ccc     &      //'       Ma    Re/10^6   alpha    CL       CD' )
cccC                9  0.7234   0.500   10.523  1.2345  0.01324
ccc 1020 FORMAT(1X,I2,F8.4,    F8.3,    F9.3,  F8.4,   F9.5)
 1025 FORMAT(A2,' ', $)
 1050 FORMAT(/
     &' *** Warning: Number of geometry modes different between points',
     &       I3,' and', I3)
 1060 FORMAT(/
     &' *** Warning: Number of position modes different between points',
     &       I3,' and', I3)
 1150 FORMAT(/' ***', A,' not available as a DOF in point',I3)
      END ! INPUT



      SUBROUTINE RESCHK
      INCLUDE 'LINDOP.INC'
      LOGICAL CONV(NPX)
      INCLUDE 'EPS.INC'
C-----------------------------------------------------------
C     Checks if MSES solutions were adequately converged.
C-----------------------------------------------------------
C
      DO 10 IP=1, NPOINT
        CONV(IP) = DRRMS(IP)  .LT. EPSR      .AND.
     &             DNRMS(IP)  .LT. EPSN      .AND.
     &             DVRMS(IP)  .LT. EPSV      .AND.
     &         ABS(DRMAX(IP)) .LT. EPSR*10.0 .AND.
     &         ABS(DNMAX(IP)) .LT. EPSN*10.0 .AND.
     &         ABS(DVMAX(IP)) .LT. EPSV*10.0
 10   CONTINUE
C
      DO 20 IP=1, NPOINT
        IF(.NOT.CONV(IP)) GO TO 29
 20   CONTINUE
      RETURN
C
 29   CONTINUE
      WRITE(*,*)
      WRITE(*,*) '*** Points may not be adequately converged...'
      WRITE(*,*)
     &    'point    rms(dRho)    rms(dVisc)     max(dRho)    max(dVisc)'
CCC         10     -0.1234E-02  -0.1234E-02    -0.1234E-02  -0.1234E-02
      DO 30 IP=1, NPOINT
        IF(.NOT.CONV(IP)) 
     &      WRITE(*,1000) IP, DRRMS(IP),DVRMS(IP),DRMAX(IP),DVMAX(IP)
 30   CONTINUE
 1000 FORMAT(1X, I3, 3X, 2E13.4, 2X, 2E13.4)
C
      RETURN
      END ! RESCHK


      SUBROUTINE USRGET
      INCLUDE 'LINDOP.INC'
C-----------------------------------------------------------
C     Reads user-defined parameter names and current values
C-----------------------------------------------------------
C
      NUPAR = 0
C
      FNAME = 'usrpar.' // ARGP1
      LU = 8
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=240)
C
      READ(LU,*) NUPAR
      IF(NUPAR.GT.NUPX) STOP 'USRGET: Array overflow. Increase NUPX.'
C
      DO 20 K=1, NUPAR
        READ(LU,1010) LINE
ccc        CALL STRIP(LINE,NN)
        KBAR = INDEX(LINE,'|') 
        IF(KBAR.EQ.0) KBAR = 8
        READ(LINE(1:KBAR-1),1050) UPNAME(K)
        READ(LINE(KBAR+1:80),*) UPAR(K), EPUPAR(K)
 20   CONTINUE
      CLOSE(LU)
C
      K = INDEX(FNAME,' ')
      WRITE(*,1070) FNAME(1:K)
      DO K=1, NUPAR
        WRITE(*,1080) K, UPNAME(K), UPAR(K)
      ENDDO
C
 240  CONTINUE
C
      RETURN
C
 1010 FORMAT(A80)
 1050 FORMAT(A8)
 1070 FORMAT(/' User parameters read from file  ', A, ' ...')
 1080 FORMAT( 1X,I3,2X,A, E14.4)
      END ! USRGET


      SUBROUTINE UCCHEK
      INCLUDE 'LINDOP.INC'
C--------------------------------------------------
C     Checks which user constraints are defined.
C--------------------------------------------------
C
C---- test-call each constraint, set maximum available-constraint number
      NUCON = 0
      DO 10 ICON=1, NUCX
        LUCDEF(ICON) = .FALSE.
        ICONT = ICON
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICONT, UCNAME(ICON), UCRES(ICON),
     &            UPAR,
     &            ALFA,
     &            MACH,
     &            REYN,
     &            CL  ,
     &            CDF ,
     &            CDP ,
     &            CM  ,
     &            AREAB ,
     &            EI11B ,
     &            ASIGB ,
     &            THIKB ,
     &            MODN ,
     &            POSN   )
C
        IF(ICONT.EQ.0) GO TO 10
C
        LUCDEF(ICON) = .TRUE.
        NUCON = MAX(ICON,NUCON)
 10   CONTINUE
C
      IF(NUCON.EQ.0) THEN
        WRITE(*,*)
        WRITE(*,*) 'No user-defined constraints are available.'
        RETURN
      ELSE
        WRITE(*,*)
        WRITE(*,*) 'User-defined constraints, current residuals...'
      ENDIF
C
      DO 20 ICON=1, NUCON
        IF(LUCDEF(ICON)) THEN
          WRITE(*,2050) ICON, UCNAME(ICON), UCRES(ICON)
 2050     FORMAT(1X,I3,2X,A8,E14.4)
        ENDIF
 20   CONTINUE
C
      WRITE(*,*)
C
      RETURN
      END ! UCCHEK



      SUBROUTINE PPINIT
      INCLUDE 'LINDOP.INC'
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU=80   (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU=IPSLU
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.90
C
C---- Default plot size in inches
C-    (Default plot window is 11.0 x 8.5)
      SIZE = 10.5
C
C---- left edge margin, bottom edge margin (inches)
      XMARG = 0.225
      YMARG = 0.225
C
C---- overall plot aspect ratio, character height
      PLAR  = 8.0/SIZE
      CH = 0.010
C
C---- initialize plot library, set default colormap
      CALL PLINITIALIZE
C
C---- assign colors to operating points
      PCOLOR(1) = 'red'
      PCOLOR(2) = 'orange'
      PCOLOR(3) = 'yellow'
      PCOLOR(4) = 'green'
      PCOLOR(5) = 'cyan'
      PCOLOR(6) = 'blue'
      PCOLOR(7) = 'violet'
      PCOLOR(8) = 'magenta'
      DO IP=9, NPX
        IP1 = MOD(IP,8)
        PCOLOR(IP) = PCOLOR(IP1)
      ENDDO
C
C---- default modified-distribution color
      MCOLOR = 'wheat'
C
C---- width fractions for left and right plot sections
      PLDX1 = 0.65
      PLDX2 = 0.35
C
C---- fraction of PLDX1 taken up by objective function info
      FRDX1 = 0.4
C
C---- height fractions for bot, mid, top plot sections on left
      PLDY1 = 0.25 * PLAR
      PLDY2 = 0.20 * PLAR
      PLDY3 = 0.55 * PLAR
C
C---- fraction of section width,height occupied by x,y-axes
      XFR = 0.85
      YFR = 0.85
C
C---- default type of plot x-coordinate
      IXPLT = 1
C
C---- default target point number, side, variable (999 = no default)
      IPTARG = 999
      ISTARG = 999
      IVTARG = 999
      L2SIDE = .FALSE.
C
      RETURN
      END ! PPINIT


      FUNCTION CPSTAR(IPOINT)
      INCLUDE 'LINDOP.INC'
C
      IP = IPOINT
      MSQ = (MACH(IP) + DMACH(IP))**2
C
      PXRAT = (1.0 + 0.5*GM1*MSQ)/(1.0 + 0.5*GM1)
      CPSTAR = (PXRAT**(GAM/GM1) - 1.0) * 2.0/(GAM*MSQ)
C
      RETURN
      END ! CPSTAR


      SUBROUTINE MODWRT
      INCLUDE 'LINDOP.INC'
C
      LEN2 = INDEX(ARGP2,' ') - 1
C
C---- write all params.xxx_n files
      LU = 8
      DO 10 IP=1, NPOINT
C
        IF(LSEQ) THEN
         KP = KPOINT(IP)
         FNAME = 'params.' // ARGP2(1:LEN2) // '_' // PNUM(KP)
         IF(IP.EQ.1)
     &    WRITE(*,1010) 'Writing parameter file ', FNAME(1:LEN2+8)
         WRITE(*,1025) PNUM(KP)
        ELSE
         FNAME = 'params.' // ARGP2(1:LEN2)
         IF(IP.EQ.1) 
     &    WRITE(*,1010) 'Writing parameter file ', FNAME(1:LEN2+7)
        ENDIF
C
        OPEN(LU,FILE=FNAME,STATUS='UNKNOWN')
        REWIND LU
C
        WRITE(LU,*) NMOD(IP), NPOS(IP)
C
        DO 102 K=1, NMOD(IP)
          MOD1 = MODN(K,IP) + DMOD(K,IP)
          WRITE(LU,*) MOD1
 102    CONTINUE
C
        DO 104 K=1, NPOS(IP)
          POS1 = POSN(K,IP) + DPOS(K,IP)
          WRITE(LU,*) POS1
 104    CONTINUE
C
        ALFA1 = ALFA(IP) + DALFA(IP)
        MACH1 = MACH(IP) + DMACH(IP)
        REYN1 = REYN(IP) + DLNRE(IP)*REYN(IP)
        CL1   = CL(IP) + CL_ALFA(IP)*DALFA(IP)
     &                 + CL_MACH(IP)*DMACH(IP)
     &                 + CL_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 106 K=1, NMOD(IP)
          CL1 = CL1 + CL_MOD(K,IP)*DMOD(K,IP)
 106    CONTINUE
        DO 107 K=1, NPOS(IP)
          CL1 = CL1 + CL_POS(K,IP)*DPOS(K,IP)
 107    CONTINUE
C
        WRITE(LU,*) ALFA1/DTOR, CL1, MACH1, REYN1
        CLOSE(LU)
C
 10   CONTINUE
C
      WRITE(*,*)
C
      IF(NUPAR.GT.0) THEN
       FNAME = 'usrpar.' // ARGP2(1:LEN2)
       WRITE(*,*) 'Writing user-parameter file ', FNAME(1:LEN2+7)
       LU = 8
       OPEN(LU,FILE=FNAME,STATUS='UNKNOWN')
       REWIND LU
       WRITE(LU,*) NUPAR
       DO 20 K=1, NUPAR
         UPAR1 = UPAR(K) + DUPAR(K)
         WRITE(LU,1080) UPNAME(K), UPAR1, EPUPAR(K)
 20    CONTINUE
       CLOSE(LU)
      ENDIF
C
C---- no unsaved changes now
      LDSET = .FALSE.
C
      RETURN
C...................................
 1000 FORMAT(A1)
 1010 FORMAT(1X,A,A,$)
 1025 FORMAT(A2,' ',$)
 1080 FORMAT(A8, '  |  ', 2E16.8)
      END ! MODWRT
      
      
      
      SUBROUTINE MODGET
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 ANS
C     
      LU = 9
C     
      LEN1 = INDEX(ARGP1,' ') - 1
C
      IF(LSEQ) THEN
       LINE = PNUM(1)
       DO 5 IP=2, NPOINT
          LINE = LINE(1:3*IP-4) // ' ' // PNUM(IP)
 5     CONTINUE
       WRITE(*,1010) 'Read changes from  params.',
     &     ARGP1(1:LEN1),'_', LINE(1:3*NPOINT-1), ' ?   Y'
      ELSE
       WRITE(*,1010) 'Read changes from  params.',
     &     ARGP1(1:LEN1),' ?   Y'
      ENDIF
C
      READ(*,1000) ANS
C
 1000 FORMAT(A1)
 1010 FORMAT(/1X,A,A,A,A,A)
C     
      IF(ANS.EQ.'N' .OR. ANS.EQ.'n')
     & WRITE(*,2000) 'Enter filenames for points ("!" to quit) ...'
C
      DO 10 IP=1, NPOINT
C
        IF(LSEQ) THEN
         FNAME = 'params.' // ARGP1(1:LEN1) // '_' // PNUM(IP)
        ELSE
         FNAME = 'params.' // ARGP1(1:LEN1)
        ENDIF
C
        IF(ANS.EQ.'N' .OR. ANS.EQ.'n') THEN
         WRITE(*,1015) IP, FNAME(1:40)
 1015    FORMAT(1X,'point ',I2,':  ',A)
         READ (*,2000) LINE
 2000    FORMAT(A80)
         IF(LINE(1:1) .NE. ' ') FNAME = LINE    
        ENDIF
C     
        OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=900)
C     
        READ(LU,*,ERR=800) NMOD1, NPOS1
C     
        IF(IABS(NMOD1).NE.NMOD(IP)) THEN
         WRITE(*,*) '*** Wrong number of geometry modes. File not read.'
         CLOSE(LU)
         LDSET = .FALSE.
         GO TO 10
        ENDIF
C     
        IF(IABS(NPOS1).NE.NPOS(IP)) THEN
         WRITE(*,*) '*** Wrong number of position modes. File not read.'
         CLOSE(LU)
         LDSET = .FALSE.
         GO TO 10
        ENDIF
C     
C------ read in prescribed mode amplitudes and set implied changes
C-      (just changes are assumed if NMOD,NPOS < 0)
        DO 102 K=1, NMOD(IP)
          READ(LU,*,ERR=800) MOD1
          DMOD(K,IP) = MOD1 - MODN(K,IP)
          IF(NMOD1.LT.0) DMOD(K,IP) = MOD1
 102    CONTINUE
C     
        DO 104 K=1, NPOS(IP)
          READ(LU,*,ERR=800) POS1
          DPOS(K,IP) = POS1 - POSN(K,IP)
          IF(NPOS1.LT.0) DPOS(K,IP) = POS1
 104    CONTINUE
C     
C------ read in prescribed flow parameters and set implied changes
        READ(LU,*,ERR=810) ADEG1, CL1, MACH1, REYN1
        DALFA(IP) = ADEG1*DTOR - ALFA(IP)
        DMACH(IP) = MACH1      - MACH(IP)
        DREYN     = REYN1      - REYN(IP)
        DLNRE(IP) = 0.
        IF(REYN(IP).GT.0.0) DLNRE(IP) = DREYN/REYN(IP)
C     
        CLOSE(LU)
 10   CONTINUE
C
C---- no "unsaved" changes for now
      LDSET = .FALSE.
      RETURN
C     
 800  WRITE(*,*) 'File read error.  Some changes read.'
      CLOSE(LU)
      LDSET = .TRUE.
      RETURN
C     
 810  WRITE(*,*) 'File incomplete.  Only geometric changes read.'
      CLOSE(LU)
      LDSET = .TRUE.
      RETURN
C     
 900  WRITE(*,*) 'File not found'
      LDSET = .FALSE.
      RETURN
      END ! MODGET


      SUBROUTINE NAMGET
      INCLUDE 'LINDOP.INC'
      LOGICAL ERROR
C
      WRITE(*,1010) (IP,NAME(IP),IP=1,NPOINT)
 1010 FORMAT(/1X,'Current point name(s)...',
     &     /( 1X,I2,':  ',A) )
C
      KP = 0
      IF(NPOINT .GT. 1) THEN
 10      WRITE(*,1110) KP
 1110  FORMAT(/1X,' Change name for which point (0=all):', I3)
       CALL READI(1,KP,ERROR)
       IF(ERROR) GO TO 10
      ENDIF
C
      IP1 = KP
      IP2 = KP
      IF(KP.EQ.0) THEN
       IP1 = 1
       IP2 = NPOINT
      ENDIF
C
      WRITE(*,1200)
 1200 FORMAT(1X,'Enter name:  ',$)
      READ (*,2000) NAME(IP1)
 2000 FORMAT(A)
C
      DO 20 IP=IP1+1, IP2
        NAME(IP) = NAME(IP1)
 20   CONTINUE
C
      RETURN
      END ! NAMGET


      LOGICAL FUNCTION SAMEP(NKDIM,A,NK,NP)
      DIMENSION A(NKDIM,NP), NK(NP)
C
      DO 1 IP=1, NP-1
        DO 11 K=1, NK(IP)
          IF(A(K,IP) .NE. A(K,IP+1)) THEN
           SAMEP = .FALSE.
           RETURN
          ENDIF
 11     CONTINUE
 1    CONTINUE
C
      SAMEP = .TRUE.
      RETURN
      END ! SAME



      SUBROUTINE BLDWRT
      INCLUDE 'LINDOP.INC'
      CHARACTER*32 NAME2
      LOGICAL ERROR, SAMEP
      DIMENSION GRDIM(4)
C
C---- see if mode or position changes are different between points
      IF(SAMEP(NMODX,DMOD,NMOD,NPOINT) .AND.
     &   SAMEP(NPOSX,DPOS,NPOS,NPOINT)       ) THEN
        IP = 1
      ELSE
        IP = 1
        WRITE(*,*) 'Mode changes are different between points.'
 12     WRITE(*,*) 'Enter point number for output geometry:', IP
        CALL READI(1,IP,ERROR)
        IF(ERROR) GO TO 12
      ENDIF
C
      NAME2 = NAME(IP)
      WRITE(*,1000) 'Enter name of airfoil:  ', NAME2
      READ (*,1010) LINE
      IF(LINE(1:1).NE.' ') NAME2 = LINE
C
      LEN2 = INDEX(ARGP2,' ') - 1
      FNAME = 'blade.' // ARGP2(1:LEN2)
      WRITE(*,1000) 'Enter output filename:  ', FNAME(1:LEN2+6)
      READ (*,1010) LINE
      IF(LINE(1:1).NE.' ') FNAME = LINE
C
      GRDIM(1) = -2.0
      GRDIM(2) =  3.0
      GRDIM(3) = -2.5
      GRDIM(4) =  3.5
C
 40   WRITE(*,1300) 'Enter grid boundaries:  Xinl Xout Ybot Ytop', GRDIM
      NGR = 4
      CALL READR(NGR,GRDIM,ERROR)
      IF(ERROR) GO TO 40
C
      XINL = GRDIM(1)
      XOUT = GRDIM(2)
      YBOT = GRDIM(3)
      YTOP = GRDIM(4)
C
      LU = 9
      OPEN(LU,FILE=FNAME,STATUS='UNKNOWN',ERR=99)
      REWIND LU
C
      WRITE(LU,1400) NAME2
      WRITE(LU,1450) XINL, XOUT, YBOT, YTOP
C
      DO 50 N=1, NBL(IP)
C
C---- set index limits for side 1
      I1 = ITEB(N,IP)
      I2 = ILEB(N,IP)
      INCR = -1
C
C---- go over the two sides of this element
      DO 49 IS=2*N-1, 2*N
C
C------ go over all points on this element
        DO 504 I=I1, I2, INCR
          XB = XBI(I,IS,IP)
          YB = YBI(I,IS,IP)
C
C-------- add on geometry deformation (typically normal to surface)
          DO 5042 K=1, NMOD(IP)
            XB = XB + XBI_MOD(I,IS,K,IP)*DMOD(K,IP)
            YB = YB + YBI_MOD(I,IS,K,IP)*DMOD(K,IP)
 5042     CONTINUE
C
C-------- add on element translations and/or rotations
          DO 5044 K=1, NPOS(IP)
C
C---------- examine all elements influenced by this mode
            DO NN=1, NPOSEL(K,IP)
C
C------------ add on change if this is the appropriate element
              IF(NBPOS(NN,K,IP) .NE. N) GO TO 5044
C
               IF(ABPOS(NN,K,IP) .EQ. 0.0) THEN
C-------------- translation
                XB = XB + XBPOS(NN,K,IP)*DPOS(K,IP)
                YB = YB + YBPOS(NN,K,IP)*DPOS(K,IP)
               ELSE
C-------------- rotation
                ANG = ABPOS(NN,K,IP)*DPOS(K,IP)
                SINA = SIN(ANG)
                COSA = COS(ANG)
                XBAR = XBI(I,IS,IP) - XBPOS(NN,K,IP)
                YBAR = YBI(I,IS,IP) - YBPOS(NN,K,IP)
                DXB = XBPOS(NN,K,IP)+COSA*XBAR+SINA*YBAR - XBI(I,IS,IP)
                DYB = YBPOS(NN,K,IP)+COSA*YBAR-SINA*XBAR - YBI(I,IS,IP)
                XB = XB + DXB
                YB = YB + DYB
               ENDIF
            ENDDO
 5044     CONTINUE
          WRITE(LU,1500) XB, YB
 504    CONTINUE
C
C------ set index limits for side 2
        I1 = ILEB(N,IP)+1
        I2 = ITEB(N,IP)
        INCR = 1
C
 49   CONTINUE
      IF(N.LT.NBL(IP)) WRITE(LU,1550)
C
 50   CONTINUE
C
      CLOSE(LU)
      RETURN
C
 99   WRITE(*,*) 'File OPEN error.  Coordinates not saved'
      RETURN
C
 1000 FORMAT(/1X,A,A)
 1010 FORMAT(A80)
 1300 FORMAT(1X,A,4F10.3)
 1400 FORMAT(1X,A32)
 1450 FORMAT(1X,2F4.1,4F8.2)
 1500 FORMAT(1X,2F10.6)
 1550 FORMAT(1X,'999.0    999.0')
      END ! BLDWRT



      SUBROUTINE LPRWRT
      INCLUDE 'LINDOP.INC'
C
C---- write out settings to linpar.xxx file
      LU = 9
      FNAME = 'linpar.' // ARGP2
      OPEN(LU,FILE=FNAME,STATUS='UNKNOWN')
      REWIND LU
C
      NBLG = NBL(IPGSEN)
C
      WRITE(LU,*) NPOINT, IPGSEN, NBLG, NHKFIX
      WRITE(LU,*) NUPAR, NUCON
      WRITE(LU,*) (NTHFIX(N), N=1, NBLG)
      WRITE(LU,*) IPTARG,ISTARG,IVTARG, IXPLT
      WRITE(LU,*) LNKMOD, LNKPOS, L2SIDE, LTRNSF
      WRITE(LU,*) DELTRY, CONDMX
C
      DO 2 IP=1, NPOINT
        WRITE(LU,*) NMOD(IP), NPOS(IP), NBL(IP)
 2    CONTINUE
C
      DO 3 IP=1, NPOINT
        WRITE(LU,*) (LMOD(K,IP), K=1, NMOD(IP))
 3    CONTINUE
C
      DO 4 IP=1, NPOINT
        WRITE(LU,*) (LPOS(K,IP), K=1, NPOS(IP))
 4    CONTINUE
C
      WRITE(LU,*) (LALFA(IP), IP=1, NPOINT)
      WRITE(LU,*) (LMACH(IP), IP=1, NPOINT)
      WRITE(LU,*) (LREYN(IP), IP=1, NPOINT)
      WRITE(LU,*) (LUPAR(K) , K=1 , NUPAR)
C
      WRITE(LU,*) (LCLFIX(IP), IP=1, NPOINT)
      WRITE(LU,*) (LCMFIX(IP), IP=1, NPOINT)
      WRITE(LU,*) (LMAFIX(IP), IP=1, NPOINT)
      WRITE(LU,*) (LREFIX(IP), IP=1, NPOINT)
      WRITE(LU,*) (LUCFIX(K) , K=1 , NUCON)
C
      WRITE(LU,*) (LSLFIX(IS), IS=1, 2*NBLG)
      WRITE(LU,*) (LSRFIX(IS), IS=1, 2*NBLG)
      WRITE(LU,*) (LCVFIX(N), N=1, NBLG)
      WRITE(LU,*) (LALFIX(N), N=1, NBLG)
      WRITE(LU,*) (LARFIX(N), N=1, NBLG)
      WRITE(LU,*) (LABFIX(N), N=1, NBLG)
      WRITE(LU,*) (LSGFIX(N), N=1, NBLG)
      WRITE(LU,*) (LEIFIX(N), N=1, NBLG)
      WRITE(LU,*) (NTHFIX(N), N=1, NBLG)
      DO 10 N=1, NBLG
        WRITE(LU,*) (LTHFIX(K,N), K=0, NTHFIX(N))
 10   CONTINUE
C
      DO 11 J=1, NHKFIX
        WRITE(LU,*) LHKFIX(J),IPHFIX(J),ISHFIX(J),XHKFIX(J),HKSPEC(J)
 11   CONTINUE
C
      DO 14 IP=1, NPOINT
        WRITE(LU,*) CLSPEC(IP), CMSPEC(IP), WP(IP)
 14   CONTINUE
C
      DO 15 N=1, NBLG
        WRITE(LU,*) CVSPEC(N), ALSPEC(N), ARSPEC(N)
        WRITE(LU,*) ABSPEC(N), SGSPEC(N), EISPEC(N)
        WRITE(LU,*) (THSPEC(K,N), K=0, NTHFIX(N))
 15   CONTINUE
C
      DO 17 N=1, NBLG
        WRITE(LU,*) (XTHFIX(K,N), K=0, NTHFIX(N))
 17   CONTINUE
C
      DO 20 N=1, NBLG
        WRITE(LU,*) TBSKIN(N), XSTRF(N), XSTRB(N)
 20   CONTINUE
C
      DO 25 N=1, NBLG
        IS1 = 2*N-1
        IS2 = 2*N
        WRITE(LU,*) SBLFIX(IS1), SBLFIX(IS2), 
     &              SBRFIX(IS1), SBRFIX(IS2)
 25   CONTINUE
C
C
      WRITE(LU,*) NMODMX, NPOSMX, NUPAR
C
      DO 31 K=1, NMODMX
        WRITE(LU,*) 1.0/GSCMOD(K)**2
 31   CONTINUE
C
      DO 32 K=1, NPOSMX
        WRITE(LU,*) 1.0/GSCPOS(K)**2
 32   CONTINUE
C
      DO 40 K=1, NUPAR
        WRITE(LU,*) 1.0/GSCUP(K)**2
 40   CONTINUE
C
      WRITE(LU,*) 1.0/GSCAL**2
      WRITE(LU,*) 1.0/GSCMA**2
      WRITE(LU,*) 1.0/GSCLR**2
C
      CLOSE(LU)
C
      LEN1 = INDEX(FNAME,' ') - 1
      WRITE(*,5000) FNAME(1:LEN1)
 5000 FORMAT(1X,' Current settings written to file ', A)
C
      LPRSET = .FALSE.
C
      RETURN
      END ! LPRWRT



      SUBROUTINE LPRGET
      INCLUDE 'LINDOP.INC'
C
C---- read settings from linpar.xxx file
      LU = 9
      FNAME = 'linpar.' // ARGP1
      LEN1 = INDEX(FNAME,' ') - 1
C
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=90)
C
      READ(LU,*,ERR=80) NPOLD, IPGOLG, NBLG, NHKFIX
      IF(NPOLD.NE.NPOINT) THEN
       WRITE(*,1000) 'points'
       GO TO 70
      ENDIF
C
      READ(LU,*,ERR=80) NUPOLD, NUCOLD
      IF(NUPOLD.NE.NUPAR) THEN
       WRITE(*,1000) 'user parameters'
      ENDIF
      IF(NUCOLD.NE.NUCON) THEN
       WRITE(*,1000) 'user constraints'
      ENDIF
C
C
      IPGSEN = IPGOLG
C
      READ(LU,*,ERR=80) (NTHFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) IPTARG,ISTARG,IVTARG, IXPLT
      READ(LU,*,ERR=80) LNKMOD, LNKPOS, L2SIDE, LTRNSF
      READ(LU,*,ERR=80) DELTRY, CONDMX
C
      DO 2 IP=1, NPOINT
        READ(LU,*,ERR=80) NMDOLD, NPSOLD, NBLOLD
        IF(NMDOLD.NE.NMOD(IP)) WRITE(*,1002) 'geometry modes', IP
        IF(NPSOLD.NE.NPOS(IP)) WRITE(*,1002) 'position modes', IP
        IF(NBLOLD.NE. NBL(IP)) WRITE(*,1002) 'elements'      , IP
        IF(NMDOLD.NE.NMOD(IP) .OR.
     &     NPSOLD.NE.NPOS(IP) .OR.
     &     NBLOLD.NE. NBL(IP)     ) GO TO 70
 2    CONTINUE
C
      DO 3 IP=1, NPOINT
        READ(LU,*,ERR=80) (LMOD(K,IP), K=1, NMOD(IP))
 3    CONTINUE
C
      DO 4 IP=1, NPOINT
        READ(LU,*,ERR=80) (LPOS(K,IP), K=1, NPOS(IP))
 4    CONTINUE
C
      READ(LU,*,ERR=80) (LALFA(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LMACH(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LREYN(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LUPAR(K) , K=1,  NUPOLD)
C
      READ(LU,*,ERR=80) (LCLFIX(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LCMFIX(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LMAFIX(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LREFIX(IP), IP=1, NPOINT)
      READ(LU,*,ERR=80) (LUCFIX(K) , K=1 , NUCOLD)
C
      READ(LU,*,ERR=80) (LSLFIX(IS), IS=1, 2*NBLG)
      READ(LU,*,ERR=80) (LSRFIX(IS), IS=1, 2*NBLG)
      READ(LU,*,ERR=80) (LCVFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (LALFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (LARFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (LABFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (LSGFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (LEIFIX(N), N=1, NBLG)
      READ(LU,*,ERR=80) (NTHFIX(N), N=1, NBLG)
      DO 10 N=1, NBLG
        READ(LU,*,ERR=80) (LTHFIX(K,N), K=0, NTHFIX(N))
 10   CONTINUE
C
      DO 11 J=1, NHKFIX
        READ(LU,*,ERR=80)
     &       LHKFIX(J), IPHFIX(J), ISHFIX(J), XHKFIX(J), HKSPEC(J)
 11   CONTINUE
C
      DO 12 IP=1, NPOINT
        READ(LU,*,ERR=80) CLSPEC(IP),CMSPEC(IP), WP(IP)
 12   CONTINUE
C
      DO 15 N=1, NBLG
        READ(LU,*,ERR=80) CVSPEC(N),ALSPEC(N),ARSPEC(N)
        READ(LU,*,ERR=80) ABSPEC(N),SGSPEC(N),EISPEC(N)
        READ(LU,*,ERR=80) (THSPEC(K,N), K=0, NTHFIX(N))
 15   CONTINUE
C
      DO 17 N=1, NBLG
        READ(LU,*,ERR=80) (XTHFIX(K,N), K=0, NTHFIX(N))
 17   CONTINUE
C
      DO 20 N=1, NBLG
        READ(LU,*,ERR=80) TBSKIN(N), XSTRF(N), XSTRB(N)
 20   CONTINUE
C
      DO 25 N=1, NBLG
        IS1 = 2*N-1
        IS2 = 2*N
        READ(LU,*,ERR=80) SBLFIX(IS1), SBLFIX(IS2),
     &                    SBRFIX(IS1), SBRFIX(IS2)
 25   CONTINUE
C
      WRITE(*,1200) FNAME(1:LEN1)
 1200 FORMAT(/1X,'Previous settings read from file ', A)
C
      READ(LU,*,ERR=85) NMOD1, NPOS1, NUPAR1
C
      DO 31 K=1, NMOD1
        READ(LU,*,ERR=85) GSCMOD(K)
        GSCMOD(K) = 1.0/SQRT(GSCMOD(K))
 31   CONTINUE
C
      DO 32 K=1, NPOS1
        READ(LU,*,ERR=85) GSCPOS(K)
        GSCPOS(K) = 1.0/SQRT(GSCPOS(K))
 32   CONTINUE
C
      DO 40 K=1, NUPAR1
        READ(LU,*,ERR=85) GSCUP(K)
        GSCUP(K) = 1.0/SQRT(GSCUP(K))
 40   CONTINUE
C
      READ(LU,*,ERR=85) GSCAL
      READ(LU,*,ERR=85) GSCMA
      READ(LU,*,ERR=85) GSCLR
      GSCAL = 1.0/SQRT(GSCAL)
      GSCMA = 1.0/SQRT(GSCMA)
      GSCLR = 1.0/SQRT(GSCLR)
C
      WRITE(*,1300) FNAME(1:LEN1)
 1300 FORMAT( 1X,'Previous  scales  read from file ', A)
C
      CLOSE(LU)
C
      LPRSET = .FALSE.
      RETURN
C
C
 70   WRITE(*,1010) FNAME(1:LEN1)
      CLOSE(LU)
      RETURN
 1000 FORMAT(1X,'*** Different number of ', A)
 1002 FORMAT(1X,'*** Different number of ', A, '  for point', I3)
 1010 FORMAT(1X,'*** Settings not read from file ', A)
C
C
 80   WRITE(*,1800) FNAME(1:LEN1)
 1800 FORMAT(/1X,'File ',A,' read error.  Check current settings.')
      CLOSE(LU)
      LPRSET = .TRUE.
      RETURN
C
 85   WRITE(*,1850) FNAME(1:LEN1)
 1850 FORMAT(/1X,'File ',A,' read error.  Check current scales.')
      CLOSE(LU)
      LPRSET = .TRUE.
      RETURN
C
 90   WRITE(*,1900) FNAME(1:LEN1)
 1900 FORMAT(/1X,'File ',A,' not found.  Default settings used.')
      LPRSET = .FALSE.
      RETURN
      END ! LPRGET



      SUBROUTINE INIGRM
      INCLUDE 'LINDOP.INC'
C
      IV = IVTARG
C
      IF(IPTARG.EQ.0) THEN
       IP1 = 1
       IP2 = NPOINT
      ELSE
       IP1 = IPTARG
       IP2 = IPTARG
      ENDIF
C
      DO 1 IP=IP1, IP2
C
        IF(ISTARG.EQ.0) THEN
         IS1 = 1
         IS2 = 2*NBL(IP)
        ELSE
         N = (ISTARG+1)/2
         IS1 = 2*N-1
         IS2 = 2*N
        ENDIF
C
        DO 10 IS=IS1, IS2
          N = (IS+1)/2
C
          DO 104 I=ILEB(N,IP), ITEB(N,IP)
C
            VSUM = (VAR_ALFA(I,IS,IP,IV)/GSCAL**2)**2
     &           + (VAR_MACH(I,IS,IP,IV)/GSCMA**2)**2
     &           + (VAR_REYN(I,IS,IP,IV)/GSCLR**2*REYN(IP))**2
C
            DO 1042 K=1, NMOD(IP)
              VSUM = VSUM + (VAR_MOD(I,IS,K,IP,IV)/GSCMOD(K)**2)**2
 1042       CONTINUE
C
            DO 1044 K=1, NPOS(IP)
              VSUM = VSUM + (VAR_POS(I,IS,K,IP,IV)/GSCPOS(K)**2)**2
 1044       CONTINUE
C
            GVARMS(I,IS,IP) = SQRT(VSUM)
C
 104      CONTINUE
C
          GVINT = 0.0
          DO 106 I=ILEB(N,IP), ITEB(N,IP)-1
            DS = ABS(SBI(I+1,IS,IP)-SBI(I,IS,IP))
            GVINT = GVINT + (GVARMS(I,IS,IP)+GVARMS(I+1,IS,IP))*DS
 106      CONTINUE
C
 10     CONTINUE
 1    CONTINUE
C
      DO 2 IP=1, NPOINT
        VSUML = (CL_ALFA(IP)/GSCAL**2)**2
     &        + (CL_MACH(IP)/GSCMA**2)**2
     &        + (CL_REYN(IP)/GSCLR**2*REYN(IP))**2
        VSUMD = (CD_ALFA(IP)/GSCAL**2)**2
     &        + (CD_MACH(IP)/GSCMA**2)**2
     &        + (CD_REYN(IP)/GSCLR**2*REYN(IP))**2
C
        DO 2042 K=1, NMOD(IP)
          VSUML = VSUML + (CL_MOD(K,IP)/GSCMOD(K)**2)**2
          VSUMD = VSUMD + (CD_MOD(K,IP)/GSCMOD(K)**2)**2
 2042   CONTINUE
C
        DO 2044 K=1, NPOS(IP)
          VSUML = VSUML + (CL_POS(K,IP)/GSCPOS(K)**2)**2
          VSUMD = VSUMD + (CD_POS(K,IP)/GSCPOS(K)**2)**2
 2044   CONTINUE
C
        GCLRMS(IP) = SQRT(VSUML)
        GCDRMS(IP) = SQRT(VSUMD)
C
 2    CONTINUE
C
      RETURN
      END ! INIGRM



      SUBROUTINE HISWRT
      INCLUDE 'LINDOP.INC'
C
      IH = NHIS
      CALL PARSET
C
      FNAME = 'ophist.' // ARGP2
C
      LU = 9
ccc   OPEN(LU,FILE=FNAME,STATUS='UNKNOWN')   !%%%  RS/6000
      OPEN(LU,FILE=FNAME,STATUS='UNKNOWN',ACCESS='APPEND')
C
      WRITE(LU,*) '===================================='
      WRITE(LU,*) NSTEP(IH), IDTYPE(IH), IFTYPE, NPAR
      WRITE(LU,*) FUN(IH), DFCON(IH), FC_SOP(IH), OPSTEP(IH), VABS(IH)
C
      DO 10 K=1, NPAR
        WRITE(LU,*) PAR(K,IH), FU_PAR(K,IH), FC_PAR(K,IH), VPAR(K,IH),
     &              ' | ' // DPNAME(K)
 10   CONTINUE
      CLOSE(LU)
C
C---- write out Hessian
      IF(LHESUP) CALL QLQWRT
C
      LOPSET = .FALSE.
      RETURN
 1500 FORMAT(1X,6E13.5)
      END ! HISWRT



      SUBROUTINE HISGET
      INCLUDE 'LINDOP.INC'
C
 1000 FORMAT(A)
C
      NHIS = 1
      NSTEP(NHIS) = 1
C
      LU = 9
C
      FNAME = 'ophist.' // ARGP1
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=7)
C
      DO 1 IH=1, NHISX
        READ(LU,1000,END=2) LINE
        READ(LU,*,ERR=8) NSTEP(IH), IDTYPE(IH), IFTYPE, NPARH(IH)
        READ(LU,*,ERR=8) FUN(IH), DFCON(IH), FC_SOP(IH),
     &                   OPSTEP(IH), VABS(IH)
C
        DO 10 K=1, NPARH(IH)
          READ(LU,1000,ERR=8) LINE
          READ(LINE,*,ERR=8)
     &         PAR(K,IH),FU_PAR(K,IH),FC_PAR(K,IH),VPAR(K,IH)
          KNAME = INDEX(LINE,'|') + 2
          DPNAME(K) = '        '
          IF(KNAME .NE. 0) READ(LINE(KNAME:80),1000) DPNAME(K)
 10     CONTINUE
C
 1    CONTINUE
C
      STOP 'History arrays will overflow.  Increase NHISX.'
C
 2    NHIS = IH
      WRITE(*,1050) NHIS-1, FNAME(1:40)
 1050 FORMAT(/1X,I3,' optimization history points read from file ',A)
C
C---- descent-direction vector VPAR has been defined
      LOPDIR = .TRUE.
C
C---- clear new optimization step size so it will be set/initialized
      OPSTEP(NHIS) = 0.0
C
C---- increment line-step counter
      NSTEP(NHIS) = NSTEP(NHIS-1) + 1
C
C---- type of descent direction method same as for previous step
      IDTYPE(NHIS) = IDTYPE(NHIS-1)
C
C---- assume no forced function change
      DFCON(NHIS) = 0.
C
C---- set new descent direction same as for previous step
      NPARH(NHIS) = NPARH(NHIS-1)
      DO 4 K=1, NPARH(NHIS)
        VPAR(K,NHIS) = VPAR(K,NHIS-1)
 4    CONTINUE
C
      NPAR = NPARH(NHIS)
      NHES = NPARH(NHIS)
C
      RETURN
C
 7    IBLANK = INDEX(FNAME,' ')
      WRITE(*,2090) FNAME(1:IBLANK-1)
 2090 FORMAT(/1X,'File ',A,' not found.  No optimization history.')
      RETURN
C
 8    WRITE(*,*) 'Read error.  Optimization history may be corrupted.'
      RETURN
      END ! HISGET



      SUBROUTINE VARSCL(IPOINT)
      INCLUDE 'LINDOP.INC'
C
C---- set Cp scaling required to get at least -2.0 as upper y-axis label
      CALL SGSCAL(1,-1.999,1.0,VARSF1,ANN,NANN1)
C
C---- set Hk scaling required to get at most 10.0 as upper y-axis label
      CALL SGSCAL(1, 9.999,0.0,VARSF2,ANN,NANN2)
C
      IP = IPOINT
C
      DO 10 IV=1, NVAR
C
        DO 105 IS=1, 2*NBL(IP)
          N = (IS+1)/2
C
          ILE = ILEB(N,IP)
          NPT = ITEB(N,IP) - ILEB(N,IP) + 1
C
          CALL SGSCAL(NPT,VAR(ILE,IS,IP,IV),VAROFF(IV),VARSF(IS,IP,IV),
     &                ANN,NANN(IS,IP,IV))
C
C-------- set upper bound on scaling for Cp
          IF(IV.EQ.1) THEN
            IF(ABS(VARSF(IS,IP,IV)) .GT. ABS(VARSF1)) THEN
              VARSF(IS,IP,IV) = VARSF1
              NANN(IS,IP,IV) = NANN1
            ENDIF
          ENDIF
C
C-------- set lower bound on scaling for Hk
          IF(IV.EQ.2) THEN
            IF(ABS(VARSF(IS,IP,IV)) .LT. ABS(VARSF2)) THEN
              VARSF(IS,IP,IV) = VARSF2
              NANN(IS,IP,IV) = NANN2
            ENDIF
          ENDIF
C
C-------- set upper bound on scaling for amplification variable (if all 0)
          IF(IV.EQ.4) THEN
            IF(VARSF(IS,IP,IV) .GT. 1.0) THEN
              VARSF(IS,IP,IV) = 1.0
              NANN(IS,IP,IV) = 5
            ENDIF
          ENDIF
C
 105    CONTINUE
C
 10   CONTINUE
C
      RETURN
      END ! VARSCL


      SUBROUTINE SHOPNT
      INCLUDE 'LINDOP.INC'
C
      IP = 1
      WRITE(*,1000) NAME(IP)
      WRITE(*,1010) 
      IF(NMODMX.GT.0) WRITE(*,1011) NMODMX
      IF(NPOSMX.GT.0) WRITE(*,1012) NPOSMX
      IF(KALFA(IP).NE.0) WRITE(*,1015)
      IF(KMACH(IP).NE.0) WRITE(*,1016)
      IF(KREYN(IP).NE.0) WRITE(*,1017)
      IF(NUPAR.GT.0)  WRITE(*,1019) NUPAR
C
      WRITE(*,2000)
      DO 10 IP=1, NPOINT
        WRITE(*,2010) IP,ALFA(IP)/DTOR,MACH(IP),REYN(IP)/1.0E6,
     &                CL(IP),CM(IP),CD(IP),CDW(IP),CDF(IP)
 10   CONTINUE
C
      RETURN
C......................................................................
 1000 FORMAT(/1X,A32)
 1010 FORMAT(/1X,'Available design parameters:')
 1011 FORMAT(5X,I2,' geometry modes')
 1012 FORMAT(5X,I2,' position modes')
 1015 FORMAT(7X,   ' alpha')
 1016 FORMAT(7X,   ' Mach number')
 1017 FORMAT(7X,   ' Reynolds number')
 1019 FORMAT(5X,I2,' user parameters')
 2000 FORMAT(/1X,2X,
     & '   alpha   Mach   Re/10^6',
     & '    CL       CM       CD      CDw      CDf'
     & /1X,2X,
     & '  ------  ------  -------',
     & '  ------   ------  -------  -------  -------')
CCC      -10.234  0.7354   1.234  
CCC       1.2345  -0.1234  0.01234  0.00234  0.00234
 2010 FORMAT(1X,I2,
     &    F8.3,   F8.4,    F8.3,
     &    F9.4,    F9.4,   F9.5,    F9.5,    F9.5)
      END ! SHOPNT



      SUBROUTINE CLRMOD(LALL)
      INCLUDE 'LINDOP.INC'
      LOGICAL LALL
C
      DO 1 IP=1, NPOINT
C
        DO 11 K=1, NMOD(IP)
          IF(LALL .OR. LMOD(K,IP)) THEN
           DMOD (K,IP) = 0.0
           DMODC(K,IP) = 0.0
          ENDIF
 11     CONTINUE
C
        DO 12 K=1, NPOS(IP)
          IF(LALL .OR. LPOS(K,IP)) THEN
           DPOS (K,IP) = 0.0
           DPOSC(K,IP) = 0.0
          ENDIF
 12     CONTINUE
C
 1    CONTINUE
C
      LDSET = .FALSE.
C
      RETURN
      END


      SUBROUTINE CLRAMR(LALL,IPOINT)
      INCLUDE 'LINDOP.INC'
      LOGICAL LALL
C
      IF(IPOINT .EQ. 0) THEN
C
       DO 1 IP=1, NPOINT
         IF(LALL .OR. LALFA(IP)) THEN
          DALFA (IP) = 0.0
          DALFAC(IP) = 0.0
         ENDIF
         IF(LALL .OR. LMACH(IP)) THEN
          DMACH (IP) = 0.0
          DMACHC(IP) = 0.0
         ENDIF
         IF(LALL .OR. LREYN(IP)) THEN
          DLNRE (IP) = 0.0
          DLNREC(IP) = 0.0
         ENDIF
 1     CONTINUE
C
      ELSE
C
       IP = IPOINT
       IF(LALL .OR. LALFA(IP)) THEN
        DALFA (IP) = 0.0
        DALFAC(IP) = 0.0
       ENDIF
       IF(LALL .OR. LMACH(IP)) THEN
        DMACH (IP) = 0.0
        DMACHC(IP) = 0.0
       ENDIF
       IF(LALL .OR. LREYN(IP)) THEN
        DLNRE (IP) = 0.0
        DLNREC(IP) = 0.0
       ENDIF
C
      ENDIF
C
      RETURN
      END


      SUBROUTINE CLRUSR(LALL)
      INCLUDE 'LINDOP.INC'
      LOGICAL LALL
C
      DO 10 K=1, NUPAR
        IF(LALL .OR. LUPAR(K)) THEN
         DUPAR (K) = 0.0
         DUPARC(K) = 0.0
        ENDIF
 10   CONTINUE
C
      RETURN
      END



      SUBROUTINE CLRCON
      INCLUDE 'LINDOP.INC'
C
C---- clears all constraint toggles and specified quantities
C
      IP = IPGSEN
      DO 10 N=1, NBL(IP)
        IS1 = 2*N-1
        IS2 = 2*N
        LSLFIX(IS1) = .FALSE.
        LSLFIX(IS2) = .FALSE.
        LSRFIX(IS1) = .FALSE.
        LSRFIX(IS2) = .FALSE.
        LCVFIX(N) = .FALSE.
        LALFIX(N) = .FALSE.
        LARFIX(N) = .FALSE.
        LABFIX(N) = .FALSE.
        LSGFIX(N) = .FALSE.
        CVSPEC(N) = 0.0
        ALSPEC(N) = 0.0
        ARSPEC(N) = 0.0
        ABSPEC(N) = 0.0
        SGSPEC(N) = 0.0
        EISPEC(N) = 0.0
        DO 105 K=0, NTHX
          THSPEC(K,N) = 0.0
          LTHFIX(K,N) = .FALSE.
 105    CONTINUE
 10   CONTINUE
C
      DO 20 IP=1, NPOINT
        LCLFIX(IP) = .FALSE.
        LCMFIX(IP) = .FALSE.
        CLSPEC(IP) = CL(IP)
        CMSPEC(IP) = CM(IP)
 20   CONTINUE
C
      DO 30 K=1, NUCON
        LUCFIX(K) = .FALSE.
 30   CONTINUE
C
      DO 40 J=1, NHKX
        LHKFIX(J) = .FALSE.
        HKSPEC(J) = 3.0
        XHKFIX(J) = 1.0
        IPHFIX(J) = 1
        ISHFIX(J) = 1
 40   CONTINUE
C
      LMAFIX1 = .FALSE.
      LREFIX1 = .FALSE.
      DO 50 IP=1, NPOINT
        LMAFIX(IP) = LDEPMA(IP)
        LREFIX(IP) = LDEPRE(IP)
        IF(MACH(IP) .EQ. 0.0) LMAFIX(IP) = .FALSE.
        IF(REYN(IP) .EQ. 0.0) LREFIX(IP) = .FALSE.
C
        LMAFIX1 = LMAFIX1 .OR. LMAFIX(IP) .OR. KMACH(IP).NE.0
        LREFIX1 = LREFIX1 .OR. LREFIX(IP) .OR. KREYN(IP).NE.0
C
        MSQCL(IP) = MACH(IP) * SQRT( ABS(CL(IP)) )
        RSQCL(IP) = REYN(IP) * SQRT( ABS(CL(IP)) )
 50   CONTINUE
C
      RETURN
      END ! CLRCON



      SUBROUTINE SHOSEN
      INCLUDE 'LINDOP.INC'
C
 899  IP = IPGSEN
      WRITE(*,1000) NMOD(IP), NPOS(IP)
 1000 FORMAT(/'   G eometry mode', I5, ' (max)'
     &       /'   P osition mode', I5, ' (max)'
     &       /'   A lpha        ' 
     &       /'   M ach         ' 
     &       /'   R eynolds no. '
     &       /'   # point   summary'
     &       /' -n #  element summary for point "#"')
C
 900  WRITE(*,*)
      WRITE(*,*) 'Enter  parameter, mode#  (G,P,A,M,R  k): '
      READ (*,1005) LINE
 1005 FORMAT(A)
C
      IF(LINE(1:1).EQ.' ') RETURN
C
      IF(INDEX('1234567890',LINE(1:1)).NE.0) THEN
        READ(LINE,*,ERR=899) IP1
        IF(IP1.EQ.0) THEN
          DO 5 IP=1, NPOINT
            CALL PNTSEN(IP)
            WRITE(*,*) 'Hit <cr>'
            READ (*,1005) DUMMY
 5        CONTINUE
        ELSE
          IP = IP1
          IF(IP.LT.0 .OR. IP.GT.NPOINT) GO TO 900
          CALL PNTSEN(IP)
        ENDIF
        GO TO 900
      ENDIF
C
      IF(INDEX('-',LINE(1:1)).NE.0) THEN
        READ(LINE,*,ERR=899) N1, IP1
        IP = IP1
        IF(IP.LT.0 .OR. IP.GT.NPOINT) GO TO 900
C
        IF(N1.EQ.0) THEN
          DO 7 N=1, NBL(IP)
            CALL GEOSEN(N,IP)
            WRITE(*,*) 'Hit <cr>'
            READ (*,1005) DUMMY
 7        CONTINUE
        ELSE
          N = IABS(N1)
          IF(N.GT.NBL(IP)) GO TO 900
          CALL GEOSEN(N,IP)
        ENDIF
        GO TO 900
      ENDIF
C
C
      K1 = MAX( INDEX(LINE,'S'), INDEX(LINE,'s')) + 1
C
      LINE(71:80) = 'GPAMRgpamr'
C
      DO 990 IPASS=1, 40
C
      KG = MIN(INDEX(LINE(K1:80),'G'),INDEX(LINE(K1:80),'g')) + K1 - 1
      KP = MIN(INDEX(LINE(K1:80),'P'),INDEX(LINE(K1:80),'p')) + K1 - 1
      KA = MIN(INDEX(LINE(K1:80),'A'),INDEX(LINE(K1:80),'a')) + K1 - 1
      KM = MIN(INDEX(LINE(K1:80),'M'),INDEX(LINE(K1:80),'m')) + K1 - 1
      KR = MIN(INDEX(LINE(K1:80),'R'),INDEX(LINE(K1:80),'r')) + K1 - 1
C
      KMIN = MIN(KG,KP,KA,KM,KR)
      IF(KMIN.GT.70) GO TO 899
C
      IF(KA.EQ.KMIN) THEN
       WRITE(*,5010) 'alpha'
       DO 11 IP=1, NPOINT
         WRITE(*,5050) IP,
     &     CL_ALFA(IP)*DTOR,  CM_ALFA(IP)*DTOR,  CD_ALFA(IP)*DTOR,
     &    CDW_ALFA(IP)*DTOR, CDV_ALFA(IP)*DTOR, CDF_ALFA(IP)*DTOR
 11    CONTINUE
      ENDIF
C
      IF(KM.EQ.KMIN) THEN
       WRITE(*,5010) 'Mach '
       DO 12 IP=1, NPOINT
         WRITE(*,5050)  IP,
     &     CL_MACH(IP),  CM_MACH(IP),  CD_MACH(IP),
     &    CDW_MACH(IP), CDV_MACH(IP), CDF_MACH(IP)
 12    CONTINUE
      ENDIF
C
      IF(KR.EQ.KMIN) THEN
       WRITE(*,5010) 'ln Re'
       DO 13 IP=1, NPOINT
         REYN_LR = REYN(IP)
         WRITE(*,5050) IP,
     &   CL_REYN(IP)*REYN_LR, CM_REYN(IP)*REYN_LR, CD_REYN(IP)*REYN_LR,
     &  CDW_REYN(IP)*REYN_LR,CDV_REYN(IP)*REYN_LR,CDF_REYN(IP)*REYN_LR
 13    CONTINUE
      ENDIF
C
      IF(KG.EQ.KMIN) THEN
       READ(LINE(KG+1:80),*,ERR=899) K
       IF(K.GE.1 .AND. K.LE.NMODMX) THEN
         WRITE(*,5020) 'Mod', K
         DO 14 IP=1, NPOINT
           WRITE(*,5050) IP,
     &      CL_MOD(K,IP),  CM_MOD(K,IP),  CD_MOD(K,IP),
     &     CDW_MOD(K,IP), CDV_MOD(K,IP), CDF_MOD(K,IP)
 14      CONTINUE
       ENDIF
      ENDIF
C
      IF(KP.EQ.KMIN) THEN
       READ(LINE(KP+1:80),*,ERR=899) K
       WRITE(*,5020) 'Pos', K
       IF(K.GE.1 .AND. K.LE.NPOSMX) THEN
         DO 15 IP=1, NPOINT
           WRITE(*,5050) IP,
     &      CL_POS(K,IP),  CM_POS(K,IP),  CD_POS(K,IP),
     &     CDW_POS(K,IP), CDV_POS(K,IP), CDF_POS(K,IP)
 15      CONTINUE
       ENDIF
      ENDIF
C
      K1 = KMIN + 1
C
 990  CONTINUE
C
      GO TO 900
C
C........................................................
 5010 FORMAT(/1X,
     & 'point   d CL      d CM      d CD     d CDw     d CDv     d CDf',
     &   ' / d ',A5)
 5020 FORMAT(/1X,
     & 'point   d CL      d CM      d CD     d CDw     d CDv     d CDf',
     &   ' / d ',A3,I2)
C         1    1.2344    1.2344   1.23445
 5050 FORMAT(1X,I3, F10.4, F10.4, F10.5, F10.5, F10.5, F10.5)
      END ! SHOSEN


      SUBROUTINE PNTSEN(IPOINT)
      INCLUDE 'LINDOP.INC'
C
      IP = IPOINT
C
      WRITE(*,1000) IP, ALFA(IP)/DTOR, MACH(IP), REYN(IP)/1.0E6, 
     &              CL(IP), CM(IP), CD(IP)
      WRITE(*,1005)
C
      IF(KALFA(IP).NE.0) WRITE(*,1010) 'alpha',
     &   CL_ALFA(IP)*DTOR,  CM_ALFA(IP)*DTOR,  CD_ALFA(IP)*DTOR,
     &  CDW_ALFA(IP)*DTOR, CDV_ALFA(IP)*DTOR, CDF_ALFA(IP)*DTOR
C
      IF(KMACH(IP).NE.0) WRITE(*,1010) 'Mach ',
     &   CL_MACH(IP),  CM_MACH(IP),  CD_MACH(IP),
     &  CDW_MACH(IP), CDV_MACH(IP), CDF_MACH(IP)
C
      REYN_LR = REYN(IP)
      IF(KREYN(IP).NE.0) WRITE(*,1010) 'ln Re',
     &   CL_REYN(IP)*REYN_LR, CM_REYN(IP)*REYN_LR, CD_REYN(IP)*REYN_LR,
     &  CDW_REYN(IP)*REYN_LR,CDV_REYN(IP)*REYN_LR,CDF_REYN(IP)*REYN_LR
C
      DO 50 K=1, NMOD(IP)
        WRITE(*,1020) 'MOD', K,
     &   CL_MOD(K,IP),  CM_MOD(K,IP),  CD_MOD(K,IP),
     &  CDW_MOD(K,IP), CDV_MOD(K,IP), CDF_MOD(K,IP)
 50   CONTINUE
C
      DO 60 K=1, NPOS(IP)
        WRITE(*,1020) 'POS', K,
     &   CL_POS(K,IP),  CM_POS(K,IP),  CD_POS(K,IP),
     &  CDW_POS(K,IP), CDV_POS(K,IP), CDF_POS(K,IP)
 60   CONTINUE
C
      RETURN
C.................................................................
 1000 FORMAT(/1X,60('-')
     & /' Point',I3,':'
     & /'  alpha =',F9.5,'      Ma =',F9.5,'    Re =',F8.4,'e6'
     & /'     CL =',F9.5,'      CM =',F9.5,'    CD =',F9.6)
 1005 FORMAT(/1X,8X,
     & '     d CL      d CM      d CD     d CDw     d CDv     d CDf')
 1010 FORMAT(1X,'/d ',A5,   F10.4, F10.4, F10.5, F10.5, F10.5, F10.5)
 1020 FORMAT(1X,'/d ',A3,I2,F10.4, F10.4, F10.5, F10.5, F10.5, F10.5)
      END ! PNTSEN



      SUBROUTINE GEOSEN(NEL,IPOINT)
      INCLUDE 'LINDOP.INC'
C
      N = NEL
      IP = IPOINT
C
      IS1 = 2*N - 1
      IS2 = 2*N
C
      ILE = ILEB(N,IP)
      ITE = ITEB(N,IP)
C
      PERIM = SBI(ITE,IS1,IP) - SBI(ILE,IS1,IP)
     &      + SBI(ITE,IS2,IP) - SBI(ILE,IS2,IP)
      WRITE(*,1000) N, IP,
     &          ANGLL(    N,IP),
     &          ANGLR(    N,IP),
     &          AREAB(    N,IP),
     &          PERIM,
     &     (KTH,THIKB(KTH,N,IP), XTHFIX(KTH,N), KTH=1,NTHFIX(N))
C
      WRITE(*,1005) (KTH, KTH=1, NTHFIX(N))
C
      DO 50 K=1, NMOD(IP)
        PER_MOD = SBI_MOD(ITE,IS1,K,IP) - SBI_MOD(ILE,IS1,K,IP)
     &          + SBI_MOD(ITE,IS2,K,IP) - SBI_MOD(ILE,IS2,K,IP)
        WRITE(*,1020) 'MOD', K,
     &    AGL_MOD(K,N,IP),
     &    AGR_MOD(K,N,IP),
     &    ARB_MOD(K,N,IP),
     &    PER_MOD        ,
     &   (THB_MOD(K,KTH,N,IP), KTH=1,NTHFIX(N))
 50   CONTINUE
C
      write(40,2005) '# Point  :', IP
      write(40,2005) '# Element:', N
      write(40,2005) '#     x         y         s'
c
      do i = ite, ile, -1
        write(40,2010) xbi(i,is1,ip), ybi(i,is1,ip), sbi(i,is1,ip)
      enddo
      do i = ile, ite
        write(40,2010) xbi(i,is2,ip), ybi(i,is2,ip), sbi(i,is2,ip)
      enddo
 2005 format(a, i4)
 2010 format(1x,3f10.6)
c
      do k = 1, nmod(ip)
      write(40+k,2005) '# Point  :', IP
      write(40+k,2005) '# Element:', N
      write(40+k,2005) '#    dx        dy        ds     / dMOD', k
      do i = ite, ile, -1
        write(40+k,2010) xbi_mod(i,is1,k,ip), 
     &                   ybi_mod(i,is1,k,ip), 
     &                   sbi_mod(i,is1,k,ip)
      enddo
      do i = ile, ite
        write(40+k,2010) xbi_mod(i,is2,k,ip), 
     &                   ybi_mod(i,is2,k,ip), 
     &                   sbi_mod(i,is2,k,ip)
      enddo
      enddo


      RETURN
C.................................................................
 1000 FORMAT(/1X,60('-')
     &  /' Element',I3,',   Point',I3,':'
     &  /'  Langle =',F9.3,
     &  /'  Rangle =',F9.3,
     &  /'    area =',F9.5,
     &  /'   perim =',F9.5,
     & /('  Thick',I1,' =',F9.5,'   at x =',F9.5))
 1005 FORMAT(/1X,8X,
     &  '     d Langl    d Rangl    d area     d perim',
     & ('   d Thick',I1))
 1020 FORMAT(1X,'/d ',A3,I2,
     &        F11.3, F11.3, F11.4, F11.4, F11.4, F11.4, 8F11.4)
      END ! GEOSEN



      SUBROUTINE XYBLIM
      INCLUDE 'LINDOP.INC'
C
      IP = 1
C
      IS = 1
      N = (IS+1)/2
C
      DO 1 N=1, NBL(IP)
        IS1 = 2*N-1
        IS2 = 2*N
C
        IS = IS1
        I = ILEB(N,IP)
        XELMIN(N) = XBI(I,IS,IP)
        XELMAX(N) = XBI(I,IS,IP)
        YELMIN(N) = YBI(I,IS,IP)
        YELMAX(N) = YBI(I,IS,IP)
C
        DO 10 IS=IS1, IS2
          DO 104 I=ILEB(N,IP), ITEB(N,IP)
            XELMIN(N) = MIN( XELMIN(N) , XBI(I,IS,IP) )
            XELMAX(N) = MAX( XELMAX(N) , XBI(I,IS,IP) )
            YELMIN(N) = MIN( YELMIN(N) , YBI(I,IS,IP) )
            YELMAX(N) = MAX( YELMAX(N) , YBI(I,IS,IP) )
 104      CONTINUE
 10     CONTINUE
 1    CONTINUE
C
      N = 1
      XBMIN = XELMIN(N)
      XBMAX = XELMAX(N)
      YBMIN = YELMIN(N)
      YBMAX = YELMAX(N)
      DO 2 N=2, NBL(IP)
        XBMIN = MIN( XBMIN , XELMIN(N) )
        XBMAX = MAX( XBMAX , XELMAX(N) )
        YBMIN = MIN( YBMIN , YELMIN(N) )
        YBMAX = MAX( YBMAX , YELMAX(N) )
 2    CONTINUE
C
      RETURN
      END


      SUBROUTINE XYCENT
      INCLUDE 'LINDOP.INC'
C
C---- calculate element centroid coordinates
C
      DO 1 IP=1, NPOINT
        DO 10 N=1, NBL(IP)
C
          IS1 = 2*N-1
          IS2 = 2*N
C
          AREA = 0.0
          XSUM = 0.0
          YSUM = 0.0
          DO 104 I=ILEB(N,IP)+1, ITEB(N,IP)
            RX  = XBI(I,IS1,IP) + XBI(I-1,IS1,IP)
     &          + XBI(I,IS2,IP) + XBI(I-1,IS2,IP)
            RY  = YBI(I,IS1,IP) + YBI(I-1,IS1,IP)
     &          + YBI(I,IS2,IP) + YBI(I-1,IS2,IP)
            DXA = XBI(I,IS1,IP) - XBI(I-1,IS1,IP)
     &          + XBI(I,IS2,IP) - XBI(I-1,IS2,IP)
            DYA = YBI(I,IS1,IP) - YBI(I-1,IS1,IP)
     &          + YBI(I,IS2,IP) - YBI(I-1,IS2,IP)
            DXB = XBI(I,IS1,IP) + XBI(I-1,IS1,IP)
     &          - XBI(I,IS2,IP) - XBI(I-1,IS2,IP)
            DYB = YBI(I,IS1,IP) + YBI(I-1,IS1,IP)
     &          - YBI(I,IS2,IP) - YBI(I-1,IS2,IP)
            DA = 0.25*(DXA*DYB - DYA*DXB)
            AREA = AREA + DA
            XSUM = XSUM + DA * 0.25*RX
            YSUM = YSUM + DA * 0.25*RY
 104      CONTINUE
C
          XCENT(N,IP) = XSUM/AREA
          YCENT(N,IP) = YSUM/AREA
C
 10     CONTINUE
 1    CONTINUE
C
      RETURN
      END ! XYCENT


